/*
 * Decompiled with CFR 0.152.
 */
package viewer.common;

import java.io.File;
import javax.swing.filechooser.FileFilter;

public class LogRefuseDirFilter
extends FileFilter {
    String[] extns;
    StringBuffer description;

    public LogRefuseDirFilter(String[] in_extns) {
        this.extns = new String[in_extns.length];
        this.description = new StringBuffer();
        for (int idx = 0; idx < this.extns.length; ++idx) {
            this.extns[idx] = new String(in_extns[idx]).trim();
            this.description.append(" *." + this.extns[idx]);
        }
    }

    public boolean accept(File file) {
        if (file.isDirectory()) {
            return false;
        }
        String extension = LogRefuseDirFilter.getFileExtension(file);
        if (extension != null) {
            for (int idx = 0; idx < this.extns.length; ++idx) {
                if (!extension.equals(this.extns[idx])) continue;
                return true;
            }
        }
        return false;
    }

    public String getDescription() {
        return this.description.toString();
    }

    private static String getFileExtension(File file) {
        String name = file.getName();
        int idx = name.lastIndexOf(46);
        String ext = null;
        if (idx > 0 && idx < name.length() - 1) {
            ext = name.substring(idx + 1).toLowerCase();
        }
        return ext;
    }
}

