/*
 * Decompiled with CFR 0.152.
 */
package logformat.slog2.input;

import base.drawable.Drawable;
import base.drawable.TimeBoundingBox;
import base.io.MixedDataInput;
import base.io.MixedDataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import logformat.slog2.BufForDrawables;
import logformat.slog2.BufForObjects;
import logformat.slog2.BufForShadows;
import logformat.slog2.input.IteratorOfGroupObjects;

public class TreeNode
extends BufForDrawables {
    private BufForShadows[] shadowbufs = null;

    public TreeNode() {
        super(false);
    }

    public BufForObjects[] getChildStubs() {
        return this.shadowbufs;
    }

    public int getNodeByteSize() {
        int total_bytesize = super.getByteSize() + 4;
        if (this.shadowbufs != null) {
            for (int idx = 0; idx < this.shadowbufs.length; ++idx) {
                total_bytesize += this.shadowbufs[idx].getByteSize();
            }
        }
        return total_bytesize;
    }

    public Iterator iteratorOfDrawables(TimeBoundingBox tframe, Drawable.Order dobj_order, boolean isComposite, boolean isNestable) {
        boolean isForeItr = dobj_order.isIncreasingTimeOrdered();
        if (isForeItr) {
            if (isNestable) {
                return super.nestableForeIterator(tframe, isComposite);
            }
            return super.nestlessForeIterator(tframe);
        }
        if (isNestable) {
            return super.nestableBackIterator(tframe, isComposite);
        }
        return super.nestlessBackIterator(tframe);
    }

    public Iterator iteratorOfShadows(TimeBoundingBox tframe, Drawable.Order dobj_order, boolean isNestable) {
        boolean isForeItr = dobj_order.isIncreasingTimeOrdered();
        if (isForeItr) {
            if (isNestable) {
                return new ForeItrOfNestableShadows(tframe);
            }
            return new ForeItrOfNestlessShadows(tframe);
        }
        if (isNestable) {
            return new BackItrOfNestableShadows(tframe);
        }
        return new BackItrOfNestlessShadows(tframe);
    }

    public void writeObject(MixedDataOutput outs) throws IOException {
        System.err.println("ERROR! : slog2.input.TreeNode.writeObject() should NOT be called!");
    }

    public TreeNode(MixedDataInput ins, Map categorymap) throws IOException {
        this();
        this.readObject(ins, categorymap);
    }

    public void readObject(MixedDataInput ins, Map categorymap) throws IOException {
        super.readObject(ins, categorymap);
        int Nbufs = ins.readInt();
        if (Nbufs > 0) {
            this.shadowbufs = new BufForShadows[Nbufs];
            for (int idx = 0; idx < this.shadowbufs.length; ++idx) {
                this.shadowbufs[idx] = new BufForShadows(ins, categorymap);
            }
        } else {
            this.shadowbufs = null;
        }
    }

    public void reorderDrawables(Drawable.Order dobj_order) {
        super.reorderDrawables(dobj_order);
        if (this.shadowbufs != null) {
            for (int idx = 0; idx < this.shadowbufs.length; ++idx) {
                this.shadowbufs[idx].reorderDrawables(dobj_order);
            }
        }
    }

    public String toString() {
        StringBuffer rep = new StringBuffer("\t*** Start of TreeNode ***\n");
        rep.append(super.toString() + "\n");
        if (this.shadowbufs != null) {
            for (int idx = 0; idx < this.shadowbufs.length; ++idx) {
                rep.append("\t BufForShadows No. " + idx + "\n");
                rep.append(this.shadowbufs[idx]);
            }
        }
        rep.append("\t*** End of TreeNode ***\n");
        return rep.toString();
    }

    private class ForeItrOfNestlessShadows
    extends IteratorOfGroupObjects {
        private int shadowbufs_length;
        private int next_buf_idx;

        public ForeItrOfNestlessShadows(TimeBoundingBox tframe) {
            super(tframe);
            this.shadowbufs_length = TreeNode.this.shadowbufs != null ? TreeNode.this.shadowbufs.length : 0;
            this.next_buf_idx = 0;
            super.setObjGrpItr(this.nextObjGrpItr(tframe));
        }

        protected Iterator nextObjGrpItr(TimeBoundingBox tframe) {
            if (TreeNode.this.shadowbufs != null) {
                while (this.next_buf_idx < this.shadowbufs_length) {
                    BufForShadows shadowbuf = TreeNode.this.shadowbufs[this.next_buf_idx];
                    ++this.next_buf_idx;
                    if (!shadowbuf.overlaps(tframe)) continue;
                    return shadowbuf.nestlessForeIterator(tframe);
                }
            }
            return null;
        }
    }

    private class ForeItrOfNestableShadows
    extends IteratorOfGroupObjects {
        private static final boolean IS_COMPOSITE = false;
        private int shadowbufs_length;
        private int next_buf_idx;

        public ForeItrOfNestableShadows(TimeBoundingBox tframe) {
            super(tframe);
            this.shadowbufs_length = TreeNode.this.shadowbufs != null ? TreeNode.this.shadowbufs.length : 0;
            this.next_buf_idx = 0;
            super.setObjGrpItr(this.nextObjGrpItr(tframe));
        }

        protected Iterator nextObjGrpItr(TimeBoundingBox tframe) {
            if (TreeNode.this.shadowbufs != null) {
                while (this.next_buf_idx < this.shadowbufs_length) {
                    BufForShadows shadowbuf = TreeNode.this.shadowbufs[this.next_buf_idx];
                    ++this.next_buf_idx;
                    if (!shadowbuf.overlaps(tframe)) continue;
                    return shadowbuf.nestableForeIterator(tframe, false);
                }
            }
            return null;
        }
    }

    private class BackItrOfNestlessShadows
    extends IteratorOfGroupObjects {
        private int shadowbufs_length;
        private int next_buf_idx;

        public BackItrOfNestlessShadows(TimeBoundingBox tframe) {
            super(tframe);
            this.shadowbufs_length = TreeNode.this.shadowbufs != null ? TreeNode.this.shadowbufs.length : 0;
            this.next_buf_idx = this.shadowbufs_length - 1;
            super.setObjGrpItr(this.nextObjGrpItr(tframe));
        }

        protected Iterator nextObjGrpItr(TimeBoundingBox tframe) {
            if (TreeNode.this.shadowbufs != null) {
                while (this.next_buf_idx >= 0) {
                    BufForShadows shadowbuf = TreeNode.this.shadowbufs[this.next_buf_idx];
                    --this.next_buf_idx;
                    if (!shadowbuf.overlaps(tframe)) continue;
                    return shadowbuf.nestlessBackIterator(tframe);
                }
            }
            return null;
        }
    }

    private class BackItrOfNestableShadows
    extends IteratorOfGroupObjects {
        private static final boolean IS_COMPOSITE = false;
        private int shadowbufs_length;
        private int next_buf_idx;

        public BackItrOfNestableShadows(TimeBoundingBox tframe) {
            super(tframe);
            this.shadowbufs_length = TreeNode.this.shadowbufs != null ? TreeNode.this.shadowbufs.length : 0;
            this.next_buf_idx = this.shadowbufs_length - 1;
            super.setObjGrpItr(this.nextObjGrpItr(tframe));
        }

        protected Iterator nextObjGrpItr(TimeBoundingBox tframe) {
            if (TreeNode.this.shadowbufs != null) {
                while (this.next_buf_idx >= 0) {
                    BufForShadows shadowbuf = TreeNode.this.shadowbufs[this.next_buf_idx];
                    --this.next_buf_idx;
                    if (!shadowbuf.overlaps(tframe)) continue;
                    return shadowbuf.nestableBackIterator(tframe, false);
                }
            }
            return null;
        }
    }
}

