/*
 * Decompiled with CFR 0.152.
 */
package logformat.slog2;

import base.drawable.Method;
import base.drawable.YCoordMap;
import base.io.MixedDataIO;
import base.io.MixedDataInput;
import base.io.MixedDataInputStream;
import base.io.MixedDataOutput;
import base.io.MixedDataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import logformat.slog2.Permutation;

public class LineIDMap
extends TreeMap
implements MixedDataIO {
    private static final long serialVersionUID = 500L;
    private int num_treenodes;
    private String title_label;
    private String[] column_labels;
    private Method[] methods;

    public LineIDMap() {
        this.num_treenodes = 0;
        this.title_label = null;
        this.column_labels = null;
        this.methods = null;
    }

    public LineIDMap(int Ntreenodes) {
        this.num_treenodes = Ntreenodes;
        this.title_label = null;
        this.column_labels = null;
        this.methods = null;
    }

    public LineIDMap(YCoordMap y_map) {
        int icol;
        this.num_treenodes = y_map.getNumOfColumns() - 1;
        this.title_label = y_map.getTitleName();
        this.column_labels = y_map.getColumnNames();
        this.methods = y_map.getMethods();
        if (this.column_labels.length != this.num_treenodes) {
            System.err.print("LineIDMap: Warning!\nThe input column_labels[] are ");
            for (icol = 0; icol < this.column_labels.length; ++icol) {
                System.err.print(this.column_labels[icol] + " ");
            }
            System.err.println();
            System.err.println("\tThe number of column labels is expected to be " + this.num_treenodes + ".");
        }
        int num_entries = y_map.getNumOfRows();
        int[] map_elems = y_map.getMapElems();
        if (map_elems.length != num_entries * (this.num_treenodes + 1)) {
            System.err.println("Warning: The input YCoordMap contains " + map_elems.length + " elements.  " + "But the number is expected to be " + num_entries * (this.num_treenodes + 1) + ".");
        }
        int idx = 0;
        for (int irow = 0; irow < num_entries; ++irow) {
            Integer key = new Integer(map_elems[idx++]);
            Integer[] value = new Integer[this.num_treenodes];
            for (icol = 0; icol < this.num_treenodes; ++icol) {
                value[icol] = new Integer(map_elems[idx++]);
            }
            super.put(key, value);
        }
    }

    public YCoordMap toYCoordMap() {
        int[] method_indexes;
        int idx;
        int num_rows = super.size();
        int num_columns = this.num_treenodes + 1;
        String title_name = this.title_label;
        String[] column_names = this.column_labels;
        int[] map_elems = new int[num_rows * num_columns];
        int map_idx = 0;
        Iterator entries = super.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            Integer key = (Integer)entry.getKey();
            Integer[] value = (Integer[])entry.getValue();
            map_elems[map_idx++] = key;
            for (idx = 0; idx < value.length; ++idx) {
                map_elems[map_idx++] = value[idx];
            }
        }
        if (map_idx < map_elems.length) {
            throw new IllegalStateException("LineIDMap's TreeMap contains less int than the expected " + map_elems.length + ".");
        }
        if (this.methods != null && this.methods.length > 0) {
            method_indexes = new int[this.methods.length];
            for (idx = 0; idx < method_indexes.length; ++idx) {
                method_indexes[idx] = this.methods[idx].getMethodIndex();
            }
        } else {
            method_indexes = null;
        }
        return new YCoordMap(num_rows, num_columns, title_name, column_names, map_elems, method_indexes);
    }

    public Method[] getMethods() {
        return this.methods;
    }

    public void setTitle(String title_labelname) {
        this.title_label = title_labelname;
    }

    public String getTitle() {
        return this.title_label;
    }

    public void setColumnLabels(String[] col_labels) {
        if (col_labels.length != this.num_treenodes) {
            System.err.print("Warning: The input column_labels[] is ");
            for (int idx = 0; idx < col_labels.length; ++idx) {
                System.err.print(col_labels[idx] + " ");
            }
            System.err.println();
            System.err.println("The number of column labels is expected to be " + this.num_treenodes + ".");
        }
        this.column_labels = col_labels;
    }

    public String[] getColumnLabels() {
        return this.column_labels;
    }

    public void writeObject(MixedDataOutput outs) throws IOException {
        int idx;
        outs.writeString(this.title_label);
        outs.writeInt(this.num_treenodes);
        for (idx = 0; idx < this.num_treenodes; ++idx) {
            outs.writeString(this.column_labels[idx]);
        }
        outs.writeInt(super.size());
        Iterator entries = super.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            Integer key = (Integer)entry.getKey();
            Integer[] value = (Integer[])entry.getValue();
            outs.writeInt(key);
            for (idx = 0; idx < this.num_treenodes; ++idx) {
                outs.writeInt(value[idx]);
            }
        }
        if (this.methods != null && this.methods.length > 0) {
            outs.writeShort((short)this.methods.length);
            for (idx = 0; idx < this.methods.length; ++idx) {
                this.methods[idx].writeObject(outs);
            }
        } else {
            outs.writeShort(0);
        }
    }

    public LineIDMap(MixedDataInput ins) throws IOException {
        this();
        this.readObject(ins);
    }

    public void readObject(MixedDataInput ins) throws IOException {
        int idx;
        this.title_label = ins.readString();
        this.num_treenodes = ins.readInt();
        this.column_labels = new String[this.num_treenodes];
        for (idx = 0; idx < this.num_treenodes; ++idx) {
            this.column_labels[idx] = ins.readString();
        }
        int Nentries = ins.readInt();
        for (int ientry = 0; ientry < Nentries; ++ientry) {
            Integer key = new Integer(ins.readInt());
            Integer[] value = new Integer[this.num_treenodes];
            for (idx = 0; idx < this.num_treenodes; ++idx) {
                value[idx] = new Integer(ins.readInt());
            }
            super.put(key, value);
        }
        Nentries = ins.readShort();
        if (Nentries > 0) {
            this.methods = new Method[Nentries];
            for (idx = 0; idx < Nentries; ++idx) {
                this.methods[idx] = new Method(ins);
            }
        } else {
            this.methods = null;
        }
    }

    public String toString() {
        int idx;
        StringBuffer rep = new StringBuffer("Title: " + this.title_label + "\n");
        rep.append("Column Labels: LineID -> ");
        for (idx = 0; idx < this.num_treenodes; ++idx) {
            rep.append(this.column_labels[idx] + " ");
        }
        rep.append("\n");
        Iterator entries = super.entrySet().iterator();
        int ientry = 0;
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            Integer key = (Integer)entry.getKey();
            Integer[] value = (Integer[])entry.getValue();
            rep.append(++ientry + ", " + key + ":  ");
            for (idx = 0; idx < this.num_treenodes; ++idx) {
                rep.append(value[idx] + " ");
            }
            rep.append("\n");
        }
        if (this.methods != null && this.methods.length > 0) {
            rep.append("methods=< ");
            for (idx = 0; idx < this.methods.length; ++idx) {
                rep.append(this.methods[idx] + " ");
            }
            rep.append(">\n");
        }
        return rep.toString();
    }

    public static final void main(String[] args) {
        String filename = "tmp_LineIDMap.dat";
        String io_str = args[0].trim();
        boolean isWriting = io_str.equals("write");
        ArrayList<Object> cfglist = new ArrayList<Object>();
        LineIDMap linemap = null;
        if (isWriting) {
            int[] icfg;
            int Nlevels = Integer.parseInt(args[1]);
            int Nchilds = Integer.parseInt(args[2]);
            Permutation perms = new Permutation(Nlevels, Nchilds);
            while (perms.hasMoreElements()) {
                icfg = (int[])perms.nextElement();
                cfglist.add(icfg);
                cfglist.add(icfg.clone());
            }
            Collections.shuffle(cfglist);
            linemap = new LineIDMap(Nlevels);
            linemap.setTitle("SLOG2 LineIDMap sample");
            String[] col_names = new String[Nlevels];
            for (int idx = 0; idx < Nlevels; ++idx) {
                col_names[idx] = "column" + idx;
            }
            linemap.setColumnLabels(col_names);
            Iterator cfgs = cfglist.iterator();
            int cfg_idx = 1;
            while (cfgs.hasNext()) {
                icfg = (int[])cfgs.next();
                Integer[] ocfg = new Integer[icfg.length];
                for (int idx = 0; idx < ocfg.length; ++idx) {
                    ocfg[idx] = new Integer(icfg[idx]);
                }
                linemap.put(new Integer(10000 + cfg_idx), ocfg);
                ++cfg_idx;
            }
            System.out.println("LineIDMap:\n" + linemap);
            try {
                FileOutputStream fout = new FileOutputStream("tmp_LineIDMap.dat");
                MixedDataOutputStream dout = new MixedDataOutputStream(fout);
                linemap.writeObject(dout);
                fout.close();
            }
            catch (IOException ioerr) {
                ioerr.printStackTrace();
                System.exit(1);
            }
        } else {
            try {
                FileInputStream fin = new FileInputStream("tmp_LineIDMap.dat");
                MixedDataInputStream din = new MixedDataInputStream(fin);
                linemap = new LineIDMap(din);
                fin.close();
            }
            catch (IOException ioerr) {
                ioerr.printStackTrace();
                System.exit(1);
            }
            System.out.println(linemap);
        }
    }
}

