/*
 * Decompiled with CFR 0.152.
 */
package base.topology;

import java.awt.Color;
import java.awt.Graphics2D;

public abstract class StateBorder {
    public static final StateBorder EMPTY_BORDER = new EmptyBorder();
    public static final StateBorder WHITE_PLAIN_BORDER = new WhitePlainBorder();
    public static final StateBorder WHITE_LOWERED_BORDER = new WhiteLoweredBorder();
    public static final StateBorder WHITE_RAISED_BORDER = new WhiteRaisedBorder();
    public static final StateBorder COLOR_LOWERED_BORDER = new ColorLoweredBorder();
    public static final StateBorder COLOR_RAISED_BORDER = new ColorRaisedBorder();
    public static final StateBorder COLOR_XOR_BORDER = new ColorXORBorder();

    public static StateBorder parseString(String str) {
        if (str.equalsIgnoreCase(COLOR_XOR_BORDER.toString())) {
            return COLOR_XOR_BORDER;
        }
        if (str.equalsIgnoreCase(COLOR_RAISED_BORDER.toString())) {
            return COLOR_RAISED_BORDER;
        }
        if (str.equalsIgnoreCase(COLOR_LOWERED_BORDER.toString())) {
            return COLOR_LOWERED_BORDER;
        }
        if (str.equalsIgnoreCase(WHITE_RAISED_BORDER.toString())) {
            return WHITE_RAISED_BORDER;
        }
        if (str.equalsIgnoreCase(WHITE_LOWERED_BORDER.toString())) {
            return WHITE_LOWERED_BORDER;
        }
        if (str.equalsIgnoreCase(WHITE_PLAIN_BORDER.toString())) {
            return WHITE_PLAIN_BORDER;
        }
        if (str.equalsIgnoreCase(EMPTY_BORDER.toString())) {
            return EMPTY_BORDER;
        }
        return null;
    }

    public abstract void paintStateBorder(Graphics2D var1, Color var2, int var3, int var4, boolean var5, int var6, int var7, boolean var8);

    public abstract String toString();

    public static class ColorXORBorder
    extends StateBorder {
        public void paintStateBorder(Graphics2D g, Color color, int iHead, int jHead, boolean isStartVtxIn, int iTail, int jTail, boolean isFinalVtxIn) {
            int iwidth = iTail - iHead + 1;
            int jheight = jTail - jHead + 1;
            g.setXORMode(color);
            g.fillRect(iHead, jTail, iwidth, 1);
            if (isFinalVtxIn) {
                g.fillRect(iTail, jHead, 1, jheight);
            }
            g.fillRect(iHead, jHead, iwidth, 1);
            if (isStartVtxIn) {
                g.fillRect(iHead, jHead, 1, jheight);
            }
            g.setPaintMode();
        }

        public String toString() {
            return "ColorXOR";
        }
    }

    public static class ColorRaisedBorder
    extends StateBorder {
        public void paintStateBorder(Graphics2D g, Color color, int iHead, int jHead, boolean isStartVtxIn, int iTail, int jTail, boolean isFinalVtxIn) {
            int iwidth = iTail - iHead + 1;
            int jheight = jTail - jHead + 1;
            g.setColor(color.darker());
            g.fillRect(iHead, jTail, iwidth, 1);
            if (isFinalVtxIn) {
                g.fillRect(iTail, jHead, 1, jheight);
            }
            g.setColor(color.brighter());
            g.fillRect(iHead, jHead, iwidth, 1);
            if (isStartVtxIn) {
                g.fillRect(iHead, jHead, 1, jheight);
            }
        }

        public String toString() {
            return "ColorRaised";
        }
    }

    public static class ColorLoweredBorder
    extends StateBorder {
        public void paintStateBorder(Graphics2D g, Color color, int iHead, int jHead, boolean isStartVtxIn, int iTail, int jTail, boolean isFinalVtxIn) {
            int iwidth = iTail - iHead + 1;
            int jheight = jTail - jHead + 1;
            g.setColor(color.brighter());
            g.fillRect(iHead, jTail, iwidth, 1);
            if (isFinalVtxIn) {
                g.fillRect(iTail, jHead, 1, jheight);
            }
            g.setColor(color.darker());
            g.fillRect(iHead, jHead, iwidth, 1);
            if (isStartVtxIn) {
                g.fillRect(iHead, jHead, 1, jheight);
            }
        }

        public String toString() {
            return "ColorLowered";
        }
    }

    public static class WhiteRaisedBorder
    extends StateBorder {
        public void paintStateBorder(Graphics2D g, Color color, int iHead, int jHead, boolean isStartVtxIn, int iTail, int jTail, boolean isFinalVtxIn) {
            int iwidth = iTail - iHead + 1;
            int jheight = jTail - jHead + 1;
            g.setColor(Color.gray);
            g.fillRect(iHead, jTail, iwidth, 1);
            if (isFinalVtxIn) {
                g.fillRect(iTail, jHead, 1, jheight);
            }
            g.setColor(Color.white);
            g.fillRect(iHead, jHead, iwidth, 1);
            if (isStartVtxIn) {
                g.fillRect(iHead, jHead, 1, jheight);
            }
        }

        public String toString() {
            return "WhiteRaised";
        }
    }

    public static class WhiteLoweredBorder
    extends StateBorder {
        public void paintStateBorder(Graphics2D g, Color color, int iHead, int jHead, boolean isStartVtxIn, int iTail, int jTail, boolean isFinalVtxIn) {
            int iwidth = iTail - iHead + 1;
            int jheight = jTail - jHead + 1;
            g.setColor(Color.white);
            g.fillRect(iHead, jTail, iwidth, 1);
            if (isFinalVtxIn) {
                g.fillRect(iTail, jHead, 1, jheight);
            }
            g.setColor(Color.gray);
            g.fillRect(iHead, jHead, iwidth, 1);
            if (isStartVtxIn) {
                g.fillRect(iHead, jHead, 1, jheight);
            }
        }

        public String toString() {
            return "WhiteLowered";
        }
    }

    public static class WhitePlainBorder
    extends StateBorder {
        public void paintStateBorder(Graphics2D g, Color color, int iHead, int jHead, boolean isStartVtxIn, int iTail, int jTail, boolean isFinalVtxIn) {
            int iwidth = iTail - iHead + 1;
            int jheight = jTail - jHead + 1;
            g.setColor(Color.white);
            g.fillRect(iHead, jTail, iwidth, 1);
            if (isFinalVtxIn) {
                g.fillRect(iTail, jHead, 1, jheight);
            }
            g.setColor(Color.white);
            g.fillRect(iHead, jHead, iwidth, 1);
            if (isStartVtxIn) {
                g.fillRect(iHead, jHead, 1, jheight);
            }
        }

        public String toString() {
            return "WhitePlain";
        }
    }

    public static class EmptyBorder
    extends StateBorder {
        public void paintStateBorder(Graphics2D g, Color color, int iHead, int jHead, boolean isStartVtxIn, int iTail, int jTail, boolean isFinalVtxIn) {
        }

        public String toString() {
            return "Empty";
        }
    }
}

