/*
 * Decompiled with CFR 0.152.
 */
package base.topology;

import base.drawable.CoordPixelXform;
import base.drawable.DrawnBox;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class Arrow {
    private static int Head_Length = 15;
    private static int Head_Half_Width = 5;

    public static void setHeadLength(int new_length) {
        Head_Length = new_length;
    }

    public static void setHeadWidth(int new_width) {
        Head_Half_Width = new_width / 2;
        if (Head_Half_Width < 1) {
            Head_Half_Width = 1;
        }
    }

    private static int drawForward(Graphics2D g, Color color, Stroke stroke, CoordPixelXform coord_xform, DrawnBox last_drawn_pos, double start_time, float start_ypos, double final_time, float final_ypos) {
        int jTail;
        int iTail;
        int jHead;
        int iHead;
        int iFinal;
        int iStart = coord_xform.convertTimeToPixel(start_time);
        if (last_drawn_pos.coversArrow(iStart, iFinal = coord_xform.convertTimeToPixel(final_time))) {
            return 0;
        }
        last_drawn_pos.set(iStart, iFinal);
        int jStart = coord_xform.convertRowToPixel(start_ypos);
        int jFinal = coord_xform.convertRowToPixel(final_ypos);
        boolean isStartVtxInImg = iStart > 0;
        boolean isFinalVtxInImg = iFinal < coord_xform.getImageWidth();
        boolean isSlopeNonComputable = false;
        double slope = 0.0;
        if (iStart != iFinal) {
            slope = (double)(jFinal - jStart) / (double)(iFinal - iStart);
        } else {
            isSlopeNonComputable = true;
            slope = jStart != jFinal ? (jFinal > jStart ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY) : Double.NaN;
        }
        if (isStartVtxInImg) {
            iHead = iStart;
            jHead = jStart;
        } else {
            if (isSlopeNonComputable) {
                return 0;
            }
            iHead = 0;
            jHead = (int)Math.rint((double)jStart - slope * (double)iStart);
        }
        if (isFinalVtxInImg) {
            iTail = iFinal;
            jTail = jFinal;
        } else {
            if (isSlopeNonComputable) {
                return 0;
            }
            iTail = coord_xform.getImageWidth();
            jTail = (int)Math.rint((double)jFinal + slope * (double)(iTail - iFinal));
        }
        int iLeft = 0;
        int jLeft = 0;
        int iRight = 0;
        int jRight = 0;
        if (isFinalVtxInImg) {
            double sinA;
            double cosA;
            if (isSlopeNonComputable) {
                if (slope == Double.NaN) {
                    cosA = 1.0;
                    sinA = 0.0;
                } else if (slope == Double.POSITIVE_INFINITY) {
                    cosA = 0.0;
                    sinA = 1.0;
                } else {
                    cosA = 0.0;
                    sinA = -1.0;
                }
            } else {
                cosA = 1.0 / Math.sqrt(1.0 + slope * slope);
                sinA = slope * cosA;
            }
            double xBase = (double)iTail - (double)Head_Length * cosA;
            double yBase = (double)jTail - (double)Head_Length * sinA;
            double xOff = (double)Head_Half_Width * sinA;
            double yOff = (double)Head_Half_Width * cosA;
            iLeft = (int)Math.round(xBase + xOff);
            jLeft = (int)Math.round(yBase - yOff);
            iRight = (int)Math.round(xBase - xOff);
            jRight = (int)Math.round(yBase + yOff);
        }
        Stroke orig_stroke = null;
        if (stroke != null) {
            orig_stroke = g.getStroke();
            g.setStroke(stroke);
        }
        g.setColor(color);
        g.drawLine(iHead, jHead, iTail, jTail);
        if (stroke != null) {
            g.setStroke(orig_stroke);
        }
        if (isFinalVtxInImg) {
            g.drawLine(iTail, jTail, iLeft, jLeft);
            g.drawLine(iLeft, jLeft, iRight, jRight);
            g.drawLine(iRight, jRight, iTail, jTail);
        }
        return 1;
    }

    private static int drawBackward(Graphics2D g, Color color, Stroke stroke, CoordPixelXform coord_xform, DrawnBox last_drawn_pos, double start_time, float start_ypos, double final_time, float final_ypos) {
        int jTail;
        int iTail;
        int jHead;
        int iHead;
        int iFinal;
        int iStart = coord_xform.convertTimeToPixel(start_time);
        if (last_drawn_pos.coversArrow(iStart, iFinal = coord_xform.convertTimeToPixel(final_time))) {
            return 0;
        }
        last_drawn_pos.set(iStart, iFinal);
        int jStart = coord_xform.convertRowToPixel(start_ypos);
        int jFinal = coord_xform.convertRowToPixel(final_ypos);
        boolean isStartVtxInImg = iStart < coord_xform.getImageWidth();
        boolean isFinalVtxInImg = iFinal > 0;
        boolean isSlopeNonComputable = false;
        double slope = 0.0;
        if (iStart != iFinal) {
            slope = (double)(jStart - jFinal) / (double)(iStart - iFinal);
        } else {
            isSlopeNonComputable = true;
            slope = jStart != jFinal ? (jStart > jFinal ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY) : Double.NaN;
        }
        if (isStartVtxInImg) {
            iHead = iStart;
            jHead = jStart;
        } else {
            if (isSlopeNonComputable) {
                return 0;
            }
            iHead = coord_xform.getImageWidth();
            jHead = (int)Math.rint((double)jStart + slope * (double)(iHead - iStart));
        }
        if (isFinalVtxInImg) {
            iTail = iFinal;
            jTail = jFinal;
        } else {
            if (isSlopeNonComputable) {
                return 0;
            }
            iTail = 0;
            jTail = (int)Math.rint((double)jFinal - slope * (double)iFinal);
        }
        int iLeft = 0;
        int jLeft = 0;
        int iRight = 0;
        int jRight = 0;
        if (isFinalVtxInImg) {
            double sinA;
            double cosA;
            if (isSlopeNonComputable) {
                if (slope == Double.NaN) {
                    cosA = -1.0;
                    sinA = 0.0;
                } else if (slope == Double.POSITIVE_INFINITY) {
                    cosA = 0.0;
                    sinA = -1.0;
                } else {
                    cosA = 0.0;
                    sinA = 1.0;
                }
            } else {
                cosA = -1.0 / Math.sqrt(1.0 + slope * slope);
                sinA = slope * cosA;
            }
            double xBase = (double)iTail - (double)Head_Length * cosA;
            double yBase = (double)jTail - (double)Head_Length * sinA;
            double xOff = (double)Head_Half_Width * sinA;
            double yOff = (double)Head_Half_Width * cosA;
            iLeft = (int)Math.round(xBase + xOff);
            jLeft = (int)Math.round(yBase - yOff);
            iRight = (int)Math.round(xBase - xOff);
            jRight = (int)Math.round(yBase + yOff);
        }
        Stroke orig_stroke = null;
        if (stroke != null) {
            orig_stroke = g.getStroke();
            g.setStroke(stroke);
        }
        g.setColor(color);
        g.drawLine(iTail, jTail, iHead, jHead);
        if (isFinalVtxInImg) {
            g.drawLine(iTail, jTail, iLeft, jLeft);
            g.drawLine(iLeft, jLeft, iRight, jRight);
            g.drawLine(iRight, jRight, iTail, jTail);
        }
        if (stroke != null) {
            g.setStroke(orig_stroke);
        }
        return 1;
    }

    public static int draw(Graphics2D g, Color color, Stroke stroke, CoordPixelXform coord_xform, DrawnBox last_drawn_pos, double start_time, float start_ypos, double final_time, float final_ypos) {
        if (start_time < final_time) {
            return Arrow.drawForward(g, color, stroke, coord_xform, last_drawn_pos, start_time, start_ypos, final_time, final_ypos);
        }
        return Arrow.drawBackward(g, color, stroke, coord_xform, last_drawn_pos, start_time, start_ypos, final_time, final_ypos);
    }
}

