/*
 * Decompiled with CFR 0.152.
 */
package logformat.slog2.output;

import base.drawable.TimeBoundingBox;
import base.io.BufArrayOutputStream;
import base.io.MixedDataIO;
import base.io.MixedDataOutputStream;
import base.io.MixedRandomAccessFile;
import java.io.IOException;
import logformat.slog2.CategoryMap;
import logformat.slog2.FileBlockPtr;
import logformat.slog2.Header;
import logformat.slog2.LineIDMapList;
import logformat.slog2.TreeDir;
import logformat.slog2.TreeDirValue;
import logformat.slog2.TreeNodeID;
import logformat.slog2.output.TreeNode;

public class OutputLog {
    private MixedRandomAccessFile rand_file = null;
    private BufArrayOutputStream bary_outs;
    private MixedDataOutputStream data_outs;
    private Header filehdr;
    private TreeDir treedir;
    private FileBlockPtr node_blockptr;

    public OutputLog(String filename) {
        try {
            this.rand_file = new MixedRandomAccessFile(filename, "rw");
        }
        catch (IOException ferr) {
            ferr.printStackTrace();
            System.exit(1);
        }
        this.filehdr = new Header();
        this.bary_outs = new BufArrayOutputStream(this.filehdr.getTreeLeafByteSize());
        this.data_outs = new MixedDataOutputStream(this.bary_outs);
        this.treedir = new TreeDir();
        this.node_blockptr = null;
        this.writeHeader();
    }

    public void setTreeLeafByteSize(int in_bytesize) {
        this.filehdr.setTreeLeafByteSize(in_bytesize);
        this.bary_outs = new BufArrayOutputStream(this.filehdr.getTreeLeafByteSize());
        this.data_outs = new MixedDataOutputStream(this.bary_outs);
    }

    public int getTreeLeafByteSize() {
        return this.filehdr.getTreeLeafByteSize();
    }

    public void setNumChildrenPerNode(short num_leafs) {
        this.filehdr.setNumChildrenPerNode(num_leafs);
    }

    public short getNumChildrenPerNode() {
        return this.filehdr.getNumChildrenPerNode();
    }

    public void writeTreeNode(TreeNode treenode) {
        try {
            this.node_blockptr = new FileBlockPtr(this.rand_file.getFilePointer(), treenode.getNodeByteSize());
        }
        catch (IOException ioerr) {
            ioerr.printStackTrace();
            System.exit(1);
        }
        TreeNodeID treedir_key = new TreeNodeID(treenode.getTreeNodeID());
        TimeBoundingBox timebox = new TimeBoundingBox(treenode);
        TreeDirValue treedir_val = new TreeDirValue(timebox, this.node_blockptr);
        this.treedir.put(treedir_key, treedir_val);
        treenode.setFileBlockPtr(this.node_blockptr.getFilePointer(), this.node_blockptr.getBlockSize());
        treenode.mergeVerticalShadowBufs();
        treenode.shiftHorizontalShadowBuf();
        this.bary_outs.reset();
        try {
            treenode.writeObject(this.data_outs);
            this.data_outs.flush();
            this.rand_file.write(this.bary_outs.getByteArrayBuf(), 0, this.bary_outs.size());
            if (this.bary_outs.size() > this.filehdr.getMaxBufferByteSize()) {
                this.filehdr.setMaxBufferByteSize(this.bary_outs.size());
            }
        }
        catch (IOException ioerr) {
            ioerr.printStackTrace();
            System.exit(1);
        }
    }

    private void writeFilePart(MixedDataIO filepart, FileBlockPtr blockptr) {
        int blocksize = 0;
        try {
            blockptr.setFilePointer(this.rand_file.getFilePointer());
        }
        catch (IOException ioerr) {
            ioerr.printStackTrace();
            System.exit(1);
        }
        this.bary_outs.reset();
        try {
            filepart.writeObject(this.data_outs);
            this.data_outs.flush();
            this.rand_file.write(this.bary_outs.getByteArrayBuf(), 0, this.bary_outs.size());
            if (this.bary_outs.size() > this.filehdr.getMaxBufferByteSize()) {
                this.filehdr.setMaxBufferByteSize(this.bary_outs.size());
            }
            blocksize = (int)(this.rand_file.getFilePointer() - blockptr.getFilePointer());
        }
        catch (IOException ioerr) {
            ioerr.printStackTrace();
            System.exit(1);
        }
        blockptr.setBlockSize(blocksize);
    }

    public void writeCategoryMap(CategoryMap objdefs) {
        this.writeFilePart(objdefs, this.filehdr.blockptr2categories);
    }

    public void writeLineIDMapList(LineIDMapList lineIDmaps) {
        this.writeFilePart(lineIDmaps, this.filehdr.blockptr2lineIDmaps);
    }

    private void writeTreeDir() {
        this.writeFilePart(this.treedir, this.filehdr.blockptr2treedir);
    }

    private void writeHeader() {
        if (this.node_blockptr != null) {
            this.filehdr.blockptr2treeroot.setFileBlockPtr(this.node_blockptr.getFilePointer(), this.node_blockptr.getBlockSize());
            this.filehdr.setMaxTreeDepth(this.treedir.getTreeRootID().depth);
        }
        this.bary_outs.reset();
        try {
            this.filehdr.writeObject(this.data_outs);
            this.data_outs.flush();
            this.rand_file.seek(0L);
            this.rand_file.write(this.bary_outs.getByteArrayBuf(), 0, this.bary_outs.size());
        }
        catch (IOException ioerr) {
            ioerr.printStackTrace();
            System.exit(1);
        }
    }

    public void close() {
        this.writeTreeDir();
        this.writeHeader();
        System.out.println(this.filehdr.toString());
        try {
            this.data_outs.close();
            this.rand_file.close();
        }
        catch (IOException ioerr) {
            ioerr.printStackTrace();
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }
}

