/*
 * Decompiled with CFR 0.152.
 */
package logformat.slog2;

import base.drawable.Composite;
import base.drawable.Drawable;
import base.drawable.Primitive;
import base.drawable.TimeBoundingBox;
import base.io.MixedDataInput;
import base.io.MixedDataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import logformat.slog2.BufForObjects;
import logformat.slog2.IteratorOfAllDrawables;
import logformat.slog2.IteratorOfBackDrawables;
import logformat.slog2.IteratorOfBackPrimitives;
import logformat.slog2.IteratorOfForeDrawables;
import logformat.slog2.IteratorOfForePrimitives;
import logformat.slog2.LineIDMap;

public class BufForDrawables
extends BufForObjects {
    private static final int INIT_BYTESIZE = 42;
    private static final byte PRIMITIVE_ID = 0;
    private static final byte COMPOSITE_ID = 1;
    private List buf4nestable;
    private List buf4nestless;
    private Drawable.Order buf4dobj_order;
    private boolean isOutputBuf;
    private boolean haveObjectsBeenSaved;
    private int total_bytesize;

    public BufForDrawables(boolean isForOutput) {
        this.isOutputBuf = isForOutput;
        if (this.isOutputBuf) {
            this.buf4nestable = new ArrayList();
            this.buf4nestless = new ArrayList();
            this.buf4dobj_order = Drawable.INCRE_FINALTIME_ORDER;
        } else {
            this.buf4nestable = null;
            this.buf4nestless = null;
            this.buf4dobj_order = Drawable.INCRE_STARTTIME_ORDER;
        }
        this.haveObjectsBeenSaved = false;
        this.total_bytesize = 42;
    }

    public int getByteSize() {
        return this.total_bytesize;
    }

    public void add(Primitive prime) {
        if (prime.getCategory().getTopology().isState()) {
            this.buf4nestable.add(prime);
        } else {
            this.buf4nestless.add(prime);
        }
        this.total_bytesize += prime.getByteSize() + 1;
    }

    public void add(Composite cmplx) {
        this.buf4nestable.add(cmplx);
        this.total_bytesize += cmplx.getByteSize() + 1;
    }

    public void empty() {
        if (this.haveObjectsBeenSaved) {
            this.buf4nestable.clear();
            this.buf4nestless.clear();
            this.buf4dobj_order = Drawable.INCRE_FINALTIME_ORDER;
            this.haveObjectsBeenSaved = false;
            this.total_bytesize = 42;
        }
    }

    public int getNumOfDrawables() {
        return this.buf4nestable.size() + this.buf4nestless.size();
    }

    public int getNumOfPrimitives() {
        int count = this.buf4nestless.size();
        Iterator dobjs_itr = this.buf4nestable.iterator();
        while (dobjs_itr.hasNext()) {
            count += ((Drawable)dobjs_itr.next()).getNumOfPrimitives();
        }
        return count;
    }

    public Iterator nestableForeIterator(TimeBoundingBox tframe, boolean isComposite) {
        if (isComposite) {
            return new IteratorOfForeDrawables(this.buf4nestable, tframe);
        }
        return new IteratorOfForePrimitives(this.buf4nestable, tframe);
    }

    public Iterator nestlessForeIterator(TimeBoundingBox tframe) {
        return new IteratorOfForeDrawables(this.buf4nestless, tframe);
    }

    public Iterator nestableBackIterator(TimeBoundingBox tframe, boolean isComposite) {
        if (isComposite) {
            return new IteratorOfBackDrawables(this.buf4nestable, tframe);
        }
        return new IteratorOfBackPrimitives(this.buf4nestable, tframe);
    }

    public Iterator nestlessBackIterator(TimeBoundingBox tframe) {
        return new IteratorOfBackDrawables(this.buf4nestless, tframe);
    }

    public LineIDMap getIdentityLineIDMap() {
        ArrayList buf4drawables = new ArrayList(this.buf4nestable);
        buf4drawables.addAll(this.buf4nestless);
        return BufForObjects.toIdentityLineIDMap(buf4drawables);
    }

    public void reorderDrawables(Drawable.Order dobj_order) {
        if (!this.buf4dobj_order.equals(dobj_order)) {
            this.buf4dobj_order = dobj_order;
            Collections.sort(this.buf4nestable, this.buf4dobj_order);
            Collections.sort(this.buf4nestless, this.buf4dobj_order);
        }
    }

    public void writeObject(MixedDataOutput outs) throws IOException {
        Drawable dobj;
        super.writeObject(outs);
        this.reorderDrawables(Drawable.INCRE_STARTTIME_ORDER);
        int Nobjs = this.buf4nestless.size();
        outs.writeInt(Nobjs);
        ListIterator dobjs_itr = this.buf4nestless.listIterator(0);
        while (dobjs_itr.hasNext()) {
            dobj = (Drawable)dobjs_itr.next();
            if (dobj instanceof Composite) {
                outs.writeByte(1);
                ((Composite)dobj).writeObject(outs);
                continue;
            }
            outs.writeByte(0);
            ((Primitive)dobj).writeObject(outs);
        }
        Nobjs = this.buf4nestable.size();
        outs.writeInt(Nobjs);
        dobjs_itr = this.buf4nestable.listIterator(0);
        while (dobjs_itr.hasNext()) {
            dobj = (Drawable)dobjs_itr.next();
            if (dobj instanceof Composite) {
                outs.writeByte(1);
                ((Composite)dobj).writeObject(outs);
                continue;
            }
            outs.writeByte(0);
            ((Primitive)dobj).writeObject(outs);
        }
        this.haveObjectsBeenSaved = true;
    }

    public BufForDrawables(MixedDataInput ins, Map categorymap) throws IOException {
        this(false);
        this.readObject(ins, categorymap);
    }

    public void readObject(MixedDataInput ins, Map categorymap) throws IOException {
        Composite cmplx;
        Primitive prime;
        byte dobj_type;
        int idx;
        super.readObject(ins);
        int Nobjs = ins.readInt();
        this.buf4nestless = new ArrayList(Nobjs);
        block8: for (idx = 0; idx < Nobjs; ++idx) {
            dobj_type = ins.readByte();
            switch (dobj_type) {
                case 0: {
                    prime = new Primitive(ins);
                    prime.resolveCategory(categorymap);
                    this.buf4nestless.add(prime);
                    this.total_bytesize += prime.getByteSize() + 1;
                    continue block8;
                }
                case 1: {
                    cmplx = new Composite(ins);
                    cmplx.resolveCategory(categorymap);
                    this.buf4nestless.add(cmplx);
                    this.total_bytesize += cmplx.getByteSize() + 1;
                    continue block8;
                }
                default: {
                    System.err.println("BufForDrawables: Error! Unknown drawable type = " + dobj_type);
                }
            }
        }
        Nobjs = ins.readInt();
        this.buf4nestable = new ArrayList(Nobjs);
        block9: for (idx = 0; idx < Nobjs; ++idx) {
            dobj_type = ins.readByte();
            switch (dobj_type) {
                case 0: {
                    prime = new Primitive(ins);
                    prime.resolveCategory(categorymap);
                    this.buf4nestable.add(prime);
                    this.total_bytesize += prime.getByteSize() + 1;
                    continue block9;
                }
                case 1: {
                    cmplx = new Composite(ins);
                    cmplx.resolveCategory(categorymap);
                    this.buf4nestable.add(cmplx);
                    this.total_bytesize += cmplx.getByteSize() + 1;
                    continue block9;
                }
                default: {
                    System.err.println("BufForDrawables: Error! Unknown drawable type = " + dobj_type);
                }
            }
        }
    }

    public String toString() {
        StringBuffer rep = new StringBuffer("    BufForDrawables{ ");
        rep.append(super.toString());
        rep.append(" }\n");
        IteratorOfForeDrawables nestable_itr = new IteratorOfForeDrawables(this.buf4nestable, this);
        IteratorOfForeDrawables nestless_itr = new IteratorOfForeDrawables(this.buf4nestless, this);
        IteratorOfAllDrawables dobjs_itr = new IteratorOfAllDrawables(nestable_itr, nestless_itr, this.buf4dobj_order);
        int idx = 1;
        while (dobjs_itr.hasNext()) {
            rep.append(idx + ": " + dobjs_itr.next() + "\n");
            ++idx;
        }
        return rep.toString();
    }
}

