/*
 * Decompiled with CFR 0.152.
 */
package viewer.common;

import base.topology.StateBorder;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import viewer.common.Alias;
import viewer.common.Const;
import viewer.common.LabeledComboBox;
import viewer.common.LabeledFloatSlider;
import viewer.common.LabeledTextField;
import viewer.common.Parameters;

public class PreferencePanel
extends JPanel {
    private static int VERTICAL_GAP_HEIGHT = 10;
    private LabeledTextField fld_Y_AXIS_ROOT_LABEL;
    private LabeledTextField fld_INIT_SLOG2_LEVEL_READ;
    private LabeledComboBox lst_AUTO_WINDOWS_LOCATION;
    private LabeledFloatSlider sdr_SCREEN_HEIGHT_RATIO;
    private LabeledFloatSlider sdr_TIME_SCROLL_UNIT_RATIO;
    private LabeledComboBox lst_Y_AXIS_ROOT_VISIBLE;
    private LabeledComboBox lst_ACTIVE_REFRESH;
    private LabeledComboBox lst_BACKGROUND_COLOR;
    private LabeledFloatSlider sdr_STATE_HEIGHT_FACTOR;
    private LabeledFloatSlider sdr_NESTING_HEIGHT_FACTOR;
    private LabeledComboBox lst_ARROW_ANTIALIASING;
    private LabeledTextField fld_MIN_WIDTH_TO_DRAG;
    private LabeledTextField fld_CLICK_RADIUS_TO_LINE;
    private LabeledComboBox lst_LEFTCLICK_INSTANT_ZOOM;
    private LabeledComboBox lst_STATE_BORDER;
    private LabeledTextField fld_ARROW_HEAD_LENGTH;
    private LabeledTextField fld_ARROW_HEAD_WIDTH;
    private LabeledTextField fld_EVENT_BASE_WIDTH;
    private LabeledComboBox lst_PREVIEW_STATE_DISPLAY;
    private LabeledComboBox lst_PREVIEW_STATE_BORDER;
    private LabeledTextField fld_PREVIEW_STATE_BORDER_W;
    private LabeledTextField fld_PREVIEW_STATE_BORDER_H;
    private LabeledTextField fld_PREVIEW_STATE_LEGEND_H;
    private LabeledTextField fld_PREVIEW_ARROW_LOG_BASE;
    private LabeledTextField fld_SEARCH_ARROW_LENGTH;
    private LabeledTextField fld_SEARCH_FRAME_THICKNESS;
    private LabeledComboBox lst_SEARCHED_OBJECT_ON_TOP;
    private LabeledComboBox lst_HISTOGRAM_ZERO_ORIGIN;
    private LabeledComboBox lst_SUMMARY_STATE_BORDER;
    private LabeledTextField fld_SUMMARY_ARROW_LOG_BASE;
    private LabeledComboBox lst_LEGEND_PREVIEW_ORDER;
    private LabeledComboBox lst_LEGEND_TOPOLOGY_ORDER;

    public PreferencePanel() {
        super.setLayout(new BoxLayout(this, 1));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        JLabel jLabel = new JLabel("Zoomable window reinitialization");
        jLabel.setToolTipText("Options become effective after the zoomable window is restarted");
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add(jLabel);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.setAlignmentX(0.0f);
        super.add(jPanel);
        this.fld_Y_AXIS_ROOT_LABEL = new LabeledTextField(true, "Y_AXIS_ROOT_LABEL", Const.STRING_FORMAT);
        this.fld_Y_AXIS_ROOT_LABEL.setToolTipText("Label for the root node of the Y-axis tree label in the left panel");
        this.fld_Y_AXIS_ROOT_LABEL.setHorizontalAlignment(0);
        this.fld_Y_AXIS_ROOT_LABEL.addSelfDocumentListener();
        this.fld_Y_AXIS_ROOT_LABEL.setEditable(true);
        super.add(this.fld_Y_AXIS_ROOT_LABEL);
        this.fld_INIT_SLOG2_LEVEL_READ = new LabeledTextField(true, "INIT_SLOG2_LEVEL_READ", "##0");
        this.fld_INIT_SLOG2_LEVEL_READ.setToolTipText("The number of SLOG-2 levels being read into memory when timeline window is initialized, the number affects the zooming and scrolling performance exponentially (in a asymptotical sense).");
        this.fld_INIT_SLOG2_LEVEL_READ.setHorizontalAlignment(0);
        this.fld_INIT_SLOG2_LEVEL_READ.addSelfDocumentListener();
        this.fld_INIT_SLOG2_LEVEL_READ.setEditable(true);
        super.add(this.fld_INIT_SLOG2_LEVEL_READ);
        this.lst_AUTO_WINDOWS_LOCATION = new LabeledComboBox("AUTO_WINDOWS_LOCATION");
        this.lst_AUTO_WINDOWS_LOCATION.addItem(Boolean.TRUE);
        this.lst_AUTO_WINDOWS_LOCATION.addItem(Boolean.FALSE);
        this.lst_AUTO_WINDOWS_LOCATION.setToolTipText("Whether to let Jumpshot-4 automatically set windows placement.");
        super.add(this.lst_AUTO_WINDOWS_LOCATION);
        super.add(Box.createVerticalStrut(VERTICAL_GAP_HEIGHT));
        this.sdr_SCREEN_HEIGHT_RATIO = new LabeledFloatSlider("SCREEN_HEIGHT_RATIO", 0.0f, 1.0f);
        this.sdr_SCREEN_HEIGHT_RATIO.setToolTipText("Ratio of the initial timeline canvas height to the screen height.");
        this.sdr_SCREEN_HEIGHT_RATIO.setHorizontalAlignment(0);
        this.sdr_SCREEN_HEIGHT_RATIO.setEditable(true);
        super.add(this.sdr_SCREEN_HEIGHT_RATIO);
        this.sdr_TIME_SCROLL_UNIT_RATIO = new LabeledFloatSlider("TIME_SCROLL_UNIT_RATIO", 0.0f, 1.0f);
        this.sdr_TIME_SCROLL_UNIT_RATIO.setToolTipText("Unit increment of the horizontal scrollbar in the fraction of timeline canvas's width.");
        this.sdr_TIME_SCROLL_UNIT_RATIO.setHorizontalAlignment(0);
        this.sdr_TIME_SCROLL_UNIT_RATIO.setEditable(true);
        super.add(this.sdr_TIME_SCROLL_UNIT_RATIO);
        super.add(Box.createVerticalStrut(2 * VERTICAL_GAP_HEIGHT));
        jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jLabel = new JLabel("All zoomable windows");
        jLabel.setToolTipText("Options become effective after return and the zoomable window is redrawn");
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add(jLabel);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.setAlignmentX(0.0f);
        super.add(jPanel);
        this.lst_Y_AXIS_ROOT_VISIBLE = new LabeledComboBox("Y_AXIS_ROOT_VISIBLE");
        this.lst_Y_AXIS_ROOT_VISIBLE.addItem(Boolean.TRUE);
        this.lst_Y_AXIS_ROOT_VISIBLE.addItem(Boolean.FALSE);
        this.lst_Y_AXIS_ROOT_VISIBLE.setToolTipText("Whether to show the top of the Y-axis tree-styled directory label.");
        super.add(this.lst_Y_AXIS_ROOT_VISIBLE);
        this.lst_ACTIVE_REFRESH = new LabeledComboBox("ACTIVE_REFRESH");
        this.lst_ACTIVE_REFRESH.addItem(Boolean.TRUE);
        this.lst_ACTIVE_REFRESH.addItem(Boolean.FALSE);
        this.lst_ACTIVE_REFRESH.setToolTipText("Whether to let Jumpshot-4 actively update the timeline canvas.");
        super.add(this.lst_ACTIVE_REFRESH);
        this.lst_ACTIVE_REFRESH.setEnabled(false);
        this.lst_BACKGROUND_COLOR = new LabeledComboBox("BACKGROUND_COLOR");
        this.lst_BACKGROUND_COLOR.addItem(Const.COLOR_BLACK);
        this.lst_BACKGROUND_COLOR.addItem(Const.COLOR_DARKGRAY);
        this.lst_BACKGROUND_COLOR.addItem(Const.COLOR_GRAY);
        this.lst_BACKGROUND_COLOR.addItem(Const.COLOR_LIGHTGRAY);
        this.lst_BACKGROUND_COLOR.addItem(Const.COLOR_WHITE);
        this.lst_BACKGROUND_COLOR.setToolTipText("Background color of the timeline canvas");
        super.add(this.lst_BACKGROUND_COLOR);
        super.add(Box.createVerticalStrut(VERTICAL_GAP_HEIGHT));
        this.sdr_STATE_HEIGHT_FACTOR = new LabeledFloatSlider("STATE_HEIGHT_FACTOR", 0.0f, 1.0f);
        this.sdr_STATE_HEIGHT_FACTOR.setToolTipText("Ratio of the outermost rectangle height to the row height. The larger the factor is, the larger the outermost rectangle will be with respect to the row height.");
        this.sdr_STATE_HEIGHT_FACTOR.setHorizontalAlignment(0);
        this.sdr_STATE_HEIGHT_FACTOR.setEditable(true);
        super.add(this.sdr_STATE_HEIGHT_FACTOR);
        this.sdr_NESTING_HEIGHT_FACTOR = new LabeledFloatSlider("NESTING_HEIGHT_FACTOR", 0.0f, 1.0f);
        this.sdr_NESTING_HEIGHT_FACTOR.setToolTipText("The gap ratio between successive nesting rectangles. The larger the factor is, the smaller the gap will be.");
        this.sdr_NESTING_HEIGHT_FACTOR.setHorizontalAlignment(0);
        this.sdr_NESTING_HEIGHT_FACTOR.setEditable(true);
        super.add(this.sdr_NESTING_HEIGHT_FACTOR);
        this.lst_ARROW_ANTIALIASING = new LabeledComboBox("ARROW_ANTIALIASING");
        this.lst_ARROW_ANTIALIASING.addItem(Const.ANTIALIAS_DEFAULT);
        this.lst_ARROW_ANTIALIASING.addItem(Const.ANTIALIAS_OFF);
        this.lst_ARROW_ANTIALIASING.addItem(Const.ANTIALIAS_ON);
        this.lst_ARROW_ANTIALIASING.setToolTipText("Whether to draw arrow with antialiasing lines. Turning this on will slow down the canvas drawing by a factor of ~3");
        super.add(this.lst_ARROW_ANTIALIASING);
        this.fld_MIN_WIDTH_TO_DRAG = new LabeledTextField(true, "MIN_WIDTH_TO_DRAG", "#,##0");
        this.fld_MIN_WIDTH_TO_DRAG.setToolTipText("Minimum width in pixel to be considered a dragged operation.");
        this.fld_MIN_WIDTH_TO_DRAG.setHorizontalAlignment(0);
        this.fld_MIN_WIDTH_TO_DRAG.addSelfDocumentListener();
        this.fld_MIN_WIDTH_TO_DRAG.setEditable(true);
        super.add(this.fld_MIN_WIDTH_TO_DRAG);
        this.fld_CLICK_RADIUS_TO_LINE = new LabeledTextField(true, "CLICK_RADIUS_TO_LINE", "#,##0");
        this.fld_CLICK_RADIUS_TO_LINE.setToolTipText("Radius in pixel for a click to be considered on the arrow.");
        this.fld_CLICK_RADIUS_TO_LINE.setHorizontalAlignment(0);
        this.fld_CLICK_RADIUS_TO_LINE.addSelfDocumentListener();
        this.fld_CLICK_RADIUS_TO_LINE.setEditable(true);
        super.add(this.fld_CLICK_RADIUS_TO_LINE);
        this.lst_LEFTCLICK_INSTANT_ZOOM = new LabeledComboBox("LEFTCLICK_INSTANT_ZOOM");
        this.lst_LEFTCLICK_INSTANT_ZOOM.addItem(Boolean.TRUE);
        this.lst_LEFTCLICK_INSTANT_ZOOM.addItem(Boolean.FALSE);
        this.lst_LEFTCLICK_INSTANT_ZOOM.setToolTipText("Whether to zoom in immediately after left mouse click on canvas.");
        super.add(this.lst_LEFTCLICK_INSTANT_ZOOM);
        super.add(Box.createVerticalStrut(2 * VERTICAL_GAP_HEIGHT));
        jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jLabel = new JLabel("Timeline zoomable window");
        jLabel.setToolTipText("Options become effective after return and the Timeline window is redrawn");
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add(jLabel);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.setAlignmentX(0.0f);
        super.add(jPanel);
        this.lst_STATE_BORDER = new LabeledComboBox("STATE_BORDER");
        this.lst_STATE_BORDER.addItem(StateBorder.COLOR_RAISED_BORDER);
        this.lst_STATE_BORDER.addItem(StateBorder.COLOR_LOWERED_BORDER);
        this.lst_STATE_BORDER.addItem(StateBorder.WHITE_RAISED_BORDER);
        this.lst_STATE_BORDER.addItem(StateBorder.WHITE_LOWERED_BORDER);
        this.lst_STATE_BORDER.addItem(StateBorder.WHITE_PLAIN_BORDER);
        this.lst_STATE_BORDER.addItem(StateBorder.EMPTY_BORDER);
        this.lst_STATE_BORDER.setToolTipText("Border style of real states");
        super.add(this.lst_STATE_BORDER);
        this.fld_ARROW_HEAD_LENGTH = new LabeledTextField(true, "ARROW_HEAD_LENGTH", "#,##0");
        this.fld_ARROW_HEAD_LENGTH.setToolTipText("Length of the arrow head in pixel.");
        this.fld_ARROW_HEAD_LENGTH.setHorizontalAlignment(0);
        this.fld_ARROW_HEAD_LENGTH.addSelfDocumentListener();
        this.fld_ARROW_HEAD_LENGTH.setEditable(true);
        super.add(this.fld_ARROW_HEAD_LENGTH);
        this.fld_ARROW_HEAD_WIDTH = new LabeledTextField(true, "ARROW_HEAD_WIDTH", "#,##0");
        this.fld_ARROW_HEAD_WIDTH.setToolTipText("Width of the arrow head's base in pixel(Even number).");
        this.fld_ARROW_HEAD_WIDTH.setHorizontalAlignment(0);
        this.fld_ARROW_HEAD_WIDTH.addSelfDocumentListener();
        this.fld_ARROW_HEAD_WIDTH.setEditable(true);
        super.add(this.fld_ARROW_HEAD_WIDTH);
        this.fld_EVENT_BASE_WIDTH = new LabeledTextField(true, "EVENT_BASE_WIDTH", "#,##0");
        this.fld_EVENT_BASE_WIDTH.setToolTipText("Width of the event triangle's base in pixel(Even number).");
        this.fld_EVENT_BASE_WIDTH.setHorizontalAlignment(0);
        this.fld_EVENT_BASE_WIDTH.addSelfDocumentListener();
        this.fld_EVENT_BASE_WIDTH.setEditable(true);
        super.add(this.fld_EVENT_BASE_WIDTH);
        super.add(Box.createVerticalStrut(VERTICAL_GAP_HEIGHT));
        this.lst_PREVIEW_STATE_DISPLAY = new LabeledComboBox("PREVIEW_STATE_DISPLAY");
        this.lst_PREVIEW_STATE_DISPLAY.addItem("FitMostLegends");
        this.lst_PREVIEW_STATE_DISPLAY.addItem("OverlapInclusionRatio");
        this.lst_PREVIEW_STATE_DISPLAY.addItem("CumulativeInclusionRatio");
        this.lst_PREVIEW_STATE_DISPLAY.addItem("OverlapExclusionRatio");
        this.lst_PREVIEW_STATE_DISPLAY.addItem("CumulativeExclusionRatio");
        this.lst_PREVIEW_STATE_DISPLAY.addItem("BaseAlignedCumulativeExclusionRatio");
        this.lst_PREVIEW_STATE_DISPLAY.setToolTipText("Display options for the Preview state.");
        super.add(this.lst_PREVIEW_STATE_DISPLAY);
        this.lst_PREVIEW_STATE_BORDER = new LabeledComboBox("PREVIEW_STATE_BORDER");
        this.lst_PREVIEW_STATE_BORDER.addItem(StateBorder.COLOR_XOR_BORDER);
        this.lst_PREVIEW_STATE_BORDER.addItem(StateBorder.COLOR_RAISED_BORDER);
        this.lst_PREVIEW_STATE_BORDER.addItem(StateBorder.COLOR_LOWERED_BORDER);
        this.lst_PREVIEW_STATE_BORDER.addItem(StateBorder.WHITE_RAISED_BORDER);
        this.lst_PREVIEW_STATE_BORDER.addItem(StateBorder.WHITE_LOWERED_BORDER);
        this.lst_PREVIEW_STATE_BORDER.addItem(StateBorder.WHITE_PLAIN_BORDER);
        this.lst_PREVIEW_STATE_BORDER.addItem(StateBorder.EMPTY_BORDER);
        this.lst_PREVIEW_STATE_BORDER.setToolTipText("Border style of Preview state.");
        super.add(this.lst_PREVIEW_STATE_BORDER);
        this.fld_PREVIEW_STATE_BORDER_W = new LabeledTextField(true, "PREVIEW_STATE_BORDER_W", "#,##0");
        this.fld_PREVIEW_STATE_BORDER_W.setToolTipText("The empty border insets' width in pixel for the Preview state.");
        this.fld_PREVIEW_STATE_BORDER_W.setHorizontalAlignment(0);
        this.fld_PREVIEW_STATE_BORDER_W.addSelfDocumentListener();
        this.fld_PREVIEW_STATE_BORDER_W.setEditable(true);
        super.add(this.fld_PREVIEW_STATE_BORDER_W);
        this.fld_PREVIEW_STATE_BORDER_H = new LabeledTextField(true, "PREVIEW_STATE_BORDER_H", "#,##0");
        this.fld_PREVIEW_STATE_BORDER_H.setToolTipText("The empty border insets' height in pixel for the Preview state.");
        this.fld_PREVIEW_STATE_BORDER_H.setHorizontalAlignment(0);
        this.fld_PREVIEW_STATE_BORDER_H.addSelfDocumentListener();
        this.fld_PREVIEW_STATE_BORDER_H.setEditable(true);
        super.add(this.fld_PREVIEW_STATE_BORDER_H);
        this.fld_PREVIEW_STATE_LEGEND_H = new LabeledTextField(true, "PREVIEW_STATE_LEGEND_H", "#,##0");
        this.fld_PREVIEW_STATE_LEGEND_H.setToolTipText("Minimum height of the legend divison in pixel for the Preview state");
        this.fld_PREVIEW_STATE_LEGEND_H.setHorizontalAlignment(0);
        this.fld_PREVIEW_STATE_LEGEND_H.addSelfDocumentListener();
        this.fld_PREVIEW_STATE_LEGEND_H.setEditable(true);
        super.add(this.fld_PREVIEW_STATE_LEGEND_H);
        this.fld_PREVIEW_ARROW_LOG_BASE = new LabeledTextField(true, "PREVIEW_ARROW_LOG_BASE", "#,##0");
        this.fld_PREVIEW_ARROW_LOG_BASE.setToolTipText("The logarithmic base of the number of arrows in Preview arrow.\nThis determines the Preview arrow's width.");
        this.fld_PREVIEW_ARROW_LOG_BASE.setHorizontalAlignment(0);
        this.fld_PREVIEW_ARROW_LOG_BASE.addSelfDocumentListener();
        this.fld_PREVIEW_ARROW_LOG_BASE.setEditable(true);
        super.add(this.fld_PREVIEW_ARROW_LOG_BASE);
        super.add(Box.createVerticalStrut(VERTICAL_GAP_HEIGHT));
        this.fld_SEARCH_ARROW_LENGTH = new LabeledTextField(true, "SEARCH_ARROW_LENGTH", "#,##0");
        this.fld_SEARCH_ARROW_LENGTH.setToolTipText("Length of the search marker's arrow in pixel");
        this.fld_SEARCH_ARROW_LENGTH.setHorizontalAlignment(0);
        this.fld_SEARCH_ARROW_LENGTH.addSelfDocumentListener();
        this.fld_SEARCH_ARROW_LENGTH.setEditable(true);
        super.add(this.fld_SEARCH_ARROW_LENGTH);
        this.fld_SEARCH_FRAME_THICKNESS = new LabeledTextField(true, "SEARCH_FRAME_THICKNESS", "#,##0");
        this.fld_SEARCH_FRAME_THICKNESS.setToolTipText("Thickness in pixel of the popup frame that hightlights the searched drawable");
        this.fld_SEARCH_FRAME_THICKNESS.setHorizontalAlignment(0);
        this.fld_SEARCH_FRAME_THICKNESS.addSelfDocumentListener();
        this.fld_SEARCH_FRAME_THICKNESS.setEditable(true);
        super.add(this.fld_SEARCH_FRAME_THICKNESS);
        this.lst_SEARCHED_OBJECT_ON_TOP = new LabeledComboBox("SEARCHED_OBJECT_ON_TOP");
        this.lst_SEARCHED_OBJECT_ON_TOP.addItem(Boolean.TRUE);
        this.lst_SEARCHED_OBJECT_ON_TOP.addItem(Boolean.FALSE);
        this.lst_SEARCHED_OBJECT_ON_TOP.setToolTipText("Whether to display the searched object on top of the search frame.");
        super.add(this.lst_SEARCHED_OBJECT_ON_TOP);
        super.add(Box.createVerticalStrut(2 * VERTICAL_GAP_HEIGHT));
        jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jLabel = new JLabel("Histogram zoomable window");
        jLabel.setToolTipText("Options become effective after return and the Histogram window is redrawn");
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add(jLabel);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.setAlignmentX(0.0f);
        super.add(jPanel);
        this.lst_HISTOGRAM_ZERO_ORIGIN = new LabeledComboBox("HISTOGRAM_ZERO_ORIGIN");
        this.lst_HISTOGRAM_ZERO_ORIGIN.addItem(Boolean.TRUE);
        this.lst_HISTOGRAM_ZERO_ORIGIN.addItem(Boolean.FALSE);
        this.lst_HISTOGRAM_ZERO_ORIGIN.setToolTipText("Whether to the time ruler is in duration, i.e. starts with 0.0.");
        super.add(this.lst_HISTOGRAM_ZERO_ORIGIN);
        this.lst_SUMMARY_STATE_BORDER = new LabeledComboBox("SUMMARY_STATE_BORDER");
        this.lst_SUMMARY_STATE_BORDER.addItem(StateBorder.COLOR_XOR_BORDER);
        this.lst_SUMMARY_STATE_BORDER.addItem(StateBorder.COLOR_RAISED_BORDER);
        this.lst_SUMMARY_STATE_BORDER.addItem(StateBorder.COLOR_LOWERED_BORDER);
        this.lst_SUMMARY_STATE_BORDER.addItem(StateBorder.WHITE_RAISED_BORDER);
        this.lst_SUMMARY_STATE_BORDER.addItem(StateBorder.WHITE_LOWERED_BORDER);
        this.lst_SUMMARY_STATE_BORDER.addItem(StateBorder.WHITE_PLAIN_BORDER);
        this.lst_SUMMARY_STATE_BORDER.addItem(StateBorder.EMPTY_BORDER);
        this.lst_SUMMARY_STATE_BORDER.setToolTipText("Border style of the Summary state in the histogram window.");
        super.add(this.lst_SUMMARY_STATE_BORDER);
        this.fld_SUMMARY_ARROW_LOG_BASE = new LabeledTextField(true, "SUMMARY_ARROW_LOG_BASE", "#,##0");
        this.fld_SUMMARY_ARROW_LOG_BASE.setToolTipText("The logarithmic base of the number of arrows in Summary arrow.\nThis determines the Summary arrow's width.");
        this.fld_SUMMARY_ARROW_LOG_BASE.setHorizontalAlignment(0);
        this.fld_SUMMARY_ARROW_LOG_BASE.addSelfDocumentListener();
        this.fld_SUMMARY_ARROW_LOG_BASE.setEditable(true);
        super.add(this.fld_SUMMARY_ARROW_LOG_BASE);
        super.add(Box.createVerticalStrut(2 * VERTICAL_GAP_HEIGHT));
        jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jLabel = new JLabel("Legend window");
        jLabel.setToolTipText("Options become effective after return and the Legend window is redrawn");
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add(jLabel);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.setAlignmentX(0.0f);
        super.add(jPanel);
        this.lst_LEGEND_PREVIEW_ORDER = new LabeledComboBox("LEGEND_PREVIEW_ORDER");
        this.lst_LEGEND_PREVIEW_ORDER.addItem(Boolean.TRUE);
        this.lst_LEGEND_PREVIEW_ORDER.addItem(Boolean.FALSE);
        this.lst_LEGEND_PREVIEW_ORDER.setToolTipText("Whether to arrange the legends with a hidden Preview order.");
        super.add(this.lst_LEGEND_PREVIEW_ORDER);
        this.lst_LEGEND_TOPOLOGY_ORDER = new LabeledComboBox("LEGEND_TOPOLOGY_ORDER");
        this.lst_LEGEND_TOPOLOGY_ORDER.addItem(Boolean.TRUE);
        this.lst_LEGEND_TOPOLOGY_ORDER.addItem(Boolean.FALSE);
        this.lst_LEGEND_TOPOLOGY_ORDER.setToolTipText("Whether to arrange the legends with a hidden Topology order.");
        super.add(this.lst_LEGEND_TOPOLOGY_ORDER);
        super.add(Box.createVerticalStrut(VERTICAL_GAP_HEIGHT));
        super.setBorder(BorderFactory.createEtchedBorder());
    }

    public void updateAllFieldsFromParameters() {
        this.fld_Y_AXIS_ROOT_LABEL.setText(Parameters.Y_AXIS_ROOT_LABEL);
        this.fld_INIT_SLOG2_LEVEL_READ.setShort(Parameters.INIT_SLOG2_LEVEL_READ);
        this.lst_AUTO_WINDOWS_LOCATION.setSelectedBooleanItem(Parameters.AUTO_WINDOWS_LOCATION);
        this.sdr_SCREEN_HEIGHT_RATIO.setFloat(Parameters.SCREEN_HEIGHT_RATIO);
        this.sdr_TIME_SCROLL_UNIT_RATIO.setFloat(Parameters.TIME_SCROLL_UNIT_RATIO);
        this.lst_Y_AXIS_ROOT_VISIBLE.setSelectedBooleanItem(Parameters.Y_AXIS_ROOT_VISIBLE);
        this.lst_ACTIVE_REFRESH.setSelectedBooleanItem(Parameters.ACTIVE_REFRESH);
        this.lst_BACKGROUND_COLOR.setSelectedItem(Parameters.BACKGROUND_COLOR);
        this.sdr_STATE_HEIGHT_FACTOR.setFloat(Parameters.STATE_HEIGHT_FACTOR);
        this.sdr_NESTING_HEIGHT_FACTOR.setFloat(Parameters.NESTING_HEIGHT_FACTOR);
        this.lst_ARROW_ANTIALIASING.setSelectedItem(Parameters.ARROW_ANTIALIASING);
        this.fld_MIN_WIDTH_TO_DRAG.setInteger(Parameters.MIN_WIDTH_TO_DRAG);
        this.fld_CLICK_RADIUS_TO_LINE.setInteger(Parameters.CLICK_RADIUS_TO_LINE);
        this.lst_LEFTCLICK_INSTANT_ZOOM.setSelectedBooleanItem(Parameters.LEFTCLICK_INSTANT_ZOOM);
        this.lst_STATE_BORDER.setSelectedItem(Parameters.STATE_BORDER);
        this.fld_ARROW_HEAD_LENGTH.setInteger(Parameters.ARROW_HEAD_LENGTH);
        this.fld_ARROW_HEAD_WIDTH.setInteger(Parameters.ARROW_HEAD_WIDTH);
        this.fld_EVENT_BASE_WIDTH.setInteger(Parameters.EVENT_BASE_WIDTH);
        this.lst_PREVIEW_STATE_DISPLAY.setSelectedItem(Parameters.PREVIEW_STATE_DISPLAY);
        this.lst_PREVIEW_STATE_BORDER.setSelectedItem(Parameters.PREVIEW_STATE_BORDER);
        this.fld_PREVIEW_STATE_BORDER_W.setInteger(Parameters.PREVIEW_STATE_BORDER_W);
        this.fld_PREVIEW_STATE_BORDER_H.setInteger(Parameters.PREVIEW_STATE_BORDER_H);
        this.fld_PREVIEW_STATE_LEGEND_H.setInteger(Parameters.PREVIEW_STATE_LEGEND_H);
        this.fld_PREVIEW_ARROW_LOG_BASE.setInteger(Parameters.PREVIEW_ARROW_LOG_BASE);
        this.fld_SEARCH_ARROW_LENGTH.setInteger(Parameters.SEARCH_ARROW_LENGTH);
        this.fld_SEARCH_FRAME_THICKNESS.setInteger(Parameters.SEARCH_FRAME_THICKNESS);
        this.lst_SEARCHED_OBJECT_ON_TOP.setSelectedBooleanItem(Parameters.SEARCHED_OBJECT_ON_TOP);
        this.lst_HISTOGRAM_ZERO_ORIGIN.setSelectedBooleanItem(Parameters.HISTOGRAM_ZERO_ORIGIN);
        this.lst_SUMMARY_STATE_BORDER.setSelectedItem(Parameters.SUMMARY_STATE_BORDER);
        this.fld_SUMMARY_ARROW_LOG_BASE.setInteger(Parameters.SUMMARY_ARROW_LOG_BASE);
        this.lst_LEGEND_PREVIEW_ORDER.setSelectedBooleanItem(Parameters.LEGEND_PREVIEW_ORDER);
        this.lst_LEGEND_TOPOLOGY_ORDER.setSelectedBooleanItem(Parameters.LEGEND_TOPOLOGY_ORDER);
    }

    public void updateAllParametersFromFields() {
        Parameters.Y_AXIS_ROOT_LABEL = this.fld_Y_AXIS_ROOT_LABEL.getText();
        Parameters.INIT_SLOG2_LEVEL_READ = this.fld_INIT_SLOG2_LEVEL_READ.getShort();
        Parameters.AUTO_WINDOWS_LOCATION = this.lst_AUTO_WINDOWS_LOCATION.getSelectedBooleanItem();
        Parameters.SCREEN_HEIGHT_RATIO = this.sdr_SCREEN_HEIGHT_RATIO.getFloat();
        Parameters.TIME_SCROLL_UNIT_RATIO = this.sdr_TIME_SCROLL_UNIT_RATIO.getFloat();
        Parameters.Y_AXIS_ROOT_VISIBLE = this.lst_Y_AXIS_ROOT_VISIBLE.getSelectedBooleanItem();
        Parameters.ACTIVE_REFRESH = this.lst_ACTIVE_REFRESH.getSelectedBooleanItem();
        Parameters.BACKGROUND_COLOR = (Alias)this.lst_BACKGROUND_COLOR.getSelectedItem();
        Parameters.STATE_HEIGHT_FACTOR = this.sdr_STATE_HEIGHT_FACTOR.getFloat();
        Parameters.NESTING_HEIGHT_FACTOR = this.sdr_NESTING_HEIGHT_FACTOR.getFloat();
        Parameters.ARROW_ANTIALIASING = (Alias)this.lst_ARROW_ANTIALIASING.getSelectedItem();
        Parameters.MIN_WIDTH_TO_DRAG = this.fld_MIN_WIDTH_TO_DRAG.getInteger();
        Parameters.CLICK_RADIUS_TO_LINE = this.fld_CLICK_RADIUS_TO_LINE.getInteger();
        Parameters.LEFTCLICK_INSTANT_ZOOM = this.lst_LEFTCLICK_INSTANT_ZOOM.getSelectedBooleanItem();
        Parameters.STATE_BORDER = (StateBorder)this.lst_STATE_BORDER.getSelectedItem();
        Parameters.ARROW_HEAD_LENGTH = this.fld_ARROW_HEAD_LENGTH.getInteger();
        Parameters.ARROW_HEAD_WIDTH = this.fld_ARROW_HEAD_WIDTH.getInteger();
        Parameters.EVENT_BASE_WIDTH = this.fld_EVENT_BASE_WIDTH.getInteger();
        Parameters.PREVIEW_STATE_DISPLAY = (String)this.lst_PREVIEW_STATE_DISPLAY.getSelectedItem();
        Parameters.PREVIEW_STATE_BORDER = (StateBorder)this.lst_PREVIEW_STATE_BORDER.getSelectedItem();
        Parameters.PREVIEW_STATE_BORDER_W = this.fld_PREVIEW_STATE_BORDER_W.getInteger();
        Parameters.PREVIEW_STATE_BORDER_H = this.fld_PREVIEW_STATE_BORDER_H.getInteger();
        Parameters.PREVIEW_STATE_LEGEND_H = this.fld_PREVIEW_STATE_LEGEND_H.getInteger();
        Parameters.PREVIEW_ARROW_LOG_BASE = this.fld_PREVIEW_ARROW_LOG_BASE.getInteger();
        Parameters.SEARCH_ARROW_LENGTH = this.fld_SEARCH_ARROW_LENGTH.getInteger();
        Parameters.SEARCH_FRAME_THICKNESS = this.fld_SEARCH_FRAME_THICKNESS.getInteger();
        Parameters.SEARCHED_OBJECT_ON_TOP = this.lst_SEARCHED_OBJECT_ON_TOP.getSelectedBooleanItem();
        Parameters.HISTOGRAM_ZERO_ORIGIN = this.lst_HISTOGRAM_ZERO_ORIGIN.getSelectedBooleanItem();
        Parameters.SUMMARY_STATE_BORDER = (StateBorder)this.lst_SUMMARY_STATE_BORDER.getSelectedItem();
        Parameters.SUMMARY_ARROW_LOG_BASE = this.fld_SUMMARY_ARROW_LOG_BASE.getInteger();
        Parameters.LEGEND_PREVIEW_ORDER = this.lst_LEGEND_PREVIEW_ORDER.getSelectedBooleanItem();
        Parameters.LEGEND_TOPOLOGY_ORDER = this.lst_LEGEND_TOPOLOGY_ORDER.getSelectedBooleanItem();
    }
}

