/*
 * Decompiled with CFR 0.152.
 */
package logformat.clog2;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import logformat.clog2.MixedDataInputStream;
import logformat.clog2.Preamble;

public class InputLog {
    private static final int INPUT_STREAM_BUFSIZE = 1024;
    private String filename;
    private DataInputStream main_ins;
    private Preamble preamble;
    private byte[] buffer;

    public InputLog(String string) {
        this.filename = string;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.filename);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            System.exit(0);
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream, 1024);
        this.main_ins = new DataInputStream(bufferedInputStream);
        this.preamble = new Preamble();
        this.preamble.readFromDataStream(this.main_ins);
        if (!this.preamble.isVersionMatched()) {
            if (!this.preamble.isVersionCompatible()) {
                System.err.println("Error: CLOG versions mismatched !\n\tThe input logfile version is " + this.preamble.getVersionString() + "\n" + "\t" + "But this tool is of version " + "CLOG-02.20");
                System.exit(1);
            } else {
                System.err.println("Warning: CLOG versions compatible !\n\tThe input logfile version is " + this.preamble.getVersionString() + "\n" + "\t" + "But this tool is of version " + "CLOG-02.20");
            }
        }
        if (!this.preamble.isBigEndian()) {
            System.err.println("Error: input logfile is little-endian!");
            System.exit(1);
        }
        this.buffer = null;
    }

    public String getFileName() {
        return this.filename;
    }

    public Preamble getPreamble() {
        return this.preamble;
    }

    public MixedDataInputStream getBlockStream() {
        if (this.main_ins == null) {
            System.err.println("Error: input_stream.main_ins == null !!");
            return null;
        }
        if (this.buffer == null) {
            this.buffer = new byte[this.preamble.getBlockSize()];
        }
        try {
            this.main_ins.readFully(this.buffer);
        }
        catch (EOFException eOFException) {
            return null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        return new MixedDataInputStream(new ByteArrayInputStream(this.buffer));
    }

    public void close() {
        try {
            this.main_ins.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }
}

