/*
 * Decompiled with CFR 0.152.
 */
package logformat.clog;

import java.io.DataInputStream;
import java.io.IOException;

public class RecHeader {
    private static final int BYTESIZE = 24;
    public double timestamp;
    public int rectype;
    public int length;
    public int taskID;
    private static int pad;

    public RecHeader() {
        this.timestamp = Double.MIN_VALUE;
        this.rectype = Integer.MIN_VALUE;
        this.length = Integer.MIN_VALUE;
        this.taskID = Integer.MIN_VALUE;
        pad = Integer.MIN_VALUE;
    }

    public RecHeader(DataInputStream dataInputStream) {
        this.readFromDataStream(dataInputStream);
    }

    public int readFromDataStream(DataInputStream dataInputStream) {
        try {
            this.timestamp = dataInputStream.readDouble();
            this.rectype = dataInputStream.readInt();
            this.length = dataInputStream.readInt();
            this.taskID = dataInputStream.readInt();
            pad = dataInputStream.readInt();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 0;
        }
        return 24;
    }

    public int skipBytesFromDataStream(DataInputStream dataInputStream) {
        try {
            dataInputStream.skipBytes(24);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 0;
        }
        return 24;
    }

    public RecHeader copy() {
        RecHeader recHeader = new RecHeader();
        recHeader.timestamp = this.timestamp;
        recHeader.rectype = this.rectype;
        recHeader.length = this.length;
        recHeader.taskID = this.taskID;
        return recHeader;
    }

    public int getRecType() {
        return this.rectype;
    }

    public String toString() {
        return "RecHeader[ timestamp=" + this.timestamp + ", rectype=" + this.rectype + ", length=" + this.length + ", taskID=" + this.taskID + " ]";
    }
}

