#! /bin/bash
#fixup routine (Makefile got too crowded.)
# 15 jul 2000 Junichi Uekawa -- taken from original MPICH fixup.sh
# 27 jan 2001 Junichi Uekawa <dancer@debian.org> -- modified a bit.
# 13 Oct 2001 Junichi Uekawa <dancer@debian.org> -- modified for 1.2.2.2 build system

echo Doing extra installation
#
# MPICH does seem to have "mpich/" and "mpich/debian/tmp" prefices
# and it needs to be hacked.
# -- this is because MPICH needs mpicc et al for installation
# and before installation is finished we cannot put it in 
# /usr/share/lib... etc. 
#
# only wreck script files or binary files being overwritten
# will cause major problems.
dir=`pwd`

#just to make sure "file" will output an understandable output
LANG=C
LC_ALL=C


for processes in mpich mpich-mpd mpich-shmem ; do
( 
  cd debian/${processes}-bin; 
  for d in usr/lib/${processes}/{bin,sbin,share/upshot/bin,share/examples,examples,examples/MPI-2-C++,etc}; do 
  (  
      cd ${d}
      echo Doing ${d}
      for x in $(grep -l ${dir} * 2>/dev/null); do
	  if (file ${x} | grep script ) || \
		  (file ${x} | grep text ); then 
	      echo Fixing ${x}
	      sed -e 's|/image_mpich/../debian/mpich||g' -e 's|/image_mpich-mpd/../debian/mpich-mpd||g' -e 's|'$(echo ${dir})'||g' -e 's|'${HOME}'|${HOME}|g' ${x} > ${x}.new
	      cp ${x}.new ${x}
	      rm ${x}.new ;
	  fi
      done )
  done
) done

