/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mouse Gestures for Mozilla.
 *
 * The Initial Developer of the Original Code is Jens Bannmann.
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s) (alphabetical order):
 *  Jens Bannmann <jens.b@web.de>
 *  Jochen <bugs@krickelkrackel.de>
 *  Neil <neil@parkwaycc.co.uk>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

var docTitle, dialogMode, acceptButton, actTemp, wType, docLoc, mgStatusPopup;
var gestureType, codeBox, wheelBtn, wheelDir, functionType, functionsTree, ftChildren, mappingName, customBox, keyBox, keyMappingName;
var startType, startCode, startName, startFunc, startCount;
var bmMappingName, bmTree, bmSelected, bmOpenIn, bmInfo, bmImage;
var mgRow1, mgRow2, mgRow3;
var bmDeleted = false;
var curMapping = false;
var bmp_attention = "chrome://mozgest/skin/attention.png";
var bmp_placeholder = "chrome://mozgest/skin/placeholder.png";

function initMain() {
  if (mgBMService.plEnabled)
    document.loadOverlay("chrome://browser/content/places/placesOverlay.xul", placesObserver);
  else
    initEditor();
}

var placesObserver = {
  observe: function(subject, topic, data) {
    var ssS = Components.classes["@mozilla.org/content/style-sheet-service;1"]
              .getService(Components.interfaces.nsIStyleSheetService);

    var sheet0 = mgBMService.makeURI("chrome://browser/content/places/places.css");
    var sheet1 = mgBMService.makeURI("chrome://browser/skin/places/places.css");

    if (!ssS.sheetRegistered(sheet0, ssS.USER_SHEET)) {
      ssS.loadAndRegisterSheet(sheet0, ssS.USER_SHEET);
      ssS.loadAndRegisterSheet(sheet1, ssS.USER_SHEET);
    }

    document.getElementById("mgPlacesTree").setAttribute("place",
    "place:queryType=1&excludeReadOnlyFolders=1&folder=" + PlacesUtils.allBookmarksFolderId);
    document.getElementById("mgPlacesTree").setAttribute("type", "places");
    initEditor();
  }
}

function initEditor() {
  acceptButton   = document.documentElement._buttons.accept;
  gestureType    = document.getElementById("gestureType");
  codeBox        = document.getElementById("codeBox");
  wheelBtn       = document.getElementById("wheelRockerButton");
  wheelDir       = document.getElementById("wheelDirection");
  functionType   = document.getElementById("functionType");
  functionsTree  = document.getElementById("functionsTree");
  ftChildren     = document.getElementById("ftChildren");
  mappingName    = document.getElementById("mappingName");
  bmMappingName  = document.getElementById("bmMappingName");
  keyMappingName = document.getElementById("keyMappingName");
  customBox      = document.getElementById("mgCustomCodeBox");
  keyBox         = document.getElementById("mozgestKeyBox")
  bmInfo         = document.getElementById("bmInfo");
  bmImage        = document.getElementById("bmImage");
  bmOpenIn       = document.getElementById("bmOpenIn");
  mgRow1         = document.getElementById("mgRow1");
  mgRow2         = mgRow1.nextSibling;
  mgRow3         = mgRow2.nextSibling;
  bmSelected     = "";

  mgComponentLoader.initMouseService(true);
  document.getElementById("mgRegcognizeButton").hidden = !mgNativeTrails;
  mgInitNotification();

  if (mgAppInfo.name != "Firefox")
    document.getElementById("sidebarItem").hidden = true;

  // get passed arguments
  // [0] == dialogMode (Edit, New or Import)
  // [1] == wType (window, browser, etc.)
  // [2] == gesture code
  dialogMode = window.arguments[0];
  wType = window.arguments[1];

  if (dialogMode != "Import")
    document.getElementById("mgPermissionButton").hidden = true;

  curMapping = window.arguments[2];
  initDirectionCodes();
  docTitle = mgGetString(dialogMode + "MappingWindow")
             + " - " + document.documentElement.getAttribute("mg" + wType);
  document.title = docTitle;

  // fill function list
  var curFuncts = _mgMS.functions[wType];

  for (func in curFuncts)
    mgCommon.addTreeRow(ftChildren, new Array(func, mgGetString(func)));

  if (wType != "window") {
    curFuncts = _mgMS.functions["window"];

    for (func in curFuncts)
      mgCommon.addTreeRow(ftChildren, new Array(func,mgGetString(func)), "mozgestGeneric");
  }

  // prepare for bookmark mappings
  if (wType != "browser" || dialogMode == "Import") {
    mgBMService.enabled = mgBMService.plEnabled = false;
    functionType._tabs.removeChild(functionType._tabs.lastChild);
  }

  if (mgBMService.enabled || mgBMService.plEnabled) {
    bmTree = (mgBMService.enabled) ?
              document.getElementById("mgBookmarksTree") : document.getElementById("mgPlacesTree");
    bmTree.removeAttribute("hidden");
    (mgBMService.enabled) ? updateInfoBox(true) : plUpdateInfoBox(true);;
  }

  actTemp = _mgMS.actTemp;

  if (dialogMode == "New") {
    if (_mgMS.curBookmark) {
      bmSelected = _mgMS.curBookmark;
      _mgMS.curBookmark = null;
      bmMappingName.value = _mgMS.curBookmarkName;

      if (mgBMService.enabled)
        bmInit();
      else if (mgBMService.plEnabled)
        setTimeout(plInit, 0);

      functionType.selectedTab = functionType.getElementsByAttribute("gestureType", "9")[0];
    }
  return;
  }

  if (dialogMode == "Edit") {
    startCode = curMapping;

    if (actTemp[wType][curMapping].name)
      startName = actTemp[wType][curMapping].name;

    startFunc = actTemp[wType][curMapping].func;
    startCount = actTemp[wType][curMapping].count;
    setGestureType();

    var fType = startType = actTemp[wType][curMapping].type;

    if (!fType) {
      fType = startType = "";
      try {
        for (var x = 0; x < ftChildren.childNodes.length; x++) {
          var funcName = functionsTree.view.getCellText(x, functionsTree.columns["ftFuncCol"]);

          if (funcName == actTemp[wType][curMapping].func) {
            functionsTree.view.selection.select(x);
            functionsTree.boxObject.ensureRowIsVisible(x);
            break;
          }
        }
      }
      catch (e) {}
    }
    else {
      fType = fType.toString();

      if (fType == "1") {
        mappingName.value = decodeURIComponent(actTemp[wType][curMapping].name);
        customBox.value = decodeURIComponent(actTemp[wType][curMapping].func);
      }
      if (fType == "2") {
        keyMappingName.value = decodeURIComponent(actTemp[wType][curMapping].name);
        keyBox.value = actTemp[wType][curMapping].func;
      }
      if (fType.indexOf("9") == 0) {
        bmMappingName.value = decodeURIComponent(actTemp[wType][curMapping].name);
        bmSelected = actTemp[wType][curMapping].func;
        bmOpenIn.selectedIndex = fType.toString().substring(1, 2);

        if (mgAppInfo.name != "Firefox" && bmOpenIn.selectedIndex == 4)
          bmOpenIn.selectedIndex = 0;

        bmOpenIn.disabled = false;

        if (mgBMService.enabled)
          bmInit();
        else if (mgBMService.plEnabled)
          setTimeout(plInit, 0);
      }
      functionType.selectedTab = functionType.getElementsByAttribute("gestureType",
                                 fType.substring(0,1))[0];
    }
  }

  if (dialogMode == "Import") {
    setGestureType();
    importGesture();
  }

  updateTypeDeck();
}

function importGesture() {
  docLoc = mgBMService.makeURI(_mgMS.importLocation);
  mgPrefs.prefs.QueryInterface(Components.interfaces.nsIPrefBranchInternal)
               .addObserver("", mgPermissionObserver, false);
  checkPermissions();

  if (_mgMS.importName)
    mappingName.value = _mgMS.importName;

  // if _mgMS.importFunc is null than it is a custom gesture!
  if (!_mgMS.importFunc) {
    customBox.value = _mgMS.importCustom;
    functionType.selectedIndex = 1;
  }
  else {
    try {
      for (var x = 0; x < ftChildren.childNodes.length; x++) {
        var funcName = functionsTree.view.getCellText(x, functionsTree.columns["ftFuncCol"]);
        if (funcName == _mgMS.importFunc) {
          functionsTree.view.selection.select(x);
          break;
        }
      }
    }
    catch (e) {}
  }
}

function bmInit() {
  try {
    var sel = bmTree.view.getIndexOfResource(mgBMService.RDFS.GetResource(bmSelected));
    bmTree.builderView.selection.select(sel);
  }
  catch (e) {}

  var elt = mgBMService.RDFS.GetResource(bmSelected);
  var target = mgBMService.Book.GetTarget(elt, mgBMService.Href, true);

  // mapping with an unknown(deleted) bookmark
  if (!target)
    bmOpenIn.disabled = bmDeleted = true;

  updateInfoBox();

  // new gesture from bookmark properties -> prefill mappingname
  if (dialogMode == "New" && target) {
    var bmName = mgBMService.Book.GetTarget(elt, mgBMService.Name, true);
    if (bmName)
      bmMappingName.value = bmName.QueryInterface(Components.interfaces.nsIRDFLiteral).Value;
  }
}

function plInit() {
  var target = false;
  try {
    target = mgBMService.plBook.getBookmarkURI(mgBMService.plBook.getItemIdForGUID(bmSelected));
  }
  catch (e) {}

  // mapping with an unknown(deleted) bookmark
  if (!target)
    bmOpenIn.disabled = bmDeleted = true;

  plUpdateInfoBox();

  // new gesture from bookmark properties -> prefill mappingname
  if (dialogMode == "New" && target) {
    var bmName = mgBMService.plBook.getItemTitle(mgBMService.plBook.getItemIdForGUID(bmSelected));
    if (bmName != "")
      bmMappingName.value = bmName;
    else
      bmMappingName.value = mgGetString("noName");
  }
}

function bmSelect(e) {
  if (e && e.type == "dblclick") {
    if (!bmOpenIn.disabled)
      bmMappingName.value = bmInfo.value;

    return;
  }

  var elt = bmTree.view.getResourceAtIndex(e.target.currentIndex);
  var target = mgBMService.Book.GetTarget(elt, mgBMService.Href, true)

  // check for livemarks
  try {
    var check = mgBMService.Book.GetTarget(elt, mgBMService.Type, true);
    check = check.QueryInterface(Components.interfaces.nsIRDFResource).Value.toLowerCase();

    if (check == "http://home.netscape.com/nc-rdf#livemark")
      target = false;
    else {
      var eltParent = bmTree.view.getResourceAtIndex(bmTree.view.getParentIndex(e.target.currentIndex));
      check = mgBMService.Book.GetTarget(eltParent, mgBMService.Type, true);
      check = check.QueryInterface(Components.interfaces.nsIRDFResource).Value.toLowerCase();

      if (check == "http://home.netscape.com/nc-rdf#livemark")
        target = false;
    }
  }
  catch (e) {}

  bmOpenIn.disabled = !target;

  if (target)
    bmSelected = elt.QueryInterface(Components.interfaces.nsIRDFNode).Value;
  else
    bmSelected = "";

  updateInfoBox();
}

function plSelect(e) {
  if (e && e.type == "dblclick") {
    if (!bmOpenIn.disabled)
      bmMappingName.value = bmInfo.value;

    return;
  }

  var target = bmTree.selectedNode;

  if (!target || target.type != 0)
    bmSelected = "";
  else if (target) {
    try {
      bmSelected = mgBMService.plBook.getItemGUID(target.itemId);
    }
    catch (e) {
      bmSelected = "";
    }
  }

  bmOpenIn.disabled = (bmSelected == "") ? true : false;
  plUpdateInfoBox();
}

function resetInfoBox(emptyNew, bmHref) {
  if (!bmHref) {
    mgRow1.hidden = mgRow2.hidden = mgRow3.hidden = true;

    if (emptyNew) {
      bmInfo.value = mgRow2.value = mgGetString("chooseBM");
      mgRow2.hidden = false;
      bmOpenIn.disabled = true;
      return false;
    }

    if (bmSelected == "" || bmDeleted) {
      mgRow2.value = mgGetString("chooseBM");
      bmImage.src = bmp_attention;

      if (bmDeleted)
        bmInfo.value = mgRow1.value = mgGetString("unknownBookmark");
      else
        bmInfo.value = mgRow1.value = mgGetString("notValid");

      mgRow1.hidden = mgRow2.hidden = false;
      bmDeleted = false;
      return false;
    }
  }
  else {
    bmOpenIn.disabled = false;
    var mC = bmOpenIn.menupopup.childNodes;

    for (var i = 0; i < mC.length; i++)
      mC[i].removeAttribute("disabled");

    if (bmHref.scheme == "javascript") {
      for (i = 1; i < mC.length; i++)
        mC[i].setAttribute("disabled", true);

      bmOpenIn.selectedIndex = 0;
      mgRow2.value = mgGetString("bmBookmarklet");
    }
    else if (bmHref.spec.indexOf("%s") != -1)
      mgRow2.value = mgGetString("bmSearch");
    else
      mgRow2.value = mgGetString("bmBookmark");

    //var bmPost = mgBMService.Book.GetTarget(mgBMService.RDFS.GetResource(bmSelected),
    //                                        mgBMService.Post, true);

    //if (bmPost) {
    //        bmPost = unescape(bmPost.QueryInterface(Components.interfaces.nsIRDFLiteral).Value);
    //        if (bmPost.indexOf("%s") != -1)
    //                mgRow2.value = mgGetString("bmSearch");
    //}

     mgRow2.value = mgGetString("bmType") + mgRow2.value;
     mgRow3.value = mgGetString("bmHref") + bmHref.spec;
     mgRow2.hidden = mgRow3.hidden = false;
   }
   return true;
}

function updateInfoBox(emptyNew) {
  if (!resetInfoBox(emptyNew))
    return;

  var bmName = mgBMService.Book.GetTarget(mgBMService.RDFS.GetResource(bmSelected),
               mgBMService.Name, true);
  if (bmName)
    bmName = bmName.QueryInterface(Components.interfaces.nsIRDFLiteral).Value
  else
    bmName = mgGetString("noName");

  bmInfo.value = mgRow1.value = bmName;
  mgRow1.value = mgGetString("bmName") + mgRow1.value;
  mgRow1.hidden = false;

  var bmHref = mgBMService.Book.GetTarget(mgBMService.RDFS.GetResource(bmSelected),
                                          mgBMService.Href, true);

  if (bmHref) {
    bmHref = mgBMService.makeURI(bmHref.QueryInterface(Components.interfaces.nsIRDFLiteral).Value);
    resetInfoBox(null, bmHref);
  }

  var bmIcon = mgBMService.Book.GetTarget(mgBMService.RDFS.GetResource(bmSelected),
                                          mgBMService.Icon, true);

  if (bmIcon)
    bmImage.src = bmIcon.QueryInterface(Components.interfaces.nsIRDFLiteral).Value;
  else
    bmImage.src = bmp_placeholder;
}

function plUpdateInfoBox(emptyNew) {
  if (!resetInfoBox(emptyNew))
    return;

  var bmName = mgBMService.plBook.getItemTitle(mgBMService.plBook.getItemIdForGUID(bmSelected));

  if (bmName == "")
    bmName = mgGetString("noName");

  bmInfo.value = mgRow1.value = bmName;
  mgRow1.value = mgGetString("bmName") + mgRow1.value;
  mgRow1.hidden = false;

  var bmHref = mgBMService.plBook.getBookmarkURI(mgBMService.plBook.getItemIdForGUID(bmSelected));

  resetInfoBox(null, bmHref);
  bmImage.src = mgBMService.plIcon.getFaviconImageForPage(bmHref).spec;
}

function setGestureType() {
  if (curMapping.substr(0, 1) == ":") {
    var a = curMapping.substr(1, 1);
    var b = curMapping.substr(2, 1);

    if (!isNaN(b)) {
      gestureType.selectedIndex = 1;
      document.getElementById("rocker1").selectedIndex = parseInt(a)+1;
      document.getElementById("rocker2").selectedIndex = parseInt(b)+1;
    }
    else {
      gestureType.selectedIndex = 2;
      wheelBtn.selectedIndex = parseInt(a)+1;
      wheelDir.selectedIndex = (b == "+") ? 1 : 0;
    }
  }
  else
    codeBox.value = mgMappingLocalizer.localize(curMapping);
}

function updateTypeDeck() {
  document.getElementById("gestureTypeDeck")
          .selectedIndex = gestureType.selectedIndex;
}

function updateSecondRocker(r1) {
  var r2 = document.getElementById("rocker2");
  var c = r2.menupopup.childNodes;

  for (var i=1; i < c.length; i++) {
    c[i].removeAttribute("disabled");

    if (r1.selectedIndex == i)
      c[i].setAttribute("disabled", true);
  }

  if (r1.selectedIndex == r2.selectedIndex && r2.selectedIndex != 0)
    r2.selectedIndex = 0;
}

function checkPermissions() {
  var permButton = document.getElementById("mgPermissionButton");
  permButton.hidden = false;
  permButton.setAttribute("tooltiptext", mgGetString("permButtonLabel1"));
  permButton.removeAttribute("mgAllowImport");
  acceptButton.disabled = true;

  var allowedHosts = mgPrefs.prefs.getCharPref("importFrom").split("|");
  var allow = (docLoc.scheme == "file") ? true : false;

  if (!allow) {
    for (var x = 0; x < allowedHosts.length; x++) {
      if (allowedHosts[x] == docLoc.host) {
        allow = true;
        break;
      }
    }
  }

  if (allow) {
    acceptButton.disabled = false;
    permButton.setAttribute("tooltiptext", mgGetString("permButtonLabel0"));
    permButton.setAttribute("mgAllowImport", true);
  }
}

var mgPermissionObserver = {
  observe: function(subject, topic, data) {
    if (topic.indexOf("nsPref") == 0) {
      if (data == "importFrom")
        checkPermissions();
    }
  }
}

function removeObserver() {
  try {
    mgPrefs.prefs.QueryInterface(Components.interfaces.nsIPrefBranchInternal)
                          .removeObserver("", mgPermissionObserver);
  }
  catch (e) {}
}

function saveMapping() {
  var code = mgMappingLocalizer.deLocalize(codeBox.value);

  if (gestureType.selectedIndex == 0) {
    if (code.substring(0,1) == "*") {
      if (code.length < 3 || code.length > 4) {
        alert(mgGetString("enterGesture"));
        return false;
      }
    }

    if (!code.match(/^\*{0,1}[1379DLUR]+$/)
        || mgCommon.compactCode(code) != code) {
                        alert(mgGetString("enterGesture"));
      return false;
    }
  }
  else if (gestureType.selectedIndex == 1) {
    var a = document.getElementById("rocker1").selectedIndex -1;
    var b = document.getElementById("rocker2").selectedIndex -1;

    if (a == -1 || b == -1) {
      alert(mgGetString("chooseRockerButtons"));
      return false;
    }
    code = ":" + a + b;
  }
  else if (gestureType.selectedIndex == 2) {
    var wb = wheelBtn.selectedIndex -1;
    var wd = wheelDir.selectedIndex;

    if (wd == -1 || wb == -1) {
      alert(mgGetString("chooseWheelDirBtn"));
      return false;
    }
    code = ":" +        wb + ((wd == 1) ? "+" : "-");
  }

  var type   = parseInt(functionType.selectedTab.getAttribute("gestureType"));
  var name   = null;
  var func   = null;
  var count  = 0;

  if (type == 1) { // custom gesture
    name = mappingName.value;

    if (name == "") {
      alert(mgGetString("enterMappingName"));
      return false;
    }

    if (customBox.value == "") {
      alert(mgGetString("chooseFunction"));
      return false;
    }

    name = encodeURIComponent(name);
    func = encodeURIComponent(customBox.value);
  }
  else if (type == 2) { // keyboard gesture
    name = keyMappingName.value;

    if (name == "") {
      alert(mgGetString("enterMappingName"));
      return false;
    }

    if (keyBox.value == "") {
      alert("Enter a key code");
      return false;
    }

    name = encodeURIComponent(name);
    func = keyBox.value;
  }
  else if (type == 9) { // bookmark gesture
    name = bmMappingName.value;

    if (name == "") {
      alert(mgGetString("enterMappingName"));
      return false;
    }

    if (bmSelected == "" || bmOpenIn.disabled) {
      alert(mgGetString("chooseBM"));
      return false;
    }

    name = encodeURIComponent(name);
    func = bmSelected;
    type = type.toString() + bmOpenIn.selectedIndex.toString();
  }
  else { // normal gesture
    var row = functionsTree.contentView.selection.currentIndex;
    if (row == -1) {
      alert(mgGetString("chooseFunction"));
      return false;
    }

    func = functionsTree.view.getCellText(row, functionsTree.columns["ftFuncCol"]);
  }

  var conf = true;

  if (code in actTemp[wType] && code != startCode) {
    var msg = mgGetString("overwriteWarning");
    var xName;

    if (actTemp[wType][code].name)
      xName = decodeURIComponent(actTemp[wType][code].name);
    else
      xName = mgGetString(actTemp[wType][code].func);

    msg = msg.replace(/%MAPPINGNAME%/, xName);
    var dc = mgMappingLocalizer.localize(code);
    msg = msg.replace(/%CODE%/, dc);
    conf = confirm(msg);
  }

  if (conf) {
    if (dialogMode == "Edit") {
      // let us check if there were changes
      if (type != startType || code != startCode ||
          name != startName || func != startFunc) {
        // if code was changed, we have to remove the original gesture
        if (code != startCode) {
          //rebuild actTemp without startCode
          var temp = actTemp[wType];
          actTemp[wType] = new Array();

          for (mapping in temp) {
            if (mapping == startCode)
              continue;

            actTemp[wType][mapping] = temp[mapping];
          }
          // if startCode was a default gesture: add an entry to defTemp
          if (startCode in _mgMS.defaultMappings[wType])
            _mgMS.defTemp[wType][startCode] = _mgMS.defaultMappings[wType][startCode];
        }
        else
          count = startCount;
      }
      else
        return true;
    }

    // if code is a default gesture: add an entry to defTemp
    if (code in _mgMS.defaultMappings[wType])
      _mgMS.defTemp[wType][code] = _mgMS.defaultMappings[wType][code];

    // add the mapping to actTemp
    _mgMS.addMapping(wType, code, type, name, func, count);
  }
  else
    return false;

  return true;
}

function cancelDialog() {
  if (document.getElementById('contentDeck').selectedIndex == 1) {
    showRecognizer(false);
    return false;
  }

  return true;
}

// recognizer
var mgWindowType;
var gestureEngineInit = false;

// "embedding" the gesture engine
function showRecognizer(aBool) {
  mgWindowType = wType;
  mgStatusPopup.hidePopup();
  acceptButton.hidden = aBool;
  document.getElementById('contentDeck').selectedIndex = (aBool) ? 1 : 0;
  document.title = (aBool) ? document.documentElement.getAttribute("titleRecognizer") : docTitle;

  if (gestureEngineInit)
    return;

  mgLoadStrings();
  mgPrefs.enableStrokes = mgPrefs["trails.enabled"] =
                          gestureEngineInit = mgPrefs["status.enabled"] = true;
  mgPrefs.enableRockers = mgPrefs.enableWheelRockers = false;
  mgAddWindowWatch();
}

//fillKeys
function fillKeyBox(e) {
  e.preventDefault();
  e.stopPropagation();

  keyBox.value = e.ctrlKey + "|" + e.altKey + "|" + e.shiftKey + "|" +
                 e.metaKey + "|" + e.keyCode + "|" + e.charCode;
}

function mgGetContentArea() {
  return document.getElementById("gestureArea");
}

function mgGetAutoScrollArea() {
  return mgGetContentArea();
}

function mgFireGesture(code) {
  codeBox.value = mgMappingLocalizer.localize(code);
  showRecognizer(false);
  return;
}

// the following dummy functions are needed because
// we did not load gestures.js and windowTypes.js.
var mgFireStatic = {
  setTime:function(){},
  clearTime:function(){}
}
function mgExamineHoveredElement() {
  return true;
}
function mgCheckForRocker() {
  return false;
}
function mgReleaseRocker() {
  return;
}
function mgResetRocker() {
  return;
}
function mgMousewheelHandler() {
  return;
}
function mgGetSelection() {
  return;
}