# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.

from elisa.plugins.pigment.widgets.widget import Widget
from elisa.plugins.pigment.widgets.const import *

from elisa.plugins.pigment.graph.text import Text
from elisa.plugins.pigment.graph import TEXT_ELLIPSIZE_END


class Label(Widget):
    """
    A widget displaying text.

    @ivar text: the text of the label
    @type text: unicode
    """

    def __init__(self):
        super(Label, self).__init__()

        self._text = None

        self._text = Text()
        self._text.bg_color = (0, 0, 0, 0)
        self._text.fg_color = (255, 255, 255, 255)
        self._text.ellipsize = TEXT_ELLIPSIZE_END
        self._text.visible = True

        self.add(self._text)

        self.update_style_properties(self.style.get_items())

    def text__get(self):
        """Get the label's text"""
        return unicode(self._text.label)

    def text__set(self, value):
        """Set the label's text"""
        self._text.label = value or ''

    text = property(text__get, text__set)

    @classmethod
    def _demo_widget(cls, *args, **kwargs):
        widget = cls()
        widget.text = "Hola!"
        widget.size = (100.0, 10.0)
        widget.visible = True

        return widget


if __name__ == '__main__':
    import logging
    logger = logging.getLogger()
    logger.setLevel(logging.DEBUG)

    label = Label.demo()
    try:
        __IPYTHON__
    except NameError:
        import pgm
        pgm.main()
