﻿using System;
using System.Windows;
using System.Windows.Automation.Peers;
using System.Windows.Browser;
using System.Windows.Controls;
using System.Windows.Controls.Primitives;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Interop;
using System.Windows.Markup;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Media.Imaging;
using System.Windows.Resources;
using System.Windows.Shapes;
using System.Windows.Threading;

using Microsoft.VisualStudio.TestTools.UnitTesting;
using Mono.Moonlight.UnitTesting;
using System.Collections.Generic;
using System.Collections.ObjectModel;

namespace MoonTest.System.Windows
{
    public partial class EventTriggerTest
    {
        [TestMethod]
        public void Test_PropertyGetter_EventTrigger ()
        {
            EventTrigger widget = new EventTrigger ();

            Assert.IsNotNull(widget.Actions, "Actions should not have returned null");
            Assert.IsTrue(widget.Actions is TriggerActionCollection, "Actions is not of the correct type");
            Assert.IsNull(widget.RoutedEvent, "RoutedEvent should have returned null");
        }

    }
}
namespace MoonTest.System.Windows
{
    public partial class TriggerActionCollectionTest
    {
        [TestMethod]
        public void Test_PropertyGetter_TriggerActionCollection ()
        {
            TriggerActionCollection widget = new TriggerActionCollection ();

            Assert.AreEqual(false, widget.IsFixedSize, "IsFixedSize does not match the default value");
            Assert.AreEqual(false, widget.IsReadOnly, "IsReadOnly does not match the default value");
            Assert.AreEqual(0, widget.Count, "Count does not match the default value");
            Assert.AreEqual(false, widget.IsSynchronized, "IsSynchronized does not match the default value");
            Assert.IsNotNull(widget.SyncRoot, "SyncRoot should not have returned null");
            Assert.IsTrue(widget.SyncRoot is TriggerActionCollection, "SyncRoot is not of the correct type");
        }

    }
}
namespace MoonTest.System.Windows
{
    public partial class AssemblyPartTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_AssemblyPart ()
        {
            AssemblyPart widget = new AssemblyPart ();
            object retval;

            retval = widget.ReadLocalValue(AssemblyPart.SourceProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(AssemblyPart.SourceProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_AssemblyPart ()
        {
            AssemblyPart widget = new AssemblyPart ();
            object retval;

            retval = widget.GetValue(AssemblyPart.SourceProperty);
            Assert.IsNotNull(retval, "GetValue(AssemblyPart.SourceProperty) should not have returned null");
            Assert.IsTrue(retval is string, "GetValue(AssemblyPart.SourceProperty) is not of the correct type");
            Assert.AreEqual("", retval, "GetValue(AssemblyPart.SourceProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_AssemblyPart ()
        {
            AssemblyPart widget = new AssemblyPart ();

            Assert.IsNotNull(widget.Source, "Source should not have returned null");
            Assert.AreEqual("", widget.Source, "Source does not match the default value");
        }

        [TestMethod]
	[MoonlightBug]
        public void Test_SetStringValue_AssemblyPart ()
        {
            AssemblyPart widget = new AssemblyPart ();
            object retval;

            widget.SetValue(AssemblyPart.SourceProperty, "some text");
            retval = widget.GetValue(AssemblyPart.SourceProperty);
            Assert.AreEqual("some text", retval, "GetValue(AssemblyPart.SourceProperty) should have returned 'some text'");
            widget.SetValue(AssemblyPart.SourceProperty, null);
            retval = widget.GetValue(AssemblyPart.SourceProperty);
            Assert.AreEqual(String.Empty, retval, "GetValue(AssemblyPart.SourceProperty) should have returned String.Empty");
            retval = widget.ReadLocalValue(AssemblyPart.SourceProperty);
            Assert.AreEqual(String.Empty, retval, "ReadLocalValue(AssemblyPart.SourceProperty) should have returned String.Empty");
        }

    }
}
namespace MoonTest.System.Windows
{
    public partial class AssemblyPartCollectionTest
    {
        [TestMethod]
        public void Test_PropertyGetter_AssemblyPartCollection ()
        {
            AssemblyPartCollection widget = new AssemblyPartCollection ();

            Assert.AreEqual(false, widget.IsFixedSize, "IsFixedSize does not match the default value");
            Assert.AreEqual(false, widget.IsReadOnly, "IsReadOnly does not match the default value");
            Assert.AreEqual(0, widget.Count, "Count does not match the default value");
            Assert.AreEqual(false, widget.IsSynchronized, "IsSynchronized does not match the default value");
            Assert.IsNotNull(widget.SyncRoot, "SyncRoot should not have returned null");
            Assert.IsTrue(widget.SyncRoot is AssemblyPartCollection, "SyncRoot is not of the correct type");
        }

    }
}
namespace MoonTest.System.Windows
{
    public partial class DataTemplateTest
    {
    }
}
namespace MoonTest.System.Windows
{
    public partial class StyleTest
    {
        [TestMethod]
        public void Test_PropertyGetter_Style ()
        {
            Style widget = new Style ();

            Assert.AreEqual(false, widget.IsSealed, "IsSealed does not match the default value");
            Assert.IsNotNull(widget.Setters, "Setters should not have returned null");
            Assert.IsTrue(widget.Setters is SetterBaseCollection, "Setters is not of the correct type");
            Assert.IsNull(widget.TargetType, "TargetType should have returned null");
        }

    }
}
namespace MoonTest.System.Windows
{
    public partial class SetterTest
    {
        [TestMethod]
        public void Test_PropertyGetter_Setter ()
        {
            Setter widget = new Setter ();

            Assert.IsNull(widget.Value, "Value should have returned null");
            Assert.IsNull(widget.Property, "Property should have returned null");
            Assert.AreEqual(false, widget.IsSealed, "IsSealed does not match the default value");
        }

    }
}
namespace MoonTest.System.Windows
{
    public partial class SetterBaseCollectionTest
    {
        [TestMethod]
        public void Test_PropertyGetter_SetterBaseCollection ()
        {
            SetterBaseCollection widget = new SetterBaseCollection ();

            Assert.AreEqual(false, widget.IsSealed, "IsSealed does not match the default value");
            Assert.AreEqual(false, widget.IsFixedSize, "IsFixedSize does not match the default value");
            Assert.AreEqual(false, widget.IsReadOnly, "IsReadOnly does not match the default value");
            Assert.AreEqual(0, widget.Count, "Count does not match the default value");
            Assert.AreEqual(false, widget.IsSynchronized, "IsSynchronized does not match the default value");
            Assert.IsNotNull(widget.SyncRoot, "SyncRoot should not have returned null");
            Assert.IsTrue(widget.SyncRoot is SetterBaseCollection, "SyncRoot is not of the correct type");
        }

    }
}
namespace MoonTest.System.Windows
{
    public partial class VisualStateTest
    {
        [TestMethod]
        public void Test_PropertyGetter_VisualState ()
        {
            VisualState widget = new VisualState ();

            Assert.IsNotNull(widget.Name, "Name should not have returned null");
            Assert.AreEqual("", widget.Name, "Name does not match the default value");
            Assert.IsNull(widget.Storyboard, "Storyboard should have returned null");
        }

    }
}
namespace MoonTest.System.Windows.Ink
{
    public partial class StrokeCollectionTest
    {
        [TestMethod]
        public void Test_PropertyGetter_StrokeCollection ()
        {
            StrokeCollection widget = new StrokeCollection ();

            Assert.AreEqual(false, widget.IsFixedSize, "IsFixedSize does not match the default value");
            Assert.AreEqual(false, widget.IsReadOnly, "IsReadOnly does not match the default value");
            Assert.AreEqual(0, widget.Count, "Count does not match the default value");
            Assert.AreEqual(false, widget.IsSynchronized, "IsSynchronized does not match the default value");
            Assert.IsNotNull(widget.SyncRoot, "SyncRoot should not have returned null");
            Assert.IsTrue(widget.SyncRoot is StrokeCollection, "SyncRoot is not of the correct type");
        }

    }
}
namespace MoonTest.System.Windows.Ink
{
    public partial class DrawingAttributesTest
    {
        [TestMethod]
        public void Test_PropertyGetter_DrawingAttributes ()
        {
            DrawingAttributes widget = new DrawingAttributes ();

            Assert.AreEqual("#FF000000", widget.Color.ToString (), "Color does not match the default value");
            Assert.AreEqual("#00000000", widget.OutlineColor.ToString (), "OutlineColor does not match the default value");
            Assert.AreEqual((double) 3, widget.Width, "Width does not match the default value");
            Assert.AreEqual((double) 3, widget.Height, "Height does not match the default value");
        }

    }
}
namespace MoonTest.System.Windows.Media
{
    public partial class DoubleCollectionTest
    {
        [TestMethod]
        public void Test_PropertyGetter_DoubleCollection ()
        {
            DoubleCollection widget = new DoubleCollection ();

            Assert.AreEqual(false, widget.IsFixedSize, "IsFixedSize does not match the default value");
            Assert.AreEqual(false, widget.IsReadOnly, "IsReadOnly does not match the default value");
            Assert.AreEqual(0, widget.Count, "Count does not match the default value");
            Assert.AreEqual(false, widget.IsSynchronized, "IsSynchronized does not match the default value");
            Assert.IsNotNull(widget.SyncRoot, "SyncRoot should not have returned null");
            Assert.IsTrue(widget.SyncRoot is DoubleCollection, "SyncRoot is not of the correct type");
        }

    }
}
namespace MoonTest.System.Windows.Media
{
    public partial class PointCollectionTest
    {
        [TestMethod]
        public void Test_PropertyGetter_PointCollection ()
        {
            PointCollection widget = new PointCollection ();

            Assert.AreEqual(false, widget.IsFixedSize, "IsFixedSize does not match the default value");
            Assert.AreEqual(false, widget.IsReadOnly, "IsReadOnly does not match the default value");
            Assert.AreEqual(0, widget.Count, "Count does not match the default value");
            Assert.AreEqual(false, widget.IsSynchronized, "IsSynchronized does not match the default value");
            Assert.IsNotNull(widget.SyncRoot, "SyncRoot should not have returned null");
            Assert.IsTrue(widget.SyncRoot is PointCollection, "SyncRoot is not of the correct type");
        }

    }
}
namespace MoonTest.System.Windows.Media
{
    public partial class RotateTransformTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_RotateTransform ()
        {
            RotateTransform widget = new RotateTransform ();
            object retval;

            retval = widget.ReadLocalValue(RotateTransform.CenterXProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(RotateTransform.CenterXProperty) should not have a value by default");
            retval = widget.ReadLocalValue(RotateTransform.CenterYProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(RotateTransform.CenterYProperty) should not have a value by default");
            retval = widget.ReadLocalValue(RotateTransform.AngleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(RotateTransform.AngleProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_RotateTransform ()
        {
            RotateTransform widget = new RotateTransform ();
            object retval;

            retval = widget.GetValue(RotateTransform.CenterXProperty);
            Assert.IsNotNull(retval, "GetValue(RotateTransform.CenterXProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(RotateTransform.CenterXProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(RotateTransform.CenterXProperty) does not match the default value");
            retval = widget.GetValue(RotateTransform.CenterYProperty);
            Assert.IsNotNull(retval, "GetValue(RotateTransform.CenterYProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(RotateTransform.CenterYProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(RotateTransform.CenterYProperty) does not match the default value");
            retval = widget.GetValue(RotateTransform.AngleProperty);
            Assert.IsNotNull(retval, "GetValue(RotateTransform.AngleProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(RotateTransform.AngleProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(RotateTransform.AngleProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_RotateTransform ()
        {
            RotateTransform widget = new RotateTransform ();

            Assert.AreEqual((double) 0, widget.CenterX, "CenterX does not match the default value");
            Assert.AreEqual((double) 0, widget.CenterY, "CenterY does not match the default value");
            Assert.AreEqual((double) 0, widget.Angle, "Angle does not match the default value");
        }

    }
}
namespace MoonTest.System.Windows.Media
{
    public partial class ScaleTransformTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_ScaleTransform ()
        {
            ScaleTransform widget = new ScaleTransform ();
            object retval;

            retval = widget.ReadLocalValue(ScaleTransform.CenterXProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(ScaleTransform.CenterXProperty) should not have a value by default");
            retval = widget.ReadLocalValue(ScaleTransform.CenterYProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(ScaleTransform.CenterYProperty) should not have a value by default");
            retval = widget.ReadLocalValue(ScaleTransform.ScaleXProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(ScaleTransform.ScaleXProperty) should not have a value by default");
            retval = widget.ReadLocalValue(ScaleTransform.ScaleYProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(ScaleTransform.ScaleYProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_ScaleTransform ()
        {
            ScaleTransform widget = new ScaleTransform ();
            object retval;

            retval = widget.GetValue(ScaleTransform.CenterXProperty);
            Assert.IsNotNull(retval, "GetValue(ScaleTransform.CenterXProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(ScaleTransform.CenterXProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(ScaleTransform.CenterXProperty) does not match the default value");
            retval = widget.GetValue(ScaleTransform.CenterYProperty);
            Assert.IsNotNull(retval, "GetValue(ScaleTransform.CenterYProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(ScaleTransform.CenterYProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(ScaleTransform.CenterYProperty) does not match the default value");
            retval = widget.GetValue(ScaleTransform.ScaleXProperty);
            Assert.IsNotNull(retval, "GetValue(ScaleTransform.ScaleXProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(ScaleTransform.ScaleXProperty) is not of the correct type");
            Assert.AreEqual((double) 1, retval, "GetValue(ScaleTransform.ScaleXProperty) does not match the default value");
            retval = widget.GetValue(ScaleTransform.ScaleYProperty);
            Assert.IsNotNull(retval, "GetValue(ScaleTransform.ScaleYProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(ScaleTransform.ScaleYProperty) is not of the correct type");
            Assert.AreEqual((double) 1, retval, "GetValue(ScaleTransform.ScaleYProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_ScaleTransform ()
        {
            ScaleTransform widget = new ScaleTransform ();

            Assert.AreEqual((double) 0, widget.CenterX, "CenterX does not match the default value");
            Assert.AreEqual((double) 0, widget.CenterY, "CenterY does not match the default value");
            Assert.AreEqual((double) 1, widget.ScaleX, "ScaleX does not match the default value");
            Assert.AreEqual((double) 1, widget.ScaleY, "ScaleY does not match the default value");
        }

    }
}
namespace MoonTest.System.Windows.Media
{
    public partial class SkewTransformTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_SkewTransform ()
        {
            SkewTransform widget = new SkewTransform ();
            object retval;

            retval = widget.ReadLocalValue(SkewTransform.CenterXProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(SkewTransform.CenterXProperty) should not have a value by default");
            retval = widget.ReadLocalValue(SkewTransform.CenterYProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(SkewTransform.CenterYProperty) should not have a value by default");
            retval = widget.ReadLocalValue(SkewTransform.AngleXProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(SkewTransform.AngleXProperty) should not have a value by default");
            retval = widget.ReadLocalValue(SkewTransform.AngleYProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(SkewTransform.AngleYProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_SkewTransform ()
        {
            SkewTransform widget = new SkewTransform ();
            object retval;

            retval = widget.GetValue(SkewTransform.CenterXProperty);
            Assert.IsNotNull(retval, "GetValue(SkewTransform.CenterXProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(SkewTransform.CenterXProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(SkewTransform.CenterXProperty) does not match the default value");
            retval = widget.GetValue(SkewTransform.CenterYProperty);
            Assert.IsNotNull(retval, "GetValue(SkewTransform.CenterYProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(SkewTransform.CenterYProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(SkewTransform.CenterYProperty) does not match the default value");
            retval = widget.GetValue(SkewTransform.AngleXProperty);
            Assert.IsNotNull(retval, "GetValue(SkewTransform.AngleXProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(SkewTransform.AngleXProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(SkewTransform.AngleXProperty) does not match the default value");
            retval = widget.GetValue(SkewTransform.AngleYProperty);
            Assert.IsNotNull(retval, "GetValue(SkewTransform.AngleYProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(SkewTransform.AngleYProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(SkewTransform.AngleYProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_SkewTransform ()
        {
            SkewTransform widget = new SkewTransform ();

            Assert.AreEqual((double) 0, widget.CenterX, "CenterX does not match the default value");
            Assert.AreEqual((double) 0, widget.CenterY, "CenterY does not match the default value");
            Assert.AreEqual((double) 0, widget.AngleX, "AngleX does not match the default value");
            Assert.AreEqual((double) 0, widget.AngleY, "AngleY does not match the default value");
        }

    }
}
namespace MoonTest.System.Windows.Media
{
    public partial class TranslateTransformTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_TranslateTransform ()
        {
            TranslateTransform widget = new TranslateTransform ();
            object retval;

            retval = widget.ReadLocalValue(TranslateTransform.XProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(TranslateTransform.XProperty) should not have a value by default");
            retval = widget.ReadLocalValue(TranslateTransform.YProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(TranslateTransform.YProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_TranslateTransform ()
        {
            TranslateTransform widget = new TranslateTransform ();
            object retval;

            retval = widget.GetValue(TranslateTransform.XProperty);
            Assert.IsNotNull(retval, "GetValue(TranslateTransform.XProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(TranslateTransform.XProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(TranslateTransform.XProperty) does not match the default value");
            retval = widget.GetValue(TranslateTransform.YProperty);
            Assert.IsNotNull(retval, "GetValue(TranslateTransform.YProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(TranslateTransform.YProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(TranslateTransform.YProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_TranslateTransform ()
        {
            TranslateTransform widget = new TranslateTransform ();

            Assert.AreEqual((double) 0, widget.X, "X does not match the default value");
            Assert.AreEqual((double) 0, widget.Y, "Y does not match the default value");
        }

    }
}
namespace MoonTest.System.Windows.Media
{
    public partial class TransformCollectionTest
    {
        [TestMethod]
        public void Test_PropertyGetter_TransformCollection ()
        {
            TransformCollection widget = new TransformCollection ();

            Assert.AreEqual(false, widget.IsFixedSize, "IsFixedSize does not match the default value");
            Assert.AreEqual(false, widget.IsReadOnly, "IsReadOnly does not match the default value");
            Assert.AreEqual(0, widget.Count, "Count does not match the default value");
            Assert.AreEqual(false, widget.IsSynchronized, "IsSynchronized does not match the default value");
            Assert.IsNotNull(widget.SyncRoot, "SyncRoot should not have returned null");
            Assert.IsTrue(widget.SyncRoot is TransformCollection, "SyncRoot is not of the correct type");
        }

    }
}
namespace MoonTest.System.Windows.Media
{
    public partial class TransformGroupTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_TransformGroup ()
        {
            TransformGroup widget = new TransformGroup ();
            object retval;

            retval = widget.ReadLocalValue(TransformGroup.ChildrenProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(TransformGroup.ChildrenProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_TransformGroup ()
        {
            TransformGroup widget = new TransformGroup ();
            object retval;

            retval = widget.GetValue(TransformGroup.ChildrenProperty);
            Assert.IsNotNull(retval, "GetValue(TransformGroup.ChildrenProperty) should not have returned null");
            Assert.IsTrue(retval is TransformCollection, "GetValue(TransformGroup.ChildrenProperty) is not of the correct type");
        }

        [TestMethod]
        public void Test_PropertyGetter_TransformGroup ()
        {
            TransformGroup widget = new TransformGroup ();

            Assert.IsNotNull(widget.Children, "Children should not have returned null");
            Assert.IsTrue(widget.Children is TransformCollection, "Children is not of the correct type");
            Assert.AreEqual("Identity", widget.Value.ToString (), "Value does not match the default value");
        }

    }
}
namespace MoonTest.System.Windows.Media
{
    public partial class MatrixTransformTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_MatrixTransform ()
        {
            MatrixTransform widget = new MatrixTransform ();
            object retval;

            retval = widget.ReadLocalValue(MatrixTransform.MatrixProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(MatrixTransform.MatrixProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_MatrixTransform ()
        {
            MatrixTransform widget = new MatrixTransform ();
            object retval;

            retval = widget.GetValue(MatrixTransform.MatrixProperty);
            Assert.IsNotNull(retval, "GetValue(MatrixTransform.MatrixProperty) should not have returned null");
            Assert.IsTrue(retval is Matrix, "GetValue(MatrixTransform.MatrixProperty) is not of the correct type");
            Assert.AreEqual("Identity", retval.ToString (), "GetValue(MatrixTransform.MatrixProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_MatrixTransform ()
        {
            MatrixTransform widget = new MatrixTransform ();

            Assert.AreEqual("Identity", widget.Matrix.ToString (), "Matrix does not match the default value");
        }

    }
}
namespace MoonTest.System.Windows.Media
{
    public partial class LineSegmentTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_LineSegment ()
        {
            LineSegment widget = new LineSegment ();
            object retval;

            retval = widget.ReadLocalValue(LineSegment.PointProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(LineSegment.PointProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_LineSegment ()
        {
            LineSegment widget = new LineSegment ();
            object retval;

            retval = widget.GetValue(LineSegment.PointProperty);
            Assert.IsNotNull(retval, "GetValue(LineSegment.PointProperty) should not have returned null");
            Assert.IsTrue(retval is Point, "GetValue(LineSegment.PointProperty) is not of the correct type");
            Assert.AreEqual("0,0", retval.ToString (), "GetValue(LineSegment.PointProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_LineSegment ()
        {
            LineSegment widget = new LineSegment ();

            Assert.AreEqual("0,0", widget.Point.ToString (), "Point does not match the default value");
        }

    }
}
namespace MoonTest.System.Windows.Media
{
    public partial class BezierSegmentTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_BezierSegment ()
        {
            BezierSegment widget = new BezierSegment ();
            object retval;

            retval = widget.ReadLocalValue(BezierSegment.Point1Property);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(BezierSegment.Point1Property) should not have a value by default");
            retval = widget.ReadLocalValue(BezierSegment.Point2Property);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(BezierSegment.Point2Property) should not have a value by default");
            retval = widget.ReadLocalValue(BezierSegment.Point3Property);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(BezierSegment.Point3Property) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_BezierSegment ()
        {
            BezierSegment widget = new BezierSegment ();
            object retval;

            retval = widget.GetValue(BezierSegment.Point1Property);
            Assert.IsNotNull(retval, "GetValue(BezierSegment.Point1Property) should not have returned null");
            Assert.IsTrue(retval is Point, "GetValue(BezierSegment.Point1Property) is not of the correct type");
            Assert.AreEqual("0,0", retval.ToString (), "GetValue(BezierSegment.Point1Property) does not match the default value");
            retval = widget.GetValue(BezierSegment.Point2Property);
            Assert.IsNotNull(retval, "GetValue(BezierSegment.Point2Property) should not have returned null");
            Assert.IsTrue(retval is Point, "GetValue(BezierSegment.Point2Property) is not of the correct type");
            Assert.AreEqual("0,0", retval.ToString (), "GetValue(BezierSegment.Point2Property) does not match the default value");
            retval = widget.GetValue(BezierSegment.Point3Property);
            Assert.IsNotNull(retval, "GetValue(BezierSegment.Point3Property) should not have returned null");
            Assert.IsTrue(retval is Point, "GetValue(BezierSegment.Point3Property) is not of the correct type");
            Assert.AreEqual("0,0", retval.ToString (), "GetValue(BezierSegment.Point3Property) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_BezierSegment ()
        {
            BezierSegment widget = new BezierSegment ();

            Assert.AreEqual("0,0", widget.Point1.ToString (), "Point1 does not match the default value");
            Assert.AreEqual("0,0", widget.Point2.ToString (), "Point2 does not match the default value");
            Assert.AreEqual("0,0", widget.Point3.ToString (), "Point3 does not match the default value");
        }

    }
}
namespace MoonTest.System.Windows.Media
{
    public partial class QuadraticBezierSegmentTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_QuadraticBezierSegment ()
        {
            QuadraticBezierSegment widget = new QuadraticBezierSegment ();
            object retval;

            retval = widget.ReadLocalValue(QuadraticBezierSegment.Point1Property);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(QuadraticBezierSegment.Point1Property) should not have a value by default");
            retval = widget.ReadLocalValue(QuadraticBezierSegment.Point2Property);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(QuadraticBezierSegment.Point2Property) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_QuadraticBezierSegment ()
        {
            QuadraticBezierSegment widget = new QuadraticBezierSegment ();
            object retval;

            retval = widget.GetValue(QuadraticBezierSegment.Point1Property);
            Assert.IsNotNull(retval, "GetValue(QuadraticBezierSegment.Point1Property) should not have returned null");
            Assert.IsTrue(retval is Point, "GetValue(QuadraticBezierSegment.Point1Property) is not of the correct type");
            Assert.AreEqual("0,0", retval.ToString (), "GetValue(QuadraticBezierSegment.Point1Property) does not match the default value");
            retval = widget.GetValue(QuadraticBezierSegment.Point2Property);
            Assert.IsNotNull(retval, "GetValue(QuadraticBezierSegment.Point2Property) should not have returned null");
            Assert.IsTrue(retval is Point, "GetValue(QuadraticBezierSegment.Point2Property) is not of the correct type");
            Assert.AreEqual("0,0", retval.ToString (), "GetValue(QuadraticBezierSegment.Point2Property) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_QuadraticBezierSegment ()
        {
            QuadraticBezierSegment widget = new QuadraticBezierSegment ();

            Assert.AreEqual("0,0", widget.Point1.ToString (), "Point1 does not match the default value");
            Assert.AreEqual("0,0", widget.Point2.ToString (), "Point2 does not match the default value");
        }

    }
}
namespace MoonTest.System.Windows.Media
{
    public partial class ArcSegmentTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_ArcSegment ()
        {
            ArcSegment widget = new ArcSegment ();
            object retval;

            retval = widget.ReadLocalValue(ArcSegment.PointProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(ArcSegment.PointProperty) should not have a value by default");
            retval = widget.ReadLocalValue(ArcSegment.SizeProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(ArcSegment.SizeProperty) should not have a value by default");
            retval = widget.ReadLocalValue(ArcSegment.RotationAngleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(ArcSegment.RotationAngleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(ArcSegment.IsLargeArcProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(ArcSegment.IsLargeArcProperty) should not have a value by default");
            retval = widget.ReadLocalValue(ArcSegment.SweepDirectionProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(ArcSegment.SweepDirectionProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_ArcSegment ()
        {
            ArcSegment widget = new ArcSegment ();
            object retval;

            retval = widget.GetValue(ArcSegment.PointProperty);
            Assert.IsNotNull(retval, "GetValue(ArcSegment.PointProperty) should not have returned null");
            Assert.IsTrue(retval is Point, "GetValue(ArcSegment.PointProperty) is not of the correct type");
            Assert.AreEqual("0,0", retval.ToString (), "GetValue(ArcSegment.PointProperty) does not match the default value");
            retval = widget.GetValue(ArcSegment.SizeProperty);
            Assert.IsNotNull(retval, "GetValue(ArcSegment.SizeProperty) should not have returned null");
            Assert.IsTrue(retval is Size, "GetValue(ArcSegment.SizeProperty) is not of the correct type");
            Assert.AreEqual("0,0", retval.ToString (), "GetValue(ArcSegment.SizeProperty) does not match the default value");
            retval = widget.GetValue(ArcSegment.RotationAngleProperty);
            Assert.IsNotNull(retval, "GetValue(ArcSegment.RotationAngleProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(ArcSegment.RotationAngleProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(ArcSegment.RotationAngleProperty) does not match the default value");
            retval = widget.GetValue(ArcSegment.IsLargeArcProperty);
            Assert.IsNotNull(retval, "GetValue(ArcSegment.IsLargeArcProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(ArcSegment.IsLargeArcProperty) is not of the correct type");
            Assert.AreEqual(false, retval, "GetValue(ArcSegment.IsLargeArcProperty) does not match the default value");
            retval = widget.GetValue(ArcSegment.SweepDirectionProperty);
            Assert.IsNotNull(retval, "GetValue(ArcSegment.SweepDirectionProperty) should not have returned null");
            Assert.IsTrue(retval is SweepDirection, "GetValue(ArcSegment.SweepDirectionProperty) is not of the correct type");
            Assert.AreEqual(SweepDirection.Counterclockwise, retval, "GetValue(ArcSegment.SweepDirectionProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_ArcSegment ()
        {
            ArcSegment widget = new ArcSegment ();

            Assert.AreEqual("0,0", widget.Point.ToString (), "Point does not match the default value");
            Assert.AreEqual((double) 0, widget.RotationAngle, "RotationAngle does not match the default value");
            Assert.AreEqual(false, widget.IsLargeArc, "IsLargeArc does not match the default value");
            Assert.AreEqual(SweepDirection.Counterclockwise, widget.SweepDirection, "SweepDirection does not match the default value");
            Assert.AreEqual("0,0", widget.Size.ToString (), "Size does not match the default value");
        }

    }
}
namespace MoonTest.System.Windows.Media
{
    public partial class PolyLineSegmentTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_PolyLineSegment ()
        {
            PolyLineSegment widget = new PolyLineSegment ();
            object retval;

            retval = widget.ReadLocalValue(PolyLineSegment.PointsProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(PolyLineSegment.PointsProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_PolyLineSegment ()
        {
            PolyLineSegment widget = new PolyLineSegment ();
            object retval;

            retval = widget.GetValue(PolyLineSegment.PointsProperty);
            Assert.IsNotNull(retval, "GetValue(PolyLineSegment.PointsProperty) should not have returned null");
            Assert.IsTrue(retval is PointCollection, "GetValue(PolyLineSegment.PointsProperty) is not of the correct type");
        }

        [TestMethod]
        public void Test_PropertyGetter_PolyLineSegment ()
        {
            PolyLineSegment widget = new PolyLineSegment ();

            Assert.IsNotNull(widget.Points, "Points should not have returned null");
            Assert.IsTrue(widget.Points is PointCollection, "Points is not of the correct type");
        }

    }
}
namespace MoonTest.System.Windows.Media
{
    public partial class PolyBezierSegmentTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_PolyBezierSegment ()
        {
            PolyBezierSegment widget = new PolyBezierSegment ();
            object retval;

            retval = widget.ReadLocalValue(PolyBezierSegment.PointsProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(PolyBezierSegment.PointsProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_PolyBezierSegment ()
        {
            PolyBezierSegment widget = new PolyBezierSegment ();
            object retval;

            retval = widget.GetValue(PolyBezierSegment.PointsProperty);
            Assert.IsNotNull(retval, "GetValue(PolyBezierSegment.PointsProperty) should not have returned null");
            Assert.IsTrue(retval is PointCollection, "GetValue(PolyBezierSegment.PointsProperty) is not of the correct type");
        }

        [TestMethod]
        public void Test_PropertyGetter_PolyBezierSegment ()
        {
            PolyBezierSegment widget = new PolyBezierSegment ();

            Assert.IsNotNull(widget.Points, "Points should not have returned null");
            Assert.IsTrue(widget.Points is PointCollection, "Points is not of the correct type");
        }

    }
}
namespace MoonTest.System.Windows.Media
{
    public partial class PolyQuadraticBezierSegmentTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_PolyQuadraticBezierSegment ()
        {
            PolyQuadraticBezierSegment widget = new PolyQuadraticBezierSegment ();
            object retval;

            retval = widget.ReadLocalValue(PolyQuadraticBezierSegment.PointsProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(PolyQuadraticBezierSegment.PointsProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_PolyQuadraticBezierSegment ()
        {
            PolyQuadraticBezierSegment widget = new PolyQuadraticBezierSegment ();
            object retval;

            retval = widget.GetValue(PolyQuadraticBezierSegment.PointsProperty);
            Assert.IsNotNull(retval, "GetValue(PolyQuadraticBezierSegment.PointsProperty) should not have returned null");
            Assert.IsTrue(retval is PointCollection, "GetValue(PolyQuadraticBezierSegment.PointsProperty) is not of the correct type");
        }

        [TestMethod]
        public void Test_PropertyGetter_PolyQuadraticBezierSegment ()
        {
            PolyQuadraticBezierSegment widget = new PolyQuadraticBezierSegment ();

            Assert.IsNotNull(widget.Points, "Points should not have returned null");
            Assert.IsTrue(widget.Points is PointCollection, "Points is not of the correct type");
        }

    }
}
namespace MoonTest.System.Windows.Media
{
    public partial class PathSegmentCollectionTest
    {
        [TestMethod]
        public void Test_PropertyGetter_PathSegmentCollection ()
        {
            PathSegmentCollection widget = new PathSegmentCollection ();

            Assert.AreEqual(false, widget.IsFixedSize, "IsFixedSize does not match the default value");
            Assert.AreEqual(false, widget.IsReadOnly, "IsReadOnly does not match the default value");
            Assert.AreEqual(0, widget.Count, "Count does not match the default value");
            Assert.AreEqual(false, widget.IsSynchronized, "IsSynchronized does not match the default value");
            Assert.IsNotNull(widget.SyncRoot, "SyncRoot should not have returned null");
            Assert.IsTrue(widget.SyncRoot is PathSegmentCollection, "SyncRoot is not of the correct type");
        }

    }
}
namespace MoonTest.System.Windows.Media
{
    public partial class PathFigureTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_PathFigure ()
        {
            PathFigure widget = new PathFigure ();
            object retval;

            retval = widget.ReadLocalValue(PathFigure.SegmentsProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(PathFigure.SegmentsProperty) should not have a value by default");
            retval = widget.ReadLocalValue(PathFigure.StartPointProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(PathFigure.StartPointProperty) should not have a value by default");
            retval = widget.ReadLocalValue(PathFigure.IsClosedProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(PathFigure.IsClosedProperty) should not have a value by default");
            retval = widget.ReadLocalValue(PathFigure.IsFilledProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(PathFigure.IsFilledProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_PathFigure ()
        {
            PathFigure widget = new PathFigure ();
            object retval;

            retval = widget.GetValue(PathFigure.SegmentsProperty);
            Assert.IsNotNull(retval, "GetValue(PathFigure.SegmentsProperty) should not have returned null");
            Assert.IsTrue(retval is PathSegmentCollection, "GetValue(PathFigure.SegmentsProperty) is not of the correct type");
            retval = widget.GetValue(PathFigure.StartPointProperty);
            Assert.IsNotNull(retval, "GetValue(PathFigure.StartPointProperty) should not have returned null");
            Assert.IsTrue(retval is Point, "GetValue(PathFigure.StartPointProperty) is not of the correct type");
            Assert.AreEqual("0,0", retval.ToString (), "GetValue(PathFigure.StartPointProperty) does not match the default value");
            retval = widget.GetValue(PathFigure.IsClosedProperty);
            Assert.IsNotNull(retval, "GetValue(PathFigure.IsClosedProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(PathFigure.IsClosedProperty) is not of the correct type");
            Assert.AreEqual(false, retval, "GetValue(PathFigure.IsClosedProperty) does not match the default value");
            retval = widget.GetValue(PathFigure.IsFilledProperty);
            Assert.IsNotNull(retval, "GetValue(PathFigure.IsFilledProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(PathFigure.IsFilledProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(PathFigure.IsFilledProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_PathFigure ()
        {
            PathFigure widget = new PathFigure ();

            Assert.IsNotNull(widget.Segments, "Segments should not have returned null");
            Assert.IsTrue(widget.Segments is PathSegmentCollection, "Segments is not of the correct type");
            Assert.AreEqual("0,0", widget.StartPoint.ToString (), "StartPoint does not match the default value");
            Assert.AreEqual(false, widget.IsClosed, "IsClosed does not match the default value");
            Assert.AreEqual(true, widget.IsFilled, "IsFilled does not match the default value");
        }

    }
}
namespace MoonTest.System.Windows.Media
{
    public partial class PathFigureCollectionTest
    {
        [TestMethod]
        public void Test_PropertyGetter_PathFigureCollection ()
        {
            PathFigureCollection widget = new PathFigureCollection ();

            Assert.AreEqual(false, widget.IsFixedSize, "IsFixedSize does not match the default value");
            Assert.AreEqual(false, widget.IsReadOnly, "IsReadOnly does not match the default value");
            Assert.AreEqual(0, widget.Count, "Count does not match the default value");
            Assert.AreEqual(false, widget.IsSynchronized, "IsSynchronized does not match the default value");
            Assert.IsNotNull(widget.SyncRoot, "SyncRoot should not have returned null");
            Assert.IsTrue(widget.SyncRoot is PathFigureCollection, "SyncRoot is not of the correct type");
        }

    }
}
namespace MoonTest.System.Windows.Media
{
    public partial class PathGeometryTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_PathGeometry ()
        {
            PathGeometry widget = new PathGeometry ();
            object retval;

            retval = widget.ReadLocalValue(PathGeometry.FillRuleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(PathGeometry.FillRuleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(PathGeometry.FiguresProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(PathGeometry.FiguresProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_Geometry ()
        {
            PathGeometry widget = new PathGeometry ();
            object retval;

            retval = widget.ReadLocalValue(Geometry.TransformProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Geometry.TransformProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_PathGeometry ()
        {
            PathGeometry widget = new PathGeometry ();
            object retval;

            retval = widget.GetValue(PathGeometry.FillRuleProperty);
            Assert.IsNotNull(retval, "GetValue(PathGeometry.FillRuleProperty) should not have returned null");
            Assert.IsTrue(retval is FillRule, "GetValue(PathGeometry.FillRuleProperty) is not of the correct type");
            Assert.AreEqual(FillRule.EvenOdd, retval, "GetValue(PathGeometry.FillRuleProperty) does not match the default value");
            retval = widget.GetValue(PathGeometry.FiguresProperty);
            Assert.IsNotNull(retval, "GetValue(PathGeometry.FiguresProperty) should not have returned null");
            Assert.IsTrue(retval is PathFigureCollection, "GetValue(PathGeometry.FiguresProperty) is not of the correct type");
        }

        [TestMethod]
        public void Test_GetValue_Geometry ()
        {
            PathGeometry widget = new PathGeometry ();
            object retval;

            retval = widget.GetValue(Geometry.TransformProperty);
            Assert.IsNull(retval, "GetValue(Geometry.TransformProperty) should have returned null");
        }

        [TestMethod]
        public void Test_PropertyGetter_PathGeometry ()
        {
            PathGeometry widget = new PathGeometry ();

            Assert.AreEqual(FillRule.EvenOdd, widget.FillRule, "FillRule does not match the default value");
            Assert.IsNotNull(widget.Figures, "Figures should not have returned null");
            Assert.IsTrue(widget.Figures is PathFigureCollection, "Figures is not of the correct type");
            Assert.IsNull(widget.Transform, "Transform should have returned null");
            Assert.AreEqual("0,0,0,0", widget.Bounds.ToString (), "Bounds does not match the default value");
        }

    }
}
namespace MoonTest.System.Windows.Media
{
    public partial class EllipseGeometryTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_EllipseGeometry ()
        {
            EllipseGeometry widget = new EllipseGeometry ();
            object retval;

            retval = widget.ReadLocalValue(EllipseGeometry.CenterProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(EllipseGeometry.CenterProperty) should not have a value by default");
            retval = widget.ReadLocalValue(EllipseGeometry.RadiusXProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(EllipseGeometry.RadiusXProperty) should not have a value by default");
            retval = widget.ReadLocalValue(EllipseGeometry.RadiusYProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(EllipseGeometry.RadiusYProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_Geometry ()
        {
            EllipseGeometry widget = new EllipseGeometry ();
            object retval;

            retval = widget.ReadLocalValue(Geometry.TransformProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Geometry.TransformProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_EllipseGeometry ()
        {
            EllipseGeometry widget = new EllipseGeometry ();
            object retval;

            retval = widget.GetValue(EllipseGeometry.CenterProperty);
            Assert.IsNotNull(retval, "GetValue(EllipseGeometry.CenterProperty) should not have returned null");
            Assert.IsTrue(retval is Point, "GetValue(EllipseGeometry.CenterProperty) is not of the correct type");
            Assert.AreEqual("0,0", retval.ToString (), "GetValue(EllipseGeometry.CenterProperty) does not match the default value");
            retval = widget.GetValue(EllipseGeometry.RadiusXProperty);
            Assert.IsNotNull(retval, "GetValue(EllipseGeometry.RadiusXProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(EllipseGeometry.RadiusXProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(EllipseGeometry.RadiusXProperty) does not match the default value");
            retval = widget.GetValue(EllipseGeometry.RadiusYProperty);
            Assert.IsNotNull(retval, "GetValue(EllipseGeometry.RadiusYProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(EllipseGeometry.RadiusYProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(EllipseGeometry.RadiusYProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_GetValue_Geometry ()
        {
            EllipseGeometry widget = new EllipseGeometry ();
            object retval;

            retval = widget.GetValue(Geometry.TransformProperty);
            Assert.IsNull(retval, "GetValue(Geometry.TransformProperty) should have returned null");
        }

        [TestMethod]
        public void Test_PropertyGetter_EllipseGeometry ()
        {
            EllipseGeometry widget = new EllipseGeometry ();

            Assert.AreEqual("0,0", widget.Center.ToString (), "Center does not match the default value");
            Assert.AreEqual((double) 0, widget.RadiusX, "RadiusX does not match the default value");
            Assert.AreEqual((double) 0, widget.RadiusY, "RadiusY does not match the default value");
            Assert.IsNull(widget.Transform, "Transform should have returned null");
            Assert.AreEqual("0,0,0,0", widget.Bounds.ToString (), "Bounds does not match the default value");
        }

    }
}
namespace MoonTest.System.Windows.Media
{
    public partial class RectangleGeometryTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_RectangleGeometry ()
        {
            RectangleGeometry widget = new RectangleGeometry ();
            object retval;

            retval = widget.ReadLocalValue(RectangleGeometry.RectProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(RectangleGeometry.RectProperty) should not have a value by default");
            retval = widget.ReadLocalValue(RectangleGeometry.RadiusXProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(RectangleGeometry.RadiusXProperty) should not have a value by default");
            retval = widget.ReadLocalValue(RectangleGeometry.RadiusYProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(RectangleGeometry.RadiusYProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_Geometry ()
        {
            RectangleGeometry widget = new RectangleGeometry ();
            object retval;

            retval = widget.ReadLocalValue(Geometry.TransformProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Geometry.TransformProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_RectangleGeometry ()
        {
            RectangleGeometry widget = new RectangleGeometry ();
            object retval;

            retval = widget.GetValue(RectangleGeometry.RectProperty);
            Assert.IsNotNull(retval, "GetValue(RectangleGeometry.RectProperty) should not have returned null");
            Assert.IsTrue(retval is Rect, "GetValue(RectangleGeometry.RectProperty) is not of the correct type");
            Assert.AreEqual("0,0,0,0", retval.ToString (), "GetValue(RectangleGeometry.RectProperty) does not match the default value");
            retval = widget.GetValue(RectangleGeometry.RadiusXProperty);
            Assert.IsNotNull(retval, "GetValue(RectangleGeometry.RadiusXProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(RectangleGeometry.RadiusXProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(RectangleGeometry.RadiusXProperty) does not match the default value");
            retval = widget.GetValue(RectangleGeometry.RadiusYProperty);
            Assert.IsNotNull(retval, "GetValue(RectangleGeometry.RadiusYProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(RectangleGeometry.RadiusYProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(RectangleGeometry.RadiusYProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_GetValue_Geometry ()
        {
            RectangleGeometry widget = new RectangleGeometry ();
            object retval;

            retval = widget.GetValue(Geometry.TransformProperty);
            Assert.IsNull(retval, "GetValue(Geometry.TransformProperty) should have returned null");
        }

        [TestMethod]
        public void Test_PropertyGetter_RectangleGeometry ()
        {
            RectangleGeometry widget = new RectangleGeometry ();

            Assert.AreEqual("0,0,0,0", widget.Rect.ToString (), "Rect does not match the default value");
            Assert.AreEqual((double) 0, widget.RadiusX, "RadiusX does not match the default value");
            Assert.AreEqual((double) 0, widget.RadiusY, "RadiusY does not match the default value");
            Assert.IsNull(widget.Transform, "Transform should have returned null");
            Assert.AreEqual("0,0,0,0", widget.Bounds.ToString (), "Bounds does not match the default value");
        }

    }
}
namespace MoonTest.System.Windows.Media
{
    public partial class LineGeometryTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_LineGeometry ()
        {
            LineGeometry widget = new LineGeometry ();
            object retval;

            retval = widget.ReadLocalValue(LineGeometry.StartPointProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(LineGeometry.StartPointProperty) should not have a value by default");
            retval = widget.ReadLocalValue(LineGeometry.EndPointProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(LineGeometry.EndPointProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_Geometry ()
        {
            LineGeometry widget = new LineGeometry ();
            object retval;

            retval = widget.ReadLocalValue(Geometry.TransformProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Geometry.TransformProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_LineGeometry ()
        {
            LineGeometry widget = new LineGeometry ();
            object retval;

            retval = widget.GetValue(LineGeometry.StartPointProperty);
            Assert.IsNotNull(retval, "GetValue(LineGeometry.StartPointProperty) should not have returned null");
            Assert.IsTrue(retval is Point, "GetValue(LineGeometry.StartPointProperty) is not of the correct type");
            Assert.AreEqual("0,0", retval.ToString (), "GetValue(LineGeometry.StartPointProperty) does not match the default value");
            retval = widget.GetValue(LineGeometry.EndPointProperty);
            Assert.IsNotNull(retval, "GetValue(LineGeometry.EndPointProperty) should not have returned null");
            Assert.IsTrue(retval is Point, "GetValue(LineGeometry.EndPointProperty) is not of the correct type");
            Assert.AreEqual("0,0", retval.ToString (), "GetValue(LineGeometry.EndPointProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_GetValue_Geometry ()
        {
            LineGeometry widget = new LineGeometry ();
            object retval;

            retval = widget.GetValue(Geometry.TransformProperty);
            Assert.IsNull(retval, "GetValue(Geometry.TransformProperty) should have returned null");
        }

        [TestMethod]
        public void Test_PropertyGetter_LineGeometry ()
        {
            LineGeometry widget = new LineGeometry ();

            Assert.AreEqual("0,0", widget.StartPoint.ToString (), "StartPoint does not match the default value");
            Assert.AreEqual("0,0", widget.EndPoint.ToString (), "EndPoint does not match the default value");
            Assert.IsNull(widget.Transform, "Transform should have returned null");
            Assert.AreEqual("0,0,0,0", widget.Bounds.ToString (), "Bounds does not match the default value");
        }

    }
}
namespace MoonTest.System.Windows.Media
{
    public partial class GeometryCollectionTest
    {
        [TestMethod]
        public void Test_PropertyGetter_GeometryCollection ()
        {
            GeometryCollection widget = new GeometryCollection ();

            Assert.AreEqual(false, widget.IsFixedSize, "IsFixedSize does not match the default value");
            Assert.AreEqual(false, widget.IsReadOnly, "IsReadOnly does not match the default value");
            Assert.AreEqual(0, widget.Count, "Count does not match the default value");
            Assert.AreEqual(false, widget.IsSynchronized, "IsSynchronized does not match the default value");
            Assert.IsNotNull(widget.SyncRoot, "SyncRoot should not have returned null");
            Assert.IsTrue(widget.SyncRoot is GeometryCollection, "SyncRoot is not of the correct type");
        }

    }
}
namespace MoonTest.System.Windows.Media
{
    public partial class GeometryGroupTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_GeometryGroup ()
        {
            GeometryGroup widget = new GeometryGroup ();
            object retval;

            retval = widget.ReadLocalValue(GeometryGroup.FillRuleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(GeometryGroup.FillRuleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(GeometryGroup.ChildrenProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(GeometryGroup.ChildrenProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_Geometry ()
        {
            GeometryGroup widget = new GeometryGroup ();
            object retval;

            retval = widget.ReadLocalValue(Geometry.TransformProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Geometry.TransformProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_GeometryGroup ()
        {
            GeometryGroup widget = new GeometryGroup ();
            object retval;

            retval = widget.GetValue(GeometryGroup.FillRuleProperty);
            Assert.IsNotNull(retval, "GetValue(GeometryGroup.FillRuleProperty) should not have returned null");
            Assert.IsTrue(retval is FillRule, "GetValue(GeometryGroup.FillRuleProperty) is not of the correct type");
            Assert.AreEqual(FillRule.EvenOdd, retval, "GetValue(GeometryGroup.FillRuleProperty) does not match the default value");
            retval = widget.GetValue(GeometryGroup.ChildrenProperty);
            Assert.IsNotNull(retval, "GetValue(GeometryGroup.ChildrenProperty) should not have returned null");
            Assert.IsTrue(retval is GeometryCollection, "GetValue(GeometryGroup.ChildrenProperty) is not of the correct type");
        }

        [TestMethod]
        public void Test_GetValue_Geometry ()
        {
            GeometryGroup widget = new GeometryGroup ();
            object retval;

            retval = widget.GetValue(Geometry.TransformProperty);
            Assert.IsNull(retval, "GetValue(Geometry.TransformProperty) should have returned null");
        }

        [TestMethod]
        public void Test_PropertyGetter_GeometryGroup ()
        {
            GeometryGroup widget = new GeometryGroup ();

            Assert.AreEqual(FillRule.EvenOdd, widget.FillRule, "FillRule does not match the default value");
            Assert.IsNotNull(widget.Children, "Children should not have returned null");
            Assert.IsTrue(widget.Children is GeometryCollection, "Children is not of the correct type");
            Assert.IsNull(widget.Transform, "Transform should have returned null");
            Assert.AreEqual("0,0,0,0", widget.Bounds.ToString (), "Bounds does not match the default value");
        }

    }
}
namespace MoonTest.System.Windows.Media
{
    public partial class SolidColorBrushTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_SolidColorBrush ()
        {
            SolidColorBrush widget = new SolidColorBrush ();
            object retval;

            retval = widget.ReadLocalValue(SolidColorBrush.ColorProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(SolidColorBrush.ColorProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_Brush ()
        {
            SolidColorBrush widget = new SolidColorBrush ();
            object retval;

            retval = widget.ReadLocalValue(Brush.OpacityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Brush.OpacityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Brush.TransformProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Brush.TransformProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Brush.RelativeTransformProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Brush.RelativeTransformProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_SolidColorBrush ()
        {
            SolidColorBrush widget = new SolidColorBrush ();
            object retval;

            retval = widget.GetValue(SolidColorBrush.ColorProperty);
            Assert.IsNotNull(retval, "GetValue(SolidColorBrush.ColorProperty) should not have returned null");
            Assert.IsTrue(retval is Color, "GetValue(SolidColorBrush.ColorProperty) is not of the correct type");
            Assert.AreEqual("#00000000", retval.ToString (), "GetValue(SolidColorBrush.ColorProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_GetValue_Brush ()
        {
            SolidColorBrush widget = new SolidColorBrush ();
            object retval;

            retval = widget.GetValue(Brush.OpacityProperty);
            Assert.IsNotNull(retval, "GetValue(Brush.OpacityProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Brush.OpacityProperty) is not of the correct type");
            Assert.AreEqual((double) 1, retval, "GetValue(Brush.OpacityProperty) does not match the default value");
            retval = widget.GetValue(Brush.TransformProperty);
            Assert.IsNotNull(retval, "GetValue(Brush.TransformProperty) should not have returned null");
            Assert.IsTrue(retval is MatrixTransform, "GetValue(Brush.TransformProperty) is not of the correct type");
            retval = widget.GetValue(Brush.RelativeTransformProperty);
            Assert.IsNotNull(retval, "GetValue(Brush.RelativeTransformProperty) should not have returned null");
            Assert.IsTrue(retval is MatrixTransform, "GetValue(Brush.RelativeTransformProperty) is not of the correct type");
        }

        [TestMethod]
        public void Test_PropertyGetter_SolidColorBrush ()
        {
            SolidColorBrush widget = new SolidColorBrush ();

            Assert.AreEqual("#00000000", widget.Color.ToString (), "Color does not match the default value");
            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNotNull(widget.Transform, "Transform should not have returned null");
            Assert.IsTrue(widget.Transform is MatrixTransform, "Transform is not of the correct type");
            Assert.IsNotNull(widget.RelativeTransform, "RelativeTransform should not have returned null");
            Assert.IsTrue(widget.RelativeTransform is MatrixTransform, "RelativeTransform is not of the correct type");
        }

    }
}
namespace MoonTest.System.Windows.Media
{
    public partial class GradientStopTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_GradientStop ()
        {
            GradientStop widget = new GradientStop ();
            object retval;

            retval = widget.ReadLocalValue(GradientStop.ColorProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(GradientStop.ColorProperty) should not have a value by default");
            retval = widget.ReadLocalValue(GradientStop.OffsetProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(GradientStop.OffsetProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_GradientStop ()
        {
            GradientStop widget = new GradientStop ();
            object retval;

            retval = widget.GetValue(GradientStop.ColorProperty);
            Assert.IsNotNull(retval, "GetValue(GradientStop.ColorProperty) should not have returned null");
            Assert.IsTrue(retval is Color, "GetValue(GradientStop.ColorProperty) is not of the correct type");
            Assert.AreEqual("#00000000", retval.ToString (), "GetValue(GradientStop.ColorProperty) does not match the default value");
            retval = widget.GetValue(GradientStop.OffsetProperty);
            Assert.IsNotNull(retval, "GetValue(GradientStop.OffsetProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(GradientStop.OffsetProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(GradientStop.OffsetProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_GradientStop ()
        {
            GradientStop widget = new GradientStop ();

            Assert.AreEqual("#00000000", widget.Color.ToString (), "Color does not match the default value");
            Assert.AreEqual((double) 0, widget.Offset, "Offset does not match the default value");
        }

    }
}
namespace MoonTest.System.Windows.Media
{
    public partial class GradientStopCollectionTest
    {
        [TestMethod]
        public void Test_PropertyGetter_GradientStopCollection ()
        {
            GradientStopCollection widget = new GradientStopCollection ();

            Assert.AreEqual(false, widget.IsFixedSize, "IsFixedSize does not match the default value");
            Assert.AreEqual(false, widget.IsReadOnly, "IsReadOnly does not match the default value");
            Assert.AreEqual(0, widget.Count, "Count does not match the default value");
            Assert.AreEqual(false, widget.IsSynchronized, "IsSynchronized does not match the default value");
            Assert.IsNotNull(widget.SyncRoot, "SyncRoot should not have returned null");
            Assert.IsTrue(widget.SyncRoot is GradientStopCollection, "SyncRoot is not of the correct type");
        }

    }
}
namespace MoonTest.System.Windows.Media
{
    public partial class LinearGradientBrushTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_LinearGradientBrush ()
        {
            LinearGradientBrush widget = new LinearGradientBrush ();
            object retval;

            retval = widget.ReadLocalValue(LinearGradientBrush.StartPointProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(LinearGradientBrush.StartPointProperty) should not have a value by default");
            retval = widget.ReadLocalValue(LinearGradientBrush.EndPointProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(LinearGradientBrush.EndPointProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_GradientBrush ()
        {
            LinearGradientBrush widget = new LinearGradientBrush ();
            object retval;

            retval = widget.ReadLocalValue(GradientBrush.SpreadMethodProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(GradientBrush.SpreadMethodProperty) should not have a value by default");
            retval = widget.ReadLocalValue(GradientBrush.MappingModeProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(GradientBrush.MappingModeProperty) should not have a value by default");
            retval = widget.ReadLocalValue(GradientBrush.ColorInterpolationModeProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(GradientBrush.ColorInterpolationModeProperty) should not have a value by default");
            retval = widget.ReadLocalValue(GradientBrush.GradientStopsProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(GradientBrush.GradientStopsProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_Brush ()
        {
            LinearGradientBrush widget = new LinearGradientBrush ();
            object retval;

            retval = widget.ReadLocalValue(Brush.OpacityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Brush.OpacityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Brush.TransformProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Brush.TransformProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Brush.RelativeTransformProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Brush.RelativeTransformProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_LinearGradientBrush ()
        {
            LinearGradientBrush widget = new LinearGradientBrush ();
            object retval;

            retval = widget.GetValue(LinearGradientBrush.StartPointProperty);
            Assert.IsNotNull(retval, "GetValue(LinearGradientBrush.StartPointProperty) should not have returned null");
            Assert.IsTrue(retval is Point, "GetValue(LinearGradientBrush.StartPointProperty) is not of the correct type");
            Assert.AreEqual("0,0", retval.ToString (), "GetValue(LinearGradientBrush.StartPointProperty) does not match the default value");
            retval = widget.GetValue(LinearGradientBrush.EndPointProperty);
            Assert.IsNotNull(retval, "GetValue(LinearGradientBrush.EndPointProperty) should not have returned null");
            Assert.IsTrue(retval is Point, "GetValue(LinearGradientBrush.EndPointProperty) is not of the correct type");
            Assert.AreEqual("1,1", retval.ToString (), "GetValue(LinearGradientBrush.EndPointProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_GetValue_GradientBrush ()
        {
            LinearGradientBrush widget = new LinearGradientBrush ();
            object retval;

            retval = widget.GetValue(GradientBrush.SpreadMethodProperty);
            Assert.IsNotNull(retval, "GetValue(GradientBrush.SpreadMethodProperty) should not have returned null");
            Assert.IsTrue(retval is GradientSpreadMethod, "GetValue(GradientBrush.SpreadMethodProperty) is not of the correct type");
            Assert.AreEqual(GradientSpreadMethod.Pad, retval, "GetValue(GradientBrush.SpreadMethodProperty) does not match the default value");
            retval = widget.GetValue(GradientBrush.MappingModeProperty);
            Assert.IsNotNull(retval, "GetValue(GradientBrush.MappingModeProperty) should not have returned null");
            Assert.IsTrue(retval is BrushMappingMode, "GetValue(GradientBrush.MappingModeProperty) is not of the correct type");
            Assert.AreEqual(BrushMappingMode.RelativeToBoundingBox, retval, "GetValue(GradientBrush.MappingModeProperty) does not match the default value");
            retval = widget.GetValue(GradientBrush.ColorInterpolationModeProperty);
            Assert.IsNotNull(retval, "GetValue(GradientBrush.ColorInterpolationModeProperty) should not have returned null");
            Assert.IsTrue(retval is ColorInterpolationMode, "GetValue(GradientBrush.ColorInterpolationModeProperty) is not of the correct type");
            Assert.AreEqual(ColorInterpolationMode.SRgbLinearInterpolation, retval, "GetValue(GradientBrush.ColorInterpolationModeProperty) does not match the default value");
            retval = widget.GetValue(GradientBrush.GradientStopsProperty);
            Assert.IsNotNull(retval, "GetValue(GradientBrush.GradientStopsProperty) should not have returned null");
            Assert.IsTrue(retval is GradientStopCollection, "GetValue(GradientBrush.GradientStopsProperty) is not of the correct type");
        }

        [TestMethod]
        public void Test_GetValue_Brush ()
        {
            LinearGradientBrush widget = new LinearGradientBrush ();
            object retval;

            retval = widget.GetValue(Brush.OpacityProperty);
            Assert.IsNotNull(retval, "GetValue(Brush.OpacityProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Brush.OpacityProperty) is not of the correct type");
            Assert.AreEqual((double) 1, retval, "GetValue(Brush.OpacityProperty) does not match the default value");
            retval = widget.GetValue(Brush.TransformProperty);
            Assert.IsNotNull(retval, "GetValue(Brush.TransformProperty) should not have returned null");
            Assert.IsTrue(retval is MatrixTransform, "GetValue(Brush.TransformProperty) is not of the correct type");
            retval = widget.GetValue(Brush.RelativeTransformProperty);
            Assert.IsNotNull(retval, "GetValue(Brush.RelativeTransformProperty) should not have returned null");
            Assert.IsTrue(retval is MatrixTransform, "GetValue(Brush.RelativeTransformProperty) is not of the correct type");
        }

        [TestMethod]
        public void Test_PropertyGetter_LinearGradientBrush ()
        {
            LinearGradientBrush widget = new LinearGradientBrush ();

            Assert.AreEqual("0,0", widget.StartPoint.ToString (), "StartPoint does not match the default value");
            Assert.AreEqual("1,1", widget.EndPoint.ToString (), "EndPoint does not match the default value");
            Assert.AreEqual(GradientSpreadMethod.Pad, widget.SpreadMethod, "SpreadMethod does not match the default value");
            Assert.AreEqual(BrushMappingMode.RelativeToBoundingBox, widget.MappingMode, "MappingMode does not match the default value");
            Assert.AreEqual(ColorInterpolationMode.SRgbLinearInterpolation, widget.ColorInterpolationMode, "ColorInterpolationMode does not match the default value");
            Assert.IsNotNull(widget.GradientStops, "GradientStops should not have returned null");
            Assert.IsTrue(widget.GradientStops is GradientStopCollection, "GradientStops is not of the correct type");
            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNotNull(widget.Transform, "Transform should not have returned null");
            Assert.IsTrue(widget.Transform is MatrixTransform, "Transform is not of the correct type");
            Assert.IsNotNull(widget.RelativeTransform, "RelativeTransform should not have returned null");
            Assert.IsTrue(widget.RelativeTransform is MatrixTransform, "RelativeTransform is not of the correct type");
        }

        [TestMethod]
        public void Test_PropertyGetter_Brush ()
        {
            LinearGradientBrush widget = new LinearGradientBrush ();

            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNotNull(widget.Transform, "Transform should not have returned null");
            Assert.IsTrue(widget.Transform is MatrixTransform, "Transform is not of the correct type");
            Assert.IsNotNull(widget.RelativeTransform, "RelativeTransform should not have returned null");
            Assert.IsTrue(widget.RelativeTransform is MatrixTransform, "RelativeTransform is not of the correct type");
        }

    }
}
namespace MoonTest.System.Windows.Media
{
    public partial class RadialGradientBrushTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_RadialGradientBrush ()
        {
            RadialGradientBrush widget = new RadialGradientBrush ();
            object retval;

            retval = widget.ReadLocalValue(RadialGradientBrush.CenterProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(RadialGradientBrush.CenterProperty) should not have a value by default");
            retval = widget.ReadLocalValue(RadialGradientBrush.GradientOriginProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(RadialGradientBrush.GradientOriginProperty) should not have a value by default");
            retval = widget.ReadLocalValue(RadialGradientBrush.RadiusXProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(RadialGradientBrush.RadiusXProperty) should not have a value by default");
            retval = widget.ReadLocalValue(RadialGradientBrush.RadiusYProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(RadialGradientBrush.RadiusYProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_GradientBrush ()
        {
            RadialGradientBrush widget = new RadialGradientBrush ();
            object retval;

            retval = widget.ReadLocalValue(GradientBrush.SpreadMethodProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(GradientBrush.SpreadMethodProperty) should not have a value by default");
            retval = widget.ReadLocalValue(GradientBrush.MappingModeProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(GradientBrush.MappingModeProperty) should not have a value by default");
            retval = widget.ReadLocalValue(GradientBrush.ColorInterpolationModeProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(GradientBrush.ColorInterpolationModeProperty) should not have a value by default");
            retval = widget.ReadLocalValue(GradientBrush.GradientStopsProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(GradientBrush.GradientStopsProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_Brush ()
        {
            RadialGradientBrush widget = new RadialGradientBrush ();
            object retval;

            retval = widget.ReadLocalValue(Brush.OpacityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Brush.OpacityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Brush.TransformProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Brush.TransformProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Brush.RelativeTransformProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Brush.RelativeTransformProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_RadialGradientBrush ()
        {
            RadialGradientBrush widget = new RadialGradientBrush ();
            object retval;

            retval = widget.GetValue(RadialGradientBrush.CenterProperty);
            Assert.IsNotNull(retval, "GetValue(RadialGradientBrush.CenterProperty) should not have returned null");
            Assert.IsTrue(retval is Point, "GetValue(RadialGradientBrush.CenterProperty) is not of the correct type");
            Assert.AreEqual("0.5,0.5", retval.ToString (), "GetValue(RadialGradientBrush.CenterProperty) does not match the default value");
            retval = widget.GetValue(RadialGradientBrush.GradientOriginProperty);
            Assert.IsNotNull(retval, "GetValue(RadialGradientBrush.GradientOriginProperty) should not have returned null");
            Assert.IsTrue(retval is Point, "GetValue(RadialGradientBrush.GradientOriginProperty) is not of the correct type");
            Assert.AreEqual("0.5,0.5", retval.ToString (), "GetValue(RadialGradientBrush.GradientOriginProperty) does not match the default value");
            retval = widget.GetValue(RadialGradientBrush.RadiusXProperty);
            Assert.IsNotNull(retval, "GetValue(RadialGradientBrush.RadiusXProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(RadialGradientBrush.RadiusXProperty) is not of the correct type");
            Assert.AreEqual((double) 0.5, retval, "GetValue(RadialGradientBrush.RadiusXProperty) does not match the default value");
            retval = widget.GetValue(RadialGradientBrush.RadiusYProperty);
            Assert.IsNotNull(retval, "GetValue(RadialGradientBrush.RadiusYProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(RadialGradientBrush.RadiusYProperty) is not of the correct type");
            Assert.AreEqual((double) 0.5, retval, "GetValue(RadialGradientBrush.RadiusYProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_GetValue_GradientBrush ()
        {
            RadialGradientBrush widget = new RadialGradientBrush ();
            object retval;

            retval = widget.GetValue(GradientBrush.SpreadMethodProperty);
            Assert.IsNotNull(retval, "GetValue(GradientBrush.SpreadMethodProperty) should not have returned null");
            Assert.IsTrue(retval is GradientSpreadMethod, "GetValue(GradientBrush.SpreadMethodProperty) is not of the correct type");
            Assert.AreEqual(GradientSpreadMethod.Pad, retval, "GetValue(GradientBrush.SpreadMethodProperty) does not match the default value");
            retval = widget.GetValue(GradientBrush.MappingModeProperty);
            Assert.IsNotNull(retval, "GetValue(GradientBrush.MappingModeProperty) should not have returned null");
            Assert.IsTrue(retval is BrushMappingMode, "GetValue(GradientBrush.MappingModeProperty) is not of the correct type");
            Assert.AreEqual(BrushMappingMode.RelativeToBoundingBox, retval, "GetValue(GradientBrush.MappingModeProperty) does not match the default value");
            retval = widget.GetValue(GradientBrush.ColorInterpolationModeProperty);
            Assert.IsNotNull(retval, "GetValue(GradientBrush.ColorInterpolationModeProperty) should not have returned null");
            Assert.IsTrue(retval is ColorInterpolationMode, "GetValue(GradientBrush.ColorInterpolationModeProperty) is not of the correct type");
            Assert.AreEqual(ColorInterpolationMode.SRgbLinearInterpolation, retval, "GetValue(GradientBrush.ColorInterpolationModeProperty) does not match the default value");
            retval = widget.GetValue(GradientBrush.GradientStopsProperty);
            Assert.IsNotNull(retval, "GetValue(GradientBrush.GradientStopsProperty) should not have returned null");
            Assert.IsTrue(retval is GradientStopCollection, "GetValue(GradientBrush.GradientStopsProperty) is not of the correct type");
        }

        [TestMethod]
        public void Test_GetValue_Brush ()
        {
            RadialGradientBrush widget = new RadialGradientBrush ();
            object retval;

            retval = widget.GetValue(Brush.OpacityProperty);
            Assert.IsNotNull(retval, "GetValue(Brush.OpacityProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Brush.OpacityProperty) is not of the correct type");
            Assert.AreEqual((double) 1, retval, "GetValue(Brush.OpacityProperty) does not match the default value");
            retval = widget.GetValue(Brush.TransformProperty);
            Assert.IsNotNull(retval, "GetValue(Brush.TransformProperty) should not have returned null");
            Assert.IsTrue(retval is MatrixTransform, "GetValue(Brush.TransformProperty) is not of the correct type");
            retval = widget.GetValue(Brush.RelativeTransformProperty);
            Assert.IsNotNull(retval, "GetValue(Brush.RelativeTransformProperty) should not have returned null");
            Assert.IsTrue(retval is MatrixTransform, "GetValue(Brush.RelativeTransformProperty) is not of the correct type");
        }

        [TestMethod]
        public void Test_PropertyGetter_RadialGradientBrush ()
        {
            RadialGradientBrush widget = new RadialGradientBrush ();

            Assert.AreEqual("0.5,0.5", widget.Center.ToString (), "Center does not match the default value");
            Assert.AreEqual("0.5,0.5", widget.GradientOrigin.ToString (), "GradientOrigin does not match the default value");
            Assert.AreEqual((double) 0.5, widget.RadiusX, "RadiusX does not match the default value");
            Assert.AreEqual((double) 0.5, widget.RadiusY, "RadiusY does not match the default value");
            Assert.AreEqual(GradientSpreadMethod.Pad, widget.SpreadMethod, "SpreadMethod does not match the default value");
            Assert.AreEqual(BrushMappingMode.RelativeToBoundingBox, widget.MappingMode, "MappingMode does not match the default value");
            Assert.AreEqual(ColorInterpolationMode.SRgbLinearInterpolation, widget.ColorInterpolationMode, "ColorInterpolationMode does not match the default value");
            Assert.IsNotNull(widget.GradientStops, "GradientStops should not have returned null");
            Assert.IsTrue(widget.GradientStops is GradientStopCollection, "GradientStops is not of the correct type");
            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNotNull(widget.Transform, "Transform should not have returned null");
            Assert.IsTrue(widget.Transform is MatrixTransform, "Transform is not of the correct type");
            Assert.IsNotNull(widget.RelativeTransform, "RelativeTransform should not have returned null");
            Assert.IsTrue(widget.RelativeTransform is MatrixTransform, "RelativeTransform is not of the correct type");
        }

        [TestMethod]
        public void Test_PropertyGetter_Brush ()
        {
            RadialGradientBrush widget = new RadialGradientBrush ();

            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNotNull(widget.Transform, "Transform should not have returned null");
            Assert.IsTrue(widget.Transform is MatrixTransform, "Transform is not of the correct type");
            Assert.IsNotNull(widget.RelativeTransform, "RelativeTransform should not have returned null");
            Assert.IsTrue(widget.RelativeTransform is MatrixTransform, "RelativeTransform is not of the correct type");
        }

    }
}
namespace MoonTest.System.Windows.Media
{
    public partial class ImageBrushTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_ImageBrush ()
        {
            ImageBrush widget = new ImageBrush ();
            object retval;

            retval = widget.ReadLocalValue(ImageBrush.ImageSourceProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(ImageBrush.ImageSourceProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_TileBrush ()
        {
            ImageBrush widget = new ImageBrush ();
            object retval;

            retval = widget.ReadLocalValue(TileBrush.AlignmentXProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(TileBrush.AlignmentXProperty) should not have a value by default");
            retval = widget.ReadLocalValue(TileBrush.AlignmentYProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(TileBrush.AlignmentYProperty) should not have a value by default");
            retval = widget.ReadLocalValue(TileBrush.StretchProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(TileBrush.StretchProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_Brush ()
        {
            ImageBrush widget = new ImageBrush ();
            object retval;

            retval = widget.ReadLocalValue(Brush.OpacityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Brush.OpacityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Brush.TransformProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Brush.TransformProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Brush.RelativeTransformProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Brush.RelativeTransformProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_ImageBrush ()
        {
            ImageBrush widget = new ImageBrush ();
            object retval;

            retval = widget.GetValue(ImageBrush.ImageSourceProperty);
            Assert.IsNull(retval, "GetValue(ImageBrush.ImageSourceProperty) should have returned null");
        }

        [TestMethod]
        public void Test_GetValue_TileBrush ()
        {
            ImageBrush widget = new ImageBrush ();
            object retval;

            retval = widget.GetValue(TileBrush.AlignmentXProperty);
            Assert.IsNotNull(retval, "GetValue(TileBrush.AlignmentXProperty) should not have returned null");
            Assert.IsTrue(retval is AlignmentX, "GetValue(TileBrush.AlignmentXProperty) is not of the correct type");
            Assert.AreEqual(AlignmentX.Center, retval, "GetValue(TileBrush.AlignmentXProperty) does not match the default value");
            retval = widget.GetValue(TileBrush.AlignmentYProperty);
            Assert.IsNotNull(retval, "GetValue(TileBrush.AlignmentYProperty) should not have returned null");
            Assert.IsTrue(retval is AlignmentY, "GetValue(TileBrush.AlignmentYProperty) is not of the correct type");
            Assert.AreEqual(AlignmentY.Center, retval, "GetValue(TileBrush.AlignmentYProperty) does not match the default value");
            retval = widget.GetValue(TileBrush.StretchProperty);
            Assert.IsNotNull(retval, "GetValue(TileBrush.StretchProperty) should not have returned null");
            Assert.IsTrue(retval is Stretch, "GetValue(TileBrush.StretchProperty) is not of the correct type");
            Assert.AreEqual(Stretch.Fill, retval, "GetValue(TileBrush.StretchProperty) does not match the default value");
        }

        [TestMethod]
	[MoonlightBug]
        public void Test_GetValue_Brush ()
        {
            ImageBrush widget = new ImageBrush ();
            object retval;

            retval = widget.GetValue(Brush.OpacityProperty);
            Assert.IsNotNull(retval, "GetValue(Brush.OpacityProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Brush.OpacityProperty) is not of the correct type");
            Assert.AreEqual((double) 1, retval, "GetValue(Brush.OpacityProperty) does not match the default value");
            retval = widget.GetValue(Brush.TransformProperty);
            Assert.IsNull(retval, "GetValue(Brush.TransformProperty) should have returned null");
            retval = widget.GetValue(Brush.RelativeTransformProperty);
            Assert.IsNull(retval, "GetValue(Brush.RelativeTransformProperty) should have returned null");
        }

        [TestMethod]
	[MoonlightBug]
        public void Test_PropertyGetter_ImageBrush ()
        {
            ImageBrush widget = new ImageBrush ();

            Assert.IsNotNull(widget.ImageSource, "ImageSource should not have returned null");
            Assert.IsTrue(widget.ImageSource is BitmapImage, "ImageSource is not of the correct type");
            Assert.AreEqual(AlignmentX.Center, widget.AlignmentX, "AlignmentX does not match the default value");
            Assert.AreEqual(AlignmentY.Center, widget.AlignmentY, "AlignmentY does not match the default value");
            Assert.AreEqual(Stretch.Fill, widget.Stretch, "Stretch does not match the default value");
            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNull(widget.Transform, "Transform should have returned null");
            Assert.IsNull(widget.RelativeTransform, "RelativeTransform should have returned null");
        }

        [TestMethod]
	[MoonlightBug]
        public void Test_PropertyGetter_Brush ()
        {
            ImageBrush widget = new ImageBrush ();

            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNull(widget.Transform, "Transform should have returned null");
            Assert.IsNull(widget.RelativeTransform, "RelativeTransform should have returned null");
        }

    }
}
namespace MoonTest.System.Windows.Media
{
    public partial class VideoBrushTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_VideoBrush ()
        {
            VideoBrush widget = new VideoBrush ();
            object retval;

            retval = widget.ReadLocalValue(VideoBrush.SourceNameProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(VideoBrush.SourceNameProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_TileBrush ()
        {
            VideoBrush widget = new VideoBrush ();
            object retval;

            retval = widget.ReadLocalValue(TileBrush.AlignmentXProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(TileBrush.AlignmentXProperty) should not have a value by default");
            retval = widget.ReadLocalValue(TileBrush.AlignmentYProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(TileBrush.AlignmentYProperty) should not have a value by default");
            retval = widget.ReadLocalValue(TileBrush.StretchProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(TileBrush.StretchProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_Brush ()
        {
            VideoBrush widget = new VideoBrush ();
            object retval;

            retval = widget.ReadLocalValue(Brush.OpacityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Brush.OpacityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Brush.TransformProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Brush.TransformProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Brush.RelativeTransformProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Brush.RelativeTransformProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_VideoBrush ()
        {
            VideoBrush widget = new VideoBrush ();
            object retval;

            retval = widget.GetValue(VideoBrush.SourceNameProperty);
            Assert.IsNotNull(retval, "GetValue(VideoBrush.SourceNameProperty) should not have returned null");
            Assert.IsTrue(retval is string, "GetValue(VideoBrush.SourceNameProperty) is not of the correct type");
            Assert.AreEqual("", retval, "GetValue(VideoBrush.SourceNameProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_GetValue_TileBrush ()
        {
            VideoBrush widget = new VideoBrush ();
            object retval;

            retval = widget.GetValue(TileBrush.AlignmentXProperty);
            Assert.IsNotNull(retval, "GetValue(TileBrush.AlignmentXProperty) should not have returned null");
            Assert.IsTrue(retval is AlignmentX, "GetValue(TileBrush.AlignmentXProperty) is not of the correct type");
            Assert.AreEqual(AlignmentX.Center, retval, "GetValue(TileBrush.AlignmentXProperty) does not match the default value");
            retval = widget.GetValue(TileBrush.AlignmentYProperty);
            Assert.IsNotNull(retval, "GetValue(TileBrush.AlignmentYProperty) should not have returned null");
            Assert.IsTrue(retval is AlignmentY, "GetValue(TileBrush.AlignmentYProperty) is not of the correct type");
            Assert.AreEqual(AlignmentY.Center, retval, "GetValue(TileBrush.AlignmentYProperty) does not match the default value");
            retval = widget.GetValue(TileBrush.StretchProperty);
            Assert.IsNotNull(retval, "GetValue(TileBrush.StretchProperty) should not have returned null");
            Assert.IsTrue(retval is Stretch, "GetValue(TileBrush.StretchProperty) is not of the correct type");
            Assert.AreEqual(Stretch.Fill, retval, "GetValue(TileBrush.StretchProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_GetValue_Brush ()
        {
            VideoBrush widget = new VideoBrush ();
            object retval;

            retval = widget.GetValue(Brush.OpacityProperty);
            Assert.IsNotNull(retval, "GetValue(Brush.OpacityProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Brush.OpacityProperty) is not of the correct type");
            Assert.AreEqual((double) 1, retval, "GetValue(Brush.OpacityProperty) does not match the default value");
            retval = widget.GetValue(Brush.TransformProperty);
            Assert.IsNotNull(retval, "GetValue(Brush.TransformProperty) should not have returned null");
            Assert.IsTrue(retval is MatrixTransform, "GetValue(Brush.TransformProperty) is not of the correct type");
            retval = widget.GetValue(Brush.RelativeTransformProperty);
            Assert.IsNotNull(retval, "GetValue(Brush.RelativeTransformProperty) should not have returned null");
            Assert.IsTrue(retval is MatrixTransform, "GetValue(Brush.RelativeTransformProperty) is not of the correct type");
        }

        [TestMethod]
        public void Test_PropertyGetter_VideoBrush ()
        {
            VideoBrush widget = new VideoBrush ();

            Assert.IsNotNull(widget.SourceName, "SourceName should not have returned null");
            Assert.AreEqual("", widget.SourceName, "SourceName does not match the default value");
            Assert.AreEqual(AlignmentX.Center, widget.AlignmentX, "AlignmentX does not match the default value");
            Assert.AreEqual(AlignmentY.Center, widget.AlignmentY, "AlignmentY does not match the default value");
            Assert.AreEqual(Stretch.Fill, widget.Stretch, "Stretch does not match the default value");
            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNotNull(widget.Transform, "Transform should not have returned null");
            Assert.IsTrue(widget.Transform is MatrixTransform, "Transform is not of the correct type");
            Assert.IsNotNull(widget.RelativeTransform, "RelativeTransform should not have returned null");
            Assert.IsTrue(widget.RelativeTransform is MatrixTransform, "RelativeTransform is not of the correct type");
        }

        [TestMethod]
        public void Test_PropertyGetter_Brush ()
        {
            VideoBrush widget = new VideoBrush ();

            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNotNull(widget.Transform, "Transform should not have returned null");
            Assert.IsTrue(widget.Transform is MatrixTransform, "Transform is not of the correct type");
            Assert.IsNotNull(widget.RelativeTransform, "RelativeTransform should not have returned null");
            Assert.IsTrue(widget.RelativeTransform is MatrixTransform, "RelativeTransform is not of the correct type");
        }

        [TestMethod]
	[MoonlightBug]
        public void Test_SetStringValue_VideoBrush ()
        {
            VideoBrush widget = new VideoBrush ();
            object retval;

            widget.SetValue(VideoBrush.SourceNameProperty, "some text");
            retval = widget.GetValue(VideoBrush.SourceNameProperty);
            Assert.AreEqual("some text", retval, "GetValue(VideoBrush.SourceNameProperty) should have returned 'some text'");
            widget.SetValue(VideoBrush.SourceNameProperty, null);
            retval = widget.GetValue(VideoBrush.SourceNameProperty);
            Assert.AreEqual(String.Empty, retval, "GetValue(VideoBrush.SourceNameProperty) should have returned String.Empty");
            retval = widget.ReadLocalValue(VideoBrush.SourceNameProperty);
            Assert.AreEqual(String.Empty, retval, "ReadLocalValue(VideoBrush.SourceNameProperty) should have returned String.Empty");
        }

    }
}
namespace MoonTest.System.Windows.Media
{
    public partial class TimelineMarkerTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_TimelineMarker ()
        {
            TimelineMarker widget = new TimelineMarker ();
            object retval;

            retval = widget.ReadLocalValue(TimelineMarker.TimeProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(TimelineMarker.TimeProperty) should not have a value by default");
            retval = widget.ReadLocalValue(TimelineMarker.TypeProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(TimelineMarker.TypeProperty) should not have a value by default");
            retval = widget.ReadLocalValue(TimelineMarker.TextProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(TimelineMarker.TextProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_TimelineMarker ()
        {
            TimelineMarker widget = new TimelineMarker ();
            object retval;

            retval = widget.GetValue(TimelineMarker.TimeProperty);
            Assert.IsNotNull(retval, "GetValue(TimelineMarker.TimeProperty) should not have returned null");
            Assert.IsTrue(retval is TimeSpan, "GetValue(TimelineMarker.TimeProperty) is not of the correct type");
            Assert.AreEqual("00:00:00", retval.ToString (), "GetValue(TimelineMarker.TimeProperty) does not match the default value");
            retval = widget.GetValue(TimelineMarker.TypeProperty);
            Assert.IsNull(retval, "GetValue(TimelineMarker.TypeProperty) should have returned null");
            retval = widget.GetValue(TimelineMarker.TextProperty);
            Assert.IsNull(retval, "GetValue(TimelineMarker.TextProperty) should have returned null");
        }

        [TestMethod]
        public void Test_PropertyGetter_TimelineMarker ()
        {
            TimelineMarker widget = new TimelineMarker ();

            Assert.AreEqual("00:00:00", widget.Time.ToString (), "Time does not match the default value");
            Assert.IsNull(widget.Type, "Type should have returned null");
            Assert.IsNull(widget.Text, "Text should have returned null");
        }

        [TestMethod]
        public void Test_SetStringValue_TimelineMarker ()
        {
            TimelineMarker widget = new TimelineMarker ();
            object retval;

            widget.SetValue(TimelineMarker.TypeProperty, "some text");
            retval = widget.GetValue(TimelineMarker.TypeProperty);
            Assert.AreEqual("some text", retval, "GetValue(TimelineMarker.TypeProperty) should have returned 'some text'");
            widget.SetValue(TimelineMarker.TypeProperty, null);
            retval = widget.GetValue(TimelineMarker.TypeProperty);
            Assert.IsNull(retval, "GetValue(TimelineMarker.TypeProperty) should have returned null");
            widget.SetValue(TimelineMarker.TextProperty, "some text");
            retval = widget.GetValue(TimelineMarker.TextProperty);
            Assert.AreEqual("some text", retval, "GetValue(TimelineMarker.TextProperty) should have returned 'some text'");
            widget.SetValue(TimelineMarker.TextProperty, null);
            retval = widget.GetValue(TimelineMarker.TextProperty);
            Assert.IsNull(retval, "GetValue(TimelineMarker.TextProperty) should have returned null");
        }

    }
}
namespace MoonTest.System.Windows.Media
{
    public partial class TimelineMarkerCollectionTest
    {
        [TestMethod]
        public void Test_PropertyGetter_TimelineMarkerCollection ()
        {
            TimelineMarkerCollection widget = new TimelineMarkerCollection ();

            Assert.AreEqual(false, widget.IsFixedSize, "IsFixedSize does not match the default value");
            Assert.AreEqual(false, widget.IsReadOnly, "IsReadOnly does not match the default value");
            Assert.AreEqual(0, widget.Count, "Count does not match the default value");
            Assert.AreEqual(false, widget.IsSynchronized, "IsSynchronized does not match the default value");
            Assert.IsNotNull(widget.SyncRoot, "SyncRoot should not have returned null");
            Assert.IsTrue(widget.SyncRoot is TimelineMarkerCollection, "SyncRoot is not of the correct type");
        }

    }
}
namespace MoonTest.System.Windows.Media.Animation
{
    public partial class BeginStoryboardTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_BeginStoryboard ()
        {
            BeginStoryboard widget = new BeginStoryboard ();
            object retval;

            retval = widget.ReadLocalValue(BeginStoryboard.StoryboardProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(BeginStoryboard.StoryboardProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_BeginStoryboard ()
        {
            BeginStoryboard widget = new BeginStoryboard ();
            object retval;

            retval = widget.GetValue(BeginStoryboard.StoryboardProperty);
            Assert.IsNull(retval, "GetValue(BeginStoryboard.StoryboardProperty) should have returned null");
        }

        [TestMethod]
        public void Test_PropertyGetter_BeginStoryboard ()
        {
            BeginStoryboard widget = new BeginStoryboard ();

            Assert.IsNull(widget.Storyboard, "Storyboard should have returned null");
        }

    }
}
namespace MoonTest.System.Windows.Media.Animation
{
    public partial class StoryboardTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_Storyboard ()
        {
            Storyboard widget = new Storyboard ();
            object retval;

            retval = widget.ReadLocalValue(Storyboard.TargetPropertyProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Storyboard.TargetPropertyProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Storyboard.TargetNameProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Storyboard.TargetNameProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_Timeline ()
        {
            Storyboard widget = new Storyboard ();
            object retval;

            retval = widget.ReadLocalValue(Timeline.AutoReverseProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Timeline.AutoReverseProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Timeline.BeginTimeProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Timeline.BeginTimeProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Timeline.DurationProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Timeline.DurationProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Timeline.SpeedRatioProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Timeline.SpeedRatioProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Timeline.FillBehaviorProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Timeline.FillBehaviorProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Timeline.RepeatBehaviorProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Timeline.RepeatBehaviorProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_Storyboard ()
        {
            Storyboard widget = new Storyboard ();
            object retval;

            retval = widget.GetValue(Storyboard.TargetPropertyProperty);
            Assert.IsNull(retval, "GetValue(Storyboard.TargetPropertyProperty) should have returned null");
            retval = widget.GetValue(Storyboard.TargetNameProperty);
            Assert.IsNull(retval, "GetValue(Storyboard.TargetNameProperty) should have returned null");
        }

        [TestMethod]
        public void Test_GetValue_Timeline ()
        {
            Storyboard widget = new Storyboard ();
            object retval;

            retval = widget.GetValue(Timeline.AutoReverseProperty);
            Assert.IsNotNull(retval, "GetValue(Timeline.AutoReverseProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(Timeline.AutoReverseProperty) is not of the correct type");
            Assert.AreEqual(false, retval, "GetValue(Timeline.AutoReverseProperty) does not match the default value");
            retval = widget.GetValue(Timeline.BeginTimeProperty);
            Assert.IsNotNull(retval, "GetValue(Timeline.BeginTimeProperty) should not have returned null");
            Assert.IsTrue(retval is TimeSpan, "GetValue(Timeline.BeginTimeProperty) is not of the correct type");
            Assert.AreEqual("00:00:00", retval.ToString (), "GetValue(Timeline.BeginTimeProperty) does not match the default value");
            retval = widget.GetValue(Timeline.DurationProperty);
            Assert.IsNotNull(retval, "GetValue(Timeline.DurationProperty) should not have returned null");
            Assert.IsTrue(retval is Duration, "GetValue(Timeline.DurationProperty) is not of the correct type");
            Assert.AreEqual("Automatic", retval.ToString (), "GetValue(Timeline.DurationProperty) does not match the default value");
            retval = widget.GetValue(Timeline.SpeedRatioProperty);
            Assert.IsNotNull(retval, "GetValue(Timeline.SpeedRatioProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Timeline.SpeedRatioProperty) is not of the correct type");
            Assert.AreEqual((double) 1, retval, "GetValue(Timeline.SpeedRatioProperty) does not match the default value");
            retval = widget.GetValue(Timeline.FillBehaviorProperty);
            Assert.IsNotNull(retval, "GetValue(Timeline.FillBehaviorProperty) should not have returned null");
            Assert.IsTrue(retval is FillBehavior, "GetValue(Timeline.FillBehaviorProperty) is not of the correct type");
            Assert.AreEqual(FillBehavior.HoldEnd, retval, "GetValue(Timeline.FillBehaviorProperty) does not match the default value");
            retval = widget.GetValue(Timeline.RepeatBehaviorProperty);
            Assert.IsNotNull(retval, "GetValue(Timeline.RepeatBehaviorProperty) should not have returned null");
            Assert.IsTrue(retval is RepeatBehavior, "GetValue(Timeline.RepeatBehaviorProperty) is not of the correct type");
            Assert.AreEqual("1x", retval.ToString (), "GetValue(Timeline.RepeatBehaviorProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_Storyboard ()
        {
            Storyboard widget = new Storyboard ();

            Assert.IsNotNull(widget.Children, "Children should not have returned null");
            Assert.IsTrue(widget.Children is TimelineCollection, "Children is not of the correct type");
            Assert.AreEqual(false, widget.AutoReverse, "AutoReverse does not match the default value");
            Assert.AreEqual("00:00:00", widget.BeginTime.ToString (), "BeginTime does not match the default value");
            Assert.AreEqual("Automatic", widget.Duration.ToString (), "Duration does not match the default value");
            Assert.AreEqual((double) 1, widget.SpeedRatio, "SpeedRatio does not match the default value");
            Assert.AreEqual(FillBehavior.HoldEnd, widget.FillBehavior, "FillBehavior does not match the default value");
            Assert.AreEqual("1x", widget.RepeatBehavior.ToString (), "RepeatBehavior does not match the default value");
        }

    }
}
namespace MoonTest.System.Windows.Media.Animation
{
    public partial class DoubleAnimationTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_DoubleAnimation ()
        {
            DoubleAnimation widget = new DoubleAnimation ();
            object retval;

            retval = widget.ReadLocalValue(DoubleAnimation.FromProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(DoubleAnimation.FromProperty) should not have a value by default");
            retval = widget.ReadLocalValue(DoubleAnimation.ToProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(DoubleAnimation.ToProperty) should not have a value by default");
            retval = widget.ReadLocalValue(DoubleAnimation.ByProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(DoubleAnimation.ByProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_Timeline ()
        {
            DoubleAnimation widget = new DoubleAnimation ();
            object retval;

            retval = widget.ReadLocalValue(Timeline.AutoReverseProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Timeline.AutoReverseProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Timeline.BeginTimeProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Timeline.BeginTimeProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Timeline.DurationProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Timeline.DurationProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Timeline.SpeedRatioProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Timeline.SpeedRatioProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Timeline.FillBehaviorProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Timeline.FillBehaviorProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Timeline.RepeatBehaviorProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Timeline.RepeatBehaviorProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_DoubleAnimation ()
        {
            DoubleAnimation widget = new DoubleAnimation ();
            object retval;

            retval = widget.GetValue(DoubleAnimation.FromProperty);
            Assert.IsNull(retval, "GetValue(DoubleAnimation.FromProperty) should have returned null");
            retval = widget.GetValue(DoubleAnimation.ToProperty);
            Assert.IsNull(retval, "GetValue(DoubleAnimation.ToProperty) should have returned null");
            retval = widget.GetValue(DoubleAnimation.ByProperty);
            Assert.IsNull(retval, "GetValue(DoubleAnimation.ByProperty) should have returned null");
        }

        [TestMethod]
        public void Test_GetValue_Timeline ()
        {
            DoubleAnimation widget = new DoubleAnimation ();
            object retval;

            retval = widget.GetValue(Timeline.AutoReverseProperty);
            Assert.IsNotNull(retval, "GetValue(Timeline.AutoReverseProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(Timeline.AutoReverseProperty) is not of the correct type");
            Assert.AreEqual(false, retval, "GetValue(Timeline.AutoReverseProperty) does not match the default value");
            retval = widget.GetValue(Timeline.BeginTimeProperty);
            Assert.IsNotNull(retval, "GetValue(Timeline.BeginTimeProperty) should not have returned null");
            Assert.IsTrue(retval is TimeSpan, "GetValue(Timeline.BeginTimeProperty) is not of the correct type");
            Assert.AreEqual("00:00:00", retval.ToString (), "GetValue(Timeline.BeginTimeProperty) does not match the default value");
            retval = widget.GetValue(Timeline.DurationProperty);
            Assert.IsNotNull(retval, "GetValue(Timeline.DurationProperty) should not have returned null");
            Assert.IsTrue(retval is Duration, "GetValue(Timeline.DurationProperty) is not of the correct type");
            Assert.AreEqual("Automatic", retval.ToString (), "GetValue(Timeline.DurationProperty) does not match the default value");
            retval = widget.GetValue(Timeline.SpeedRatioProperty);
            Assert.IsNotNull(retval, "GetValue(Timeline.SpeedRatioProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Timeline.SpeedRatioProperty) is not of the correct type");
            Assert.AreEqual((double) 1, retval, "GetValue(Timeline.SpeedRatioProperty) does not match the default value");
            retval = widget.GetValue(Timeline.FillBehaviorProperty);
            Assert.IsNotNull(retval, "GetValue(Timeline.FillBehaviorProperty) should not have returned null");
            Assert.IsTrue(retval is FillBehavior, "GetValue(Timeline.FillBehaviorProperty) is not of the correct type");
            Assert.AreEqual(FillBehavior.HoldEnd, retval, "GetValue(Timeline.FillBehaviorProperty) does not match the default value");
            retval = widget.GetValue(Timeline.RepeatBehaviorProperty);
            Assert.IsNotNull(retval, "GetValue(Timeline.RepeatBehaviorProperty) should not have returned null");
            Assert.IsTrue(retval is RepeatBehavior, "GetValue(Timeline.RepeatBehaviorProperty) is not of the correct type");
            Assert.AreEqual("1x", retval.ToString (), "GetValue(Timeline.RepeatBehaviorProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_DoubleAnimation ()
        {
            DoubleAnimation widget = new DoubleAnimation ();

            Assert.IsNull(widget.From, "From should have returned null");
            Assert.IsNull(widget.To, "To should have returned null");
            Assert.IsNull(widget.By, "By should have returned null");
            Assert.AreEqual(false, widget.AutoReverse, "AutoReverse does not match the default value");
            Assert.AreEqual("00:00:00", widget.BeginTime.ToString (), "BeginTime does not match the default value");
            Assert.AreEqual("Automatic", widget.Duration.ToString (), "Duration does not match the default value");
            Assert.AreEqual((double) 1, widget.SpeedRatio, "SpeedRatio does not match the default value");
            Assert.AreEqual(FillBehavior.HoldEnd, widget.FillBehavior, "FillBehavior does not match the default value");
            Assert.AreEqual("1x", widget.RepeatBehavior.ToString (), "RepeatBehavior does not match the default value");
        }

    }
}
namespace MoonTest.System.Windows.Media.Animation
{
    public partial class ColorAnimationTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_ColorAnimation ()
        {
            ColorAnimation widget = new ColorAnimation ();
            object retval;

            retval = widget.ReadLocalValue(ColorAnimation.FromProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(ColorAnimation.FromProperty) should not have a value by default");
            retval = widget.ReadLocalValue(ColorAnimation.ToProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(ColorAnimation.ToProperty) should not have a value by default");
            retval = widget.ReadLocalValue(ColorAnimation.ByProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(ColorAnimation.ByProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_Timeline ()
        {
            ColorAnimation widget = new ColorAnimation ();
            object retval;

            retval = widget.ReadLocalValue(Timeline.AutoReverseProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Timeline.AutoReverseProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Timeline.BeginTimeProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Timeline.BeginTimeProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Timeline.DurationProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Timeline.DurationProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Timeline.SpeedRatioProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Timeline.SpeedRatioProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Timeline.FillBehaviorProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Timeline.FillBehaviorProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Timeline.RepeatBehaviorProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Timeline.RepeatBehaviorProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_ColorAnimation ()
        {
            ColorAnimation widget = new ColorAnimation ();
            object retval;

            retval = widget.GetValue(ColorAnimation.FromProperty);
            Assert.IsNull(retval, "GetValue(ColorAnimation.FromProperty) should have returned null");
            retval = widget.GetValue(ColorAnimation.ToProperty);
            Assert.IsNull(retval, "GetValue(ColorAnimation.ToProperty) should have returned null");
            retval = widget.GetValue(ColorAnimation.ByProperty);
            Assert.IsNull(retval, "GetValue(ColorAnimation.ByProperty) should have returned null");
        }

        [TestMethod]
        public void Test_GetValue_Timeline ()
        {
            ColorAnimation widget = new ColorAnimation ();
            object retval;

            retval = widget.GetValue(Timeline.AutoReverseProperty);
            Assert.IsNotNull(retval, "GetValue(Timeline.AutoReverseProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(Timeline.AutoReverseProperty) is not of the correct type");
            Assert.AreEqual(false, retval, "GetValue(Timeline.AutoReverseProperty) does not match the default value");
            retval = widget.GetValue(Timeline.BeginTimeProperty);
            Assert.IsNotNull(retval, "GetValue(Timeline.BeginTimeProperty) should not have returned null");
            Assert.IsTrue(retval is TimeSpan, "GetValue(Timeline.BeginTimeProperty) is not of the correct type");
            Assert.AreEqual("00:00:00", retval.ToString (), "GetValue(Timeline.BeginTimeProperty) does not match the default value");
            retval = widget.GetValue(Timeline.DurationProperty);
            Assert.IsNotNull(retval, "GetValue(Timeline.DurationProperty) should not have returned null");
            Assert.IsTrue(retval is Duration, "GetValue(Timeline.DurationProperty) is not of the correct type");
            Assert.AreEqual("Automatic", retval.ToString (), "GetValue(Timeline.DurationProperty) does not match the default value");
            retval = widget.GetValue(Timeline.SpeedRatioProperty);
            Assert.IsNotNull(retval, "GetValue(Timeline.SpeedRatioProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Timeline.SpeedRatioProperty) is not of the correct type");
            Assert.AreEqual((double) 1, retval, "GetValue(Timeline.SpeedRatioProperty) does not match the default value");
            retval = widget.GetValue(Timeline.FillBehaviorProperty);
            Assert.IsNotNull(retval, "GetValue(Timeline.FillBehaviorProperty) should not have returned null");
            Assert.IsTrue(retval is FillBehavior, "GetValue(Timeline.FillBehaviorProperty) is not of the correct type");
            Assert.AreEqual(FillBehavior.HoldEnd, retval, "GetValue(Timeline.FillBehaviorProperty) does not match the default value");
            retval = widget.GetValue(Timeline.RepeatBehaviorProperty);
            Assert.IsNotNull(retval, "GetValue(Timeline.RepeatBehaviorProperty) should not have returned null");
            Assert.IsTrue(retval is RepeatBehavior, "GetValue(Timeline.RepeatBehaviorProperty) is not of the correct type");
            Assert.AreEqual("1x", retval.ToString (), "GetValue(Timeline.RepeatBehaviorProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_ColorAnimation ()
        {
            ColorAnimation widget = new ColorAnimation ();

            Assert.IsNull(widget.From, "From should have returned null");
            Assert.IsNull(widget.To, "To should have returned null");
            Assert.IsNull(widget.By, "By should have returned null");
            Assert.AreEqual(false, widget.AutoReverse, "AutoReverse does not match the default value");
            Assert.AreEqual("00:00:00", widget.BeginTime.ToString (), "BeginTime does not match the default value");
            Assert.AreEqual("Automatic", widget.Duration.ToString (), "Duration does not match the default value");
            Assert.AreEqual((double) 1, widget.SpeedRatio, "SpeedRatio does not match the default value");
            Assert.AreEqual(FillBehavior.HoldEnd, widget.FillBehavior, "FillBehavior does not match the default value");
            Assert.AreEqual("1x", widget.RepeatBehavior.ToString (), "RepeatBehavior does not match the default value");
        }

    }
}
namespace MoonTest.System.Windows.Media.Animation
{
    public partial class PointAnimationTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_PointAnimation ()
        {
            PointAnimation widget = new PointAnimation ();
            object retval;

            retval = widget.ReadLocalValue(PointAnimation.FromProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(PointAnimation.FromProperty) should not have a value by default");
            retval = widget.ReadLocalValue(PointAnimation.ToProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(PointAnimation.ToProperty) should not have a value by default");
            retval = widget.ReadLocalValue(PointAnimation.ByProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(PointAnimation.ByProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_Timeline ()
        {
            PointAnimation widget = new PointAnimation ();
            object retval;

            retval = widget.ReadLocalValue(Timeline.AutoReverseProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Timeline.AutoReverseProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Timeline.BeginTimeProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Timeline.BeginTimeProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Timeline.DurationProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Timeline.DurationProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Timeline.SpeedRatioProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Timeline.SpeedRatioProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Timeline.FillBehaviorProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Timeline.FillBehaviorProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Timeline.RepeatBehaviorProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Timeline.RepeatBehaviorProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_PointAnimation ()
        {
            PointAnimation widget = new PointAnimation ();
            object retval;

            retval = widget.GetValue(PointAnimation.FromProperty);
            Assert.IsNull(retval, "GetValue(PointAnimation.FromProperty) should have returned null");
            retval = widget.GetValue(PointAnimation.ToProperty);
            Assert.IsNull(retval, "GetValue(PointAnimation.ToProperty) should have returned null");
            retval = widget.GetValue(PointAnimation.ByProperty);
            Assert.IsNull(retval, "GetValue(PointAnimation.ByProperty) should have returned null");
        }

        [TestMethod]
        public void Test_GetValue_Timeline ()
        {
            PointAnimation widget = new PointAnimation ();
            object retval;

            retval = widget.GetValue(Timeline.AutoReverseProperty);
            Assert.IsNotNull(retval, "GetValue(Timeline.AutoReverseProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(Timeline.AutoReverseProperty) is not of the correct type");
            Assert.AreEqual(false, retval, "GetValue(Timeline.AutoReverseProperty) does not match the default value");
            retval = widget.GetValue(Timeline.BeginTimeProperty);
            Assert.IsNotNull(retval, "GetValue(Timeline.BeginTimeProperty) should not have returned null");
            Assert.IsTrue(retval is TimeSpan, "GetValue(Timeline.BeginTimeProperty) is not of the correct type");
            Assert.AreEqual("00:00:00", retval.ToString (), "GetValue(Timeline.BeginTimeProperty) does not match the default value");
            retval = widget.GetValue(Timeline.DurationProperty);
            Assert.IsNotNull(retval, "GetValue(Timeline.DurationProperty) should not have returned null");
            Assert.IsTrue(retval is Duration, "GetValue(Timeline.DurationProperty) is not of the correct type");
            Assert.AreEqual("Automatic", retval.ToString (), "GetValue(Timeline.DurationProperty) does not match the default value");
            retval = widget.GetValue(Timeline.SpeedRatioProperty);
            Assert.IsNotNull(retval, "GetValue(Timeline.SpeedRatioProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Timeline.SpeedRatioProperty) is not of the correct type");
            Assert.AreEqual((double) 1, retval, "GetValue(Timeline.SpeedRatioProperty) does not match the default value");
            retval = widget.GetValue(Timeline.FillBehaviorProperty);
            Assert.IsNotNull(retval, "GetValue(Timeline.FillBehaviorProperty) should not have returned null");
            Assert.IsTrue(retval is FillBehavior, "GetValue(Timeline.FillBehaviorProperty) is not of the correct type");
            Assert.AreEqual(FillBehavior.HoldEnd, retval, "GetValue(Timeline.FillBehaviorProperty) does not match the default value");
            retval = widget.GetValue(Timeline.RepeatBehaviorProperty);
            Assert.IsNotNull(retval, "GetValue(Timeline.RepeatBehaviorProperty) should not have returned null");
            Assert.IsTrue(retval is RepeatBehavior, "GetValue(Timeline.RepeatBehaviorProperty) is not of the correct type");
            Assert.AreEqual("1x", retval.ToString (), "GetValue(Timeline.RepeatBehaviorProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_PointAnimation ()
        {
            PointAnimation widget = new PointAnimation ();

            Assert.IsNull(widget.From, "From should have returned null");
            Assert.IsNull(widget.To, "To should have returned null");
            Assert.IsNull(widget.By, "By should have returned null");
            Assert.AreEqual(false, widget.AutoReverse, "AutoReverse does not match the default value");
            Assert.AreEqual("00:00:00", widget.BeginTime.ToString (), "BeginTime does not match the default value");
            Assert.AreEqual("Automatic", widget.Duration.ToString (), "Duration does not match the default value");
            Assert.AreEqual((double) 1, widget.SpeedRatio, "SpeedRatio does not match the default value");
            Assert.AreEqual(FillBehavior.HoldEnd, widget.FillBehavior, "FillBehavior does not match the default value");
            Assert.AreEqual("1x", widget.RepeatBehavior.ToString (), "RepeatBehavior does not match the default value");
        }

    }
}
namespace MoonTest.System.Windows.Media.Animation
{
    public partial class KeySplineTest
    {
        [TestMethod]
        public void Test_PropertyGetter_KeySpline ()
        {
            KeySpline widget = new KeySpline ();

            Assert.AreEqual("0,0", widget.ControlPoint1.ToString (), "ControlPoint1 does not match the default value");
            Assert.AreEqual("1,1", widget.ControlPoint2.ToString (), "ControlPoint2 does not match the default value");
        }

    }
}
namespace MoonTest.System.Windows.Media.Animation
{
    public partial class ColorKeyFrameCollectionTest
    {
        [TestMethod]
        public void Test_PropertyGetter_ColorKeyFrameCollection ()
        {
            ColorKeyFrameCollection widget = new ColorKeyFrameCollection ();

            Assert.AreEqual(false, widget.IsFixedSize, "IsFixedSize does not match the default value");
            Assert.AreEqual(false, widget.IsReadOnly, "IsReadOnly does not match the default value");
            Assert.AreEqual(0, widget.Count, "Count does not match the default value");
            Assert.AreEqual(false, widget.IsSynchronized, "IsSynchronized does not match the default value");
            Assert.IsNotNull(widget.SyncRoot, "SyncRoot should not have returned null");
            Assert.IsTrue(widget.SyncRoot is ColorKeyFrameCollection, "SyncRoot is not of the correct type");
        }

    }
}
namespace MoonTest.System.Windows.Media.Animation
{
    public partial class DoubleKeyFrameCollectionTest
    {
        [TestMethod]
        public void Test_PropertyGetter_DoubleKeyFrameCollection ()
        {
            DoubleKeyFrameCollection widget = new DoubleKeyFrameCollection ();

            Assert.AreEqual(false, widget.IsFixedSize, "IsFixedSize does not match the default value");
            Assert.AreEqual(false, widget.IsReadOnly, "IsReadOnly does not match the default value");
            Assert.AreEqual(0, widget.Count, "Count does not match the default value");
            Assert.AreEqual(false, widget.IsSynchronized, "IsSynchronized does not match the default value");
            Assert.IsNotNull(widget.SyncRoot, "SyncRoot should not have returned null");
            Assert.IsTrue(widget.SyncRoot is DoubleKeyFrameCollection, "SyncRoot is not of the correct type");
        }

    }
}
namespace MoonTest.System.Windows.Media.Animation
{
    public partial class PointKeyFrameCollectionTest
    {
        [TestMethod]
        public void Test_PropertyGetter_PointKeyFrameCollection ()
        {
            PointKeyFrameCollection widget = new PointKeyFrameCollection ();

            Assert.AreEqual(false, widget.IsFixedSize, "IsFixedSize does not match the default value");
            Assert.AreEqual(false, widget.IsReadOnly, "IsReadOnly does not match the default value");
            Assert.AreEqual(0, widget.Count, "Count does not match the default value");
            Assert.AreEqual(false, widget.IsSynchronized, "IsSynchronized does not match the default value");
            Assert.IsNotNull(widget.SyncRoot, "SyncRoot should not have returned null");
            Assert.IsTrue(widget.SyncRoot is PointKeyFrameCollection, "SyncRoot is not of the correct type");
        }

    }
}
namespace MoonTest.System.Windows.Media.Animation
{
    public partial class ObjectKeyFrameCollectionTest
    {
        [TestMethod]
        public void Test_PropertyGetter_ObjectKeyFrameCollection ()
        {
            ObjectKeyFrameCollection widget = new ObjectKeyFrameCollection ();

            Assert.AreEqual(false, widget.IsFixedSize, "IsFixedSize does not match the default value");
            Assert.AreEqual(false, widget.IsReadOnly, "IsReadOnly does not match the default value");
            Assert.AreEqual(0, widget.Count, "Count does not match the default value");
            Assert.AreEqual(false, widget.IsSynchronized, "IsSynchronized does not match the default value");
            Assert.IsNotNull(widget.SyncRoot, "SyncRoot should not have returned null");
            Assert.IsTrue(widget.SyncRoot is ObjectKeyFrameCollection, "SyncRoot is not of the correct type");
        }

    }
}
namespace MoonTest.System.Windows.Media.Animation
{
    public partial class DoubleAnimationUsingKeyFramesTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_Timeline ()
        {
            DoubleAnimationUsingKeyFrames widget = new DoubleAnimationUsingKeyFrames ();
            object retval;

            retval = widget.ReadLocalValue(Timeline.AutoReverseProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Timeline.AutoReverseProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Timeline.BeginTimeProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Timeline.BeginTimeProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Timeline.DurationProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Timeline.DurationProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Timeline.SpeedRatioProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Timeline.SpeedRatioProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Timeline.FillBehaviorProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Timeline.FillBehaviorProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Timeline.RepeatBehaviorProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Timeline.RepeatBehaviorProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_Timeline ()
        {
            DoubleAnimationUsingKeyFrames widget = new DoubleAnimationUsingKeyFrames ();
            object retval;

            retval = widget.GetValue(Timeline.AutoReverseProperty);
            Assert.IsNotNull(retval, "GetValue(Timeline.AutoReverseProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(Timeline.AutoReverseProperty) is not of the correct type");
            Assert.AreEqual(false, retval, "GetValue(Timeline.AutoReverseProperty) does not match the default value");
            retval = widget.GetValue(Timeline.BeginTimeProperty);
            Assert.IsNotNull(retval, "GetValue(Timeline.BeginTimeProperty) should not have returned null");
            Assert.IsTrue(retval is TimeSpan, "GetValue(Timeline.BeginTimeProperty) is not of the correct type");
            Assert.AreEqual("00:00:00", retval.ToString (), "GetValue(Timeline.BeginTimeProperty) does not match the default value");
            retval = widget.GetValue(Timeline.DurationProperty);
            Assert.IsNotNull(retval, "GetValue(Timeline.DurationProperty) should not have returned null");
            Assert.IsTrue(retval is Duration, "GetValue(Timeline.DurationProperty) is not of the correct type");
            Assert.AreEqual("Automatic", retval.ToString (), "GetValue(Timeline.DurationProperty) does not match the default value");
            retval = widget.GetValue(Timeline.SpeedRatioProperty);
            Assert.IsNotNull(retval, "GetValue(Timeline.SpeedRatioProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Timeline.SpeedRatioProperty) is not of the correct type");
            Assert.AreEqual((double) 1, retval, "GetValue(Timeline.SpeedRatioProperty) does not match the default value");
            retval = widget.GetValue(Timeline.FillBehaviorProperty);
            Assert.IsNotNull(retval, "GetValue(Timeline.FillBehaviorProperty) should not have returned null");
            Assert.IsTrue(retval is FillBehavior, "GetValue(Timeline.FillBehaviorProperty) is not of the correct type");
            Assert.AreEqual(FillBehavior.HoldEnd, retval, "GetValue(Timeline.FillBehaviorProperty) does not match the default value");
            retval = widget.GetValue(Timeline.RepeatBehaviorProperty);
            Assert.IsNotNull(retval, "GetValue(Timeline.RepeatBehaviorProperty) should not have returned null");
            Assert.IsTrue(retval is RepeatBehavior, "GetValue(Timeline.RepeatBehaviorProperty) is not of the correct type");
            Assert.AreEqual("1x", retval.ToString (), "GetValue(Timeline.RepeatBehaviorProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_DoubleAnimationUsingKeyFrames ()
        {
            DoubleAnimationUsingKeyFrames widget = new DoubleAnimationUsingKeyFrames ();

            Assert.IsNotNull(widget.KeyFrames, "KeyFrames should not have returned null");
            Assert.IsTrue(widget.KeyFrames is DoubleKeyFrameCollection, "KeyFrames is not of the correct type");
            Assert.AreEqual(false, widget.AutoReverse, "AutoReverse does not match the default value");
            Assert.AreEqual("00:00:00", widget.BeginTime.ToString (), "BeginTime does not match the default value");
            Assert.AreEqual("Automatic", widget.Duration.ToString (), "Duration does not match the default value");
            Assert.AreEqual((double) 1, widget.SpeedRatio, "SpeedRatio does not match the default value");
            Assert.AreEqual(FillBehavior.HoldEnd, widget.FillBehavior, "FillBehavior does not match the default value");
            Assert.AreEqual("1x", widget.RepeatBehavior.ToString (), "RepeatBehavior does not match the default value");
        }

    }
}
namespace MoonTest.System.Windows.Media.Animation
{
    public partial class DiscreteDoubleKeyFrameTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_DoubleKeyFrame ()
        {
            DiscreteDoubleKeyFrame widget = new DiscreteDoubleKeyFrame ();
            object retval;

            retval = widget.ReadLocalValue(DoubleKeyFrame.ValueProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(DoubleKeyFrame.ValueProperty) should not have a value by default");
            retval = widget.ReadLocalValue(DoubleKeyFrame.KeyTimeProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(DoubleKeyFrame.KeyTimeProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_DoubleKeyFrame ()
        {
            DiscreteDoubleKeyFrame widget = new DiscreteDoubleKeyFrame ();
            object retval;

            retval = widget.GetValue(DoubleKeyFrame.ValueProperty);
            Assert.IsNotNull(retval, "GetValue(DoubleKeyFrame.ValueProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(DoubleKeyFrame.ValueProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(DoubleKeyFrame.ValueProperty) does not match the default value");
            retval = widget.GetValue(DoubleKeyFrame.KeyTimeProperty);
            Assert.IsNotNull(retval, "GetValue(DoubleKeyFrame.KeyTimeProperty) should not have returned null");
            Assert.IsTrue(retval is KeyTime, "GetValue(DoubleKeyFrame.KeyTimeProperty) is not of the correct type");
            Assert.AreEqual("Uniform", retval.ToString (), "GetValue(DoubleKeyFrame.KeyTimeProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_DiscreteDoubleKeyFrame ()
        {
            DiscreteDoubleKeyFrame widget = new DiscreteDoubleKeyFrame ();

            Assert.AreEqual((double) 0, widget.Value, "Value does not match the default value");
            Assert.AreEqual("Uniform", widget.KeyTime.ToString (), "KeyTime does not match the default value");
        }

    }
}
namespace MoonTest.System.Windows.Media.Animation
{
    public partial class LinearDoubleKeyFrameTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_DoubleKeyFrame ()
        {
            LinearDoubleKeyFrame widget = new LinearDoubleKeyFrame ();
            object retval;

            retval = widget.ReadLocalValue(DoubleKeyFrame.ValueProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(DoubleKeyFrame.ValueProperty) should not have a value by default");
            retval = widget.ReadLocalValue(DoubleKeyFrame.KeyTimeProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(DoubleKeyFrame.KeyTimeProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_DoubleKeyFrame ()
        {
            LinearDoubleKeyFrame widget = new LinearDoubleKeyFrame ();
            object retval;

            retval = widget.GetValue(DoubleKeyFrame.ValueProperty);
            Assert.IsNotNull(retval, "GetValue(DoubleKeyFrame.ValueProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(DoubleKeyFrame.ValueProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(DoubleKeyFrame.ValueProperty) does not match the default value");
            retval = widget.GetValue(DoubleKeyFrame.KeyTimeProperty);
            Assert.IsNotNull(retval, "GetValue(DoubleKeyFrame.KeyTimeProperty) should not have returned null");
            Assert.IsTrue(retval is KeyTime, "GetValue(DoubleKeyFrame.KeyTimeProperty) is not of the correct type");
            Assert.AreEqual("Uniform", retval.ToString (), "GetValue(DoubleKeyFrame.KeyTimeProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_LinearDoubleKeyFrame ()
        {
            LinearDoubleKeyFrame widget = new LinearDoubleKeyFrame ();

            Assert.AreEqual((double) 0, widget.Value, "Value does not match the default value");
            Assert.AreEqual("Uniform", widget.KeyTime.ToString (), "KeyTime does not match the default value");
        }

    }
}
namespace MoonTest.System.Windows.Media.Animation
{
    public partial class SplineDoubleKeyFrameTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_SplineDoubleKeyFrame ()
        {
            SplineDoubleKeyFrame widget = new SplineDoubleKeyFrame ();
            object retval;

            retval = widget.ReadLocalValue(SplineDoubleKeyFrame.KeySplineProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(SplineDoubleKeyFrame.KeySplineProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_DoubleKeyFrame ()
        {
            SplineDoubleKeyFrame widget = new SplineDoubleKeyFrame ();
            object retval;

            retval = widget.ReadLocalValue(DoubleKeyFrame.ValueProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(DoubleKeyFrame.ValueProperty) should not have a value by default");
            retval = widget.ReadLocalValue(DoubleKeyFrame.KeyTimeProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(DoubleKeyFrame.KeyTimeProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_SplineDoubleKeyFrame ()
        {
            SplineDoubleKeyFrame widget = new SplineDoubleKeyFrame ();
            object retval;

            retval = widget.GetValue(SplineDoubleKeyFrame.KeySplineProperty);
            Assert.IsNotNull(retval, "GetValue(SplineDoubleKeyFrame.KeySplineProperty) should not have returned null");
            Assert.IsTrue(retval is KeySpline, "GetValue(SplineDoubleKeyFrame.KeySplineProperty) is not of the correct type");
        }

        [TestMethod]
        public void Test_GetValue_DoubleKeyFrame ()
        {
            SplineDoubleKeyFrame widget = new SplineDoubleKeyFrame ();
            object retval;

            retval = widget.GetValue(DoubleKeyFrame.ValueProperty);
            Assert.IsNotNull(retval, "GetValue(DoubleKeyFrame.ValueProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(DoubleKeyFrame.ValueProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(DoubleKeyFrame.ValueProperty) does not match the default value");
            retval = widget.GetValue(DoubleKeyFrame.KeyTimeProperty);
            Assert.IsNotNull(retval, "GetValue(DoubleKeyFrame.KeyTimeProperty) should not have returned null");
            Assert.IsTrue(retval is KeyTime, "GetValue(DoubleKeyFrame.KeyTimeProperty) is not of the correct type");
            Assert.AreEqual("Uniform", retval.ToString (), "GetValue(DoubleKeyFrame.KeyTimeProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_SplineDoubleKeyFrame ()
        {
            SplineDoubleKeyFrame widget = new SplineDoubleKeyFrame ();

            Assert.IsNotNull(widget.KeySpline, "KeySpline should not have returned null");
            Assert.IsTrue(widget.KeySpline is KeySpline, "KeySpline is not of the correct type");
            Assert.AreEqual((double) 0, widget.Value, "Value does not match the default value");
            Assert.AreEqual("Uniform", widget.KeyTime.ToString (), "KeyTime does not match the default value");
        }

    }
}
namespace MoonTest.System.Windows.Media.Animation
{
    public partial class ColorAnimationUsingKeyFramesTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_Timeline ()
        {
            ColorAnimationUsingKeyFrames widget = new ColorAnimationUsingKeyFrames ();
            object retval;

            retval = widget.ReadLocalValue(Timeline.AutoReverseProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Timeline.AutoReverseProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Timeline.BeginTimeProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Timeline.BeginTimeProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Timeline.DurationProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Timeline.DurationProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Timeline.SpeedRatioProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Timeline.SpeedRatioProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Timeline.FillBehaviorProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Timeline.FillBehaviorProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Timeline.RepeatBehaviorProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Timeline.RepeatBehaviorProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_Timeline ()
        {
            ColorAnimationUsingKeyFrames widget = new ColorAnimationUsingKeyFrames ();
            object retval;

            retval = widget.GetValue(Timeline.AutoReverseProperty);
            Assert.IsNotNull(retval, "GetValue(Timeline.AutoReverseProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(Timeline.AutoReverseProperty) is not of the correct type");
            Assert.AreEqual(false, retval, "GetValue(Timeline.AutoReverseProperty) does not match the default value");
            retval = widget.GetValue(Timeline.BeginTimeProperty);
            Assert.IsNotNull(retval, "GetValue(Timeline.BeginTimeProperty) should not have returned null");
            Assert.IsTrue(retval is TimeSpan, "GetValue(Timeline.BeginTimeProperty) is not of the correct type");
            Assert.AreEqual("00:00:00", retval.ToString (), "GetValue(Timeline.BeginTimeProperty) does not match the default value");
            retval = widget.GetValue(Timeline.DurationProperty);
            Assert.IsNotNull(retval, "GetValue(Timeline.DurationProperty) should not have returned null");
            Assert.IsTrue(retval is Duration, "GetValue(Timeline.DurationProperty) is not of the correct type");
            Assert.AreEqual("Automatic", retval.ToString (), "GetValue(Timeline.DurationProperty) does not match the default value");
            retval = widget.GetValue(Timeline.SpeedRatioProperty);
            Assert.IsNotNull(retval, "GetValue(Timeline.SpeedRatioProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Timeline.SpeedRatioProperty) is not of the correct type");
            Assert.AreEqual((double) 1, retval, "GetValue(Timeline.SpeedRatioProperty) does not match the default value");
            retval = widget.GetValue(Timeline.FillBehaviorProperty);
            Assert.IsNotNull(retval, "GetValue(Timeline.FillBehaviorProperty) should not have returned null");
            Assert.IsTrue(retval is FillBehavior, "GetValue(Timeline.FillBehaviorProperty) is not of the correct type");
            Assert.AreEqual(FillBehavior.HoldEnd, retval, "GetValue(Timeline.FillBehaviorProperty) does not match the default value");
            retval = widget.GetValue(Timeline.RepeatBehaviorProperty);
            Assert.IsNotNull(retval, "GetValue(Timeline.RepeatBehaviorProperty) should not have returned null");
            Assert.IsTrue(retval is RepeatBehavior, "GetValue(Timeline.RepeatBehaviorProperty) is not of the correct type");
            Assert.AreEqual("1x", retval.ToString (), "GetValue(Timeline.RepeatBehaviorProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_ColorAnimationUsingKeyFrames ()
        {
            ColorAnimationUsingKeyFrames widget = new ColorAnimationUsingKeyFrames ();

            Assert.IsNotNull(widget.KeyFrames, "KeyFrames should not have returned null");
            Assert.IsTrue(widget.KeyFrames is ColorKeyFrameCollection, "KeyFrames is not of the correct type");
            Assert.AreEqual(false, widget.AutoReverse, "AutoReverse does not match the default value");
            Assert.AreEqual("00:00:00", widget.BeginTime.ToString (), "BeginTime does not match the default value");
            Assert.AreEqual("Automatic", widget.Duration.ToString (), "Duration does not match the default value");
            Assert.AreEqual((double) 1, widget.SpeedRatio, "SpeedRatio does not match the default value");
            Assert.AreEqual(FillBehavior.HoldEnd, widget.FillBehavior, "FillBehavior does not match the default value");
            Assert.AreEqual("1x", widget.RepeatBehavior.ToString (), "RepeatBehavior does not match the default value");
        }

    }
}
namespace MoonTest.System.Windows.Media.Animation
{
    public partial class DiscreteColorKeyFrameTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_ColorKeyFrame ()
        {
            DiscreteColorKeyFrame widget = new DiscreteColorKeyFrame ();
            object retval;

            retval = widget.ReadLocalValue(ColorKeyFrame.ValueProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(ColorKeyFrame.ValueProperty) should not have a value by default");
            retval = widget.ReadLocalValue(ColorKeyFrame.KeyTimeProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(ColorKeyFrame.KeyTimeProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_ColorKeyFrame ()
        {
            DiscreteColorKeyFrame widget = new DiscreteColorKeyFrame ();
            object retval;

            retval = widget.GetValue(ColorKeyFrame.ValueProperty);
            Assert.IsNotNull(retval, "GetValue(ColorKeyFrame.ValueProperty) should not have returned null");
            Assert.IsTrue(retval is Color, "GetValue(ColorKeyFrame.ValueProperty) is not of the correct type");
            Assert.AreEqual("#FF000000", retval.ToString (), "GetValue(ColorKeyFrame.ValueProperty) does not match the default value");
            retval = widget.GetValue(ColorKeyFrame.KeyTimeProperty);
            Assert.IsNotNull(retval, "GetValue(ColorKeyFrame.KeyTimeProperty) should not have returned null");
            Assert.IsTrue(retval is KeyTime, "GetValue(ColorKeyFrame.KeyTimeProperty) is not of the correct type");
            Assert.AreEqual("Uniform", retval.ToString (), "GetValue(ColorKeyFrame.KeyTimeProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_DiscreteColorKeyFrame ()
        {
            DiscreteColorKeyFrame widget = new DiscreteColorKeyFrame ();

            Assert.AreEqual("#FF000000", widget.Value.ToString (), "Value does not match the default value");
            Assert.AreEqual("Uniform", widget.KeyTime.ToString (), "KeyTime does not match the default value");
        }

    }
}
namespace MoonTest.System.Windows.Media.Animation
{
    public partial class LinearColorKeyFrameTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_ColorKeyFrame ()
        {
            LinearColorKeyFrame widget = new LinearColorKeyFrame ();
            object retval;

            retval = widget.ReadLocalValue(ColorKeyFrame.ValueProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(ColorKeyFrame.ValueProperty) should not have a value by default");
            retval = widget.ReadLocalValue(ColorKeyFrame.KeyTimeProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(ColorKeyFrame.KeyTimeProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_ColorKeyFrame ()
        {
            LinearColorKeyFrame widget = new LinearColorKeyFrame ();
            object retval;

            retval = widget.GetValue(ColorKeyFrame.ValueProperty);
            Assert.IsNotNull(retval, "GetValue(ColorKeyFrame.ValueProperty) should not have returned null");
            Assert.IsTrue(retval is Color, "GetValue(ColorKeyFrame.ValueProperty) is not of the correct type");
            Assert.AreEqual("#FF000000", retval.ToString (), "GetValue(ColorKeyFrame.ValueProperty) does not match the default value");
            retval = widget.GetValue(ColorKeyFrame.KeyTimeProperty);
            Assert.IsNotNull(retval, "GetValue(ColorKeyFrame.KeyTimeProperty) should not have returned null");
            Assert.IsTrue(retval is KeyTime, "GetValue(ColorKeyFrame.KeyTimeProperty) is not of the correct type");
            Assert.AreEqual("Uniform", retval.ToString (), "GetValue(ColorKeyFrame.KeyTimeProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_LinearColorKeyFrame ()
        {
            LinearColorKeyFrame widget = new LinearColorKeyFrame ();

            Assert.AreEqual("#FF000000", widget.Value.ToString (), "Value does not match the default value");
            Assert.AreEqual("Uniform", widget.KeyTime.ToString (), "KeyTime does not match the default value");
        }

    }
}
namespace MoonTest.System.Windows.Media.Animation
{
    public partial class SplineColorKeyFrameTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_SplineColorKeyFrame ()
        {
            SplineColorKeyFrame widget = new SplineColorKeyFrame ();
            object retval;

            retval = widget.ReadLocalValue(SplineColorKeyFrame.KeySplineProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(SplineColorKeyFrame.KeySplineProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_ColorKeyFrame ()
        {
            SplineColorKeyFrame widget = new SplineColorKeyFrame ();
            object retval;

            retval = widget.ReadLocalValue(ColorKeyFrame.ValueProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(ColorKeyFrame.ValueProperty) should not have a value by default");
            retval = widget.ReadLocalValue(ColorKeyFrame.KeyTimeProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(ColorKeyFrame.KeyTimeProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_SplineColorKeyFrame ()
        {
            SplineColorKeyFrame widget = new SplineColorKeyFrame ();
            object retval;

            retval = widget.GetValue(SplineColorKeyFrame.KeySplineProperty);
            Assert.IsNotNull(retval, "GetValue(SplineColorKeyFrame.KeySplineProperty) should not have returned null");
            Assert.IsTrue(retval is KeySpline, "GetValue(SplineColorKeyFrame.KeySplineProperty) is not of the correct type");
        }

        [TestMethod]
        public void Test_GetValue_ColorKeyFrame ()
        {
            SplineColorKeyFrame widget = new SplineColorKeyFrame ();
            object retval;

            retval = widget.GetValue(ColorKeyFrame.ValueProperty);
            Assert.IsNotNull(retval, "GetValue(ColorKeyFrame.ValueProperty) should not have returned null");
            Assert.IsTrue(retval is Color, "GetValue(ColorKeyFrame.ValueProperty) is not of the correct type");
            Assert.AreEqual("#FF000000", retval.ToString (), "GetValue(ColorKeyFrame.ValueProperty) does not match the default value");
            retval = widget.GetValue(ColorKeyFrame.KeyTimeProperty);
            Assert.IsNotNull(retval, "GetValue(ColorKeyFrame.KeyTimeProperty) should not have returned null");
            Assert.IsTrue(retval is KeyTime, "GetValue(ColorKeyFrame.KeyTimeProperty) is not of the correct type");
            Assert.AreEqual("Uniform", retval.ToString (), "GetValue(ColorKeyFrame.KeyTimeProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_SplineColorKeyFrame ()
        {
            SplineColorKeyFrame widget = new SplineColorKeyFrame ();

            Assert.IsNotNull(widget.KeySpline, "KeySpline should not have returned null");
            Assert.IsTrue(widget.KeySpline is KeySpline, "KeySpline is not of the correct type");
            Assert.AreEqual("#FF000000", widget.Value.ToString (), "Value does not match the default value");
            Assert.AreEqual("Uniform", widget.KeyTime.ToString (), "KeyTime does not match the default value");
        }

    }
}
namespace MoonTest.System.Windows.Media.Animation
{
    public partial class PointAnimationUsingKeyFramesTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_Timeline ()
        {
            PointAnimationUsingKeyFrames widget = new PointAnimationUsingKeyFrames ();
            object retval;

            retval = widget.ReadLocalValue(Timeline.AutoReverseProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Timeline.AutoReverseProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Timeline.BeginTimeProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Timeline.BeginTimeProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Timeline.DurationProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Timeline.DurationProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Timeline.SpeedRatioProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Timeline.SpeedRatioProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Timeline.FillBehaviorProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Timeline.FillBehaviorProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Timeline.RepeatBehaviorProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Timeline.RepeatBehaviorProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_Timeline ()
        {
            PointAnimationUsingKeyFrames widget = new PointAnimationUsingKeyFrames ();
            object retval;

            retval = widget.GetValue(Timeline.AutoReverseProperty);
            Assert.IsNotNull(retval, "GetValue(Timeline.AutoReverseProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(Timeline.AutoReverseProperty) is not of the correct type");
            Assert.AreEqual(false, retval, "GetValue(Timeline.AutoReverseProperty) does not match the default value");
            retval = widget.GetValue(Timeline.BeginTimeProperty);
            Assert.IsNotNull(retval, "GetValue(Timeline.BeginTimeProperty) should not have returned null");
            Assert.IsTrue(retval is TimeSpan, "GetValue(Timeline.BeginTimeProperty) is not of the correct type");
            Assert.AreEqual("00:00:00", retval.ToString (), "GetValue(Timeline.BeginTimeProperty) does not match the default value");
            retval = widget.GetValue(Timeline.DurationProperty);
            Assert.IsNotNull(retval, "GetValue(Timeline.DurationProperty) should not have returned null");
            Assert.IsTrue(retval is Duration, "GetValue(Timeline.DurationProperty) is not of the correct type");
            Assert.AreEqual("Automatic", retval.ToString (), "GetValue(Timeline.DurationProperty) does not match the default value");
            retval = widget.GetValue(Timeline.SpeedRatioProperty);
            Assert.IsNotNull(retval, "GetValue(Timeline.SpeedRatioProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Timeline.SpeedRatioProperty) is not of the correct type");
            Assert.AreEqual((double) 1, retval, "GetValue(Timeline.SpeedRatioProperty) does not match the default value");
            retval = widget.GetValue(Timeline.FillBehaviorProperty);
            Assert.IsNotNull(retval, "GetValue(Timeline.FillBehaviorProperty) should not have returned null");
            Assert.IsTrue(retval is FillBehavior, "GetValue(Timeline.FillBehaviorProperty) is not of the correct type");
            Assert.AreEqual(FillBehavior.HoldEnd, retval, "GetValue(Timeline.FillBehaviorProperty) does not match the default value");
            retval = widget.GetValue(Timeline.RepeatBehaviorProperty);
            Assert.IsNotNull(retval, "GetValue(Timeline.RepeatBehaviorProperty) should not have returned null");
            Assert.IsTrue(retval is RepeatBehavior, "GetValue(Timeline.RepeatBehaviorProperty) is not of the correct type");
            Assert.AreEqual("1x", retval.ToString (), "GetValue(Timeline.RepeatBehaviorProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_PointAnimationUsingKeyFrames ()
        {
            PointAnimationUsingKeyFrames widget = new PointAnimationUsingKeyFrames ();

            Assert.IsNotNull(widget.KeyFrames, "KeyFrames should not have returned null");
            Assert.IsTrue(widget.KeyFrames is PointKeyFrameCollection, "KeyFrames is not of the correct type");
            Assert.AreEqual(false, widget.AutoReverse, "AutoReverse does not match the default value");
            Assert.AreEqual("00:00:00", widget.BeginTime.ToString (), "BeginTime does not match the default value");
            Assert.AreEqual("Automatic", widget.Duration.ToString (), "Duration does not match the default value");
            Assert.AreEqual((double) 1, widget.SpeedRatio, "SpeedRatio does not match the default value");
            Assert.AreEqual(FillBehavior.HoldEnd, widget.FillBehavior, "FillBehavior does not match the default value");
            Assert.AreEqual("1x", widget.RepeatBehavior.ToString (), "RepeatBehavior does not match the default value");
        }

    }
}
namespace MoonTest.System.Windows.Media.Animation
{
    public partial class DiscretePointKeyFrameTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_PointKeyFrame ()
        {
            DiscretePointKeyFrame widget = new DiscretePointKeyFrame ();
            object retval;

            retval = widget.ReadLocalValue(PointKeyFrame.ValueProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(PointKeyFrame.ValueProperty) should not have a value by default");
            retval = widget.ReadLocalValue(PointKeyFrame.KeyTimeProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(PointKeyFrame.KeyTimeProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_PointKeyFrame ()
        {
            DiscretePointKeyFrame widget = new DiscretePointKeyFrame ();
            object retval;

            retval = widget.GetValue(PointKeyFrame.ValueProperty);
            Assert.IsNotNull(retval, "GetValue(PointKeyFrame.ValueProperty) should not have returned null");
            Assert.IsTrue(retval is Point, "GetValue(PointKeyFrame.ValueProperty) is not of the correct type");
            Assert.AreEqual("0,0", retval.ToString (), "GetValue(PointKeyFrame.ValueProperty) does not match the default value");
            retval = widget.GetValue(PointKeyFrame.KeyTimeProperty);
            Assert.IsNotNull(retval, "GetValue(PointKeyFrame.KeyTimeProperty) should not have returned null");
            Assert.IsTrue(retval is KeyTime, "GetValue(PointKeyFrame.KeyTimeProperty) is not of the correct type");
            Assert.AreEqual("Uniform", retval.ToString (), "GetValue(PointKeyFrame.KeyTimeProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_DiscretePointKeyFrame ()
        {
            DiscretePointKeyFrame widget = new DiscretePointKeyFrame ();

            Assert.AreEqual("0,0", widget.Value.ToString (), "Value does not match the default value");
            Assert.AreEqual("Uniform", widget.KeyTime.ToString (), "KeyTime does not match the default value");
        }

    }
}
namespace MoonTest.System.Windows.Media.Animation
{
    public partial class LinearPointKeyFrameTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_PointKeyFrame ()
        {
            LinearPointKeyFrame widget = new LinearPointKeyFrame ();
            object retval;

            retval = widget.ReadLocalValue(PointKeyFrame.ValueProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(PointKeyFrame.ValueProperty) should not have a value by default");
            retval = widget.ReadLocalValue(PointKeyFrame.KeyTimeProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(PointKeyFrame.KeyTimeProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_PointKeyFrame ()
        {
            LinearPointKeyFrame widget = new LinearPointKeyFrame ();
            object retval;

            retval = widget.GetValue(PointKeyFrame.ValueProperty);
            Assert.IsNotNull(retval, "GetValue(PointKeyFrame.ValueProperty) should not have returned null");
            Assert.IsTrue(retval is Point, "GetValue(PointKeyFrame.ValueProperty) is not of the correct type");
            Assert.AreEqual("0,0", retval.ToString (), "GetValue(PointKeyFrame.ValueProperty) does not match the default value");
            retval = widget.GetValue(PointKeyFrame.KeyTimeProperty);
            Assert.IsNotNull(retval, "GetValue(PointKeyFrame.KeyTimeProperty) should not have returned null");
            Assert.IsTrue(retval is KeyTime, "GetValue(PointKeyFrame.KeyTimeProperty) is not of the correct type");
            Assert.AreEqual("Uniform", retval.ToString (), "GetValue(PointKeyFrame.KeyTimeProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_LinearPointKeyFrame ()
        {
            LinearPointKeyFrame widget = new LinearPointKeyFrame ();

            Assert.AreEqual("0,0", widget.Value.ToString (), "Value does not match the default value");
            Assert.AreEqual("Uniform", widget.KeyTime.ToString (), "KeyTime does not match the default value");
        }

    }
}
namespace MoonTest.System.Windows.Media.Animation
{
    public partial class SplinePointKeyFrameTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_SplinePointKeyFrame ()
        {
            SplinePointKeyFrame widget = new SplinePointKeyFrame ();
            object retval;

            retval = widget.ReadLocalValue(SplinePointKeyFrame.KeySplineProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(SplinePointKeyFrame.KeySplineProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_PointKeyFrame ()
        {
            SplinePointKeyFrame widget = new SplinePointKeyFrame ();
            object retval;

            retval = widget.ReadLocalValue(PointKeyFrame.ValueProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(PointKeyFrame.ValueProperty) should not have a value by default");
            retval = widget.ReadLocalValue(PointKeyFrame.KeyTimeProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(PointKeyFrame.KeyTimeProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_SplinePointKeyFrame ()
        {
            SplinePointKeyFrame widget = new SplinePointKeyFrame ();
            object retval;

            retval = widget.GetValue(SplinePointKeyFrame.KeySplineProperty);
            Assert.IsNotNull(retval, "GetValue(SplinePointKeyFrame.KeySplineProperty) should not have returned null");
            Assert.IsTrue(retval is KeySpline, "GetValue(SplinePointKeyFrame.KeySplineProperty) is not of the correct type");
        }

        [TestMethod]
        public void Test_GetValue_PointKeyFrame ()
        {
            SplinePointKeyFrame widget = new SplinePointKeyFrame ();
            object retval;

            retval = widget.GetValue(PointKeyFrame.ValueProperty);
            Assert.IsNotNull(retval, "GetValue(PointKeyFrame.ValueProperty) should not have returned null");
            Assert.IsTrue(retval is Point, "GetValue(PointKeyFrame.ValueProperty) is not of the correct type");
            Assert.AreEqual("0,0", retval.ToString (), "GetValue(PointKeyFrame.ValueProperty) does not match the default value");
            retval = widget.GetValue(PointKeyFrame.KeyTimeProperty);
            Assert.IsNotNull(retval, "GetValue(PointKeyFrame.KeyTimeProperty) should not have returned null");
            Assert.IsTrue(retval is KeyTime, "GetValue(PointKeyFrame.KeyTimeProperty) is not of the correct type");
            Assert.AreEqual("Uniform", retval.ToString (), "GetValue(PointKeyFrame.KeyTimeProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_SplinePointKeyFrame ()
        {
            SplinePointKeyFrame widget = new SplinePointKeyFrame ();

            Assert.IsNotNull(widget.KeySpline, "KeySpline should not have returned null");
            Assert.IsTrue(widget.KeySpline is KeySpline, "KeySpline is not of the correct type");
            Assert.AreEqual("0,0", widget.Value.ToString (), "Value does not match the default value");
            Assert.AreEqual("Uniform", widget.KeyTime.ToString (), "KeyTime does not match the default value");
        }

    }
}
namespace MoonTest.System.Windows.Media.Animation
{
    public partial class ObjectAnimationUsingKeyFramesTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_Timeline ()
        {
            ObjectAnimationUsingKeyFrames widget = new ObjectAnimationUsingKeyFrames ();
            object retval;

            retval = widget.ReadLocalValue(Timeline.AutoReverseProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Timeline.AutoReverseProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Timeline.BeginTimeProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Timeline.BeginTimeProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Timeline.DurationProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Timeline.DurationProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Timeline.SpeedRatioProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Timeline.SpeedRatioProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Timeline.FillBehaviorProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Timeline.FillBehaviorProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Timeline.RepeatBehaviorProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Timeline.RepeatBehaviorProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_Timeline ()
        {
            ObjectAnimationUsingKeyFrames widget = new ObjectAnimationUsingKeyFrames ();
            object retval;

            retval = widget.GetValue(Timeline.AutoReverseProperty);
            Assert.IsNotNull(retval, "GetValue(Timeline.AutoReverseProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(Timeline.AutoReverseProperty) is not of the correct type");
            Assert.AreEqual(false, retval, "GetValue(Timeline.AutoReverseProperty) does not match the default value");
            retval = widget.GetValue(Timeline.BeginTimeProperty);
            Assert.IsNotNull(retval, "GetValue(Timeline.BeginTimeProperty) should not have returned null");
            Assert.IsTrue(retval is TimeSpan, "GetValue(Timeline.BeginTimeProperty) is not of the correct type");
            Assert.AreEqual("00:00:00", retval.ToString (), "GetValue(Timeline.BeginTimeProperty) does not match the default value");
            retval = widget.GetValue(Timeline.DurationProperty);
            Assert.IsNotNull(retval, "GetValue(Timeline.DurationProperty) should not have returned null");
            Assert.IsTrue(retval is Duration, "GetValue(Timeline.DurationProperty) is not of the correct type");
            Assert.AreEqual("Automatic", retval.ToString (), "GetValue(Timeline.DurationProperty) does not match the default value");
            retval = widget.GetValue(Timeline.SpeedRatioProperty);
            Assert.IsNotNull(retval, "GetValue(Timeline.SpeedRatioProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Timeline.SpeedRatioProperty) is not of the correct type");
            Assert.AreEqual((double) 1, retval, "GetValue(Timeline.SpeedRatioProperty) does not match the default value");
            retval = widget.GetValue(Timeline.FillBehaviorProperty);
            Assert.IsNotNull(retval, "GetValue(Timeline.FillBehaviorProperty) should not have returned null");
            Assert.IsTrue(retval is FillBehavior, "GetValue(Timeline.FillBehaviorProperty) is not of the correct type");
            Assert.AreEqual(FillBehavior.HoldEnd, retval, "GetValue(Timeline.FillBehaviorProperty) does not match the default value");
            retval = widget.GetValue(Timeline.RepeatBehaviorProperty);
            Assert.IsNotNull(retval, "GetValue(Timeline.RepeatBehaviorProperty) should not have returned null");
            Assert.IsTrue(retval is RepeatBehavior, "GetValue(Timeline.RepeatBehaviorProperty) is not of the correct type");
            Assert.AreEqual("1x", retval.ToString (), "GetValue(Timeline.RepeatBehaviorProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_ObjectAnimationUsingKeyFrames ()
        {
            ObjectAnimationUsingKeyFrames widget = new ObjectAnimationUsingKeyFrames ();

            Assert.IsNotNull(widget.KeyFrames, "KeyFrames should not have returned null");
            Assert.IsTrue(widget.KeyFrames is ObjectKeyFrameCollection, "KeyFrames is not of the correct type");
            Assert.AreEqual(false, widget.AutoReverse, "AutoReverse does not match the default value");
            Assert.AreEqual("00:00:00", widget.BeginTime.ToString (), "BeginTime does not match the default value");
            Assert.AreEqual("Automatic", widget.Duration.ToString (), "Duration does not match the default value");
            Assert.AreEqual((double) 1, widget.SpeedRatio, "SpeedRatio does not match the default value");
            Assert.AreEqual(FillBehavior.HoldEnd, widget.FillBehavior, "FillBehavior does not match the default value");
            Assert.AreEqual("1x", widget.RepeatBehavior.ToString (), "RepeatBehavior does not match the default value");
        }

    }
}
namespace MoonTest.System.Windows.Media.Animation
{
    public partial class DiscreteObjectKeyFrameTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_ObjectKeyFrame ()
        {
            DiscreteObjectKeyFrame widget = new DiscreteObjectKeyFrame ();
            object retval;

            retval = widget.ReadLocalValue(ObjectKeyFrame.KeyTimeProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(ObjectKeyFrame.KeyTimeProperty) should not have a value by default");
            retval = widget.ReadLocalValue(ObjectKeyFrame.ValueProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(ObjectKeyFrame.ValueProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_ObjectKeyFrame ()
        {
            DiscreteObjectKeyFrame widget = new DiscreteObjectKeyFrame ();
            object retval;

            retval = widget.GetValue(ObjectKeyFrame.KeyTimeProperty);
            Assert.IsNotNull(retval, "GetValue(ObjectKeyFrame.KeyTimeProperty) should not have returned null");
            Assert.IsTrue(retval is KeyTime, "GetValue(ObjectKeyFrame.KeyTimeProperty) is not of the correct type");
            Assert.AreEqual("Uniform", retval.ToString (), "GetValue(ObjectKeyFrame.KeyTimeProperty) does not match the default value");
            retval = widget.GetValue(ObjectKeyFrame.ValueProperty);
            Assert.IsNull(retval, "GetValue(ObjectKeyFrame.ValueProperty) should have returned null");
        }

        [TestMethod]
        public void Test_PropertyGetter_DiscreteObjectKeyFrame ()
        {
            DiscreteObjectKeyFrame widget = new DiscreteObjectKeyFrame ();

            Assert.AreEqual("Uniform", widget.KeyTime.ToString (), "KeyTime does not match the default value");
            Assert.IsNull(widget.Value, "Value should have returned null");
        }

    }
}
namespace MoonTest.System.Windows.Media.Animation
{
    public partial class TimelineCollectionTest
    {
        [TestMethod]
        public void Test_PropertyGetter_TimelineCollection ()
        {
            TimelineCollection widget = new TimelineCollection ();

            Assert.AreEqual(false, widget.IsFixedSize, "IsFixedSize does not match the default value");
            Assert.AreEqual(false, widget.IsReadOnly, "IsReadOnly does not match the default value");
            Assert.AreEqual(0, widget.Count, "Count does not match the default value");
            Assert.AreEqual(false, widget.IsSynchronized, "IsSynchronized does not match the default value");
            Assert.IsNotNull(widget.SyncRoot, "SyncRoot should not have returned null");
            Assert.IsTrue(widget.SyncRoot is TimelineCollection, "SyncRoot is not of the correct type");
        }

    }
}
namespace MoonTest.System.Windows.Input
{
    public partial class StylusPointCollectionTest
    {
        [TestMethod]
        public void Test_PropertyGetter_StylusPointCollection ()
        {
            StylusPointCollection widget = new StylusPointCollection ();

            Assert.AreEqual(false, widget.IsFixedSize, "IsFixedSize does not match the default value");
            Assert.AreEqual(false, widget.IsReadOnly, "IsReadOnly does not match the default value");
            Assert.AreEqual(0, widget.Count, "Count does not match the default value");
            Assert.AreEqual(false, widget.IsSynchronized, "IsSynchronized does not match the default value");
            Assert.IsNotNull(widget.SyncRoot, "SyncRoot should not have returned null");
            Assert.IsTrue(widget.SyncRoot is StylusPointCollection, "SyncRoot is not of the correct type");
        }

    }
}
namespace MoonTest.System.Windows.Shapes
{
    public partial class PathTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_Path ()
        {
            Path widget = new Path ();
            object retval;

            retval = widget.ReadLocalValue(Path.DataProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Path.DataProperty) should not have a value by default");
        }

        [TestMethod]
	[MoonlightBug]
        public void Test_ReadLocalValue_Shape ()
        {
            Path widget = new Path ();
            object retval;

            retval = widget.ReadLocalValue(Shape.FillProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.FillProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeMiterLimitProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeMiterLimitProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeThicknessProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeThicknessProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeStartLineCapProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeStartLineCapProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeEndLineCapProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeEndLineCapProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeLineJoinProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeLineJoinProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeDashOffsetProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeDashOffsetProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeDashCapProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeDashCapProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeDashArrayProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeDashArrayProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StretchProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StretchProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_FrameworkElement ()
        {
            Path widget = new Path ();
            object retval;

            retval = widget.ReadLocalValue(FrameworkElement.LanguageProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.LanguageProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.ActualWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.ActualWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.ActualHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.ActualHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.WidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.WidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.HeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.HeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MinWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MinWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MaxWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MaxWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MinHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MinHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MaxHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MaxHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.HorizontalAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.HorizontalAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.VerticalAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.VerticalAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MarginProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MarginProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.StyleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.StyleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.NameProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.NameProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.TagProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.TagProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.DataContextProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.DataContextProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_UIElement ()
        {
            Path widget = new Path ();
            object retval;

            retval = widget.ReadLocalValue(UIElement.OpacityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.OpacityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.ClipProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.ClipProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.RenderTransformProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.RenderTransformProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.OpacityMaskProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.OpacityMaskProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.RenderTransformOriginProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.RenderTransformOriginProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.IsHitTestVisibleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.IsHitTestVisibleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.VisibilityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.VisibilityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.UseLayoutRoundingProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.UseLayoutRoundingProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_Path ()
        {
            Path widget = new Path ();
            object retval;

            retval = widget.GetValue(Path.DataProperty);
            Assert.IsNull(retval, "GetValue(Path.DataProperty) should have returned null");
        }

        [TestMethod]
        public void Test_GetValue_Shape ()
        {
            Path widget = new Path ();
            object retval;

            retval = widget.GetValue(Shape.FillProperty);
            Assert.IsNull(retval, "GetValue(Shape.FillProperty) should have returned null");
            retval = widget.GetValue(Shape.StrokeProperty);
            Assert.IsNull(retval, "GetValue(Shape.StrokeProperty) should have returned null");
            retval = widget.GetValue(Shape.StrokeMiterLimitProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StrokeMiterLimitProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Shape.StrokeMiterLimitProperty) is not of the correct type");
            Assert.AreEqual((double) 10, retval, "GetValue(Shape.StrokeMiterLimitProperty) does not match the default value");
            retval = widget.GetValue(Shape.StrokeThicknessProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StrokeThicknessProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Shape.StrokeThicknessProperty) is not of the correct type");
            Assert.AreEqual((double) 1, retval, "GetValue(Shape.StrokeThicknessProperty) does not match the default value");
            retval = widget.GetValue(Shape.StrokeStartLineCapProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StrokeStartLineCapProperty) should not have returned null");
            Assert.IsTrue(retval is PenLineCap, "GetValue(Shape.StrokeStartLineCapProperty) is not of the correct type");
            Assert.AreEqual(PenLineCap.Flat, retval, "GetValue(Shape.StrokeStartLineCapProperty) does not match the default value");
            retval = widget.GetValue(Shape.StrokeEndLineCapProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StrokeEndLineCapProperty) should not have returned null");
            Assert.IsTrue(retval is PenLineCap, "GetValue(Shape.StrokeEndLineCapProperty) is not of the correct type");
            Assert.AreEqual(PenLineCap.Flat, retval, "GetValue(Shape.StrokeEndLineCapProperty) does not match the default value");
            retval = widget.GetValue(Shape.StrokeLineJoinProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StrokeLineJoinProperty) should not have returned null");
            Assert.IsTrue(retval is PenLineJoin, "GetValue(Shape.StrokeLineJoinProperty) is not of the correct type");
            Assert.AreEqual(PenLineJoin.Miter, retval, "GetValue(Shape.StrokeLineJoinProperty) does not match the default value");
            retval = widget.GetValue(Shape.StrokeDashOffsetProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StrokeDashOffsetProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Shape.StrokeDashOffsetProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(Shape.StrokeDashOffsetProperty) does not match the default value");
            retval = widget.GetValue(Shape.StrokeDashCapProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StrokeDashCapProperty) should not have returned null");
            Assert.IsTrue(retval is PenLineCap, "GetValue(Shape.StrokeDashCapProperty) is not of the correct type");
            Assert.AreEqual(PenLineCap.Flat, retval, "GetValue(Shape.StrokeDashCapProperty) does not match the default value");
            retval = widget.GetValue(Shape.StrokeDashArrayProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StrokeDashArrayProperty) should not have returned null");
            Assert.IsTrue(retval is DoubleCollection, "GetValue(Shape.StrokeDashArrayProperty) is not of the correct type");
            retval = widget.GetValue(Shape.StretchProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StretchProperty) should not have returned null");
            Assert.IsTrue(retval is Stretch, "GetValue(Shape.StretchProperty) is not of the correct type");
            Assert.AreEqual(Stretch.None, retval, "GetValue(Shape.StretchProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_GetValue_FrameworkElement ()
        {
            Path widget = new Path ();
            object retval;

            retval = widget.GetValue(FrameworkElement.LanguageProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.LanguageProperty) should not have returned null");
            Assert.IsTrue(retval is XmlLanguage, "GetValue(FrameworkElement.LanguageProperty) is not of the correct type");
            Assert.AreEqual("en-us", ((XmlLanguage) retval).IetfLanguageTag, "GetValue(FrameworkElement.LanguageProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.ActualWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.ActualWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.ActualWidthProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.ActualWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.ActualHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.ActualHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.ActualHeightProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.ActualHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.WidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.WidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.WidthProperty) is not of the correct type");
            Assert.IsTrue(Double.IsNaN((double) retval), "GetValue(FrameworkElement.WidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.HeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.HeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.HeightProperty) is not of the correct type");
            Assert.IsTrue(Double.IsNaN((double) retval), "GetValue(FrameworkElement.HeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MinWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MinWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MinWidthProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.MinWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MaxWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MaxWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MaxWidthProperty) is not of the correct type");
            Assert.IsTrue(Double.IsPositiveInfinity((double) retval), "GetValue(FrameworkElement.MaxWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MinHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MinHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MinHeightProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.MinHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MaxHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MaxHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MaxHeightProperty) is not of the correct type");
            Assert.IsTrue(Double.IsPositiveInfinity((double) retval), "GetValue(FrameworkElement.MaxHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.HorizontalAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.HorizontalAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is HorizontalAlignment, "GetValue(FrameworkElement.HorizontalAlignmentProperty) is not of the correct type");
            Assert.AreEqual(HorizontalAlignment.Stretch, retval, "GetValue(FrameworkElement.HorizontalAlignmentProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.VerticalAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.VerticalAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is VerticalAlignment, "GetValue(FrameworkElement.VerticalAlignmentProperty) is not of the correct type");
            Assert.AreEqual(VerticalAlignment.Stretch, retval, "GetValue(FrameworkElement.VerticalAlignmentProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MarginProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MarginProperty) should not have returned null");
            Assert.IsTrue(retval is Thickness, "GetValue(FrameworkElement.MarginProperty) is not of the correct type");
            Assert.AreEqual("0,0,0,0", retval.ToString (), "GetValue(FrameworkElement.MarginProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.StyleProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.StyleProperty) should have returned null");
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.NameProperty) should not have returned null");
            Assert.IsTrue(retval is string, "GetValue(FrameworkElement.NameProperty) is not of the correct type");
            Assert.AreEqual("", retval, "GetValue(FrameworkElement.NameProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.TagProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.TagProperty) should have returned null");
            retval = widget.GetValue(FrameworkElement.DataContextProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.DataContextProperty) should have returned null");
        }

        [TestMethod]
        public void Test_GetValue_UIElement ()
        {
            Path widget = new Path ();
            object retval;

            retval = widget.GetValue(UIElement.OpacityProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.OpacityProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(UIElement.OpacityProperty) is not of the correct type");
            Assert.AreEqual((double) 1, retval, "GetValue(UIElement.OpacityProperty) does not match the default value");
            retval = widget.GetValue(UIElement.ClipProperty);
            Assert.IsNull(retval, "GetValue(UIElement.ClipProperty) should have returned null");
            retval = widget.GetValue(UIElement.RenderTransformProperty);
            Assert.IsNull(retval, "GetValue(UIElement.RenderTransformProperty) should have returned null");
            retval = widget.GetValue(UIElement.OpacityMaskProperty);
            Assert.IsNull(retval, "GetValue(UIElement.OpacityMaskProperty) should have returned null");
            retval = widget.GetValue(UIElement.RenderTransformOriginProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.RenderTransformOriginProperty) should not have returned null");
            Assert.IsTrue(retval is Point, "GetValue(UIElement.RenderTransformOriginProperty) is not of the correct type");
            Assert.AreEqual("0,0", retval.ToString (), "GetValue(UIElement.RenderTransformOriginProperty) does not match the default value");
            retval = widget.GetValue(UIElement.IsHitTestVisibleProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.IsHitTestVisibleProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(UIElement.IsHitTestVisibleProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(UIElement.IsHitTestVisibleProperty) does not match the default value");
            retval = widget.GetValue(UIElement.VisibilityProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.VisibilityProperty) should not have returned null");
            Assert.IsTrue(retval is Visibility, "GetValue(UIElement.VisibilityProperty) is not of the correct type");
            Assert.AreEqual(Visibility.Visible, retval, "GetValue(UIElement.VisibilityProperty) does not match the default value");
            retval = widget.GetValue(UIElement.UseLayoutRoundingProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.UseLayoutRoundingProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(UIElement.UseLayoutRoundingProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(UIElement.UseLayoutRoundingProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_Path ()
        {
            Path widget = new Path ();

            Assert.IsNull(widget.Data, "Data should have returned null");
            Assert.IsNull(widget.Fill, "Fill should have returned null");
            Assert.IsNull(widget.Stroke, "Stroke should have returned null");
            Assert.AreEqual((double) 10, widget.StrokeMiterLimit, "StrokeMiterLimit does not match the default value");
            Assert.AreEqual((double) 1, widget.StrokeThickness, "StrokeThickness does not match the default value");
            Assert.AreEqual(PenLineCap.Flat, widget.StrokeStartLineCap, "StrokeStartLineCap does not match the default value");
            Assert.AreEqual(PenLineCap.Flat, widget.StrokeEndLineCap, "StrokeEndLineCap does not match the default value");
            Assert.AreEqual(PenLineJoin.Miter, widget.StrokeLineJoin, "StrokeLineJoin does not match the default value");
            Assert.AreEqual((double) 0, widget.StrokeDashOffset, "StrokeDashOffset does not match the default value");
            Assert.AreEqual(PenLineCap.Flat, widget.StrokeDashCap, "StrokeDashCap does not match the default value");
            Assert.IsNotNull(widget.StrokeDashArray, "StrokeDashArray should not have returned null");
            Assert.IsTrue(widget.StrokeDashArray is DoubleCollection, "StrokeDashArray is not of the correct type");
            Assert.AreEqual(Stretch.None, widget.Stretch, "Stretch does not match the default value");
            Assert.IsNotNull(widget.GeometryTransform, "GeometryTransform should not have returned null");
            Assert.IsTrue(widget.GeometryTransform is MatrixTransform, "GeometryTransform is not of the correct type");
            Assert.IsNotNull(widget.Triggers, "Triggers should not have returned null");
            Assert.IsTrue(widget.Triggers is TriggerCollection, "Triggers is not of the correct type");
            Assert.IsNotNull(widget.Resources, "Resources should not have returned null");
            Assert.IsTrue(widget.Resources is ResourceDictionary, "Resources is not of the correct type");
            Assert.AreEqual((double) 0, widget.ActualWidth, "ActualWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.ActualHeight, "ActualHeight does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Width), "Width does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Height), "Height does not match the default value");
            Assert.AreEqual((double) 0, widget.MinWidth, "MinWidth does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxWidth), "MaxWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.MinHeight, "MinHeight does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxHeight), "MaxHeight does not match the default value");
            Assert.AreEqual(HorizontalAlignment.Stretch, widget.HorizontalAlignment, "HorizontalAlignment does not match the default value");
            Assert.AreEqual(VerticalAlignment.Stretch, widget.VerticalAlignment, "VerticalAlignment does not match the default value");
            Assert.AreEqual("0,0,0,0", widget.Margin.ToString (), "Margin does not match the default value");
            Assert.IsNull(widget.Style, "Style should have returned null");
            Assert.IsNull(widget.Parent, "Parent should have returned null");
            Assert.IsNotNull(widget.Name, "Name should not have returned null");
            Assert.AreEqual("", widget.Name, "Name does not match the default value");
            Assert.IsNull(widget.Tag, "Tag should have returned null");
            Assert.IsNull(widget.Cursor, "Cursor should have returned null");
            Assert.IsNotNull(widget.Language, "Language should not have returned null");
            Assert.AreEqual("en-us", widget.Language.IetfLanguageTag, "Language does not match the default value");
            Assert.IsNull(widget.DataContext, "DataContext should have returned null");
            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNull(widget.Clip, "Clip should have returned null");
            Assert.IsNull(widget.OpacityMask, "OpacityMask should have returned null");
            Assert.AreEqual("0,0", widget.RenderTransformOrigin.ToString (), "RenderTransformOrigin does not match the default value");
            Assert.AreEqual(true, widget.IsHitTestVisible, "IsHitTestVisible does not match the default value");
            Assert.AreEqual(Visibility.Visible, widget.Visibility, "Visibility does not match the default value");
            Assert.AreEqual("0,0", widget.RenderSize.ToString (), "RenderSize does not match the default value");
            Assert.AreEqual(true, widget.UseLayoutRounding, "UseLayoutRounding does not match the default value");
            Assert.AreEqual("0,0", widget.DesiredSize.ToString (), "DesiredSize does not match the default value");
            Assert.IsNotNull(widget.RenderTransform, "RenderTransform should not have returned null");
            Assert.IsTrue(widget.RenderTransform is MatrixTransform, "RenderTransform is not of the correct type");
        }

        [TestMethod]
        public void Test_PropertyGetter_FrameworkElement ()
        {
            Path widget = new Path ();

            Assert.IsNotNull(widget.Triggers, "Triggers should not have returned null");
            Assert.IsTrue(widget.Triggers is TriggerCollection, "Triggers is not of the correct type");
            Assert.IsNotNull(widget.Resources, "Resources should not have returned null");
            Assert.IsTrue(widget.Resources is ResourceDictionary, "Resources is not of the correct type");
            Assert.AreEqual((double) 0, widget.ActualWidth, "ActualWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.ActualHeight, "ActualHeight does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Width), "Width does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Height), "Height does not match the default value");
            Assert.AreEqual((double) 0, widget.MinWidth, "MinWidth does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxWidth), "MaxWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.MinHeight, "MinHeight does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxHeight), "MaxHeight does not match the default value");
            Assert.AreEqual(HorizontalAlignment.Stretch, widget.HorizontalAlignment, "HorizontalAlignment does not match the default value");
            Assert.AreEqual(VerticalAlignment.Stretch, widget.VerticalAlignment, "VerticalAlignment does not match the default value");
            Assert.AreEqual("0,0,0,0", widget.Margin.ToString (), "Margin does not match the default value");
            Assert.IsNull(widget.Style, "Style should have returned null");
            Assert.IsNull(widget.Parent, "Parent should have returned null");
            Assert.IsNotNull(widget.Name, "Name should not have returned null");
            Assert.AreEqual("", widget.Name, "Name does not match the default value");
            Assert.IsNull(widget.Tag, "Tag should have returned null");
            Assert.IsNull(widget.Cursor, "Cursor should have returned null");
            Assert.IsNotNull(widget.Language, "Language should not have returned null");
            Assert.AreEqual("en-us", widget.Language.IetfLanguageTag, "Language does not match the default value");
            Assert.IsNull(widget.DataContext, "DataContext should have returned null");
            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNull(widget.Clip, "Clip should have returned null");
            Assert.IsNull(widget.OpacityMask, "OpacityMask should have returned null");
            Assert.AreEqual("0,0", widget.RenderTransformOrigin.ToString (), "RenderTransformOrigin does not match the default value");
            Assert.AreEqual(true, widget.IsHitTestVisible, "IsHitTestVisible does not match the default value");
            Assert.AreEqual(Visibility.Visible, widget.Visibility, "Visibility does not match the default value");
            Assert.AreEqual("0,0", widget.RenderSize.ToString (), "RenderSize does not match the default value");
            Assert.AreEqual(true, widget.UseLayoutRounding, "UseLayoutRounding does not match the default value");
            Assert.AreEqual("0,0", widget.DesiredSize.ToString (), "DesiredSize does not match the default value");
            Assert.IsNotNull(widget.RenderTransform, "RenderTransform should not have returned null");
            Assert.IsTrue(widget.RenderTransform is MatrixTransform, "RenderTransform is not of the correct type");
        }

        [TestMethod]
	[MoonlightBug]
        public void Test_SetStringValue_FrameworkElement ()
        {
            Path widget = new Path ();
            object retval;

            widget.SetValue(FrameworkElement.NameProperty, "some text");
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.AreEqual("some text", retval, "GetValue(FrameworkElement.NameProperty) should have returned 'some text'");
            widget.SetValue(FrameworkElement.NameProperty, null);
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.AreEqual(String.Empty, retval, "GetValue(FrameworkElement.NameProperty) should have returned String.Empty");
            retval = widget.ReadLocalValue(FrameworkElement.NameProperty);
            Assert.AreEqual(String.Empty, retval, "ReadLocalValue(FrameworkElement.NameProperty) should have returned String.Empty");
        }

    }
}
namespace MoonTest.System.Windows.Shapes
{
    public partial class EllipseTest
    {
        [TestMethod]
	[MoonlightBug]
        public void Test_ReadLocalValue_Shape ()
        {
            Ellipse widget = new Ellipse ();
            object retval;

            retval = widget.ReadLocalValue(Shape.FillProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.FillProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeMiterLimitProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeMiterLimitProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeThicknessProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeThicknessProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeStartLineCapProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeStartLineCapProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeEndLineCapProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeEndLineCapProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeLineJoinProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeLineJoinProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeDashOffsetProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeDashOffsetProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeDashCapProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeDashCapProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeDashArrayProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeDashArrayProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StretchProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StretchProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_FrameworkElement ()
        {
            Ellipse widget = new Ellipse ();
            object retval;

            retval = widget.ReadLocalValue(FrameworkElement.LanguageProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.LanguageProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.ActualWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.ActualWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.ActualHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.ActualHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.WidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.WidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.HeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.HeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MinWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MinWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MaxWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MaxWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MinHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MinHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MaxHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MaxHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.HorizontalAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.HorizontalAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.VerticalAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.VerticalAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MarginProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MarginProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.StyleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.StyleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.NameProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.NameProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.TagProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.TagProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.DataContextProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.DataContextProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_UIElement ()
        {
            Ellipse widget = new Ellipse ();
            object retval;

            retval = widget.ReadLocalValue(UIElement.OpacityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.OpacityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.ClipProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.ClipProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.RenderTransformProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.RenderTransformProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.OpacityMaskProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.OpacityMaskProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.RenderTransformOriginProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.RenderTransformOriginProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.IsHitTestVisibleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.IsHitTestVisibleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.VisibilityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.VisibilityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.UseLayoutRoundingProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.UseLayoutRoundingProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_Shape ()
        {
            Ellipse widget = new Ellipse ();
            object retval;

            retval = widget.GetValue(Shape.FillProperty);
            Assert.IsNull(retval, "GetValue(Shape.FillProperty) should have returned null");
            retval = widget.GetValue(Shape.StrokeProperty);
            Assert.IsNull(retval, "GetValue(Shape.StrokeProperty) should have returned null");
            retval = widget.GetValue(Shape.StrokeMiterLimitProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StrokeMiterLimitProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Shape.StrokeMiterLimitProperty) is not of the correct type");
            Assert.AreEqual((double) 10, retval, "GetValue(Shape.StrokeMiterLimitProperty) does not match the default value");
            retval = widget.GetValue(Shape.StrokeThicknessProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StrokeThicknessProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Shape.StrokeThicknessProperty) is not of the correct type");
            Assert.AreEqual((double) 1, retval, "GetValue(Shape.StrokeThicknessProperty) does not match the default value");
            retval = widget.GetValue(Shape.StrokeStartLineCapProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StrokeStartLineCapProperty) should not have returned null");
            Assert.IsTrue(retval is PenLineCap, "GetValue(Shape.StrokeStartLineCapProperty) is not of the correct type");
            Assert.AreEqual(PenLineCap.Flat, retval, "GetValue(Shape.StrokeStartLineCapProperty) does not match the default value");
            retval = widget.GetValue(Shape.StrokeEndLineCapProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StrokeEndLineCapProperty) should not have returned null");
            Assert.IsTrue(retval is PenLineCap, "GetValue(Shape.StrokeEndLineCapProperty) is not of the correct type");
            Assert.AreEqual(PenLineCap.Flat, retval, "GetValue(Shape.StrokeEndLineCapProperty) does not match the default value");
            retval = widget.GetValue(Shape.StrokeLineJoinProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StrokeLineJoinProperty) should not have returned null");
            Assert.IsTrue(retval is PenLineJoin, "GetValue(Shape.StrokeLineJoinProperty) is not of the correct type");
            Assert.AreEqual(PenLineJoin.Miter, retval, "GetValue(Shape.StrokeLineJoinProperty) does not match the default value");
            retval = widget.GetValue(Shape.StrokeDashOffsetProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StrokeDashOffsetProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Shape.StrokeDashOffsetProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(Shape.StrokeDashOffsetProperty) does not match the default value");
            retval = widget.GetValue(Shape.StrokeDashCapProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StrokeDashCapProperty) should not have returned null");
            Assert.IsTrue(retval is PenLineCap, "GetValue(Shape.StrokeDashCapProperty) is not of the correct type");
            Assert.AreEqual(PenLineCap.Flat, retval, "GetValue(Shape.StrokeDashCapProperty) does not match the default value");
            retval = widget.GetValue(Shape.StrokeDashArrayProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StrokeDashArrayProperty) should not have returned null");
            Assert.IsTrue(retval is DoubleCollection, "GetValue(Shape.StrokeDashArrayProperty) is not of the correct type");
            retval = widget.GetValue(Shape.StretchProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StretchProperty) should not have returned null");
            Assert.IsTrue(retval is Stretch, "GetValue(Shape.StretchProperty) is not of the correct type");
            Assert.AreEqual(Stretch.Fill, retval, "GetValue(Shape.StretchProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_GetValue_FrameworkElement ()
        {
            Ellipse widget = new Ellipse ();
            object retval;

            retval = widget.GetValue(FrameworkElement.LanguageProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.LanguageProperty) should not have returned null");
            Assert.IsTrue(retval is XmlLanguage, "GetValue(FrameworkElement.LanguageProperty) is not of the correct type");
            Assert.AreEqual("en-us", ((XmlLanguage) retval).IetfLanguageTag, "GetValue(FrameworkElement.LanguageProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.ActualWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.ActualWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.ActualWidthProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.ActualWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.ActualHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.ActualHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.ActualHeightProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.ActualHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.WidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.WidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.WidthProperty) is not of the correct type");
            Assert.IsTrue(Double.IsNaN((double) retval), "GetValue(FrameworkElement.WidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.HeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.HeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.HeightProperty) is not of the correct type");
            Assert.IsTrue(Double.IsNaN((double) retval), "GetValue(FrameworkElement.HeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MinWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MinWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MinWidthProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.MinWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MaxWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MaxWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MaxWidthProperty) is not of the correct type");
            Assert.IsTrue(Double.IsPositiveInfinity((double) retval), "GetValue(FrameworkElement.MaxWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MinHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MinHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MinHeightProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.MinHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MaxHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MaxHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MaxHeightProperty) is not of the correct type");
            Assert.IsTrue(Double.IsPositiveInfinity((double) retval), "GetValue(FrameworkElement.MaxHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.HorizontalAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.HorizontalAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is HorizontalAlignment, "GetValue(FrameworkElement.HorizontalAlignmentProperty) is not of the correct type");
            Assert.AreEqual(HorizontalAlignment.Stretch, retval, "GetValue(FrameworkElement.HorizontalAlignmentProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.VerticalAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.VerticalAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is VerticalAlignment, "GetValue(FrameworkElement.VerticalAlignmentProperty) is not of the correct type");
            Assert.AreEqual(VerticalAlignment.Stretch, retval, "GetValue(FrameworkElement.VerticalAlignmentProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MarginProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MarginProperty) should not have returned null");
            Assert.IsTrue(retval is Thickness, "GetValue(FrameworkElement.MarginProperty) is not of the correct type");
            Assert.AreEqual("0,0,0,0", retval.ToString (), "GetValue(FrameworkElement.MarginProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.StyleProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.StyleProperty) should have returned null");
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.NameProperty) should not have returned null");
            Assert.IsTrue(retval is string, "GetValue(FrameworkElement.NameProperty) is not of the correct type");
            Assert.AreEqual("", retval, "GetValue(FrameworkElement.NameProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.TagProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.TagProperty) should have returned null");
            retval = widget.GetValue(FrameworkElement.DataContextProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.DataContextProperty) should have returned null");
        }

        [TestMethod]
        public void Test_GetValue_UIElement ()
        {
            Ellipse widget = new Ellipse ();
            object retval;

            retval = widget.GetValue(UIElement.OpacityProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.OpacityProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(UIElement.OpacityProperty) is not of the correct type");
            Assert.AreEqual((double) 1, retval, "GetValue(UIElement.OpacityProperty) does not match the default value");
            retval = widget.GetValue(UIElement.ClipProperty);
            Assert.IsNull(retval, "GetValue(UIElement.ClipProperty) should have returned null");
            retval = widget.GetValue(UIElement.RenderTransformProperty);
            Assert.IsNull(retval, "GetValue(UIElement.RenderTransformProperty) should have returned null");
            retval = widget.GetValue(UIElement.OpacityMaskProperty);
            Assert.IsNull(retval, "GetValue(UIElement.OpacityMaskProperty) should have returned null");
            retval = widget.GetValue(UIElement.RenderTransformOriginProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.RenderTransformOriginProperty) should not have returned null");
            Assert.IsTrue(retval is Point, "GetValue(UIElement.RenderTransformOriginProperty) is not of the correct type");
            Assert.AreEqual("0,0", retval.ToString (), "GetValue(UIElement.RenderTransformOriginProperty) does not match the default value");
            retval = widget.GetValue(UIElement.IsHitTestVisibleProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.IsHitTestVisibleProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(UIElement.IsHitTestVisibleProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(UIElement.IsHitTestVisibleProperty) does not match the default value");
            retval = widget.GetValue(UIElement.VisibilityProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.VisibilityProperty) should not have returned null");
            Assert.IsTrue(retval is Visibility, "GetValue(UIElement.VisibilityProperty) is not of the correct type");
            Assert.AreEqual(Visibility.Visible, retval, "GetValue(UIElement.VisibilityProperty) does not match the default value");
            retval = widget.GetValue(UIElement.UseLayoutRoundingProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.UseLayoutRoundingProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(UIElement.UseLayoutRoundingProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(UIElement.UseLayoutRoundingProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_Ellipse ()
        {
            Ellipse widget = new Ellipse ();

            Assert.IsNull(widget.Fill, "Fill should have returned null");
            Assert.IsNull(widget.Stroke, "Stroke should have returned null");
            Assert.AreEqual((double) 10, widget.StrokeMiterLimit, "StrokeMiterLimit does not match the default value");
            Assert.AreEqual((double) 1, widget.StrokeThickness, "StrokeThickness does not match the default value");
            Assert.AreEqual(PenLineCap.Flat, widget.StrokeStartLineCap, "StrokeStartLineCap does not match the default value");
            Assert.AreEqual(PenLineCap.Flat, widget.StrokeEndLineCap, "StrokeEndLineCap does not match the default value");
            Assert.AreEqual(PenLineJoin.Miter, widget.StrokeLineJoin, "StrokeLineJoin does not match the default value");
            Assert.AreEqual((double) 0, widget.StrokeDashOffset, "StrokeDashOffset does not match the default value");
            Assert.AreEqual(PenLineCap.Flat, widget.StrokeDashCap, "StrokeDashCap does not match the default value");
            Assert.IsNotNull(widget.StrokeDashArray, "StrokeDashArray should not have returned null");
            Assert.IsTrue(widget.StrokeDashArray is DoubleCollection, "StrokeDashArray is not of the correct type");
            Assert.AreEqual(Stretch.Fill, widget.Stretch, "Stretch does not match the default value");
            Assert.IsNotNull(widget.GeometryTransform, "GeometryTransform should not have returned null");
            Assert.IsTrue(widget.GeometryTransform is MatrixTransform, "GeometryTransform is not of the correct type");
            Assert.IsNotNull(widget.Triggers, "Triggers should not have returned null");
            Assert.IsTrue(widget.Triggers is TriggerCollection, "Triggers is not of the correct type");
            Assert.IsNotNull(widget.Resources, "Resources should not have returned null");
            Assert.IsTrue(widget.Resources is ResourceDictionary, "Resources is not of the correct type");
            Assert.AreEqual((double) 0, widget.ActualWidth, "ActualWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.ActualHeight, "ActualHeight does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Width), "Width does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Height), "Height does not match the default value");
            Assert.AreEqual((double) 0, widget.MinWidth, "MinWidth does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxWidth), "MaxWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.MinHeight, "MinHeight does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxHeight), "MaxHeight does not match the default value");
            Assert.AreEqual(HorizontalAlignment.Stretch, widget.HorizontalAlignment, "HorizontalAlignment does not match the default value");
            Assert.AreEqual(VerticalAlignment.Stretch, widget.VerticalAlignment, "VerticalAlignment does not match the default value");
            Assert.AreEqual("0,0,0,0", widget.Margin.ToString (), "Margin does not match the default value");
            Assert.IsNull(widget.Style, "Style should have returned null");
            Assert.IsNull(widget.Parent, "Parent should have returned null");
            Assert.IsNotNull(widget.Name, "Name should not have returned null");
            Assert.AreEqual("", widget.Name, "Name does not match the default value");
            Assert.IsNull(widget.Tag, "Tag should have returned null");
            Assert.IsNull(widget.Cursor, "Cursor should have returned null");
            Assert.IsNotNull(widget.Language, "Language should not have returned null");
            Assert.AreEqual("en-us", widget.Language.IetfLanguageTag, "Language does not match the default value");
            Assert.IsNull(widget.DataContext, "DataContext should have returned null");
            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNull(widget.Clip, "Clip should have returned null");
            Assert.IsNull(widget.OpacityMask, "OpacityMask should have returned null");
            Assert.AreEqual("0,0", widget.RenderTransformOrigin.ToString (), "RenderTransformOrigin does not match the default value");
            Assert.AreEqual(true, widget.IsHitTestVisible, "IsHitTestVisible does not match the default value");
            Assert.AreEqual(Visibility.Visible, widget.Visibility, "Visibility does not match the default value");
            Assert.AreEqual("0,0", widget.RenderSize.ToString (), "RenderSize does not match the default value");
            Assert.AreEqual(true, widget.UseLayoutRounding, "UseLayoutRounding does not match the default value");
            Assert.AreEqual("0,0", widget.DesiredSize.ToString (), "DesiredSize does not match the default value");
            Assert.IsNotNull(widget.RenderTransform, "RenderTransform should not have returned null");
            Assert.IsTrue(widget.RenderTransform is MatrixTransform, "RenderTransform is not of the correct type");
        }

        [TestMethod]
        public void Test_PropertyGetter_FrameworkElement ()
        {
            Ellipse widget = new Ellipse ();

            Assert.IsNotNull(widget.Triggers, "Triggers should not have returned null");
            Assert.IsTrue(widget.Triggers is TriggerCollection, "Triggers is not of the correct type");
            Assert.IsNotNull(widget.Resources, "Resources should not have returned null");
            Assert.IsTrue(widget.Resources is ResourceDictionary, "Resources is not of the correct type");
            Assert.AreEqual((double) 0, widget.ActualWidth, "ActualWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.ActualHeight, "ActualHeight does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Width), "Width does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Height), "Height does not match the default value");
            Assert.AreEqual((double) 0, widget.MinWidth, "MinWidth does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxWidth), "MaxWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.MinHeight, "MinHeight does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxHeight), "MaxHeight does not match the default value");
            Assert.AreEqual(HorizontalAlignment.Stretch, widget.HorizontalAlignment, "HorizontalAlignment does not match the default value");
            Assert.AreEqual(VerticalAlignment.Stretch, widget.VerticalAlignment, "VerticalAlignment does not match the default value");
            Assert.AreEqual("0,0,0,0", widget.Margin.ToString (), "Margin does not match the default value");
            Assert.IsNull(widget.Style, "Style should have returned null");
            Assert.IsNull(widget.Parent, "Parent should have returned null");
            Assert.IsNotNull(widget.Name, "Name should not have returned null");
            Assert.AreEqual("", widget.Name, "Name does not match the default value");
            Assert.IsNull(widget.Tag, "Tag should have returned null");
            Assert.IsNull(widget.Cursor, "Cursor should have returned null");
            Assert.IsNotNull(widget.Language, "Language should not have returned null");
            Assert.AreEqual("en-us", widget.Language.IetfLanguageTag, "Language does not match the default value");
            Assert.IsNull(widget.DataContext, "DataContext should have returned null");
            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNull(widget.Clip, "Clip should have returned null");
            Assert.IsNull(widget.OpacityMask, "OpacityMask should have returned null");
            Assert.AreEqual("0,0", widget.RenderTransformOrigin.ToString (), "RenderTransformOrigin does not match the default value");
            Assert.AreEqual(true, widget.IsHitTestVisible, "IsHitTestVisible does not match the default value");
            Assert.AreEqual(Visibility.Visible, widget.Visibility, "Visibility does not match the default value");
            Assert.AreEqual("0,0", widget.RenderSize.ToString (), "RenderSize does not match the default value");
            Assert.AreEqual(true, widget.UseLayoutRounding, "UseLayoutRounding does not match the default value");
            Assert.AreEqual("0,0", widget.DesiredSize.ToString (), "DesiredSize does not match the default value");
            Assert.IsNotNull(widget.RenderTransform, "RenderTransform should not have returned null");
            Assert.IsTrue(widget.RenderTransform is MatrixTransform, "RenderTransform is not of the correct type");
        }

        [TestMethod]
	[MoonlightBug]
        public void Test_SetStringValue_FrameworkElement ()
        {
            Ellipse widget = new Ellipse ();
            object retval;

            widget.SetValue(FrameworkElement.NameProperty, "some text");
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.AreEqual("some text", retval, "GetValue(FrameworkElement.NameProperty) should have returned 'some text'");
            widget.SetValue(FrameworkElement.NameProperty, null);
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.AreEqual(String.Empty, retval, "GetValue(FrameworkElement.NameProperty) should have returned String.Empty");
            retval = widget.ReadLocalValue(FrameworkElement.NameProperty);
            Assert.AreEqual(String.Empty, retval, "ReadLocalValue(FrameworkElement.NameProperty) should have returned String.Empty");
        }

    }
}
namespace MoonTest.System.Windows.Shapes
{
    public partial class LineTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_Line ()
        {
            Line widget = new Line ();
            object retval;

            retval = widget.ReadLocalValue(Line.X1Property);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Line.X1Property) should not have a value by default");
            retval = widget.ReadLocalValue(Line.Y1Property);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Line.Y1Property) should not have a value by default");
            retval = widget.ReadLocalValue(Line.X2Property);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Line.X2Property) should not have a value by default");
            retval = widget.ReadLocalValue(Line.Y2Property);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Line.Y2Property) should not have a value by default");
        }

        [TestMethod]
	[MoonlightBug]
        public void Test_ReadLocalValue_Shape ()
        {
            Line widget = new Line ();
            object retval;

            retval = widget.ReadLocalValue(Shape.FillProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.FillProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeMiterLimitProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeMiterLimitProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeThicknessProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeThicknessProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeStartLineCapProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeStartLineCapProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeEndLineCapProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeEndLineCapProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeLineJoinProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeLineJoinProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeDashOffsetProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeDashOffsetProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeDashCapProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeDashCapProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeDashArrayProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeDashArrayProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StretchProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StretchProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_FrameworkElement ()
        {
            Line widget = new Line ();
            object retval;

            retval = widget.ReadLocalValue(FrameworkElement.LanguageProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.LanguageProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.ActualWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.ActualWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.ActualHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.ActualHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.WidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.WidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.HeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.HeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MinWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MinWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MaxWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MaxWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MinHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MinHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MaxHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MaxHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.HorizontalAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.HorizontalAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.VerticalAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.VerticalAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MarginProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MarginProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.StyleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.StyleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.NameProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.NameProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.TagProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.TagProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.DataContextProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.DataContextProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_UIElement ()
        {
            Line widget = new Line ();
            object retval;

            retval = widget.ReadLocalValue(UIElement.OpacityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.OpacityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.ClipProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.ClipProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.RenderTransformProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.RenderTransformProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.OpacityMaskProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.OpacityMaskProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.RenderTransformOriginProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.RenderTransformOriginProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.IsHitTestVisibleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.IsHitTestVisibleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.VisibilityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.VisibilityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.UseLayoutRoundingProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.UseLayoutRoundingProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_Line ()
        {
            Line widget = new Line ();
            object retval;

            retval = widget.GetValue(Line.X1Property);
            Assert.IsNotNull(retval, "GetValue(Line.X1Property) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Line.X1Property) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(Line.X1Property) does not match the default value");
            retval = widget.GetValue(Line.Y1Property);
            Assert.IsNotNull(retval, "GetValue(Line.Y1Property) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Line.Y1Property) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(Line.Y1Property) does not match the default value");
            retval = widget.GetValue(Line.X2Property);
            Assert.IsNotNull(retval, "GetValue(Line.X2Property) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Line.X2Property) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(Line.X2Property) does not match the default value");
            retval = widget.GetValue(Line.Y2Property);
            Assert.IsNotNull(retval, "GetValue(Line.Y2Property) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Line.Y2Property) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(Line.Y2Property) does not match the default value");
        }

        [TestMethod]
        public void Test_GetValue_Shape ()
        {
            Line widget = new Line ();
            object retval;

            retval = widget.GetValue(Shape.FillProperty);
            Assert.IsNull(retval, "GetValue(Shape.FillProperty) should have returned null");
            retval = widget.GetValue(Shape.StrokeProperty);
            Assert.IsNull(retval, "GetValue(Shape.StrokeProperty) should have returned null");
            retval = widget.GetValue(Shape.StrokeMiterLimitProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StrokeMiterLimitProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Shape.StrokeMiterLimitProperty) is not of the correct type");
            Assert.AreEqual((double) 10, retval, "GetValue(Shape.StrokeMiterLimitProperty) does not match the default value");
            retval = widget.GetValue(Shape.StrokeThicknessProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StrokeThicknessProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Shape.StrokeThicknessProperty) is not of the correct type");
            Assert.AreEqual((double) 1, retval, "GetValue(Shape.StrokeThicknessProperty) does not match the default value");
            retval = widget.GetValue(Shape.StrokeStartLineCapProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StrokeStartLineCapProperty) should not have returned null");
            Assert.IsTrue(retval is PenLineCap, "GetValue(Shape.StrokeStartLineCapProperty) is not of the correct type");
            Assert.AreEqual(PenLineCap.Flat, retval, "GetValue(Shape.StrokeStartLineCapProperty) does not match the default value");
            retval = widget.GetValue(Shape.StrokeEndLineCapProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StrokeEndLineCapProperty) should not have returned null");
            Assert.IsTrue(retval is PenLineCap, "GetValue(Shape.StrokeEndLineCapProperty) is not of the correct type");
            Assert.AreEqual(PenLineCap.Flat, retval, "GetValue(Shape.StrokeEndLineCapProperty) does not match the default value");
            retval = widget.GetValue(Shape.StrokeLineJoinProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StrokeLineJoinProperty) should not have returned null");
            Assert.IsTrue(retval is PenLineJoin, "GetValue(Shape.StrokeLineJoinProperty) is not of the correct type");
            Assert.AreEqual(PenLineJoin.Miter, retval, "GetValue(Shape.StrokeLineJoinProperty) does not match the default value");
            retval = widget.GetValue(Shape.StrokeDashOffsetProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StrokeDashOffsetProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Shape.StrokeDashOffsetProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(Shape.StrokeDashOffsetProperty) does not match the default value");
            retval = widget.GetValue(Shape.StrokeDashCapProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StrokeDashCapProperty) should not have returned null");
            Assert.IsTrue(retval is PenLineCap, "GetValue(Shape.StrokeDashCapProperty) is not of the correct type");
            Assert.AreEqual(PenLineCap.Flat, retval, "GetValue(Shape.StrokeDashCapProperty) does not match the default value");
            retval = widget.GetValue(Shape.StrokeDashArrayProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StrokeDashArrayProperty) should not have returned null");
            Assert.IsTrue(retval is DoubleCollection, "GetValue(Shape.StrokeDashArrayProperty) is not of the correct type");
            retval = widget.GetValue(Shape.StretchProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StretchProperty) should not have returned null");
            Assert.IsTrue(retval is Stretch, "GetValue(Shape.StretchProperty) is not of the correct type");
            Assert.AreEqual(Stretch.None, retval, "GetValue(Shape.StretchProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_GetValue_FrameworkElement ()
        {
            Line widget = new Line ();
            object retval;

            retval = widget.GetValue(FrameworkElement.LanguageProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.LanguageProperty) should not have returned null");
            Assert.IsTrue(retval is XmlLanguage, "GetValue(FrameworkElement.LanguageProperty) is not of the correct type");
            Assert.AreEqual("en-us", ((XmlLanguage) retval).IetfLanguageTag, "GetValue(FrameworkElement.LanguageProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.ActualWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.ActualWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.ActualWidthProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.ActualWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.ActualHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.ActualHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.ActualHeightProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.ActualHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.WidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.WidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.WidthProperty) is not of the correct type");
            Assert.IsTrue(Double.IsNaN((double) retval), "GetValue(FrameworkElement.WidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.HeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.HeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.HeightProperty) is not of the correct type");
            Assert.IsTrue(Double.IsNaN((double) retval), "GetValue(FrameworkElement.HeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MinWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MinWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MinWidthProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.MinWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MaxWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MaxWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MaxWidthProperty) is not of the correct type");
            Assert.IsTrue(Double.IsPositiveInfinity((double) retval), "GetValue(FrameworkElement.MaxWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MinHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MinHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MinHeightProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.MinHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MaxHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MaxHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MaxHeightProperty) is not of the correct type");
            Assert.IsTrue(Double.IsPositiveInfinity((double) retval), "GetValue(FrameworkElement.MaxHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.HorizontalAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.HorizontalAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is HorizontalAlignment, "GetValue(FrameworkElement.HorizontalAlignmentProperty) is not of the correct type");
            Assert.AreEqual(HorizontalAlignment.Stretch, retval, "GetValue(FrameworkElement.HorizontalAlignmentProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.VerticalAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.VerticalAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is VerticalAlignment, "GetValue(FrameworkElement.VerticalAlignmentProperty) is not of the correct type");
            Assert.AreEqual(VerticalAlignment.Stretch, retval, "GetValue(FrameworkElement.VerticalAlignmentProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MarginProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MarginProperty) should not have returned null");
            Assert.IsTrue(retval is Thickness, "GetValue(FrameworkElement.MarginProperty) is not of the correct type");
            Assert.AreEqual("0,0,0,0", retval.ToString (), "GetValue(FrameworkElement.MarginProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.StyleProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.StyleProperty) should have returned null");
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.NameProperty) should not have returned null");
            Assert.IsTrue(retval is string, "GetValue(FrameworkElement.NameProperty) is not of the correct type");
            Assert.AreEqual("", retval, "GetValue(FrameworkElement.NameProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.TagProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.TagProperty) should have returned null");
            retval = widget.GetValue(FrameworkElement.DataContextProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.DataContextProperty) should have returned null");
        }

        [TestMethod]
        public void Test_GetValue_UIElement ()
        {
            Line widget = new Line ();
            object retval;

            retval = widget.GetValue(UIElement.OpacityProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.OpacityProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(UIElement.OpacityProperty) is not of the correct type");
            Assert.AreEqual((double) 1, retval, "GetValue(UIElement.OpacityProperty) does not match the default value");
            retval = widget.GetValue(UIElement.ClipProperty);
            Assert.IsNull(retval, "GetValue(UIElement.ClipProperty) should have returned null");
            retval = widget.GetValue(UIElement.RenderTransformProperty);
            Assert.IsNull(retval, "GetValue(UIElement.RenderTransformProperty) should have returned null");
            retval = widget.GetValue(UIElement.OpacityMaskProperty);
            Assert.IsNull(retval, "GetValue(UIElement.OpacityMaskProperty) should have returned null");
            retval = widget.GetValue(UIElement.RenderTransformOriginProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.RenderTransformOriginProperty) should not have returned null");
            Assert.IsTrue(retval is Point, "GetValue(UIElement.RenderTransformOriginProperty) is not of the correct type");
            Assert.AreEqual("0,0", retval.ToString (), "GetValue(UIElement.RenderTransformOriginProperty) does not match the default value");
            retval = widget.GetValue(UIElement.IsHitTestVisibleProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.IsHitTestVisibleProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(UIElement.IsHitTestVisibleProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(UIElement.IsHitTestVisibleProperty) does not match the default value");
            retval = widget.GetValue(UIElement.VisibilityProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.VisibilityProperty) should not have returned null");
            Assert.IsTrue(retval is Visibility, "GetValue(UIElement.VisibilityProperty) is not of the correct type");
            Assert.AreEqual(Visibility.Visible, retval, "GetValue(UIElement.VisibilityProperty) does not match the default value");
            retval = widget.GetValue(UIElement.UseLayoutRoundingProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.UseLayoutRoundingProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(UIElement.UseLayoutRoundingProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(UIElement.UseLayoutRoundingProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_Line ()
        {
            Line widget = new Line ();

            Assert.AreEqual((double) 0, widget.X1, "X1 does not match the default value");
            Assert.AreEqual((double) 0, widget.Y1, "Y1 does not match the default value");
            Assert.AreEqual((double) 0, widget.X2, "X2 does not match the default value");
            Assert.AreEqual((double) 0, widget.Y2, "Y2 does not match the default value");
            Assert.IsNull(widget.Fill, "Fill should have returned null");
            Assert.IsNull(widget.Stroke, "Stroke should have returned null");
            Assert.AreEqual((double) 10, widget.StrokeMiterLimit, "StrokeMiterLimit does not match the default value");
            Assert.AreEqual((double) 1, widget.StrokeThickness, "StrokeThickness does not match the default value");
            Assert.AreEqual(PenLineCap.Flat, widget.StrokeStartLineCap, "StrokeStartLineCap does not match the default value");
            Assert.AreEqual(PenLineCap.Flat, widget.StrokeEndLineCap, "StrokeEndLineCap does not match the default value");
            Assert.AreEqual(PenLineJoin.Miter, widget.StrokeLineJoin, "StrokeLineJoin does not match the default value");
            Assert.AreEqual((double) 0, widget.StrokeDashOffset, "StrokeDashOffset does not match the default value");
            Assert.AreEqual(PenLineCap.Flat, widget.StrokeDashCap, "StrokeDashCap does not match the default value");
            Assert.IsNotNull(widget.StrokeDashArray, "StrokeDashArray should not have returned null");
            Assert.IsTrue(widget.StrokeDashArray is DoubleCollection, "StrokeDashArray is not of the correct type");
            Assert.AreEqual(Stretch.None, widget.Stretch, "Stretch does not match the default value");
            Assert.IsNotNull(widget.GeometryTransform, "GeometryTransform should not have returned null");
            Assert.IsTrue(widget.GeometryTransform is MatrixTransform, "GeometryTransform is not of the correct type");
            Assert.IsNotNull(widget.Triggers, "Triggers should not have returned null");
            Assert.IsTrue(widget.Triggers is TriggerCollection, "Triggers is not of the correct type");
            Assert.IsNotNull(widget.Resources, "Resources should not have returned null");
            Assert.IsTrue(widget.Resources is ResourceDictionary, "Resources is not of the correct type");
            Assert.AreEqual((double) 0, widget.ActualWidth, "ActualWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.ActualHeight, "ActualHeight does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Width), "Width does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Height), "Height does not match the default value");
            Assert.AreEqual((double) 0, widget.MinWidth, "MinWidth does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxWidth), "MaxWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.MinHeight, "MinHeight does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxHeight), "MaxHeight does not match the default value");
            Assert.AreEqual(HorizontalAlignment.Stretch, widget.HorizontalAlignment, "HorizontalAlignment does not match the default value");
            Assert.AreEqual(VerticalAlignment.Stretch, widget.VerticalAlignment, "VerticalAlignment does not match the default value");
            Assert.AreEqual("0,0,0,0", widget.Margin.ToString (), "Margin does not match the default value");
            Assert.IsNull(widget.Style, "Style should have returned null");
            Assert.IsNull(widget.Parent, "Parent should have returned null");
            Assert.IsNotNull(widget.Name, "Name should not have returned null");
            Assert.AreEqual("", widget.Name, "Name does not match the default value");
            Assert.IsNull(widget.Tag, "Tag should have returned null");
            Assert.IsNull(widget.Cursor, "Cursor should have returned null");
            Assert.IsNotNull(widget.Language, "Language should not have returned null");
            Assert.AreEqual("en-us", widget.Language.IetfLanguageTag, "Language does not match the default value");
            Assert.IsNull(widget.DataContext, "DataContext should have returned null");
            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNull(widget.Clip, "Clip should have returned null");
            Assert.IsNull(widget.OpacityMask, "OpacityMask should have returned null");
            Assert.AreEqual("0,0", widget.RenderTransformOrigin.ToString (), "RenderTransformOrigin does not match the default value");
            Assert.AreEqual(true, widget.IsHitTestVisible, "IsHitTestVisible does not match the default value");
            Assert.AreEqual(Visibility.Visible, widget.Visibility, "Visibility does not match the default value");
            Assert.AreEqual("0,0", widget.RenderSize.ToString (), "RenderSize does not match the default value");
            Assert.AreEqual(true, widget.UseLayoutRounding, "UseLayoutRounding does not match the default value");
            Assert.AreEqual("0,0", widget.DesiredSize.ToString (), "DesiredSize does not match the default value");
            Assert.IsNotNull(widget.RenderTransform, "RenderTransform should not have returned null");
            Assert.IsTrue(widget.RenderTransform is MatrixTransform, "RenderTransform is not of the correct type");
        }

        [TestMethod]
        public void Test_PropertyGetter_FrameworkElement ()
        {
            Line widget = new Line ();

            Assert.IsNotNull(widget.Triggers, "Triggers should not have returned null");
            Assert.IsTrue(widget.Triggers is TriggerCollection, "Triggers is not of the correct type");
            Assert.IsNotNull(widget.Resources, "Resources should not have returned null");
            Assert.IsTrue(widget.Resources is ResourceDictionary, "Resources is not of the correct type");
            Assert.AreEqual((double) 0, widget.ActualWidth, "ActualWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.ActualHeight, "ActualHeight does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Width), "Width does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Height), "Height does not match the default value");
            Assert.AreEqual((double) 0, widget.MinWidth, "MinWidth does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxWidth), "MaxWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.MinHeight, "MinHeight does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxHeight), "MaxHeight does not match the default value");
            Assert.AreEqual(HorizontalAlignment.Stretch, widget.HorizontalAlignment, "HorizontalAlignment does not match the default value");
            Assert.AreEqual(VerticalAlignment.Stretch, widget.VerticalAlignment, "VerticalAlignment does not match the default value");
            Assert.AreEqual("0,0,0,0", widget.Margin.ToString (), "Margin does not match the default value");
            Assert.IsNull(widget.Style, "Style should have returned null");
            Assert.IsNull(widget.Parent, "Parent should have returned null");
            Assert.IsNotNull(widget.Name, "Name should not have returned null");
            Assert.AreEqual("", widget.Name, "Name does not match the default value");
            Assert.IsNull(widget.Tag, "Tag should have returned null");
            Assert.IsNull(widget.Cursor, "Cursor should have returned null");
            Assert.IsNotNull(widget.Language, "Language should not have returned null");
            Assert.AreEqual("en-us", widget.Language.IetfLanguageTag, "Language does not match the default value");
            Assert.IsNull(widget.DataContext, "DataContext should have returned null");
            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNull(widget.Clip, "Clip should have returned null");
            Assert.IsNull(widget.OpacityMask, "OpacityMask should have returned null");
            Assert.AreEqual("0,0", widget.RenderTransformOrigin.ToString (), "RenderTransformOrigin does not match the default value");
            Assert.AreEqual(true, widget.IsHitTestVisible, "IsHitTestVisible does not match the default value");
            Assert.AreEqual(Visibility.Visible, widget.Visibility, "Visibility does not match the default value");
            Assert.AreEqual("0,0", widget.RenderSize.ToString (), "RenderSize does not match the default value");
            Assert.AreEqual(true, widget.UseLayoutRounding, "UseLayoutRounding does not match the default value");
            Assert.AreEqual("0,0", widget.DesiredSize.ToString (), "DesiredSize does not match the default value");
            Assert.IsNotNull(widget.RenderTransform, "RenderTransform should not have returned null");
            Assert.IsTrue(widget.RenderTransform is MatrixTransform, "RenderTransform is not of the correct type");
        }

        [TestMethod]
	[MoonlightBug]
        public void Test_SetStringValue_FrameworkElement ()
        {
            Line widget = new Line ();
            object retval;

            widget.SetValue(FrameworkElement.NameProperty, "some text");
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.AreEqual("some text", retval, "GetValue(FrameworkElement.NameProperty) should have returned 'some text'");
            widget.SetValue(FrameworkElement.NameProperty, null);
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.AreEqual(String.Empty, retval, "GetValue(FrameworkElement.NameProperty) should have returned String.Empty");
            retval = widget.ReadLocalValue(FrameworkElement.NameProperty);
            Assert.AreEqual(String.Empty, retval, "ReadLocalValue(FrameworkElement.NameProperty) should have returned String.Empty");
        }

    }
}
namespace MoonTest.System.Windows.Shapes
{
    public partial class PolygonTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_Polygon ()
        {
            Polygon widget = new Polygon ();
            object retval;

            retval = widget.ReadLocalValue(Polygon.FillRuleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Polygon.FillRuleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Polygon.PointsProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Polygon.PointsProperty) should not have a value by default");
        }

        [TestMethod]
	[MoonlightBug]
        public void Test_ReadLocalValue_Shape ()
        {
            Polygon widget = new Polygon ();
            object retval;

            retval = widget.ReadLocalValue(Shape.FillProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.FillProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeMiterLimitProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeMiterLimitProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeThicknessProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeThicknessProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeStartLineCapProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeStartLineCapProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeEndLineCapProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeEndLineCapProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeLineJoinProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeLineJoinProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeDashOffsetProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeDashOffsetProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeDashCapProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeDashCapProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeDashArrayProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeDashArrayProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StretchProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StretchProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_FrameworkElement ()
        {
            Polygon widget = new Polygon ();
            object retval;

            retval = widget.ReadLocalValue(FrameworkElement.LanguageProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.LanguageProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.ActualWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.ActualWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.ActualHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.ActualHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.WidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.WidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.HeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.HeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MinWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MinWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MaxWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MaxWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MinHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MinHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MaxHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MaxHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.HorizontalAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.HorizontalAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.VerticalAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.VerticalAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MarginProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MarginProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.StyleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.StyleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.NameProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.NameProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.TagProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.TagProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.DataContextProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.DataContextProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_UIElement ()
        {
            Polygon widget = new Polygon ();
            object retval;

            retval = widget.ReadLocalValue(UIElement.OpacityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.OpacityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.ClipProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.ClipProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.RenderTransformProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.RenderTransformProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.OpacityMaskProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.OpacityMaskProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.RenderTransformOriginProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.RenderTransformOriginProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.IsHitTestVisibleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.IsHitTestVisibleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.VisibilityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.VisibilityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.UseLayoutRoundingProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.UseLayoutRoundingProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_Polygon ()
        {
            Polygon widget = new Polygon ();
            object retval;

            retval = widget.GetValue(Polygon.FillRuleProperty);
            Assert.IsNotNull(retval, "GetValue(Polygon.FillRuleProperty) should not have returned null");
            Assert.IsTrue(retval is FillRule, "GetValue(Polygon.FillRuleProperty) is not of the correct type");
            Assert.AreEqual(FillRule.EvenOdd, retval, "GetValue(Polygon.FillRuleProperty) does not match the default value");
            retval = widget.GetValue(Polygon.PointsProperty);
            Assert.IsNotNull(retval, "GetValue(Polygon.PointsProperty) should not have returned null");
            Assert.IsTrue(retval is PointCollection, "GetValue(Polygon.PointsProperty) is not of the correct type");
        }

        [TestMethod]
        public void Test_GetValue_Shape ()
        {
            Polygon widget = new Polygon ();
            object retval;

            retval = widget.GetValue(Shape.FillProperty);
            Assert.IsNull(retval, "GetValue(Shape.FillProperty) should have returned null");
            retval = widget.GetValue(Shape.StrokeProperty);
            Assert.IsNull(retval, "GetValue(Shape.StrokeProperty) should have returned null");
            retval = widget.GetValue(Shape.StrokeMiterLimitProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StrokeMiterLimitProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Shape.StrokeMiterLimitProperty) is not of the correct type");
            Assert.AreEqual((double) 10, retval, "GetValue(Shape.StrokeMiterLimitProperty) does not match the default value");
            retval = widget.GetValue(Shape.StrokeThicknessProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StrokeThicknessProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Shape.StrokeThicknessProperty) is not of the correct type");
            Assert.AreEqual((double) 1, retval, "GetValue(Shape.StrokeThicknessProperty) does not match the default value");
            retval = widget.GetValue(Shape.StrokeStartLineCapProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StrokeStartLineCapProperty) should not have returned null");
            Assert.IsTrue(retval is PenLineCap, "GetValue(Shape.StrokeStartLineCapProperty) is not of the correct type");
            Assert.AreEqual(PenLineCap.Flat, retval, "GetValue(Shape.StrokeStartLineCapProperty) does not match the default value");
            retval = widget.GetValue(Shape.StrokeEndLineCapProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StrokeEndLineCapProperty) should not have returned null");
            Assert.IsTrue(retval is PenLineCap, "GetValue(Shape.StrokeEndLineCapProperty) is not of the correct type");
            Assert.AreEqual(PenLineCap.Flat, retval, "GetValue(Shape.StrokeEndLineCapProperty) does not match the default value");
            retval = widget.GetValue(Shape.StrokeLineJoinProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StrokeLineJoinProperty) should not have returned null");
            Assert.IsTrue(retval is PenLineJoin, "GetValue(Shape.StrokeLineJoinProperty) is not of the correct type");
            Assert.AreEqual(PenLineJoin.Miter, retval, "GetValue(Shape.StrokeLineJoinProperty) does not match the default value");
            retval = widget.GetValue(Shape.StrokeDashOffsetProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StrokeDashOffsetProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Shape.StrokeDashOffsetProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(Shape.StrokeDashOffsetProperty) does not match the default value");
            retval = widget.GetValue(Shape.StrokeDashCapProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StrokeDashCapProperty) should not have returned null");
            Assert.IsTrue(retval is PenLineCap, "GetValue(Shape.StrokeDashCapProperty) is not of the correct type");
            Assert.AreEqual(PenLineCap.Flat, retval, "GetValue(Shape.StrokeDashCapProperty) does not match the default value");
            retval = widget.GetValue(Shape.StrokeDashArrayProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StrokeDashArrayProperty) should not have returned null");
            Assert.IsTrue(retval is DoubleCollection, "GetValue(Shape.StrokeDashArrayProperty) is not of the correct type");
            retval = widget.GetValue(Shape.StretchProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StretchProperty) should not have returned null");
            Assert.IsTrue(retval is Stretch, "GetValue(Shape.StretchProperty) is not of the correct type");
            Assert.AreEqual(Stretch.None, retval, "GetValue(Shape.StretchProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_GetValue_FrameworkElement ()
        {
            Polygon widget = new Polygon ();
            object retval;

            retval = widget.GetValue(FrameworkElement.LanguageProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.LanguageProperty) should not have returned null");
            Assert.IsTrue(retval is XmlLanguage, "GetValue(FrameworkElement.LanguageProperty) is not of the correct type");
            Assert.AreEqual("en-us", ((XmlLanguage) retval).IetfLanguageTag, "GetValue(FrameworkElement.LanguageProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.ActualWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.ActualWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.ActualWidthProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.ActualWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.ActualHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.ActualHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.ActualHeightProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.ActualHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.WidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.WidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.WidthProperty) is not of the correct type");
            Assert.IsTrue(Double.IsNaN((double) retval), "GetValue(FrameworkElement.WidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.HeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.HeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.HeightProperty) is not of the correct type");
            Assert.IsTrue(Double.IsNaN((double) retval), "GetValue(FrameworkElement.HeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MinWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MinWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MinWidthProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.MinWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MaxWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MaxWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MaxWidthProperty) is not of the correct type");
            Assert.IsTrue(Double.IsPositiveInfinity((double) retval), "GetValue(FrameworkElement.MaxWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MinHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MinHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MinHeightProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.MinHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MaxHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MaxHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MaxHeightProperty) is not of the correct type");
            Assert.IsTrue(Double.IsPositiveInfinity((double) retval), "GetValue(FrameworkElement.MaxHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.HorizontalAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.HorizontalAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is HorizontalAlignment, "GetValue(FrameworkElement.HorizontalAlignmentProperty) is not of the correct type");
            Assert.AreEqual(HorizontalAlignment.Stretch, retval, "GetValue(FrameworkElement.HorizontalAlignmentProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.VerticalAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.VerticalAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is VerticalAlignment, "GetValue(FrameworkElement.VerticalAlignmentProperty) is not of the correct type");
            Assert.AreEqual(VerticalAlignment.Stretch, retval, "GetValue(FrameworkElement.VerticalAlignmentProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MarginProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MarginProperty) should not have returned null");
            Assert.IsTrue(retval is Thickness, "GetValue(FrameworkElement.MarginProperty) is not of the correct type");
            Assert.AreEqual("0,0,0,0", retval.ToString (), "GetValue(FrameworkElement.MarginProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.StyleProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.StyleProperty) should have returned null");
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.NameProperty) should not have returned null");
            Assert.IsTrue(retval is string, "GetValue(FrameworkElement.NameProperty) is not of the correct type");
            Assert.AreEqual("", retval, "GetValue(FrameworkElement.NameProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.TagProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.TagProperty) should have returned null");
            retval = widget.GetValue(FrameworkElement.DataContextProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.DataContextProperty) should have returned null");
        }

        [TestMethod]
        public void Test_GetValue_UIElement ()
        {
            Polygon widget = new Polygon ();
            object retval;

            retval = widget.GetValue(UIElement.OpacityProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.OpacityProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(UIElement.OpacityProperty) is not of the correct type");
            Assert.AreEqual((double) 1, retval, "GetValue(UIElement.OpacityProperty) does not match the default value");
            retval = widget.GetValue(UIElement.ClipProperty);
            Assert.IsNull(retval, "GetValue(UIElement.ClipProperty) should have returned null");
            retval = widget.GetValue(UIElement.RenderTransformProperty);
            Assert.IsNull(retval, "GetValue(UIElement.RenderTransformProperty) should have returned null");
            retval = widget.GetValue(UIElement.OpacityMaskProperty);
            Assert.IsNull(retval, "GetValue(UIElement.OpacityMaskProperty) should have returned null");
            retval = widget.GetValue(UIElement.RenderTransformOriginProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.RenderTransformOriginProperty) should not have returned null");
            Assert.IsTrue(retval is Point, "GetValue(UIElement.RenderTransformOriginProperty) is not of the correct type");
            Assert.AreEqual("0,0", retval.ToString (), "GetValue(UIElement.RenderTransformOriginProperty) does not match the default value");
            retval = widget.GetValue(UIElement.IsHitTestVisibleProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.IsHitTestVisibleProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(UIElement.IsHitTestVisibleProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(UIElement.IsHitTestVisibleProperty) does not match the default value");
            retval = widget.GetValue(UIElement.VisibilityProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.VisibilityProperty) should not have returned null");
            Assert.IsTrue(retval is Visibility, "GetValue(UIElement.VisibilityProperty) is not of the correct type");
            Assert.AreEqual(Visibility.Visible, retval, "GetValue(UIElement.VisibilityProperty) does not match the default value");
            retval = widget.GetValue(UIElement.UseLayoutRoundingProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.UseLayoutRoundingProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(UIElement.UseLayoutRoundingProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(UIElement.UseLayoutRoundingProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_Polygon ()
        {
            Polygon widget = new Polygon ();

            Assert.AreEqual(FillRule.EvenOdd, widget.FillRule, "FillRule does not match the default value");
            Assert.IsNotNull(widget.Points, "Points should not have returned null");
            Assert.IsTrue(widget.Points is PointCollection, "Points is not of the correct type");
            Assert.IsNull(widget.Fill, "Fill should have returned null");
            Assert.IsNull(widget.Stroke, "Stroke should have returned null");
            Assert.AreEqual((double) 10, widget.StrokeMiterLimit, "StrokeMiterLimit does not match the default value");
            Assert.AreEqual((double) 1, widget.StrokeThickness, "StrokeThickness does not match the default value");
            Assert.AreEqual(PenLineCap.Flat, widget.StrokeStartLineCap, "StrokeStartLineCap does not match the default value");
            Assert.AreEqual(PenLineCap.Flat, widget.StrokeEndLineCap, "StrokeEndLineCap does not match the default value");
            Assert.AreEqual(PenLineJoin.Miter, widget.StrokeLineJoin, "StrokeLineJoin does not match the default value");
            Assert.AreEqual((double) 0, widget.StrokeDashOffset, "StrokeDashOffset does not match the default value");
            Assert.AreEqual(PenLineCap.Flat, widget.StrokeDashCap, "StrokeDashCap does not match the default value");
            Assert.IsNotNull(widget.StrokeDashArray, "StrokeDashArray should not have returned null");
            Assert.IsTrue(widget.StrokeDashArray is DoubleCollection, "StrokeDashArray is not of the correct type");
            Assert.AreEqual(Stretch.None, widget.Stretch, "Stretch does not match the default value");
            Assert.IsNotNull(widget.GeometryTransform, "GeometryTransform should not have returned null");
            Assert.IsTrue(widget.GeometryTransform is MatrixTransform, "GeometryTransform is not of the correct type");
            Assert.IsNotNull(widget.Triggers, "Triggers should not have returned null");
            Assert.IsTrue(widget.Triggers is TriggerCollection, "Triggers is not of the correct type");
            Assert.IsNotNull(widget.Resources, "Resources should not have returned null");
            Assert.IsTrue(widget.Resources is ResourceDictionary, "Resources is not of the correct type");
            Assert.AreEqual((double) 0, widget.ActualWidth, "ActualWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.ActualHeight, "ActualHeight does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Width), "Width does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Height), "Height does not match the default value");
            Assert.AreEqual((double) 0, widget.MinWidth, "MinWidth does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxWidth), "MaxWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.MinHeight, "MinHeight does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxHeight), "MaxHeight does not match the default value");
            Assert.AreEqual(HorizontalAlignment.Stretch, widget.HorizontalAlignment, "HorizontalAlignment does not match the default value");
            Assert.AreEqual(VerticalAlignment.Stretch, widget.VerticalAlignment, "VerticalAlignment does not match the default value");
            Assert.AreEqual("0,0,0,0", widget.Margin.ToString (), "Margin does not match the default value");
            Assert.IsNull(widget.Style, "Style should have returned null");
            Assert.IsNull(widget.Parent, "Parent should have returned null");
            Assert.IsNotNull(widget.Name, "Name should not have returned null");
            Assert.AreEqual("", widget.Name, "Name does not match the default value");
            Assert.IsNull(widget.Tag, "Tag should have returned null");
            Assert.IsNull(widget.Cursor, "Cursor should have returned null");
            Assert.IsNotNull(widget.Language, "Language should not have returned null");
            Assert.AreEqual("en-us", widget.Language.IetfLanguageTag, "Language does not match the default value");
            Assert.IsNull(widget.DataContext, "DataContext should have returned null");
            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNull(widget.Clip, "Clip should have returned null");
            Assert.IsNull(widget.OpacityMask, "OpacityMask should have returned null");
            Assert.AreEqual("0,0", widget.RenderTransformOrigin.ToString (), "RenderTransformOrigin does not match the default value");
            Assert.AreEqual(true, widget.IsHitTestVisible, "IsHitTestVisible does not match the default value");
            Assert.AreEqual(Visibility.Visible, widget.Visibility, "Visibility does not match the default value");
            Assert.AreEqual("0,0", widget.RenderSize.ToString (), "RenderSize does not match the default value");
            Assert.AreEqual(true, widget.UseLayoutRounding, "UseLayoutRounding does not match the default value");
            Assert.AreEqual("0,0", widget.DesiredSize.ToString (), "DesiredSize does not match the default value");
            Assert.IsNotNull(widget.RenderTransform, "RenderTransform should not have returned null");
            Assert.IsTrue(widget.RenderTransform is MatrixTransform, "RenderTransform is not of the correct type");
        }

        [TestMethod]
        public void Test_PropertyGetter_FrameworkElement ()
        {
            Polygon widget = new Polygon ();

            Assert.IsNotNull(widget.Triggers, "Triggers should not have returned null");
            Assert.IsTrue(widget.Triggers is TriggerCollection, "Triggers is not of the correct type");
            Assert.IsNotNull(widget.Resources, "Resources should not have returned null");
            Assert.IsTrue(widget.Resources is ResourceDictionary, "Resources is not of the correct type");
            Assert.AreEqual((double) 0, widget.ActualWidth, "ActualWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.ActualHeight, "ActualHeight does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Width), "Width does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Height), "Height does not match the default value");
            Assert.AreEqual((double) 0, widget.MinWidth, "MinWidth does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxWidth), "MaxWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.MinHeight, "MinHeight does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxHeight), "MaxHeight does not match the default value");
            Assert.AreEqual(HorizontalAlignment.Stretch, widget.HorizontalAlignment, "HorizontalAlignment does not match the default value");
            Assert.AreEqual(VerticalAlignment.Stretch, widget.VerticalAlignment, "VerticalAlignment does not match the default value");
            Assert.AreEqual("0,0,0,0", widget.Margin.ToString (), "Margin does not match the default value");
            Assert.IsNull(widget.Style, "Style should have returned null");
            Assert.IsNull(widget.Parent, "Parent should have returned null");
            Assert.IsNotNull(widget.Name, "Name should not have returned null");
            Assert.AreEqual("", widget.Name, "Name does not match the default value");
            Assert.IsNull(widget.Tag, "Tag should have returned null");
            Assert.IsNull(widget.Cursor, "Cursor should have returned null");
            Assert.IsNotNull(widget.Language, "Language should not have returned null");
            Assert.AreEqual("en-us", widget.Language.IetfLanguageTag, "Language does not match the default value");
            Assert.IsNull(widget.DataContext, "DataContext should have returned null");
            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNull(widget.Clip, "Clip should have returned null");
            Assert.IsNull(widget.OpacityMask, "OpacityMask should have returned null");
            Assert.AreEqual("0,0", widget.RenderTransformOrigin.ToString (), "RenderTransformOrigin does not match the default value");
            Assert.AreEqual(true, widget.IsHitTestVisible, "IsHitTestVisible does not match the default value");
            Assert.AreEqual(Visibility.Visible, widget.Visibility, "Visibility does not match the default value");
            Assert.AreEqual("0,0", widget.RenderSize.ToString (), "RenderSize does not match the default value");
            Assert.AreEqual(true, widget.UseLayoutRounding, "UseLayoutRounding does not match the default value");
            Assert.AreEqual("0,0", widget.DesiredSize.ToString (), "DesiredSize does not match the default value");
            Assert.IsNotNull(widget.RenderTransform, "RenderTransform should not have returned null");
            Assert.IsTrue(widget.RenderTransform is MatrixTransform, "RenderTransform is not of the correct type");
        }

        [TestMethod]
	[MoonlightBug]
        public void Test_SetStringValue_FrameworkElement ()
        {
            Polygon widget = new Polygon ();
            object retval;

            widget.SetValue(FrameworkElement.NameProperty, "some text");
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.AreEqual("some text", retval, "GetValue(FrameworkElement.NameProperty) should have returned 'some text'");
            widget.SetValue(FrameworkElement.NameProperty, null);
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.AreEqual(String.Empty, retval, "GetValue(FrameworkElement.NameProperty) should have returned String.Empty");
            retval = widget.ReadLocalValue(FrameworkElement.NameProperty);
            Assert.AreEqual(String.Empty, retval, "ReadLocalValue(FrameworkElement.NameProperty) should have returned String.Empty");
        }

    }
}
namespace MoonTest.System.Windows.Shapes
{
    public partial class PolylineTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_Polyline ()
        {
            Polyline widget = new Polyline ();
            object retval;

            retval = widget.ReadLocalValue(Polyline.FillRuleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Polyline.FillRuleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Polyline.PointsProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Polyline.PointsProperty) should not have a value by default");
        }

        [TestMethod]
	[MoonlightBug]
        public void Test_ReadLocalValue_Shape ()
        {
            Polyline widget = new Polyline ();
            object retval;

            retval = widget.ReadLocalValue(Shape.FillProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.FillProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeMiterLimitProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeMiterLimitProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeThicknessProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeThicknessProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeStartLineCapProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeStartLineCapProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeEndLineCapProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeEndLineCapProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeLineJoinProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeLineJoinProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeDashOffsetProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeDashOffsetProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeDashCapProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeDashCapProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeDashArrayProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeDashArrayProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StretchProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StretchProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_FrameworkElement ()
        {
            Polyline widget = new Polyline ();
            object retval;

            retval = widget.ReadLocalValue(FrameworkElement.LanguageProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.LanguageProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.ActualWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.ActualWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.ActualHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.ActualHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.WidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.WidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.HeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.HeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MinWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MinWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MaxWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MaxWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MinHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MinHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MaxHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MaxHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.HorizontalAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.HorizontalAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.VerticalAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.VerticalAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MarginProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MarginProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.StyleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.StyleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.NameProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.NameProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.TagProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.TagProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.DataContextProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.DataContextProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_UIElement ()
        {
            Polyline widget = new Polyline ();
            object retval;

            retval = widget.ReadLocalValue(UIElement.OpacityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.OpacityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.ClipProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.ClipProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.RenderTransformProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.RenderTransformProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.OpacityMaskProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.OpacityMaskProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.RenderTransformOriginProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.RenderTransformOriginProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.IsHitTestVisibleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.IsHitTestVisibleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.VisibilityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.VisibilityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.UseLayoutRoundingProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.UseLayoutRoundingProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_Polyline ()
        {
            Polyline widget = new Polyline ();
            object retval;

            retval = widget.GetValue(Polyline.FillRuleProperty);
            Assert.IsNotNull(retval, "GetValue(Polyline.FillRuleProperty) should not have returned null");
            Assert.IsTrue(retval is FillRule, "GetValue(Polyline.FillRuleProperty) is not of the correct type");
            Assert.AreEqual(FillRule.EvenOdd, retval, "GetValue(Polyline.FillRuleProperty) does not match the default value");
            retval = widget.GetValue(Polyline.PointsProperty);
            Assert.IsNotNull(retval, "GetValue(Polyline.PointsProperty) should not have returned null");
            Assert.IsTrue(retval is PointCollection, "GetValue(Polyline.PointsProperty) is not of the correct type");
        }

        [TestMethod]
        public void Test_GetValue_Shape ()
        {
            Polyline widget = new Polyline ();
            object retval;

            retval = widget.GetValue(Shape.FillProperty);
            Assert.IsNull(retval, "GetValue(Shape.FillProperty) should have returned null");
            retval = widget.GetValue(Shape.StrokeProperty);
            Assert.IsNull(retval, "GetValue(Shape.StrokeProperty) should have returned null");
            retval = widget.GetValue(Shape.StrokeMiterLimitProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StrokeMiterLimitProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Shape.StrokeMiterLimitProperty) is not of the correct type");
            Assert.AreEqual((double) 10, retval, "GetValue(Shape.StrokeMiterLimitProperty) does not match the default value");
            retval = widget.GetValue(Shape.StrokeThicknessProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StrokeThicknessProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Shape.StrokeThicknessProperty) is not of the correct type");
            Assert.AreEqual((double) 1, retval, "GetValue(Shape.StrokeThicknessProperty) does not match the default value");
            retval = widget.GetValue(Shape.StrokeStartLineCapProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StrokeStartLineCapProperty) should not have returned null");
            Assert.IsTrue(retval is PenLineCap, "GetValue(Shape.StrokeStartLineCapProperty) is not of the correct type");
            Assert.AreEqual(PenLineCap.Flat, retval, "GetValue(Shape.StrokeStartLineCapProperty) does not match the default value");
            retval = widget.GetValue(Shape.StrokeEndLineCapProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StrokeEndLineCapProperty) should not have returned null");
            Assert.IsTrue(retval is PenLineCap, "GetValue(Shape.StrokeEndLineCapProperty) is not of the correct type");
            Assert.AreEqual(PenLineCap.Flat, retval, "GetValue(Shape.StrokeEndLineCapProperty) does not match the default value");
            retval = widget.GetValue(Shape.StrokeLineJoinProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StrokeLineJoinProperty) should not have returned null");
            Assert.IsTrue(retval is PenLineJoin, "GetValue(Shape.StrokeLineJoinProperty) is not of the correct type");
            Assert.AreEqual(PenLineJoin.Miter, retval, "GetValue(Shape.StrokeLineJoinProperty) does not match the default value");
            retval = widget.GetValue(Shape.StrokeDashOffsetProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StrokeDashOffsetProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Shape.StrokeDashOffsetProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(Shape.StrokeDashOffsetProperty) does not match the default value");
            retval = widget.GetValue(Shape.StrokeDashCapProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StrokeDashCapProperty) should not have returned null");
            Assert.IsTrue(retval is PenLineCap, "GetValue(Shape.StrokeDashCapProperty) is not of the correct type");
            Assert.AreEqual(PenLineCap.Flat, retval, "GetValue(Shape.StrokeDashCapProperty) does not match the default value");
            retval = widget.GetValue(Shape.StrokeDashArrayProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StrokeDashArrayProperty) should not have returned null");
            Assert.IsTrue(retval is DoubleCollection, "GetValue(Shape.StrokeDashArrayProperty) is not of the correct type");
            retval = widget.GetValue(Shape.StretchProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StretchProperty) should not have returned null");
            Assert.IsTrue(retval is Stretch, "GetValue(Shape.StretchProperty) is not of the correct type");
            Assert.AreEqual(Stretch.None, retval, "GetValue(Shape.StretchProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_GetValue_FrameworkElement ()
        {
            Polyline widget = new Polyline ();
            object retval;

            retval = widget.GetValue(FrameworkElement.LanguageProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.LanguageProperty) should not have returned null");
            Assert.IsTrue(retval is XmlLanguage, "GetValue(FrameworkElement.LanguageProperty) is not of the correct type");
            Assert.AreEqual("en-us", ((XmlLanguage) retval).IetfLanguageTag, "GetValue(FrameworkElement.LanguageProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.ActualWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.ActualWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.ActualWidthProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.ActualWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.ActualHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.ActualHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.ActualHeightProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.ActualHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.WidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.WidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.WidthProperty) is not of the correct type");
            Assert.IsTrue(Double.IsNaN((double) retval), "GetValue(FrameworkElement.WidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.HeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.HeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.HeightProperty) is not of the correct type");
            Assert.IsTrue(Double.IsNaN((double) retval), "GetValue(FrameworkElement.HeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MinWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MinWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MinWidthProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.MinWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MaxWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MaxWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MaxWidthProperty) is not of the correct type");
            Assert.IsTrue(Double.IsPositiveInfinity((double) retval), "GetValue(FrameworkElement.MaxWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MinHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MinHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MinHeightProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.MinHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MaxHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MaxHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MaxHeightProperty) is not of the correct type");
            Assert.IsTrue(Double.IsPositiveInfinity((double) retval), "GetValue(FrameworkElement.MaxHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.HorizontalAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.HorizontalAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is HorizontalAlignment, "GetValue(FrameworkElement.HorizontalAlignmentProperty) is not of the correct type");
            Assert.AreEqual(HorizontalAlignment.Stretch, retval, "GetValue(FrameworkElement.HorizontalAlignmentProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.VerticalAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.VerticalAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is VerticalAlignment, "GetValue(FrameworkElement.VerticalAlignmentProperty) is not of the correct type");
            Assert.AreEqual(VerticalAlignment.Stretch, retval, "GetValue(FrameworkElement.VerticalAlignmentProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MarginProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MarginProperty) should not have returned null");
            Assert.IsTrue(retval is Thickness, "GetValue(FrameworkElement.MarginProperty) is not of the correct type");
            Assert.AreEqual("0,0,0,0", retval.ToString (), "GetValue(FrameworkElement.MarginProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.StyleProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.StyleProperty) should have returned null");
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.NameProperty) should not have returned null");
            Assert.IsTrue(retval is string, "GetValue(FrameworkElement.NameProperty) is not of the correct type");
            Assert.AreEqual("", retval, "GetValue(FrameworkElement.NameProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.TagProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.TagProperty) should have returned null");
            retval = widget.GetValue(FrameworkElement.DataContextProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.DataContextProperty) should have returned null");
        }

        [TestMethod]
        public void Test_GetValue_UIElement ()
        {
            Polyline widget = new Polyline ();
            object retval;

            retval = widget.GetValue(UIElement.OpacityProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.OpacityProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(UIElement.OpacityProperty) is not of the correct type");
            Assert.AreEqual((double) 1, retval, "GetValue(UIElement.OpacityProperty) does not match the default value");
            retval = widget.GetValue(UIElement.ClipProperty);
            Assert.IsNull(retval, "GetValue(UIElement.ClipProperty) should have returned null");
            retval = widget.GetValue(UIElement.RenderTransformProperty);
            Assert.IsNull(retval, "GetValue(UIElement.RenderTransformProperty) should have returned null");
            retval = widget.GetValue(UIElement.OpacityMaskProperty);
            Assert.IsNull(retval, "GetValue(UIElement.OpacityMaskProperty) should have returned null");
            retval = widget.GetValue(UIElement.RenderTransformOriginProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.RenderTransformOriginProperty) should not have returned null");
            Assert.IsTrue(retval is Point, "GetValue(UIElement.RenderTransformOriginProperty) is not of the correct type");
            Assert.AreEqual("0,0", retval.ToString (), "GetValue(UIElement.RenderTransformOriginProperty) does not match the default value");
            retval = widget.GetValue(UIElement.IsHitTestVisibleProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.IsHitTestVisibleProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(UIElement.IsHitTestVisibleProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(UIElement.IsHitTestVisibleProperty) does not match the default value");
            retval = widget.GetValue(UIElement.VisibilityProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.VisibilityProperty) should not have returned null");
            Assert.IsTrue(retval is Visibility, "GetValue(UIElement.VisibilityProperty) is not of the correct type");
            Assert.AreEqual(Visibility.Visible, retval, "GetValue(UIElement.VisibilityProperty) does not match the default value");
            retval = widget.GetValue(UIElement.UseLayoutRoundingProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.UseLayoutRoundingProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(UIElement.UseLayoutRoundingProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(UIElement.UseLayoutRoundingProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_Polyline ()
        {
            Polyline widget = new Polyline ();

            Assert.AreEqual(FillRule.EvenOdd, widget.FillRule, "FillRule does not match the default value");
            Assert.IsNotNull(widget.Points, "Points should not have returned null");
            Assert.IsTrue(widget.Points is PointCollection, "Points is not of the correct type");
            Assert.IsNull(widget.Fill, "Fill should have returned null");
            Assert.IsNull(widget.Stroke, "Stroke should have returned null");
            Assert.AreEqual((double) 10, widget.StrokeMiterLimit, "StrokeMiterLimit does not match the default value");
            Assert.AreEqual((double) 1, widget.StrokeThickness, "StrokeThickness does not match the default value");
            Assert.AreEqual(PenLineCap.Flat, widget.StrokeStartLineCap, "StrokeStartLineCap does not match the default value");
            Assert.AreEqual(PenLineCap.Flat, widget.StrokeEndLineCap, "StrokeEndLineCap does not match the default value");
            Assert.AreEqual(PenLineJoin.Miter, widget.StrokeLineJoin, "StrokeLineJoin does not match the default value");
            Assert.AreEqual((double) 0, widget.StrokeDashOffset, "StrokeDashOffset does not match the default value");
            Assert.AreEqual(PenLineCap.Flat, widget.StrokeDashCap, "StrokeDashCap does not match the default value");
            Assert.IsNotNull(widget.StrokeDashArray, "StrokeDashArray should not have returned null");
            Assert.IsTrue(widget.StrokeDashArray is DoubleCollection, "StrokeDashArray is not of the correct type");
            Assert.AreEqual(Stretch.None, widget.Stretch, "Stretch does not match the default value");
            Assert.IsNotNull(widget.GeometryTransform, "GeometryTransform should not have returned null");
            Assert.IsTrue(widget.GeometryTransform is MatrixTransform, "GeometryTransform is not of the correct type");
            Assert.IsNotNull(widget.Triggers, "Triggers should not have returned null");
            Assert.IsTrue(widget.Triggers is TriggerCollection, "Triggers is not of the correct type");
            Assert.IsNotNull(widget.Resources, "Resources should not have returned null");
            Assert.IsTrue(widget.Resources is ResourceDictionary, "Resources is not of the correct type");
            Assert.AreEqual((double) 0, widget.ActualWidth, "ActualWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.ActualHeight, "ActualHeight does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Width), "Width does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Height), "Height does not match the default value");
            Assert.AreEqual((double) 0, widget.MinWidth, "MinWidth does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxWidth), "MaxWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.MinHeight, "MinHeight does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxHeight), "MaxHeight does not match the default value");
            Assert.AreEqual(HorizontalAlignment.Stretch, widget.HorizontalAlignment, "HorizontalAlignment does not match the default value");
            Assert.AreEqual(VerticalAlignment.Stretch, widget.VerticalAlignment, "VerticalAlignment does not match the default value");
            Assert.AreEqual("0,0,0,0", widget.Margin.ToString (), "Margin does not match the default value");
            Assert.IsNull(widget.Style, "Style should have returned null");
            Assert.IsNull(widget.Parent, "Parent should have returned null");
            Assert.IsNotNull(widget.Name, "Name should not have returned null");
            Assert.AreEqual("", widget.Name, "Name does not match the default value");
            Assert.IsNull(widget.Tag, "Tag should have returned null");
            Assert.IsNull(widget.Cursor, "Cursor should have returned null");
            Assert.IsNotNull(widget.Language, "Language should not have returned null");
            Assert.AreEqual("en-us", widget.Language.IetfLanguageTag, "Language does not match the default value");
            Assert.IsNull(widget.DataContext, "DataContext should have returned null");
            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNull(widget.Clip, "Clip should have returned null");
            Assert.IsNull(widget.OpacityMask, "OpacityMask should have returned null");
            Assert.AreEqual("0,0", widget.RenderTransformOrigin.ToString (), "RenderTransformOrigin does not match the default value");
            Assert.AreEqual(true, widget.IsHitTestVisible, "IsHitTestVisible does not match the default value");
            Assert.AreEqual(Visibility.Visible, widget.Visibility, "Visibility does not match the default value");
            Assert.AreEqual("0,0", widget.RenderSize.ToString (), "RenderSize does not match the default value");
            Assert.AreEqual(true, widget.UseLayoutRounding, "UseLayoutRounding does not match the default value");
            Assert.AreEqual("0,0", widget.DesiredSize.ToString (), "DesiredSize does not match the default value");
            Assert.IsNotNull(widget.RenderTransform, "RenderTransform should not have returned null");
            Assert.IsTrue(widget.RenderTransform is MatrixTransform, "RenderTransform is not of the correct type");
        }

        [TestMethod]
        public void Test_PropertyGetter_FrameworkElement ()
        {
            Polyline widget = new Polyline ();

            Assert.IsNotNull(widget.Triggers, "Triggers should not have returned null");
            Assert.IsTrue(widget.Triggers is TriggerCollection, "Triggers is not of the correct type");
            Assert.IsNotNull(widget.Resources, "Resources should not have returned null");
            Assert.IsTrue(widget.Resources is ResourceDictionary, "Resources is not of the correct type");
            Assert.AreEqual((double) 0, widget.ActualWidth, "ActualWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.ActualHeight, "ActualHeight does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Width), "Width does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Height), "Height does not match the default value");
            Assert.AreEqual((double) 0, widget.MinWidth, "MinWidth does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxWidth), "MaxWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.MinHeight, "MinHeight does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxHeight), "MaxHeight does not match the default value");
            Assert.AreEqual(HorizontalAlignment.Stretch, widget.HorizontalAlignment, "HorizontalAlignment does not match the default value");
            Assert.AreEqual(VerticalAlignment.Stretch, widget.VerticalAlignment, "VerticalAlignment does not match the default value");
            Assert.AreEqual("0,0,0,0", widget.Margin.ToString (), "Margin does not match the default value");
            Assert.IsNull(widget.Style, "Style should have returned null");
            Assert.IsNull(widget.Parent, "Parent should have returned null");
            Assert.IsNotNull(widget.Name, "Name should not have returned null");
            Assert.AreEqual("", widget.Name, "Name does not match the default value");
            Assert.IsNull(widget.Tag, "Tag should have returned null");
            Assert.IsNull(widget.Cursor, "Cursor should have returned null");
            Assert.IsNotNull(widget.Language, "Language should not have returned null");
            Assert.AreEqual("en-us", widget.Language.IetfLanguageTag, "Language does not match the default value");
            Assert.IsNull(widget.DataContext, "DataContext should have returned null");
            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNull(widget.Clip, "Clip should have returned null");
            Assert.IsNull(widget.OpacityMask, "OpacityMask should have returned null");
            Assert.AreEqual("0,0", widget.RenderTransformOrigin.ToString (), "RenderTransformOrigin does not match the default value");
            Assert.AreEqual(true, widget.IsHitTestVisible, "IsHitTestVisible does not match the default value");
            Assert.AreEqual(Visibility.Visible, widget.Visibility, "Visibility does not match the default value");
            Assert.AreEqual("0,0", widget.RenderSize.ToString (), "RenderSize does not match the default value");
            Assert.AreEqual(true, widget.UseLayoutRounding, "UseLayoutRounding does not match the default value");
            Assert.AreEqual("0,0", widget.DesiredSize.ToString (), "DesiredSize does not match the default value");
            Assert.IsNotNull(widget.RenderTransform, "RenderTransform should not have returned null");
            Assert.IsTrue(widget.RenderTransform is MatrixTransform, "RenderTransform is not of the correct type");
        }

        [TestMethod]
	[MoonlightBug]
        public void Test_SetStringValue_FrameworkElement ()
        {
            Polyline widget = new Polyline ();
            object retval;

            widget.SetValue(FrameworkElement.NameProperty, "some text");
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.AreEqual("some text", retval, "GetValue(FrameworkElement.NameProperty) should have returned 'some text'");
            widget.SetValue(FrameworkElement.NameProperty, null);
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.AreEqual(String.Empty, retval, "GetValue(FrameworkElement.NameProperty) should have returned String.Empty");
            retval = widget.ReadLocalValue(FrameworkElement.NameProperty);
            Assert.AreEqual(String.Empty, retval, "ReadLocalValue(FrameworkElement.NameProperty) should have returned String.Empty");
        }

    }
}
namespace MoonTest.System.Windows.Shapes
{
    public partial class RectangleTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_Rectangle ()
        {
            Rectangle widget = new Rectangle ();
            object retval;

            retval = widget.ReadLocalValue(Rectangle.RadiusXProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Rectangle.RadiusXProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Rectangle.RadiusYProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Rectangle.RadiusYProperty) should not have a value by default");
        }

        [TestMethod]
	[MoonlightBug]
        public void Test_ReadLocalValue_Shape ()
        {
            Rectangle widget = new Rectangle ();
            object retval;

            retval = widget.ReadLocalValue(Shape.FillProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.FillProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeMiterLimitProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeMiterLimitProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeThicknessProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeThicknessProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeStartLineCapProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeStartLineCapProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeEndLineCapProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeEndLineCapProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeLineJoinProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeLineJoinProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeDashOffsetProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeDashOffsetProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeDashCapProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeDashCapProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StrokeDashArrayProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StrokeDashArrayProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Shape.StretchProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Shape.StretchProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_FrameworkElement ()
        {
            Rectangle widget = new Rectangle ();
            object retval;

            retval = widget.ReadLocalValue(FrameworkElement.LanguageProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.LanguageProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.ActualWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.ActualWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.ActualHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.ActualHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.WidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.WidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.HeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.HeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MinWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MinWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MaxWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MaxWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MinHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MinHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MaxHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MaxHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.HorizontalAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.HorizontalAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.VerticalAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.VerticalAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MarginProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MarginProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.StyleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.StyleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.NameProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.NameProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.TagProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.TagProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.DataContextProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.DataContextProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_UIElement ()
        {
            Rectangle widget = new Rectangle ();
            object retval;

            retval = widget.ReadLocalValue(UIElement.OpacityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.OpacityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.ClipProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.ClipProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.RenderTransformProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.RenderTransformProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.OpacityMaskProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.OpacityMaskProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.RenderTransformOriginProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.RenderTransformOriginProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.IsHitTestVisibleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.IsHitTestVisibleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.VisibilityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.VisibilityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.UseLayoutRoundingProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.UseLayoutRoundingProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_Rectangle ()
        {
            Rectangle widget = new Rectangle ();
            object retval;

            retval = widget.GetValue(Rectangle.RadiusXProperty);
            Assert.IsNotNull(retval, "GetValue(Rectangle.RadiusXProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Rectangle.RadiusXProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(Rectangle.RadiusXProperty) does not match the default value");
            retval = widget.GetValue(Rectangle.RadiusYProperty);
            Assert.IsNotNull(retval, "GetValue(Rectangle.RadiusYProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Rectangle.RadiusYProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(Rectangle.RadiusYProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_GetValue_Shape ()
        {
            Rectangle widget = new Rectangle ();
            object retval;

            retval = widget.GetValue(Shape.FillProperty);
            Assert.IsNull(retval, "GetValue(Shape.FillProperty) should have returned null");
            retval = widget.GetValue(Shape.StrokeProperty);
            Assert.IsNull(retval, "GetValue(Shape.StrokeProperty) should have returned null");
            retval = widget.GetValue(Shape.StrokeMiterLimitProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StrokeMiterLimitProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Shape.StrokeMiterLimitProperty) is not of the correct type");
            Assert.AreEqual((double) 10, retval, "GetValue(Shape.StrokeMiterLimitProperty) does not match the default value");
            retval = widget.GetValue(Shape.StrokeThicknessProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StrokeThicknessProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Shape.StrokeThicknessProperty) is not of the correct type");
            Assert.AreEqual((double) 1, retval, "GetValue(Shape.StrokeThicknessProperty) does not match the default value");
            retval = widget.GetValue(Shape.StrokeStartLineCapProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StrokeStartLineCapProperty) should not have returned null");
            Assert.IsTrue(retval is PenLineCap, "GetValue(Shape.StrokeStartLineCapProperty) is not of the correct type");
            Assert.AreEqual(PenLineCap.Flat, retval, "GetValue(Shape.StrokeStartLineCapProperty) does not match the default value");
            retval = widget.GetValue(Shape.StrokeEndLineCapProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StrokeEndLineCapProperty) should not have returned null");
            Assert.IsTrue(retval is PenLineCap, "GetValue(Shape.StrokeEndLineCapProperty) is not of the correct type");
            Assert.AreEqual(PenLineCap.Flat, retval, "GetValue(Shape.StrokeEndLineCapProperty) does not match the default value");
            retval = widget.GetValue(Shape.StrokeLineJoinProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StrokeLineJoinProperty) should not have returned null");
            Assert.IsTrue(retval is PenLineJoin, "GetValue(Shape.StrokeLineJoinProperty) is not of the correct type");
            Assert.AreEqual(PenLineJoin.Miter, retval, "GetValue(Shape.StrokeLineJoinProperty) does not match the default value");
            retval = widget.GetValue(Shape.StrokeDashOffsetProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StrokeDashOffsetProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Shape.StrokeDashOffsetProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(Shape.StrokeDashOffsetProperty) does not match the default value");
            retval = widget.GetValue(Shape.StrokeDashCapProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StrokeDashCapProperty) should not have returned null");
            Assert.IsTrue(retval is PenLineCap, "GetValue(Shape.StrokeDashCapProperty) is not of the correct type");
            Assert.AreEqual(PenLineCap.Flat, retval, "GetValue(Shape.StrokeDashCapProperty) does not match the default value");
            retval = widget.GetValue(Shape.StrokeDashArrayProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StrokeDashArrayProperty) should not have returned null");
            Assert.IsTrue(retval is DoubleCollection, "GetValue(Shape.StrokeDashArrayProperty) is not of the correct type");
            retval = widget.GetValue(Shape.StretchProperty);
            Assert.IsNotNull(retval, "GetValue(Shape.StretchProperty) should not have returned null");
            Assert.IsTrue(retval is Stretch, "GetValue(Shape.StretchProperty) is not of the correct type");
            Assert.AreEqual(Stretch.Fill, retval, "GetValue(Shape.StretchProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_GetValue_FrameworkElement ()
        {
            Rectangle widget = new Rectangle ();
            object retval;

            retval = widget.GetValue(FrameworkElement.LanguageProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.LanguageProperty) should not have returned null");
            Assert.IsTrue(retval is XmlLanguage, "GetValue(FrameworkElement.LanguageProperty) is not of the correct type");
            Assert.AreEqual("en-us", ((XmlLanguage) retval).IetfLanguageTag, "GetValue(FrameworkElement.LanguageProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.ActualWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.ActualWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.ActualWidthProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.ActualWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.ActualHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.ActualHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.ActualHeightProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.ActualHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.WidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.WidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.WidthProperty) is not of the correct type");
            Assert.IsTrue(Double.IsNaN((double) retval), "GetValue(FrameworkElement.WidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.HeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.HeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.HeightProperty) is not of the correct type");
            Assert.IsTrue(Double.IsNaN((double) retval), "GetValue(FrameworkElement.HeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MinWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MinWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MinWidthProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.MinWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MaxWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MaxWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MaxWidthProperty) is not of the correct type");
            Assert.IsTrue(Double.IsPositiveInfinity((double) retval), "GetValue(FrameworkElement.MaxWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MinHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MinHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MinHeightProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.MinHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MaxHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MaxHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MaxHeightProperty) is not of the correct type");
            Assert.IsTrue(Double.IsPositiveInfinity((double) retval), "GetValue(FrameworkElement.MaxHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.HorizontalAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.HorizontalAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is HorizontalAlignment, "GetValue(FrameworkElement.HorizontalAlignmentProperty) is not of the correct type");
            Assert.AreEqual(HorizontalAlignment.Stretch, retval, "GetValue(FrameworkElement.HorizontalAlignmentProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.VerticalAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.VerticalAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is VerticalAlignment, "GetValue(FrameworkElement.VerticalAlignmentProperty) is not of the correct type");
            Assert.AreEqual(VerticalAlignment.Stretch, retval, "GetValue(FrameworkElement.VerticalAlignmentProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MarginProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MarginProperty) should not have returned null");
            Assert.IsTrue(retval is Thickness, "GetValue(FrameworkElement.MarginProperty) is not of the correct type");
            Assert.AreEqual("0,0,0,0", retval.ToString (), "GetValue(FrameworkElement.MarginProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.StyleProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.StyleProperty) should have returned null");
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.NameProperty) should not have returned null");
            Assert.IsTrue(retval is string, "GetValue(FrameworkElement.NameProperty) is not of the correct type");
            Assert.AreEqual("", retval, "GetValue(FrameworkElement.NameProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.TagProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.TagProperty) should have returned null");
            retval = widget.GetValue(FrameworkElement.DataContextProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.DataContextProperty) should have returned null");
        }

        [TestMethod]
        public void Test_GetValue_UIElement ()
        {
            Rectangle widget = new Rectangle ();
            object retval;

            retval = widget.GetValue(UIElement.OpacityProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.OpacityProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(UIElement.OpacityProperty) is not of the correct type");
            Assert.AreEqual((double) 1, retval, "GetValue(UIElement.OpacityProperty) does not match the default value");
            retval = widget.GetValue(UIElement.ClipProperty);
            Assert.IsNull(retval, "GetValue(UIElement.ClipProperty) should have returned null");
            retval = widget.GetValue(UIElement.RenderTransformProperty);
            Assert.IsNull(retval, "GetValue(UIElement.RenderTransformProperty) should have returned null");
            retval = widget.GetValue(UIElement.OpacityMaskProperty);
            Assert.IsNull(retval, "GetValue(UIElement.OpacityMaskProperty) should have returned null");
            retval = widget.GetValue(UIElement.RenderTransformOriginProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.RenderTransformOriginProperty) should not have returned null");
            Assert.IsTrue(retval is Point, "GetValue(UIElement.RenderTransformOriginProperty) is not of the correct type");
            Assert.AreEqual("0,0", retval.ToString (), "GetValue(UIElement.RenderTransformOriginProperty) does not match the default value");
            retval = widget.GetValue(UIElement.IsHitTestVisibleProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.IsHitTestVisibleProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(UIElement.IsHitTestVisibleProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(UIElement.IsHitTestVisibleProperty) does not match the default value");
            retval = widget.GetValue(UIElement.VisibilityProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.VisibilityProperty) should not have returned null");
            Assert.IsTrue(retval is Visibility, "GetValue(UIElement.VisibilityProperty) is not of the correct type");
            Assert.AreEqual(Visibility.Visible, retval, "GetValue(UIElement.VisibilityProperty) does not match the default value");
            retval = widget.GetValue(UIElement.UseLayoutRoundingProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.UseLayoutRoundingProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(UIElement.UseLayoutRoundingProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(UIElement.UseLayoutRoundingProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_Rectangle ()
        {
            Rectangle widget = new Rectangle ();

            Assert.AreEqual((double) 0, widget.RadiusX, "RadiusX does not match the default value");
            Assert.AreEqual((double) 0, widget.RadiusY, "RadiusY does not match the default value");
            Assert.IsNull(widget.Fill, "Fill should have returned null");
            Assert.IsNull(widget.Stroke, "Stroke should have returned null");
            Assert.AreEqual((double) 10, widget.StrokeMiterLimit, "StrokeMiterLimit does not match the default value");
            Assert.AreEqual((double) 1, widget.StrokeThickness, "StrokeThickness does not match the default value");
            Assert.AreEqual(PenLineCap.Flat, widget.StrokeStartLineCap, "StrokeStartLineCap does not match the default value");
            Assert.AreEqual(PenLineCap.Flat, widget.StrokeEndLineCap, "StrokeEndLineCap does not match the default value");
            Assert.AreEqual(PenLineJoin.Miter, widget.StrokeLineJoin, "StrokeLineJoin does not match the default value");
            Assert.AreEqual((double) 0, widget.StrokeDashOffset, "StrokeDashOffset does not match the default value");
            Assert.AreEqual(PenLineCap.Flat, widget.StrokeDashCap, "StrokeDashCap does not match the default value");
            Assert.IsNotNull(widget.StrokeDashArray, "StrokeDashArray should not have returned null");
            Assert.IsTrue(widget.StrokeDashArray is DoubleCollection, "StrokeDashArray is not of the correct type");
            Assert.AreEqual(Stretch.Fill, widget.Stretch, "Stretch does not match the default value");
            Assert.IsNotNull(widget.GeometryTransform, "GeometryTransform should not have returned null");
            Assert.IsTrue(widget.GeometryTransform is MatrixTransform, "GeometryTransform is not of the correct type");
            Assert.IsNotNull(widget.Triggers, "Triggers should not have returned null");
            Assert.IsTrue(widget.Triggers is TriggerCollection, "Triggers is not of the correct type");
            Assert.IsNotNull(widget.Resources, "Resources should not have returned null");
            Assert.IsTrue(widget.Resources is ResourceDictionary, "Resources is not of the correct type");
            Assert.AreEqual((double) 0, widget.ActualWidth, "ActualWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.ActualHeight, "ActualHeight does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Width), "Width does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Height), "Height does not match the default value");
            Assert.AreEqual((double) 0, widget.MinWidth, "MinWidth does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxWidth), "MaxWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.MinHeight, "MinHeight does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxHeight), "MaxHeight does not match the default value");
            Assert.AreEqual(HorizontalAlignment.Stretch, widget.HorizontalAlignment, "HorizontalAlignment does not match the default value");
            Assert.AreEqual(VerticalAlignment.Stretch, widget.VerticalAlignment, "VerticalAlignment does not match the default value");
            Assert.AreEqual("0,0,0,0", widget.Margin.ToString (), "Margin does not match the default value");
            Assert.IsNull(widget.Style, "Style should have returned null");
            Assert.IsNull(widget.Parent, "Parent should have returned null");
            Assert.IsNotNull(widget.Name, "Name should not have returned null");
            Assert.AreEqual("", widget.Name, "Name does not match the default value");
            Assert.IsNull(widget.Tag, "Tag should have returned null");
            Assert.IsNull(widget.Cursor, "Cursor should have returned null");
            Assert.IsNotNull(widget.Language, "Language should not have returned null");
            Assert.AreEqual("en-us", widget.Language.IetfLanguageTag, "Language does not match the default value");
            Assert.IsNull(widget.DataContext, "DataContext should have returned null");
            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNull(widget.Clip, "Clip should have returned null");
            Assert.IsNull(widget.OpacityMask, "OpacityMask should have returned null");
            Assert.AreEqual("0,0", widget.RenderTransformOrigin.ToString (), "RenderTransformOrigin does not match the default value");
            Assert.AreEqual(true, widget.IsHitTestVisible, "IsHitTestVisible does not match the default value");
            Assert.AreEqual(Visibility.Visible, widget.Visibility, "Visibility does not match the default value");
            Assert.AreEqual("0,0", widget.RenderSize.ToString (), "RenderSize does not match the default value");
            Assert.AreEqual(true, widget.UseLayoutRounding, "UseLayoutRounding does not match the default value");
            Assert.AreEqual("0,0", widget.DesiredSize.ToString (), "DesiredSize does not match the default value");
            Assert.IsNotNull(widget.RenderTransform, "RenderTransform should not have returned null");
            Assert.IsTrue(widget.RenderTransform is MatrixTransform, "RenderTransform is not of the correct type");
        }

        [TestMethod]
        public void Test_PropertyGetter_FrameworkElement ()
        {
            Rectangle widget = new Rectangle ();

            Assert.IsNotNull(widget.Triggers, "Triggers should not have returned null");
            Assert.IsTrue(widget.Triggers is TriggerCollection, "Triggers is not of the correct type");
            Assert.IsNotNull(widget.Resources, "Resources should not have returned null");
            Assert.IsTrue(widget.Resources is ResourceDictionary, "Resources is not of the correct type");
            Assert.AreEqual((double) 0, widget.ActualWidth, "ActualWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.ActualHeight, "ActualHeight does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Width), "Width does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Height), "Height does not match the default value");
            Assert.AreEqual((double) 0, widget.MinWidth, "MinWidth does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxWidth), "MaxWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.MinHeight, "MinHeight does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxHeight), "MaxHeight does not match the default value");
            Assert.AreEqual(HorizontalAlignment.Stretch, widget.HorizontalAlignment, "HorizontalAlignment does not match the default value");
            Assert.AreEqual(VerticalAlignment.Stretch, widget.VerticalAlignment, "VerticalAlignment does not match the default value");
            Assert.AreEqual("0,0,0,0", widget.Margin.ToString (), "Margin does not match the default value");
            Assert.IsNull(widget.Style, "Style should have returned null");
            Assert.IsNull(widget.Parent, "Parent should have returned null");
            Assert.IsNotNull(widget.Name, "Name should not have returned null");
            Assert.AreEqual("", widget.Name, "Name does not match the default value");
            Assert.IsNull(widget.Tag, "Tag should have returned null");
            Assert.IsNull(widget.Cursor, "Cursor should have returned null");
            Assert.IsNotNull(widget.Language, "Language should not have returned null");
            Assert.AreEqual("en-us", widget.Language.IetfLanguageTag, "Language does not match the default value");
            Assert.IsNull(widget.DataContext, "DataContext should have returned null");
            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNull(widget.Clip, "Clip should have returned null");
            Assert.IsNull(widget.OpacityMask, "OpacityMask should have returned null");
            Assert.AreEqual("0,0", widget.RenderTransformOrigin.ToString (), "RenderTransformOrigin does not match the default value");
            Assert.AreEqual(true, widget.IsHitTestVisible, "IsHitTestVisible does not match the default value");
            Assert.AreEqual(Visibility.Visible, widget.Visibility, "Visibility does not match the default value");
            Assert.AreEqual("0,0", widget.RenderSize.ToString (), "RenderSize does not match the default value");
            Assert.AreEqual(true, widget.UseLayoutRounding, "UseLayoutRounding does not match the default value");
            Assert.AreEqual("0,0", widget.DesiredSize.ToString (), "DesiredSize does not match the default value");
            Assert.IsNotNull(widget.RenderTransform, "RenderTransform should not have returned null");
            Assert.IsTrue(widget.RenderTransform is MatrixTransform, "RenderTransform is not of the correct type");
        }

        [TestMethod]
	[MoonlightBug]
        public void Test_SetStringValue_FrameworkElement ()
        {
            Rectangle widget = new Rectangle ();
            object retval;

            widget.SetValue(FrameworkElement.NameProperty, "some text");
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.AreEqual("some text", retval, "GetValue(FrameworkElement.NameProperty) should have returned 'some text'");
            widget.SetValue(FrameworkElement.NameProperty, null);
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.AreEqual(String.Empty, retval, "GetValue(FrameworkElement.NameProperty) should have returned String.Empty");
            retval = widget.ReadLocalValue(FrameworkElement.NameProperty);
            Assert.AreEqual(String.Empty, retval, "ReadLocalValue(FrameworkElement.NameProperty) should have returned String.Empty");
        }

    }
}
namespace MoonTest.System.Windows.Documents
{
    public partial class GlyphsTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_Glyphs ()
        {
            Glyphs widget = new Glyphs ();
            object retval;

            retval = widget.ReadLocalValue(Glyphs.UnicodeStringProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Glyphs.UnicodeStringProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Glyphs.IndicesProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Glyphs.IndicesProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Glyphs.FontUriProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Glyphs.FontUriProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Glyphs.StyleSimulationsProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Glyphs.StyleSimulationsProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Glyphs.FontRenderingEmSizeProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Glyphs.FontRenderingEmSizeProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Glyphs.OriginXProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Glyphs.OriginXProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Glyphs.OriginYProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Glyphs.OriginYProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Glyphs.FillProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Glyphs.FillProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_FrameworkElement ()
        {
            Glyphs widget = new Glyphs ();
            object retval;

            retval = widget.ReadLocalValue(FrameworkElement.LanguageProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.LanguageProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.ActualWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.ActualWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.ActualHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.ActualHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.WidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.WidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.HeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.HeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MinWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MinWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MaxWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MaxWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MinHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MinHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MaxHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MaxHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.HorizontalAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.HorizontalAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.VerticalAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.VerticalAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MarginProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MarginProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.StyleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.StyleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.NameProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.NameProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.TagProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.TagProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.DataContextProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.DataContextProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_UIElement ()
        {
            Glyphs widget = new Glyphs ();
            object retval;

            retval = widget.ReadLocalValue(UIElement.OpacityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.OpacityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.ClipProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.ClipProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.RenderTransformProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.RenderTransformProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.OpacityMaskProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.OpacityMaskProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.RenderTransformOriginProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.RenderTransformOriginProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.IsHitTestVisibleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.IsHitTestVisibleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.VisibilityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.VisibilityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.UseLayoutRoundingProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.UseLayoutRoundingProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_Glyphs ()
        {
            Glyphs widget = new Glyphs ();
            object retval;

            retval = widget.GetValue(Glyphs.UnicodeStringProperty);
            Assert.IsNotNull(retval, "GetValue(Glyphs.UnicodeStringProperty) should not have returned null");
            Assert.IsTrue(retval is string, "GetValue(Glyphs.UnicodeStringProperty) is not of the correct type");
            Assert.AreEqual("", retval, "GetValue(Glyphs.UnicodeStringProperty) does not match the default value");
            retval = widget.GetValue(Glyphs.IndicesProperty);
            Assert.IsNotNull(retval, "GetValue(Glyphs.IndicesProperty) should not have returned null");
            Assert.IsTrue(retval is string, "GetValue(Glyphs.IndicesProperty) is not of the correct type");
            Assert.AreEqual("", retval, "GetValue(Glyphs.IndicesProperty) does not match the default value");
            retval = widget.GetValue(Glyphs.FontUriProperty);
            Assert.IsNotNull(retval, "GetValue(Glyphs.FontUriProperty) should not have returned null");
            Assert.IsTrue(retval is Uri, "GetValue(Glyphs.FontUriProperty) is not of the correct type");
            Assert.AreEqual("", retval.ToString (), "GetValue(Glyphs.FontUriProperty) does not match the default value");
            retval = widget.GetValue(Glyphs.StyleSimulationsProperty);
            Assert.IsNotNull(retval, "GetValue(Glyphs.StyleSimulationsProperty) should not have returned null");
            Assert.IsTrue(retval is StyleSimulations, "GetValue(Glyphs.StyleSimulationsProperty) is not of the correct type");
            Assert.AreEqual(StyleSimulations.None, retval, "GetValue(Glyphs.StyleSimulationsProperty) does not match the default value");
            retval = widget.GetValue(Glyphs.FontRenderingEmSizeProperty);
            Assert.IsNotNull(retval, "GetValue(Glyphs.FontRenderingEmSizeProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Glyphs.FontRenderingEmSizeProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(Glyphs.FontRenderingEmSizeProperty) does not match the default value");
            retval = widget.GetValue(Glyphs.OriginXProperty);
            Assert.IsNotNull(retval, "GetValue(Glyphs.OriginXProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Glyphs.OriginXProperty) is not of the correct type");
            Assert.AreEqual((float) -3.40282346638529E+38, (double) retval, "GetValue(Glyphs.OriginXProperty) does not match the default value");
            retval = widget.GetValue(Glyphs.OriginYProperty);
            Assert.IsNotNull(retval, "GetValue(Glyphs.OriginYProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Glyphs.OriginYProperty) is not of the correct type");
            Assert.AreEqual((float) -3.40282346638529E+38, (double) retval, "GetValue(Glyphs.OriginYProperty) does not match the default value");
            retval = widget.GetValue(Glyphs.FillProperty);
            Assert.IsNull(retval, "GetValue(Glyphs.FillProperty) should have returned null");
        }

        [TestMethod]
        public void Test_GetValue_FrameworkElement ()
        {
            Glyphs widget = new Glyphs ();
            object retval;

            retval = widget.GetValue(FrameworkElement.LanguageProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.LanguageProperty) should not have returned null");
            Assert.IsTrue(retval is XmlLanguage, "GetValue(FrameworkElement.LanguageProperty) is not of the correct type");
            Assert.AreEqual("en-us", ((XmlLanguage) retval).IetfLanguageTag, "GetValue(FrameworkElement.LanguageProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.ActualWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.ActualWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.ActualWidthProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.ActualWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.ActualHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.ActualHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.ActualHeightProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.ActualHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.WidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.WidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.WidthProperty) is not of the correct type");
            Assert.IsTrue(Double.IsNaN((double) retval), "GetValue(FrameworkElement.WidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.HeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.HeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.HeightProperty) is not of the correct type");
            Assert.IsTrue(Double.IsNaN((double) retval), "GetValue(FrameworkElement.HeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MinWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MinWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MinWidthProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.MinWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MaxWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MaxWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MaxWidthProperty) is not of the correct type");
            Assert.IsTrue(Double.IsPositiveInfinity((double) retval), "GetValue(FrameworkElement.MaxWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MinHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MinHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MinHeightProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.MinHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MaxHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MaxHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MaxHeightProperty) is not of the correct type");
            Assert.IsTrue(Double.IsPositiveInfinity((double) retval), "GetValue(FrameworkElement.MaxHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.HorizontalAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.HorizontalAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is HorizontalAlignment, "GetValue(FrameworkElement.HorizontalAlignmentProperty) is not of the correct type");
            Assert.AreEqual(HorizontalAlignment.Stretch, retval, "GetValue(FrameworkElement.HorizontalAlignmentProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.VerticalAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.VerticalAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is VerticalAlignment, "GetValue(FrameworkElement.VerticalAlignmentProperty) is not of the correct type");
            Assert.AreEqual(VerticalAlignment.Stretch, retval, "GetValue(FrameworkElement.VerticalAlignmentProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MarginProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MarginProperty) should not have returned null");
            Assert.IsTrue(retval is Thickness, "GetValue(FrameworkElement.MarginProperty) is not of the correct type");
            Assert.AreEqual("0,0,0,0", retval.ToString (), "GetValue(FrameworkElement.MarginProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.StyleProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.StyleProperty) should have returned null");
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.NameProperty) should not have returned null");
            Assert.IsTrue(retval is string, "GetValue(FrameworkElement.NameProperty) is not of the correct type");
            Assert.AreEqual("", retval, "GetValue(FrameworkElement.NameProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.TagProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.TagProperty) should have returned null");
            retval = widget.GetValue(FrameworkElement.DataContextProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.DataContextProperty) should have returned null");
        }

        [TestMethod]
        public void Test_GetValue_UIElement ()
        {
            Glyphs widget = new Glyphs ();
            object retval;

            retval = widget.GetValue(UIElement.OpacityProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.OpacityProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(UIElement.OpacityProperty) is not of the correct type");
            Assert.AreEqual((double) 1, retval, "GetValue(UIElement.OpacityProperty) does not match the default value");
            retval = widget.GetValue(UIElement.ClipProperty);
            Assert.IsNull(retval, "GetValue(UIElement.ClipProperty) should have returned null");
            retval = widget.GetValue(UIElement.RenderTransformProperty);
            Assert.IsNull(retval, "GetValue(UIElement.RenderTransformProperty) should have returned null");
            retval = widget.GetValue(UIElement.OpacityMaskProperty);
            Assert.IsNull(retval, "GetValue(UIElement.OpacityMaskProperty) should have returned null");
            retval = widget.GetValue(UIElement.RenderTransformOriginProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.RenderTransformOriginProperty) should not have returned null");
            Assert.IsTrue(retval is Point, "GetValue(UIElement.RenderTransformOriginProperty) is not of the correct type");
            Assert.AreEqual("0,0", retval.ToString (), "GetValue(UIElement.RenderTransformOriginProperty) does not match the default value");
            retval = widget.GetValue(UIElement.IsHitTestVisibleProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.IsHitTestVisibleProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(UIElement.IsHitTestVisibleProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(UIElement.IsHitTestVisibleProperty) does not match the default value");
            retval = widget.GetValue(UIElement.VisibilityProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.VisibilityProperty) should not have returned null");
            Assert.IsTrue(retval is Visibility, "GetValue(UIElement.VisibilityProperty) is not of the correct type");
            Assert.AreEqual(Visibility.Visible, retval, "GetValue(UIElement.VisibilityProperty) does not match the default value");
            retval = widget.GetValue(UIElement.UseLayoutRoundingProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.UseLayoutRoundingProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(UIElement.UseLayoutRoundingProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(UIElement.UseLayoutRoundingProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_Glyphs ()
        {
            Glyphs widget = new Glyphs ();

            Assert.IsNotNull(widget.UnicodeString, "UnicodeString should not have returned null");
            Assert.AreEqual("", widget.UnicodeString, "UnicodeString does not match the default value");
            Assert.IsNotNull(widget.Indices, "Indices should not have returned null");
            Assert.AreEqual("", widget.Indices, "Indices does not match the default value");
            Assert.IsNotNull(widget.FontUri, "FontUri should not have returned null");
            Assert.AreEqual("", widget.FontUri.ToString (), "FontUri does not match the default value");
            Assert.AreEqual(StyleSimulations.None, widget.StyleSimulations, "StyleSimulations does not match the default value");
            Assert.AreEqual((double) 0, widget.FontRenderingEmSize, "FontRenderingEmSize does not match the default value");
            Assert.AreEqual((float) -3.40282346638529E+38, (float) widget.OriginX, "OriginX does not match the default value");
            Assert.AreEqual((float) -3.40282346638529E+38, (float) widget.OriginY, "OriginY does not match the default value");
            Assert.IsNull(widget.Fill, "Fill should have returned null");
            Assert.IsNotNull(widget.Triggers, "Triggers should not have returned null");
            Assert.IsTrue(widget.Triggers is TriggerCollection, "Triggers is not of the correct type");
            Assert.IsNotNull(widget.Resources, "Resources should not have returned null");
            Assert.IsTrue(widget.Resources is ResourceDictionary, "Resources is not of the correct type");
            Assert.AreEqual((double) 0, widget.ActualWidth, "ActualWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.ActualHeight, "ActualHeight does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Width), "Width does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Height), "Height does not match the default value");
            Assert.AreEqual((double) 0, widget.MinWidth, "MinWidth does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxWidth), "MaxWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.MinHeight, "MinHeight does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxHeight), "MaxHeight does not match the default value");
            Assert.AreEqual(HorizontalAlignment.Stretch, widget.HorizontalAlignment, "HorizontalAlignment does not match the default value");
            Assert.AreEqual(VerticalAlignment.Stretch, widget.VerticalAlignment, "VerticalAlignment does not match the default value");
            Assert.AreEqual("0,0,0,0", widget.Margin.ToString (), "Margin does not match the default value");
            Assert.IsNull(widget.Style, "Style should have returned null");
            Assert.IsNull(widget.Parent, "Parent should have returned null");
            Assert.IsNotNull(widget.Name, "Name should not have returned null");
            Assert.AreEqual("", widget.Name, "Name does not match the default value");
            Assert.IsNull(widget.Tag, "Tag should have returned null");
            Assert.IsNull(widget.Cursor, "Cursor should have returned null");
            Assert.IsNotNull(widget.Language, "Language should not have returned null");
            Assert.AreEqual("en-us", widget.Language.IetfLanguageTag, "Language does not match the default value");
            Assert.IsNull(widget.DataContext, "DataContext should have returned null");
            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNull(widget.Clip, "Clip should have returned null");
            Assert.IsNull(widget.OpacityMask, "OpacityMask should have returned null");
            Assert.AreEqual("0,0", widget.RenderTransformOrigin.ToString (), "RenderTransformOrigin does not match the default value");
            Assert.AreEqual(true, widget.IsHitTestVisible, "IsHitTestVisible does not match the default value");
            Assert.AreEqual(Visibility.Visible, widget.Visibility, "Visibility does not match the default value");
            Assert.AreEqual("0,0", widget.RenderSize.ToString (), "RenderSize does not match the default value");
            Assert.AreEqual(true, widget.UseLayoutRounding, "UseLayoutRounding does not match the default value");
            Assert.AreEqual("0,0", widget.DesiredSize.ToString (), "DesiredSize does not match the default value");
            Assert.IsNotNull(widget.RenderTransform, "RenderTransform should not have returned null");
            Assert.IsTrue(widget.RenderTransform is MatrixTransform, "RenderTransform is not of the correct type");
        }

        [TestMethod]
        public void Test_PropertyGetter_UIElement ()
        {
            Glyphs widget = new Glyphs ();

            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNull(widget.Clip, "Clip should have returned null");
            Assert.IsNull(widget.OpacityMask, "OpacityMask should have returned null");
            Assert.AreEqual("0,0", widget.RenderTransformOrigin.ToString (), "RenderTransformOrigin does not match the default value");
            Assert.AreEqual(true, widget.IsHitTestVisible, "IsHitTestVisible does not match the default value");
            Assert.AreEqual(Visibility.Visible, widget.Visibility, "Visibility does not match the default value");
            Assert.AreEqual("0,0", widget.RenderSize.ToString (), "RenderSize does not match the default value");
            Assert.AreEqual(true, widget.UseLayoutRounding, "UseLayoutRounding does not match the default value");
            Assert.AreEqual("0,0", widget.DesiredSize.ToString (), "DesiredSize does not match the default value");
            Assert.IsNotNull(widget.RenderTransform, "RenderTransform should not have returned null");
            Assert.IsTrue(widget.RenderTransform is MatrixTransform, "RenderTransform is not of the correct type");
        }

        [TestMethod]
	[MoonlightBug]
        public void Test_SetStringValue_Glyphs ()
        {
            Glyphs widget = new Glyphs ();
            object retval;

            widget.SetValue(Glyphs.UnicodeStringProperty, "some text");
            retval = widget.GetValue(Glyphs.UnicodeStringProperty);
            Assert.AreEqual("some text", retval, "GetValue(Glyphs.UnicodeStringProperty) should have returned 'some text'");
            widget.SetValue(Glyphs.UnicodeStringProperty, null);
            retval = widget.GetValue(Glyphs.UnicodeStringProperty);
            Assert.AreEqual(String.Empty, retval, "GetValue(Glyphs.UnicodeStringProperty) should have returned String.Empty");
            retval = widget.ReadLocalValue(Glyphs.UnicodeStringProperty);
            Assert.AreEqual(String.Empty, retval, "ReadLocalValue(Glyphs.UnicodeStringProperty) should have returned String.Empty");
            widget.SetValue(Glyphs.IndicesProperty, "some text");
            retval = widget.GetValue(Glyphs.IndicesProperty);
            Assert.AreEqual("some text", retval, "GetValue(Glyphs.IndicesProperty) should have returned 'some text'");
            widget.SetValue(Glyphs.IndicesProperty, null);
            retval = widget.GetValue(Glyphs.IndicesProperty);
            Assert.AreEqual(String.Empty, retval, "GetValue(Glyphs.IndicesProperty) should have returned String.Empty");
            retval = widget.ReadLocalValue(Glyphs.IndicesProperty);
            Assert.AreEqual(String.Empty, retval, "ReadLocalValue(Glyphs.IndicesProperty) should have returned String.Empty");
        }

        [TestMethod]
	[MoonlightBug]
        public void Test_SetStringValue_FrameworkElement ()
        {
            Glyphs widget = new Glyphs ();
            object retval;

            widget.SetValue(FrameworkElement.NameProperty, "some text");
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.AreEqual("some text", retval, "GetValue(FrameworkElement.NameProperty) should have returned 'some text'");
            widget.SetValue(FrameworkElement.NameProperty, null);
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.AreEqual(String.Empty, retval, "GetValue(FrameworkElement.NameProperty) should have returned String.Empty");
            retval = widget.ReadLocalValue(FrameworkElement.NameProperty);
            Assert.AreEqual(String.Empty, retval, "ReadLocalValue(FrameworkElement.NameProperty) should have returned String.Empty");
        }

    }
}
namespace MoonTest.System.Windows.Documents
{
    public partial class RunTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_Inline ()
        {
            Run widget = new Run ();
            object retval;

            retval = widget.ReadLocalValue(Inline.FontSizeProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Inline.FontSizeProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Inline.FontFamilyProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Inline.FontFamilyProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Inline.FontWeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Inline.FontWeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Inline.FontStyleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Inline.FontStyleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Inline.FontStretchProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Inline.FontStretchProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Inline.ForegroundProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Inline.ForegroundProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Inline.TextDecorationsProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Inline.TextDecorationsProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Inline.LanguageProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Inline.LanguageProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_Inline ()
        {
            Run widget = new Run ();
            object retval;

            retval = widget.GetValue(Inline.FontSizeProperty);
            Assert.IsNotNull(retval, "GetValue(Inline.FontSizeProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Inline.FontSizeProperty) is not of the correct type");
            Assert.AreEqual((double) 11, retval, "GetValue(Inline.FontSizeProperty) does not match the default value");
            retval = widget.GetValue(Inline.FontFamilyProperty);
            Assert.IsNotNull(retval, "GetValue(Inline.FontFamilyProperty) should not have returned null");
            Assert.IsTrue(retval is FontFamily, "GetValue(Inline.FontFamilyProperty) is not of the correct type");
            Assert.AreEqual("Portable User Interface", retval.ToString (), "GetValue(Inline.FontFamilyProperty) does not match the default value");
            retval = widget.GetValue(Inline.FontWeightProperty);
            Assert.IsNotNull(retval, "GetValue(Inline.FontWeightProperty) should not have returned null");
            Assert.IsTrue(retval is FontWeight, "GetValue(Inline.FontWeightProperty) is not of the correct type");
            Assert.AreEqual("Normal", retval.ToString (), "GetValue(Inline.FontWeightProperty) does not match the default value");
            retval = widget.GetValue(Inline.FontStyleProperty);
            Assert.IsNotNull(retval, "GetValue(Inline.FontStyleProperty) should not have returned null");
            Assert.IsTrue(retval is FontStyle, "GetValue(Inline.FontStyleProperty) is not of the correct type");
            Assert.AreEqual("Normal", retval.ToString (), "GetValue(Inline.FontStyleProperty) does not match the default value");
            retval = widget.GetValue(Inline.FontStretchProperty);
            Assert.IsNotNull(retval, "GetValue(Inline.FontStretchProperty) should not have returned null");
            Assert.IsTrue(retval is FontStretch, "GetValue(Inline.FontStretchProperty) is not of the correct type");
            Assert.AreEqual("Normal", retval.ToString (), "GetValue(Inline.FontStretchProperty) does not match the default value");
            retval = widget.GetValue(Inline.ForegroundProperty);
            Assert.IsNotNull(retval, "GetValue(Inline.ForegroundProperty) should not have returned null");
            Assert.IsTrue(retval is SolidColorBrush, "GetValue(Inline.ForegroundProperty) is not of the correct type");
            retval = widget.GetValue(Inline.TextDecorationsProperty);
            Assert.IsNull(retval, "GetValue(Inline.TextDecorationsProperty) should have returned null");
            retval = widget.GetValue(Inline.LanguageProperty);
            Assert.IsNotNull(retval, "GetValue(Inline.LanguageProperty) should not have returned null");
            Assert.IsTrue(retval is XmlLanguage, "GetValue(Inline.LanguageProperty) is not of the correct type");
            Assert.AreEqual("en-us", ((XmlLanguage) retval).IetfLanguageTag, "GetValue(Inline.LanguageProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_Run ()
        {
            Run widget = new Run ();

            Assert.IsNull(widget.Text, "Text should have returned null");
            Assert.AreEqual((double) 11, widget.FontSize, "FontSize does not match the default value");
            Assert.IsNotNull(widget.FontFamily, "FontFamily should not have returned null");
            Assert.AreEqual("Portable User Interface", widget.FontFamily.ToString (), "FontFamily does not match the default value");
            Assert.AreEqual("Normal", widget.FontWeight.ToString (), "FontWeight does not match the default value");
            Assert.AreEqual("Normal", widget.FontStyle.ToString (), "FontStyle does not match the default value");
            Assert.AreEqual("Normal", widget.FontStretch.ToString (), "FontStretch does not match the default value");
            Assert.IsNotNull(widget.Foreground, "Foreground should not have returned null");
            Assert.IsTrue(widget.Foreground is SolidColorBrush, "Foreground is not of the correct type");
            Assert.IsNull(widget.TextDecorations, "TextDecorations should have returned null");
            Assert.IsNotNull(widget.Name, "Name should not have returned null");
            Assert.AreEqual("", widget.Name, "Name does not match the default value");
            Assert.IsNotNull(widget.Language, "Language should not have returned null");
            Assert.AreEqual("en-us", widget.Language.IetfLanguageTag, "Language does not match the default value");
        }

    }
}
namespace MoonTest.System.Windows.Documents
{
    public partial class LineBreakTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_Inline ()
        {
            LineBreak widget = new LineBreak ();
            object retval;

            retval = widget.ReadLocalValue(Inline.FontSizeProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Inline.FontSizeProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Inline.FontFamilyProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Inline.FontFamilyProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Inline.FontWeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Inline.FontWeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Inline.FontStyleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Inline.FontStyleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Inline.FontStretchProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Inline.FontStretchProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Inline.ForegroundProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Inline.ForegroundProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Inline.TextDecorationsProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Inline.TextDecorationsProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Inline.LanguageProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Inline.LanguageProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_Inline ()
        {
            LineBreak widget = new LineBreak ();
            object retval;

            retval = widget.GetValue(Inline.FontSizeProperty);
            Assert.IsNotNull(retval, "GetValue(Inline.FontSizeProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Inline.FontSizeProperty) is not of the correct type");
            Assert.AreEqual((double) 11, retval, "GetValue(Inline.FontSizeProperty) does not match the default value");
            retval = widget.GetValue(Inline.FontFamilyProperty);
            Assert.IsNotNull(retval, "GetValue(Inline.FontFamilyProperty) should not have returned null");
            Assert.IsTrue(retval is FontFamily, "GetValue(Inline.FontFamilyProperty) is not of the correct type");
            Assert.AreEqual("Portable User Interface", retval.ToString (), "GetValue(Inline.FontFamilyProperty) does not match the default value");
            retval = widget.GetValue(Inline.FontWeightProperty);
            Assert.IsNotNull(retval, "GetValue(Inline.FontWeightProperty) should not have returned null");
            Assert.IsTrue(retval is FontWeight, "GetValue(Inline.FontWeightProperty) is not of the correct type");
            Assert.AreEqual("Normal", retval.ToString (), "GetValue(Inline.FontWeightProperty) does not match the default value");
            retval = widget.GetValue(Inline.FontStyleProperty);
            Assert.IsNotNull(retval, "GetValue(Inline.FontStyleProperty) should not have returned null");
            Assert.IsTrue(retval is FontStyle, "GetValue(Inline.FontStyleProperty) is not of the correct type");
            Assert.AreEqual("Normal", retval.ToString (), "GetValue(Inline.FontStyleProperty) does not match the default value");
            retval = widget.GetValue(Inline.FontStretchProperty);
            Assert.IsNotNull(retval, "GetValue(Inline.FontStretchProperty) should not have returned null");
            Assert.IsTrue(retval is FontStretch, "GetValue(Inline.FontStretchProperty) is not of the correct type");
            Assert.AreEqual("Normal", retval.ToString (), "GetValue(Inline.FontStretchProperty) does not match the default value");
            retval = widget.GetValue(Inline.ForegroundProperty);
            Assert.IsNotNull(retval, "GetValue(Inline.ForegroundProperty) should not have returned null");
            Assert.IsTrue(retval is SolidColorBrush, "GetValue(Inline.ForegroundProperty) is not of the correct type");
            retval = widget.GetValue(Inline.TextDecorationsProperty);
            Assert.IsNull(retval, "GetValue(Inline.TextDecorationsProperty) should have returned null");
            retval = widget.GetValue(Inline.LanguageProperty);
            Assert.IsNotNull(retval, "GetValue(Inline.LanguageProperty) should not have returned null");
            Assert.IsTrue(retval is XmlLanguage, "GetValue(Inline.LanguageProperty) is not of the correct type");
            Assert.AreEqual("en-us", ((XmlLanguage) retval).IetfLanguageTag, "GetValue(Inline.LanguageProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_LineBreak ()
        {
            LineBreak widget = new LineBreak ();

            Assert.AreEqual((double) 11, widget.FontSize, "FontSize does not match the default value");
            Assert.IsNotNull(widget.FontFamily, "FontFamily should not have returned null");
            Assert.AreEqual("Portable User Interface", widget.FontFamily.ToString (), "FontFamily does not match the default value");
            Assert.AreEqual("Normal", widget.FontWeight.ToString (), "FontWeight does not match the default value");
            Assert.AreEqual("Normal", widget.FontStyle.ToString (), "FontStyle does not match the default value");
            Assert.AreEqual("Normal", widget.FontStretch.ToString (), "FontStretch does not match the default value");
            Assert.IsNotNull(widget.Foreground, "Foreground should not have returned null");
            Assert.IsTrue(widget.Foreground is SolidColorBrush, "Foreground is not of the correct type");
            Assert.IsNull(widget.TextDecorations, "TextDecorations should have returned null");
            Assert.IsNotNull(widget.Name, "Name should not have returned null");
            Assert.AreEqual("", widget.Name, "Name does not match the default value");
            Assert.IsNotNull(widget.Language, "Language should not have returned null");
            Assert.AreEqual("en-us", widget.Language.IetfLanguageTag, "Language does not match the default value");
        }

    }
}
namespace MoonTest.System.Windows.Controls
{
    public partial class ImageTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_Image ()
        {
            Image widget = new Image ();
            object retval;

            retval = widget.ReadLocalValue(Image.SourceProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Image.SourceProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Image.StretchProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Image.StretchProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_FrameworkElement ()
        {
            Image widget = new Image ();
            object retval;

            retval = widget.ReadLocalValue(FrameworkElement.LanguageProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.LanguageProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.ActualWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.ActualWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.ActualHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.ActualHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.WidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.WidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.HeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.HeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MinWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MinWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MaxWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MaxWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MinHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MinHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MaxHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MaxHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.HorizontalAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.HorizontalAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.VerticalAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.VerticalAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MarginProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MarginProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.StyleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.StyleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.NameProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.NameProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.TagProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.TagProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.DataContextProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.DataContextProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_UIElement ()
        {
            Image widget = new Image ();
            object retval;

            retval = widget.ReadLocalValue(UIElement.OpacityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.OpacityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.ClipProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.ClipProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.RenderTransformProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.RenderTransformProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.OpacityMaskProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.OpacityMaskProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.RenderTransformOriginProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.RenderTransformOriginProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.IsHitTestVisibleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.IsHitTestVisibleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.VisibilityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.VisibilityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.UseLayoutRoundingProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.UseLayoutRoundingProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_Image ()
        {
            Image widget = new Image ();
            object retval;

            retval = widget.GetValue(Image.SourceProperty);
            Assert.IsNotNull(retval, "GetValue(Image.SourceProperty) should not have returned null");
            Assert.IsTrue(retval is BitmapImage, "GetValue(Image.SourceProperty) is not of the correct type");
            retval = widget.GetValue(Image.StretchProperty);
            Assert.IsNotNull(retval, "GetValue(Image.StretchProperty) should not have returned null");
            Assert.IsTrue(retval is Stretch, "GetValue(Image.StretchProperty) is not of the correct type");
            Assert.AreEqual(Stretch.Uniform, retval, "GetValue(Image.StretchProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_GetValue_FrameworkElement ()
        {
            Image widget = new Image ();
            object retval;

            retval = widget.GetValue(FrameworkElement.LanguageProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.LanguageProperty) should not have returned null");
            Assert.IsTrue(retval is XmlLanguage, "GetValue(FrameworkElement.LanguageProperty) is not of the correct type");
            Assert.AreEqual("en-us", ((XmlLanguage) retval).IetfLanguageTag, "GetValue(FrameworkElement.LanguageProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.ActualWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.ActualWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.ActualWidthProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.ActualWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.ActualHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.ActualHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.ActualHeightProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.ActualHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.WidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.WidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.WidthProperty) is not of the correct type");
            Assert.IsTrue(Double.IsNaN((double) retval), "GetValue(FrameworkElement.WidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.HeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.HeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.HeightProperty) is not of the correct type");
            Assert.IsTrue(Double.IsNaN((double) retval), "GetValue(FrameworkElement.HeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MinWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MinWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MinWidthProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.MinWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MaxWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MaxWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MaxWidthProperty) is not of the correct type");
            Assert.IsTrue(Double.IsPositiveInfinity((double) retval), "GetValue(FrameworkElement.MaxWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MinHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MinHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MinHeightProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.MinHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MaxHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MaxHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MaxHeightProperty) is not of the correct type");
            Assert.IsTrue(Double.IsPositiveInfinity((double) retval), "GetValue(FrameworkElement.MaxHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.HorizontalAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.HorizontalAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is HorizontalAlignment, "GetValue(FrameworkElement.HorizontalAlignmentProperty) is not of the correct type");
            Assert.AreEqual(HorizontalAlignment.Stretch, retval, "GetValue(FrameworkElement.HorizontalAlignmentProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.VerticalAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.VerticalAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is VerticalAlignment, "GetValue(FrameworkElement.VerticalAlignmentProperty) is not of the correct type");
            Assert.AreEqual(VerticalAlignment.Stretch, retval, "GetValue(FrameworkElement.VerticalAlignmentProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MarginProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MarginProperty) should not have returned null");
            Assert.IsTrue(retval is Thickness, "GetValue(FrameworkElement.MarginProperty) is not of the correct type");
            Assert.AreEqual("0,0,0,0", retval.ToString (), "GetValue(FrameworkElement.MarginProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.StyleProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.StyleProperty) should have returned null");
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.NameProperty) should not have returned null");
            Assert.IsTrue(retval is string, "GetValue(FrameworkElement.NameProperty) is not of the correct type");
            Assert.AreEqual("", retval, "GetValue(FrameworkElement.NameProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.TagProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.TagProperty) should have returned null");
            retval = widget.GetValue(FrameworkElement.DataContextProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.DataContextProperty) should have returned null");
        }

        [TestMethod]
        public void Test_GetValue_UIElement ()
        {
            Image widget = new Image ();
            object retval;

            retval = widget.GetValue(UIElement.OpacityProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.OpacityProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(UIElement.OpacityProperty) is not of the correct type");
            Assert.AreEqual((double) 1, retval, "GetValue(UIElement.OpacityProperty) does not match the default value");
            retval = widget.GetValue(UIElement.ClipProperty);
            Assert.IsNull(retval, "GetValue(UIElement.ClipProperty) should have returned null");
            retval = widget.GetValue(UIElement.RenderTransformProperty);
            Assert.IsNull(retval, "GetValue(UIElement.RenderTransformProperty) should have returned null");
            retval = widget.GetValue(UIElement.OpacityMaskProperty);
            Assert.IsNull(retval, "GetValue(UIElement.OpacityMaskProperty) should have returned null");
            retval = widget.GetValue(UIElement.RenderTransformOriginProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.RenderTransformOriginProperty) should not have returned null");
            Assert.IsTrue(retval is Point, "GetValue(UIElement.RenderTransformOriginProperty) is not of the correct type");
            Assert.AreEqual("0,0", retval.ToString (), "GetValue(UIElement.RenderTransformOriginProperty) does not match the default value");
            retval = widget.GetValue(UIElement.IsHitTestVisibleProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.IsHitTestVisibleProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(UIElement.IsHitTestVisibleProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(UIElement.IsHitTestVisibleProperty) does not match the default value");
            retval = widget.GetValue(UIElement.VisibilityProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.VisibilityProperty) should not have returned null");
            Assert.IsTrue(retval is Visibility, "GetValue(UIElement.VisibilityProperty) is not of the correct type");
            Assert.AreEqual(Visibility.Visible, retval, "GetValue(UIElement.VisibilityProperty) does not match the default value");
            retval = widget.GetValue(UIElement.UseLayoutRoundingProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.UseLayoutRoundingProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(UIElement.UseLayoutRoundingProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(UIElement.UseLayoutRoundingProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_Image ()
        {
            Image widget = new Image ();

            Assert.AreEqual(Stretch.Uniform, widget.Stretch, "Stretch does not match the default value");
            Assert.IsNotNull(widget.Source, "Source should not have returned null");
            Assert.IsTrue(widget.Source is BitmapImage, "Source is not of the correct type");
            Assert.IsNotNull(widget.Triggers, "Triggers should not have returned null");
            Assert.IsTrue(widget.Triggers is TriggerCollection, "Triggers is not of the correct type");
            Assert.IsNotNull(widget.Resources, "Resources should not have returned null");
            Assert.IsTrue(widget.Resources is ResourceDictionary, "Resources is not of the correct type");
            Assert.AreEqual((double) 0, widget.ActualWidth, "ActualWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.ActualHeight, "ActualHeight does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Width), "Width does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Height), "Height does not match the default value");
            Assert.AreEqual((double) 0, widget.MinWidth, "MinWidth does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxWidth), "MaxWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.MinHeight, "MinHeight does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxHeight), "MaxHeight does not match the default value");
            Assert.AreEqual(HorizontalAlignment.Stretch, widget.HorizontalAlignment, "HorizontalAlignment does not match the default value");
            Assert.AreEqual(VerticalAlignment.Stretch, widget.VerticalAlignment, "VerticalAlignment does not match the default value");
            Assert.AreEqual("0,0,0,0", widget.Margin.ToString (), "Margin does not match the default value");
            Assert.IsNull(widget.Style, "Style should have returned null");
            Assert.IsNull(widget.Parent, "Parent should have returned null");
            Assert.IsNotNull(widget.Name, "Name should not have returned null");
            Assert.AreEqual("", widget.Name, "Name does not match the default value");
            Assert.IsNull(widget.Tag, "Tag should have returned null");
            Assert.IsNull(widget.Cursor, "Cursor should have returned null");
            Assert.IsNotNull(widget.Language, "Language should not have returned null");
            Assert.AreEqual("en-us", widget.Language.IetfLanguageTag, "Language does not match the default value");
            Assert.IsNull(widget.DataContext, "DataContext should have returned null");
            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNull(widget.Clip, "Clip should have returned null");
            Assert.IsNull(widget.OpacityMask, "OpacityMask should have returned null");
            Assert.AreEqual("0,0", widget.RenderTransformOrigin.ToString (), "RenderTransformOrigin does not match the default value");
            Assert.AreEqual(true, widget.IsHitTestVisible, "IsHitTestVisible does not match the default value");
            Assert.AreEqual(Visibility.Visible, widget.Visibility, "Visibility does not match the default value");
            Assert.AreEqual("0,0", widget.RenderSize.ToString (), "RenderSize does not match the default value");
            Assert.AreEqual(true, widget.UseLayoutRounding, "UseLayoutRounding does not match the default value");
            Assert.AreEqual("0,0", widget.DesiredSize.ToString (), "DesiredSize does not match the default value");
            Assert.IsNotNull(widget.RenderTransform, "RenderTransform should not have returned null");
            Assert.IsTrue(widget.RenderTransform is MatrixTransform, "RenderTransform is not of the correct type");
        }

        [TestMethod]
        public void Test_PropertyGetter_UIElement ()
        {
            Image widget = new Image ();

            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNull(widget.Clip, "Clip should have returned null");
            Assert.IsNull(widget.OpacityMask, "OpacityMask should have returned null");
            Assert.AreEqual("0,0", widget.RenderTransformOrigin.ToString (), "RenderTransformOrigin does not match the default value");
            Assert.AreEqual(true, widget.IsHitTestVisible, "IsHitTestVisible does not match the default value");
            Assert.AreEqual(Visibility.Visible, widget.Visibility, "Visibility does not match the default value");
            Assert.AreEqual("0,0", widget.RenderSize.ToString (), "RenderSize does not match the default value");
            Assert.AreEqual(true, widget.UseLayoutRounding, "UseLayoutRounding does not match the default value");
            Assert.AreEqual("0,0", widget.DesiredSize.ToString (), "DesiredSize does not match the default value");
            Assert.IsNotNull(widget.RenderTransform, "RenderTransform should not have returned null");
            Assert.IsTrue(widget.RenderTransform is MatrixTransform, "RenderTransform is not of the correct type");
        }

        [TestMethod]
	[MoonlightBug]
        public void Test_SetStringValue_FrameworkElement ()
        {
            Image widget = new Image ();
            object retval;

            widget.SetValue(FrameworkElement.NameProperty, "some text");
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.AreEqual("some text", retval, "GetValue(FrameworkElement.NameProperty) should have returned 'some text'");
            widget.SetValue(FrameworkElement.NameProperty, null);
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.AreEqual(String.Empty, retval, "GetValue(FrameworkElement.NameProperty) should have returned String.Empty");
            retval = widget.ReadLocalValue(FrameworkElement.NameProperty);
            Assert.AreEqual(String.Empty, retval, "ReadLocalValue(FrameworkElement.NameProperty) should have returned String.Empty");
        }

    }
}
namespace MoonTest.System.Windows.Controls
{
    public partial class CanvasTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_Canvas ()
        {
            Canvas widget = new Canvas ();
            object retval;

            retval = widget.ReadLocalValue(Canvas.LeftProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Canvas.LeftProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Canvas.TopProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Canvas.TopProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Canvas.ZIndexProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Canvas.ZIndexProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_Panel ()
        {
            Canvas widget = new Canvas ();
            object retval;

            retval = widget.ReadLocalValue(Panel.BackgroundProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Panel.BackgroundProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_FrameworkElement ()
        {
            Canvas widget = new Canvas ();
            object retval;

            retval = widget.ReadLocalValue(FrameworkElement.LanguageProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.LanguageProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.ActualWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.ActualWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.ActualHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.ActualHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.WidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.WidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.HeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.HeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MinWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MinWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MaxWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MaxWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MinHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MinHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MaxHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MaxHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.HorizontalAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.HorizontalAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.VerticalAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.VerticalAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MarginProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MarginProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.StyleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.StyleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.NameProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.NameProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.TagProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.TagProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.DataContextProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.DataContextProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_UIElement ()
        {
            Canvas widget = new Canvas ();
            object retval;

            retval = widget.ReadLocalValue(UIElement.OpacityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.OpacityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.ClipProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.ClipProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.RenderTransformProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.RenderTransformProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.OpacityMaskProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.OpacityMaskProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.RenderTransformOriginProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.RenderTransformOriginProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.IsHitTestVisibleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.IsHitTestVisibleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.VisibilityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.VisibilityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.UseLayoutRoundingProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.UseLayoutRoundingProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_Canvas ()
        {
            Canvas widget = new Canvas ();
            object retval;

            retval = widget.GetValue(Canvas.LeftProperty);
            Assert.IsNotNull(retval, "GetValue(Canvas.LeftProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Canvas.LeftProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(Canvas.LeftProperty) does not match the default value");
            retval = widget.GetValue(Canvas.TopProperty);
            Assert.IsNotNull(retval, "GetValue(Canvas.TopProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Canvas.TopProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(Canvas.TopProperty) does not match the default value");
            retval = widget.GetValue(Canvas.ZIndexProperty);
            Assert.IsNotNull(retval, "GetValue(Canvas.ZIndexProperty) should not have returned null");
            Assert.IsTrue(retval is int, "GetValue(Canvas.ZIndexProperty) is not of the correct type");
            Assert.AreEqual(0, retval, "GetValue(Canvas.ZIndexProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_GetValue_Panel ()
        {
            Canvas widget = new Canvas ();
            object retval;

            retval = widget.GetValue(Panel.BackgroundProperty);
            Assert.IsNull(retval, "GetValue(Panel.BackgroundProperty) should have returned null");
        }

        [TestMethod]
        public void Test_GetValue_FrameworkElement ()
        {
            Canvas widget = new Canvas ();
            object retval;

            retval = widget.GetValue(FrameworkElement.LanguageProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.LanguageProperty) should not have returned null");
            Assert.IsTrue(retval is XmlLanguage, "GetValue(FrameworkElement.LanguageProperty) is not of the correct type");
            Assert.AreEqual("en-us", ((XmlLanguage) retval).IetfLanguageTag, "GetValue(FrameworkElement.LanguageProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.ActualWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.ActualWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.ActualWidthProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.ActualWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.ActualHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.ActualHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.ActualHeightProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.ActualHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.WidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.WidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.WidthProperty) is not of the correct type");
            Assert.IsTrue(Double.IsNaN((double) retval), "GetValue(FrameworkElement.WidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.HeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.HeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.HeightProperty) is not of the correct type");
            Assert.IsTrue(Double.IsNaN((double) retval), "GetValue(FrameworkElement.HeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MinWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MinWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MinWidthProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.MinWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MaxWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MaxWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MaxWidthProperty) is not of the correct type");
            Assert.IsTrue(Double.IsPositiveInfinity((double) retval), "GetValue(FrameworkElement.MaxWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MinHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MinHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MinHeightProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.MinHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MaxHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MaxHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MaxHeightProperty) is not of the correct type");
            Assert.IsTrue(Double.IsPositiveInfinity((double) retval), "GetValue(FrameworkElement.MaxHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.HorizontalAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.HorizontalAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is HorizontalAlignment, "GetValue(FrameworkElement.HorizontalAlignmentProperty) is not of the correct type");
            Assert.AreEqual(HorizontalAlignment.Stretch, retval, "GetValue(FrameworkElement.HorizontalAlignmentProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.VerticalAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.VerticalAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is VerticalAlignment, "GetValue(FrameworkElement.VerticalAlignmentProperty) is not of the correct type");
            Assert.AreEqual(VerticalAlignment.Stretch, retval, "GetValue(FrameworkElement.VerticalAlignmentProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MarginProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MarginProperty) should not have returned null");
            Assert.IsTrue(retval is Thickness, "GetValue(FrameworkElement.MarginProperty) is not of the correct type");
            Assert.AreEqual("0,0,0,0", retval.ToString (), "GetValue(FrameworkElement.MarginProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.StyleProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.StyleProperty) should have returned null");
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.NameProperty) should not have returned null");
            Assert.IsTrue(retval is string, "GetValue(FrameworkElement.NameProperty) is not of the correct type");
            Assert.AreEqual("", retval, "GetValue(FrameworkElement.NameProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.TagProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.TagProperty) should have returned null");
            retval = widget.GetValue(FrameworkElement.DataContextProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.DataContextProperty) should have returned null");
        }

        [TestMethod]
        public void Test_GetValue_UIElement ()
        {
            Canvas widget = new Canvas ();
            object retval;

            retval = widget.GetValue(UIElement.OpacityProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.OpacityProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(UIElement.OpacityProperty) is not of the correct type");
            Assert.AreEqual((double) 1, retval, "GetValue(UIElement.OpacityProperty) does not match the default value");
            retval = widget.GetValue(UIElement.ClipProperty);
            Assert.IsNull(retval, "GetValue(UIElement.ClipProperty) should have returned null");
            retval = widget.GetValue(UIElement.RenderTransformProperty);
            Assert.IsNull(retval, "GetValue(UIElement.RenderTransformProperty) should have returned null");
            retval = widget.GetValue(UIElement.OpacityMaskProperty);
            Assert.IsNull(retval, "GetValue(UIElement.OpacityMaskProperty) should have returned null");
            retval = widget.GetValue(UIElement.RenderTransformOriginProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.RenderTransformOriginProperty) should not have returned null");
            Assert.IsTrue(retval is Point, "GetValue(UIElement.RenderTransformOriginProperty) is not of the correct type");
            Assert.AreEqual("0,0", retval.ToString (), "GetValue(UIElement.RenderTransformOriginProperty) does not match the default value");
            retval = widget.GetValue(UIElement.IsHitTestVisibleProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.IsHitTestVisibleProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(UIElement.IsHitTestVisibleProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(UIElement.IsHitTestVisibleProperty) does not match the default value");
            retval = widget.GetValue(UIElement.VisibilityProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.VisibilityProperty) should not have returned null");
            Assert.IsTrue(retval is Visibility, "GetValue(UIElement.VisibilityProperty) is not of the correct type");
            Assert.AreEqual(Visibility.Visible, retval, "GetValue(UIElement.VisibilityProperty) does not match the default value");
            retval = widget.GetValue(UIElement.UseLayoutRoundingProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.UseLayoutRoundingProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(UIElement.UseLayoutRoundingProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(UIElement.UseLayoutRoundingProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_Canvas ()
        {
            Canvas widget = new Canvas ();

            Assert.IsNotNull(widget.Children, "Children should not have returned null");
            Assert.IsTrue(widget.Children is UIElementCollection, "Children is not of the correct type");
            Assert.IsNull(widget.Background, "Background should have returned null");
            Assert.IsNotNull(widget.Triggers, "Triggers should not have returned null");
            Assert.IsTrue(widget.Triggers is TriggerCollection, "Triggers is not of the correct type");
            Assert.IsNotNull(widget.Resources, "Resources should not have returned null");
            Assert.IsTrue(widget.Resources is ResourceDictionary, "Resources is not of the correct type");
            Assert.AreEqual((double) 0, widget.ActualWidth, "ActualWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.ActualHeight, "ActualHeight does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Width), "Width does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Height), "Height does not match the default value");
            Assert.AreEqual((double) 0, widget.MinWidth, "MinWidth does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxWidth), "MaxWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.MinHeight, "MinHeight does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxHeight), "MaxHeight does not match the default value");
            Assert.AreEqual(HorizontalAlignment.Stretch, widget.HorizontalAlignment, "HorizontalAlignment does not match the default value");
            Assert.AreEqual(VerticalAlignment.Stretch, widget.VerticalAlignment, "VerticalAlignment does not match the default value");
            Assert.AreEqual("0,0,0,0", widget.Margin.ToString (), "Margin does not match the default value");
            Assert.IsNull(widget.Style, "Style should have returned null");
            Assert.IsNull(widget.Parent, "Parent should have returned null");
            Assert.IsNotNull(widget.Name, "Name should not have returned null");
            Assert.AreEqual("", widget.Name, "Name does not match the default value");
            Assert.IsNull(widget.Tag, "Tag should have returned null");
            Assert.IsNull(widget.Cursor, "Cursor should have returned null");
            Assert.IsNotNull(widget.Language, "Language should not have returned null");
            Assert.AreEqual("en-us", widget.Language.IetfLanguageTag, "Language does not match the default value");
            Assert.IsNull(widget.DataContext, "DataContext should have returned null");
            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNull(widget.Clip, "Clip should have returned null");
            Assert.IsNull(widget.OpacityMask, "OpacityMask should have returned null");
            Assert.AreEqual("0,0", widget.RenderTransformOrigin.ToString (), "RenderTransformOrigin does not match the default value");
            Assert.AreEqual(true, widget.IsHitTestVisible, "IsHitTestVisible does not match the default value");
            Assert.AreEqual(Visibility.Visible, widget.Visibility, "Visibility does not match the default value");
            Assert.AreEqual("0,0", widget.RenderSize.ToString (), "RenderSize does not match the default value");
            Assert.AreEqual(true, widget.UseLayoutRounding, "UseLayoutRounding does not match the default value");
            Assert.AreEqual("0,0", widget.DesiredSize.ToString (), "DesiredSize does not match the default value");
            Assert.IsNotNull(widget.RenderTransform, "RenderTransform should not have returned null");
            Assert.IsTrue(widget.RenderTransform is MatrixTransform, "RenderTransform is not of the correct type");
        }

        [TestMethod]
        public void Test_PropertyGetter_FrameworkElement ()
        {
            Canvas widget = new Canvas ();

            Assert.IsNotNull(widget.Triggers, "Triggers should not have returned null");
            Assert.IsTrue(widget.Triggers is TriggerCollection, "Triggers is not of the correct type");
            Assert.IsNotNull(widget.Resources, "Resources should not have returned null");
            Assert.IsTrue(widget.Resources is ResourceDictionary, "Resources is not of the correct type");
            Assert.AreEqual((double) 0, widget.ActualWidth, "ActualWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.ActualHeight, "ActualHeight does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Width), "Width does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Height), "Height does not match the default value");
            Assert.AreEqual((double) 0, widget.MinWidth, "MinWidth does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxWidth), "MaxWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.MinHeight, "MinHeight does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxHeight), "MaxHeight does not match the default value");
            Assert.AreEqual(HorizontalAlignment.Stretch, widget.HorizontalAlignment, "HorizontalAlignment does not match the default value");
            Assert.AreEqual(VerticalAlignment.Stretch, widget.VerticalAlignment, "VerticalAlignment does not match the default value");
            Assert.AreEqual("0,0,0,0", widget.Margin.ToString (), "Margin does not match the default value");
            Assert.IsNull(widget.Style, "Style should have returned null");
            Assert.IsNull(widget.Parent, "Parent should have returned null");
            Assert.IsNotNull(widget.Name, "Name should not have returned null");
            Assert.AreEqual("", widget.Name, "Name does not match the default value");
            Assert.IsNull(widget.Tag, "Tag should have returned null");
            Assert.IsNull(widget.Cursor, "Cursor should have returned null");
            Assert.IsNotNull(widget.Language, "Language should not have returned null");
            Assert.AreEqual("en-us", widget.Language.IetfLanguageTag, "Language does not match the default value");
            Assert.IsNull(widget.DataContext, "DataContext should have returned null");
            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNull(widget.Clip, "Clip should have returned null");
            Assert.IsNull(widget.OpacityMask, "OpacityMask should have returned null");
            Assert.AreEqual("0,0", widget.RenderTransformOrigin.ToString (), "RenderTransformOrigin does not match the default value");
            Assert.AreEqual(true, widget.IsHitTestVisible, "IsHitTestVisible does not match the default value");
            Assert.AreEqual(Visibility.Visible, widget.Visibility, "Visibility does not match the default value");
            Assert.AreEqual("0,0", widget.RenderSize.ToString (), "RenderSize does not match the default value");
            Assert.AreEqual(true, widget.UseLayoutRounding, "UseLayoutRounding does not match the default value");
            Assert.AreEqual("0,0", widget.DesiredSize.ToString (), "DesiredSize does not match the default value");
            Assert.IsNotNull(widget.RenderTransform, "RenderTransform should not have returned null");
            Assert.IsTrue(widget.RenderTransform is MatrixTransform, "RenderTransform is not of the correct type");
        }

        [TestMethod]
	[MoonlightBug]
        public void Test_SetStringValue_FrameworkElement ()
        {
            Canvas widget = new Canvas ();
            object retval;

            widget.SetValue(FrameworkElement.NameProperty, "some text");
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.AreEqual("some text", retval, "GetValue(FrameworkElement.NameProperty) should have returned 'some text'");
            widget.SetValue(FrameworkElement.NameProperty, null);
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.AreEqual(String.Empty, retval, "GetValue(FrameworkElement.NameProperty) should have returned String.Empty");
            retval = widget.ReadLocalValue(FrameworkElement.NameProperty);
            Assert.AreEqual(String.Empty, retval, "ReadLocalValue(FrameworkElement.NameProperty) should have returned String.Empty");
        }

    }
}
namespace MoonTest.System.Windows.Controls
{
    public partial class TextBlockTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_TextBlock ()
        {
            TextBlock widget = new TextBlock ();
            object retval;

            retval = widget.ReadLocalValue(TextBlock.FontSizeProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(TextBlock.FontSizeProperty) should not have a value by default");
            retval = widget.ReadLocalValue(TextBlock.FontFamilyProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(TextBlock.FontFamilyProperty) should not have a value by default");
            retval = widget.ReadLocalValue(TextBlock.FontWeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(TextBlock.FontWeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(TextBlock.FontStyleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(TextBlock.FontStyleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(TextBlock.FontStretchProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(TextBlock.FontStretchProperty) should not have a value by default");
            retval = widget.ReadLocalValue(TextBlock.ForegroundProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(TextBlock.ForegroundProperty) should not have a value by default");
            retval = widget.ReadLocalValue(TextBlock.TextDecorationsProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(TextBlock.TextDecorationsProperty) should not have a value by default");
            retval = widget.ReadLocalValue(TextBlock.TextWrappingProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(TextBlock.TextWrappingProperty) should not have a value by default");
            retval = widget.ReadLocalValue(TextBlock.TextAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(TextBlock.TextAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(TextBlock.TextProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(TextBlock.TextProperty) should not have a value by default");
            retval = widget.ReadLocalValue(TextBlock.PaddingProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(TextBlock.PaddingProperty) should not have a value by default");
            retval = widget.ReadLocalValue(TextBlock.LineHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(TextBlock.LineHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(TextBlock.LineStackingStrategyProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(TextBlock.LineStackingStrategyProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_FrameworkElement ()
        {
            TextBlock widget = new TextBlock ();
            object retval;

            retval = widget.ReadLocalValue(FrameworkElement.LanguageProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.LanguageProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.ActualWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.ActualWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.ActualHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.ActualHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.WidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.WidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.HeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.HeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MinWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MinWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MaxWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MaxWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MinHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MinHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MaxHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MaxHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.HorizontalAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.HorizontalAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.VerticalAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.VerticalAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MarginProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MarginProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.StyleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.StyleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.NameProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.NameProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.TagProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.TagProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.DataContextProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.DataContextProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_UIElement ()
        {
            TextBlock widget = new TextBlock ();
            object retval;

            retval = widget.ReadLocalValue(UIElement.OpacityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.OpacityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.ClipProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.ClipProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.RenderTransformProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.RenderTransformProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.OpacityMaskProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.OpacityMaskProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.RenderTransformOriginProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.RenderTransformOriginProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.IsHitTestVisibleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.IsHitTestVisibleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.VisibilityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.VisibilityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.UseLayoutRoundingProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.UseLayoutRoundingProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_TextBlock ()
        {
            TextBlock widget = new TextBlock ();
            object retval;

            retval = widget.GetValue(TextBlock.FontSizeProperty);
            Assert.IsNotNull(retval, "GetValue(TextBlock.FontSizeProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(TextBlock.FontSizeProperty) is not of the correct type");
            Assert.AreEqual((double) 11, retval, "GetValue(TextBlock.FontSizeProperty) does not match the default value");
            retval = widget.GetValue(TextBlock.FontFamilyProperty);
            Assert.IsNotNull(retval, "GetValue(TextBlock.FontFamilyProperty) should not have returned null");
            Assert.IsTrue(retval is FontFamily, "GetValue(TextBlock.FontFamilyProperty) is not of the correct type");
            Assert.AreEqual("Portable User Interface", retval.ToString (), "GetValue(TextBlock.FontFamilyProperty) does not match the default value");
            retval = widget.GetValue(TextBlock.FontWeightProperty);
            Assert.IsNotNull(retval, "GetValue(TextBlock.FontWeightProperty) should not have returned null");
            Assert.IsTrue(retval is FontWeight, "GetValue(TextBlock.FontWeightProperty) is not of the correct type");
            Assert.AreEqual("Normal", retval.ToString (), "GetValue(TextBlock.FontWeightProperty) does not match the default value");
            retval = widget.GetValue(TextBlock.FontStyleProperty);
            Assert.IsNotNull(retval, "GetValue(TextBlock.FontStyleProperty) should not have returned null");
            Assert.IsTrue(retval is FontStyle, "GetValue(TextBlock.FontStyleProperty) is not of the correct type");
            Assert.AreEqual("Normal", retval.ToString (), "GetValue(TextBlock.FontStyleProperty) does not match the default value");
            retval = widget.GetValue(TextBlock.FontStretchProperty);
            Assert.IsNotNull(retval, "GetValue(TextBlock.FontStretchProperty) should not have returned null");
            Assert.IsTrue(retval is FontStretch, "GetValue(TextBlock.FontStretchProperty) is not of the correct type");
            Assert.AreEqual("Normal", retval.ToString (), "GetValue(TextBlock.FontStretchProperty) does not match the default value");
            retval = widget.GetValue(TextBlock.ForegroundProperty);
            Assert.IsNotNull(retval, "GetValue(TextBlock.ForegroundProperty) should not have returned null");
            Assert.IsTrue(retval is SolidColorBrush, "GetValue(TextBlock.ForegroundProperty) is not of the correct type");
            retval = widget.GetValue(TextBlock.TextDecorationsProperty);
            Assert.IsNull(retval, "GetValue(TextBlock.TextDecorationsProperty) should have returned null");
            retval = widget.GetValue(TextBlock.TextWrappingProperty);
            Assert.IsNotNull(retval, "GetValue(TextBlock.TextWrappingProperty) should not have returned null");
            Assert.IsTrue(retval is TextWrapping, "GetValue(TextBlock.TextWrappingProperty) is not of the correct type");
            Assert.AreEqual(TextWrapping.NoWrap, retval, "GetValue(TextBlock.TextWrappingProperty) does not match the default value");
            retval = widget.GetValue(TextBlock.TextAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(TextBlock.TextAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is TextAlignment, "GetValue(TextBlock.TextAlignmentProperty) is not of the correct type");
            Assert.AreEqual(TextAlignment.Left, retval, "GetValue(TextBlock.TextAlignmentProperty) does not match the default value");
            retval = widget.GetValue(TextBlock.TextProperty);
            Assert.IsNotNull(retval, "GetValue(TextBlock.TextProperty) should not have returned null");
            Assert.IsTrue(retval is string, "GetValue(TextBlock.TextProperty) is not of the correct type");
            Assert.AreEqual("", retval, "GetValue(TextBlock.TextProperty) does not match the default value");
            retval = widget.GetValue(TextBlock.PaddingProperty);
            Assert.IsNotNull(retval, "GetValue(TextBlock.PaddingProperty) should not have returned null");
            Assert.IsTrue(retval is Thickness, "GetValue(TextBlock.PaddingProperty) is not of the correct type");
            Assert.AreEqual("0,0,0,0", retval.ToString (), "GetValue(TextBlock.PaddingProperty) does not match the default value");
            retval = widget.GetValue(TextBlock.LineHeightProperty);
            Assert.IsNotNull(retval, "GetValue(TextBlock.LineHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(TextBlock.LineHeightProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(TextBlock.LineHeightProperty) does not match the default value");
            retval = widget.GetValue(TextBlock.LineStackingStrategyProperty);
            Assert.IsNotNull(retval, "GetValue(TextBlock.LineStackingStrategyProperty) should not have returned null");
            Assert.IsTrue(retval is LineStackingStrategy, "GetValue(TextBlock.LineStackingStrategyProperty) is not of the correct type");
            Assert.AreEqual(LineStackingStrategy.MaxHeight, retval, "GetValue(TextBlock.LineStackingStrategyProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_GetValue_FrameworkElement ()
        {
            TextBlock widget = new TextBlock ();
            object retval;

            retval = widget.GetValue(FrameworkElement.LanguageProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.LanguageProperty) should not have returned null");
            Assert.IsTrue(retval is XmlLanguage, "GetValue(FrameworkElement.LanguageProperty) is not of the correct type");
            Assert.AreEqual("en-us", ((XmlLanguage) retval).IetfLanguageTag, "GetValue(FrameworkElement.LanguageProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.ActualWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.ActualWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.ActualWidthProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.ActualWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.ActualHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.ActualHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.ActualHeightProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.ActualHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.WidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.WidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.WidthProperty) is not of the correct type");
            Assert.IsTrue(Double.IsNaN((double) retval), "GetValue(FrameworkElement.WidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.HeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.HeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.HeightProperty) is not of the correct type");
            Assert.IsTrue(Double.IsNaN((double) retval), "GetValue(FrameworkElement.HeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MinWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MinWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MinWidthProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.MinWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MaxWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MaxWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MaxWidthProperty) is not of the correct type");
            Assert.IsTrue(Double.IsPositiveInfinity((double) retval), "GetValue(FrameworkElement.MaxWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MinHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MinHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MinHeightProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.MinHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MaxHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MaxHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MaxHeightProperty) is not of the correct type");
            Assert.IsTrue(Double.IsPositiveInfinity((double) retval), "GetValue(FrameworkElement.MaxHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.HorizontalAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.HorizontalAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is HorizontalAlignment, "GetValue(FrameworkElement.HorizontalAlignmentProperty) is not of the correct type");
            Assert.AreEqual(HorizontalAlignment.Stretch, retval, "GetValue(FrameworkElement.HorizontalAlignmentProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.VerticalAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.VerticalAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is VerticalAlignment, "GetValue(FrameworkElement.VerticalAlignmentProperty) is not of the correct type");
            Assert.AreEqual(VerticalAlignment.Stretch, retval, "GetValue(FrameworkElement.VerticalAlignmentProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MarginProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MarginProperty) should not have returned null");
            Assert.IsTrue(retval is Thickness, "GetValue(FrameworkElement.MarginProperty) is not of the correct type");
            Assert.AreEqual("0,0,0,0", retval.ToString (), "GetValue(FrameworkElement.MarginProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.StyleProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.StyleProperty) should have returned null");
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.NameProperty) should not have returned null");
            Assert.IsTrue(retval is string, "GetValue(FrameworkElement.NameProperty) is not of the correct type");
            Assert.AreEqual("", retval, "GetValue(FrameworkElement.NameProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.TagProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.TagProperty) should have returned null");
            retval = widget.GetValue(FrameworkElement.DataContextProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.DataContextProperty) should have returned null");
        }

        [TestMethod]
        public void Test_GetValue_UIElement ()
        {
            TextBlock widget = new TextBlock ();
            object retval;

            retval = widget.GetValue(UIElement.OpacityProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.OpacityProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(UIElement.OpacityProperty) is not of the correct type");
            Assert.AreEqual((double) 1, retval, "GetValue(UIElement.OpacityProperty) does not match the default value");
            retval = widget.GetValue(UIElement.ClipProperty);
            Assert.IsNull(retval, "GetValue(UIElement.ClipProperty) should have returned null");
            retval = widget.GetValue(UIElement.RenderTransformProperty);
            Assert.IsNull(retval, "GetValue(UIElement.RenderTransformProperty) should have returned null");
            retval = widget.GetValue(UIElement.OpacityMaskProperty);
            Assert.IsNull(retval, "GetValue(UIElement.OpacityMaskProperty) should have returned null");
            retval = widget.GetValue(UIElement.RenderTransformOriginProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.RenderTransformOriginProperty) should not have returned null");
            Assert.IsTrue(retval is Point, "GetValue(UIElement.RenderTransformOriginProperty) is not of the correct type");
            Assert.AreEqual("0,0", retval.ToString (), "GetValue(UIElement.RenderTransformOriginProperty) does not match the default value");
            retval = widget.GetValue(UIElement.IsHitTestVisibleProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.IsHitTestVisibleProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(UIElement.IsHitTestVisibleProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(UIElement.IsHitTestVisibleProperty) does not match the default value");
            retval = widget.GetValue(UIElement.VisibilityProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.VisibilityProperty) should not have returned null");
            Assert.IsTrue(retval is Visibility, "GetValue(UIElement.VisibilityProperty) is not of the correct type");
            Assert.AreEqual(Visibility.Visible, retval, "GetValue(UIElement.VisibilityProperty) does not match the default value");
            retval = widget.GetValue(UIElement.UseLayoutRoundingProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.UseLayoutRoundingProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(UIElement.UseLayoutRoundingProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(UIElement.UseLayoutRoundingProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_TextBlock ()
        {
            TextBlock widget = new TextBlock ();

            Assert.AreEqual((double) 11, widget.FontSize, "FontSize does not match the default value");
            Assert.IsNotNull(widget.FontFamily, "FontFamily should not have returned null");
            Assert.AreEqual("Portable User Interface", widget.FontFamily.ToString (), "FontFamily does not match the default value");
            Assert.AreEqual("Normal", widget.FontWeight.ToString (), "FontWeight does not match the default value");
            Assert.AreEqual("Normal", widget.FontStyle.ToString (), "FontStyle does not match the default value");
            Assert.AreEqual("Normal", widget.FontStretch.ToString (), "FontStretch does not match the default value");
            Assert.IsNotNull(widget.Foreground, "Foreground should not have returned null");
            Assert.IsTrue(widget.Foreground is SolidColorBrush, "Foreground is not of the correct type");
            Assert.AreEqual(TextWrapping.NoWrap, widget.TextWrapping, "TextWrapping does not match the default value");
            Assert.AreEqual(TextAlignment.Left, widget.TextAlignment, "TextAlignment does not match the default value");
            Assert.IsNotNull(widget.Text, "Text should not have returned null");
            Assert.AreEqual("", widget.Text, "Text does not match the default value");
            Assert.AreEqual("0,0,0,0", widget.Padding.ToString (), "Padding does not match the default value");
            Assert.AreEqual((double) 0, widget.LineHeight, "LineHeight does not match the default value");
            Assert.AreEqual(LineStackingStrategy.MaxHeight, widget.LineStackingStrategy, "LineStackingStrategy does not match the default value");
            Assert.IsNull(widget.TextDecorations, "TextDecorations should have returned null");
            Assert.IsNotNull(widget.Inlines, "Inlines should not have returned null");
            Assert.IsTrue(widget.Inlines is InlineCollection, "Inlines is not of the correct type");
            Assert.IsNull(widget.FontSource, "FontSource should have returned null");
            Assert.IsNotNull(widget.Triggers, "Triggers should not have returned null");
            Assert.IsTrue(widget.Triggers is TriggerCollection, "Triggers is not of the correct type");
            Assert.IsNotNull(widget.Resources, "Resources should not have returned null");
            Assert.IsTrue(widget.Resources is ResourceDictionary, "Resources is not of the correct type");
            Assert.AreEqual((double) 0, widget.ActualWidth, "ActualWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.ActualHeight, "ActualHeight does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Width), "Width does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Height), "Height does not match the default value");
            Assert.AreEqual((double) 0, widget.MinWidth, "MinWidth does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxWidth), "MaxWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.MinHeight, "MinHeight does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxHeight), "MaxHeight does not match the default value");
            Assert.AreEqual(HorizontalAlignment.Stretch, widget.HorizontalAlignment, "HorizontalAlignment does not match the default value");
            Assert.AreEqual(VerticalAlignment.Stretch, widget.VerticalAlignment, "VerticalAlignment does not match the default value");
            Assert.AreEqual("0,0,0,0", widget.Margin.ToString (), "Margin does not match the default value");
            Assert.IsNull(widget.Style, "Style should have returned null");
            Assert.IsNull(widget.Parent, "Parent should have returned null");
            Assert.IsNotNull(widget.Name, "Name should not have returned null");
            Assert.AreEqual("", widget.Name, "Name does not match the default value");
            Assert.IsNull(widget.Tag, "Tag should have returned null");
            Assert.IsNull(widget.Cursor, "Cursor should have returned null");
            Assert.IsNotNull(widget.Language, "Language should not have returned null");
            Assert.AreEqual("en-us", widget.Language.IetfLanguageTag, "Language does not match the default value");
            Assert.IsNull(widget.DataContext, "DataContext should have returned null");
            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNull(widget.Clip, "Clip should have returned null");
            Assert.IsNull(widget.OpacityMask, "OpacityMask should have returned null");
            Assert.AreEqual("0,0", widget.RenderTransformOrigin.ToString (), "RenderTransformOrigin does not match the default value");
            Assert.AreEqual(true, widget.IsHitTestVisible, "IsHitTestVisible does not match the default value");
            Assert.AreEqual(Visibility.Visible, widget.Visibility, "Visibility does not match the default value");
            Assert.AreEqual("0,0", widget.RenderSize.ToString (), "RenderSize does not match the default value");
            Assert.AreEqual(true, widget.UseLayoutRounding, "UseLayoutRounding does not match the default value");
            Assert.AreEqual("0,0", widget.DesiredSize.ToString (), "DesiredSize does not match the default value");
            Assert.IsNotNull(widget.RenderTransform, "RenderTransform should not have returned null");
            Assert.IsTrue(widget.RenderTransform is MatrixTransform, "RenderTransform is not of the correct type");
        }

        [TestMethod]
        public void Test_PropertyGetter_UIElement ()
        {
            TextBlock widget = new TextBlock ();

            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNull(widget.Clip, "Clip should have returned null");
            Assert.IsNull(widget.OpacityMask, "OpacityMask should have returned null");
            Assert.AreEqual("0,0", widget.RenderTransformOrigin.ToString (), "RenderTransformOrigin does not match the default value");
            Assert.AreEqual(true, widget.IsHitTestVisible, "IsHitTestVisible does not match the default value");
            Assert.AreEqual(Visibility.Visible, widget.Visibility, "Visibility does not match the default value");
            Assert.AreEqual("0,0", widget.RenderSize.ToString (), "RenderSize does not match the default value");
            Assert.AreEqual(true, widget.UseLayoutRounding, "UseLayoutRounding does not match the default value");
            Assert.AreEqual("0,0", widget.DesiredSize.ToString (), "DesiredSize does not match the default value");
            Assert.IsNotNull(widget.RenderTransform, "RenderTransform should not have returned null");
            Assert.IsTrue(widget.RenderTransform is MatrixTransform, "RenderTransform is not of the correct type");
        }

        [TestMethod]
        public void Test_SetStringValue_TextBlock ()
        {
            TextBlock widget = new TextBlock ();
            object retval;

            widget.SetValue(TextBlock.TextProperty, "some text");
            retval = widget.GetValue(TextBlock.TextProperty);
            Assert.AreEqual("some text", retval, "GetValue(TextBlock.TextProperty) should have returned 'some text'");
            widget.SetValue(TextBlock.TextProperty, null);
            retval = widget.GetValue(TextBlock.TextProperty);
            Assert.AreEqual(String.Empty, retval, "GetValue(TextBlock.TextProperty) should have returned String.Empty");
            retval = widget.ReadLocalValue(TextBlock.TextProperty);
            Assert.AreEqual(String.Empty, retval, "ReadLocalValue(TextBlock.TextProperty) should have returned String.Empty");
        }

        [TestMethod]
	[MoonlightBug]
        public void Test_SetStringValue_FrameworkElement ()
        {
            TextBlock widget = new TextBlock ();
            object retval;

            widget.SetValue(FrameworkElement.NameProperty, "some text");
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.AreEqual("some text", retval, "GetValue(FrameworkElement.NameProperty) should have returned 'some text'");
            widget.SetValue(FrameworkElement.NameProperty, null);
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.AreEqual(String.Empty, retval, "GetValue(FrameworkElement.NameProperty) should have returned String.Empty");
            retval = widget.ReadLocalValue(FrameworkElement.NameProperty);
            Assert.AreEqual(String.Empty, retval, "ReadLocalValue(FrameworkElement.NameProperty) should have returned String.Empty");
        }

    }
}
namespace MoonTest.System.Windows.Controls
{
    public partial class MediaElementTest
    {
        [TestMethod]
	[MoonlightBug]
        public void Test_ReadLocalValue_MediaElement ()
        {
            MediaElement widget = new MediaElement ();
            object retval;

            retval = widget.ReadLocalValue(MediaElement.SourceProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(MediaElement.SourceProperty) should not have a value by default");
            retval = widget.ReadLocalValue(MediaElement.StretchProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(MediaElement.StretchProperty) should not have a value by default");
            retval = widget.ReadLocalValue(MediaElement.IsMutedProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(MediaElement.IsMutedProperty) should not have a value by default");
            retval = widget.ReadLocalValue(MediaElement.AutoPlayProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(MediaElement.AutoPlayProperty) should not have a value by default");
            retval = widget.ReadLocalValue(MediaElement.VolumeProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(MediaElement.VolumeProperty) should not have a value by default");
            retval = widget.ReadLocalValue(MediaElement.BalanceProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(MediaElement.BalanceProperty) should not have a value by default");
            retval = widget.ReadLocalValue(MediaElement.NaturalVideoHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(MediaElement.NaturalVideoHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(MediaElement.NaturalVideoWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(MediaElement.NaturalVideoWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(MediaElement.NaturalDurationProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(MediaElement.NaturalDurationProperty) should not have a value by default");
            retval = widget.ReadLocalValue(MediaElement.PositionProperty);
            Assert.IsNotNull(retval, "ReadLocalValue(MediaElement.PositionProperty) should not have returned null");
            Assert.IsTrue(retval is TimeSpan, "ReadLocalValue(MediaElement.PositionProperty) is not of the correct type");
            Assert.AreEqual("00:00:00", retval.ToString (), "ReadLocalValue(MediaElement.PositionProperty) does not match the default value");
            retval = widget.ReadLocalValue(MediaElement.DownloadProgressProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(MediaElement.DownloadProgressProperty) should not have a value by default");
            retval = widget.ReadLocalValue(MediaElement.BufferingProgressProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(MediaElement.BufferingProgressProperty) should not have a value by default");
            retval = widget.ReadLocalValue(MediaElement.DownloadProgressOffsetProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(MediaElement.DownloadProgressOffsetProperty) should not have a value by default");
            retval = widget.ReadLocalValue(MediaElement.CurrentStateProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(MediaElement.CurrentStateProperty) should not have a value by default");
            retval = widget.ReadLocalValue(MediaElement.BufferingTimeProperty);
            Assert.IsNotNull(retval, "ReadLocalValue(MediaElement.BufferingTimeProperty) should not have returned null");
            Assert.IsTrue(retval is TimeSpan, "ReadLocalValue(MediaElement.BufferingTimeProperty) is not of the correct type");
            Assert.AreEqual("00:00:05", retval.ToString (), "ReadLocalValue(MediaElement.BufferingTimeProperty) does not match the default value");
            retval = widget.ReadLocalValue(MediaElement.CanSeekProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(MediaElement.CanSeekProperty) should not have a value by default");
            retval = widget.ReadLocalValue(MediaElement.CanPauseProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(MediaElement.CanPauseProperty) should not have a value by default");
            retval = widget.ReadLocalValue(MediaElement.AudioStreamCountProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(MediaElement.AudioStreamCountProperty) should not have a value by default");
            retval = widget.ReadLocalValue(MediaElement.AudioStreamIndexProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(MediaElement.AudioStreamIndexProperty) should not have a value by default");
            retval = widget.ReadLocalValue(MediaElement.RenderedFramesPerSecondProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(MediaElement.RenderedFramesPerSecondProperty) should not have a value by default");
            retval = widget.ReadLocalValue(MediaElement.DroppedFramesPerSecondProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(MediaElement.DroppedFramesPerSecondProperty) should not have a value by default");
            // [MoonlightBug] - Moonlight needs to be fixed to throw on some ReadLocalValue invocations
            //Assert.Throws<Exception>(delegate {
            //    retval = widget.ReadLocalValue(MediaElement.AttributesProperty);
            //}, "ReadLocalValue(MediaElement.AttributesProperty) should thow an exception");
        }

        [TestMethod]
        public void Test_ReadLocalValue_FrameworkElement ()
        {
            MediaElement widget = new MediaElement ();
            object retval;

            retval = widget.ReadLocalValue(FrameworkElement.LanguageProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.LanguageProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.ActualWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.ActualWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.ActualHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.ActualHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.WidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.WidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.HeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.HeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MinWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MinWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MaxWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MaxWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MinHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MinHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MaxHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MaxHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.HorizontalAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.HorizontalAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.VerticalAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.VerticalAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MarginProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MarginProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.StyleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.StyleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.NameProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.NameProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.TagProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.TagProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.DataContextProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.DataContextProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_UIElement ()
        {
            MediaElement widget = new MediaElement ();
            object retval;

            retval = widget.ReadLocalValue(UIElement.OpacityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.OpacityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.ClipProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.ClipProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.RenderTransformProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.RenderTransformProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.OpacityMaskProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.OpacityMaskProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.RenderTransformOriginProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.RenderTransformOriginProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.IsHitTestVisibleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.IsHitTestVisibleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.VisibilityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.VisibilityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.UseLayoutRoundingProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.UseLayoutRoundingProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_MediaElement ()
        {
            MediaElement widget = new MediaElement ();
            object retval;

            retval = widget.GetValue(MediaElement.SourceProperty);
            Assert.IsNull(retval, "GetValue(MediaElement.SourceProperty) should have returned null");
            retval = widget.GetValue(MediaElement.StretchProperty);
            Assert.IsNotNull(retval, "GetValue(MediaElement.StretchProperty) should not have returned null");
            Assert.IsTrue(retval is Stretch, "GetValue(MediaElement.StretchProperty) is not of the correct type");
            Assert.AreEqual(Stretch.Uniform, retval, "GetValue(MediaElement.StretchProperty) does not match the default value");
            retval = widget.GetValue(MediaElement.IsMutedProperty);
            Assert.IsNotNull(retval, "GetValue(MediaElement.IsMutedProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(MediaElement.IsMutedProperty) is not of the correct type");
            Assert.AreEqual(false, retval, "GetValue(MediaElement.IsMutedProperty) does not match the default value");
            retval = widget.GetValue(MediaElement.AutoPlayProperty);
            Assert.IsNotNull(retval, "GetValue(MediaElement.AutoPlayProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(MediaElement.AutoPlayProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(MediaElement.AutoPlayProperty) does not match the default value");
            retval = widget.GetValue(MediaElement.VolumeProperty);
            Assert.IsNotNull(retval, "GetValue(MediaElement.VolumeProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(MediaElement.VolumeProperty) is not of the correct type");
            Assert.AreEqual((double) 0.5, retval, "GetValue(MediaElement.VolumeProperty) does not match the default value");
            retval = widget.GetValue(MediaElement.BalanceProperty);
            Assert.IsNotNull(retval, "GetValue(MediaElement.BalanceProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(MediaElement.BalanceProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(MediaElement.BalanceProperty) does not match the default value");
            retval = widget.GetValue(MediaElement.NaturalVideoHeightProperty);
            Assert.IsNotNull(retval, "GetValue(MediaElement.NaturalVideoHeightProperty) should not have returned null");
            Assert.IsTrue(retval is int, "GetValue(MediaElement.NaturalVideoHeightProperty) is not of the correct type");
            Assert.AreEqual(0, retval, "GetValue(MediaElement.NaturalVideoHeightProperty) does not match the default value");
            retval = widget.GetValue(MediaElement.NaturalVideoWidthProperty);
            Assert.IsNotNull(retval, "GetValue(MediaElement.NaturalVideoWidthProperty) should not have returned null");
            Assert.IsTrue(retval is int, "GetValue(MediaElement.NaturalVideoWidthProperty) is not of the correct type");
            Assert.AreEqual(0, retval, "GetValue(MediaElement.NaturalVideoWidthProperty) does not match the default value");
            retval = widget.GetValue(MediaElement.NaturalDurationProperty);
            Assert.IsNotNull(retval, "GetValue(MediaElement.NaturalDurationProperty) should not have returned null");
            Assert.IsTrue(retval is Duration, "GetValue(MediaElement.NaturalDurationProperty) is not of the correct type");
            Assert.AreEqual("00:00:00", retval.ToString (), "GetValue(MediaElement.NaturalDurationProperty) does not match the default value");
            retval = widget.GetValue(MediaElement.PositionProperty);
            Assert.IsNotNull(retval, "GetValue(MediaElement.PositionProperty) should not have returned null");
            Assert.IsTrue(retval is TimeSpan, "GetValue(MediaElement.PositionProperty) is not of the correct type");
            Assert.AreEqual("00:00:00", retval.ToString (), "GetValue(MediaElement.PositionProperty) does not match the default value");
            retval = widget.GetValue(MediaElement.DownloadProgressProperty);
            Assert.IsNotNull(retval, "GetValue(MediaElement.DownloadProgressProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(MediaElement.DownloadProgressProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(MediaElement.DownloadProgressProperty) does not match the default value");
            retval = widget.GetValue(MediaElement.BufferingProgressProperty);
            Assert.IsNotNull(retval, "GetValue(MediaElement.BufferingProgressProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(MediaElement.BufferingProgressProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(MediaElement.BufferingProgressProperty) does not match the default value");
            retval = widget.GetValue(MediaElement.DownloadProgressOffsetProperty);
            Assert.IsNotNull(retval, "GetValue(MediaElement.DownloadProgressOffsetProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(MediaElement.DownloadProgressOffsetProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(MediaElement.DownloadProgressOffsetProperty) does not match the default value");
            retval = widget.GetValue(MediaElement.CurrentStateProperty);
            Assert.IsNotNull(retval, "GetValue(MediaElement.CurrentStateProperty) should not have returned null");
            Assert.IsTrue(retval is MediaElementState, "GetValue(MediaElement.CurrentStateProperty) is not of the correct type");
            Assert.AreEqual(MediaElementState.Closed, retval, "GetValue(MediaElement.CurrentStateProperty) does not match the default value");
            retval = widget.GetValue(MediaElement.BufferingTimeProperty);
            Assert.IsNotNull(retval, "GetValue(MediaElement.BufferingTimeProperty) should not have returned null");
            Assert.IsTrue(retval is TimeSpan, "GetValue(MediaElement.BufferingTimeProperty) is not of the correct type");
            Assert.AreEqual("00:00:05", retval.ToString (), "GetValue(MediaElement.BufferingTimeProperty) does not match the default value");
            retval = widget.GetValue(MediaElement.CanSeekProperty);
            Assert.IsNotNull(retval, "GetValue(MediaElement.CanSeekProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(MediaElement.CanSeekProperty) is not of the correct type");
            Assert.AreEqual(false, retval, "GetValue(MediaElement.CanSeekProperty) does not match the default value");
            retval = widget.GetValue(MediaElement.CanPauseProperty);
            Assert.IsNotNull(retval, "GetValue(MediaElement.CanPauseProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(MediaElement.CanPauseProperty) is not of the correct type");
            Assert.AreEqual(false, retval, "GetValue(MediaElement.CanPauseProperty) does not match the default value");
            retval = widget.GetValue(MediaElement.AudioStreamCountProperty);
            Assert.IsNotNull(retval, "GetValue(MediaElement.AudioStreamCountProperty) should not have returned null");
            Assert.IsTrue(retval is int, "GetValue(MediaElement.AudioStreamCountProperty) is not of the correct type");
            Assert.AreEqual(0, retval, "GetValue(MediaElement.AudioStreamCountProperty) does not match the default value");
            retval = widget.GetValue(MediaElement.AudioStreamIndexProperty);
            Assert.IsNull(retval, "GetValue(MediaElement.AudioStreamIndexProperty) should have returned null");
            retval = widget.GetValue(MediaElement.RenderedFramesPerSecondProperty);
            Assert.IsNotNull(retval, "GetValue(MediaElement.RenderedFramesPerSecondProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(MediaElement.RenderedFramesPerSecondProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(MediaElement.RenderedFramesPerSecondProperty) does not match the default value");
            retval = widget.GetValue(MediaElement.DroppedFramesPerSecondProperty);
            Assert.IsNotNull(retval, "GetValue(MediaElement.DroppedFramesPerSecondProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(MediaElement.DroppedFramesPerSecondProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(MediaElement.DroppedFramesPerSecondProperty) does not match the default value");
            retval = widget.GetValue(MediaElement.AttributesProperty);
            Assert.IsNotNull(retval, "GetValue(MediaElement.AttributesProperty) should not have returned null");
        }

        [TestMethod]
        public void Test_GetValue_FrameworkElement ()
        {
            MediaElement widget = new MediaElement ();
            object retval;

            retval = widget.GetValue(FrameworkElement.LanguageProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.LanguageProperty) should not have returned null");
            Assert.IsTrue(retval is XmlLanguage, "GetValue(FrameworkElement.LanguageProperty) is not of the correct type");
            Assert.AreEqual("en-us", ((XmlLanguage) retval).IetfLanguageTag, "GetValue(FrameworkElement.LanguageProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.ActualWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.ActualWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.ActualWidthProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.ActualWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.ActualHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.ActualHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.ActualHeightProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.ActualHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.WidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.WidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.WidthProperty) is not of the correct type");
            Assert.IsTrue(Double.IsNaN((double) retval), "GetValue(FrameworkElement.WidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.HeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.HeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.HeightProperty) is not of the correct type");
            Assert.IsTrue(Double.IsNaN((double) retval), "GetValue(FrameworkElement.HeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MinWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MinWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MinWidthProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.MinWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MaxWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MaxWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MaxWidthProperty) is not of the correct type");
            Assert.IsTrue(Double.IsPositiveInfinity((double) retval), "GetValue(FrameworkElement.MaxWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MinHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MinHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MinHeightProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.MinHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MaxHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MaxHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MaxHeightProperty) is not of the correct type");
            Assert.IsTrue(Double.IsPositiveInfinity((double) retval), "GetValue(FrameworkElement.MaxHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.HorizontalAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.HorizontalAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is HorizontalAlignment, "GetValue(FrameworkElement.HorizontalAlignmentProperty) is not of the correct type");
            Assert.AreEqual(HorizontalAlignment.Stretch, retval, "GetValue(FrameworkElement.HorizontalAlignmentProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.VerticalAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.VerticalAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is VerticalAlignment, "GetValue(FrameworkElement.VerticalAlignmentProperty) is not of the correct type");
            Assert.AreEqual(VerticalAlignment.Stretch, retval, "GetValue(FrameworkElement.VerticalAlignmentProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MarginProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MarginProperty) should not have returned null");
            Assert.IsTrue(retval is Thickness, "GetValue(FrameworkElement.MarginProperty) is not of the correct type");
            Assert.AreEqual("0,0,0,0", retval.ToString (), "GetValue(FrameworkElement.MarginProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.StyleProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.StyleProperty) should have returned null");
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.NameProperty) should not have returned null");
            Assert.IsTrue(retval is string, "GetValue(FrameworkElement.NameProperty) is not of the correct type");
            Assert.AreEqual("", retval, "GetValue(FrameworkElement.NameProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.TagProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.TagProperty) should have returned null");
            retval = widget.GetValue(FrameworkElement.DataContextProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.DataContextProperty) should have returned null");
        }

        [TestMethod]
        public void Test_GetValue_UIElement ()
        {
            MediaElement widget = new MediaElement ();
            object retval;

            retval = widget.GetValue(UIElement.OpacityProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.OpacityProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(UIElement.OpacityProperty) is not of the correct type");
            Assert.AreEqual((double) 1, retval, "GetValue(UIElement.OpacityProperty) does not match the default value");
            retval = widget.GetValue(UIElement.ClipProperty);
            Assert.IsNull(retval, "GetValue(UIElement.ClipProperty) should have returned null");
            retval = widget.GetValue(UIElement.RenderTransformProperty);
            Assert.IsNull(retval, "GetValue(UIElement.RenderTransformProperty) should have returned null");
            retval = widget.GetValue(UIElement.OpacityMaskProperty);
            Assert.IsNull(retval, "GetValue(UIElement.OpacityMaskProperty) should have returned null");
            retval = widget.GetValue(UIElement.RenderTransformOriginProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.RenderTransformOriginProperty) should not have returned null");
            Assert.IsTrue(retval is Point, "GetValue(UIElement.RenderTransformOriginProperty) is not of the correct type");
            Assert.AreEqual("0,0", retval.ToString (), "GetValue(UIElement.RenderTransformOriginProperty) does not match the default value");
            retval = widget.GetValue(UIElement.IsHitTestVisibleProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.IsHitTestVisibleProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(UIElement.IsHitTestVisibleProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(UIElement.IsHitTestVisibleProperty) does not match the default value");
            retval = widget.GetValue(UIElement.VisibilityProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.VisibilityProperty) should not have returned null");
            Assert.IsTrue(retval is Visibility, "GetValue(UIElement.VisibilityProperty) is not of the correct type");
            Assert.AreEqual(Visibility.Visible, retval, "GetValue(UIElement.VisibilityProperty) does not match the default value");
            retval = widget.GetValue(UIElement.UseLayoutRoundingProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.UseLayoutRoundingProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(UIElement.UseLayoutRoundingProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(UIElement.UseLayoutRoundingProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_MediaElement ()
        {
            MediaElement widget = new MediaElement ();

            Assert.IsNull(widget.Source, "Source should have returned null");
            Assert.AreEqual(Stretch.Uniform, widget.Stretch, "Stretch does not match the default value");
            Assert.AreEqual(false, widget.IsMuted, "IsMuted does not match the default value");
            Assert.AreEqual(true, widget.AutoPlay, "AutoPlay does not match the default value");
            Assert.AreEqual((double) 0.5, widget.Volume, "Volume does not match the default value");
            Assert.AreEqual((double) 0, widget.Balance, "Balance does not match the default value");
            Assert.AreEqual(0, widget.NaturalVideoHeight, "NaturalVideoHeight does not match the default value");
            Assert.AreEqual(0, widget.NaturalVideoWidth, "NaturalVideoWidth does not match the default value");
            Assert.AreEqual("00:00:00", widget.NaturalDuration.ToString (), "NaturalDuration does not match the default value");
            Assert.AreEqual("00:00:00", widget.Position.ToString (), "Position does not match the default value");
            Assert.AreEqual((double) 0, widget.DownloadProgress, "DownloadProgress does not match the default value");
            Assert.AreEqual((double) 0, widget.BufferingProgress, "BufferingProgress does not match the default value");
            Assert.AreEqual((double) 0, widget.DownloadProgressOffset, "DownloadProgressOffset does not match the default value");
            Assert.AreEqual(MediaElementState.Closed, widget.CurrentState, "CurrentState does not match the default value");
            Assert.AreEqual("00:00:05", widget.BufferingTime.ToString (), "BufferingTime does not match the default value");
            Assert.IsNotNull(widget.Markers, "Markers should not have returned null");
            Assert.IsTrue(widget.Markers is TimelineMarkerCollection, "Markers is not of the correct type");
            Assert.AreEqual(false, widget.CanSeek, "CanSeek does not match the default value");
            Assert.AreEqual(false, widget.CanPause, "CanPause does not match the default value");
            Assert.AreEqual(0, widget.AudioStreamCount, "AudioStreamCount does not match the default value");
            Assert.IsNull(widget.AudioStreamIndex, "AudioStreamIndex should have returned null");
            Assert.AreEqual((double) 0, widget.RenderedFramesPerSecond, "RenderedFramesPerSecond does not match the default value");
            Assert.AreEqual((double) 0, widget.DroppedFramesPerSecond, "DroppedFramesPerSecond does not match the default value");
            Assert.IsNotNull(widget.Attributes, "Attributes should not have returned null");
            Assert.IsNotNull(widget.LicenseAcquirer, "LicenseAcquirer should not have returned null");
            Assert.AreEqual("System.Windows.Media.LicenseAcquirer", widget.LicenseAcquirer.ToString (), "LicenseAcquirer does not match the default value");
            Assert.IsNotNull(widget.Triggers, "Triggers should not have returned null");
            Assert.IsTrue(widget.Triggers is TriggerCollection, "Triggers is not of the correct type");
            Assert.IsNotNull(widget.Resources, "Resources should not have returned null");
            Assert.IsTrue(widget.Resources is ResourceDictionary, "Resources is not of the correct type");
            Assert.AreEqual((double) 0, widget.ActualWidth, "ActualWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.ActualHeight, "ActualHeight does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Width), "Width does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Height), "Height does not match the default value");
            Assert.AreEqual((double) 0, widget.MinWidth, "MinWidth does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxWidth), "MaxWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.MinHeight, "MinHeight does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxHeight), "MaxHeight does not match the default value");
            Assert.AreEqual(HorizontalAlignment.Stretch, widget.HorizontalAlignment, "HorizontalAlignment does not match the default value");
            Assert.AreEqual(VerticalAlignment.Stretch, widget.VerticalAlignment, "VerticalAlignment does not match the default value");
            Assert.AreEqual("0,0,0,0", widget.Margin.ToString (), "Margin does not match the default value");
            Assert.IsNull(widget.Style, "Style should have returned null");
            Assert.IsNull(widget.Parent, "Parent should have returned null");
            Assert.IsNotNull(widget.Name, "Name should not have returned null");
            Assert.AreEqual("", widget.Name, "Name does not match the default value");
            Assert.IsNull(widget.Tag, "Tag should have returned null");
            Assert.IsNull(widget.Cursor, "Cursor should have returned null");
            Assert.IsNotNull(widget.Language, "Language should not have returned null");
            Assert.AreEqual("en-us", widget.Language.IetfLanguageTag, "Language does not match the default value");
            Assert.IsNull(widget.DataContext, "DataContext should have returned null");
            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNull(widget.Clip, "Clip should have returned null");
            Assert.IsNull(widget.OpacityMask, "OpacityMask should have returned null");
            Assert.AreEqual("0,0", widget.RenderTransformOrigin.ToString (), "RenderTransformOrigin does not match the default value");
            Assert.AreEqual(true, widget.IsHitTestVisible, "IsHitTestVisible does not match the default value");
            Assert.AreEqual(Visibility.Visible, widget.Visibility, "Visibility does not match the default value");
            Assert.AreEqual("0,0", widget.RenderSize.ToString (), "RenderSize does not match the default value");
            Assert.AreEqual(true, widget.UseLayoutRounding, "UseLayoutRounding does not match the default value");
            Assert.AreEqual("0,0", widget.DesiredSize.ToString (), "DesiredSize does not match the default value");
            Assert.IsNotNull(widget.RenderTransform, "RenderTransform should not have returned null");
            Assert.IsTrue(widget.RenderTransform is MatrixTransform, "RenderTransform is not of the correct type");
        }

        [TestMethod]
        public void Test_PropertyGetter_UIElement ()
        {
            MediaElement widget = new MediaElement ();

            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNull(widget.Clip, "Clip should have returned null");
            Assert.IsNull(widget.OpacityMask, "OpacityMask should have returned null");
            Assert.AreEqual("0,0", widget.RenderTransformOrigin.ToString (), "RenderTransformOrigin does not match the default value");
            Assert.AreEqual(true, widget.IsHitTestVisible, "IsHitTestVisible does not match the default value");
            Assert.AreEqual(Visibility.Visible, widget.Visibility, "Visibility does not match the default value");
            Assert.AreEqual("0,0", widget.RenderSize.ToString (), "RenderSize does not match the default value");
            Assert.AreEqual(true, widget.UseLayoutRounding, "UseLayoutRounding does not match the default value");
            Assert.AreEqual("0,0", widget.DesiredSize.ToString (), "DesiredSize does not match the default value");
            Assert.IsNotNull(widget.RenderTransform, "RenderTransform should not have returned null");
            Assert.IsTrue(widget.RenderTransform is MatrixTransform, "RenderTransform is not of the correct type");
        }

        [TestMethod]
	[MoonlightBug]
        public void Test_SetStringValue_FrameworkElement ()
        {
            MediaElement widget = new MediaElement ();
            object retval;

            widget.SetValue(FrameworkElement.NameProperty, "some text");
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.AreEqual("some text", retval, "GetValue(FrameworkElement.NameProperty) should have returned 'some text'");
            widget.SetValue(FrameworkElement.NameProperty, null);
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.AreEqual(String.Empty, retval, "GetValue(FrameworkElement.NameProperty) should have returned String.Empty");
            retval = widget.ReadLocalValue(FrameworkElement.NameProperty);
            Assert.AreEqual(String.Empty, retval, "ReadLocalValue(FrameworkElement.NameProperty) should have returned String.Empty");
        }

    }
}
namespace MoonTest.System.Windows.Controls
{
    public partial class InkPresenterTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_InkPresenter ()
        {
            InkPresenter widget = new InkPresenter ();
            object retval;

            retval = widget.ReadLocalValue(InkPresenter.StrokesProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(InkPresenter.StrokesProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_Canvas ()
        {
            InkPresenter widget = new InkPresenter ();
            object retval;

            retval = widget.ReadLocalValue(Canvas.LeftProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Canvas.LeftProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Canvas.TopProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Canvas.TopProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Canvas.ZIndexProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Canvas.ZIndexProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_Panel ()
        {
            InkPresenter widget = new InkPresenter ();
            object retval;

            retval = widget.ReadLocalValue(Panel.BackgroundProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Panel.BackgroundProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_FrameworkElement ()
        {
            InkPresenter widget = new InkPresenter ();
            object retval;

            retval = widget.ReadLocalValue(FrameworkElement.LanguageProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.LanguageProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.ActualWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.ActualWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.ActualHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.ActualHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.WidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.WidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.HeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.HeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MinWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MinWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MaxWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MaxWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MinHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MinHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MaxHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MaxHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.HorizontalAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.HorizontalAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.VerticalAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.VerticalAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MarginProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MarginProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.StyleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.StyleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.NameProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.NameProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.TagProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.TagProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.DataContextProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.DataContextProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_UIElement ()
        {
            InkPresenter widget = new InkPresenter ();
            object retval;

            retval = widget.ReadLocalValue(UIElement.OpacityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.OpacityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.ClipProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.ClipProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.RenderTransformProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.RenderTransformProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.OpacityMaskProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.OpacityMaskProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.RenderTransformOriginProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.RenderTransformOriginProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.IsHitTestVisibleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.IsHitTestVisibleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.VisibilityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.VisibilityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.UseLayoutRoundingProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.UseLayoutRoundingProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_InkPresenter ()
        {
            InkPresenter widget = new InkPresenter ();
            object retval;

            retval = widget.GetValue(InkPresenter.StrokesProperty);
            Assert.IsNotNull(retval, "GetValue(InkPresenter.StrokesProperty) should not have returned null");
            Assert.IsTrue(retval is StrokeCollection, "GetValue(InkPresenter.StrokesProperty) is not of the correct type");
        }

        [TestMethod]
        public void Test_GetValue_Canvas ()
        {
            InkPresenter widget = new InkPresenter ();
            object retval;

            retval = widget.GetValue(Canvas.LeftProperty);
            Assert.IsNotNull(retval, "GetValue(Canvas.LeftProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Canvas.LeftProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(Canvas.LeftProperty) does not match the default value");
            retval = widget.GetValue(Canvas.TopProperty);
            Assert.IsNotNull(retval, "GetValue(Canvas.TopProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Canvas.TopProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(Canvas.TopProperty) does not match the default value");
            retval = widget.GetValue(Canvas.ZIndexProperty);
            Assert.IsNotNull(retval, "GetValue(Canvas.ZIndexProperty) should not have returned null");
            Assert.IsTrue(retval is int, "GetValue(Canvas.ZIndexProperty) is not of the correct type");
            Assert.AreEqual(0, retval, "GetValue(Canvas.ZIndexProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_GetValue_Panel ()
        {
            InkPresenter widget = new InkPresenter ();
            object retval;

            retval = widget.GetValue(Panel.BackgroundProperty);
            Assert.IsNull(retval, "GetValue(Panel.BackgroundProperty) should have returned null");
        }

        [TestMethod]
        public void Test_GetValue_FrameworkElement ()
        {
            InkPresenter widget = new InkPresenter ();
            object retval;

            retval = widget.GetValue(FrameworkElement.LanguageProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.LanguageProperty) should not have returned null");
            Assert.IsTrue(retval is XmlLanguage, "GetValue(FrameworkElement.LanguageProperty) is not of the correct type");
            Assert.AreEqual("en-us", ((XmlLanguage) retval).IetfLanguageTag, "GetValue(FrameworkElement.LanguageProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.ActualWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.ActualWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.ActualWidthProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.ActualWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.ActualHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.ActualHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.ActualHeightProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.ActualHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.WidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.WidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.WidthProperty) is not of the correct type");
            Assert.IsTrue(Double.IsNaN((double) retval), "GetValue(FrameworkElement.WidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.HeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.HeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.HeightProperty) is not of the correct type");
            Assert.IsTrue(Double.IsNaN((double) retval), "GetValue(FrameworkElement.HeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MinWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MinWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MinWidthProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.MinWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MaxWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MaxWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MaxWidthProperty) is not of the correct type");
            Assert.IsTrue(Double.IsPositiveInfinity((double) retval), "GetValue(FrameworkElement.MaxWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MinHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MinHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MinHeightProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.MinHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MaxHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MaxHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MaxHeightProperty) is not of the correct type");
            Assert.IsTrue(Double.IsPositiveInfinity((double) retval), "GetValue(FrameworkElement.MaxHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.HorizontalAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.HorizontalAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is HorizontalAlignment, "GetValue(FrameworkElement.HorizontalAlignmentProperty) is not of the correct type");
            Assert.AreEqual(HorizontalAlignment.Stretch, retval, "GetValue(FrameworkElement.HorizontalAlignmentProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.VerticalAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.VerticalAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is VerticalAlignment, "GetValue(FrameworkElement.VerticalAlignmentProperty) is not of the correct type");
            Assert.AreEqual(VerticalAlignment.Stretch, retval, "GetValue(FrameworkElement.VerticalAlignmentProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MarginProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MarginProperty) should not have returned null");
            Assert.IsTrue(retval is Thickness, "GetValue(FrameworkElement.MarginProperty) is not of the correct type");
            Assert.AreEqual("0,0,0,0", retval.ToString (), "GetValue(FrameworkElement.MarginProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.StyleProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.StyleProperty) should have returned null");
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.NameProperty) should not have returned null");
            Assert.IsTrue(retval is string, "GetValue(FrameworkElement.NameProperty) is not of the correct type");
            Assert.AreEqual("", retval, "GetValue(FrameworkElement.NameProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.TagProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.TagProperty) should have returned null");
            retval = widget.GetValue(FrameworkElement.DataContextProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.DataContextProperty) should have returned null");
        }

        [TestMethod]
        public void Test_GetValue_UIElement ()
        {
            InkPresenter widget = new InkPresenter ();
            object retval;

            retval = widget.GetValue(UIElement.OpacityProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.OpacityProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(UIElement.OpacityProperty) is not of the correct type");
            Assert.AreEqual((double) 1, retval, "GetValue(UIElement.OpacityProperty) does not match the default value");
            retval = widget.GetValue(UIElement.ClipProperty);
            Assert.IsNull(retval, "GetValue(UIElement.ClipProperty) should have returned null");
            retval = widget.GetValue(UIElement.RenderTransformProperty);
            Assert.IsNull(retval, "GetValue(UIElement.RenderTransformProperty) should have returned null");
            retval = widget.GetValue(UIElement.OpacityMaskProperty);
            Assert.IsNull(retval, "GetValue(UIElement.OpacityMaskProperty) should have returned null");
            retval = widget.GetValue(UIElement.RenderTransformOriginProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.RenderTransformOriginProperty) should not have returned null");
            Assert.IsTrue(retval is Point, "GetValue(UIElement.RenderTransformOriginProperty) is not of the correct type");
            Assert.AreEqual("0,0", retval.ToString (), "GetValue(UIElement.RenderTransformOriginProperty) does not match the default value");
            retval = widget.GetValue(UIElement.IsHitTestVisibleProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.IsHitTestVisibleProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(UIElement.IsHitTestVisibleProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(UIElement.IsHitTestVisibleProperty) does not match the default value");
            retval = widget.GetValue(UIElement.VisibilityProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.VisibilityProperty) should not have returned null");
            Assert.IsTrue(retval is Visibility, "GetValue(UIElement.VisibilityProperty) is not of the correct type");
            Assert.AreEqual(Visibility.Visible, retval, "GetValue(UIElement.VisibilityProperty) does not match the default value");
            retval = widget.GetValue(UIElement.UseLayoutRoundingProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.UseLayoutRoundingProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(UIElement.UseLayoutRoundingProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(UIElement.UseLayoutRoundingProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_InkPresenter ()
        {
            InkPresenter widget = new InkPresenter ();

            Assert.IsNotNull(widget.Strokes, "Strokes should not have returned null");
            Assert.IsTrue(widget.Strokes is StrokeCollection, "Strokes is not of the correct type");
            Assert.IsNotNull(widget.Children, "Children should not have returned null");
            Assert.IsTrue(widget.Children is UIElementCollection, "Children is not of the correct type");
            Assert.IsNull(widget.Background, "Background should have returned null");
            Assert.IsNotNull(widget.Triggers, "Triggers should not have returned null");
            Assert.IsTrue(widget.Triggers is TriggerCollection, "Triggers is not of the correct type");
            Assert.IsNotNull(widget.Resources, "Resources should not have returned null");
            Assert.IsTrue(widget.Resources is ResourceDictionary, "Resources is not of the correct type");
            Assert.AreEqual((double) 0, widget.ActualWidth, "ActualWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.ActualHeight, "ActualHeight does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Width), "Width does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Height), "Height does not match the default value");
            Assert.AreEqual((double) 0, widget.MinWidth, "MinWidth does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxWidth), "MaxWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.MinHeight, "MinHeight does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxHeight), "MaxHeight does not match the default value");
            Assert.AreEqual(HorizontalAlignment.Stretch, widget.HorizontalAlignment, "HorizontalAlignment does not match the default value");
            Assert.AreEqual(VerticalAlignment.Stretch, widget.VerticalAlignment, "VerticalAlignment does not match the default value");
            Assert.AreEqual("0,0,0,0", widget.Margin.ToString (), "Margin does not match the default value");
            Assert.IsNull(widget.Style, "Style should have returned null");
            Assert.IsNull(widget.Parent, "Parent should have returned null");
            Assert.IsNotNull(widget.Name, "Name should not have returned null");
            Assert.AreEqual("", widget.Name, "Name does not match the default value");
            Assert.IsNull(widget.Tag, "Tag should have returned null");
            Assert.IsNull(widget.Cursor, "Cursor should have returned null");
            Assert.IsNotNull(widget.Language, "Language should not have returned null");
            Assert.AreEqual("en-us", widget.Language.IetfLanguageTag, "Language does not match the default value");
            Assert.IsNull(widget.DataContext, "DataContext should have returned null");
            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNull(widget.Clip, "Clip should have returned null");
            Assert.IsNull(widget.OpacityMask, "OpacityMask should have returned null");
            Assert.AreEqual("0,0", widget.RenderTransformOrigin.ToString (), "RenderTransformOrigin does not match the default value");
            Assert.AreEqual(true, widget.IsHitTestVisible, "IsHitTestVisible does not match the default value");
            Assert.AreEqual(Visibility.Visible, widget.Visibility, "Visibility does not match the default value");
            Assert.AreEqual("0,0", widget.RenderSize.ToString (), "RenderSize does not match the default value");
            Assert.AreEqual(true, widget.UseLayoutRounding, "UseLayoutRounding does not match the default value");
            Assert.AreEqual("0,0", widget.DesiredSize.ToString (), "DesiredSize does not match the default value");
            Assert.IsNotNull(widget.RenderTransform, "RenderTransform should not have returned null");
            Assert.IsTrue(widget.RenderTransform is MatrixTransform, "RenderTransform is not of the correct type");
        }

        [TestMethod]
        public void Test_PropertyGetter_Panel ()
        {
            InkPresenter widget = new InkPresenter ();

            Assert.IsNotNull(widget.Children, "Children should not have returned null");
            Assert.IsTrue(widget.Children is UIElementCollection, "Children is not of the correct type");
            Assert.IsNull(widget.Background, "Background should have returned null");
            Assert.IsNotNull(widget.Triggers, "Triggers should not have returned null");
            Assert.IsTrue(widget.Triggers is TriggerCollection, "Triggers is not of the correct type");
            Assert.IsNotNull(widget.Resources, "Resources should not have returned null");
            Assert.IsTrue(widget.Resources is ResourceDictionary, "Resources is not of the correct type");
            Assert.AreEqual((double) 0, widget.ActualWidth, "ActualWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.ActualHeight, "ActualHeight does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Width), "Width does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Height), "Height does not match the default value");
            Assert.AreEqual((double) 0, widget.MinWidth, "MinWidth does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxWidth), "MaxWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.MinHeight, "MinHeight does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxHeight), "MaxHeight does not match the default value");
            Assert.AreEqual(HorizontalAlignment.Stretch, widget.HorizontalAlignment, "HorizontalAlignment does not match the default value");
            Assert.AreEqual(VerticalAlignment.Stretch, widget.VerticalAlignment, "VerticalAlignment does not match the default value");
            Assert.AreEqual("0,0,0,0", widget.Margin.ToString (), "Margin does not match the default value");
            Assert.IsNull(widget.Style, "Style should have returned null");
            Assert.IsNull(widget.Parent, "Parent should have returned null");
            Assert.IsNotNull(widget.Name, "Name should not have returned null");
            Assert.AreEqual("", widget.Name, "Name does not match the default value");
            Assert.IsNull(widget.Tag, "Tag should have returned null");
            Assert.IsNull(widget.Cursor, "Cursor should have returned null");
            Assert.IsNotNull(widget.Language, "Language should not have returned null");
            Assert.AreEqual("en-us", widget.Language.IetfLanguageTag, "Language does not match the default value");
            Assert.IsNull(widget.DataContext, "DataContext should have returned null");
            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNull(widget.Clip, "Clip should have returned null");
            Assert.IsNull(widget.OpacityMask, "OpacityMask should have returned null");
            Assert.AreEqual("0,0", widget.RenderTransformOrigin.ToString (), "RenderTransformOrigin does not match the default value");
            Assert.AreEqual(true, widget.IsHitTestVisible, "IsHitTestVisible does not match the default value");
            Assert.AreEqual(Visibility.Visible, widget.Visibility, "Visibility does not match the default value");
            Assert.AreEqual("0,0", widget.RenderSize.ToString (), "RenderSize does not match the default value");
            Assert.AreEqual(true, widget.UseLayoutRounding, "UseLayoutRounding does not match the default value");
            Assert.AreEqual("0,0", widget.DesiredSize.ToString (), "DesiredSize does not match the default value");
            Assert.IsNotNull(widget.RenderTransform, "RenderTransform should not have returned null");
            Assert.IsTrue(widget.RenderTransform is MatrixTransform, "RenderTransform is not of the correct type");
        }

        [TestMethod]
        public void Test_PropertyGetter_UIElement ()
        {
            InkPresenter widget = new InkPresenter ();

            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNull(widget.Clip, "Clip should have returned null");
            Assert.IsNull(widget.OpacityMask, "OpacityMask should have returned null");
            Assert.AreEqual("0,0", widget.RenderTransformOrigin.ToString (), "RenderTransformOrigin does not match the default value");
            Assert.AreEqual(true, widget.IsHitTestVisible, "IsHitTestVisible does not match the default value");
            Assert.AreEqual(Visibility.Visible, widget.Visibility, "Visibility does not match the default value");
            Assert.AreEqual("0,0", widget.RenderSize.ToString (), "RenderSize does not match the default value");
            Assert.AreEqual(true, widget.UseLayoutRounding, "UseLayoutRounding does not match the default value");
            Assert.AreEqual("0,0", widget.DesiredSize.ToString (), "DesiredSize does not match the default value");
            Assert.IsNotNull(widget.RenderTransform, "RenderTransform should not have returned null");
            Assert.IsTrue(widget.RenderTransform is MatrixTransform, "RenderTransform is not of the correct type");
        }

        [TestMethod]
	[MoonlightBug]
        public void Test_SetStringValue_FrameworkElement ()
        {
            InkPresenter widget = new InkPresenter ();
            object retval;

            widget.SetValue(FrameworkElement.NameProperty, "some text");
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.AreEqual("some text", retval, "GetValue(FrameworkElement.NameProperty) should have returned 'some text'");
            widget.SetValue(FrameworkElement.NameProperty, null);
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.AreEqual(String.Empty, retval, "GetValue(FrameworkElement.NameProperty) should have returned String.Empty");
            retval = widget.ReadLocalValue(FrameworkElement.NameProperty);
            Assert.AreEqual(String.Empty, retval, "ReadLocalValue(FrameworkElement.NameProperty) should have returned String.Empty");
        }

    }
}
namespace MoonTest.System.Windows.Controls
{
    public partial class MultiScaleImageTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_MultiScaleImage ()
        {
            MultiScaleImage widget = new MultiScaleImage ();
            object retval;

            retval = widget.ReadLocalValue(MultiScaleImage.SourceProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(MultiScaleImage.SourceProperty) should not have a value by default");
            retval = widget.ReadLocalValue(MultiScaleImage.ViewportOriginProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(MultiScaleImage.ViewportOriginProperty) should not have a value by default");
            retval = widget.ReadLocalValue(MultiScaleImage.ViewportWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(MultiScaleImage.ViewportWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(MultiScaleImage.AspectRatioProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(MultiScaleImage.AspectRatioProperty) should not have a value by default");
            retval = widget.ReadLocalValue(MultiScaleImage.UseSpringsProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(MultiScaleImage.UseSpringsProperty) should not have a value by default");
            // [MoonlightBug] - Moonlight needs to be fixed to throw on some ReadLocalValue invocations
            //Assert.Throws<Exception>(delegate {
            //    retval = widget.ReadLocalValue(MultiScaleImage.SubImagesProperty);
            //}, "ReadLocalValue(MultiScaleImage.SubImagesProperty) should thow an exception");
        }

        [TestMethod]
        public void Test_ReadLocalValue_FrameworkElement ()
        {
            MultiScaleImage widget = new MultiScaleImage ();
            object retval;

            retval = widget.ReadLocalValue(FrameworkElement.LanguageProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.LanguageProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.ActualWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.ActualWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.ActualHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.ActualHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.WidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.WidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.HeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.HeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MinWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MinWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MaxWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MaxWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MinHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MinHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MaxHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MaxHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.HorizontalAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.HorizontalAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.VerticalAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.VerticalAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MarginProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MarginProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.StyleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.StyleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.NameProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.NameProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.TagProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.TagProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.DataContextProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.DataContextProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_UIElement ()
        {
            MultiScaleImage widget = new MultiScaleImage ();
            object retval;

            retval = widget.ReadLocalValue(UIElement.OpacityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.OpacityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.ClipProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.ClipProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.RenderTransformProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.RenderTransformProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.OpacityMaskProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.OpacityMaskProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.RenderTransformOriginProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.RenderTransformOriginProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.IsHitTestVisibleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.IsHitTestVisibleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.VisibilityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.VisibilityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.UseLayoutRoundingProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.UseLayoutRoundingProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_MultiScaleImage ()
        {
            MultiScaleImage widget = new MultiScaleImage ();
            object retval;

            retval = widget.GetValue(MultiScaleImage.SourceProperty);
            Assert.IsNull(retval, "GetValue(MultiScaleImage.SourceProperty) should have returned null");
            retval = widget.GetValue(MultiScaleImage.ViewportOriginProperty);
            Assert.IsNotNull(retval, "GetValue(MultiScaleImage.ViewportOriginProperty) should not have returned null");
            Assert.IsTrue(retval is Point, "GetValue(MultiScaleImage.ViewportOriginProperty) is not of the correct type");
            Assert.AreEqual("0,0", retval.ToString (), "GetValue(MultiScaleImage.ViewportOriginProperty) does not match the default value");
            retval = widget.GetValue(MultiScaleImage.ViewportWidthProperty);
            Assert.IsNotNull(retval, "GetValue(MultiScaleImage.ViewportWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(MultiScaleImage.ViewportWidthProperty) is not of the correct type");
            Assert.AreEqual((double) 1, retval, "GetValue(MultiScaleImage.ViewportWidthProperty) does not match the default value");
            retval = widget.GetValue(MultiScaleImage.AspectRatioProperty);
            Assert.IsNotNull(retval, "GetValue(MultiScaleImage.AspectRatioProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(MultiScaleImage.AspectRatioProperty) is not of the correct type");
            Assert.AreEqual((double) 1, retval, "GetValue(MultiScaleImage.AspectRatioProperty) does not match the default value");
            retval = widget.GetValue(MultiScaleImage.UseSpringsProperty);
            Assert.IsNotNull(retval, "GetValue(MultiScaleImage.UseSpringsProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(MultiScaleImage.UseSpringsProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(MultiScaleImage.UseSpringsProperty) does not match the default value");
            retval = widget.GetValue(MultiScaleImage.SubImagesProperty);
            Assert.IsNotNull(retval, "GetValue(MultiScaleImage.SubImagesProperty) should not have returned null");
        }

        [TestMethod]
        public void Test_GetValue_FrameworkElement ()
        {
            MultiScaleImage widget = new MultiScaleImage ();
            object retval;

            retval = widget.GetValue(FrameworkElement.LanguageProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.LanguageProperty) should not have returned null");
            Assert.IsTrue(retval is XmlLanguage, "GetValue(FrameworkElement.LanguageProperty) is not of the correct type");
            Assert.AreEqual("en-us", ((XmlLanguage) retval).IetfLanguageTag, "GetValue(FrameworkElement.LanguageProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.ActualWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.ActualWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.ActualWidthProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.ActualWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.ActualHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.ActualHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.ActualHeightProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.ActualHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.WidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.WidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.WidthProperty) is not of the correct type");
            Assert.IsTrue(Double.IsNaN((double) retval), "GetValue(FrameworkElement.WidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.HeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.HeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.HeightProperty) is not of the correct type");
            Assert.IsTrue(Double.IsNaN((double) retval), "GetValue(FrameworkElement.HeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MinWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MinWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MinWidthProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.MinWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MaxWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MaxWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MaxWidthProperty) is not of the correct type");
            Assert.IsTrue(Double.IsPositiveInfinity((double) retval), "GetValue(FrameworkElement.MaxWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MinHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MinHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MinHeightProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.MinHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MaxHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MaxHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MaxHeightProperty) is not of the correct type");
            Assert.IsTrue(Double.IsPositiveInfinity((double) retval), "GetValue(FrameworkElement.MaxHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.HorizontalAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.HorizontalAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is HorizontalAlignment, "GetValue(FrameworkElement.HorizontalAlignmentProperty) is not of the correct type");
            Assert.AreEqual(HorizontalAlignment.Stretch, retval, "GetValue(FrameworkElement.HorizontalAlignmentProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.VerticalAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.VerticalAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is VerticalAlignment, "GetValue(FrameworkElement.VerticalAlignmentProperty) is not of the correct type");
            Assert.AreEqual(VerticalAlignment.Stretch, retval, "GetValue(FrameworkElement.VerticalAlignmentProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MarginProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MarginProperty) should not have returned null");
            Assert.IsTrue(retval is Thickness, "GetValue(FrameworkElement.MarginProperty) is not of the correct type");
            Assert.AreEqual("0,0,0,0", retval.ToString (), "GetValue(FrameworkElement.MarginProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.StyleProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.StyleProperty) should have returned null");
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.NameProperty) should not have returned null");
            Assert.IsTrue(retval is string, "GetValue(FrameworkElement.NameProperty) is not of the correct type");
            Assert.AreEqual("", retval, "GetValue(FrameworkElement.NameProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.TagProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.TagProperty) should have returned null");
            retval = widget.GetValue(FrameworkElement.DataContextProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.DataContextProperty) should have returned null");
        }

        [TestMethod]
        public void Test_GetValue_UIElement ()
        {
            MultiScaleImage widget = new MultiScaleImage ();
            object retval;

            retval = widget.GetValue(UIElement.OpacityProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.OpacityProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(UIElement.OpacityProperty) is not of the correct type");
            Assert.AreEqual((double) 1, retval, "GetValue(UIElement.OpacityProperty) does not match the default value");
            retval = widget.GetValue(UIElement.ClipProperty);
            Assert.IsNull(retval, "GetValue(UIElement.ClipProperty) should have returned null");
            retval = widget.GetValue(UIElement.RenderTransformProperty);
            Assert.IsNull(retval, "GetValue(UIElement.RenderTransformProperty) should have returned null");
            retval = widget.GetValue(UIElement.OpacityMaskProperty);
            Assert.IsNull(retval, "GetValue(UIElement.OpacityMaskProperty) should have returned null");
            retval = widget.GetValue(UIElement.RenderTransformOriginProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.RenderTransformOriginProperty) should not have returned null");
            Assert.IsTrue(retval is Point, "GetValue(UIElement.RenderTransformOriginProperty) is not of the correct type");
            Assert.AreEqual("0,0", retval.ToString (), "GetValue(UIElement.RenderTransformOriginProperty) does not match the default value");
            retval = widget.GetValue(UIElement.IsHitTestVisibleProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.IsHitTestVisibleProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(UIElement.IsHitTestVisibleProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(UIElement.IsHitTestVisibleProperty) does not match the default value");
            retval = widget.GetValue(UIElement.VisibilityProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.VisibilityProperty) should not have returned null");
            Assert.IsTrue(retval is Visibility, "GetValue(UIElement.VisibilityProperty) is not of the correct type");
            Assert.AreEqual(Visibility.Visible, retval, "GetValue(UIElement.VisibilityProperty) does not match the default value");
            retval = widget.GetValue(UIElement.UseLayoutRoundingProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.UseLayoutRoundingProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(UIElement.UseLayoutRoundingProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(UIElement.UseLayoutRoundingProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_MultiScaleImage ()
        {
            MultiScaleImage widget = new MultiScaleImage ();

            Assert.IsNull(widget.Source, "Source should have returned null");
            Assert.AreEqual("0,0", widget.ViewportOrigin.ToString (), "ViewportOrigin does not match the default value");
            Assert.AreEqual((double) 1, widget.ViewportWidth, "ViewportWidth does not match the default value");
            Assert.AreEqual((double) 1, widget.AspectRatio, "AspectRatio does not match the default value");
            Assert.AreEqual(true, widget.UseSprings, "UseSprings does not match the default value");
            Assert.IsNotNull(widget.SubImages, "SubImages should not have returned null");
            Assert.IsNotNull(widget.Triggers, "Triggers should not have returned null");
            Assert.IsTrue(widget.Triggers is TriggerCollection, "Triggers is not of the correct type");
            Assert.IsNotNull(widget.Resources, "Resources should not have returned null");
            Assert.IsTrue(widget.Resources is ResourceDictionary, "Resources is not of the correct type");
            Assert.AreEqual((double) 0, widget.ActualWidth, "ActualWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.ActualHeight, "ActualHeight does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Width), "Width does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Height), "Height does not match the default value");
            Assert.AreEqual((double) 0, widget.MinWidth, "MinWidth does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxWidth), "MaxWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.MinHeight, "MinHeight does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxHeight), "MaxHeight does not match the default value");
            Assert.AreEqual(HorizontalAlignment.Stretch, widget.HorizontalAlignment, "HorizontalAlignment does not match the default value");
            Assert.AreEqual(VerticalAlignment.Stretch, widget.VerticalAlignment, "VerticalAlignment does not match the default value");
            Assert.AreEqual("0,0,0,0", widget.Margin.ToString (), "Margin does not match the default value");
            Assert.IsNull(widget.Style, "Style should have returned null");
            Assert.IsNull(widget.Parent, "Parent should have returned null");
            Assert.IsNotNull(widget.Name, "Name should not have returned null");
            Assert.AreEqual("", widget.Name, "Name does not match the default value");
            Assert.IsNull(widget.Tag, "Tag should have returned null");
            Assert.IsNull(widget.Cursor, "Cursor should have returned null");
            Assert.IsNotNull(widget.Language, "Language should not have returned null");
            Assert.AreEqual("en-us", widget.Language.IetfLanguageTag, "Language does not match the default value");
            Assert.IsNull(widget.DataContext, "DataContext should have returned null");
            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNull(widget.Clip, "Clip should have returned null");
            Assert.IsNull(widget.OpacityMask, "OpacityMask should have returned null");
            Assert.AreEqual("0,0", widget.RenderTransformOrigin.ToString (), "RenderTransformOrigin does not match the default value");
            Assert.AreEqual(true, widget.IsHitTestVisible, "IsHitTestVisible does not match the default value");
            Assert.AreEqual(Visibility.Visible, widget.Visibility, "Visibility does not match the default value");
            Assert.AreEqual("0,0", widget.RenderSize.ToString (), "RenderSize does not match the default value");
            Assert.AreEqual(true, widget.UseLayoutRounding, "UseLayoutRounding does not match the default value");
            Assert.AreEqual("0,0", widget.DesiredSize.ToString (), "DesiredSize does not match the default value");
            Assert.IsNotNull(widget.RenderTransform, "RenderTransform should not have returned null");
            Assert.IsTrue(widget.RenderTransform is MatrixTransform, "RenderTransform is not of the correct type");
        }

        [TestMethod]
        public void Test_PropertyGetter_UIElement ()
        {
            MultiScaleImage widget = new MultiScaleImage ();

            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNull(widget.Clip, "Clip should have returned null");
            Assert.IsNull(widget.OpacityMask, "OpacityMask should have returned null");
            Assert.AreEqual("0,0", widget.RenderTransformOrigin.ToString (), "RenderTransformOrigin does not match the default value");
            Assert.AreEqual(true, widget.IsHitTestVisible, "IsHitTestVisible does not match the default value");
            Assert.AreEqual(Visibility.Visible, widget.Visibility, "Visibility does not match the default value");
            Assert.AreEqual("0,0", widget.RenderSize.ToString (), "RenderSize does not match the default value");
            Assert.AreEqual(true, widget.UseLayoutRounding, "UseLayoutRounding does not match the default value");
            Assert.AreEqual("0,0", widget.DesiredSize.ToString (), "DesiredSize does not match the default value");
            Assert.IsNotNull(widget.RenderTransform, "RenderTransform should not have returned null");
            Assert.IsTrue(widget.RenderTransform is MatrixTransform, "RenderTransform is not of the correct type");
        }

        [TestMethod]
	[MoonlightBug]
        public void Test_SetStringValue_FrameworkElement ()
        {
            MultiScaleImage widget = new MultiScaleImage ();
            object retval;

            widget.SetValue(FrameworkElement.NameProperty, "some text");
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.AreEqual("some text", retval, "GetValue(FrameworkElement.NameProperty) should have returned 'some text'");
            widget.SetValue(FrameworkElement.NameProperty, null);
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.AreEqual(String.Empty, retval, "GetValue(FrameworkElement.NameProperty) should have returned String.Empty");
            retval = widget.ReadLocalValue(FrameworkElement.NameProperty);
            Assert.AreEqual(String.Empty, retval, "ReadLocalValue(FrameworkElement.NameProperty) should have returned String.Empty");
        }

    }
}
namespace MoonTest.System.Windows.Controls
{
    public partial class MultiScaleSubImageTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_MultiScaleSubImage ()
        {
            MultiScaleSubImage widget = new MultiScaleSubImage ();
            object retval;

            retval = widget.ReadLocalValue(MultiScaleSubImage.ViewportOriginProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(MultiScaleSubImage.ViewportOriginProperty) should not have a value by default");
            retval = widget.ReadLocalValue(MultiScaleSubImage.ViewportWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(MultiScaleSubImage.ViewportWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(MultiScaleSubImage.AspectRatioProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(MultiScaleSubImage.AspectRatioProperty) should not have a value by default");
            retval = widget.ReadLocalValue(MultiScaleSubImage.ZIndexProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(MultiScaleSubImage.ZIndexProperty) should not have a value by default");
            retval = widget.ReadLocalValue(MultiScaleSubImage.OpacityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(MultiScaleSubImage.OpacityProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_MultiScaleSubImage ()
        {
            MultiScaleSubImage widget = new MultiScaleSubImage ();
            object retval;

            retval = widget.GetValue(MultiScaleSubImage.ViewportOriginProperty);
            Assert.IsNotNull(retval, "GetValue(MultiScaleSubImage.ViewportOriginProperty) should not have returned null");
            Assert.IsTrue(retval is Point, "GetValue(MultiScaleSubImage.ViewportOriginProperty) is not of the correct type");
            Assert.AreEqual("0,0", retval.ToString (), "GetValue(MultiScaleSubImage.ViewportOriginProperty) does not match the default value");
            retval = widget.GetValue(MultiScaleSubImage.ViewportWidthProperty);
            Assert.IsNotNull(retval, "GetValue(MultiScaleSubImage.ViewportWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(MultiScaleSubImage.ViewportWidthProperty) is not of the correct type");
            Assert.AreEqual((double) 1, retval, "GetValue(MultiScaleSubImage.ViewportWidthProperty) does not match the default value");
            retval = widget.GetValue(MultiScaleSubImage.AspectRatioProperty);
            Assert.IsNotNull(retval, "GetValue(MultiScaleSubImage.AspectRatioProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(MultiScaleSubImage.AspectRatioProperty) is not of the correct type");
            Assert.AreEqual((double) 1, retval, "GetValue(MultiScaleSubImage.AspectRatioProperty) does not match the default value");
            retval = widget.GetValue(MultiScaleSubImage.ZIndexProperty);
            Assert.IsNotNull(retval, "GetValue(MultiScaleSubImage.ZIndexProperty) should not have returned null");
            Assert.IsTrue(retval is int, "GetValue(MultiScaleSubImage.ZIndexProperty) is not of the correct type");
            Assert.AreEqual(0, retval, "GetValue(MultiScaleSubImage.ZIndexProperty) does not match the default value");
            retval = widget.GetValue(MultiScaleSubImage.OpacityProperty);
            Assert.IsNotNull(retval, "GetValue(MultiScaleSubImage.OpacityProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(MultiScaleSubImage.OpacityProperty) is not of the correct type");
            Assert.AreEqual((double) 1, retval, "GetValue(MultiScaleSubImage.OpacityProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_MultiScaleSubImage ()
        {
            MultiScaleSubImage widget = new MultiScaleSubImage ();

            Assert.AreEqual("0,0", widget.ViewportOrigin.ToString (), "ViewportOrigin does not match the default value");
            Assert.AreEqual((double) 1, widget.ViewportWidth, "ViewportWidth does not match the default value");
            Assert.AreEqual((double) 1, widget.AspectRatio, "AspectRatio does not match the default value");
            Assert.AreEqual(0, widget.ZIndex, "ZIndex does not match the default value");
            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
        }

    }
}
namespace MoonTest.System.Windows.Controls
{
    public partial class StackPanelTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_StackPanel ()
        {
            StackPanel widget = new StackPanel ();
            object retval;

            retval = widget.ReadLocalValue(StackPanel.OrientationProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(StackPanel.OrientationProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_Panel ()
        {
            StackPanel widget = new StackPanel ();
            object retval;

            retval = widget.ReadLocalValue(Panel.BackgroundProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Panel.BackgroundProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_FrameworkElement ()
        {
            StackPanel widget = new StackPanel ();
            object retval;

            retval = widget.ReadLocalValue(FrameworkElement.LanguageProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.LanguageProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.ActualWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.ActualWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.ActualHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.ActualHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.WidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.WidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.HeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.HeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MinWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MinWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MaxWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MaxWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MinHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MinHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MaxHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MaxHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.HorizontalAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.HorizontalAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.VerticalAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.VerticalAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MarginProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MarginProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.StyleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.StyleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.NameProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.NameProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.TagProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.TagProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.DataContextProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.DataContextProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_UIElement ()
        {
            StackPanel widget = new StackPanel ();
            object retval;

            retval = widget.ReadLocalValue(UIElement.OpacityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.OpacityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.ClipProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.ClipProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.RenderTransformProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.RenderTransformProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.OpacityMaskProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.OpacityMaskProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.RenderTransformOriginProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.RenderTransformOriginProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.IsHitTestVisibleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.IsHitTestVisibleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.VisibilityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.VisibilityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.UseLayoutRoundingProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.UseLayoutRoundingProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_StackPanel ()
        {
            StackPanel widget = new StackPanel ();
            object retval;

            retval = widget.GetValue(StackPanel.OrientationProperty);
            Assert.IsNotNull(retval, "GetValue(StackPanel.OrientationProperty) should not have returned null");
            Assert.IsTrue(retval is Orientation, "GetValue(StackPanel.OrientationProperty) is not of the correct type");
            Assert.AreEqual(Orientation.Vertical, retval, "GetValue(StackPanel.OrientationProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_GetValue_Panel ()
        {
            StackPanel widget = new StackPanel ();
            object retval;

            retval = widget.GetValue(Panel.BackgroundProperty);
            Assert.IsNull(retval, "GetValue(Panel.BackgroundProperty) should have returned null");
        }

        [TestMethod]
        public void Test_GetValue_FrameworkElement ()
        {
            StackPanel widget = new StackPanel ();
            object retval;

            retval = widget.GetValue(FrameworkElement.LanguageProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.LanguageProperty) should not have returned null");
            Assert.IsTrue(retval is XmlLanguage, "GetValue(FrameworkElement.LanguageProperty) is not of the correct type");
            Assert.AreEqual("en-us", ((XmlLanguage) retval).IetfLanguageTag, "GetValue(FrameworkElement.LanguageProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.ActualWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.ActualWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.ActualWidthProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.ActualWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.ActualHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.ActualHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.ActualHeightProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.ActualHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.WidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.WidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.WidthProperty) is not of the correct type");
            Assert.IsTrue(Double.IsNaN((double) retval), "GetValue(FrameworkElement.WidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.HeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.HeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.HeightProperty) is not of the correct type");
            Assert.IsTrue(Double.IsNaN((double) retval), "GetValue(FrameworkElement.HeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MinWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MinWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MinWidthProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.MinWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MaxWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MaxWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MaxWidthProperty) is not of the correct type");
            Assert.IsTrue(Double.IsPositiveInfinity((double) retval), "GetValue(FrameworkElement.MaxWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MinHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MinHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MinHeightProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.MinHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MaxHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MaxHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MaxHeightProperty) is not of the correct type");
            Assert.IsTrue(Double.IsPositiveInfinity((double) retval), "GetValue(FrameworkElement.MaxHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.HorizontalAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.HorizontalAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is HorizontalAlignment, "GetValue(FrameworkElement.HorizontalAlignmentProperty) is not of the correct type");
            Assert.AreEqual(HorizontalAlignment.Stretch, retval, "GetValue(FrameworkElement.HorizontalAlignmentProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.VerticalAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.VerticalAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is VerticalAlignment, "GetValue(FrameworkElement.VerticalAlignmentProperty) is not of the correct type");
            Assert.AreEqual(VerticalAlignment.Stretch, retval, "GetValue(FrameworkElement.VerticalAlignmentProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MarginProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MarginProperty) should not have returned null");
            Assert.IsTrue(retval is Thickness, "GetValue(FrameworkElement.MarginProperty) is not of the correct type");
            Assert.AreEqual("0,0,0,0", retval.ToString (), "GetValue(FrameworkElement.MarginProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.StyleProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.StyleProperty) should have returned null");
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.NameProperty) should not have returned null");
            Assert.IsTrue(retval is string, "GetValue(FrameworkElement.NameProperty) is not of the correct type");
            Assert.AreEqual("", retval, "GetValue(FrameworkElement.NameProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.TagProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.TagProperty) should have returned null");
            retval = widget.GetValue(FrameworkElement.DataContextProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.DataContextProperty) should have returned null");
        }

        [TestMethod]
        public void Test_GetValue_UIElement ()
        {
            StackPanel widget = new StackPanel ();
            object retval;

            retval = widget.GetValue(UIElement.OpacityProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.OpacityProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(UIElement.OpacityProperty) is not of the correct type");
            Assert.AreEqual((double) 1, retval, "GetValue(UIElement.OpacityProperty) does not match the default value");
            retval = widget.GetValue(UIElement.ClipProperty);
            Assert.IsNull(retval, "GetValue(UIElement.ClipProperty) should have returned null");
            retval = widget.GetValue(UIElement.RenderTransformProperty);
            Assert.IsNull(retval, "GetValue(UIElement.RenderTransformProperty) should have returned null");
            retval = widget.GetValue(UIElement.OpacityMaskProperty);
            Assert.IsNull(retval, "GetValue(UIElement.OpacityMaskProperty) should have returned null");
            retval = widget.GetValue(UIElement.RenderTransformOriginProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.RenderTransformOriginProperty) should not have returned null");
            Assert.IsTrue(retval is Point, "GetValue(UIElement.RenderTransformOriginProperty) is not of the correct type");
            Assert.AreEqual("0,0", retval.ToString (), "GetValue(UIElement.RenderTransformOriginProperty) does not match the default value");
            retval = widget.GetValue(UIElement.IsHitTestVisibleProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.IsHitTestVisibleProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(UIElement.IsHitTestVisibleProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(UIElement.IsHitTestVisibleProperty) does not match the default value");
            retval = widget.GetValue(UIElement.VisibilityProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.VisibilityProperty) should not have returned null");
            Assert.IsTrue(retval is Visibility, "GetValue(UIElement.VisibilityProperty) is not of the correct type");
            Assert.AreEqual(Visibility.Visible, retval, "GetValue(UIElement.VisibilityProperty) does not match the default value");
            retval = widget.GetValue(UIElement.UseLayoutRoundingProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.UseLayoutRoundingProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(UIElement.UseLayoutRoundingProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(UIElement.UseLayoutRoundingProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_StackPanel ()
        {
            StackPanel widget = new StackPanel ();

            Assert.AreEqual(Orientation.Vertical, widget.Orientation, "Orientation does not match the default value");
            Assert.IsNotNull(widget.Children, "Children should not have returned null");
            Assert.IsTrue(widget.Children is UIElementCollection, "Children is not of the correct type");
            Assert.IsNull(widget.Background, "Background should have returned null");
            Assert.IsNotNull(widget.Triggers, "Triggers should not have returned null");
            Assert.IsTrue(widget.Triggers is TriggerCollection, "Triggers is not of the correct type");
            Assert.IsNotNull(widget.Resources, "Resources should not have returned null");
            Assert.IsTrue(widget.Resources is ResourceDictionary, "Resources is not of the correct type");
            Assert.AreEqual((double) 0, widget.ActualWidth, "ActualWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.ActualHeight, "ActualHeight does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Width), "Width does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Height), "Height does not match the default value");
            Assert.AreEqual((double) 0, widget.MinWidth, "MinWidth does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxWidth), "MaxWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.MinHeight, "MinHeight does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxHeight), "MaxHeight does not match the default value");
            Assert.AreEqual(HorizontalAlignment.Stretch, widget.HorizontalAlignment, "HorizontalAlignment does not match the default value");
            Assert.AreEqual(VerticalAlignment.Stretch, widget.VerticalAlignment, "VerticalAlignment does not match the default value");
            Assert.AreEqual("0,0,0,0", widget.Margin.ToString (), "Margin does not match the default value");
            Assert.IsNull(widget.Style, "Style should have returned null");
            Assert.IsNull(widget.Parent, "Parent should have returned null");
            Assert.IsNotNull(widget.Name, "Name should not have returned null");
            Assert.AreEqual("", widget.Name, "Name does not match the default value");
            Assert.IsNull(widget.Tag, "Tag should have returned null");
            Assert.IsNull(widget.Cursor, "Cursor should have returned null");
            Assert.IsNotNull(widget.Language, "Language should not have returned null");
            Assert.AreEqual("en-us", widget.Language.IetfLanguageTag, "Language does not match the default value");
            Assert.IsNull(widget.DataContext, "DataContext should have returned null");
            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNull(widget.Clip, "Clip should have returned null");
            Assert.IsNull(widget.OpacityMask, "OpacityMask should have returned null");
            Assert.AreEqual("0,0", widget.RenderTransformOrigin.ToString (), "RenderTransformOrigin does not match the default value");
            Assert.AreEqual(true, widget.IsHitTestVisible, "IsHitTestVisible does not match the default value");
            Assert.AreEqual(Visibility.Visible, widget.Visibility, "Visibility does not match the default value");
            Assert.AreEqual("0,0", widget.RenderSize.ToString (), "RenderSize does not match the default value");
            Assert.AreEqual(true, widget.UseLayoutRounding, "UseLayoutRounding does not match the default value");
            Assert.AreEqual("0,0", widget.DesiredSize.ToString (), "DesiredSize does not match the default value");
            Assert.IsNotNull(widget.RenderTransform, "RenderTransform should not have returned null");
            Assert.IsTrue(widget.RenderTransform is MatrixTransform, "RenderTransform is not of the correct type");
        }

        [TestMethod]
        public void Test_PropertyGetter_FrameworkElement ()
        {
            StackPanel widget = new StackPanel ();

            Assert.IsNotNull(widget.Triggers, "Triggers should not have returned null");
            Assert.IsTrue(widget.Triggers is TriggerCollection, "Triggers is not of the correct type");
            Assert.IsNotNull(widget.Resources, "Resources should not have returned null");
            Assert.IsTrue(widget.Resources is ResourceDictionary, "Resources is not of the correct type");
            Assert.AreEqual((double) 0, widget.ActualWidth, "ActualWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.ActualHeight, "ActualHeight does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Width), "Width does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Height), "Height does not match the default value");
            Assert.AreEqual((double) 0, widget.MinWidth, "MinWidth does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxWidth), "MaxWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.MinHeight, "MinHeight does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxHeight), "MaxHeight does not match the default value");
            Assert.AreEqual(HorizontalAlignment.Stretch, widget.HorizontalAlignment, "HorizontalAlignment does not match the default value");
            Assert.AreEqual(VerticalAlignment.Stretch, widget.VerticalAlignment, "VerticalAlignment does not match the default value");
            Assert.AreEqual("0,0,0,0", widget.Margin.ToString (), "Margin does not match the default value");
            Assert.IsNull(widget.Style, "Style should have returned null");
            Assert.IsNull(widget.Parent, "Parent should have returned null");
            Assert.IsNotNull(widget.Name, "Name should not have returned null");
            Assert.AreEqual("", widget.Name, "Name does not match the default value");
            Assert.IsNull(widget.Tag, "Tag should have returned null");
            Assert.IsNull(widget.Cursor, "Cursor should have returned null");
            Assert.IsNotNull(widget.Language, "Language should not have returned null");
            Assert.AreEqual("en-us", widget.Language.IetfLanguageTag, "Language does not match the default value");
            Assert.IsNull(widget.DataContext, "DataContext should have returned null");
            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNull(widget.Clip, "Clip should have returned null");
            Assert.IsNull(widget.OpacityMask, "OpacityMask should have returned null");
            Assert.AreEqual("0,0", widget.RenderTransformOrigin.ToString (), "RenderTransformOrigin does not match the default value");
            Assert.AreEqual(true, widget.IsHitTestVisible, "IsHitTestVisible does not match the default value");
            Assert.AreEqual(Visibility.Visible, widget.Visibility, "Visibility does not match the default value");
            Assert.AreEqual("0,0", widget.RenderSize.ToString (), "RenderSize does not match the default value");
            Assert.AreEqual(true, widget.UseLayoutRounding, "UseLayoutRounding does not match the default value");
            Assert.AreEqual("0,0", widget.DesiredSize.ToString (), "DesiredSize does not match the default value");
            Assert.IsNotNull(widget.RenderTransform, "RenderTransform should not have returned null");
            Assert.IsTrue(widget.RenderTransform is MatrixTransform, "RenderTransform is not of the correct type");
        }

        [TestMethod]
	[MoonlightBug]
        public void Test_SetStringValue_FrameworkElement ()
        {
            StackPanel widget = new StackPanel ();
            object retval;

            widget.SetValue(FrameworkElement.NameProperty, "some text");
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.AreEqual("some text", retval, "GetValue(FrameworkElement.NameProperty) should have returned 'some text'");
            widget.SetValue(FrameworkElement.NameProperty, null);
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.AreEqual(String.Empty, retval, "GetValue(FrameworkElement.NameProperty) should have returned String.Empty");
            retval = widget.ReadLocalValue(FrameworkElement.NameProperty);
            Assert.AreEqual(String.Empty, retval, "ReadLocalValue(FrameworkElement.NameProperty) should have returned String.Empty");
        }

    }
}
namespace MoonTest.System.Windows.Controls
{
    public partial class TextBoxTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_TextBox ()
        {
            TextBox widget = new TextBox ();
            object retval;

            retval = widget.ReadLocalValue(TextBox.TextProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(TextBox.TextProperty) should not have a value by default");
            retval = widget.ReadLocalValue(TextBox.MaxLengthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(TextBox.MaxLengthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(TextBox.IsReadOnlyProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(TextBox.IsReadOnlyProperty) should not have a value by default");
            retval = widget.ReadLocalValue(TextBox.AcceptsReturnProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(TextBox.AcceptsReturnProperty) should not have a value by default");
            retval = widget.ReadLocalValue(TextBox.SelectionBackgroundProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(TextBox.SelectionBackgroundProperty) should not have a value by default");
            retval = widget.ReadLocalValue(TextBox.SelectionForegroundProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(TextBox.SelectionForegroundProperty) should not have a value by default");
            retval = widget.ReadLocalValue(TextBox.TextAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(TextBox.TextAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(TextBox.TextWrappingProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(TextBox.TextWrappingProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_Control ()
        {
            TextBox widget = new TextBox ();
            object retval;

            retval = widget.ReadLocalValue(Control.IsTabStopProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.IsTabStopProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.TabIndexProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.TabIndexProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.TemplateProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.TemplateProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.TabNavigationProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.TabNavigationProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.PaddingProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.PaddingProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.HorizontalContentAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.HorizontalContentAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.VerticalContentAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.VerticalContentAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.BackgroundProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.BackgroundProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.BorderBrushProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.BorderBrushProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.BorderThicknessProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.BorderThicknessProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.FontSizeProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.FontSizeProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.FontFamilyProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.FontFamilyProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.ForegroundProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.ForegroundProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.FontWeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.FontWeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.FontStyleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.FontStyleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.FontStretchProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.FontStretchProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.IsEnabledProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.IsEnabledProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_FrameworkElement ()
        {
            TextBox widget = new TextBox ();
            object retval;

            retval = widget.ReadLocalValue(FrameworkElement.LanguageProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.LanguageProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.ActualWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.ActualWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.ActualHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.ActualHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.WidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.WidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.HeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.HeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MinWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MinWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MaxWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MaxWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MinHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MinHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MaxHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MaxHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.HorizontalAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.HorizontalAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.VerticalAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.VerticalAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MarginProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MarginProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.StyleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.StyleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.NameProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.NameProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.TagProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.TagProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.DataContextProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.DataContextProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_UIElement ()
        {
            TextBox widget = new TextBox ();
            object retval;

            retval = widget.ReadLocalValue(UIElement.OpacityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.OpacityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.ClipProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.ClipProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.RenderTransformProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.RenderTransformProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.OpacityMaskProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.OpacityMaskProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.RenderTransformOriginProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.RenderTransformOriginProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.IsHitTestVisibleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.IsHitTestVisibleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.VisibilityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.VisibilityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.UseLayoutRoundingProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.UseLayoutRoundingProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_TextBox ()
        {
            TextBox widget = new TextBox ();
            object retval;

            retval = widget.GetValue(TextBox.TextProperty);
            Assert.IsNull(retval, "GetValue(TextBox.TextProperty) should have returned null");
            retval = widget.GetValue(TextBox.MaxLengthProperty);
            Assert.IsNotNull(retval, "GetValue(TextBox.MaxLengthProperty) should not have returned null");
            Assert.IsTrue(retval is int, "GetValue(TextBox.MaxLengthProperty) is not of the correct type");
            Assert.AreEqual(0, retval, "GetValue(TextBox.MaxLengthProperty) does not match the default value");
            retval = widget.GetValue(TextBox.IsReadOnlyProperty);
            Assert.IsNotNull(retval, "GetValue(TextBox.IsReadOnlyProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(TextBox.IsReadOnlyProperty) is not of the correct type");
            Assert.AreEqual(false, retval, "GetValue(TextBox.IsReadOnlyProperty) does not match the default value");
            retval = widget.GetValue(TextBox.AcceptsReturnProperty);
            Assert.IsNotNull(retval, "GetValue(TextBox.AcceptsReturnProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(TextBox.AcceptsReturnProperty) is not of the correct type");
            Assert.AreEqual(false, retval, "GetValue(TextBox.AcceptsReturnProperty) does not match the default value");
            retval = widget.GetValue(TextBox.SelectionBackgroundProperty);
            Assert.IsNull(retval, "GetValue(TextBox.SelectionBackgroundProperty) should have returned null");
            retval = widget.GetValue(TextBox.SelectionForegroundProperty);
            Assert.IsNull(retval, "GetValue(TextBox.SelectionForegroundProperty) should have returned null");
            retval = widget.GetValue(TextBox.TextAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(TextBox.TextAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is TextAlignment, "GetValue(TextBox.TextAlignmentProperty) is not of the correct type");
            Assert.AreEqual(TextAlignment.Left, retval, "GetValue(TextBox.TextAlignmentProperty) does not match the default value");
            retval = widget.GetValue(TextBox.TextWrappingProperty);
            Assert.IsNotNull(retval, "GetValue(TextBox.TextWrappingProperty) should not have returned null");
            Assert.IsTrue(retval is TextWrapping, "GetValue(TextBox.TextWrappingProperty) is not of the correct type");
            Assert.AreEqual(TextWrapping.NoWrap, retval, "GetValue(TextBox.TextWrappingProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_GetValue_Control ()
        {
            TextBox widget = new TextBox ();
            object retval;

            retval = widget.GetValue(Control.IsTabStopProperty);
            Assert.IsNotNull(retval, "GetValue(Control.IsTabStopProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(Control.IsTabStopProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(Control.IsTabStopProperty) does not match the default value");
            retval = widget.GetValue(Control.TabIndexProperty);
            Assert.IsNotNull(retval, "GetValue(Control.TabIndexProperty) should not have returned null");
            Assert.IsTrue(retval is int, "GetValue(Control.TabIndexProperty) is not of the correct type");
            Assert.AreEqual(2147483647, retval, "GetValue(Control.TabIndexProperty) does not match the default value");
            retval = widget.GetValue(Control.TemplateProperty);
            Assert.IsNull(retval, "GetValue(Control.TemplateProperty) should have returned null");
            retval = widget.GetValue(Control.TabNavigationProperty);
            Assert.IsNotNull(retval, "GetValue(Control.TabNavigationProperty) should not have returned null");
            Assert.IsTrue(retval is KeyboardNavigationMode, "GetValue(Control.TabNavigationProperty) is not of the correct type");
            Assert.AreEqual(KeyboardNavigationMode.Local, retval, "GetValue(Control.TabNavigationProperty) does not match the default value");
            retval = widget.GetValue(Control.PaddingProperty);
            Assert.IsNotNull(retval, "GetValue(Control.PaddingProperty) should not have returned null");
            Assert.IsTrue(retval is Thickness, "GetValue(Control.PaddingProperty) is not of the correct type");
            Assert.AreEqual("0,0,0,0", retval.ToString (), "GetValue(Control.PaddingProperty) does not match the default value");
            retval = widget.GetValue(Control.HorizontalContentAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(Control.HorizontalContentAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is HorizontalAlignment, "GetValue(Control.HorizontalContentAlignmentProperty) is not of the correct type");
            Assert.AreEqual(HorizontalAlignment.Center, retval, "GetValue(Control.HorizontalContentAlignmentProperty) does not match the default value");
            retval = widget.GetValue(Control.VerticalContentAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(Control.VerticalContentAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is VerticalAlignment, "GetValue(Control.VerticalContentAlignmentProperty) is not of the correct type");
            Assert.AreEqual(VerticalAlignment.Center, retval, "GetValue(Control.VerticalContentAlignmentProperty) does not match the default value");
            retval = widget.GetValue(Control.BackgroundProperty);
            Assert.IsNull(retval, "GetValue(Control.BackgroundProperty) should have returned null");
            retval = widget.GetValue(Control.BorderBrushProperty);
            Assert.IsNull(retval, "GetValue(Control.BorderBrushProperty) should have returned null");
            retval = widget.GetValue(Control.BorderThicknessProperty);
            Assert.IsNotNull(retval, "GetValue(Control.BorderThicknessProperty) should not have returned null");
            Assert.IsTrue(retval is Thickness, "GetValue(Control.BorderThicknessProperty) is not of the correct type");
            Assert.AreEqual("0,0,0,0", retval.ToString (), "GetValue(Control.BorderThicknessProperty) does not match the default value");
            retval = widget.GetValue(Control.FontSizeProperty);
            Assert.IsNotNull(retval, "GetValue(Control.FontSizeProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Control.FontSizeProperty) is not of the correct type");
            Assert.AreEqual((double) 11, retval, "GetValue(Control.FontSizeProperty) does not match the default value");
            retval = widget.GetValue(Control.FontFamilyProperty);
            Assert.IsNotNull(retval, "GetValue(Control.FontFamilyProperty) should not have returned null");
            Assert.IsTrue(retval is FontFamily, "GetValue(Control.FontFamilyProperty) is not of the correct type");
            Assert.AreEqual("Portable User Interface", retval.ToString (), "GetValue(Control.FontFamilyProperty) does not match the default value");
            retval = widget.GetValue(Control.ForegroundProperty);
            Assert.IsNotNull(retval, "GetValue(Control.ForegroundProperty) should not have returned null");
            Assert.IsTrue(retval is SolidColorBrush, "GetValue(Control.ForegroundProperty) is not of the correct type");
            retval = widget.GetValue(Control.FontWeightProperty);
            Assert.IsNotNull(retval, "GetValue(Control.FontWeightProperty) should not have returned null");
            Assert.IsTrue(retval is FontWeight, "GetValue(Control.FontWeightProperty) is not of the correct type");
            Assert.AreEqual("Normal", retval.ToString (), "GetValue(Control.FontWeightProperty) does not match the default value");
            retval = widget.GetValue(Control.FontStyleProperty);
            Assert.IsNotNull(retval, "GetValue(Control.FontStyleProperty) should not have returned null");
            Assert.IsTrue(retval is FontStyle, "GetValue(Control.FontStyleProperty) is not of the correct type");
            Assert.AreEqual("Normal", retval.ToString (), "GetValue(Control.FontStyleProperty) does not match the default value");
            retval = widget.GetValue(Control.FontStretchProperty);
            Assert.IsNotNull(retval, "GetValue(Control.FontStretchProperty) should not have returned null");
            Assert.IsTrue(retval is FontStretch, "GetValue(Control.FontStretchProperty) is not of the correct type");
            Assert.AreEqual("Normal", retval.ToString (), "GetValue(Control.FontStretchProperty) does not match the default value");
            retval = widget.GetValue(Control.IsEnabledProperty);
            Assert.IsNotNull(retval, "GetValue(Control.IsEnabledProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(Control.IsEnabledProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(Control.IsEnabledProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_GetValue_FrameworkElement ()
        {
            TextBox widget = new TextBox ();
            object retval;

            retval = widget.GetValue(FrameworkElement.LanguageProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.LanguageProperty) should not have returned null");
            Assert.IsTrue(retval is XmlLanguage, "GetValue(FrameworkElement.LanguageProperty) is not of the correct type");
            Assert.AreEqual("en-us", ((XmlLanguage) retval).IetfLanguageTag, "GetValue(FrameworkElement.LanguageProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.ActualWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.ActualWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.ActualWidthProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.ActualWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.ActualHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.ActualHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.ActualHeightProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.ActualHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.WidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.WidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.WidthProperty) is not of the correct type");
            Assert.IsTrue(Double.IsNaN((double) retval), "GetValue(FrameworkElement.WidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.HeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.HeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.HeightProperty) is not of the correct type");
            Assert.IsTrue(Double.IsNaN((double) retval), "GetValue(FrameworkElement.HeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MinWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MinWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MinWidthProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.MinWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MaxWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MaxWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MaxWidthProperty) is not of the correct type");
            Assert.IsTrue(Double.IsPositiveInfinity((double) retval), "GetValue(FrameworkElement.MaxWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MinHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MinHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MinHeightProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.MinHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MaxHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MaxHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MaxHeightProperty) is not of the correct type");
            Assert.IsTrue(Double.IsPositiveInfinity((double) retval), "GetValue(FrameworkElement.MaxHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.HorizontalAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.HorizontalAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is HorizontalAlignment, "GetValue(FrameworkElement.HorizontalAlignmentProperty) is not of the correct type");
            Assert.AreEqual(HorizontalAlignment.Stretch, retval, "GetValue(FrameworkElement.HorizontalAlignmentProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.VerticalAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.VerticalAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is VerticalAlignment, "GetValue(FrameworkElement.VerticalAlignmentProperty) is not of the correct type");
            Assert.AreEqual(VerticalAlignment.Stretch, retval, "GetValue(FrameworkElement.VerticalAlignmentProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MarginProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MarginProperty) should not have returned null");
            Assert.IsTrue(retval is Thickness, "GetValue(FrameworkElement.MarginProperty) is not of the correct type");
            Assert.AreEqual("0,0,0,0", retval.ToString (), "GetValue(FrameworkElement.MarginProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.StyleProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.StyleProperty) should have returned null");
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.NameProperty) should not have returned null");
            Assert.IsTrue(retval is string, "GetValue(FrameworkElement.NameProperty) is not of the correct type");
            Assert.AreEqual("", retval, "GetValue(FrameworkElement.NameProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.TagProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.TagProperty) should have returned null");
            retval = widget.GetValue(FrameworkElement.DataContextProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.DataContextProperty) should have returned null");
        }

        [TestMethod]
        public void Test_GetValue_UIElement ()
        {
            TextBox widget = new TextBox ();
            object retval;

            retval = widget.GetValue(UIElement.OpacityProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.OpacityProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(UIElement.OpacityProperty) is not of the correct type");
            Assert.AreEqual((double) 1, retval, "GetValue(UIElement.OpacityProperty) does not match the default value");
            retval = widget.GetValue(UIElement.ClipProperty);
            Assert.IsNull(retval, "GetValue(UIElement.ClipProperty) should have returned null");
            retval = widget.GetValue(UIElement.RenderTransformProperty);
            Assert.IsNull(retval, "GetValue(UIElement.RenderTransformProperty) should have returned null");
            retval = widget.GetValue(UIElement.OpacityMaskProperty);
            Assert.IsNull(retval, "GetValue(UIElement.OpacityMaskProperty) should have returned null");
            retval = widget.GetValue(UIElement.RenderTransformOriginProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.RenderTransformOriginProperty) should not have returned null");
            Assert.IsTrue(retval is Point, "GetValue(UIElement.RenderTransformOriginProperty) is not of the correct type");
            Assert.AreEqual("0,0", retval.ToString (), "GetValue(UIElement.RenderTransformOriginProperty) does not match the default value");
            retval = widget.GetValue(UIElement.IsHitTestVisibleProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.IsHitTestVisibleProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(UIElement.IsHitTestVisibleProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(UIElement.IsHitTestVisibleProperty) does not match the default value");
            retval = widget.GetValue(UIElement.VisibilityProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.VisibilityProperty) should not have returned null");
            Assert.IsTrue(retval is Visibility, "GetValue(UIElement.VisibilityProperty) is not of the correct type");
            Assert.AreEqual(Visibility.Visible, retval, "GetValue(UIElement.VisibilityProperty) does not match the default value");
            retval = widget.GetValue(UIElement.UseLayoutRoundingProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.UseLayoutRoundingProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(UIElement.UseLayoutRoundingProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(UIElement.UseLayoutRoundingProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_TextBox ()
        {
            TextBox widget = new TextBox ();

            Assert.AreEqual(false, widget.IsReadOnly, "IsReadOnly does not match the default value");
            Assert.AreEqual(false, widget.AcceptsReturn, "AcceptsReturn does not match the default value");
            Assert.IsNull(widget.SelectionBackground, "SelectionBackground should have returned null");
            Assert.IsNull(widget.SelectionForeground, "SelectionForeground should have returned null");
            Assert.AreEqual(TextAlignment.Left, widget.TextAlignment, "TextAlignment does not match the default value");
            Assert.AreEqual(TextWrapping.NoWrap, widget.TextWrapping, "TextWrapping does not match the default value");
            Assert.IsNull(widget.FontSource, "FontSource should have returned null");
            Assert.IsNotNull(widget.Text, "Text should not have returned null");
            Assert.AreEqual("", widget.Text, "Text does not match the default value");
            Assert.IsNotNull(widget.SelectedText, "SelectedText should not have returned null");
            Assert.AreEqual("", widget.SelectedText, "SelectedText does not match the default value");
            Assert.AreEqual(0, widget.SelectionLength, "SelectionLength does not match the default value");
            Assert.AreEqual(0, widget.SelectionStart, "SelectionStart does not match the default value");
            Assert.AreEqual(0, widget.MaxLength, "MaxLength does not match the default value");
            Assert.AreEqual(ScrollBarVisibility.Hidden, widget.HorizontalScrollBarVisibility, "HorizontalScrollBarVisibility does not match the default value");
            Assert.AreEqual(ScrollBarVisibility.Hidden, widget.VerticalScrollBarVisibility, "VerticalScrollBarVisibility does not match the default value");
            Assert.AreEqual(true, widget.IsTabStop, "IsTabStop does not match the default value");
            Assert.AreEqual(true, widget.IsEnabled, "IsEnabled does not match the default value");
            Assert.AreEqual(2147483647, widget.TabIndex, "TabIndex does not match the default value");
            Assert.AreEqual(KeyboardNavigationMode.Local, widget.TabNavigation, "TabNavigation does not match the default value");
            Assert.IsNull(widget.Template, "Template should have returned null");
            Assert.AreEqual("0,0,0,0", widget.Padding.ToString (), "Padding does not match the default value");
            Assert.AreEqual("0,0,0,0", widget.BorderThickness.ToString (), "BorderThickness does not match the default value");
            Assert.AreEqual(HorizontalAlignment.Center, widget.HorizontalContentAlignment, "HorizontalContentAlignment does not match the default value");
            Assert.AreEqual(VerticalAlignment.Center, widget.VerticalContentAlignment, "VerticalContentAlignment does not match the default value");
            Assert.IsNull(widget.Background, "Background should have returned null");
            Assert.IsNull(widget.BorderBrush, "BorderBrush should have returned null");
            Assert.IsNotNull(widget.FontFamily, "FontFamily should not have returned null");
            Assert.AreEqual("Portable User Interface", widget.FontFamily.ToString (), "FontFamily does not match the default value");
            Assert.AreEqual((double) 11, widget.FontSize, "FontSize does not match the default value");
            Assert.AreEqual("Normal", widget.FontStretch.ToString (), "FontStretch does not match the default value");
            Assert.AreEqual("Normal", widget.FontStyle.ToString (), "FontStyle does not match the default value");
            Assert.AreEqual("Normal", widget.FontWeight.ToString (), "FontWeight does not match the default value");
            Assert.IsNotNull(widget.Foreground, "Foreground should not have returned null");
            Assert.IsTrue(widget.Foreground is SolidColorBrush, "Foreground is not of the correct type");
            Assert.IsNotNull(widget.Triggers, "Triggers should not have returned null");
            Assert.IsTrue(widget.Triggers is TriggerCollection, "Triggers is not of the correct type");
            Assert.IsNotNull(widget.Resources, "Resources should not have returned null");
            Assert.IsTrue(widget.Resources is ResourceDictionary, "Resources is not of the correct type");
            Assert.AreEqual((double) 0, widget.ActualWidth, "ActualWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.ActualHeight, "ActualHeight does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Width), "Width does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Height), "Height does not match the default value");
            Assert.AreEqual((double) 0, widget.MinWidth, "MinWidth does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxWidth), "MaxWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.MinHeight, "MinHeight does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxHeight), "MaxHeight does not match the default value");
            Assert.AreEqual(HorizontalAlignment.Stretch, widget.HorizontalAlignment, "HorizontalAlignment does not match the default value");
            Assert.AreEqual(VerticalAlignment.Stretch, widget.VerticalAlignment, "VerticalAlignment does not match the default value");
            Assert.AreEqual("0,0,0,0", widget.Margin.ToString (), "Margin does not match the default value");
            Assert.IsNull(widget.Style, "Style should have returned null");
            Assert.IsNull(widget.Parent, "Parent should have returned null");
            Assert.IsNotNull(widget.Name, "Name should not have returned null");
            Assert.AreEqual("", widget.Name, "Name does not match the default value");
            Assert.IsNull(widget.Tag, "Tag should have returned null");
            Assert.IsNull(widget.Cursor, "Cursor should have returned null");
            Assert.IsNotNull(widget.Language, "Language should not have returned null");
            Assert.AreEqual("en-us", widget.Language.IetfLanguageTag, "Language does not match the default value");
            Assert.IsNull(widget.DataContext, "DataContext should have returned null");
            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNull(widget.Clip, "Clip should have returned null");
            Assert.IsNull(widget.OpacityMask, "OpacityMask should have returned null");
            Assert.AreEqual("0,0", widget.RenderTransformOrigin.ToString (), "RenderTransformOrigin does not match the default value");
            Assert.AreEqual(true, widget.IsHitTestVisible, "IsHitTestVisible does not match the default value");
            Assert.AreEqual(Visibility.Visible, widget.Visibility, "Visibility does not match the default value");
            Assert.AreEqual("0,0", widget.RenderSize.ToString (), "RenderSize does not match the default value");
            Assert.AreEqual(true, widget.UseLayoutRounding, "UseLayoutRounding does not match the default value");
            Assert.AreEqual("0,0", widget.DesiredSize.ToString (), "DesiredSize does not match the default value");
            Assert.IsNotNull(widget.RenderTransform, "RenderTransform should not have returned null");
            Assert.IsTrue(widget.RenderTransform is MatrixTransform, "RenderTransform is not of the correct type");
        }

        [TestMethod]
        public void Test_PropertyGetter_FrameworkElement ()
        {
            TextBox widget = new TextBox ();

            Assert.IsNotNull(widget.Triggers, "Triggers should not have returned null");
            Assert.IsTrue(widget.Triggers is TriggerCollection, "Triggers is not of the correct type");
            Assert.IsNotNull(widget.Resources, "Resources should not have returned null");
            Assert.IsTrue(widget.Resources is ResourceDictionary, "Resources is not of the correct type");
            Assert.AreEqual((double) 0, widget.ActualWidth, "ActualWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.ActualHeight, "ActualHeight does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Width), "Width does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Height), "Height does not match the default value");
            Assert.AreEqual((double) 0, widget.MinWidth, "MinWidth does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxWidth), "MaxWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.MinHeight, "MinHeight does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxHeight), "MaxHeight does not match the default value");
            Assert.AreEqual(HorizontalAlignment.Stretch, widget.HorizontalAlignment, "HorizontalAlignment does not match the default value");
            Assert.AreEqual(VerticalAlignment.Stretch, widget.VerticalAlignment, "VerticalAlignment does not match the default value");
            Assert.AreEqual("0,0,0,0", widget.Margin.ToString (), "Margin does not match the default value");
            Assert.IsNull(widget.Style, "Style should have returned null");
            Assert.IsNull(widget.Parent, "Parent should have returned null");
            Assert.IsNotNull(widget.Name, "Name should not have returned null");
            Assert.AreEqual("", widget.Name, "Name does not match the default value");
            Assert.IsNull(widget.Tag, "Tag should have returned null");
            Assert.IsNull(widget.Cursor, "Cursor should have returned null");
            Assert.IsNotNull(widget.Language, "Language should not have returned null");
            Assert.AreEqual("en-us", widget.Language.IetfLanguageTag, "Language does not match the default value");
            Assert.IsNull(widget.DataContext, "DataContext should have returned null");
            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNull(widget.Clip, "Clip should have returned null");
            Assert.IsNull(widget.OpacityMask, "OpacityMask should have returned null");
            Assert.AreEqual("0,0", widget.RenderTransformOrigin.ToString (), "RenderTransformOrigin does not match the default value");
            Assert.AreEqual(true, widget.IsHitTestVisible, "IsHitTestVisible does not match the default value");
            Assert.AreEqual(Visibility.Visible, widget.Visibility, "Visibility does not match the default value");
            Assert.AreEqual("0,0", widget.RenderSize.ToString (), "RenderSize does not match the default value");
            Assert.AreEqual(true, widget.UseLayoutRounding, "UseLayoutRounding does not match the default value");
            Assert.AreEqual("0,0", widget.DesiredSize.ToString (), "DesiredSize does not match the default value");
            Assert.IsNotNull(widget.RenderTransform, "RenderTransform should not have returned null");
            Assert.IsTrue(widget.RenderTransform is MatrixTransform, "RenderTransform is not of the correct type");
        }

        [TestMethod]
        public void Test_SetStringValue_TextBox ()
        {
            TextBox widget = new TextBox ();
            object retval;

            widget.SetValue(TextBox.TextProperty, "some text");
            retval = widget.GetValue(TextBox.TextProperty);
            Assert.AreEqual("some text", retval, "GetValue(TextBox.TextProperty) should have returned 'some text'");
            widget.SetValue(TextBox.TextProperty, null);
            retval = widget.GetValue(TextBox.TextProperty);
            Assert.AreEqual(String.Empty, retval, "GetValue(TextBox.TextProperty) should have returned String.Empty");
            retval = widget.ReadLocalValue(TextBox.TextProperty);
            Assert.AreEqual(String.Empty, retval, "ReadLocalValue(TextBox.TextProperty) should have returned String.Empty");
        }

        [TestMethod]
	[MoonlightBug]
        public void Test_SetStringValue_FrameworkElement ()
        {
            TextBox widget = new TextBox ();
            object retval;

            widget.SetValue(FrameworkElement.NameProperty, "some text");
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.AreEqual("some text", retval, "GetValue(FrameworkElement.NameProperty) should have returned 'some text'");
            widget.SetValue(FrameworkElement.NameProperty, null);
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.AreEqual(String.Empty, retval, "GetValue(FrameworkElement.NameProperty) should have returned String.Empty");
            retval = widget.ReadLocalValue(FrameworkElement.NameProperty);
            Assert.AreEqual(String.Empty, retval, "ReadLocalValue(FrameworkElement.NameProperty) should have returned String.Empty");
        }

    }
}
namespace MoonTest.System.Windows.Controls
{
    public partial class PasswordBoxTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_PasswordBox ()
        {
            PasswordBox widget = new PasswordBox ();
            object retval;

            retval = widget.ReadLocalValue(PasswordBox.MaxLengthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(PasswordBox.MaxLengthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(PasswordBox.SelectionBackgroundProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(PasswordBox.SelectionBackgroundProperty) should not have a value by default");
            retval = widget.ReadLocalValue(PasswordBox.SelectionForegroundProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(PasswordBox.SelectionForegroundProperty) should not have a value by default");
            retval = widget.ReadLocalValue(PasswordBox.PasswordCharProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(PasswordBox.PasswordCharProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_Control ()
        {
            PasswordBox widget = new PasswordBox ();
            object retval;

            retval = widget.ReadLocalValue(Control.IsTabStopProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.IsTabStopProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.TabIndexProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.TabIndexProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.TemplateProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.TemplateProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.TabNavigationProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.TabNavigationProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.PaddingProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.PaddingProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.HorizontalContentAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.HorizontalContentAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.VerticalContentAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.VerticalContentAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.BackgroundProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.BackgroundProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.BorderBrushProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.BorderBrushProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.BorderThicknessProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.BorderThicknessProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.FontSizeProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.FontSizeProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.FontFamilyProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.FontFamilyProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.ForegroundProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.ForegroundProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.FontWeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.FontWeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.FontStyleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.FontStyleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.FontStretchProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.FontStretchProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.IsEnabledProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.IsEnabledProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_FrameworkElement ()
        {
            PasswordBox widget = new PasswordBox ();
            object retval;

            retval = widget.ReadLocalValue(FrameworkElement.LanguageProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.LanguageProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.ActualWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.ActualWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.ActualHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.ActualHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.WidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.WidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.HeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.HeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MinWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MinWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MaxWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MaxWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MinHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MinHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MaxHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MaxHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.HorizontalAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.HorizontalAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.VerticalAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.VerticalAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MarginProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MarginProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.StyleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.StyleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.NameProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.NameProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.TagProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.TagProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.DataContextProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.DataContextProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_UIElement ()
        {
            PasswordBox widget = new PasswordBox ();
            object retval;

            retval = widget.ReadLocalValue(UIElement.OpacityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.OpacityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.ClipProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.ClipProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.RenderTransformProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.RenderTransformProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.OpacityMaskProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.OpacityMaskProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.RenderTransformOriginProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.RenderTransformOriginProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.IsHitTestVisibleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.IsHitTestVisibleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.VisibilityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.VisibilityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.UseLayoutRoundingProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.UseLayoutRoundingProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_PasswordBox ()
        {
            PasswordBox widget = new PasswordBox ();
            object retval;

            retval = widget.GetValue(PasswordBox.MaxLengthProperty);
            Assert.IsNotNull(retval, "GetValue(PasswordBox.MaxLengthProperty) should not have returned null");
            Assert.IsTrue(retval is int, "GetValue(PasswordBox.MaxLengthProperty) is not of the correct type");
            Assert.AreEqual(0, retval, "GetValue(PasswordBox.MaxLengthProperty) does not match the default value");
            retval = widget.GetValue(PasswordBox.SelectionBackgroundProperty);
            Assert.IsNull(retval, "GetValue(PasswordBox.SelectionBackgroundProperty) should have returned null");
            retval = widget.GetValue(PasswordBox.SelectionForegroundProperty);
            Assert.IsNull(retval, "GetValue(PasswordBox.SelectionForegroundProperty) should have returned null");
            retval = widget.GetValue(PasswordBox.PasswordCharProperty);
            Assert.IsNotNull(retval, "GetValue(PasswordBox.PasswordCharProperty) should not have returned null");
            Assert.IsTrue(retval is char, "GetValue(PasswordBox.PasswordCharProperty) is not of the correct type");
            Assert.AreEqual("●", retval.ToString (), "GetValue(PasswordBox.PasswordCharProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_GetValue_Control ()
        {
            PasswordBox widget = new PasswordBox ();
            object retval;

            retval = widget.GetValue(Control.IsTabStopProperty);
            Assert.IsNotNull(retval, "GetValue(Control.IsTabStopProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(Control.IsTabStopProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(Control.IsTabStopProperty) does not match the default value");
            retval = widget.GetValue(Control.TabIndexProperty);
            Assert.IsNotNull(retval, "GetValue(Control.TabIndexProperty) should not have returned null");
            Assert.IsTrue(retval is int, "GetValue(Control.TabIndexProperty) is not of the correct type");
            Assert.AreEqual(2147483647, retval, "GetValue(Control.TabIndexProperty) does not match the default value");
            retval = widget.GetValue(Control.TemplateProperty);
            Assert.IsNull(retval, "GetValue(Control.TemplateProperty) should have returned null");
            retval = widget.GetValue(Control.TabNavigationProperty);
            Assert.IsNotNull(retval, "GetValue(Control.TabNavigationProperty) should not have returned null");
            Assert.IsTrue(retval is KeyboardNavigationMode, "GetValue(Control.TabNavigationProperty) is not of the correct type");
            Assert.AreEqual(KeyboardNavigationMode.Local, retval, "GetValue(Control.TabNavigationProperty) does not match the default value");
            retval = widget.GetValue(Control.PaddingProperty);
            Assert.IsNotNull(retval, "GetValue(Control.PaddingProperty) should not have returned null");
            Assert.IsTrue(retval is Thickness, "GetValue(Control.PaddingProperty) is not of the correct type");
            Assert.AreEqual("0,0,0,0", retval.ToString (), "GetValue(Control.PaddingProperty) does not match the default value");
            retval = widget.GetValue(Control.HorizontalContentAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(Control.HorizontalContentAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is HorizontalAlignment, "GetValue(Control.HorizontalContentAlignmentProperty) is not of the correct type");
            Assert.AreEqual(HorizontalAlignment.Center, retval, "GetValue(Control.HorizontalContentAlignmentProperty) does not match the default value");
            retval = widget.GetValue(Control.VerticalContentAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(Control.VerticalContentAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is VerticalAlignment, "GetValue(Control.VerticalContentAlignmentProperty) is not of the correct type");
            Assert.AreEqual(VerticalAlignment.Center, retval, "GetValue(Control.VerticalContentAlignmentProperty) does not match the default value");
            retval = widget.GetValue(Control.BackgroundProperty);
            Assert.IsNull(retval, "GetValue(Control.BackgroundProperty) should have returned null");
            retval = widget.GetValue(Control.BorderBrushProperty);
            Assert.IsNull(retval, "GetValue(Control.BorderBrushProperty) should have returned null");
            retval = widget.GetValue(Control.BorderThicknessProperty);
            Assert.IsNotNull(retval, "GetValue(Control.BorderThicknessProperty) should not have returned null");
            Assert.IsTrue(retval is Thickness, "GetValue(Control.BorderThicknessProperty) is not of the correct type");
            Assert.AreEqual("0,0,0,0", retval.ToString (), "GetValue(Control.BorderThicknessProperty) does not match the default value");
            retval = widget.GetValue(Control.FontSizeProperty);
            Assert.IsNotNull(retval, "GetValue(Control.FontSizeProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Control.FontSizeProperty) is not of the correct type");
            Assert.AreEqual((double) 11, retval, "GetValue(Control.FontSizeProperty) does not match the default value");
            retval = widget.GetValue(Control.FontFamilyProperty);
            Assert.IsNotNull(retval, "GetValue(Control.FontFamilyProperty) should not have returned null");
            Assert.IsTrue(retval is FontFamily, "GetValue(Control.FontFamilyProperty) is not of the correct type");
            Assert.AreEqual("Portable User Interface", retval.ToString (), "GetValue(Control.FontFamilyProperty) does not match the default value");
            retval = widget.GetValue(Control.ForegroundProperty);
            Assert.IsNotNull(retval, "GetValue(Control.ForegroundProperty) should not have returned null");
            Assert.IsTrue(retval is SolidColorBrush, "GetValue(Control.ForegroundProperty) is not of the correct type");
            retval = widget.GetValue(Control.FontWeightProperty);
            Assert.IsNotNull(retval, "GetValue(Control.FontWeightProperty) should not have returned null");
            Assert.IsTrue(retval is FontWeight, "GetValue(Control.FontWeightProperty) is not of the correct type");
            Assert.AreEqual("Normal", retval.ToString (), "GetValue(Control.FontWeightProperty) does not match the default value");
            retval = widget.GetValue(Control.FontStyleProperty);
            Assert.IsNotNull(retval, "GetValue(Control.FontStyleProperty) should not have returned null");
            Assert.IsTrue(retval is FontStyle, "GetValue(Control.FontStyleProperty) is not of the correct type");
            Assert.AreEqual("Normal", retval.ToString (), "GetValue(Control.FontStyleProperty) does not match the default value");
            retval = widget.GetValue(Control.FontStretchProperty);
            Assert.IsNotNull(retval, "GetValue(Control.FontStretchProperty) should not have returned null");
            Assert.IsTrue(retval is FontStretch, "GetValue(Control.FontStretchProperty) is not of the correct type");
            Assert.AreEqual("Normal", retval.ToString (), "GetValue(Control.FontStretchProperty) does not match the default value");
            retval = widget.GetValue(Control.IsEnabledProperty);
            Assert.IsNotNull(retval, "GetValue(Control.IsEnabledProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(Control.IsEnabledProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(Control.IsEnabledProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_GetValue_FrameworkElement ()
        {
            PasswordBox widget = new PasswordBox ();
            object retval;

            retval = widget.GetValue(FrameworkElement.LanguageProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.LanguageProperty) should not have returned null");
            Assert.IsTrue(retval is XmlLanguage, "GetValue(FrameworkElement.LanguageProperty) is not of the correct type");
            Assert.AreEqual("en-us", ((XmlLanguage) retval).IetfLanguageTag, "GetValue(FrameworkElement.LanguageProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.ActualWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.ActualWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.ActualWidthProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.ActualWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.ActualHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.ActualHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.ActualHeightProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.ActualHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.WidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.WidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.WidthProperty) is not of the correct type");
            Assert.IsTrue(Double.IsNaN((double) retval), "GetValue(FrameworkElement.WidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.HeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.HeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.HeightProperty) is not of the correct type");
            Assert.IsTrue(Double.IsNaN((double) retval), "GetValue(FrameworkElement.HeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MinWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MinWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MinWidthProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.MinWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MaxWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MaxWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MaxWidthProperty) is not of the correct type");
            Assert.IsTrue(Double.IsPositiveInfinity((double) retval), "GetValue(FrameworkElement.MaxWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MinHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MinHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MinHeightProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.MinHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MaxHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MaxHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MaxHeightProperty) is not of the correct type");
            Assert.IsTrue(Double.IsPositiveInfinity((double) retval), "GetValue(FrameworkElement.MaxHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.HorizontalAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.HorizontalAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is HorizontalAlignment, "GetValue(FrameworkElement.HorizontalAlignmentProperty) is not of the correct type");
            Assert.AreEqual(HorizontalAlignment.Stretch, retval, "GetValue(FrameworkElement.HorizontalAlignmentProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.VerticalAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.VerticalAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is VerticalAlignment, "GetValue(FrameworkElement.VerticalAlignmentProperty) is not of the correct type");
            Assert.AreEqual(VerticalAlignment.Stretch, retval, "GetValue(FrameworkElement.VerticalAlignmentProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MarginProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MarginProperty) should not have returned null");
            Assert.IsTrue(retval is Thickness, "GetValue(FrameworkElement.MarginProperty) is not of the correct type");
            Assert.AreEqual("0,0,0,0", retval.ToString (), "GetValue(FrameworkElement.MarginProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.StyleProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.StyleProperty) should have returned null");
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.NameProperty) should not have returned null");
            Assert.IsTrue(retval is string, "GetValue(FrameworkElement.NameProperty) is not of the correct type");
            Assert.AreEqual("", retval, "GetValue(FrameworkElement.NameProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.TagProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.TagProperty) should have returned null");
            retval = widget.GetValue(FrameworkElement.DataContextProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.DataContextProperty) should have returned null");
        }

        [TestMethod]
        public void Test_GetValue_UIElement ()
        {
            PasswordBox widget = new PasswordBox ();
            object retval;

            retval = widget.GetValue(UIElement.OpacityProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.OpacityProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(UIElement.OpacityProperty) is not of the correct type");
            Assert.AreEqual((double) 1, retval, "GetValue(UIElement.OpacityProperty) does not match the default value");
            retval = widget.GetValue(UIElement.ClipProperty);
            Assert.IsNull(retval, "GetValue(UIElement.ClipProperty) should have returned null");
            retval = widget.GetValue(UIElement.RenderTransformProperty);
            Assert.IsNull(retval, "GetValue(UIElement.RenderTransformProperty) should have returned null");
            retval = widget.GetValue(UIElement.OpacityMaskProperty);
            Assert.IsNull(retval, "GetValue(UIElement.OpacityMaskProperty) should have returned null");
            retval = widget.GetValue(UIElement.RenderTransformOriginProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.RenderTransformOriginProperty) should not have returned null");
            Assert.IsTrue(retval is Point, "GetValue(UIElement.RenderTransformOriginProperty) is not of the correct type");
            Assert.AreEqual("0,0", retval.ToString (), "GetValue(UIElement.RenderTransformOriginProperty) does not match the default value");
            retval = widget.GetValue(UIElement.IsHitTestVisibleProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.IsHitTestVisibleProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(UIElement.IsHitTestVisibleProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(UIElement.IsHitTestVisibleProperty) does not match the default value");
            retval = widget.GetValue(UIElement.VisibilityProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.VisibilityProperty) should not have returned null");
            Assert.IsTrue(retval is Visibility, "GetValue(UIElement.VisibilityProperty) is not of the correct type");
            Assert.AreEqual(Visibility.Visible, retval, "GetValue(UIElement.VisibilityProperty) does not match the default value");
            retval = widget.GetValue(UIElement.UseLayoutRoundingProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.UseLayoutRoundingProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(UIElement.UseLayoutRoundingProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(UIElement.UseLayoutRoundingProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_PasswordBox ()
        {
            PasswordBox widget = new PasswordBox ();

            Assert.IsNull(widget.SelectionBackground, "SelectionBackground should have returned null");
            Assert.IsNull(widget.SelectionForeground, "SelectionForeground should have returned null");
            Assert.IsNull(widget.FontSource, "FontSource should have returned null");
            Assert.IsNotNull(widget.Password, "Password should not have returned null");
            Assert.AreEqual("", widget.Password, "Password does not match the default value");
            Assert.AreEqual("●", widget.PasswordChar.ToString (), "PasswordChar does not match the default value");
            Assert.AreEqual(0, widget.MaxLength, "MaxLength does not match the default value");
            Assert.AreEqual(true, widget.IsTabStop, "IsTabStop does not match the default value");
            Assert.AreEqual(true, widget.IsEnabled, "IsEnabled does not match the default value");
            Assert.AreEqual(2147483647, widget.TabIndex, "TabIndex does not match the default value");
            Assert.AreEqual(KeyboardNavigationMode.Local, widget.TabNavigation, "TabNavigation does not match the default value");
            Assert.IsNull(widget.Template, "Template should have returned null");
            Assert.AreEqual("0,0,0,0", widget.Padding.ToString (), "Padding does not match the default value");
            Assert.AreEqual("0,0,0,0", widget.BorderThickness.ToString (), "BorderThickness does not match the default value");
            Assert.AreEqual(HorizontalAlignment.Center, widget.HorizontalContentAlignment, "HorizontalContentAlignment does not match the default value");
            Assert.AreEqual(VerticalAlignment.Center, widget.VerticalContentAlignment, "VerticalContentAlignment does not match the default value");
            Assert.IsNull(widget.Background, "Background should have returned null");
            Assert.IsNull(widget.BorderBrush, "BorderBrush should have returned null");
            Assert.IsNotNull(widget.FontFamily, "FontFamily should not have returned null");
            Assert.AreEqual("Portable User Interface", widget.FontFamily.ToString (), "FontFamily does not match the default value");
            Assert.AreEqual((double) 11, widget.FontSize, "FontSize does not match the default value");
            Assert.AreEqual("Normal", widget.FontStretch.ToString (), "FontStretch does not match the default value");
            Assert.AreEqual("Normal", widget.FontStyle.ToString (), "FontStyle does not match the default value");
            Assert.AreEqual("Normal", widget.FontWeight.ToString (), "FontWeight does not match the default value");
            Assert.IsNotNull(widget.Foreground, "Foreground should not have returned null");
            Assert.IsTrue(widget.Foreground is SolidColorBrush, "Foreground is not of the correct type");
            Assert.IsNotNull(widget.Triggers, "Triggers should not have returned null");
            Assert.IsTrue(widget.Triggers is TriggerCollection, "Triggers is not of the correct type");
            Assert.IsNotNull(widget.Resources, "Resources should not have returned null");
            Assert.IsTrue(widget.Resources is ResourceDictionary, "Resources is not of the correct type");
            Assert.AreEqual((double) 0, widget.ActualWidth, "ActualWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.ActualHeight, "ActualHeight does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Width), "Width does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Height), "Height does not match the default value");
            Assert.AreEqual((double) 0, widget.MinWidth, "MinWidth does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxWidth), "MaxWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.MinHeight, "MinHeight does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxHeight), "MaxHeight does not match the default value");
            Assert.AreEqual(HorizontalAlignment.Stretch, widget.HorizontalAlignment, "HorizontalAlignment does not match the default value");
            Assert.AreEqual(VerticalAlignment.Stretch, widget.VerticalAlignment, "VerticalAlignment does not match the default value");
            Assert.AreEqual("0,0,0,0", widget.Margin.ToString (), "Margin does not match the default value");
            Assert.IsNull(widget.Style, "Style should have returned null");
            Assert.IsNull(widget.Parent, "Parent should have returned null");
            Assert.IsNotNull(widget.Name, "Name should not have returned null");
            Assert.AreEqual("", widget.Name, "Name does not match the default value");
            Assert.IsNull(widget.Tag, "Tag should have returned null");
            Assert.IsNull(widget.Cursor, "Cursor should have returned null");
            Assert.IsNotNull(widget.Language, "Language should not have returned null");
            Assert.AreEqual("en-us", widget.Language.IetfLanguageTag, "Language does not match the default value");
            Assert.IsNull(widget.DataContext, "DataContext should have returned null");
            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNull(widget.Clip, "Clip should have returned null");
            Assert.IsNull(widget.OpacityMask, "OpacityMask should have returned null");
            Assert.AreEqual("0,0", widget.RenderTransformOrigin.ToString (), "RenderTransformOrigin does not match the default value");
            Assert.AreEqual(true, widget.IsHitTestVisible, "IsHitTestVisible does not match the default value");
            Assert.AreEqual(Visibility.Visible, widget.Visibility, "Visibility does not match the default value");
            Assert.AreEqual("0,0", widget.RenderSize.ToString (), "RenderSize does not match the default value");
            Assert.AreEqual(true, widget.UseLayoutRounding, "UseLayoutRounding does not match the default value");
            Assert.AreEqual("0,0", widget.DesiredSize.ToString (), "DesiredSize does not match the default value");
            Assert.IsNotNull(widget.RenderTransform, "RenderTransform should not have returned null");
            Assert.IsTrue(widget.RenderTransform is MatrixTransform, "RenderTransform is not of the correct type");
        }

        [TestMethod]
        public void Test_PropertyGetter_FrameworkElement ()
        {
            PasswordBox widget = new PasswordBox ();

            Assert.IsNotNull(widget.Triggers, "Triggers should not have returned null");
            Assert.IsTrue(widget.Triggers is TriggerCollection, "Triggers is not of the correct type");
            Assert.IsNotNull(widget.Resources, "Resources should not have returned null");
            Assert.IsTrue(widget.Resources is ResourceDictionary, "Resources is not of the correct type");
            Assert.AreEqual((double) 0, widget.ActualWidth, "ActualWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.ActualHeight, "ActualHeight does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Width), "Width does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Height), "Height does not match the default value");
            Assert.AreEqual((double) 0, widget.MinWidth, "MinWidth does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxWidth), "MaxWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.MinHeight, "MinHeight does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxHeight), "MaxHeight does not match the default value");
            Assert.AreEqual(HorizontalAlignment.Stretch, widget.HorizontalAlignment, "HorizontalAlignment does not match the default value");
            Assert.AreEqual(VerticalAlignment.Stretch, widget.VerticalAlignment, "VerticalAlignment does not match the default value");
            Assert.AreEqual("0,0,0,0", widget.Margin.ToString (), "Margin does not match the default value");
            Assert.IsNull(widget.Style, "Style should have returned null");
            Assert.IsNull(widget.Parent, "Parent should have returned null");
            Assert.IsNotNull(widget.Name, "Name should not have returned null");
            Assert.AreEqual("", widget.Name, "Name does not match the default value");
            Assert.IsNull(widget.Tag, "Tag should have returned null");
            Assert.IsNull(widget.Cursor, "Cursor should have returned null");
            Assert.IsNotNull(widget.Language, "Language should not have returned null");
            Assert.AreEqual("en-us", widget.Language.IetfLanguageTag, "Language does not match the default value");
            Assert.IsNull(widget.DataContext, "DataContext should have returned null");
            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNull(widget.Clip, "Clip should have returned null");
            Assert.IsNull(widget.OpacityMask, "OpacityMask should have returned null");
            Assert.AreEqual("0,0", widget.RenderTransformOrigin.ToString (), "RenderTransformOrigin does not match the default value");
            Assert.AreEqual(true, widget.IsHitTestVisible, "IsHitTestVisible does not match the default value");
            Assert.AreEqual(Visibility.Visible, widget.Visibility, "Visibility does not match the default value");
            Assert.AreEqual("0,0", widget.RenderSize.ToString (), "RenderSize does not match the default value");
            Assert.AreEqual(true, widget.UseLayoutRounding, "UseLayoutRounding does not match the default value");
            Assert.AreEqual("0,0", widget.DesiredSize.ToString (), "DesiredSize does not match the default value");
            Assert.IsNotNull(widget.RenderTransform, "RenderTransform should not have returned null");
            Assert.IsTrue(widget.RenderTransform is MatrixTransform, "RenderTransform is not of the correct type");
        }

        [TestMethod]
	[MoonlightBug]
        public void Test_SetStringValue_FrameworkElement ()
        {
            PasswordBox widget = new PasswordBox ();
            object retval;

            widget.SetValue(FrameworkElement.NameProperty, "some text");
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.AreEqual("some text", retval, "GetValue(FrameworkElement.NameProperty) should have returned 'some text'");
            widget.SetValue(FrameworkElement.NameProperty, null);
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.AreEqual(String.Empty, retval, "GetValue(FrameworkElement.NameProperty) should have returned String.Empty");
            retval = widget.ReadLocalValue(FrameworkElement.NameProperty);
            Assert.AreEqual(String.Empty, retval, "ReadLocalValue(FrameworkElement.NameProperty) should have returned String.Empty");
        }

    }
}
namespace MoonTest.System.Windows.Controls
{
    public partial class RowDefinitionTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_RowDefinition ()
        {
            RowDefinition widget = new RowDefinition ();
            object retval;

            retval = widget.ReadLocalValue(RowDefinition.HeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(RowDefinition.HeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(RowDefinition.MaxHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(RowDefinition.MaxHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(RowDefinition.MinHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(RowDefinition.MinHeightProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_RowDefinition ()
        {
            RowDefinition widget = new RowDefinition ();
            object retval;

            retval = widget.GetValue(RowDefinition.HeightProperty);
            Assert.IsNotNull(retval, "GetValue(RowDefinition.HeightProperty) should not have returned null");
            Assert.IsTrue(retval is GridLength, "GetValue(RowDefinition.HeightProperty) is not of the correct type");
            Assert.AreEqual("1*", retval.ToString (), "GetValue(RowDefinition.HeightProperty) does not match the default value");
            retval = widget.GetValue(RowDefinition.MaxHeightProperty);
            Assert.IsNotNull(retval, "GetValue(RowDefinition.MaxHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(RowDefinition.MaxHeightProperty) is not of the correct type");
            Assert.IsTrue(Double.IsPositiveInfinity((double) retval), "GetValue(RowDefinition.MaxHeightProperty) does not match the default value");
            retval = widget.GetValue(RowDefinition.MinHeightProperty);
            Assert.IsNotNull(retval, "GetValue(RowDefinition.MinHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(RowDefinition.MinHeightProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(RowDefinition.MinHeightProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_RowDefinition ()
        {
            RowDefinition widget = new RowDefinition ();

            Assert.AreEqual("1*", widget.Height.ToString (), "Height does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxHeight), "MaxHeight does not match the default value");
            Assert.AreEqual((double) 0, widget.MinHeight, "MinHeight does not match the default value");
            Assert.AreEqual((double) 0, widget.ActualHeight, "ActualHeight does not match the default value");
        }

    }
}
namespace MoonTest.System.Windows.Controls
{
    public partial class ColumnDefinitionTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_ColumnDefinition ()
        {
            ColumnDefinition widget = new ColumnDefinition ();
            object retval;

            retval = widget.ReadLocalValue(ColumnDefinition.WidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(ColumnDefinition.WidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(ColumnDefinition.MaxWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(ColumnDefinition.MaxWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(ColumnDefinition.MinWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(ColumnDefinition.MinWidthProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_ColumnDefinition ()
        {
            ColumnDefinition widget = new ColumnDefinition ();
            object retval;

            retval = widget.GetValue(ColumnDefinition.WidthProperty);
            Assert.IsNotNull(retval, "GetValue(ColumnDefinition.WidthProperty) should not have returned null");
            Assert.IsTrue(retval is GridLength, "GetValue(ColumnDefinition.WidthProperty) is not of the correct type");
            Assert.AreEqual("1*", retval.ToString (), "GetValue(ColumnDefinition.WidthProperty) does not match the default value");
            retval = widget.GetValue(ColumnDefinition.MaxWidthProperty);
            Assert.IsNotNull(retval, "GetValue(ColumnDefinition.MaxWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(ColumnDefinition.MaxWidthProperty) is not of the correct type");
            Assert.IsTrue(Double.IsPositiveInfinity((double) retval), "GetValue(ColumnDefinition.MaxWidthProperty) does not match the default value");
            retval = widget.GetValue(ColumnDefinition.MinWidthProperty);
            Assert.IsNotNull(retval, "GetValue(ColumnDefinition.MinWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(ColumnDefinition.MinWidthProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(ColumnDefinition.MinWidthProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_ColumnDefinition ()
        {
            ColumnDefinition widget = new ColumnDefinition ();

            Assert.AreEqual("1*", widget.Width.ToString (), "Width does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxWidth), "MaxWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.MinWidth, "MinWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.ActualWidth, "ActualWidth does not match the default value");
        }

    }
}
namespace MoonTest.System.Windows.Controls
{
    public partial class GridTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_Grid ()
        {
            Grid widget = new Grid ();
            object retval;

            retval = widget.ReadLocalValue(Grid.ShowGridLinesProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Grid.ShowGridLinesProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Grid.RowProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Grid.RowProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Grid.ColumnProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Grid.ColumnProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Grid.RowSpanProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Grid.RowSpanProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Grid.ColumnSpanProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Grid.ColumnSpanProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_Panel ()
        {
            Grid widget = new Grid ();
            object retval;

            retval = widget.ReadLocalValue(Panel.BackgroundProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Panel.BackgroundProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_FrameworkElement ()
        {
            Grid widget = new Grid ();
            object retval;

            retval = widget.ReadLocalValue(FrameworkElement.LanguageProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.LanguageProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.ActualWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.ActualWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.ActualHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.ActualHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.WidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.WidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.HeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.HeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MinWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MinWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MaxWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MaxWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MinHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MinHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MaxHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MaxHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.HorizontalAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.HorizontalAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.VerticalAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.VerticalAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MarginProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MarginProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.StyleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.StyleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.NameProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.NameProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.TagProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.TagProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.DataContextProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.DataContextProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_UIElement ()
        {
            Grid widget = new Grid ();
            object retval;

            retval = widget.ReadLocalValue(UIElement.OpacityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.OpacityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.ClipProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.ClipProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.RenderTransformProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.RenderTransformProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.OpacityMaskProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.OpacityMaskProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.RenderTransformOriginProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.RenderTransformOriginProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.IsHitTestVisibleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.IsHitTestVisibleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.VisibilityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.VisibilityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.UseLayoutRoundingProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.UseLayoutRoundingProperty) should not have a value by default");
        }

        [TestMethod]
        [MoonlightBug]
        public void Test_GetValue_Grid ()
        {
            Grid widget = new Grid ();
            object retval;

            retval = widget.GetValue(Grid.ShowGridLinesProperty);
            Assert.IsNotNull(retval, "GetValue(Grid.ShowGridLinesProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(Grid.ShowGridLinesProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(Grid.ShowGridLinesProperty) does not match the default value");
            retval = widget.GetValue(Grid.RowProperty);
            Assert.IsNotNull(retval, "GetValue(Grid.RowProperty) should not have returned null");
            Assert.IsTrue(retval is int, "GetValue(Grid.RowProperty) is not of the correct type");
            Assert.AreEqual(0, retval, "GetValue(Grid.RowProperty) does not match the default value");
            retval = widget.GetValue(Grid.ColumnProperty);
            Assert.IsNotNull(retval, "GetValue(Grid.ColumnProperty) should not have returned null");
            Assert.IsTrue(retval is int, "GetValue(Grid.ColumnProperty) is not of the correct type");
            Assert.AreEqual(0, retval, "GetValue(Grid.ColumnProperty) does not match the default value");
            retval = widget.GetValue(Grid.RowSpanProperty);
            Assert.IsNotNull(retval, "GetValue(Grid.RowSpanProperty) should not have returned null");
            Assert.IsTrue(retval is int, "GetValue(Grid.RowSpanProperty) is not of the correct type");
            Assert.AreEqual(1, retval, "GetValue(Grid.RowSpanProperty) does not match the default value");
            retval = widget.GetValue(Grid.ColumnSpanProperty);
            Assert.IsNotNull(retval, "GetValue(Grid.ColumnSpanProperty) should not have returned null");
            Assert.IsTrue(retval is int, "GetValue(Grid.ColumnSpanProperty) is not of the correct type");
            Assert.AreEqual(1, retval, "GetValue(Grid.ColumnSpanProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_GetValue_Panel ()
        {
            Grid widget = new Grid ();
            object retval;

            retval = widget.GetValue(Panel.BackgroundProperty);
            Assert.IsNull(retval, "GetValue(Panel.BackgroundProperty) should have returned null");
        }

        [TestMethod]
        public void Test_GetValue_FrameworkElement ()
        {
            Grid widget = new Grid ();
            object retval;

            retval = widget.GetValue(FrameworkElement.LanguageProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.LanguageProperty) should not have returned null");
            Assert.IsTrue(retval is XmlLanguage, "GetValue(FrameworkElement.LanguageProperty) is not of the correct type");
            Assert.AreEqual("en-us", ((XmlLanguage) retval).IetfLanguageTag, "GetValue(FrameworkElement.LanguageProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.ActualWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.ActualWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.ActualWidthProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.ActualWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.ActualHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.ActualHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.ActualHeightProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.ActualHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.WidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.WidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.WidthProperty) is not of the correct type");
            Assert.IsTrue(Double.IsNaN((double) retval), "GetValue(FrameworkElement.WidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.HeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.HeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.HeightProperty) is not of the correct type");
            Assert.IsTrue(Double.IsNaN((double) retval), "GetValue(FrameworkElement.HeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MinWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MinWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MinWidthProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.MinWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MaxWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MaxWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MaxWidthProperty) is not of the correct type");
            Assert.IsTrue(Double.IsPositiveInfinity((double) retval), "GetValue(FrameworkElement.MaxWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MinHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MinHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MinHeightProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.MinHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MaxHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MaxHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MaxHeightProperty) is not of the correct type");
            Assert.IsTrue(Double.IsPositiveInfinity((double) retval), "GetValue(FrameworkElement.MaxHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.HorizontalAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.HorizontalAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is HorizontalAlignment, "GetValue(FrameworkElement.HorizontalAlignmentProperty) is not of the correct type");
            Assert.AreEqual(HorizontalAlignment.Stretch, retval, "GetValue(FrameworkElement.HorizontalAlignmentProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.VerticalAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.VerticalAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is VerticalAlignment, "GetValue(FrameworkElement.VerticalAlignmentProperty) is not of the correct type");
            Assert.AreEqual(VerticalAlignment.Stretch, retval, "GetValue(FrameworkElement.VerticalAlignmentProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MarginProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MarginProperty) should not have returned null");
            Assert.IsTrue(retval is Thickness, "GetValue(FrameworkElement.MarginProperty) is not of the correct type");
            Assert.AreEqual("0,0,0,0", retval.ToString (), "GetValue(FrameworkElement.MarginProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.StyleProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.StyleProperty) should have returned null");
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.NameProperty) should not have returned null");
            Assert.IsTrue(retval is string, "GetValue(FrameworkElement.NameProperty) is not of the correct type");
            Assert.AreEqual("", retval, "GetValue(FrameworkElement.NameProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.TagProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.TagProperty) should have returned null");
            retval = widget.GetValue(FrameworkElement.DataContextProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.DataContextProperty) should have returned null");
        }

        [TestMethod]
        public void Test_GetValue_UIElement ()
        {
            Grid widget = new Grid ();
            object retval;

            retval = widget.GetValue(UIElement.OpacityProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.OpacityProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(UIElement.OpacityProperty) is not of the correct type");
            Assert.AreEqual((double) 1, retval, "GetValue(UIElement.OpacityProperty) does not match the default value");
            retval = widget.GetValue(UIElement.ClipProperty);
            Assert.IsNull(retval, "GetValue(UIElement.ClipProperty) should have returned null");
            retval = widget.GetValue(UIElement.RenderTransformProperty);
            Assert.IsNull(retval, "GetValue(UIElement.RenderTransformProperty) should have returned null");
            retval = widget.GetValue(UIElement.OpacityMaskProperty);
            Assert.IsNull(retval, "GetValue(UIElement.OpacityMaskProperty) should have returned null");
            retval = widget.GetValue(UIElement.RenderTransformOriginProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.RenderTransformOriginProperty) should not have returned null");
            Assert.IsTrue(retval is Point, "GetValue(UIElement.RenderTransformOriginProperty) is not of the correct type");
            Assert.AreEqual("0,0", retval.ToString (), "GetValue(UIElement.RenderTransformOriginProperty) does not match the default value");
            retval = widget.GetValue(UIElement.IsHitTestVisibleProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.IsHitTestVisibleProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(UIElement.IsHitTestVisibleProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(UIElement.IsHitTestVisibleProperty) does not match the default value");
            retval = widget.GetValue(UIElement.VisibilityProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.VisibilityProperty) should not have returned null");
            Assert.IsTrue(retval is Visibility, "GetValue(UIElement.VisibilityProperty) is not of the correct type");
            Assert.AreEqual(Visibility.Visible, retval, "GetValue(UIElement.VisibilityProperty) does not match the default value");
            retval = widget.GetValue(UIElement.UseLayoutRoundingProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.UseLayoutRoundingProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(UIElement.UseLayoutRoundingProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(UIElement.UseLayoutRoundingProperty) does not match the default value");
        }

        [TestMethod]
        [MoonlightBug]
        public void Test_PropertyGetter_Grid ()
        {
            Grid widget = new Grid ();

            Assert.IsNotNull(widget.RowDefinitions, "RowDefinitions should not have returned null");
            Assert.IsTrue(widget.RowDefinitions is RowDefinitionCollection, "RowDefinitions is not of the correct type");
            Assert.IsNotNull(widget.ColumnDefinitions, "ColumnDefinitions should not have returned null");
            Assert.IsTrue(widget.ColumnDefinitions is ColumnDefinitionCollection, "ColumnDefinitions is not of the correct type");
            Assert.AreEqual(true, widget.ShowGridLines, "ShowGridLines does not match the default value");
            Assert.IsNotNull(widget.Children, "Children should not have returned null");
            Assert.IsTrue(widget.Children is UIElementCollection, "Children is not of the correct type");
            Assert.IsNull(widget.Background, "Background should have returned null");
            Assert.IsNotNull(widget.Triggers, "Triggers should not have returned null");
            Assert.IsTrue(widget.Triggers is TriggerCollection, "Triggers is not of the correct type");
            Assert.IsNotNull(widget.Resources, "Resources should not have returned null");
            Assert.IsTrue(widget.Resources is ResourceDictionary, "Resources is not of the correct type");
            Assert.AreEqual((double) 0, widget.ActualWidth, "ActualWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.ActualHeight, "ActualHeight does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Width), "Width does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Height), "Height does not match the default value");
            Assert.AreEqual((double) 0, widget.MinWidth, "MinWidth does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxWidth), "MaxWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.MinHeight, "MinHeight does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxHeight), "MaxHeight does not match the default value");
            Assert.AreEqual(HorizontalAlignment.Stretch, widget.HorizontalAlignment, "HorizontalAlignment does not match the default value");
            Assert.AreEqual(VerticalAlignment.Stretch, widget.VerticalAlignment, "VerticalAlignment does not match the default value");
            Assert.AreEqual("0,0,0,0", widget.Margin.ToString (), "Margin does not match the default value");
            Assert.IsNull(widget.Style, "Style should have returned null");
            Assert.IsNull(widget.Parent, "Parent should have returned null");
            Assert.IsNotNull(widget.Name, "Name should not have returned null");
            Assert.AreEqual("", widget.Name, "Name does not match the default value");
            Assert.IsNull(widget.Tag, "Tag should have returned null");
            Assert.IsNull(widget.Cursor, "Cursor should have returned null");
            Assert.IsNotNull(widget.Language, "Language should not have returned null");
            Assert.AreEqual("en-us", widget.Language.IetfLanguageTag, "Language does not match the default value");
            Assert.IsNull(widget.DataContext, "DataContext should have returned null");
            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNull(widget.Clip, "Clip should have returned null");
            Assert.IsNull(widget.OpacityMask, "OpacityMask should have returned null");
            Assert.AreEqual("0,0", widget.RenderTransformOrigin.ToString (), "RenderTransformOrigin does not match the default value");
            Assert.AreEqual(true, widget.IsHitTestVisible, "IsHitTestVisible does not match the default value");
            Assert.AreEqual(Visibility.Visible, widget.Visibility, "Visibility does not match the default value");
            Assert.AreEqual("0,0", widget.RenderSize.ToString (), "RenderSize does not match the default value");
            Assert.AreEqual(true, widget.UseLayoutRounding, "UseLayoutRounding does not match the default value");
            Assert.AreEqual("0,0", widget.DesiredSize.ToString (), "DesiredSize does not match the default value");
            Assert.IsNotNull(widget.RenderTransform, "RenderTransform should not have returned null");
            Assert.IsTrue(widget.RenderTransform is MatrixTransform, "RenderTransform is not of the correct type");
        }

        [TestMethod]
        public void Test_PropertyGetter_FrameworkElement ()
        {
            Grid widget = new Grid ();

            Assert.IsNotNull(widget.Triggers, "Triggers should not have returned null");
            Assert.IsTrue(widget.Triggers is TriggerCollection, "Triggers is not of the correct type");
            Assert.IsNotNull(widget.Resources, "Resources should not have returned null");
            Assert.IsTrue(widget.Resources is ResourceDictionary, "Resources is not of the correct type");
            Assert.AreEqual((double) 0, widget.ActualWidth, "ActualWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.ActualHeight, "ActualHeight does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Width), "Width does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Height), "Height does not match the default value");
            Assert.AreEqual((double) 0, widget.MinWidth, "MinWidth does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxWidth), "MaxWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.MinHeight, "MinHeight does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxHeight), "MaxHeight does not match the default value");
            Assert.AreEqual(HorizontalAlignment.Stretch, widget.HorizontalAlignment, "HorizontalAlignment does not match the default value");
            Assert.AreEqual(VerticalAlignment.Stretch, widget.VerticalAlignment, "VerticalAlignment does not match the default value");
            Assert.AreEqual("0,0,0,0", widget.Margin.ToString (), "Margin does not match the default value");
            Assert.IsNull(widget.Style, "Style should have returned null");
            Assert.IsNull(widget.Parent, "Parent should have returned null");
            Assert.IsNotNull(widget.Name, "Name should not have returned null");
            Assert.AreEqual("", widget.Name, "Name does not match the default value");
            Assert.IsNull(widget.Tag, "Tag should have returned null");
            Assert.IsNull(widget.Cursor, "Cursor should have returned null");
            Assert.IsNotNull(widget.Language, "Language should not have returned null");
            Assert.AreEqual("en-us", widget.Language.IetfLanguageTag, "Language does not match the default value");
            Assert.IsNull(widget.DataContext, "DataContext should have returned null");
            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNull(widget.Clip, "Clip should have returned null");
            Assert.IsNull(widget.OpacityMask, "OpacityMask should have returned null");
            Assert.AreEqual("0,0", widget.RenderTransformOrigin.ToString (), "RenderTransformOrigin does not match the default value");
            Assert.AreEqual(true, widget.IsHitTestVisible, "IsHitTestVisible does not match the default value");
            Assert.AreEqual(Visibility.Visible, widget.Visibility, "Visibility does not match the default value");
            Assert.AreEqual("0,0", widget.RenderSize.ToString (), "RenderSize does not match the default value");
            Assert.AreEqual(true, widget.UseLayoutRounding, "UseLayoutRounding does not match the default value");
            Assert.AreEqual("0,0", widget.DesiredSize.ToString (), "DesiredSize does not match the default value");
            Assert.IsNotNull(widget.RenderTransform, "RenderTransform should not have returned null");
            Assert.IsTrue(widget.RenderTransform is MatrixTransform, "RenderTransform is not of the correct type");
        }

        [TestMethod]
	[MoonlightBug]
        public void Test_SetStringValue_FrameworkElement ()
        {
            Grid widget = new Grid ();
            object retval;

            widget.SetValue(FrameworkElement.NameProperty, "some text");
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.AreEqual("some text", retval, "GetValue(FrameworkElement.NameProperty) should have returned 'some text'");
            widget.SetValue(FrameworkElement.NameProperty, null);
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.AreEqual(String.Empty, retval, "GetValue(FrameworkElement.NameProperty) should have returned String.Empty");
            retval = widget.ReadLocalValue(FrameworkElement.NameProperty);
            Assert.AreEqual(String.Empty, retval, "ReadLocalValue(FrameworkElement.NameProperty) should have returned String.Empty");
        }

    }
}
namespace MoonTest.System.Windows.Controls
{
    public partial class ControlTemplateTest
    {
        [TestMethod]
        public void Test_PropertyGetter_ControlTemplate ()
        {
            ControlTemplate widget = new ControlTemplate ();

            Assert.IsNull(widget.TargetType, "TargetType should have returned null");
        }

    }
}
namespace MoonTest.System.Windows.Controls
{
    public partial class ItemsControlTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_ItemsControl ()
        {
            ItemsControl widget = new ItemsControl ();
            object retval;

            retval = widget.ReadLocalValue(ItemsControl.ItemTemplateProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(ItemsControl.ItemTemplateProperty) should not have a value by default");
            retval = widget.ReadLocalValue(ItemsControl.ItemsPanelProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(ItemsControl.ItemsPanelProperty) should not have a value by default");
            retval = widget.ReadLocalValue(ItemsControl.DisplayMemberPathProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(ItemsControl.DisplayMemberPathProperty) should not have a value by default");
            retval = widget.ReadLocalValue(ItemsControl.ItemsSourceProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(ItemsControl.ItemsSourceProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_Control ()
        {
            ItemsControl widget = new ItemsControl ();
            object retval;

            retval = widget.ReadLocalValue(Control.IsTabStopProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.IsTabStopProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.TabIndexProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.TabIndexProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.TemplateProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.TemplateProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.TabNavigationProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.TabNavigationProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.PaddingProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.PaddingProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.HorizontalContentAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.HorizontalContentAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.VerticalContentAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.VerticalContentAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.BackgroundProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.BackgroundProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.BorderBrushProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.BorderBrushProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.BorderThicknessProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.BorderThicknessProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.FontSizeProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.FontSizeProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.FontFamilyProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.FontFamilyProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.ForegroundProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.ForegroundProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.FontWeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.FontWeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.FontStyleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.FontStyleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.FontStretchProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.FontStretchProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.IsEnabledProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.IsEnabledProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_FrameworkElement ()
        {
            ItemsControl widget = new ItemsControl ();
            object retval;

            retval = widget.ReadLocalValue(FrameworkElement.LanguageProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.LanguageProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.ActualWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.ActualWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.ActualHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.ActualHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.WidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.WidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.HeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.HeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MinWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MinWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MaxWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MaxWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MinHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MinHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MaxHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MaxHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.HorizontalAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.HorizontalAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.VerticalAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.VerticalAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MarginProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MarginProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.StyleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.StyleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.NameProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.NameProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.TagProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.TagProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.DataContextProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.DataContextProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_UIElement ()
        {
            ItemsControl widget = new ItemsControl ();
            object retval;

            retval = widget.ReadLocalValue(UIElement.OpacityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.OpacityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.ClipProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.ClipProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.RenderTransformProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.RenderTransformProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.OpacityMaskProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.OpacityMaskProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.RenderTransformOriginProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.RenderTransformOriginProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.IsHitTestVisibleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.IsHitTestVisibleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.VisibilityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.VisibilityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.UseLayoutRoundingProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.UseLayoutRoundingProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_ItemsControl ()
        {
            ItemsControl widget = new ItemsControl ();
            object retval;

            retval = widget.GetValue(ItemsControl.ItemTemplateProperty);
            Assert.IsNull(retval, "GetValue(ItemsControl.ItemTemplateProperty) should have returned null");
            retval = widget.GetValue(ItemsControl.ItemsPanelProperty);
            Assert.IsNull(retval, "GetValue(ItemsControl.ItemsPanelProperty) should have returned null");
            retval = widget.GetValue(ItemsControl.DisplayMemberPathProperty);
            Assert.IsNull(retval, "GetValue(ItemsControl.DisplayMemberPathProperty) should have returned null");
            retval = widget.GetValue(ItemsControl.ItemsSourceProperty);
            Assert.IsNull(retval, "GetValue(ItemsControl.ItemsSourceProperty) should have returned null");
        }

        [TestMethod]
        public void Test_GetValue_Control ()
        {
            ItemsControl widget = new ItemsControl ();
            object retval;

            retval = widget.GetValue(Control.IsTabStopProperty);
            Assert.IsNotNull(retval, "GetValue(Control.IsTabStopProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(Control.IsTabStopProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(Control.IsTabStopProperty) does not match the default value");
            retval = widget.GetValue(Control.TabIndexProperty);
            Assert.IsNotNull(retval, "GetValue(Control.TabIndexProperty) should not have returned null");
            Assert.IsTrue(retval is int, "GetValue(Control.TabIndexProperty) is not of the correct type");
            Assert.AreEqual(2147483647, retval, "GetValue(Control.TabIndexProperty) does not match the default value");
            retval = widget.GetValue(Control.TemplateProperty);
            Assert.IsNull(retval, "GetValue(Control.TemplateProperty) should have returned null");
            retval = widget.GetValue(Control.TabNavigationProperty);
            Assert.IsNotNull(retval, "GetValue(Control.TabNavigationProperty) should not have returned null");
            Assert.IsTrue(retval is KeyboardNavigationMode, "GetValue(Control.TabNavigationProperty) is not of the correct type");
            Assert.AreEqual(KeyboardNavigationMode.Local, retval, "GetValue(Control.TabNavigationProperty) does not match the default value");
            retval = widget.GetValue(Control.PaddingProperty);
            Assert.IsNotNull(retval, "GetValue(Control.PaddingProperty) should not have returned null");
            Assert.IsTrue(retval is Thickness, "GetValue(Control.PaddingProperty) is not of the correct type");
            Assert.AreEqual("0,0,0,0", retval.ToString (), "GetValue(Control.PaddingProperty) does not match the default value");
            retval = widget.GetValue(Control.HorizontalContentAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(Control.HorizontalContentAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is HorizontalAlignment, "GetValue(Control.HorizontalContentAlignmentProperty) is not of the correct type");
            Assert.AreEqual(HorizontalAlignment.Center, retval, "GetValue(Control.HorizontalContentAlignmentProperty) does not match the default value");
            retval = widget.GetValue(Control.VerticalContentAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(Control.VerticalContentAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is VerticalAlignment, "GetValue(Control.VerticalContentAlignmentProperty) is not of the correct type");
            Assert.AreEqual(VerticalAlignment.Center, retval, "GetValue(Control.VerticalContentAlignmentProperty) does not match the default value");
            retval = widget.GetValue(Control.BackgroundProperty);
            Assert.IsNull(retval, "GetValue(Control.BackgroundProperty) should have returned null");
            retval = widget.GetValue(Control.BorderBrushProperty);
            Assert.IsNull(retval, "GetValue(Control.BorderBrushProperty) should have returned null");
            retval = widget.GetValue(Control.BorderThicknessProperty);
            Assert.IsNotNull(retval, "GetValue(Control.BorderThicknessProperty) should not have returned null");
            Assert.IsTrue(retval is Thickness, "GetValue(Control.BorderThicknessProperty) is not of the correct type");
            Assert.AreEqual("0,0,0,0", retval.ToString (), "GetValue(Control.BorderThicknessProperty) does not match the default value");
            retval = widget.GetValue(Control.FontSizeProperty);
            Assert.IsNotNull(retval, "GetValue(Control.FontSizeProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Control.FontSizeProperty) is not of the correct type");
            Assert.AreEqual((double) 11, retval, "GetValue(Control.FontSizeProperty) does not match the default value");
            retval = widget.GetValue(Control.FontFamilyProperty);
            Assert.IsNotNull(retval, "GetValue(Control.FontFamilyProperty) should not have returned null");
            Assert.IsTrue(retval is FontFamily, "GetValue(Control.FontFamilyProperty) is not of the correct type");
            Assert.AreEqual("Portable User Interface", retval.ToString (), "GetValue(Control.FontFamilyProperty) does not match the default value");
            retval = widget.GetValue(Control.ForegroundProperty);
            Assert.IsNotNull(retval, "GetValue(Control.ForegroundProperty) should not have returned null");
            Assert.IsTrue(retval is SolidColorBrush, "GetValue(Control.ForegroundProperty) is not of the correct type");
            retval = widget.GetValue(Control.FontWeightProperty);
            Assert.IsNotNull(retval, "GetValue(Control.FontWeightProperty) should not have returned null");
            Assert.IsTrue(retval is FontWeight, "GetValue(Control.FontWeightProperty) is not of the correct type");
            Assert.AreEqual("Normal", retval.ToString (), "GetValue(Control.FontWeightProperty) does not match the default value");
            retval = widget.GetValue(Control.FontStyleProperty);
            Assert.IsNotNull(retval, "GetValue(Control.FontStyleProperty) should not have returned null");
            Assert.IsTrue(retval is FontStyle, "GetValue(Control.FontStyleProperty) is not of the correct type");
            Assert.AreEqual("Normal", retval.ToString (), "GetValue(Control.FontStyleProperty) does not match the default value");
            retval = widget.GetValue(Control.FontStretchProperty);
            Assert.IsNotNull(retval, "GetValue(Control.FontStretchProperty) should not have returned null");
            Assert.IsTrue(retval is FontStretch, "GetValue(Control.FontStretchProperty) is not of the correct type");
            Assert.AreEqual("Normal", retval.ToString (), "GetValue(Control.FontStretchProperty) does not match the default value");
            retval = widget.GetValue(Control.IsEnabledProperty);
            Assert.IsNotNull(retval, "GetValue(Control.IsEnabledProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(Control.IsEnabledProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(Control.IsEnabledProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_GetValue_FrameworkElement ()
        {
            ItemsControl widget = new ItemsControl ();
            object retval;

            retval = widget.GetValue(FrameworkElement.LanguageProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.LanguageProperty) should not have returned null");
            Assert.IsTrue(retval is XmlLanguage, "GetValue(FrameworkElement.LanguageProperty) is not of the correct type");
            Assert.AreEqual("en-us", ((XmlLanguage) retval).IetfLanguageTag, "GetValue(FrameworkElement.LanguageProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.ActualWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.ActualWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.ActualWidthProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.ActualWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.ActualHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.ActualHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.ActualHeightProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.ActualHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.WidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.WidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.WidthProperty) is not of the correct type");
            Assert.IsTrue(Double.IsNaN((double) retval), "GetValue(FrameworkElement.WidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.HeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.HeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.HeightProperty) is not of the correct type");
            Assert.IsTrue(Double.IsNaN((double) retval), "GetValue(FrameworkElement.HeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MinWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MinWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MinWidthProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.MinWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MaxWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MaxWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MaxWidthProperty) is not of the correct type");
            Assert.IsTrue(Double.IsPositiveInfinity((double) retval), "GetValue(FrameworkElement.MaxWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MinHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MinHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MinHeightProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.MinHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MaxHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MaxHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MaxHeightProperty) is not of the correct type");
            Assert.IsTrue(Double.IsPositiveInfinity((double) retval), "GetValue(FrameworkElement.MaxHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.HorizontalAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.HorizontalAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is HorizontalAlignment, "GetValue(FrameworkElement.HorizontalAlignmentProperty) is not of the correct type");
            Assert.AreEqual(HorizontalAlignment.Stretch, retval, "GetValue(FrameworkElement.HorizontalAlignmentProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.VerticalAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.VerticalAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is VerticalAlignment, "GetValue(FrameworkElement.VerticalAlignmentProperty) is not of the correct type");
            Assert.AreEqual(VerticalAlignment.Stretch, retval, "GetValue(FrameworkElement.VerticalAlignmentProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MarginProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MarginProperty) should not have returned null");
            Assert.IsTrue(retval is Thickness, "GetValue(FrameworkElement.MarginProperty) is not of the correct type");
            Assert.AreEqual("0,0,0,0", retval.ToString (), "GetValue(FrameworkElement.MarginProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.StyleProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.StyleProperty) should have returned null");
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.NameProperty) should not have returned null");
            Assert.IsTrue(retval is string, "GetValue(FrameworkElement.NameProperty) is not of the correct type");
            Assert.AreEqual("", retval, "GetValue(FrameworkElement.NameProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.TagProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.TagProperty) should have returned null");
            retval = widget.GetValue(FrameworkElement.DataContextProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.DataContextProperty) should have returned null");
        }

        [TestMethod]
        public void Test_GetValue_UIElement ()
        {
            ItemsControl widget = new ItemsControl ();
            object retval;

            retval = widget.GetValue(UIElement.OpacityProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.OpacityProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(UIElement.OpacityProperty) is not of the correct type");
            Assert.AreEqual((double) 1, retval, "GetValue(UIElement.OpacityProperty) does not match the default value");
            retval = widget.GetValue(UIElement.ClipProperty);
            Assert.IsNull(retval, "GetValue(UIElement.ClipProperty) should have returned null");
            retval = widget.GetValue(UIElement.RenderTransformProperty);
            Assert.IsNull(retval, "GetValue(UIElement.RenderTransformProperty) should have returned null");
            retval = widget.GetValue(UIElement.OpacityMaskProperty);
            Assert.IsNull(retval, "GetValue(UIElement.OpacityMaskProperty) should have returned null");
            retval = widget.GetValue(UIElement.RenderTransformOriginProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.RenderTransformOriginProperty) should not have returned null");
            Assert.IsTrue(retval is Point, "GetValue(UIElement.RenderTransformOriginProperty) is not of the correct type");
            Assert.AreEqual("0,0", retval.ToString (), "GetValue(UIElement.RenderTransformOriginProperty) does not match the default value");
            retval = widget.GetValue(UIElement.IsHitTestVisibleProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.IsHitTestVisibleProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(UIElement.IsHitTestVisibleProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(UIElement.IsHitTestVisibleProperty) does not match the default value");
            retval = widget.GetValue(UIElement.VisibilityProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.VisibilityProperty) should not have returned null");
            Assert.IsTrue(retval is Visibility, "GetValue(UIElement.VisibilityProperty) is not of the correct type");
            Assert.AreEqual(Visibility.Visible, retval, "GetValue(UIElement.VisibilityProperty) does not match the default value");
            retval = widget.GetValue(UIElement.UseLayoutRoundingProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.UseLayoutRoundingProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(UIElement.UseLayoutRoundingProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(UIElement.UseLayoutRoundingProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_ItemsControl ()
        {
            ItemsControl widget = new ItemsControl ();

            Assert.IsNotNull(widget.Items, "Items should not have returned null");
            Assert.IsTrue(widget.Items is ItemCollection, "Items is not of the correct type");
            Assert.IsNull(widget.ItemTemplate, "ItemTemplate should have returned null");
            Assert.IsNull(widget.ItemsPanel, "ItemsPanel should have returned null");
            Assert.IsNull(widget.DisplayMemberPath, "DisplayMemberPath should have returned null");
            Assert.IsNull(widget.ItemsSource, "ItemsSource should have returned null");
            Assert.AreEqual(true, widget.IsTabStop, "IsTabStop does not match the default value");
            Assert.AreEqual(true, widget.IsEnabled, "IsEnabled does not match the default value");
            Assert.AreEqual(2147483647, widget.TabIndex, "TabIndex does not match the default value");
            Assert.AreEqual(KeyboardNavigationMode.Local, widget.TabNavigation, "TabNavigation does not match the default value");
            Assert.IsNull(widget.Template, "Template should have returned null");
            Assert.AreEqual("0,0,0,0", widget.Padding.ToString (), "Padding does not match the default value");
            Assert.AreEqual("0,0,0,0", widget.BorderThickness.ToString (), "BorderThickness does not match the default value");
            Assert.AreEqual(HorizontalAlignment.Center, widget.HorizontalContentAlignment, "HorizontalContentAlignment does not match the default value");
            Assert.AreEqual(VerticalAlignment.Center, widget.VerticalContentAlignment, "VerticalContentAlignment does not match the default value");
            Assert.IsNull(widget.Background, "Background should have returned null");
            Assert.IsNull(widget.BorderBrush, "BorderBrush should have returned null");
            Assert.IsNotNull(widget.FontFamily, "FontFamily should not have returned null");
            Assert.AreEqual("Portable User Interface", widget.FontFamily.ToString (), "FontFamily does not match the default value");
            Assert.AreEqual((double) 11, widget.FontSize, "FontSize does not match the default value");
            Assert.AreEqual("Normal", widget.FontStretch.ToString (), "FontStretch does not match the default value");
            Assert.AreEqual("Normal", widget.FontStyle.ToString (), "FontStyle does not match the default value");
            Assert.AreEqual("Normal", widget.FontWeight.ToString (), "FontWeight does not match the default value");
            Assert.IsNotNull(widget.Foreground, "Foreground should not have returned null");
            Assert.IsTrue(widget.Foreground is SolidColorBrush, "Foreground is not of the correct type");
            Assert.IsNotNull(widget.Triggers, "Triggers should not have returned null");
            Assert.IsTrue(widget.Triggers is TriggerCollection, "Triggers is not of the correct type");
            Assert.IsNotNull(widget.Resources, "Resources should not have returned null");
            Assert.IsTrue(widget.Resources is ResourceDictionary, "Resources is not of the correct type");
            Assert.AreEqual((double) 0, widget.ActualWidth, "ActualWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.ActualHeight, "ActualHeight does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Width), "Width does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Height), "Height does not match the default value");
            Assert.AreEqual((double) 0, widget.MinWidth, "MinWidth does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxWidth), "MaxWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.MinHeight, "MinHeight does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxHeight), "MaxHeight does not match the default value");
            Assert.AreEqual(HorizontalAlignment.Stretch, widget.HorizontalAlignment, "HorizontalAlignment does not match the default value");
            Assert.AreEqual(VerticalAlignment.Stretch, widget.VerticalAlignment, "VerticalAlignment does not match the default value");
            Assert.AreEqual("0,0,0,0", widget.Margin.ToString (), "Margin does not match the default value");
            Assert.IsNull(widget.Style, "Style should have returned null");
            Assert.IsNull(widget.Parent, "Parent should have returned null");
            Assert.IsNotNull(widget.Name, "Name should not have returned null");
            Assert.AreEqual("", widget.Name, "Name does not match the default value");
            Assert.IsNull(widget.Tag, "Tag should have returned null");
            Assert.IsNull(widget.Cursor, "Cursor should have returned null");
            Assert.IsNotNull(widget.Language, "Language should not have returned null");
            Assert.AreEqual("en-us", widget.Language.IetfLanguageTag, "Language does not match the default value");
            Assert.IsNull(widget.DataContext, "DataContext should have returned null");
            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNull(widget.Clip, "Clip should have returned null");
            Assert.IsNull(widget.OpacityMask, "OpacityMask should have returned null");
            Assert.AreEqual("0,0", widget.RenderTransformOrigin.ToString (), "RenderTransformOrigin does not match the default value");
            Assert.AreEqual(true, widget.IsHitTestVisible, "IsHitTestVisible does not match the default value");
            Assert.AreEqual(Visibility.Visible, widget.Visibility, "Visibility does not match the default value");
            Assert.AreEqual("0,0", widget.RenderSize.ToString (), "RenderSize does not match the default value");
            Assert.AreEqual(true, widget.UseLayoutRounding, "UseLayoutRounding does not match the default value");
            Assert.AreEqual("0,0", widget.DesiredSize.ToString (), "DesiredSize does not match the default value");
            Assert.IsNotNull(widget.RenderTransform, "RenderTransform should not have returned null");
            Assert.IsTrue(widget.RenderTransform is MatrixTransform, "RenderTransform is not of the correct type");
        }

        [TestMethod]
        public void Test_PropertyGetter_FrameworkElement ()
        {
            ItemsControl widget = new ItemsControl ();

            Assert.IsNotNull(widget.Triggers, "Triggers should not have returned null");
            Assert.IsTrue(widget.Triggers is TriggerCollection, "Triggers is not of the correct type");
            Assert.IsNotNull(widget.Resources, "Resources should not have returned null");
            Assert.IsTrue(widget.Resources is ResourceDictionary, "Resources is not of the correct type");
            Assert.AreEqual((double) 0, widget.ActualWidth, "ActualWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.ActualHeight, "ActualHeight does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Width), "Width does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Height), "Height does not match the default value");
            Assert.AreEqual((double) 0, widget.MinWidth, "MinWidth does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxWidth), "MaxWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.MinHeight, "MinHeight does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxHeight), "MaxHeight does not match the default value");
            Assert.AreEqual(HorizontalAlignment.Stretch, widget.HorizontalAlignment, "HorizontalAlignment does not match the default value");
            Assert.AreEqual(VerticalAlignment.Stretch, widget.VerticalAlignment, "VerticalAlignment does not match the default value");
            Assert.AreEqual("0,0,0,0", widget.Margin.ToString (), "Margin does not match the default value");
            Assert.IsNull(widget.Style, "Style should have returned null");
            Assert.IsNull(widget.Parent, "Parent should have returned null");
            Assert.IsNotNull(widget.Name, "Name should not have returned null");
            Assert.AreEqual("", widget.Name, "Name does not match the default value");
            Assert.IsNull(widget.Tag, "Tag should have returned null");
            Assert.IsNull(widget.Cursor, "Cursor should have returned null");
            Assert.IsNotNull(widget.Language, "Language should not have returned null");
            Assert.AreEqual("en-us", widget.Language.IetfLanguageTag, "Language does not match the default value");
            Assert.IsNull(widget.DataContext, "DataContext should have returned null");
            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNull(widget.Clip, "Clip should have returned null");
            Assert.IsNull(widget.OpacityMask, "OpacityMask should have returned null");
            Assert.AreEqual("0,0", widget.RenderTransformOrigin.ToString (), "RenderTransformOrigin does not match the default value");
            Assert.AreEqual(true, widget.IsHitTestVisible, "IsHitTestVisible does not match the default value");
            Assert.AreEqual(Visibility.Visible, widget.Visibility, "Visibility does not match the default value");
            Assert.AreEqual("0,0", widget.RenderSize.ToString (), "RenderSize does not match the default value");
            Assert.AreEqual(true, widget.UseLayoutRounding, "UseLayoutRounding does not match the default value");
            Assert.AreEqual("0,0", widget.DesiredSize.ToString (), "DesiredSize does not match the default value");
            Assert.IsNotNull(widget.RenderTransform, "RenderTransform should not have returned null");
            Assert.IsTrue(widget.RenderTransform is MatrixTransform, "RenderTransform is not of the correct type");
        }

        [TestMethod]
        public void Test_SetStringValue_ItemsControl ()
        {
            ItemsControl widget = new ItemsControl ();
            object retval;

            widget.SetValue(ItemsControl.DisplayMemberPathProperty, "some text");
            retval = widget.GetValue(ItemsControl.DisplayMemberPathProperty);
            Assert.AreEqual("some text", retval, "GetValue(ItemsControl.DisplayMemberPathProperty) should have returned 'some text'");
            widget.SetValue(ItemsControl.DisplayMemberPathProperty, null);
            retval = widget.GetValue(ItemsControl.DisplayMemberPathProperty);
            Assert.IsNull(retval, "GetValue(ItemsControl.DisplayMemberPathProperty) should have returned null");
        }

        [TestMethod]
	[MoonlightBug]
        public void Test_SetStringValue_FrameworkElement ()
        {
            ItemsControl widget = new ItemsControl ();
            object retval;

            widget.SetValue(FrameworkElement.NameProperty, "some text");
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.AreEqual("some text", retval, "GetValue(FrameworkElement.NameProperty) should have returned 'some text'");
            widget.SetValue(FrameworkElement.NameProperty, null);
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.AreEqual(String.Empty, retval, "GetValue(FrameworkElement.NameProperty) should have returned String.Empty");
            retval = widget.ReadLocalValue(FrameworkElement.NameProperty);
            Assert.AreEqual(String.Empty, retval, "ReadLocalValue(FrameworkElement.NameProperty) should have returned String.Empty");
        }

    }
}
namespace MoonTest.System.Windows.Controls
{
    public partial class BorderTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_Border ()
        {
            Border widget = new Border ();
            object retval;

            retval = widget.ReadLocalValue(Border.BorderBrushProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Border.BorderBrushProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Border.BorderThicknessProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Border.BorderThicknessProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Border.BackgroundProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Border.BackgroundProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Border.CornerRadiusProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Border.CornerRadiusProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Border.PaddingProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Border.PaddingProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_FrameworkElement ()
        {
            Border widget = new Border ();
            object retval;

            retval = widget.ReadLocalValue(FrameworkElement.LanguageProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.LanguageProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.ActualWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.ActualWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.ActualHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.ActualHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.WidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.WidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.HeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.HeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MinWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MinWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MaxWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MaxWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MinHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MinHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MaxHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MaxHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.HorizontalAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.HorizontalAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.VerticalAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.VerticalAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MarginProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MarginProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.StyleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.StyleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.NameProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.NameProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.TagProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.TagProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.DataContextProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.DataContextProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_UIElement ()
        {
            Border widget = new Border ();
            object retval;

            retval = widget.ReadLocalValue(UIElement.OpacityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.OpacityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.ClipProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.ClipProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.RenderTransformProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.RenderTransformProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.OpacityMaskProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.OpacityMaskProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.RenderTransformOriginProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.RenderTransformOriginProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.IsHitTestVisibleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.IsHitTestVisibleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.VisibilityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.VisibilityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.UseLayoutRoundingProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.UseLayoutRoundingProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_Border ()
        {
            Border widget = new Border ();
            object retval;

            retval = widget.GetValue(Border.BorderBrushProperty);
            Assert.IsNull(retval, "GetValue(Border.BorderBrushProperty) should have returned null");
            retval = widget.GetValue(Border.BorderThicknessProperty);
            Assert.IsNotNull(retval, "GetValue(Border.BorderThicknessProperty) should not have returned null");
            Assert.IsTrue(retval is Thickness, "GetValue(Border.BorderThicknessProperty) is not of the correct type");
            Assert.AreEqual("0,0,0,0", retval.ToString (), "GetValue(Border.BorderThicknessProperty) does not match the default value");
            retval = widget.GetValue(Border.BackgroundProperty);
            Assert.IsNull(retval, "GetValue(Border.BackgroundProperty) should have returned null");
            retval = widget.GetValue(Border.CornerRadiusProperty);
            Assert.IsNotNull(retval, "GetValue(Border.CornerRadiusProperty) should not have returned null");
            Assert.IsTrue(retval is CornerRadius, "GetValue(Border.CornerRadiusProperty) is not of the correct type");
            Assert.AreEqual("0,0,0,0", retval.ToString (), "GetValue(Border.CornerRadiusProperty) does not match the default value");
            retval = widget.GetValue(Border.PaddingProperty);
            Assert.IsNotNull(retval, "GetValue(Border.PaddingProperty) should not have returned null");
            Assert.IsTrue(retval is Thickness, "GetValue(Border.PaddingProperty) is not of the correct type");
            Assert.AreEqual("0,0,0,0", retval.ToString (), "GetValue(Border.PaddingProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_GetValue_FrameworkElement ()
        {
            Border widget = new Border ();
            object retval;

            retval = widget.GetValue(FrameworkElement.LanguageProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.LanguageProperty) should not have returned null");
            Assert.IsTrue(retval is XmlLanguage, "GetValue(FrameworkElement.LanguageProperty) is not of the correct type");
            Assert.AreEqual("en-us", ((XmlLanguage) retval).IetfLanguageTag, "GetValue(FrameworkElement.LanguageProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.ActualWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.ActualWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.ActualWidthProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.ActualWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.ActualHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.ActualHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.ActualHeightProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.ActualHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.WidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.WidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.WidthProperty) is not of the correct type");
            Assert.IsTrue(Double.IsNaN((double) retval), "GetValue(FrameworkElement.WidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.HeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.HeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.HeightProperty) is not of the correct type");
            Assert.IsTrue(Double.IsNaN((double) retval), "GetValue(FrameworkElement.HeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MinWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MinWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MinWidthProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.MinWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MaxWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MaxWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MaxWidthProperty) is not of the correct type");
            Assert.IsTrue(Double.IsPositiveInfinity((double) retval), "GetValue(FrameworkElement.MaxWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MinHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MinHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MinHeightProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.MinHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MaxHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MaxHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MaxHeightProperty) is not of the correct type");
            Assert.IsTrue(Double.IsPositiveInfinity((double) retval), "GetValue(FrameworkElement.MaxHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.HorizontalAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.HorizontalAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is HorizontalAlignment, "GetValue(FrameworkElement.HorizontalAlignmentProperty) is not of the correct type");
            Assert.AreEqual(HorizontalAlignment.Stretch, retval, "GetValue(FrameworkElement.HorizontalAlignmentProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.VerticalAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.VerticalAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is VerticalAlignment, "GetValue(FrameworkElement.VerticalAlignmentProperty) is not of the correct type");
            Assert.AreEqual(VerticalAlignment.Stretch, retval, "GetValue(FrameworkElement.VerticalAlignmentProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MarginProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MarginProperty) should not have returned null");
            Assert.IsTrue(retval is Thickness, "GetValue(FrameworkElement.MarginProperty) is not of the correct type");
            Assert.AreEqual("0,0,0,0", retval.ToString (), "GetValue(FrameworkElement.MarginProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.StyleProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.StyleProperty) should have returned null");
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.NameProperty) should not have returned null");
            Assert.IsTrue(retval is string, "GetValue(FrameworkElement.NameProperty) is not of the correct type");
            Assert.AreEqual("", retval, "GetValue(FrameworkElement.NameProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.TagProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.TagProperty) should have returned null");
            retval = widget.GetValue(FrameworkElement.DataContextProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.DataContextProperty) should have returned null");
        }

        [TestMethod]
        public void Test_GetValue_UIElement ()
        {
            Border widget = new Border ();
            object retval;

            retval = widget.GetValue(UIElement.OpacityProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.OpacityProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(UIElement.OpacityProperty) is not of the correct type");
            Assert.AreEqual((double) 1, retval, "GetValue(UIElement.OpacityProperty) does not match the default value");
            retval = widget.GetValue(UIElement.ClipProperty);
            Assert.IsNull(retval, "GetValue(UIElement.ClipProperty) should have returned null");
            retval = widget.GetValue(UIElement.RenderTransformProperty);
            Assert.IsNull(retval, "GetValue(UIElement.RenderTransformProperty) should have returned null");
            retval = widget.GetValue(UIElement.OpacityMaskProperty);
            Assert.IsNull(retval, "GetValue(UIElement.OpacityMaskProperty) should have returned null");
            retval = widget.GetValue(UIElement.RenderTransformOriginProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.RenderTransformOriginProperty) should not have returned null");
            Assert.IsTrue(retval is Point, "GetValue(UIElement.RenderTransformOriginProperty) is not of the correct type");
            Assert.AreEqual("0,0", retval.ToString (), "GetValue(UIElement.RenderTransformOriginProperty) does not match the default value");
            retval = widget.GetValue(UIElement.IsHitTestVisibleProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.IsHitTestVisibleProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(UIElement.IsHitTestVisibleProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(UIElement.IsHitTestVisibleProperty) does not match the default value");
            retval = widget.GetValue(UIElement.VisibilityProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.VisibilityProperty) should not have returned null");
            Assert.IsTrue(retval is Visibility, "GetValue(UIElement.VisibilityProperty) is not of the correct type");
            Assert.AreEqual(Visibility.Visible, retval, "GetValue(UIElement.VisibilityProperty) does not match the default value");
            retval = widget.GetValue(UIElement.UseLayoutRoundingProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.UseLayoutRoundingProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(UIElement.UseLayoutRoundingProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(UIElement.UseLayoutRoundingProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_Border ()
        {
            Border widget = new Border ();

            Assert.IsNull(widget.BorderBrush, "BorderBrush should have returned null");
            Assert.AreEqual("0,0,0,0", widget.BorderThickness.ToString (), "BorderThickness does not match the default value");
            Assert.IsNull(widget.Background, "Background should have returned null");
            Assert.AreEqual("0,0,0,0", widget.CornerRadius.ToString (), "CornerRadius does not match the default value");
            Assert.AreEqual("0,0,0,0", widget.Padding.ToString (), "Padding does not match the default value");
            Assert.IsNull(widget.Child, "Child should have returned null");
            Assert.IsNotNull(widget.Triggers, "Triggers should not have returned null");
            Assert.IsTrue(widget.Triggers is TriggerCollection, "Triggers is not of the correct type");
            Assert.IsNotNull(widget.Resources, "Resources should not have returned null");
            Assert.IsTrue(widget.Resources is ResourceDictionary, "Resources is not of the correct type");
            Assert.AreEqual((double) 0, widget.ActualWidth, "ActualWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.ActualHeight, "ActualHeight does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Width), "Width does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Height), "Height does not match the default value");
            Assert.AreEqual((double) 0, widget.MinWidth, "MinWidth does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxWidth), "MaxWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.MinHeight, "MinHeight does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxHeight), "MaxHeight does not match the default value");
            Assert.AreEqual(HorizontalAlignment.Stretch, widget.HorizontalAlignment, "HorizontalAlignment does not match the default value");
            Assert.AreEqual(VerticalAlignment.Stretch, widget.VerticalAlignment, "VerticalAlignment does not match the default value");
            Assert.AreEqual("0,0,0,0", widget.Margin.ToString (), "Margin does not match the default value");
            Assert.IsNull(widget.Style, "Style should have returned null");
            Assert.IsNull(widget.Parent, "Parent should have returned null");
            Assert.IsNotNull(widget.Name, "Name should not have returned null");
            Assert.AreEqual("", widget.Name, "Name does not match the default value");
            Assert.IsNull(widget.Tag, "Tag should have returned null");
            Assert.IsNull(widget.Cursor, "Cursor should have returned null");
            Assert.IsNotNull(widget.Language, "Language should not have returned null");
            Assert.AreEqual("en-us", widget.Language.IetfLanguageTag, "Language does not match the default value");
            Assert.IsNull(widget.DataContext, "DataContext should have returned null");
            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNull(widget.Clip, "Clip should have returned null");
            Assert.IsNull(widget.OpacityMask, "OpacityMask should have returned null");
            Assert.AreEqual("0,0", widget.RenderTransformOrigin.ToString (), "RenderTransformOrigin does not match the default value");
            Assert.AreEqual(true, widget.IsHitTestVisible, "IsHitTestVisible does not match the default value");
            Assert.AreEqual(Visibility.Visible, widget.Visibility, "Visibility does not match the default value");
            Assert.AreEqual("0,0", widget.RenderSize.ToString (), "RenderSize does not match the default value");
            Assert.AreEqual(true, widget.UseLayoutRounding, "UseLayoutRounding does not match the default value");
            Assert.AreEqual("0,0", widget.DesiredSize.ToString (), "DesiredSize does not match the default value");
            Assert.IsNotNull(widget.RenderTransform, "RenderTransform should not have returned null");
            Assert.IsTrue(widget.RenderTransform is MatrixTransform, "RenderTransform is not of the correct type");
        }

        [TestMethod]
        public void Test_PropertyGetter_UIElement ()
        {
            Border widget = new Border ();

            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNull(widget.Clip, "Clip should have returned null");
            Assert.IsNull(widget.OpacityMask, "OpacityMask should have returned null");
            Assert.AreEqual("0,0", widget.RenderTransformOrigin.ToString (), "RenderTransformOrigin does not match the default value");
            Assert.AreEqual(true, widget.IsHitTestVisible, "IsHitTestVisible does not match the default value");
            Assert.AreEqual(Visibility.Visible, widget.Visibility, "Visibility does not match the default value");
            Assert.AreEqual("0,0", widget.RenderSize.ToString (), "RenderSize does not match the default value");
            Assert.AreEqual(true, widget.UseLayoutRounding, "UseLayoutRounding does not match the default value");
            Assert.AreEqual("0,0", widget.DesiredSize.ToString (), "DesiredSize does not match the default value");
            Assert.IsNotNull(widget.RenderTransform, "RenderTransform should not have returned null");
            Assert.IsTrue(widget.RenderTransform is MatrixTransform, "RenderTransform is not of the correct type");
        }

        [TestMethod]
	[MoonlightBug]
        public void Test_SetStringValue_FrameworkElement ()
        {
            Border widget = new Border ();
            object retval;

            widget.SetValue(FrameworkElement.NameProperty, "some text");
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.AreEqual("some text", retval, "GetValue(FrameworkElement.NameProperty) should have returned 'some text'");
            widget.SetValue(FrameworkElement.NameProperty, null);
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.AreEqual(String.Empty, retval, "GetValue(FrameworkElement.NameProperty) should have returned String.Empty");
            retval = widget.ReadLocalValue(FrameworkElement.NameProperty);
            Assert.AreEqual(String.Empty, retval, "ReadLocalValue(FrameworkElement.NameProperty) should have returned String.Empty");
        }

    }
}
namespace MoonTest.System.Windows.Controls
{
    public partial class ContentControlTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_ContentControl ()
        {
            ContentControl widget = new ContentControl ();
            object retval;

            retval = widget.ReadLocalValue(ContentControl.ContentTemplateProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(ContentControl.ContentTemplateProperty) should not have a value by default");
            retval = widget.ReadLocalValue(ContentControl.ContentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(ContentControl.ContentProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_Control ()
        {
            ContentControl widget = new ContentControl ();
            object retval;

            retval = widget.ReadLocalValue(Control.IsTabStopProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.IsTabStopProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.TabIndexProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.TabIndexProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.TemplateProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.TemplateProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.TabNavigationProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.TabNavigationProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.PaddingProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.PaddingProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.HorizontalContentAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.HorizontalContentAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.VerticalContentAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.VerticalContentAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.BackgroundProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.BackgroundProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.BorderBrushProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.BorderBrushProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.BorderThicknessProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.BorderThicknessProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.FontSizeProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.FontSizeProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.FontFamilyProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.FontFamilyProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.ForegroundProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.ForegroundProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.FontWeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.FontWeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.FontStyleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.FontStyleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.FontStretchProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.FontStretchProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.IsEnabledProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.IsEnabledProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_FrameworkElement ()
        {
            ContentControl widget = new ContentControl ();
            object retval;

            retval = widget.ReadLocalValue(FrameworkElement.LanguageProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.LanguageProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.ActualWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.ActualWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.ActualHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.ActualHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.WidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.WidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.HeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.HeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MinWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MinWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MaxWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MaxWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MinHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MinHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MaxHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MaxHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.HorizontalAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.HorizontalAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.VerticalAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.VerticalAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MarginProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MarginProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.StyleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.StyleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.NameProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.NameProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.TagProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.TagProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.DataContextProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.DataContextProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_UIElement ()
        {
            ContentControl widget = new ContentControl ();
            object retval;

            retval = widget.ReadLocalValue(UIElement.OpacityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.OpacityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.ClipProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.ClipProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.RenderTransformProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.RenderTransformProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.OpacityMaskProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.OpacityMaskProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.RenderTransformOriginProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.RenderTransformOriginProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.IsHitTestVisibleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.IsHitTestVisibleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.VisibilityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.VisibilityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.UseLayoutRoundingProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.UseLayoutRoundingProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_ContentControl ()
        {
            ContentControl widget = new ContentControl ();
            object retval;

            retval = widget.GetValue(ContentControl.ContentTemplateProperty);
            Assert.IsNull(retval, "GetValue(ContentControl.ContentTemplateProperty) should have returned null");
            retval = widget.GetValue(ContentControl.ContentProperty);
            Assert.IsNull(retval, "GetValue(ContentControl.ContentProperty) should have returned null");
        }

        [TestMethod]
        public void Test_GetValue_Control ()
        {
            ContentControl widget = new ContentControl ();
            object retval;

            retval = widget.GetValue(Control.IsTabStopProperty);
            Assert.IsNotNull(retval, "GetValue(Control.IsTabStopProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(Control.IsTabStopProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(Control.IsTabStopProperty) does not match the default value");
            retval = widget.GetValue(Control.TabIndexProperty);
            Assert.IsNotNull(retval, "GetValue(Control.TabIndexProperty) should not have returned null");
            Assert.IsTrue(retval is int, "GetValue(Control.TabIndexProperty) is not of the correct type");
            Assert.AreEqual(2147483647, retval, "GetValue(Control.TabIndexProperty) does not match the default value");
            retval = widget.GetValue(Control.TemplateProperty);
            Assert.IsNull(retval, "GetValue(Control.TemplateProperty) should have returned null");
            retval = widget.GetValue(Control.TabNavigationProperty);
            Assert.IsNotNull(retval, "GetValue(Control.TabNavigationProperty) should not have returned null");
            Assert.IsTrue(retval is KeyboardNavigationMode, "GetValue(Control.TabNavigationProperty) is not of the correct type");
            Assert.AreEqual(KeyboardNavigationMode.Local, retval, "GetValue(Control.TabNavigationProperty) does not match the default value");
            retval = widget.GetValue(Control.PaddingProperty);
            Assert.IsNotNull(retval, "GetValue(Control.PaddingProperty) should not have returned null");
            Assert.IsTrue(retval is Thickness, "GetValue(Control.PaddingProperty) is not of the correct type");
            Assert.AreEqual("0,0,0,0", retval.ToString (), "GetValue(Control.PaddingProperty) does not match the default value");
            retval = widget.GetValue(Control.HorizontalContentAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(Control.HorizontalContentAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is HorizontalAlignment, "GetValue(Control.HorizontalContentAlignmentProperty) is not of the correct type");
            Assert.AreEqual(HorizontalAlignment.Center, retval, "GetValue(Control.HorizontalContentAlignmentProperty) does not match the default value");
            retval = widget.GetValue(Control.VerticalContentAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(Control.VerticalContentAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is VerticalAlignment, "GetValue(Control.VerticalContentAlignmentProperty) is not of the correct type");
            Assert.AreEqual(VerticalAlignment.Center, retval, "GetValue(Control.VerticalContentAlignmentProperty) does not match the default value");
            retval = widget.GetValue(Control.BackgroundProperty);
            Assert.IsNull(retval, "GetValue(Control.BackgroundProperty) should have returned null");
            retval = widget.GetValue(Control.BorderBrushProperty);
            Assert.IsNull(retval, "GetValue(Control.BorderBrushProperty) should have returned null");
            retval = widget.GetValue(Control.BorderThicknessProperty);
            Assert.IsNotNull(retval, "GetValue(Control.BorderThicknessProperty) should not have returned null");
            Assert.IsTrue(retval is Thickness, "GetValue(Control.BorderThicknessProperty) is not of the correct type");
            Assert.AreEqual("0,0,0,0", retval.ToString (), "GetValue(Control.BorderThicknessProperty) does not match the default value");
            retval = widget.GetValue(Control.FontSizeProperty);
            Assert.IsNotNull(retval, "GetValue(Control.FontSizeProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Control.FontSizeProperty) is not of the correct type");
            Assert.AreEqual((double) 11, retval, "GetValue(Control.FontSizeProperty) does not match the default value");
            retval = widget.GetValue(Control.FontFamilyProperty);
            Assert.IsNotNull(retval, "GetValue(Control.FontFamilyProperty) should not have returned null");
            Assert.IsTrue(retval is FontFamily, "GetValue(Control.FontFamilyProperty) is not of the correct type");
            Assert.AreEqual("Portable User Interface", retval.ToString (), "GetValue(Control.FontFamilyProperty) does not match the default value");
            retval = widget.GetValue(Control.ForegroundProperty);
            Assert.IsNotNull(retval, "GetValue(Control.ForegroundProperty) should not have returned null");
            Assert.IsTrue(retval is SolidColorBrush, "GetValue(Control.ForegroundProperty) is not of the correct type");
            retval = widget.GetValue(Control.FontWeightProperty);
            Assert.IsNotNull(retval, "GetValue(Control.FontWeightProperty) should not have returned null");
            Assert.IsTrue(retval is FontWeight, "GetValue(Control.FontWeightProperty) is not of the correct type");
            Assert.AreEqual("Normal", retval.ToString (), "GetValue(Control.FontWeightProperty) does not match the default value");
            retval = widget.GetValue(Control.FontStyleProperty);
            Assert.IsNotNull(retval, "GetValue(Control.FontStyleProperty) should not have returned null");
            Assert.IsTrue(retval is FontStyle, "GetValue(Control.FontStyleProperty) is not of the correct type");
            Assert.AreEqual("Normal", retval.ToString (), "GetValue(Control.FontStyleProperty) does not match the default value");
            retval = widget.GetValue(Control.FontStretchProperty);
            Assert.IsNotNull(retval, "GetValue(Control.FontStretchProperty) should not have returned null");
            Assert.IsTrue(retval is FontStretch, "GetValue(Control.FontStretchProperty) is not of the correct type");
            Assert.AreEqual("Normal", retval.ToString (), "GetValue(Control.FontStretchProperty) does not match the default value");
            retval = widget.GetValue(Control.IsEnabledProperty);
            Assert.IsNotNull(retval, "GetValue(Control.IsEnabledProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(Control.IsEnabledProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(Control.IsEnabledProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_GetValue_FrameworkElement ()
        {
            ContentControl widget = new ContentControl ();
            object retval;

            retval = widget.GetValue(FrameworkElement.LanguageProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.LanguageProperty) should not have returned null");
            Assert.IsTrue(retval is XmlLanguage, "GetValue(FrameworkElement.LanguageProperty) is not of the correct type");
            Assert.AreEqual("en-us", ((XmlLanguage) retval).IetfLanguageTag, "GetValue(FrameworkElement.LanguageProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.ActualWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.ActualWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.ActualWidthProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.ActualWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.ActualHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.ActualHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.ActualHeightProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.ActualHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.WidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.WidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.WidthProperty) is not of the correct type");
            Assert.IsTrue(Double.IsNaN((double) retval), "GetValue(FrameworkElement.WidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.HeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.HeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.HeightProperty) is not of the correct type");
            Assert.IsTrue(Double.IsNaN((double) retval), "GetValue(FrameworkElement.HeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MinWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MinWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MinWidthProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.MinWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MaxWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MaxWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MaxWidthProperty) is not of the correct type");
            Assert.IsTrue(Double.IsPositiveInfinity((double) retval), "GetValue(FrameworkElement.MaxWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MinHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MinHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MinHeightProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.MinHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MaxHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MaxHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MaxHeightProperty) is not of the correct type");
            Assert.IsTrue(Double.IsPositiveInfinity((double) retval), "GetValue(FrameworkElement.MaxHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.HorizontalAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.HorizontalAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is HorizontalAlignment, "GetValue(FrameworkElement.HorizontalAlignmentProperty) is not of the correct type");
            Assert.AreEqual(HorizontalAlignment.Stretch, retval, "GetValue(FrameworkElement.HorizontalAlignmentProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.VerticalAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.VerticalAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is VerticalAlignment, "GetValue(FrameworkElement.VerticalAlignmentProperty) is not of the correct type");
            Assert.AreEqual(VerticalAlignment.Stretch, retval, "GetValue(FrameworkElement.VerticalAlignmentProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MarginProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MarginProperty) should not have returned null");
            Assert.IsTrue(retval is Thickness, "GetValue(FrameworkElement.MarginProperty) is not of the correct type");
            Assert.AreEqual("0,0,0,0", retval.ToString (), "GetValue(FrameworkElement.MarginProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.StyleProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.StyleProperty) should have returned null");
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.NameProperty) should not have returned null");
            Assert.IsTrue(retval is string, "GetValue(FrameworkElement.NameProperty) is not of the correct type");
            Assert.AreEqual("", retval, "GetValue(FrameworkElement.NameProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.TagProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.TagProperty) should have returned null");
            retval = widget.GetValue(FrameworkElement.DataContextProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.DataContextProperty) should have returned null");
        }

        [TestMethod]
        public void Test_GetValue_UIElement ()
        {
            ContentControl widget = new ContentControl ();
            object retval;

            retval = widget.GetValue(UIElement.OpacityProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.OpacityProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(UIElement.OpacityProperty) is not of the correct type");
            Assert.AreEqual((double) 1, retval, "GetValue(UIElement.OpacityProperty) does not match the default value");
            retval = widget.GetValue(UIElement.ClipProperty);
            Assert.IsNull(retval, "GetValue(UIElement.ClipProperty) should have returned null");
            retval = widget.GetValue(UIElement.RenderTransformProperty);
            Assert.IsNull(retval, "GetValue(UIElement.RenderTransformProperty) should have returned null");
            retval = widget.GetValue(UIElement.OpacityMaskProperty);
            Assert.IsNull(retval, "GetValue(UIElement.OpacityMaskProperty) should have returned null");
            retval = widget.GetValue(UIElement.RenderTransformOriginProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.RenderTransformOriginProperty) should not have returned null");
            Assert.IsTrue(retval is Point, "GetValue(UIElement.RenderTransformOriginProperty) is not of the correct type");
            Assert.AreEqual("0,0", retval.ToString (), "GetValue(UIElement.RenderTransformOriginProperty) does not match the default value");
            retval = widget.GetValue(UIElement.IsHitTestVisibleProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.IsHitTestVisibleProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(UIElement.IsHitTestVisibleProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(UIElement.IsHitTestVisibleProperty) does not match the default value");
            retval = widget.GetValue(UIElement.VisibilityProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.VisibilityProperty) should not have returned null");
            Assert.IsTrue(retval is Visibility, "GetValue(UIElement.VisibilityProperty) is not of the correct type");
            Assert.AreEqual(Visibility.Visible, retval, "GetValue(UIElement.VisibilityProperty) does not match the default value");
            retval = widget.GetValue(UIElement.UseLayoutRoundingProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.UseLayoutRoundingProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(UIElement.UseLayoutRoundingProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(UIElement.UseLayoutRoundingProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_ContentControl ()
        {
            ContentControl widget = new ContentControl ();

            Assert.IsNull(widget.Content, "Content should have returned null");
            Assert.IsNull(widget.ContentTemplate, "ContentTemplate should have returned null");
            Assert.AreEqual(true, widget.IsTabStop, "IsTabStop does not match the default value");
            Assert.AreEqual(true, widget.IsEnabled, "IsEnabled does not match the default value");
            Assert.AreEqual(2147483647, widget.TabIndex, "TabIndex does not match the default value");
            Assert.AreEqual(KeyboardNavigationMode.Local, widget.TabNavigation, "TabNavigation does not match the default value");
            Assert.IsNull(widget.Template, "Template should have returned null");
            Assert.AreEqual("0,0,0,0", widget.Padding.ToString (), "Padding does not match the default value");
            Assert.AreEqual("0,0,0,0", widget.BorderThickness.ToString (), "BorderThickness does not match the default value");
            Assert.AreEqual(HorizontalAlignment.Center, widget.HorizontalContentAlignment, "HorizontalContentAlignment does not match the default value");
            Assert.AreEqual(VerticalAlignment.Center, widget.VerticalContentAlignment, "VerticalContentAlignment does not match the default value");
            Assert.IsNull(widget.Background, "Background should have returned null");
            Assert.IsNull(widget.BorderBrush, "BorderBrush should have returned null");
            Assert.IsNotNull(widget.FontFamily, "FontFamily should not have returned null");
            Assert.AreEqual("Portable User Interface", widget.FontFamily.ToString (), "FontFamily does not match the default value");
            Assert.AreEqual((double) 11, widget.FontSize, "FontSize does not match the default value");
            Assert.AreEqual("Normal", widget.FontStretch.ToString (), "FontStretch does not match the default value");
            Assert.AreEqual("Normal", widget.FontStyle.ToString (), "FontStyle does not match the default value");
            Assert.AreEqual("Normal", widget.FontWeight.ToString (), "FontWeight does not match the default value");
            Assert.IsNotNull(widget.Foreground, "Foreground should not have returned null");
            Assert.IsTrue(widget.Foreground is SolidColorBrush, "Foreground is not of the correct type");
            Assert.IsNotNull(widget.Triggers, "Triggers should not have returned null");
            Assert.IsTrue(widget.Triggers is TriggerCollection, "Triggers is not of the correct type");
            Assert.IsNotNull(widget.Resources, "Resources should not have returned null");
            Assert.IsTrue(widget.Resources is ResourceDictionary, "Resources is not of the correct type");
            Assert.AreEqual((double) 0, widget.ActualWidth, "ActualWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.ActualHeight, "ActualHeight does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Width), "Width does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Height), "Height does not match the default value");
            Assert.AreEqual((double) 0, widget.MinWidth, "MinWidth does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxWidth), "MaxWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.MinHeight, "MinHeight does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxHeight), "MaxHeight does not match the default value");
            Assert.AreEqual(HorizontalAlignment.Stretch, widget.HorizontalAlignment, "HorizontalAlignment does not match the default value");
            Assert.AreEqual(VerticalAlignment.Stretch, widget.VerticalAlignment, "VerticalAlignment does not match the default value");
            Assert.AreEqual("0,0,0,0", widget.Margin.ToString (), "Margin does not match the default value");
            Assert.IsNull(widget.Style, "Style should have returned null");
            Assert.IsNull(widget.Parent, "Parent should have returned null");
            Assert.IsNotNull(widget.Name, "Name should not have returned null");
            Assert.AreEqual("", widget.Name, "Name does not match the default value");
            Assert.IsNull(widget.Tag, "Tag should have returned null");
            Assert.IsNull(widget.Cursor, "Cursor should have returned null");
            Assert.IsNotNull(widget.Language, "Language should not have returned null");
            Assert.AreEqual("en-us", widget.Language.IetfLanguageTag, "Language does not match the default value");
            Assert.IsNull(widget.DataContext, "DataContext should have returned null");
            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNull(widget.Clip, "Clip should have returned null");
            Assert.IsNull(widget.OpacityMask, "OpacityMask should have returned null");
            Assert.AreEqual("0,0", widget.RenderTransformOrigin.ToString (), "RenderTransformOrigin does not match the default value");
            Assert.AreEqual(true, widget.IsHitTestVisible, "IsHitTestVisible does not match the default value");
            Assert.AreEqual(Visibility.Visible, widget.Visibility, "Visibility does not match the default value");
            Assert.AreEqual("0,0", widget.RenderSize.ToString (), "RenderSize does not match the default value");
            Assert.AreEqual(true, widget.UseLayoutRounding, "UseLayoutRounding does not match the default value");
            Assert.AreEqual("0,0", widget.DesiredSize.ToString (), "DesiredSize does not match the default value");
            Assert.IsNotNull(widget.RenderTransform, "RenderTransform should not have returned null");
            Assert.IsTrue(widget.RenderTransform is MatrixTransform, "RenderTransform is not of the correct type");
        }

        [TestMethod]
        public void Test_PropertyGetter_FrameworkElement ()
        {
            ContentControl widget = new ContentControl ();

            Assert.IsNotNull(widget.Triggers, "Triggers should not have returned null");
            Assert.IsTrue(widget.Triggers is TriggerCollection, "Triggers is not of the correct type");
            Assert.IsNotNull(widget.Resources, "Resources should not have returned null");
            Assert.IsTrue(widget.Resources is ResourceDictionary, "Resources is not of the correct type");
            Assert.AreEqual((double) 0, widget.ActualWidth, "ActualWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.ActualHeight, "ActualHeight does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Width), "Width does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Height), "Height does not match the default value");
            Assert.AreEqual((double) 0, widget.MinWidth, "MinWidth does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxWidth), "MaxWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.MinHeight, "MinHeight does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxHeight), "MaxHeight does not match the default value");
            Assert.AreEqual(HorizontalAlignment.Stretch, widget.HorizontalAlignment, "HorizontalAlignment does not match the default value");
            Assert.AreEqual(VerticalAlignment.Stretch, widget.VerticalAlignment, "VerticalAlignment does not match the default value");
            Assert.AreEqual("0,0,0,0", widget.Margin.ToString (), "Margin does not match the default value");
            Assert.IsNull(widget.Style, "Style should have returned null");
            Assert.IsNull(widget.Parent, "Parent should have returned null");
            Assert.IsNotNull(widget.Name, "Name should not have returned null");
            Assert.AreEqual("", widget.Name, "Name does not match the default value");
            Assert.IsNull(widget.Tag, "Tag should have returned null");
            Assert.IsNull(widget.Cursor, "Cursor should have returned null");
            Assert.IsNotNull(widget.Language, "Language should not have returned null");
            Assert.AreEqual("en-us", widget.Language.IetfLanguageTag, "Language does not match the default value");
            Assert.IsNull(widget.DataContext, "DataContext should have returned null");
            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNull(widget.Clip, "Clip should have returned null");
            Assert.IsNull(widget.OpacityMask, "OpacityMask should have returned null");
            Assert.AreEqual("0,0", widget.RenderTransformOrigin.ToString (), "RenderTransformOrigin does not match the default value");
            Assert.AreEqual(true, widget.IsHitTestVisible, "IsHitTestVisible does not match the default value");
            Assert.AreEqual(Visibility.Visible, widget.Visibility, "Visibility does not match the default value");
            Assert.AreEqual("0,0", widget.RenderSize.ToString (), "RenderSize does not match the default value");
            Assert.AreEqual(true, widget.UseLayoutRounding, "UseLayoutRounding does not match the default value");
            Assert.AreEqual("0,0", widget.DesiredSize.ToString (), "DesiredSize does not match the default value");
            Assert.IsNotNull(widget.RenderTransform, "RenderTransform should not have returned null");
            Assert.IsTrue(widget.RenderTransform is MatrixTransform, "RenderTransform is not of the correct type");
        }

        [TestMethod]
	[MoonlightBug]
        public void Test_SetStringValue_FrameworkElement ()
        {
            ContentControl widget = new ContentControl ();
            object retval;

            widget.SetValue(FrameworkElement.NameProperty, "some text");
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.AreEqual("some text", retval, "GetValue(FrameworkElement.NameProperty) should have returned 'some text'");
            widget.SetValue(FrameworkElement.NameProperty, null);
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.AreEqual(String.Empty, retval, "GetValue(FrameworkElement.NameProperty) should have returned String.Empty");
            retval = widget.ReadLocalValue(FrameworkElement.NameProperty);
            Assert.AreEqual(String.Empty, retval, "ReadLocalValue(FrameworkElement.NameProperty) should have returned String.Empty");
        }

    }
}
namespace MoonTest.System.Windows.Controls
{
    public partial class ContentPresenterTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_ContentPresenter ()
        {
            ContentPresenter widget = new ContentPresenter ();
            object retval;

            retval = widget.ReadLocalValue(ContentPresenter.ContentTemplateProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(ContentPresenter.ContentTemplateProperty) should not have a value by default");
            retval = widget.ReadLocalValue(ContentPresenter.ContentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(ContentPresenter.ContentProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_FrameworkElement ()
        {
            ContentPresenter widget = new ContentPresenter ();
            object retval;

            retval = widget.ReadLocalValue(FrameworkElement.LanguageProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.LanguageProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.ActualWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.ActualWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.ActualHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.ActualHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.WidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.WidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.HeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.HeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MinWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MinWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MaxWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MaxWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MinHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MinHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MaxHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MaxHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.HorizontalAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.HorizontalAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.VerticalAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.VerticalAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MarginProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MarginProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.StyleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.StyleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.NameProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.NameProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.TagProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.TagProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.DataContextProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.DataContextProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_UIElement ()
        {
            ContentPresenter widget = new ContentPresenter ();
            object retval;

            retval = widget.ReadLocalValue(UIElement.OpacityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.OpacityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.ClipProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.ClipProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.RenderTransformProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.RenderTransformProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.OpacityMaskProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.OpacityMaskProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.RenderTransformOriginProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.RenderTransformOriginProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.IsHitTestVisibleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.IsHitTestVisibleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.VisibilityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.VisibilityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.UseLayoutRoundingProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.UseLayoutRoundingProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_ContentPresenter ()
        {
            ContentPresenter widget = new ContentPresenter ();
            object retval;

            retval = widget.GetValue(ContentPresenter.ContentTemplateProperty);
            Assert.IsNull(retval, "GetValue(ContentPresenter.ContentTemplateProperty) should have returned null");
            retval = widget.GetValue(ContentPresenter.ContentProperty);
            Assert.IsNull(retval, "GetValue(ContentPresenter.ContentProperty) should have returned null");
        }

        [TestMethod]
        public void Test_GetValue_FrameworkElement ()
        {
            ContentPresenter widget = new ContentPresenter ();
            object retval;

            retval = widget.GetValue(FrameworkElement.LanguageProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.LanguageProperty) should not have returned null");
            Assert.IsTrue(retval is XmlLanguage, "GetValue(FrameworkElement.LanguageProperty) is not of the correct type");
            Assert.AreEqual("en-us", ((XmlLanguage) retval).IetfLanguageTag, "GetValue(FrameworkElement.LanguageProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.ActualWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.ActualWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.ActualWidthProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.ActualWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.ActualHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.ActualHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.ActualHeightProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.ActualHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.WidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.WidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.WidthProperty) is not of the correct type");
            Assert.IsTrue(Double.IsNaN((double) retval), "GetValue(FrameworkElement.WidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.HeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.HeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.HeightProperty) is not of the correct type");
            Assert.IsTrue(Double.IsNaN((double) retval), "GetValue(FrameworkElement.HeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MinWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MinWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MinWidthProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.MinWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MaxWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MaxWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MaxWidthProperty) is not of the correct type");
            Assert.IsTrue(Double.IsPositiveInfinity((double) retval), "GetValue(FrameworkElement.MaxWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MinHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MinHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MinHeightProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.MinHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MaxHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MaxHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MaxHeightProperty) is not of the correct type");
            Assert.IsTrue(Double.IsPositiveInfinity((double) retval), "GetValue(FrameworkElement.MaxHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.HorizontalAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.HorizontalAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is HorizontalAlignment, "GetValue(FrameworkElement.HorizontalAlignmentProperty) is not of the correct type");
            Assert.AreEqual(HorizontalAlignment.Stretch, retval, "GetValue(FrameworkElement.HorizontalAlignmentProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.VerticalAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.VerticalAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is VerticalAlignment, "GetValue(FrameworkElement.VerticalAlignmentProperty) is not of the correct type");
            Assert.AreEqual(VerticalAlignment.Stretch, retval, "GetValue(FrameworkElement.VerticalAlignmentProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MarginProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MarginProperty) should not have returned null");
            Assert.IsTrue(retval is Thickness, "GetValue(FrameworkElement.MarginProperty) is not of the correct type");
            Assert.AreEqual("0,0,0,0", retval.ToString (), "GetValue(FrameworkElement.MarginProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.StyleProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.StyleProperty) should have returned null");
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.NameProperty) should not have returned null");
            Assert.IsTrue(retval is string, "GetValue(FrameworkElement.NameProperty) is not of the correct type");
            Assert.AreEqual("", retval, "GetValue(FrameworkElement.NameProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.TagProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.TagProperty) should have returned null");
            retval = widget.GetValue(FrameworkElement.DataContextProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.DataContextProperty) should have returned null");
        }

        [TestMethod]
        public void Test_GetValue_UIElement ()
        {
            ContentPresenter widget = new ContentPresenter ();
            object retval;

            retval = widget.GetValue(UIElement.OpacityProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.OpacityProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(UIElement.OpacityProperty) is not of the correct type");
            Assert.AreEqual((double) 1, retval, "GetValue(UIElement.OpacityProperty) does not match the default value");
            retval = widget.GetValue(UIElement.ClipProperty);
            Assert.IsNull(retval, "GetValue(UIElement.ClipProperty) should have returned null");
            retval = widget.GetValue(UIElement.RenderTransformProperty);
            Assert.IsNull(retval, "GetValue(UIElement.RenderTransformProperty) should have returned null");
            retval = widget.GetValue(UIElement.OpacityMaskProperty);
            Assert.IsNull(retval, "GetValue(UIElement.OpacityMaskProperty) should have returned null");
            retval = widget.GetValue(UIElement.RenderTransformOriginProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.RenderTransformOriginProperty) should not have returned null");
            Assert.IsTrue(retval is Point, "GetValue(UIElement.RenderTransformOriginProperty) is not of the correct type");
            Assert.AreEqual("0,0", retval.ToString (), "GetValue(UIElement.RenderTransformOriginProperty) does not match the default value");
            retval = widget.GetValue(UIElement.IsHitTestVisibleProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.IsHitTestVisibleProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(UIElement.IsHitTestVisibleProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(UIElement.IsHitTestVisibleProperty) does not match the default value");
            retval = widget.GetValue(UIElement.VisibilityProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.VisibilityProperty) should not have returned null");
            Assert.IsTrue(retval is Visibility, "GetValue(UIElement.VisibilityProperty) is not of the correct type");
            Assert.AreEqual(Visibility.Visible, retval, "GetValue(UIElement.VisibilityProperty) does not match the default value");
            retval = widget.GetValue(UIElement.UseLayoutRoundingProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.UseLayoutRoundingProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(UIElement.UseLayoutRoundingProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(UIElement.UseLayoutRoundingProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_ContentPresenter ()
        {
            ContentPresenter widget = new ContentPresenter ();

            Assert.IsNull(widget.Content, "Content should have returned null");
            Assert.IsNull(widget.ContentTemplate, "ContentTemplate should have returned null");
            Assert.IsNotNull(widget.Triggers, "Triggers should not have returned null");
            Assert.IsTrue(widget.Triggers is TriggerCollection, "Triggers is not of the correct type");
            Assert.IsNotNull(widget.Resources, "Resources should not have returned null");
            Assert.IsTrue(widget.Resources is ResourceDictionary, "Resources is not of the correct type");
            Assert.AreEqual((double) 0, widget.ActualWidth, "ActualWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.ActualHeight, "ActualHeight does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Width), "Width does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Height), "Height does not match the default value");
            Assert.AreEqual((double) 0, widget.MinWidth, "MinWidth does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxWidth), "MaxWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.MinHeight, "MinHeight does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxHeight), "MaxHeight does not match the default value");
            Assert.AreEqual(HorizontalAlignment.Stretch, widget.HorizontalAlignment, "HorizontalAlignment does not match the default value");
            Assert.AreEqual(VerticalAlignment.Stretch, widget.VerticalAlignment, "VerticalAlignment does not match the default value");
            Assert.AreEqual("0,0,0,0", widget.Margin.ToString (), "Margin does not match the default value");
            Assert.IsNull(widget.Style, "Style should have returned null");
            Assert.IsNull(widget.Parent, "Parent should have returned null");
            Assert.IsNotNull(widget.Name, "Name should not have returned null");
            Assert.AreEqual("", widget.Name, "Name does not match the default value");
            Assert.IsNull(widget.Tag, "Tag should have returned null");
            Assert.IsNull(widget.Cursor, "Cursor should have returned null");
            Assert.IsNotNull(widget.Language, "Language should not have returned null");
            Assert.AreEqual("en-us", widget.Language.IetfLanguageTag, "Language does not match the default value");
            Assert.IsNull(widget.DataContext, "DataContext should have returned null");
            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNull(widget.Clip, "Clip should have returned null");
            Assert.IsNull(widget.OpacityMask, "OpacityMask should have returned null");
            Assert.AreEqual("0,0", widget.RenderTransformOrigin.ToString (), "RenderTransformOrigin does not match the default value");
            Assert.AreEqual(true, widget.IsHitTestVisible, "IsHitTestVisible does not match the default value");
            Assert.AreEqual(Visibility.Visible, widget.Visibility, "Visibility does not match the default value");
            Assert.AreEqual("0,0", widget.RenderSize.ToString (), "RenderSize does not match the default value");
            Assert.AreEqual(true, widget.UseLayoutRounding, "UseLayoutRounding does not match the default value");
            Assert.AreEqual("0,0", widget.DesiredSize.ToString (), "DesiredSize does not match the default value");
            Assert.IsNotNull(widget.RenderTransform, "RenderTransform should not have returned null");
            Assert.IsTrue(widget.RenderTransform is MatrixTransform, "RenderTransform is not of the correct type");
        }

        [TestMethod]
        public void Test_PropertyGetter_UIElement ()
        {
            ContentPresenter widget = new ContentPresenter ();

            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNull(widget.Clip, "Clip should have returned null");
            Assert.IsNull(widget.OpacityMask, "OpacityMask should have returned null");
            Assert.AreEqual("0,0", widget.RenderTransformOrigin.ToString (), "RenderTransformOrigin does not match the default value");
            Assert.AreEqual(true, widget.IsHitTestVisible, "IsHitTestVisible does not match the default value");
            Assert.AreEqual(Visibility.Visible, widget.Visibility, "Visibility does not match the default value");
            Assert.AreEqual("0,0", widget.RenderSize.ToString (), "RenderSize does not match the default value");
            Assert.AreEqual(true, widget.UseLayoutRounding, "UseLayoutRounding does not match the default value");
            Assert.AreEqual("0,0", widget.DesiredSize.ToString (), "DesiredSize does not match the default value");
            Assert.IsNotNull(widget.RenderTransform, "RenderTransform should not have returned null");
            Assert.IsTrue(widget.RenderTransform is MatrixTransform, "RenderTransform is not of the correct type");
        }

        [TestMethod]
	[MoonlightBug]
        public void Test_SetStringValue_FrameworkElement ()
        {
            ContentPresenter widget = new ContentPresenter ();
            object retval;

            widget.SetValue(FrameworkElement.NameProperty, "some text");
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.AreEqual("some text", retval, "GetValue(FrameworkElement.NameProperty) should have returned 'some text'");
            widget.SetValue(FrameworkElement.NameProperty, null);
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.AreEqual(String.Empty, retval, "GetValue(FrameworkElement.NameProperty) should have returned String.Empty");
            retval = widget.ReadLocalValue(FrameworkElement.NameProperty);
            Assert.AreEqual(String.Empty, retval, "ReadLocalValue(FrameworkElement.NameProperty) should have returned String.Empty");
        }

    }
}
namespace MoonTest.System.Windows.Controls
{
    public partial class ItemsPanelTemplateTest
    {
    }
}
namespace MoonTest.System.Windows.Controls
{
    public partial class ItemsPresenterTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_FrameworkElement ()
        {
            ItemsPresenter widget = new ItemsPresenter ();
            object retval;

            retval = widget.ReadLocalValue(FrameworkElement.LanguageProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.LanguageProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.ActualWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.ActualWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.ActualHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.ActualHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.WidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.WidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.HeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.HeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MinWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MinWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MaxWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MaxWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MinHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MinHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MaxHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MaxHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.HorizontalAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.HorizontalAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.VerticalAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.VerticalAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MarginProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MarginProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.StyleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.StyleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.NameProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.NameProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.TagProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.TagProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.DataContextProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.DataContextProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_UIElement ()
        {
            ItemsPresenter widget = new ItemsPresenter ();
            object retval;

            retval = widget.ReadLocalValue(UIElement.OpacityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.OpacityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.ClipProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.ClipProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.RenderTransformProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.RenderTransformProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.OpacityMaskProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.OpacityMaskProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.RenderTransformOriginProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.RenderTransformOriginProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.IsHitTestVisibleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.IsHitTestVisibleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.VisibilityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.VisibilityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.UseLayoutRoundingProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.UseLayoutRoundingProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_FrameworkElement ()
        {
            ItemsPresenter widget = new ItemsPresenter ();
            object retval;

            retval = widget.GetValue(FrameworkElement.LanguageProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.LanguageProperty) should not have returned null");
            Assert.IsTrue(retval is XmlLanguage, "GetValue(FrameworkElement.LanguageProperty) is not of the correct type");
            Assert.AreEqual("en-us", ((XmlLanguage) retval).IetfLanguageTag, "GetValue(FrameworkElement.LanguageProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.ActualWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.ActualWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.ActualWidthProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.ActualWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.ActualHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.ActualHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.ActualHeightProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.ActualHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.WidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.WidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.WidthProperty) is not of the correct type");
            Assert.IsTrue(Double.IsNaN((double) retval), "GetValue(FrameworkElement.WidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.HeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.HeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.HeightProperty) is not of the correct type");
            Assert.IsTrue(Double.IsNaN((double) retval), "GetValue(FrameworkElement.HeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MinWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MinWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MinWidthProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.MinWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MaxWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MaxWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MaxWidthProperty) is not of the correct type");
            Assert.IsTrue(Double.IsPositiveInfinity((double) retval), "GetValue(FrameworkElement.MaxWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MinHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MinHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MinHeightProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.MinHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MaxHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MaxHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MaxHeightProperty) is not of the correct type");
            Assert.IsTrue(Double.IsPositiveInfinity((double) retval), "GetValue(FrameworkElement.MaxHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.HorizontalAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.HorizontalAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is HorizontalAlignment, "GetValue(FrameworkElement.HorizontalAlignmentProperty) is not of the correct type");
            Assert.AreEqual(HorizontalAlignment.Stretch, retval, "GetValue(FrameworkElement.HorizontalAlignmentProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.VerticalAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.VerticalAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is VerticalAlignment, "GetValue(FrameworkElement.VerticalAlignmentProperty) is not of the correct type");
            Assert.AreEqual(VerticalAlignment.Stretch, retval, "GetValue(FrameworkElement.VerticalAlignmentProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MarginProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MarginProperty) should not have returned null");
            Assert.IsTrue(retval is Thickness, "GetValue(FrameworkElement.MarginProperty) is not of the correct type");
            Assert.AreEqual("0,0,0,0", retval.ToString (), "GetValue(FrameworkElement.MarginProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.StyleProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.StyleProperty) should have returned null");
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.NameProperty) should not have returned null");
            Assert.IsTrue(retval is string, "GetValue(FrameworkElement.NameProperty) is not of the correct type");
            Assert.AreEqual("", retval, "GetValue(FrameworkElement.NameProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.TagProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.TagProperty) should have returned null");
            retval = widget.GetValue(FrameworkElement.DataContextProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.DataContextProperty) should have returned null");
        }

        [TestMethod]
        public void Test_GetValue_UIElement ()
        {
            ItemsPresenter widget = new ItemsPresenter ();
            object retval;

            retval = widget.GetValue(UIElement.OpacityProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.OpacityProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(UIElement.OpacityProperty) is not of the correct type");
            Assert.AreEqual((double) 1, retval, "GetValue(UIElement.OpacityProperty) does not match the default value");
            retval = widget.GetValue(UIElement.ClipProperty);
            Assert.IsNull(retval, "GetValue(UIElement.ClipProperty) should have returned null");
            retval = widget.GetValue(UIElement.RenderTransformProperty);
            Assert.IsNull(retval, "GetValue(UIElement.RenderTransformProperty) should have returned null");
            retval = widget.GetValue(UIElement.OpacityMaskProperty);
            Assert.IsNull(retval, "GetValue(UIElement.OpacityMaskProperty) should have returned null");
            retval = widget.GetValue(UIElement.RenderTransformOriginProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.RenderTransformOriginProperty) should not have returned null");
            Assert.IsTrue(retval is Point, "GetValue(UIElement.RenderTransformOriginProperty) is not of the correct type");
            Assert.AreEqual("0,0", retval.ToString (), "GetValue(UIElement.RenderTransformOriginProperty) does not match the default value");
            retval = widget.GetValue(UIElement.IsHitTestVisibleProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.IsHitTestVisibleProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(UIElement.IsHitTestVisibleProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(UIElement.IsHitTestVisibleProperty) does not match the default value");
            retval = widget.GetValue(UIElement.VisibilityProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.VisibilityProperty) should not have returned null");
            Assert.IsTrue(retval is Visibility, "GetValue(UIElement.VisibilityProperty) is not of the correct type");
            Assert.AreEqual(Visibility.Visible, retval, "GetValue(UIElement.VisibilityProperty) does not match the default value");
            retval = widget.GetValue(UIElement.UseLayoutRoundingProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.UseLayoutRoundingProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(UIElement.UseLayoutRoundingProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(UIElement.UseLayoutRoundingProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_ItemsPresenter ()
        {
            ItemsPresenter widget = new ItemsPresenter ();

            Assert.IsNotNull(widget.Triggers, "Triggers should not have returned null");
            Assert.IsTrue(widget.Triggers is TriggerCollection, "Triggers is not of the correct type");
            Assert.IsNotNull(widget.Resources, "Resources should not have returned null");
            Assert.IsTrue(widget.Resources is ResourceDictionary, "Resources is not of the correct type");
            Assert.AreEqual((double) 0, widget.ActualWidth, "ActualWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.ActualHeight, "ActualHeight does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Width), "Width does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Height), "Height does not match the default value");
            Assert.AreEqual((double) 0, widget.MinWidth, "MinWidth does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxWidth), "MaxWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.MinHeight, "MinHeight does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxHeight), "MaxHeight does not match the default value");
            Assert.AreEqual(HorizontalAlignment.Stretch, widget.HorizontalAlignment, "HorizontalAlignment does not match the default value");
            Assert.AreEqual(VerticalAlignment.Stretch, widget.VerticalAlignment, "VerticalAlignment does not match the default value");
            Assert.AreEqual("0,0,0,0", widget.Margin.ToString (), "Margin does not match the default value");
            Assert.IsNull(widget.Style, "Style should have returned null");
            Assert.IsNull(widget.Parent, "Parent should have returned null");
            Assert.IsNotNull(widget.Name, "Name should not have returned null");
            Assert.AreEqual("", widget.Name, "Name does not match the default value");
            Assert.IsNull(widget.Tag, "Tag should have returned null");
            Assert.IsNull(widget.Cursor, "Cursor should have returned null");
            Assert.IsNotNull(widget.Language, "Language should not have returned null");
            Assert.AreEqual("en-us", widget.Language.IetfLanguageTag, "Language does not match the default value");
            Assert.IsNull(widget.DataContext, "DataContext should have returned null");
            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNull(widget.Clip, "Clip should have returned null");
            Assert.IsNull(widget.OpacityMask, "OpacityMask should have returned null");
            Assert.AreEqual("0,0", widget.RenderTransformOrigin.ToString (), "RenderTransformOrigin does not match the default value");
            Assert.AreEqual(true, widget.IsHitTestVisible, "IsHitTestVisible does not match the default value");
            Assert.AreEqual(Visibility.Visible, widget.Visibility, "Visibility does not match the default value");
            Assert.AreEqual("0,0", widget.RenderSize.ToString (), "RenderSize does not match the default value");
            Assert.AreEqual(true, widget.UseLayoutRounding, "UseLayoutRounding does not match the default value");
            Assert.AreEqual("0,0", widget.DesiredSize.ToString (), "DesiredSize does not match the default value");
            Assert.IsNotNull(widget.RenderTransform, "RenderTransform should not have returned null");
            Assert.IsTrue(widget.RenderTransform is MatrixTransform, "RenderTransform is not of the correct type");
        }

        [TestMethod]
        public void Test_PropertyGetter_UIElement ()
        {
            ItemsPresenter widget = new ItemsPresenter ();

            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNull(widget.Clip, "Clip should have returned null");
            Assert.IsNull(widget.OpacityMask, "OpacityMask should have returned null");
            Assert.AreEqual("0,0", widget.RenderTransformOrigin.ToString (), "RenderTransformOrigin does not match the default value");
            Assert.AreEqual(true, widget.IsHitTestVisible, "IsHitTestVisible does not match the default value");
            Assert.AreEqual(Visibility.Visible, widget.Visibility, "Visibility does not match the default value");
            Assert.AreEqual("0,0", widget.RenderSize.ToString (), "RenderSize does not match the default value");
            Assert.AreEqual(true, widget.UseLayoutRounding, "UseLayoutRounding does not match the default value");
            Assert.AreEqual("0,0", widget.DesiredSize.ToString (), "DesiredSize does not match the default value");
            Assert.IsNotNull(widget.RenderTransform, "RenderTransform should not have returned null");
            Assert.IsTrue(widget.RenderTransform is MatrixTransform, "RenderTransform is not of the correct type");
        }

        [TestMethod]
	[MoonlightBug]
        public void Test_SetStringValue_FrameworkElement ()
        {
            ItemsPresenter widget = new ItemsPresenter ();
            object retval;

            widget.SetValue(FrameworkElement.NameProperty, "some text");
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.AreEqual("some text", retval, "GetValue(FrameworkElement.NameProperty) should have returned 'some text'");
            widget.SetValue(FrameworkElement.NameProperty, null);
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.AreEqual(String.Empty, retval, "GetValue(FrameworkElement.NameProperty) should have returned String.Empty");
            retval = widget.ReadLocalValue(FrameworkElement.NameProperty);
            Assert.AreEqual(String.Empty, retval, "ReadLocalValue(FrameworkElement.NameProperty) should have returned String.Empty");
        }

    }
}
namespace MoonTest.System.Windows.Media.Imaging
{
    public partial class BitmapImageTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_BitmapImage ()
        {
            BitmapImage widget = new BitmapImage ();
            object retval;

            retval = widget.ReadLocalValue(BitmapImage.UriSourceProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(BitmapImage.UriSourceProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_BitmapImage ()
        {
            BitmapImage widget = new BitmapImage ();
            object retval;

            retval = widget.GetValue(BitmapImage.UriSourceProperty);
            Assert.IsNotNull(retval, "GetValue(BitmapImage.UriSourceProperty) should not have returned null");
            Assert.IsTrue(retval is Uri, "GetValue(BitmapImage.UriSourceProperty) is not of the correct type");
            Assert.AreEqual("", retval.ToString (), "GetValue(BitmapImage.UriSourceProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_BitmapImage ()
        {
            BitmapImage widget = new BitmapImage ();

            Assert.IsNotNull(widget.UriSource, "UriSource should not have returned null");
            Assert.AreEqual("", widget.UriSource.ToString (), "UriSource does not match the default value");
        }

    }
}
namespace MoonTest.System.Windows.Controls.Primitives
{
    public partial class PopupTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_Popup ()
        {
            Popup widget = new Popup ();
            object retval;

            retval = widget.ReadLocalValue(Popup.ChildProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Popup.ChildProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Popup.IsOpenProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Popup.IsOpenProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Popup.HorizontalOffsetProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Popup.HorizontalOffsetProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Popup.VerticalOffsetProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Popup.VerticalOffsetProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_FrameworkElement ()
        {
            Popup widget = new Popup ();
            object retval;

            retval = widget.ReadLocalValue(FrameworkElement.LanguageProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.LanguageProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.ActualWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.ActualWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.ActualHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.ActualHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.WidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.WidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.HeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.HeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MinWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MinWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MaxWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MaxWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MinHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MinHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MaxHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MaxHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.HorizontalAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.HorizontalAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.VerticalAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.VerticalAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MarginProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MarginProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.StyleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.StyleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.NameProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.NameProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.TagProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.TagProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.DataContextProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.DataContextProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_UIElement ()
        {
            Popup widget = new Popup ();
            object retval;

            retval = widget.ReadLocalValue(UIElement.OpacityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.OpacityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.ClipProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.ClipProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.RenderTransformProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.RenderTransformProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.OpacityMaskProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.OpacityMaskProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.RenderTransformOriginProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.RenderTransformOriginProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.IsHitTestVisibleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.IsHitTestVisibleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.VisibilityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.VisibilityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.UseLayoutRoundingProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.UseLayoutRoundingProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_Popup ()
        {
            Popup widget = new Popup ();
            object retval;

            retval = widget.GetValue(Popup.ChildProperty);
            Assert.IsNull(retval, "GetValue(Popup.ChildProperty) should have returned null");
            retval = widget.GetValue(Popup.IsOpenProperty);
            Assert.IsNotNull(retval, "GetValue(Popup.IsOpenProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(Popup.IsOpenProperty) is not of the correct type");
            Assert.AreEqual(false, retval, "GetValue(Popup.IsOpenProperty) does not match the default value");
            retval = widget.GetValue(Popup.HorizontalOffsetProperty);
            Assert.IsNotNull(retval, "GetValue(Popup.HorizontalOffsetProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Popup.HorizontalOffsetProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(Popup.HorizontalOffsetProperty) does not match the default value");
            retval = widget.GetValue(Popup.VerticalOffsetProperty);
            Assert.IsNotNull(retval, "GetValue(Popup.VerticalOffsetProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Popup.VerticalOffsetProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(Popup.VerticalOffsetProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_GetValue_FrameworkElement ()
        {
            Popup widget = new Popup ();
            object retval;

            retval = widget.GetValue(FrameworkElement.LanguageProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.LanguageProperty) should not have returned null");
            Assert.IsTrue(retval is XmlLanguage, "GetValue(FrameworkElement.LanguageProperty) is not of the correct type");
            Assert.AreEqual("en-us", ((XmlLanguage) retval).IetfLanguageTag, "GetValue(FrameworkElement.LanguageProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.ActualWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.ActualWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.ActualWidthProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.ActualWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.ActualHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.ActualHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.ActualHeightProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.ActualHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.WidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.WidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.WidthProperty) is not of the correct type");
            Assert.IsTrue(Double.IsNaN((double) retval), "GetValue(FrameworkElement.WidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.HeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.HeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.HeightProperty) is not of the correct type");
            Assert.IsTrue(Double.IsNaN((double) retval), "GetValue(FrameworkElement.HeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MinWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MinWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MinWidthProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.MinWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MaxWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MaxWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MaxWidthProperty) is not of the correct type");
            Assert.IsTrue(Double.IsPositiveInfinity((double) retval), "GetValue(FrameworkElement.MaxWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MinHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MinHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MinHeightProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.MinHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MaxHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MaxHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MaxHeightProperty) is not of the correct type");
            Assert.IsTrue(Double.IsPositiveInfinity((double) retval), "GetValue(FrameworkElement.MaxHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.HorizontalAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.HorizontalAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is HorizontalAlignment, "GetValue(FrameworkElement.HorizontalAlignmentProperty) is not of the correct type");
            Assert.AreEqual(HorizontalAlignment.Stretch, retval, "GetValue(FrameworkElement.HorizontalAlignmentProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.VerticalAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.VerticalAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is VerticalAlignment, "GetValue(FrameworkElement.VerticalAlignmentProperty) is not of the correct type");
            Assert.AreEqual(VerticalAlignment.Stretch, retval, "GetValue(FrameworkElement.VerticalAlignmentProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MarginProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MarginProperty) should not have returned null");
            Assert.IsTrue(retval is Thickness, "GetValue(FrameworkElement.MarginProperty) is not of the correct type");
            Assert.AreEqual("0,0,0,0", retval.ToString (), "GetValue(FrameworkElement.MarginProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.StyleProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.StyleProperty) should have returned null");
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.NameProperty) should not have returned null");
            Assert.IsTrue(retval is string, "GetValue(FrameworkElement.NameProperty) is not of the correct type");
            Assert.AreEqual("", retval, "GetValue(FrameworkElement.NameProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.TagProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.TagProperty) should have returned null");
            retval = widget.GetValue(FrameworkElement.DataContextProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.DataContextProperty) should have returned null");
        }

        [TestMethod]
        public void Test_GetValue_UIElement ()
        {
            Popup widget = new Popup ();
            object retval;

            retval = widget.GetValue(UIElement.OpacityProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.OpacityProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(UIElement.OpacityProperty) is not of the correct type");
            Assert.AreEqual((double) 1, retval, "GetValue(UIElement.OpacityProperty) does not match the default value");
            retval = widget.GetValue(UIElement.ClipProperty);
            Assert.IsNull(retval, "GetValue(UIElement.ClipProperty) should have returned null");
            retval = widget.GetValue(UIElement.RenderTransformProperty);
            Assert.IsNull(retval, "GetValue(UIElement.RenderTransformProperty) should have returned null");
            retval = widget.GetValue(UIElement.OpacityMaskProperty);
            Assert.IsNull(retval, "GetValue(UIElement.OpacityMaskProperty) should have returned null");
            retval = widget.GetValue(UIElement.RenderTransformOriginProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.RenderTransformOriginProperty) should not have returned null");
            Assert.IsTrue(retval is Point, "GetValue(UIElement.RenderTransformOriginProperty) is not of the correct type");
            Assert.AreEqual("0,0", retval.ToString (), "GetValue(UIElement.RenderTransformOriginProperty) does not match the default value");
            retval = widget.GetValue(UIElement.IsHitTestVisibleProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.IsHitTestVisibleProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(UIElement.IsHitTestVisibleProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(UIElement.IsHitTestVisibleProperty) does not match the default value");
            retval = widget.GetValue(UIElement.VisibilityProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.VisibilityProperty) should not have returned null");
            Assert.IsTrue(retval is Visibility, "GetValue(UIElement.VisibilityProperty) is not of the correct type");
            Assert.AreEqual(Visibility.Visible, retval, "GetValue(UIElement.VisibilityProperty) does not match the default value");
            retval = widget.GetValue(UIElement.UseLayoutRoundingProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.UseLayoutRoundingProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(UIElement.UseLayoutRoundingProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(UIElement.UseLayoutRoundingProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_Popup ()
        {
            Popup widget = new Popup ();

            Assert.IsNull(widget.Child, "Child should have returned null");
            Assert.AreEqual(false, widget.IsOpen, "IsOpen does not match the default value");
            Assert.AreEqual((double) 0, widget.HorizontalOffset, "HorizontalOffset does not match the default value");
            Assert.AreEqual((double) 0, widget.VerticalOffset, "VerticalOffset does not match the default value");
            Assert.IsNotNull(widget.Triggers, "Triggers should not have returned null");
            Assert.IsTrue(widget.Triggers is TriggerCollection, "Triggers is not of the correct type");
            Assert.IsNotNull(widget.Resources, "Resources should not have returned null");
            Assert.IsTrue(widget.Resources is ResourceDictionary, "Resources is not of the correct type");
            Assert.AreEqual((double) 0, widget.ActualWidth, "ActualWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.ActualHeight, "ActualHeight does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Width), "Width does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Height), "Height does not match the default value");
            Assert.AreEqual((double) 0, widget.MinWidth, "MinWidth does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxWidth), "MaxWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.MinHeight, "MinHeight does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxHeight), "MaxHeight does not match the default value");
            Assert.AreEqual(HorizontalAlignment.Stretch, widget.HorizontalAlignment, "HorizontalAlignment does not match the default value");
            Assert.AreEqual(VerticalAlignment.Stretch, widget.VerticalAlignment, "VerticalAlignment does not match the default value");
            Assert.AreEqual("0,0,0,0", widget.Margin.ToString (), "Margin does not match the default value");
            Assert.IsNull(widget.Style, "Style should have returned null");
            Assert.IsNull(widget.Parent, "Parent should have returned null");
            Assert.IsNotNull(widget.Name, "Name should not have returned null");
            Assert.AreEqual("", widget.Name, "Name does not match the default value");
            Assert.IsNull(widget.Tag, "Tag should have returned null");
            Assert.IsNull(widget.Cursor, "Cursor should have returned null");
            Assert.IsNotNull(widget.Language, "Language should not have returned null");
            Assert.AreEqual("en-us", widget.Language.IetfLanguageTag, "Language does not match the default value");
            Assert.IsNull(widget.DataContext, "DataContext should have returned null");
            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNull(widget.Clip, "Clip should have returned null");
            Assert.IsNull(widget.OpacityMask, "OpacityMask should have returned null");
            Assert.AreEqual("0,0", widget.RenderTransformOrigin.ToString (), "RenderTransformOrigin does not match the default value");
            Assert.AreEqual(true, widget.IsHitTestVisible, "IsHitTestVisible does not match the default value");
            Assert.AreEqual(Visibility.Visible, widget.Visibility, "Visibility does not match the default value");
            Assert.AreEqual("0,0", widget.RenderSize.ToString (), "RenderSize does not match the default value");
            Assert.AreEqual(true, widget.UseLayoutRounding, "UseLayoutRounding does not match the default value");
            Assert.AreEqual("0,0", widget.DesiredSize.ToString (), "DesiredSize does not match the default value");
            Assert.IsNotNull(widget.RenderTransform, "RenderTransform should not have returned null");
            Assert.IsTrue(widget.RenderTransform is MatrixTransform, "RenderTransform is not of the correct type");
        }

        [TestMethod]
        public void Test_PropertyGetter_UIElement ()
        {
            Popup widget = new Popup ();

            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNull(widget.Clip, "Clip should have returned null");
            Assert.IsNull(widget.OpacityMask, "OpacityMask should have returned null");
            Assert.AreEqual("0,0", widget.RenderTransformOrigin.ToString (), "RenderTransformOrigin does not match the default value");
            Assert.AreEqual(true, widget.IsHitTestVisible, "IsHitTestVisible does not match the default value");
            Assert.AreEqual(Visibility.Visible, widget.Visibility, "Visibility does not match the default value");
            Assert.AreEqual("0,0", widget.RenderSize.ToString (), "RenderSize does not match the default value");
            Assert.AreEqual(true, widget.UseLayoutRounding, "UseLayoutRounding does not match the default value");
            Assert.AreEqual("0,0", widget.DesiredSize.ToString (), "DesiredSize does not match the default value");
            Assert.IsNotNull(widget.RenderTransform, "RenderTransform should not have returned null");
            Assert.IsTrue(widget.RenderTransform is MatrixTransform, "RenderTransform is not of the correct type");
        }

        [TestMethod]
	[MoonlightBug]
        public void Test_SetStringValue_FrameworkElement ()
        {
            Popup widget = new Popup ();
            object retval;

            widget.SetValue(FrameworkElement.NameProperty, "some text");
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.AreEqual("some text", retval, "GetValue(FrameworkElement.NameProperty) should have returned 'some text'");
            widget.SetValue(FrameworkElement.NameProperty, null);
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.AreEqual(String.Empty, retval, "GetValue(FrameworkElement.NameProperty) should have returned String.Empty");
            retval = widget.ReadLocalValue(FrameworkElement.NameProperty);
            Assert.AreEqual(String.Empty, retval, "ReadLocalValue(FrameworkElement.NameProperty) should have returned String.Empty");
        }

    }
}
namespace MoonTest.System.Windows.Controls
{
    public partial class UserControlTest
    {
        [TestMethod]
	[MoonlightBug]
        public void Test_ReadLocalValue_Control ()
        {
            UserControl widget = new UserControl ();
            object retval;

            retval = widget.ReadLocalValue(Control.IsTabStopProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.IsTabStopProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.TabIndexProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.TabIndexProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.TemplateProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.TemplateProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.TabNavigationProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.TabNavigationProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.PaddingProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.PaddingProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.HorizontalContentAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.HorizontalContentAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.VerticalContentAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.VerticalContentAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.BackgroundProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.BackgroundProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.BorderBrushProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.BorderBrushProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.BorderThicknessProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.BorderThicknessProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.FontSizeProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.FontSizeProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.FontFamilyProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.FontFamilyProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.ForegroundProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.ForegroundProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.FontWeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.FontWeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.FontStyleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.FontStyleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.FontStretchProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.FontStretchProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.IsEnabledProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.IsEnabledProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_FrameworkElement ()
        {
            UserControl widget = new UserControl ();
            object retval;

            retval = widget.ReadLocalValue(FrameworkElement.LanguageProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.LanguageProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.ActualWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.ActualWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.ActualHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.ActualHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.WidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.WidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.HeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.HeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MinWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MinWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MaxWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MaxWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MinHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MinHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MaxHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MaxHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.HorizontalAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.HorizontalAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.VerticalAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.VerticalAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MarginProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MarginProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.StyleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.StyleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.NameProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.NameProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.TagProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.TagProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.DataContextProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.DataContextProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_UIElement ()
        {
            UserControl widget = new UserControl ();
            object retval;

            retval = widget.ReadLocalValue(UIElement.OpacityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.OpacityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.ClipProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.ClipProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.RenderTransformProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.RenderTransformProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.OpacityMaskProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.OpacityMaskProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.RenderTransformOriginProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.RenderTransformOriginProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.IsHitTestVisibleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.IsHitTestVisibleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.VisibilityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.VisibilityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.UseLayoutRoundingProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.UseLayoutRoundingProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_Control ()
        {
            UserControl widget = new UserControl ();
            object retval;

            retval = widget.GetValue(Control.IsTabStopProperty);
            Assert.IsNotNull(retval, "GetValue(Control.IsTabStopProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(Control.IsTabStopProperty) is not of the correct type");
            Assert.AreEqual(false, retval, "GetValue(Control.IsTabStopProperty) does not match the default value");
            retval = widget.GetValue(Control.TabIndexProperty);
            Assert.IsNotNull(retval, "GetValue(Control.TabIndexProperty) should not have returned null");
            Assert.IsTrue(retval is int, "GetValue(Control.TabIndexProperty) is not of the correct type");
            Assert.AreEqual(2147483647, retval, "GetValue(Control.TabIndexProperty) does not match the default value");
            retval = widget.GetValue(Control.TemplateProperty);
            Assert.IsNull(retval, "GetValue(Control.TemplateProperty) should have returned null");
            retval = widget.GetValue(Control.TabNavigationProperty);
            Assert.IsNotNull(retval, "GetValue(Control.TabNavigationProperty) should not have returned null");
            Assert.IsTrue(retval is KeyboardNavigationMode, "GetValue(Control.TabNavigationProperty) is not of the correct type");
            Assert.AreEqual(KeyboardNavigationMode.Local, retval, "GetValue(Control.TabNavigationProperty) does not match the default value");
            retval = widget.GetValue(Control.PaddingProperty);
            Assert.IsNotNull(retval, "GetValue(Control.PaddingProperty) should not have returned null");
            Assert.IsTrue(retval is Thickness, "GetValue(Control.PaddingProperty) is not of the correct type");
            Assert.AreEqual("0,0,0,0", retval.ToString (), "GetValue(Control.PaddingProperty) does not match the default value");
            retval = widget.GetValue(Control.HorizontalContentAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(Control.HorizontalContentAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is HorizontalAlignment, "GetValue(Control.HorizontalContentAlignmentProperty) is not of the correct type");
            Assert.AreEqual(HorizontalAlignment.Center, retval, "GetValue(Control.HorizontalContentAlignmentProperty) does not match the default value");
            retval = widget.GetValue(Control.VerticalContentAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(Control.VerticalContentAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is VerticalAlignment, "GetValue(Control.VerticalContentAlignmentProperty) is not of the correct type");
            Assert.AreEqual(VerticalAlignment.Center, retval, "GetValue(Control.VerticalContentAlignmentProperty) does not match the default value");
            retval = widget.GetValue(Control.BackgroundProperty);
            Assert.IsNull(retval, "GetValue(Control.BackgroundProperty) should have returned null");
            retval = widget.GetValue(Control.BorderBrushProperty);
            Assert.IsNull(retval, "GetValue(Control.BorderBrushProperty) should have returned null");
            retval = widget.GetValue(Control.BorderThicknessProperty);
            Assert.IsNotNull(retval, "GetValue(Control.BorderThicknessProperty) should not have returned null");
            Assert.IsTrue(retval is Thickness, "GetValue(Control.BorderThicknessProperty) is not of the correct type");
            Assert.AreEqual("0,0,0,0", retval.ToString (), "GetValue(Control.BorderThicknessProperty) does not match the default value");
            retval = widget.GetValue(Control.FontSizeProperty);
            Assert.IsNotNull(retval, "GetValue(Control.FontSizeProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Control.FontSizeProperty) is not of the correct type");
            Assert.AreEqual((double) 11, retval, "GetValue(Control.FontSizeProperty) does not match the default value");
            retval = widget.GetValue(Control.FontFamilyProperty);
            Assert.IsNotNull(retval, "GetValue(Control.FontFamilyProperty) should not have returned null");
            Assert.IsTrue(retval is FontFamily, "GetValue(Control.FontFamilyProperty) is not of the correct type");
            Assert.AreEqual("Portable User Interface", retval.ToString (), "GetValue(Control.FontFamilyProperty) does not match the default value");
            retval = widget.GetValue(Control.ForegroundProperty);
            Assert.IsNotNull(retval, "GetValue(Control.ForegroundProperty) should not have returned null");
            Assert.IsTrue(retval is SolidColorBrush, "GetValue(Control.ForegroundProperty) is not of the correct type");
            retval = widget.GetValue(Control.FontWeightProperty);
            Assert.IsNotNull(retval, "GetValue(Control.FontWeightProperty) should not have returned null");
            Assert.IsTrue(retval is FontWeight, "GetValue(Control.FontWeightProperty) is not of the correct type");
            Assert.AreEqual("Normal", retval.ToString (), "GetValue(Control.FontWeightProperty) does not match the default value");
            retval = widget.GetValue(Control.FontStyleProperty);
            Assert.IsNotNull(retval, "GetValue(Control.FontStyleProperty) should not have returned null");
            Assert.IsTrue(retval is FontStyle, "GetValue(Control.FontStyleProperty) is not of the correct type");
            Assert.AreEqual("Normal", retval.ToString (), "GetValue(Control.FontStyleProperty) does not match the default value");
            retval = widget.GetValue(Control.FontStretchProperty);
            Assert.IsNotNull(retval, "GetValue(Control.FontStretchProperty) should not have returned null");
            Assert.IsTrue(retval is FontStretch, "GetValue(Control.FontStretchProperty) is not of the correct type");
            Assert.AreEqual("Normal", retval.ToString (), "GetValue(Control.FontStretchProperty) does not match the default value");
            retval = widget.GetValue(Control.IsEnabledProperty);
            Assert.IsNotNull(retval, "GetValue(Control.IsEnabledProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(Control.IsEnabledProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(Control.IsEnabledProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_GetValue_FrameworkElement ()
        {
            UserControl widget = new UserControl ();
            object retval;

            retval = widget.GetValue(FrameworkElement.LanguageProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.LanguageProperty) should not have returned null");
            Assert.IsTrue(retval is XmlLanguage, "GetValue(FrameworkElement.LanguageProperty) is not of the correct type");
            Assert.AreEqual("en-us", ((XmlLanguage) retval).IetfLanguageTag, "GetValue(FrameworkElement.LanguageProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.ActualWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.ActualWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.ActualWidthProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.ActualWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.ActualHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.ActualHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.ActualHeightProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.ActualHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.WidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.WidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.WidthProperty) is not of the correct type");
            Assert.IsTrue(Double.IsNaN((double) retval), "GetValue(FrameworkElement.WidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.HeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.HeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.HeightProperty) is not of the correct type");
            Assert.IsTrue(Double.IsNaN((double) retval), "GetValue(FrameworkElement.HeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MinWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MinWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MinWidthProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.MinWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MaxWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MaxWidthProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MaxWidthProperty) is not of the correct type");
            Assert.IsTrue(Double.IsPositiveInfinity((double) retval), "GetValue(FrameworkElement.MaxWidthProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MinHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MinHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MinHeightProperty) is not of the correct type");
            Assert.AreEqual((double) 0, retval, "GetValue(FrameworkElement.MinHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MaxHeightProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MaxHeightProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(FrameworkElement.MaxHeightProperty) is not of the correct type");
            Assert.IsTrue(Double.IsPositiveInfinity((double) retval), "GetValue(FrameworkElement.MaxHeightProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.HorizontalAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.HorizontalAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is HorizontalAlignment, "GetValue(FrameworkElement.HorizontalAlignmentProperty) is not of the correct type");
            Assert.AreEqual(HorizontalAlignment.Stretch, retval, "GetValue(FrameworkElement.HorizontalAlignmentProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.VerticalAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.VerticalAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is VerticalAlignment, "GetValue(FrameworkElement.VerticalAlignmentProperty) is not of the correct type");
            Assert.AreEqual(VerticalAlignment.Stretch, retval, "GetValue(FrameworkElement.VerticalAlignmentProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.MarginProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.MarginProperty) should not have returned null");
            Assert.IsTrue(retval is Thickness, "GetValue(FrameworkElement.MarginProperty) is not of the correct type");
            Assert.AreEqual("0,0,0,0", retval.ToString (), "GetValue(FrameworkElement.MarginProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.StyleProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.StyleProperty) should have returned null");
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.NameProperty) should not have returned null");
            Assert.IsTrue(retval is string, "GetValue(FrameworkElement.NameProperty) is not of the correct type");
            Assert.AreEqual("", retval, "GetValue(FrameworkElement.NameProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.TagProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.TagProperty) should have returned null");
            retval = widget.GetValue(FrameworkElement.DataContextProperty);
            Assert.IsNull(retval, "GetValue(FrameworkElement.DataContextProperty) should have returned null");
        }

        [TestMethod]
        public void Test_GetValue_UIElement ()
        {
            UserControl widget = new UserControl ();
            object retval;

            retval = widget.GetValue(UIElement.OpacityProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.OpacityProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(UIElement.OpacityProperty) is not of the correct type");
            Assert.AreEqual((double) 1, retval, "GetValue(UIElement.OpacityProperty) does not match the default value");
            retval = widget.GetValue(UIElement.ClipProperty);
            Assert.IsNull(retval, "GetValue(UIElement.ClipProperty) should have returned null");
            retval = widget.GetValue(UIElement.RenderTransformProperty);
            Assert.IsNull(retval, "GetValue(UIElement.RenderTransformProperty) should have returned null");
            retval = widget.GetValue(UIElement.OpacityMaskProperty);
            Assert.IsNull(retval, "GetValue(UIElement.OpacityMaskProperty) should have returned null");
            retval = widget.GetValue(UIElement.RenderTransformOriginProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.RenderTransformOriginProperty) should not have returned null");
            Assert.IsTrue(retval is Point, "GetValue(UIElement.RenderTransformOriginProperty) is not of the correct type");
            Assert.AreEqual("0,0", retval.ToString (), "GetValue(UIElement.RenderTransformOriginProperty) does not match the default value");
            retval = widget.GetValue(UIElement.IsHitTestVisibleProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.IsHitTestVisibleProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(UIElement.IsHitTestVisibleProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(UIElement.IsHitTestVisibleProperty) does not match the default value");
            retval = widget.GetValue(UIElement.VisibilityProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.VisibilityProperty) should not have returned null");
            Assert.IsTrue(retval is Visibility, "GetValue(UIElement.VisibilityProperty) is not of the correct type");
            Assert.AreEqual(Visibility.Visible, retval, "GetValue(UIElement.VisibilityProperty) does not match the default value");
            retval = widget.GetValue(UIElement.UseLayoutRoundingProperty);
            Assert.IsNotNull(retval, "GetValue(UIElement.UseLayoutRoundingProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(UIElement.UseLayoutRoundingProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(UIElement.UseLayoutRoundingProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_PropertyGetter_UserControl ()
        {
            UserControl widget = new UserControl ();

            Assert.AreEqual(false, widget.IsTabStop, "IsTabStop does not match the default value");
            Assert.AreEqual(true, widget.IsEnabled, "IsEnabled does not match the default value");
            Assert.AreEqual(2147483647, widget.TabIndex, "TabIndex does not match the default value");
            Assert.AreEqual(KeyboardNavigationMode.Local, widget.TabNavigation, "TabNavigation does not match the default value");
            Assert.IsNull(widget.Template, "Template should have returned null");
            Assert.AreEqual("0,0,0,0", widget.Padding.ToString (), "Padding does not match the default value");
            Assert.AreEqual("0,0,0,0", widget.BorderThickness.ToString (), "BorderThickness does not match the default value");
            Assert.AreEqual(HorizontalAlignment.Center, widget.HorizontalContentAlignment, "HorizontalContentAlignment does not match the default value");
            Assert.AreEqual(VerticalAlignment.Center, widget.VerticalContentAlignment, "VerticalContentAlignment does not match the default value");
            Assert.IsNull(widget.Background, "Background should have returned null");
            Assert.IsNull(widget.BorderBrush, "BorderBrush should have returned null");
            Assert.IsNotNull(widget.FontFamily, "FontFamily should not have returned null");
            Assert.AreEqual("Portable User Interface", widget.FontFamily.ToString (), "FontFamily does not match the default value");
            Assert.AreEqual((double) 11, widget.FontSize, "FontSize does not match the default value");
            Assert.AreEqual("Normal", widget.FontStretch.ToString (), "FontStretch does not match the default value");
            Assert.AreEqual("Normal", widget.FontStyle.ToString (), "FontStyle does not match the default value");
            Assert.AreEqual("Normal", widget.FontWeight.ToString (), "FontWeight does not match the default value");
            Assert.IsNotNull(widget.Foreground, "Foreground should not have returned null");
            Assert.IsTrue(widget.Foreground is SolidColorBrush, "Foreground is not of the correct type");
            Assert.IsNotNull(widget.Triggers, "Triggers should not have returned null");
            Assert.IsTrue(widget.Triggers is TriggerCollection, "Triggers is not of the correct type");
            Assert.IsNotNull(widget.Resources, "Resources should not have returned null");
            Assert.IsTrue(widget.Resources is ResourceDictionary, "Resources is not of the correct type");
            Assert.AreEqual((double) 0, widget.ActualWidth, "ActualWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.ActualHeight, "ActualHeight does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Width), "Width does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Height), "Height does not match the default value");
            Assert.AreEqual((double) 0, widget.MinWidth, "MinWidth does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxWidth), "MaxWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.MinHeight, "MinHeight does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxHeight), "MaxHeight does not match the default value");
            Assert.AreEqual(HorizontalAlignment.Stretch, widget.HorizontalAlignment, "HorizontalAlignment does not match the default value");
            Assert.AreEqual(VerticalAlignment.Stretch, widget.VerticalAlignment, "VerticalAlignment does not match the default value");
            Assert.AreEqual("0,0,0,0", widget.Margin.ToString (), "Margin does not match the default value");
            Assert.IsNull(widget.Style, "Style should have returned null");
            Assert.IsNull(widget.Parent, "Parent should have returned null");
            Assert.IsNotNull(widget.Name, "Name should not have returned null");
            Assert.AreEqual("", widget.Name, "Name does not match the default value");
            Assert.IsNull(widget.Tag, "Tag should have returned null");
            Assert.IsNull(widget.Cursor, "Cursor should have returned null");
            Assert.IsNotNull(widget.Language, "Language should not have returned null");
            Assert.AreEqual("en-us", widget.Language.IetfLanguageTag, "Language does not match the default value");
            Assert.IsNull(widget.DataContext, "DataContext should have returned null");
            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNull(widget.Clip, "Clip should have returned null");
            Assert.IsNull(widget.OpacityMask, "OpacityMask should have returned null");
            Assert.AreEqual("0,0", widget.RenderTransformOrigin.ToString (), "RenderTransformOrigin does not match the default value");
            Assert.AreEqual(true, widget.IsHitTestVisible, "IsHitTestVisible does not match the default value");
            Assert.AreEqual(Visibility.Visible, widget.Visibility, "Visibility does not match the default value");
            Assert.AreEqual("0,0", widget.RenderSize.ToString (), "RenderSize does not match the default value");
            Assert.AreEqual(true, widget.UseLayoutRounding, "UseLayoutRounding does not match the default value");
            Assert.AreEqual("0,0", widget.DesiredSize.ToString (), "DesiredSize does not match the default value");
            Assert.IsNotNull(widget.RenderTransform, "RenderTransform should not have returned null");
            Assert.IsTrue(widget.RenderTransform is MatrixTransform, "RenderTransform is not of the correct type");
        }

        [TestMethod]
        public void Test_PropertyGetter_FrameworkElement ()
        {
            UserControl widget = new UserControl ();

            Assert.IsNotNull(widget.Triggers, "Triggers should not have returned null");
            Assert.IsTrue(widget.Triggers is TriggerCollection, "Triggers is not of the correct type");
            Assert.IsNotNull(widget.Resources, "Resources should not have returned null");
            Assert.IsTrue(widget.Resources is ResourceDictionary, "Resources is not of the correct type");
            Assert.AreEqual((double) 0, widget.ActualWidth, "ActualWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.ActualHeight, "ActualHeight does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Width), "Width does not match the default value");
            Assert.IsTrue(Double.IsNaN((double) widget.Height), "Height does not match the default value");
            Assert.AreEqual((double) 0, widget.MinWidth, "MinWidth does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxWidth), "MaxWidth does not match the default value");
            Assert.AreEqual((double) 0, widget.MinHeight, "MinHeight does not match the default value");
            Assert.IsTrue(Double.IsPositiveInfinity((double) widget.MaxHeight), "MaxHeight does not match the default value");
            Assert.AreEqual(HorizontalAlignment.Stretch, widget.HorizontalAlignment, "HorizontalAlignment does not match the default value");
            Assert.AreEqual(VerticalAlignment.Stretch, widget.VerticalAlignment, "VerticalAlignment does not match the default value");
            Assert.AreEqual("0,0,0,0", widget.Margin.ToString (), "Margin does not match the default value");
            Assert.IsNull(widget.Style, "Style should have returned null");
            Assert.IsNull(widget.Parent, "Parent should have returned null");
            Assert.IsNotNull(widget.Name, "Name should not have returned null");
            Assert.AreEqual("", widget.Name, "Name does not match the default value");
            Assert.IsNull(widget.Tag, "Tag should have returned null");
            Assert.IsNull(widget.Cursor, "Cursor should have returned null");
            Assert.IsNotNull(widget.Language, "Language should not have returned null");
            Assert.AreEqual("en-us", widget.Language.IetfLanguageTag, "Language does not match the default value");
            Assert.IsNull(widget.DataContext, "DataContext should have returned null");
            Assert.AreEqual((double) 1, widget.Opacity, "Opacity does not match the default value");
            Assert.IsNull(widget.Clip, "Clip should have returned null");
            Assert.IsNull(widget.OpacityMask, "OpacityMask should have returned null");
            Assert.AreEqual("0,0", widget.RenderTransformOrigin.ToString (), "RenderTransformOrigin does not match the default value");
            Assert.AreEqual(true, widget.IsHitTestVisible, "IsHitTestVisible does not match the default value");
            Assert.AreEqual(Visibility.Visible, widget.Visibility, "Visibility does not match the default value");
            Assert.AreEqual("0,0", widget.RenderSize.ToString (), "RenderSize does not match the default value");
            Assert.AreEqual(true, widget.UseLayoutRounding, "UseLayoutRounding does not match the default value");
            Assert.AreEqual("0,0", widget.DesiredSize.ToString (), "DesiredSize does not match the default value");
            Assert.IsNotNull(widget.RenderTransform, "RenderTransform should not have returned null");
            Assert.IsTrue(widget.RenderTransform is MatrixTransform, "RenderTransform is not of the correct type");
        }

        [TestMethod]
	[MoonlightBug]
        public void Test_SetStringValue_FrameworkElement ()
        {
            UserControl widget = new UserControl ();
            object retval;

            widget.SetValue(FrameworkElement.NameProperty, "some text");
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.AreEqual("some text", retval, "GetValue(FrameworkElement.NameProperty) should have returned 'some text'");
            widget.SetValue(FrameworkElement.NameProperty, null);
            retval = widget.GetValue(FrameworkElement.NameProperty);
            Assert.AreEqual(String.Empty, retval, "GetValue(FrameworkElement.NameProperty) should have returned String.Empty");
            retval = widget.ReadLocalValue(FrameworkElement.NameProperty);
            Assert.AreEqual(String.Empty, retval, "ReadLocalValue(FrameworkElement.NameProperty) should have returned String.Empty");
        }

    }
}
namespace MoonTest.System.Windows.Controls
{
    public partial class ButtonTest
    {
        [TestMethod]
        public void Test_ReadLocalValue_ButtonBase ()
        {
            Button widget = new Button ();
            object retval;

            retval = widget.ReadLocalValue(ButtonBase.ClickModeProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(ButtonBase.ClickModeProperty) should not have a value by default");
            retval = widget.ReadLocalValue(ButtonBase.IsFocusedProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(ButtonBase.IsFocusedProperty) should not have a value by default");
            retval = widget.ReadLocalValue(ButtonBase.IsMouseOverProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(ButtonBase.IsMouseOverProperty) should not have a value by default");
            retval = widget.ReadLocalValue(ButtonBase.IsPressedProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(ButtonBase.IsPressedProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_ContentControl ()
        {
            Button widget = new Button ();
            object retval;

            retval = widget.ReadLocalValue(ContentControl.ContentTemplateProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(ContentControl.ContentTemplateProperty) should not have a value by default");
            retval = widget.ReadLocalValue(ContentControl.ContentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(ContentControl.ContentProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_Control ()
        {
            Button widget = new Button ();
            object retval;

            retval = widget.ReadLocalValue(Control.IsTabStopProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.IsTabStopProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.TabIndexProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.TabIndexProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.TemplateProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.TemplateProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.TabNavigationProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.TabNavigationProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.PaddingProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.PaddingProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.HorizontalContentAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.HorizontalContentAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.VerticalContentAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.VerticalContentAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.BackgroundProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.BackgroundProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.BorderBrushProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.BorderBrushProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.BorderThicknessProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.BorderThicknessProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.FontSizeProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.FontSizeProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.FontFamilyProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.FontFamilyProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.ForegroundProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.ForegroundProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.FontWeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.FontWeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.FontStyleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.FontStyleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.FontStretchProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.FontStretchProperty) should not have a value by default");
            retval = widget.ReadLocalValue(Control.IsEnabledProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(Control.IsEnabledProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_FrameworkElement ()
        {
            Button widget = new Button ();
            object retval;

            retval = widget.ReadLocalValue(FrameworkElement.LanguageProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.LanguageProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.ActualWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.ActualWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.ActualHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.ActualHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.WidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.WidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.HeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.HeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MinWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MinWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MaxWidthProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MaxWidthProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MinHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MinHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MaxHeightProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MaxHeightProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.HorizontalAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.HorizontalAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.VerticalAlignmentProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.VerticalAlignmentProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.MarginProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.MarginProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.StyleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.StyleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.NameProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.NameProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.TagProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.TagProperty) should not have a value by default");
            retval = widget.ReadLocalValue(FrameworkElement.DataContextProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(FrameworkElement.DataContextProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_ReadLocalValue_UIElement ()
        {
            Button widget = new Button ();
            object retval;

            retval = widget.ReadLocalValue(UIElement.OpacityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.OpacityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.ClipProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.ClipProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.RenderTransformProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.RenderTransformProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.OpacityMaskProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.OpacityMaskProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.RenderTransformOriginProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.RenderTransformOriginProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.IsHitTestVisibleProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.IsHitTestVisibleProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.VisibilityProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.VisibilityProperty) should not have a value by default");
            retval = widget.ReadLocalValue(UIElement.UseLayoutRoundingProperty);
            Assert.AreEqual(DependencyProperty.UnsetValue, retval, "ReadLocalValue(UIElement.UseLayoutRoundingProperty) should not have a value by default");
        }

        [TestMethod]
        public void Test_GetValue_ButtonBase ()
        {
            Button widget = new Button ();
            object retval;

            retval = widget.GetValue(ButtonBase.ClickModeProperty);
            Assert.IsNotNull(retval, "GetValue(ButtonBase.ClickModeProperty) should not have returned null");
            Assert.IsTrue(retval is ClickMode, "GetValue(ButtonBase.ClickModeProperty) is not of the correct type");
            Assert.AreEqual(ClickMode.Release, retval, "GetValue(ButtonBase.ClickModeProperty) does not match the default value");
            retval = widget.GetValue(ButtonBase.IsFocusedProperty);
            Assert.IsNotNull(retval, "GetValue(ButtonBase.IsFocusedProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(ButtonBase.IsFocusedProperty) is not of the correct type");
            Assert.AreEqual(false, retval, "GetValue(ButtonBase.IsFocusedProperty) does not match the default value");
            retval = widget.GetValue(ButtonBase.IsMouseOverProperty);
            Assert.IsNotNull(retval, "GetValue(ButtonBase.IsMouseOverProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(ButtonBase.IsMouseOverProperty) is not of the correct type");
            Assert.AreEqual(false, retval, "GetValue(ButtonBase.IsMouseOverProperty) does not match the default value");
            retval = widget.GetValue(ButtonBase.IsPressedProperty);
            Assert.IsNotNull(retval, "GetValue(ButtonBase.IsPressedProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(ButtonBase.IsPressedProperty) is not of the correct type");
            Assert.AreEqual(false, retval, "GetValue(ButtonBase.IsPressedProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_GetValue_ContentControl ()
        {
            Button widget = new Button ();
            object retval;

            retval = widget.GetValue(ContentControl.ContentTemplateProperty);
            Assert.IsNull(retval, "GetValue(ContentControl.ContentTemplateProperty) should have returned null");
            retval = widget.GetValue(ContentControl.ContentProperty);
            Assert.IsNull(retval, "GetValue(ContentControl.ContentProperty) should have returned null");
        }

        [TestMethod]
        public void Test_GetValue_Control ()
        {
            Button widget = new Button ();
            object retval;

            retval = widget.GetValue(Control.IsTabStopProperty);
            Assert.IsNotNull(retval, "GetValue(Control.IsTabStopProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(Control.IsTabStopProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(Control.IsTabStopProperty) does not match the default value");
            retval = widget.GetValue(Control.TabIndexProperty);
            Assert.IsNotNull(retval, "GetValue(Control.TabIndexProperty) should not have returned null");
            Assert.IsTrue(retval is int, "GetValue(Control.TabIndexProperty) is not of the correct type");
            Assert.AreEqual(2147483647, retval, "GetValue(Control.TabIndexProperty) does not match the default value");
            retval = widget.GetValue(Control.TemplateProperty);
            Assert.IsNull(retval, "GetValue(Control.TemplateProperty) should have returned null");
            retval = widget.GetValue(Control.TabNavigationProperty);
            Assert.IsNotNull(retval, "GetValue(Control.TabNavigationProperty) should not have returned null");
            Assert.IsTrue(retval is KeyboardNavigationMode, "GetValue(Control.TabNavigationProperty) is not of the correct type");
            Assert.AreEqual(KeyboardNavigationMode.Local, retval, "GetValue(Control.TabNavigationProperty) does not match the default value");
            retval = widget.GetValue(Control.PaddingProperty);
            Assert.IsNotNull(retval, "GetValue(Control.PaddingProperty) should not have returned null");
            Assert.IsTrue(retval is Thickness, "GetValue(Control.PaddingProperty) is not of the correct type");
            Assert.AreEqual("0,0,0,0", retval.ToString (), "GetValue(Control.PaddingProperty) does not match the default value");
            retval = widget.GetValue(Control.HorizontalContentAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(Control.HorizontalContentAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is HorizontalAlignment, "GetValue(Control.HorizontalContentAlignmentProperty) is not of the correct type");
            Assert.AreEqual(HorizontalAlignment.Center, retval, "GetValue(Control.HorizontalContentAlignmentProperty) does not match the default value");
            retval = widget.GetValue(Control.VerticalContentAlignmentProperty);
            Assert.IsNotNull(retval, "GetValue(Control.VerticalContentAlignmentProperty) should not have returned null");
            Assert.IsTrue(retval is VerticalAlignment, "GetValue(Control.VerticalContentAlignmentProperty) is not of the correct type");
            Assert.AreEqual(VerticalAlignment.Center, retval, "GetValue(Control.VerticalContentAlignmentProperty) does not match the default value");
            retval = widget.GetValue(Control.BackgroundProperty);
            Assert.IsNull(retval, "GetValue(Control.BackgroundProperty) should have returned null");
            retval = widget.GetValue(Control.BorderBrushProperty);
            Assert.IsNull(retval, "GetValue(Control.BorderBrushProperty) should have returned null");
            retval = widget.GetValue(Control.BorderThicknessProperty);
            Assert.IsNotNull(retval, "GetValue(Control.BorderThicknessProperty) should not have returned null");
            Assert.IsTrue(retval is Thickness, "GetValue(Control.BorderThicknessProperty) is not of the correct type");
            Assert.AreEqual("0,0,0,0", retval.ToString (), "GetValue(Control.BorderThicknessProperty) does not match the default value");
            retval = widget.GetValue(Control.FontSizeProperty);
            Assert.IsNotNull(retval, "GetValue(Control.FontSizeProperty) should not have returned null");
            Assert.IsTrue(retval is double, "GetValue(Control.FontSizeProperty) is not of the correct type");
            Assert.AreEqual((double) 11, retval, "GetValue(Control.FontSizeProperty) does not match the default value");
            retval = widget.GetValue(Control.FontFamilyProperty);
            Assert.IsNotNull(retval, "GetValue(Control.FontFamilyProperty) should not have returned null");
            Assert.IsTrue(retval is FontFamily, "GetValue(Control.FontFamilyProperty) is not of the correct type");
            Assert.AreEqual("Portable User Interface", retval.ToString (), "GetValue(Control.FontFamilyProperty) does not match the default value");
            retval = widget.GetValue(Control.ForegroundProperty);
            Assert.IsNotNull(retval, "GetValue(Control.ForegroundProperty) should not have returned null");
            Assert.IsTrue(retval is SolidColorBrush, "GetValue(Control.ForegroundProperty) is not of the correct type");
            retval = widget.GetValue(Control.FontWeightProperty);
            Assert.IsNotNull(retval, "GetValue(Control.FontWeightProperty) should not have returned null");
            Assert.IsTrue(retval is FontWeight, "GetValue(Control.FontWeightProperty) is not of the correct type");
            Assert.AreEqual("Normal", retval.ToString (), "GetValue(Control.FontWeightProperty) does not match the default value");
            retval = widget.GetValue(Control.FontStyleProperty);
            Assert.IsNotNull(retval, "GetValue(Control.FontStyleProperty) should not have returned null");
            Assert.IsTrue(retval is FontStyle, "GetValue(Control.FontStyleProperty) is not of the correct type");
            Assert.AreEqual("Normal", retval.ToString (), "GetValue(Control.FontStyleProperty) does not match the default value");
            retval = widget.GetValue(Control.FontStretchProperty);
            Assert.IsNotNull(retval, "GetValue(Control.FontStretchProperty) should not have returned null");
            Assert.IsTrue(retval is FontStretch, "GetValue(Control.FontStretchProperty) is not of the correct type");
            Assert.AreEqual("Normal", retval.ToString (), "GetValue(Control.FontStretchProperty) does not match the default value");
            retval = widget.GetValue(Control.IsEnabledProperty);
            Assert.IsNotNull(retval, "GetValue(Control.IsEnabledProperty) should not have returned null");
            Assert.IsTrue(retval is bool, "GetValue(Control.IsEnabledProperty) is not of the correct type");
            Assert.AreEqual(true, retval, "GetValue(Control.IsEnabledProperty) does not match the default value");
        }

        [TestMethod]
        public void Test_GetValue_FrameworkElement ()
        {
            Button widget = new Button ();
            object retval;

            retval = widget.GetValue(FrameworkElement.LanguageProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.LanguageProperty) should not have returned null");
            Assert.IsTrue(retval is XmlLanguage, "GetValue(FrameworkElement.LanguageProperty) is not of the correct type");
            Assert.AreEqual("en-us", ((XmlLanguage) retval).IetfLanguageTag, "GetValue(FrameworkElement.LanguageProperty) does not match the default value");
            retval = widget.GetValue(FrameworkElement.ActualWidthProperty);
            Assert.IsNotNull(retval, "GetValue(FrameworkElement.ActualWidthProperty)