﻿// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License (Ms-PL).
// Please see http://go.microsoft.com/fwlink/?LinkID=131993 for details.
// All other rights reserved.


namespace System.Windows.Controls
{
    /// <summary>
    /// Dock - Enum which describes how to position and stretch the child of a DockPanel.
    /// </summary>
    public enum Dock
    {
        /// <summary>
        /// Position this child at the left of the remaining space.
        /// </summary>
        Left,

        /// <summary>
        /// Position this child at the top of the remaining space.
        /// </summary>
        Top,

        /// <summary>
        /// Position this child at the right of the remaining space.
        /// </summary>
        Right,

        /// <summary>
        /// Position this child at the bottom of the remaining space.
        /// </summary>
        Bottom,
    }

}
