
type t
type command_id = int
type output = [
  | `OUTPUT       of string
  | `ERROR        of string
  | `SYNTAX_ERROR of string]

val get_info : t -> string * string
val get_dbfname : t -> string

val make : string -> string -> t
val exit : t -> unit

val submit : t -> string list -> (output -> unit) -> command_id
val submit_sync : t -> string list -> string

val abort  : t -> command_id -> unit

