/*
 * Copyright 2001 Red Hat, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Red Hat not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  Red Hat makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * RED HAT DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL RED HAT
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Authors:  Jonathan Blandford
 */

#ifndef __MOBLIN_SETTINGS_DAEMON_H
#define __MOBLIN_SETTINGS_DAEMON_H

#include <gtk/gtk.h>
#include <gconf/gconf.h>
#include <gconf/gconf-client.h>

#include <bonobo/bonobo-object.h>

typedef void (* KeyCallbackFunc) (GConfEntry *entry);

void       moblin_settings_daemon_register_callback (const char      *dir,
						    KeyCallbackFunc  func);
GtkWidget *moblin_settings_daemon_get_invisible     (void);

void       moblin_settings_delayed_show_dialog      (GtkWidget       *dialog);

G_BEGIN_DECLS

#define MOBLIN_SETTINGS_DAEMON_TYPE (moblin_settings_daemon_get_type ())
#define MOBLIN_SETTINGS_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOBLIN_SETTINGS_DAEMON_TYPE, GnomeSettingsDaemon))
#define MOBLIN_SETTINGS_DAEMON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOBLIN_SETTINGS_DAEMON_TYPE, GnomeSettingsDaemonClass))
#define IS_MOBLIN_SETTINGS_DAEMON(obj) (GTK_TYPE_CHECK_INSTANCE_TYPE ((obj), MOBLIN_SETTINGS_DAEMON_TYPE))
#define IS_MOBLIN_SETTINGS_DAEMON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOBLIN_SETTINGS_DAEMON_TYPE))
#define MOBLIN_SETTINGS_DAEMON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOBLIN_SETTINGS_DAEMON_TYPE, GnomeSettingsDaemonClass))

typedef struct _GnomeSettingsDaemon GnomeSettingsDaemon;
typedef struct _GnomeSettingsDaemonClass GnomeSettingsDaemonClass;
typedef struct _GnomeSettingsDaemonPrivate GnomeSettingsDaemonPrivate;

struct _GnomeSettingsDaemon
{
  GObject parent_instance;
  GnomeSettingsDaemonPrivate *private;
};

struct _GnomeSettingsDaemonClass
{
  GObjectClass parent_class;
};

GType    moblin_settings_daemon_get_type         (void);
GObject *moblin_settings_daemon_new              (void);
void     moblin_settings_daemon_shutdown         (void);
void     moblin_settings_daemon_spawn_with_input (char       **argv,
						 const char  *input);

GConfClient *moblin_settings_daemon_get_conf_client (void);

/**
 * DBUS server
 */
GType moblin_settings_server_get_type (void);

G_END_DECLS

#endif /* __MOBLIN_SETTINGS_DAEMON_H */
