      SUBROUTINE cleo_ERRLUN( CRNAME, ILUN, IERR, CTEXT )
C.......................................................................
C.
C. ERRLUN - Error handler for the LUN manager
C.
C. Inputs    : CRNAME - Character name of calling routine
C.           : ILUN   - Unit number to which error applies
C.           : IERR   - Code indicating type of error
C.           : CTEXT  - Additional error specific text
C. Outputs   : None
C.
C. COMMON    : LUNMCI LUNMCC
C. Calls     : LENOCC MESLOG REPLUN
C. Called    : CHKLUN FRELUN GETLUN LOKLUN
C.
C.......................................................................
C
C------------------------- Argument declarations -----------------------
C
      CHARACTER*(*) CRNAME, CTEXT
      INTEGER ILUN, IERR
C
C------------------------- EXTERNAL declarations -----------------------
C
      INTEGER  LENOCC
      EXTERNAL LENOCC
C
C------------------------- SEQUENCE declarations -----------------------
C
C
* LUNMIN - Smallest allowed LUN number
* LUNMAX - Largest  allowed LUN number
* MAXLUN - Length of the    LUN number allocation table
*
      INTEGER    LUNMIN,     LUNMAX
      PARAMETER( LUNMIN = 1, LUNMAX = 99 )
*
      INTEGER    MAXLUN
      PARAMETER( MAXLUN = LUNMAX - LUNMIN + 1 )
*
* LISUSE - Flag for LUN is in use
* LISFRE - Flag for LUN is free
* LISLOK - Flag for LUN is locked
*
      INTEGER    LISUSE,     LISFRE,     LISLOK
      PARAMETER( LISUSE = 1, LISFRE = 0, LISLOK = -1 )
*
* LUSEER - Error, LUN in use
* LRNGER - Error, LUN number out of range
* LTABER - Error, LUN allocation table corrupted
* LFULER - Error, LUN allocation table full
* LLOKER - Error, LUN is already locked
* LFLKER - Error, LUN is locked, cannot be freed
* LINIER - Error, in initialization
* LUALER - Error, found unalloacted unit connected to file
* LNONAM - Warning, Allocator name is blank
* LDIFER - Warning, Allocator and deallocator are different
*
      INTEGER    LUSEER,     LRNGER,     LTABER,     LFULER
      PARAMETER( LUSEER = 1, LRNGER = 2, LTABER = 3, LFULER = 4 )
      INTEGER    LLOKER,     LFLKER,     LINIER,     LUALER
      PARAMETER( LLOKER = 5, LFLKER = 6, LINIER = 7, LUALER = 8 )
      INTEGER    LNONAM,     LDIFER
      PARAMETER( LNONAM = 9, LDIFER =10                         )
*
* LUNTBL - The LUN allocation table
* LUNOWN - The LUN allocation owner table
*
      INTEGER         LUNTBL
      COMMON /LUNMCI/ LUNTBL(LUNMIN:LUNMAX)
      CHARACTER*8     LUNOWN
      COMMON /LUNMCC/ LUNOWN(LUNMIN:LUNMAX)
*
* MSSUCC - Message severity is SUCCESS
* MSINFO - Message severity is INFORMATION
* MSWARN - Message severity is WARNING
* MSERRO - Message severity is ERROR
* MSFATA - Message severity is FATAL
* CHMESS - Text of current message
*
      CHARACTER*(*) MSSUCC,             MSINFO
      PARAMETER(    MSSUCC = 'SUCCESS', MSINFO = 'INFORMATION' )
      CHARACTER*(*) MSWARN,             MSERRO
      PARAMETER(    MSWARN = 'WARNING', MSERRO = 'ERROR'       )
      CHARACTER*(*) MSFATA
      PARAMETER(    MSFATA = 'FATAL'                           )
*
      CHARACTER*132   CHMESS
      COMMON /MESREP/ CHMESS
*
C
C------------------------- Local    declarations -----------------------
C
      CHARACTER*80 FNAME
      INTEGER NLEN
      LOGICAL LNAMED
C
C------------------------- SAVE     declarations -----------------------
C
* None
C
C------------------------- DATA  initializations -----------------------
C
* None
C
C---------------------- Executable code starts here --------------------
C
C
C== Write message into CHMESS and call MESLOG
C
      IF(     IERR.EQ.LUSEER ) THEN
         NLEN = LENOCC(LUNOWN(ILUN))
         WRITE(CHMESS,1000) ILUN, LUNOWN(ILUN)(1:NLEN)
         CALL CLEO_MESLOG(CRNAME,IERR,MSERRO)
      ELSEIF( IERR.EQ.LRNGER ) THEN
         WRITE(CHMESS,1010) ILUN
         CALL CLEO_MESLOG(CRNAME,IERR,MSERRO)
      ELSEIF( IERR.EQ.LTABER ) THEN
         WRITE(CHMESS,1020)
         CALL CLEO_MESLOG(CRNAME,IERR,MSFATA)
         CALL CLEO_REPLUN
      ELSEIF( IERR.EQ.LFULER ) THEN
         WRITE(CHMESS,1030)
         CALL CLEO_MESLOG(CRNAME,IERR,MSFATA)
         CALL CLEO_REPLUN
      ELSEIF( IERR.EQ.LLOKER ) THEN
         NLEN = LENOCC(LUNOWN(ILUN))
         WRITE(CHMESS,1040) ILUN, LUNOWN(ILUN)(1:NLEN)
         CALL CLEO_MESLOG(CRNAME,IERR,MSERRO)
      ELSEIF( IERR.EQ.LFLKER ) THEN
         NLEN = LENOCC(LUNOWN(ILUN))
         WRITE(CHMESS,1050) ILUN, LUNOWN(ILUN)(1:NLEN)
         CALL CLEO_MESLOG(CRNAME,IERR,MSERRO)
      ELSEIF( IERR.EQ.LINIER ) THEN
         WRITE(CHMESS,1060) ILUN
         CALL CLEO_MESLOG(CRNAME,IERR,MSFATA)
      ELSEIF( IERR.EQ.LUALER ) THEN
         FNAME = ' '
         INQUIRE(UNIT=ILUN, NAME=FNAME, NAMED=LNAMED )
         IF( FNAME.EQ.' ' .OR. .NOT.LNAMED ) THEN
            WRITE(CHMESS,1070) ILUN
            CALL CLEO_MESLOG(CRNAME,IERR,MSWARN)
         ELSE
            WRITE(CHMESS,1080) ILUN
            CALL CLEO_MESLOG(CRNAME,IERR,MSWARN)
            WRITE(CHMESS,1085) FNAME
            CALL CLEO_MESLOG(CRNAME,IERR,MSWARN)
         ENDIF
      ELSEIF( IERR.EQ.LDIFER ) THEN
         NLEN = LENOCC(LUNOWN(ILUN))
         WRITE(CHMESS,1090) ILUN, LUNOWN(ILUN)(1:NLEN),
     +   CTEXT(1:LENOCC(CTEXT))
         CALL CLEO_MESLOG(CRNAME,IERR,MSWARN)
      ELSEIF( IERR.EQ.LNONAM ) THEN
         WRITE(CHMESS,1095) ILUN
         CALL CLEO_MESLOG(CRNAME,IERR,MSWARN)
      ELSE
         WRITE(CHMESS,1100) IERR
         CALL CLEO_MESLOG(CRNAME,IERR,MSWARN)
      ENDIF
C
      RETURN
C
 1000 FORMAT(' LUN number', I3,
     +       ' is allocated by ', A, ' and cannot be locked' )
 1010 FORMAT(' LUN number', I10, ' is out of range' )
 1020 FORMAT(' LUN table has been corrupted' )
 1030 FORMAT(' LUN table is full' )
 1040 FORMAT(' LUN number', I3, ' is already locked by ', A )
 1050 FORMAT(' LUN number', I3, ' is locked by ', A,
     +       ' it cannot be freed' )
 1060 FORMAT(' Initialization failure' )
 1070 FORMAT(' LUN number', I3,
     +       ' has unallocated connection to an unnamed file,',
     +       ' unit will be locked' )
 1080 FORMAT(' LUN number', I3,
     +       ' has unallocated connection to the following file,',
     +       ' unit will be locked' )
 1085 FORMAT(' File name: ', A )
 1090 FORMAT(' LUN number', I3, ' allocated by ', A, ' deallocated',
     +       ' by ', A )
 1095 FORMAT(' LUN number', I3, ' owner name is blank' )
 1100 FORMAT(' Unknown error, IERR = ', I6 )
C
      END
