      subroutine mn_rootpwd(tdir)
*-----------------------------------------------------------------------
*     List current directory in a root file stripping off the filename
*
*     $Id: mn_rootpwd.fpp,v 1.4 2005/05/13 20:59:22 brock Exp $
*-----------------------------------------------------------------------
*
      implicit none
*
      character*(*) tdir
*
#include "mnlun.inc"
#if ( defined(ROOT) )
*
      character*255 txt1
      integer lend,istat,ind
*
      integer lnblnk
      integer m_root_pwd
#endif
*
*-----------------------------------------------------------------------
*
#if ( !defined(ROOT) )
        txterr = 'Root not in this Mn_Fit version'
        call mn_err('MN_ROOTPWD',txterr)
        goto 9000
#else
        istat = m_root_pwd(lend,txt1)
*ICB        write(6,'('' m_root_pwd returns: '',A)') txt1(:lend)
        if(istat.ne.0) then
          tdir = ' '
          txterr = 'Error finding current directory'
          call mn_err('MN_ROOTPWD',txterr)
          goto 9000
        else
          ind = index(txt1,':/')
          if(ind.gt.0) then
            if(ind+2.gt.lend) then
              tdir = '//root'
            else
              tdir = '//root/' // txt1(ind+2:lend)
            endif
          else
            tdir = '//root/' // txt1(1:lend)
          endif
          lend = lnblnk(tdir)
          write(6,'('' MN_ROOTPWD: Current root directory is: '',A)')
     +     tdir(:lend)
        endif
#endif
*
 9000   continue
        end
