      SUBROUTINE M_CGET(NMODE,COMAND,ICMD,IDELIM)
C
C     Gets the command given to MN_CLC etc and does the usual checking
C     NMODE = -1 means can make a new variable
C     NMODE =  0 means only allow existing variables
C     NMODE =  1 means called from M_PRSE - must include SIN, COS etc.
C
C     If this is cut parsing then first check for a non-abbreviated
C     ntuple variable. This is only valid for NMODE = 1.
C     First check for a non-abbreviated variable name.
C     If that fails strip off any following digits and check
C     for a non-abbreviated standard parameter name.
C     If that fails and NMODE = -1 make a new parameter.
C
      IMPLICIT NONE
C
#include "mnpar.inc"
#include "mnprs.inc"
#include "mntpl.inc"
#include "mnprj.inc"
#include "mnlun.inc"
C
      CHARACTER*(*) COMAND
      INTEGER NMODE,ICMD,IDELIM
C
      CHARACTER*32 TCOMM,TUNAME
      INTEGER I,ITYPE,NCHSAV,NMATCH,LEN1,LEN2,lenu,lenv
      INTEGER ICMTYP,ICMLST,NCHLFT,LNBLNK
      integer mlist
      parameter (mlist = 10)
      integer ilist(mlist)
C
      ICMD = 0
      COMAND = ' '
      NCHSAV = MAX0(0,NCHLFT())
C
      IF(NMODE.LE.0) THEN
          ITYPE = ICMTYP(.TRUE.,IDELIM,DEPNAM)
      ELSE
          ITYPE = ICMTYP(.TRUE.,IDELIM,CLCNAM)
      ENDIF
      IF(IDELIM.GT.0) GOTO 9000
      IF(ITYPE.LT.0) GOTO 5000
      CALL ICMSTR(TCOMM)
      LEN1 = LNBLNK(TCOMM)
      lenu = len(tuname)
      lenv = len(varnam(1))
C
C     See if it is an Ntuple variable
C
      IF(NMODE.EQ.1 .AND. QPROJ) THEN
          DO 500 I=1,NVAR
              TUNAME = ' '
              CALL M_LUPC(TAGS(I),TUNAME)
              IF(TCOMM(1:min(LEN1,lenu)).EQ.TUNAME) THEN
                  ITYPE = MNTP0 + I
                  COMAND = TUNAME
                  GOTO 5100
              ENDIF
  500     CONTINUE
      ENDIF
C
C     See if it a variable name
C
      DO 1000 I=1,NVARBL
          IF(TCOMM(1:min(LEN1,lenv)).EQ.VARNAM(I)) THEN
              IF(NMODE.LE.0) THEN
                  ITYPE = MDEPI + I
              ELSE
                  ITYPE = MPRSE + MDEPI + I
              ENDIF
              GOTO 5000
          ENDIF
1000  CONTINUE
C
C     If it is ambiguous see if a solution matches exactly
C
      IF(ITYPE.LE.0) THEN
          NMATCH = ICMLST(mlist,ilist)
          do i=1,nmatch
              if(nmode.le.0) then
                  len2 = lnblnk(depnam(ilist(i)))
                  if(tcomm(:len1).eq.depnam(ilist(i))(:len2))
     +             then
                      itype = ilist(i)
                      goto 5000
                  endif
              else
                  len2 = lnblnk(clcnam(ilist(i)))
                  if(tcomm(:len1).eq.clcnam(ilist(i))(:len2))
     +             then
                      itype = ilist(i)
                      goto 5000
                  endif
              endif
          enddo
      ENDIF
C
C     Now strip any digits off the end of the name and see if it matches
C
      IF(ITYPE.GT.0 .AND.
     +   ((NMODE.LE.0 .AND. ITYPE.LE.MDEPI) .OR.
     +    (NMODE.GT.0 .AND. ITYPE.LE.MPRSE+MDEPI))) THEN
 2000     CONTINUE
          IF(TCOMM(LEN1:LEN1).GE.'0' .AND. TCOMM(LEN1:LEN1).LE.'9') THEN
              LEN1 = LEN1 - 1
              GOTO 2000
          ENDIF
C
C     If ITYPE indicates it is a variable, but it does not completely
C     match then it is not really an existing variable
C
      ELSEIF(ITYPE.GT.0) THEN
          ITYPE = 0
      ENDIF
C
C     Check that the command is not abbreviated
C     If this is NMODE = -1 make a new variable of the command
C
      IF(NMODE.EQ.-1 .AND. ITYPE.GT.0) THEN
          LEN2 = LNBLNK(DEPNAM(ITYPE))
          IF(TCOMM(1:LEN1).NE.DEPNAM(ITYPE)(1:LEN2)) THEN
              ITYPE = 0
              GOTO 2500
          ENDIF
      ELSEIF(NMODE.EQ.0 .AND. ITYPE.GT.0) THEN
          LEN2 = LNBLNK(DEPNAM(ITYPE))
          IF(TCOMM(1:LEN1).NE.DEPNAM(ITYPE)(1:LEN2)) THEN
              IDELIM = 1
              GOTO 9000
          ENDIF
      ELSEIF(NMODE.GT.0 .AND. ITYPE.GT.0) THEN
          LEN2 = LNBLNK(CLCNAM(ITYPE))
          IF(TCOMM(1:LEN1).NE.CLCNAM(ITYPE)(1:LEN2)) THEN
              IDELIM = 1
              GOTO 9000
          ENDIF
      ENDIF
C
C     Make a new variable if this is mode -1
C
2500  CONTINUE
      IF(NMODE.EQ.-1 .AND. ITYPE.EQ.0) THEN
          IF(NVARBL.GE.MVARBL) THEN
              CALL MN_ERR('M_CGET'
     +         ,'Ran out of room for more variables')
              IDELIM = 1
              GOTO 9000
          ENDIF
          LEN1 = LNBLNK(TCOMM)
C
C         Check that it is a legal variable name
C
          IF(TCOMM.EQ.'ALL') THEN
              CALL MN_ERR('M_CGET','ALL is not a legal variable name')
              IDELIM = 1
              GOTO 9000
          ENDIF
C
          DO 3000 I=1,MPRSE
              IF(TCOMM(1:LEN1).EQ.PRSNAM(I)) THEN
                  TXTERR = TCOMM(1:LEN1) //
     +             ' is not a legal variable name'
                  CALL MN_ERR('M_CGET',TXTERR)
                  IDELIM = 1
                  GOTO 9000
              ENDIF
3000      CONTINUE
C
          DO 3100 I=1,MDEPI
              IF(TCOMM(1:LEN1).EQ.DPINAM(I)) THEN
                  TXTERR = TCOMM(1:LEN1) //
     +             ' is not a legal variable name'
                  CALL MN_ERR('M_CGET',TXTERR)
                  IDELIM = 1
                  GOTO 9000
              ENDIF
3100      CONTINUE
C
C         Check the length of the variable name and warn if is too long
C
          if(len1.gt.lenv) then
            txterr = 'WARNING Variable ' // tcomm(:len1) //
     +       ' will be truncated to ' // tcomm(:lenv)
            call m_emsg('M_CGET',txterr)
          endif
C
C         Add the new variable name
C
          NVARBL = NVARBL + 1
          VARNAM(NVARBL) = TCOMM
          IF(NMODE.LE.0) THEN
              ITYPE = MDEPI + NVARBL
          ELSE
              ITYPE = MPRSE + MDEPI + NVARBL
          ENDIF
C
C     Otherwise it is an unknown variable
C
      ELSEIF(ITYPE.EQ.0) THEN
          IDELIM = 1
          GOTO 9000
      ENDIF
C
5000  CONTINUE
      IF(ITYPE.GT.0) THEN
          IF(NMODE.LE.0) THEN
              COMAND = DEPNAM(ITYPE)
          ELSE
              COMAND = CLCNAM(ITYPE)
          ENDIF
      ENDIF
5100  CONTINUE
      ICMD   = ITYPE
C
9000  CONTINUE
      END
