      SUBROUTINE MN_DFL
C
C     SETS DEFAULT VALUES FOR PARAMETERS
C
      implicit none
*
#include "mnpar.inc"
#include "mnfit.inc"
#include "mnfun.inc"
#include "mnhpj.inc"
#include "mnplt.inc"
#include "mncwn.inc"
#include "mncmd.inc"
#include "mntyq.inc"
#include "mnflg.inc"
#include "mngrn.inc"
#include "mnlun.inc"
C
      QSEXCL  = .TRUE.
      NSID    = 2
      NSHEAD  = 2
      NSFOOT  = 0
      TSFOOT  = ' '
      QSTEXT  = .TRUE.
      QTUSER  = .FALSE.
      QTGLBL  = .FALSE.
      QSBOX   = .FALSE.
      QLEGO   = .FALSE.
      QDFIT   = .FALSE.
      QDFUN   = .FALSE.
      QMNCHGE = .TRUE.
      QPIPLT  = .FALSE.
      qascal  = .true.
      qatrim  = .true.
C
C     Do not use mouse for positioning things
C
      QMOUSE = .FALSE.
*
*     Automatically refetch Ntuples when they are to be projected
*
      QAFETCH = .TRUE.
C
C     Function Parameters
C
      NFPNT = 500
C
C     Fit Display Parameters
C
      NDMODE = 1
C
C     CWN variables
C
      ncwn_x = 0
C
C     PICTURE AND PLOT SIZES AND MARGINS
C
      SIZES(1) = SIZED(1)
      SIZES(2) = SIZED(2)
      AMRGS(1) = AMRGD(1)
      AMRGS(2) = AMRGD(2)
      WMRGS(1) = WMRGD(1)
      WMRGS(2) = WMRGD(2)
      HSZES(1) = HSZED(1)
      HSZES(2) = HSZED(2)
      WSZES(1) = WSZED(1)
      WSZES(2) = WSZED(2)
C
C     LIMITS FOR PLOTS
C
      CALL UCOPY_r(ALIMD(1,1),ALIMS(1,1),2*3)
C
C     LEGO PLOT DEFAULT ANGLES
C
      CALL UCOPY_r(ALEGD(1),ALEGS(1),10)
C
      NSYMS = NSYMD
      NHATS = NHATD
      NPATS = NPATD
C
C     Colours
C
      CALL UCOPY_i(ICOLD,ICOLS,20)
C
C     Line thicknesses
C
      CALL UCOPY_r(ATHKD,ATHKS,10)
C
C     Fonts
C
      CALL UCOPY_i(IFNTD,IFNTS,10)
C
C     TEXT AND SYMBOL SIZES
C
      CALL UCOPY_r(TSZED,TSZES,10)
C
C     Bin scaling and offsets
C
      CALL UCOPY_r(ABIND,ABINS,10)
C
C     DRAW LINE AT X OR Y = 0 AND SYMBOL
C
      QZEROS(1) = QZEROD(1)
      IZEROS(1) = IZEROD(1)
      QZEROS(2) = QZEROD(2)
      IZEROS(2) = IZEROD(2)
C
C     Draw a grid on the plot
C
      IGRIDS(1,1) = IGRIDD(1,1)
      IGRIDS(2,1) = IGRIDD(2,1)
      IGRIDS(1,2) = IGRIDD(1,2)
      IGRIDS(2,2) = IGRIDD(2,2)
      IGRIDS(1,3) = IGRIDD(1,3)
      IGRIDS(2,3) = IGRIDD(2,3)
C
C     WINDOWING, NUMBER OF WINDOWS AND THEIR SPACING
C
      QWIND = .FALSE.
      IWIND(1) = 1
      IWIND(2) = 1
      WSPACE(1) = 2.0
      WSPACE(2) = 2.0
      IPWNDS(1) = IPWNDD(1)
      IPWNDS(2) = IPWNDD(2)
C
C     DRAW FRAME ROUND THE PLOT
C
      CALL QCOPY(QFRAMD(1,1),QFRAMS(1,1),10*3)
C
C     SET NUMBER OF TICKS AND SIZES TO DEFAULT VALUES
C
      CALL UCOPY_r(TICKD(1,1),TICKS(1,1),10*3)
      CALL QCOPY(QTICKD(1,1),QTICKS(1,1),10*3)
C
C     SET SCALE PARAMETERS TO DEFAULT VALUES
C
      ISMODS(1) = ISMODD(1)
      ISMODS(2) = ISMODD(2)
      ISMODS(3) = ISMODD(3)
      CALL UCOPY_r(SCALD(1,1),SCALS(1,1),10*3)
      CALL QCOPY(QSCALD(1,1),QSCALS(1,1),10*3)
C
C     SET AXIS LABELS TO DEFAULT VALUES
C
      CALL UCOPY_r(ALABLD(1,1),ALABLS(1,1),10*3)
      CALL QCOPY(QLABLD(1,1),QLABLS(1,1),10*3)
      ILABLS(1) = ILABLD(1)
      ILABLS(2) = ILABLD(2)
      ILABLS(3) = ILABLD(3)
      TLABLS(1) = TLABLD(1)
      TLABLS(2) = TLABLD(2)
      TLABLS(3) = TLABLD(3)
C
C     SET TITLE POSITION TO DEFAULT VALUES
C
      CALL UCOPY_r(TITLD(1),TITLS(1),10)
      CALL UCOPY_r(TITGD(1),TITGS(1),10)
      CALL QCOPY(QTITLD(1),QTITLS(1),10)
C
C     SIZES FOR THE DISPLAY COMMAND
C
      FSIZE(1) = FSIZED(1)
      FSIZE(2) = FSIZED(2)
      FAMRG(1) = FAMRGD(1)
      FAMRG(2) = FAMRGD(2)
      FHSZE(1) = FHSZED(1)
      FHSZE(2) = FHSZED(2)
C
      CALL VZERO_i(NPLTCM,MHPLT)
      CALL VZERO_i(NPLTKY,MHPLT)
      NDRWLN = 0
C
      LUNDMP = LUNTTO
C
C     Initialize stuff for interface to IGTABL
C
      NIGPARS = NIGPARD
      CALL UCOPY_r(AIGPARD,AIGPARS,MIGPAR)
      TIGOPTS = TIGOPTD
      LIGOPTS = LIGOPTD
C
C     Reset all HIGZ stuff to default and switch back to alphanumeric mode
C     Also make sure the normalization transformation is set properly
C
CICB      CALL HPLOPT('*   ',1)
CICB      CALL HPLSET('*',0.0)
CICB      CALL HPLOPT('TIC ',1)
      CALL IGSET('*',0.0)
      CALL TVRNG(.TRUE.,0.0,0.0,SIZES(1),SIZES(2))
      CALL IGSA(0)
C
C     Parameters for the special displays - implemented for L3
C
      CALL MN_DSD
C
      RETURN
      END
