      SUBROUTINE M_CSTR(NMODE,IDELIM,FCN,FUTIL)
C
C-----------------------------------------------------------------------
C
C     Adds, deletes and prints constraints on a parameter
C     NMODE = -1 means remove a constraint
C     NMODE =  0 means print the current constraints
C     NMODE =  1 means set a constraint
C
C     Called by MIN_CMD, MN_SHW
C
C-----------------------------------------------------------------------
C
      EXTERNAL FCN,FUTIL
C
#include "mnpar.inc"
#include "mnfit.inc"
#include "mnlun.inc"
C
      CHARACTER*20 TCMD
      DOUBLE PRECISION FMIN,FEDM,ERRDEF,RNUMB(1)
      LOGICAL QPASS
C
C     Remove a constraint
C
      IF(NMODE.EQ.-1) THEN
          CALL WAITYQ(
     +     'Give parameter number with constraint (0 for all): ')
          NVAL = IVLTYQ(.TRUE.,IDELIM)
          CALL MN_NCK(NVAL,IDELIM,IERR)
          IF(IERR.GT.0) GOTO 9000
C
          IF(NVAL.LT.0 .OR. NVAL.GT.NPAR_MN) THEN
              WRITE(TXTERR,'(''Parameter number'',I3
     +         ,'' is out of range 0->'',I3)',IOSTAT=IOERR) NVAL,NPAR_MN
              CALL MN_ERR('M_CSTR',TXTERR)
          ENDIF
C
          IF(NVAL.GT.0) NC = JCNSTX(NVAL)
C
          IF(NVAL.EQ.0) THEN
              NCNSTR = 0
              CALL VZERO_i(JCNSTX(1),MINMAX)
          ELSEIF(NC.LE.0 .OR. NC.GT.NCNSTR) THEN
              WRITE(TXTERR,'(''Constraint'',I4,'' is not valid'')'
     +         ,IOSTAT=IOERR) NVAL
              CALL MN_ERR('M_CSTR',TXTERR)
              GOTO 9000
          ELSEIF(NC.EQ.NCNSTR) THEN
              JCNSTX(NVAL) = 0
              NCNSTR = NCNSTR - 1
          ELSE
              NCOP = (NCNSTR - NC)
              CALL UCOPY_i(ICNPAR(NC+1),ICNPAR(NC),NCOP)
              CALL UCOPY_i(LCNSTR(NC+1),LCNSTR(NC),NCOP)
              CALL TCOPY(TCNSTR(NC+1),TCNSTR(NC),NCOP)
              CALL UCOPY_i(ICNTYP(1,NC+1),ICNTYP(1,NC),NCOP*MCNSUB)
              CALL UCOPY_i(ICNTP(1,NC+1), ICNTP(1,NC),NCOP*MCNSUB)
              CALL UCOPY_i(ICNTF(1,NC+1), ICNTF(1,NC),NCOP*MCNSUB)
              JCNSTX(NVAL) = 0
              DO 1000 I=NC,NCNSTR-1
                  JCNSTX(ICNPAR(I)) = I
1000          CONTINUE
              NCNSTR = NCNSTR - 1
          ENDIF
C
C         Float this MINUIT parameter
C
          IF(NVAL.GT.0) THEN
              TCMD = 'RELEASE'
              RNUMB(1) = DBLE(NVAL)
              CALL MNEXCM(FCN,TCMD,RNUMB,1,IERFLG,FUTIL)
          ENDIF
C
C     Print the current constraints
C
      ELSEIF(NMODE.EQ.0) THEN
          IF(NCNSTR.LE.0) THEN
              CALL MN_MES(LUNTTO,'IE','There are no constraints')
          ELSE
              CALL MN_MES(LUNTTO,'I'
     +         ,' The following constraints exist:')
              CALL MN_MES(LUNTTO,'I','    Par Len      Text')
              DO 2000 I=1,NCNSTR
                  LENC = MIN0(67,LENOCC(TCNSTR(I)))
                  WRITE(TXTMES,'(1X,I2,'':'',I3,I4,1X,A)',IOSTAT=IOERR)
     +             I,ICNPAR(I),LCNSTR(I),TCNSTR(I)(1:LENC)
                  CALL MN_MES(LUNTTO,'I',TXTMES)
2000          CONTINUE
              CALL MN_MES(LUNTTO,'E',' ')
          ENDIF
C
C     Set a constraint
C
      ELSEIF(NMODE.EQ.1) THEN
          CALL MNSTAT(FMIN,FEDM,ERRDEF,NPARI,NPARX,ISTAT)
C
          CALL WAITYQ('Give parameter number and constraint: ')
          NVAL = IVLTYQ(.TRUE.,IDELIM)
          CALL MN_NCK(NVAL,IDELIM,IERR)
          IF(IERR.GT.0) GOTO 9000
C
          IF(NVAL.LE.0 .OR. NVAL.GT.NPARX) THEN
              WRITE(TXTERR,'(''Parameter'',I3,'' is out of range''
     +         ,'' 1 ->'',I3)',IOSTAT=IOERR) NVAL,NPARX
              CALL MN_ERR('M_CSTR',TXTERR)
              GOTO 9000
          ENDIF
C
C         Check if a constraint for this parameter already exist
C
          DO 3000 I=1,NCNSTR
              IF(ICNPAR(I).EQ.NVAL) THEN
                  WRITE(TXTERR,'(''Parameter'',I3
     +             ,'' is already constrained in constraint'',I3)'
     +             ,IOSTAT=IOERR) NVAL,I
                  CALL MN_ERR('M_CSTR',TXTERR)
                  GOTO 9000
              ENDIF
3000      CONTINUE
C
          NC = NCNSTR + 1
          IF(NC.GT.MCNSTR) THEN
              WRITE(TXTERR,'(''I can only have a maximum of'',I3
     +         ,'' constraints'')') MCNSTR
              CALL MN_ERR('M_CSTR',TXTERR)
              GOTO 9000
          ENDIF
C         CALL WAITYQ('Give expression or filename: ')
          CALL WAITYQ('Give expression: ')
          ISTR = ISTRNQ(.TRUE.,TCNSTR(NC),NCHAR)
          IF(NCHAR.LE.0) GOTO 9000
          CALL M_PRSE(.FALSE.,LCNSTR(NC),TCNSTR(NC)
     +     ,ICNTYP(1,NC),ICNTP(1,NC),ICNTF(1,NC),ICNTV(1,1,NC),QPASS)
          IF(LCNSTR(NC).GT.MCNSUB) THEN
              CALL MN_ERR('M_CSTR'
     +         ,'Expression is too long to be stored.' //
     +         ' I hope you have not overwritten anything')
              GOTO 9000
          ENDIF
C
          IF(QPASS) THEN
              ICNPAR(NC) = NVAL
              NCNSTR = NC
              JCNSTX(ICNPAR(NCNSTR)) = NCNSTR
C
C             Fix this MINUIT parameter
C
              TCMD = 'FIX'
              RNUMB(1) = DBLE(ICNPAR(NCNSTR))
              CALL MNEXCM(FCN,TCMD,RNUMB,1,IERFLG,FUTIL)
          ELSE
              CALL MN_ERR('M_CSTR','Error specifying constraint')
              GOTO 9000
          ENDIF
C
      ELSE
          WRITE(TXTERR,'(''Unknown mode'',I4,'' for a constraint'')'
     +     ,IOSTAT=IOERR) NMODE
          CALL MN_ERR('M_CSTR',TXTERR)
      ENDIF
C
9000  CONTINUE
      END
