      SUBROUTINE M_FHSMO(NF,IERR)
C
C-----------------------------------------------------------------------
C
C     Smooths a histogram to be used as a function
C
C     Called by MN_ADF, MN_FQU, MN_FTI
C
C-----------------------------------------------------------------------
C
      IMPLICIT NONE
C
#include "mnpar.inc"
#include "mninf.inc"
#include "mnfun.inc"
#include "mnlun.inc"
C
      INTEGER MV
      PARAMETER (MV=1)
C
      INTEGER NF,IERR
C
      INTEGER IDA,IDB,NH,NHS
      INTEGER I,MODE
      DOUBLE PRECISION WY(0:MHPTMX,1)
      REAL AMNX,AMNE
C
      EXTERNAL AMNX,AMNE
C
      IERR = 0
      IDA = NINT(XFXPAR(1,NF))
      IDB = NINT(XFXPAR(2,NF))
      CALL MN_HGT(IDA,IDB,NH)
C
      IF(NH.LE.0) THEN
          IERR = 1
          WRITE(TXTERR,'(''Histogram'',I7,I4,'' does not exist'')')
     +     IDA,IDB
          CALL MN_ERR('M_FHSMO',TXTERR)
          GOTO 9000
      ELSEIF(IABS(NDIM).NE.1) THEN
          IERR = 1
          TXTERR = 'Only 1-dimensional smooth histograms' //
     +     ' can be used as functions'
          CALL MN_ERR('M_FHSMO',TXTERR)
          GOTO 9000
      ELSEIF(NPNT.GT.MHPTMX) THEN
          IERR = 1
          WRITE(TXTERR,'(''I can only handle upto'',I4,'' bins''
     +     ,'' for smooth histograms used as functions'')') MHPTMX
          CALL MN_ERR('M_FHSMO',TXTERR)
          GOTO 9000
      ENDIF
C
C     Find the element to store the spline results
C
      NHS = NINT(XFXPAR(4,NF))
      IF(NHS.LE.0 .OR. NHS.GT.MHSMMX) THEN
          DO I=1,MHSMMX
              IF(IHSMOO(I).EQ.0) THEN
                  NHS = I
                  GOTO 2000
              ENDIF
          ENDDO
          IERR = 2
          TXTERR = 'No more space available for smooth histograms' //
     +     ' used as functions'
          CALL MN_ERR('M_FHSMO',TXTERR)
          GOTO 9000
 2000     CONTINUE
      ENDIF
C
C     Get the data in the form I need
C
      DO I=1,NPNT
          XHSMOO(I-1,NHS) = DBLE(AMNX(I,NH,IERR))
          WY(I-1,1)       = DBLE(AMNE(I,NH,IERR))
      ENDDO
C
C     Calculate the spline curves
C
      MODE = 0
      CALL DCSPLN(NPNT-1,XHSMOO(0,NHS),MV,WY,MHPTMX,MODE
     + ,AHSMOO(1,NHS),BHSMOO(1,NHS),CHSMOO(1,NHS),DHSMOO(1,NHS))
C
      XFXPAR(4,NF) = FLOAT(NHS)
      IHSMOO(NHS)  = 1
      IHPSMO(NHS)  = NPNT - 1
C
 9000 CONTINUE
      END
