# -------------------------------------------------------------------------
#     Copyright (C) 2005-2011 Martin Strohalm <www.mmass.org>

#     This program is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 3 of the License, or
#     (at your option) any later version.

#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
#     GNU General Public License for more details.

#     Complete text of GNU GPL can be found in the file LICENSE.TXT in the
#     main directory of the program
# -------------------------------------------------------------------------

# load libs
import random
import wx

# register essential objects
import mspy
import canvas
import objects


# SIMPLE PLOT CANVAS APP TO SHOW DATA PREVIEW
# -------------------------------------------

def viewer(data=[], **attr):
    """Show plot canvas as a small app."""
    
    app = wx.App(0)
    viewerFrame(None, data=data, **attr)
    app.MainLoop()
# ----


class viewerFrame(wx.Frame):
    """Main plot viewer frame."""
    
    def __init__(self, parent, data=[], **attr):
        wx.Frame.__init__(self, parent, -1, "Plot Viewer")
        
        colours=[
            [16,71,185],
            [50,140,0],
            [241,144,0],
            [76,199,197],
            [143,143,21],
            [38,122,255],
            [38,143,73],
            [237,187,0],
            [120,109,255],
            [179,78,0],
        ]
        
        # init plot canvas
        self.plotCanvas = canvas.canvas(self, size=(600,300), \
            xLabel='m/z', \
            yLabel='a.i.', \
            showPosBar=True, \
            showIntBar=True, \
            posBarHeight=6, \
            intBarHeight=6, \
        )
        self.plotCanvas.setProperties(**attr)
        self.plotCanvas.setMFunction('cross')
        self.plotCanvas.setLMBFunction('xDistance')
        
        # init plot conatiner
        self.container = objects.container([])
        
        # append data sets
        for x, item in enumerate(data):
            if isinstance(item, mspy.scan):
                obj = objects.spectrum(item)
            else:
                obj = objects.points(item)
            
            obj.setProperties(pointColour=colours[x % 10], lineColour=colours[x % 10])
            obj.setProperties(**attr)
            self.container.append(obj)
        
        # draw data
        self.plotCanvas.draw(self.container)
        
        # fit layout
        sizer = wx.BoxSizer(wx.VERTICAL)
        sizer.Add(self.plotCanvas, 1, wx.EXPAND)
        sizer.Fit(self)
        self.SetSizer(sizer)
        self.SetMinSize(self.GetSize())
        self.Centre(wx.BOTH)
        self.Show()
    # ----
    

