# -------------------------------------------------------------------------
#     This file is part of mMass - the spectrum analysis tool for MS.
#     Copyright (C) 2005-07 Martin Strohalm <mmass@biographics.cz>

#     This program is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 2 of the License, or
#     (at your option) any later version.

#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.

#     Complete text of GNU GPL can be found in the file LICENSE in the
#     main directory of the program
# -------------------------------------------------------------------------

# Function: Menu and toolbar items hotkeys.


# import modules
from ids import *

hotkeys = {}

# file
hotkeys[ID_fileNew] = 'Ctrl+N'
hotkeys[ID_fileOpen] = 'Ctrl+O'
hotkeys[ID_fileSave] = 'Ctrl+S'
hotkeys[ID_fileSaveAs] = 'Ctrl+Shift+S'
hotkeys[ID_fileRecentFiles0] = ''
hotkeys[ID_fileRecentFiles1] = ''
hotkeys[ID_fileRecentFiles2] = ''
hotkeys[ID_fileRecentFiles3] = ''
hotkeys[ID_fileRecentFiles4] = ''
hotkeys[ID_fileRecentFiles5] = ''
hotkeys[ID_fileRecentFiles6] = ''
hotkeys[ID_fileRecentFiles7] = ''
hotkeys[ID_fileRecentFiles8] = ''
hotkeys[ID_fileRecentFiles9] = ''
hotkeys[ID_filePrintSpectrum] = 'Ctrl+P'
hotkeys[ID_filePrintReport] = 'Ctrl+Shift+P'
hotkeys[ID_filePageSetup] = ''
hotkeys[ID_fileImportPeaklist] = ''
hotkeys[ID_fileImportSequence] = ''
hotkeys[ID_fileExportSpectrumData] = ''
hotkeys[ID_fileExportSpectrumImage] = ''
hotkeys[ID_fileExportPeaklist] = ''
hotkeys[ID_fileInfo] = 'Ctrl+I'
hotkeys[ID_fileClose] = 'Ctrl+W'
hotkeys[ID_fileExit] = 'Ctrl+Q'

# peaklist
hotkeys[ID_peaklistUndo] = 'Ctrl+Z'
hotkeys[ID_peaklistRedo] = 'Shift+Ctrl+Z'
hotkeys[ID_peaklistAddPeak] = 'Shift+Ctrl+A'
hotkeys[ID_peaklistClearAllAnnots] = 'Shift+Ctrl+D'
hotkeys[ID_peaklistDeleteAllPeaks] = 'Shift+Ctrl+E'
hotkeys[ID_peaklistSelectAllPeaks] = ''
hotkeys[ID_peaklistSelectAnnotatedPeaks] = ''
hotkeys[ID_peaklistSelectByTreshold] = ''
hotkeys[ID_peaklistInvertSelection] = ''
hotkeys[ID_peaklistCopyToClipboard] = 'Shift+Ctrl+C'
hotkeys[ID_peaklistRefresh] = ''

# spectrum
hotkeys[ID_spectrumLabelPoint] = 'Alt+Q'
hotkeys[ID_spectrumLabelPeak] = 'Alt+W'
hotkeys[ID_spectrumDeleteLabel] = 'Alt+E'
hotkeys[ID_spectrumMeasureDistance] = 'Alt+D'
hotkeys[ID_spectrumAddToCompare] = 'Alt+A'
hotkeys[ID_spectrumCopyToClipboard] = 'Alt+C'
hotkeys[ID_spectrumSetRange] = ''
hotkeys[ID_spectrumViewOptions] = 'Alt+S'
hotkeys[ID_spectrumRefresh] = ''

# processing
hotkeys[ID_processingUndo] = 'Alt+Z'
hotkeys[ID_processingInternalCalibration] = ''
hotkeys[ID_processingStatisticalCalibration] = ''
hotkeys[ID_processingBaseline] = ''
hotkeys[ID_processingSmooth] = ''
hotkeys[ID_processingCrop] = ''

# matching
hotkeys[ID_matchingMatchData] = 'Ctrl+E'
hotkeys[ID_matchingMatchInfo] = 'Ctrl+F'
hotkeys[ID_matchingAnnotate] = 'Ctrl+T'

# sequence
hotkeys[ID_sequenceEditMod] = ''
hotkeys[ID_sequenceInfo] = ''
hotkeys[ID_sequenceHighlight] = ''
hotkeys[ID_sequenceSearchMass] = ''
hotkeys[ID_sequenceSearchSeq] = ''

# tools
hotkeys[ID_toolsMSpec] = 'F3'
hotkeys[ID_toolsMSeq] = 'F4'
hotkeys[ID_toolsMCut] = 'F5'
hotkeys[ID_toolsMFrag] = 'F6'
hotkeys[ID_toolsMDiff] = 'F7'
hotkeys[ID_toolsMComp] = 'F8'
hotkeys[ID_toolsMMascotPMF] = ''
hotkeys[ID_toolsMMascotSeq] = ''
hotkeys[ID_toolsMMascotMSMS] = ''
hotkeys[ID_toolsMConv] = ''

# links
hotkeys[ID_linksMatrixScience] = ''
hotkeys[ID_linksProspector] = ''
hotkeys[ID_linksExpasy] = ''
hotkeys[ID_linksModifs] = ''
hotkeys[ID_linksUniMod] = ''
hotkeys[ID_linksDeltaMass] = ''
hotkeys[ID_linksUniProt] = ''
hotkeys[ID_linksEMBLEBI] = ''
hotkeys[ID_linksPIR] = ''
hotkeys[ID_linksNCBI] = ''
hotkeys[ID_linksBLAST] = ''
hotkeys[ID_linksClustalW] = ''
hotkeys[ID_linksFASTA] = ''
hotkeys[ID_linksMUSCLE] = ''
hotkeys[ID_linksPDB] = ''
hotkeys[ID_linksSearchXLinks] = ''

# config
hotkeys[ID_configMonoisotopic] = ''
hotkeys[ID_configAverage] = ''
hotkeys[ID_configTolerance] = ''
hotkeys[ID_configShowPeaklist] = 'F2'
hotkeys[ID_configPeaklistBottom] = 'Alt+F2'
hotkeys[ID_configModifications] = ''
hotkeys[ID_configPreferences] = 'F12'

if wx.Platform == '__WXMAC__':
    hotkeys[ID_configPreferences] = 'Ctrl+,'

# help
hotkeys[ID_helpUpdate] = ''
hotkeys[ID_helpHomepage] = ''
hotkeys[ID_helpAbout] = 'F1'


# add tab
for item in hotkeys:
    if hotkeys[item] != '':
        hotkeys[item] = '\t' + hotkeys[item]
