
;;; file:pao_term.scm

(display"

Begin of pao_term.scm

")



(add-alg "ord" '("ø" "ord") '("OP" "ord=>ord=>ord"))
(display-constructors "ord")

(display"

We define the algebra ord of Ordinals
as follows:

O ,   α,β  ->  ω^α + β

So we have:

    O : ø
    1 : OP NULL NULL
    2 : OP NULL (OP NULL NULL)
  n+1 : OP NULL n

   ω  : OP (OP NULL NULL) NULL
  ω+1 : OP (OP NULL NULL) (OP NULL NULL)
1+ω+1 : OP NULL (OP (OP NULL NULL) (OP NULL NULL))
  1+α : OP NULL α

")


(begin
(display"
We introduce ω-multiplication:
")

(add-program-constant
 "ω⋆"
 (mk-arrow (make-alg "ord")(make-alg "ord"))
 1 'const 1)

(add-computation-rule (pt "ω⋆ ø")(pt "ø"))
(add-computation-rule (pt "ω⋆(OP ord1 ord2)")(pt "OP (OP ø ord1) (ω⋆ord2)"))

(display-program-constants "ω⋆")
)





(begin
(display"
We introduce ω-exponentiation:
")

(add-program-constant
 "ω^"
 (mk-arrow (make-alg "ord")(make-alg "ord"))
 1 'const 1)

(add-computation-rule (pt "ω^ ord")(pt "OP ord ø"))

(display-program-constants "ω^")
)


; nat    :  natural
; ford   :  finite ordinal
; inford :  infinite ordinal






(display"
We introduce some ordinal constants
")


(add-token
 "①"
 'const
 (pt "OP ø ø"))


(add-token
 "②"
 'const
 (pt "OP ø ①"))


(add-token
 "③"
 'const
 (pt "OP ø ②"))


(add-token
 "④"
 'const
 (pt "OP ø ③"))


(add-token
 "⑤"
 'const
 (pt "OP ø ④"))


(add-token
 "⑥"
 'const
 (pt "OP ø ⑤"))


(add-token
 "⑦"
 'const
 (pt "OP ø ⑥"))


(add-token
 "⑧"
 'const
 (pt "OP ø ⑦"))


(add-token
 "⑨"
 'const
 (pt "OP ø ⑧"))


(add-token
 "⑩"
 'const
 (pt "OP ø ⑨"))


(add-token
 "⑪"
 'const
 (pt "OP ø ⑩"))


(add-token
 "⑫"
 'const
 (pt "OP ø ⑪"))


(add-token
 "⑬"
 'const
 (pt "OP ø ⑫"))


(add-token
 "⑭"
 'const
 (pt "OP ø ⑬"))


(add-token
 "⑮"
 'const
 (pt "OP ø ⑭"))


(add-token
 "ω"
 'const
 (pt "OP ① ø"))


(add-token
 "ω²"
 'const
 (pt "OP ② ø"))


(add-token
 "ω³"
 'const
 (pt "OP ③ ø"))


(add-token
 "ω⁴"
 'const
 (pt "OP ④ ø"))


(add-token
 "ω⁵"
 'const
 (pt "OP ⑤ ø"))


(add-token
 "ω⁶"
 'const
 (pt "OP ⑥ ø"))


(add-token
 "ω⁷"
 'const
 (pt "OP ⑦ ø"))


(add-token
 "ω⁸"
 'const
 (pt "OP ⑧ ø"))


(add-token
 "ω⁹"
 'const
 (pt "OP ⑨ ø"))


(add-token
 "ω₂"
 'const
 (pt "OP ω ø"))


(add-token
 "ω₃"
 'const
 (pt "OP ω₂ ø"))


(add-token
 "ω₄"
 'const
 (pt "OP ω₃ ø"))


(add-token
 "ω₅"
 'const
 (pt "OP ω₄ ø"))


(add-token
 "ω₆"
 'const
 (pt "OP ω₅ ø"))


(add-token
 "ω₇"
 'const
 (pt "OP ω₆ ø"))


(add-token
 "ω₈"
 'const
 (pt "OP ω₇ ø"))


(add-token
 "ω₉"
 'const
 (pt "OP ω₈ ø"))


(add-display
 (py "ord")
 (lambda (x)
   (cond ((equal? x (pt "ø"))(list 'const "ø"))
         ((equal? x (pt "OP ø ø"))(list 'const "①"))
         ((equal? x (pt "OP ø ①"))(list 'const "②"))
         ((equal? x (pt "OP ø ②"))(list 'const "③"))
         ((equal? x (pt "OP ø ③"))(list 'const "④"))
         ((equal? x (pt "OP ø ④"))(list 'const "⑤"))
         ((equal? x (pt "OP ø ⑤"))(list 'const "⑥"))
         ((equal? x (pt "OP ø ⑥"))(list 'const "⑦"))
         ((equal? x (pt "OP ø ⑦"))(list 'const "⑧"))
         ((equal? x (pt "OP ø ⑧"))(list 'const "⑨"))
         ((equal? x (pt "OP ø ⑨"))(list 'const "⑩"))
         ((equal? x (pt "OP ø ⑩"))(list 'const "⑪"))
         ((equal? x (pt "OP ø ⑪"))(list 'const "⑫"))
         ((equal? x (pt "OP ø ⑫"))(list 'const "⑬"))
         ((equal? x (pt "OP ø ⑬"))(list 'const "⑭"))
         ((equal? x (pt "OP ø ⑭"))(list 'const "⑮"))
         ((equal? x (pt "OP ① ø"))(list 'const "ω"))
         ((equal? x (pt "OP ② ø"))(list 'const "ω²"))
         ((equal? x (pt "OP ③ ø"))(list 'const "ω³"))
         ((equal? x (pt "OP ④ ø"))(list 'const "ω⁴"))
         ((equal? x (pt "OP ⑤ ø"))(list 'const "ω⁵"))
         ((equal? x (pt "OP ⑥ ø"))(list 'const "ω⁶"))
         ((equal? x (pt "OP ⑦ ø"))(list 'const "ω⁷"))
         ((equal? x (pt "OP ⑧ ø"))(list 'const "ω⁸"))
         ((equal? x (pt "OP ⑨ ø"))(list 'const "ω⁹"))
         ((equal? x (pt "OP ω ø"))(list 'const "ω₂"))
         ((equal? x (pt "OP ω₂ ø"))(list 'const "ω₃"))
         ((equal? x (pt "OP ω₃ ø"))(list 'const "ω₄"))
         ((equal? x (pt "OP ω₄ ø"))(list 'const "ω₅"))
         ((equal? x (pt "OP ω₅ ø"))(list 'const "ω₆"))
         ((equal? x (pt "OP ω₆ ø"))(list 'const "ω₇"))
         ((equal? x (pt "OP ω₇ ø"))(list 'const "ω₈"))
         ((equal? x (pt "OP ω₈ ø"))(list 'const "ω₉"))
         (else #f))))


(begin
(display "
ø\t\t\t\t") (pp (pt "ø"))
(display "OP ø ø\t\t\t\t")(pp (pt "OP ø ø"))
(display "OP ø ①\t\t\t\t")(pp (pt "OP ø ①"))
(display "OP ø ⑭\t\t\t\t")(pp (pt "OP ø ⑭"))
(display "OP ① ø\t\t\t\t")(pp (pt "OP ① ø"))
(display "OP ② ø\t\t\t\t")(pp (pt "OP ② ø"))
(display "OP ⑨ ø\t\t\t\t")(pp (pt "OP ⑨ ø"))
(display "ω\t\t\t\t")(pp (pt "ω"))
(display "OP ω ø\t\t\t\t")(pp (pt "OP ω ø"))
(display "OP ω₈ ø\t\t\t\t")(pp (pt "OP ω₈ ø"))
)






(display"

In order to test extracted programmes
we define the functions

(test-extracted-unary THM)

(test-extracted-binary THM)

")


(define (test-extracted-unary THM)
  (begin
(deanimate "BooleOr2")
(animate "BooleOr2")
(deanimate THM)
; (show-output)
(set! COMMENT-FLAG #t)
(newline)
(newline)
(animate THM)
(display (string-append "

Test of  extracted function
c" THM "

"))
(display"ø             ")(pnt (string-append "c" THM "ø"))
(display"①            ")(pnt (string-append "c" THM "①"))
(display"⑭            ")(pnt (string-append "c" THM "⑭"))
(display"ω⁶            ")(pnt (string-append "c" THM "ω⁶"))
(display"OP ω⁷ ②      ")(pnt (string-append "c" THM "(OP ω⁷ ②)"))
(display"OP ② ω⁷      ")(pnt (string-append "c" THM "(OP ② ω⁷)"))
(display"ω₇            ")(pnt (string-append "c" THM "ω₇"))
(display"OP ω₉ ⑧      ")(pnt (string-append "c" THM "(OP ω₉ ⑧)"))
(display"OP ⑧ ω₉      ")(pnt (string-append "c" THM "(OP ⑧ ω₉)"))
(newline)
(set! COMMENT-FLAG #f)
; (hide-output)
(deanimate THM)
(deanimate "BooleOr2")
))



(define (test-extracted-binary THM)
(deanimate "BooleOr2")
(animate "BooleOr2")
(deanimate THM)
; (show-output)
(set! COMMENT-FLAG #t)
(newline)
(newline)
(animate THM)
  (begin
    (display (string-append "
Test of extracted function
 c" THM "

"))
(display"ø             ø            ") (pnt (string-append "c" THM "ø ø"))
(display"ø             ①           ")(pnt (string-append "c" THM "ø ①"))
(display"①            ø            ")(pnt (string-append "c" THM "① ø"))
(display"①            ⑭           ")(pnt (string-append "c" THM "① ⑭"))
(display"ω₇            ω₇           ")(pnt (string-append "c" THM "ω₇ ω₇"))
(display"ω₅            ω₇           ")(pnt (string-append "c" THM "ω₅ ω₇"))
(display"ω₇            ω₅           ")(pnt (string-append "c" THM "ω₇ ω₅"))
(display"ω⁶            ω⁶           ")(pnt (string-append "c" THM "ω⁶ ω⁶"))
(display"ω⁶            ω₉           ")(pnt (string-append "c" THM "ω⁶ ω₉"))
(display"ω⁹            ω₆           ")(pnt (string-append "c" THM "ω⁹ ω₆"))
(display"OP ⑨ ⑩      OP ⑨ ⑩     ")(pnt (string-append "c" THM "(OP ⑨ ⑩) (OP ⑨ ⑩)"))
(display"OP ⑨ ⑩      ⑨           ")(pnt  (string-append "c" THM "(OP ⑨ ⑩) ⑨"))
(display"⑨            OP ⑨ ⑩     ")(pnt  (string-append "c" THM "⑨ (OP ⑨ ⑩)"))
(newline)
; (hide-output)
(set! COMMENT-FLAG #f)
(deanimate THM)
(deanimate "BooleOr2")
))




(set! COMMENT-FLAG #f)



(display"

Some ordinal term properties:

")

; (hide-output)


(time(begin

; eqsym: (α=β) = (β=α)

(set-goal(pf"(ord1=ord2) = (ord2=ord1)"))
(ca "all ord1,ord2.(ord1=ord2) -> (ord2=ord1)" "->")
(assume "ord1" "ord2")
(cd "ord1=ord2" "1=2")
  (simp "<-" "1=2")
  (use "Truth-Axiom")
(assume "1≠2")
(cut(pf"ord2=ord1->F"))
(cases(pt"ord2=ord1"))
(auto)
(assume "ord1" "ord2")
(assume "1=2")
(simp "1=2")
(use "Truth-Axiom")

; ok, ?_3 is proved by minimal quantifier logic.  Proof finished.

(save "eqsym")
(display-theorems "eqsym")




; THM: OPinjective

(sg "OP ord1 ord2 = OP ord3 ord4 -> (ord1=ord3 & ord2=ord4)")
(assume "ord1" "ord2" "ord3" "ord4")
(ng)
(casedist(pt"ord1=ord3"))
(casedist(pt"ord2=ord4"))
(search)
(search)
(ng)
(casedist(pt"ord2=ord4"))
(search)
(search)

; ok, ?_10 is proved by minimal quantifier logic.  Proof finished.

(save "OPinjective")
(display-theorems "OPinjective")



; noOPleftFixedPoint

(sg "¬(OP ord0 ord1 = ord0)")
(ind); ord0
       (cases); ord1
       (auto)
(assume "ord2" "ord4" "IH2" "IH4" "ord1")
(drop "IH4")
(ng)
(simp "IH2")
(auto)

; Proof finished.

(save"noOPleftFixedPoint")
(display-theorems"noOPleftFixedPoint")



; noOPrightFixedPoint

(sg "all ord0.¬(OP ord0 ord1 = ord1)")
(ind); ord1
     (search)
(assume "ord3" "ord5" "IH3" "IH5" "ord0")
(drop "IH3")
(ng)
(simp "IH5")
(auto)

; Proof finished.

(save"noOPrightFixedPoint")
(display-theorems"noOPrightFixedPoint")

))



(display"

Comp: α=ø ∨ (∃ξ₁,ξ₂) α=OP ξ₁ ξ₂

PROOF:
")

(begin
(sg "all ord.  ord= ø ∨ ex ord0,ord1. ord=OP ord0 ord1")
(cases)
  (ex-intro (pt "F"))
  (split)
  (search)
  (assume "F")
  (ex-intro (pt "ø"))
  (ex-intro (pt "ø"))
  (search)
(assume "ord2" "ord3")
(ex-intro (pt "T"))
(split)
(search)
(assume "T")
(ex-intro (pt"ord2"))
(ex-intro (pt"ord3"))
(search)
)

; Proof finished.

(save "Comp")
(display-theorems "Comp")

(add-theorem "CompSoundness"
	     (np(proof-to-soundness-proof 
		 (theorem-name-to-proof "Comp"))))
(display-theorems "CompSoundness")

(test-extracted-unary "Comp")



(animate "Comp")

(display"

NonZeroConstructed:
α≠ø -> α = OP leftright (cComp α) rightright (cComp α)

PROOF:
")

(begin

(sg "¬(ord= ø) -> ord=OP (left right (cComp ord)) (right right (cComp ord))")
(assume "ord")
(cut(pf"(¬¬(ord= ø)) ∨ ord=OP left right(cComp ord)right right(cComp ord)"))
(use-with "BooleNotor2imp"
	  (py "ord")
	  (make-cterm (pv "ord")
		      (pf "ord=OP (left right (cComp ord)) (right right (cComp ord))"))
	   (pt "¬(ord= ø)")(pt "ord"))
(cut(pf "((ord= ø ∨ ord=OP left right(cComp ord)right right(cComp ord)))"))
(assume "with=")
(exel "with=" "boole" "with=2")
(ex-intro (pt "boole"))
(split)
(assume "boole=F")
(simp "with=2")
(use "Truth-Axiom")
(use "boole=F")
(use "with=2")
(ex-intro(pt "left(cComp ord)"))
(use "CompSoundness")

; Proof finished.

(save "NonZeroConstructed")
(deanimate "Comp")
(display-theorems "NonZeroConstructed")
)




(display "

FINITE ORDINALS


We define inductively the prediacte FORD ⊆ pos@ord
for finite ordinal.

")


(add-ids
  (list (list "FORD" (make-arity (py "pos") (py "ord"))))
  '("FORD 1 ①")
  '("allnc pos,ord.FORD pos ord -> FORD (pos+1) (OP ø ord)"))



(sg "FORD pos ord -> pos=1 -> ord= ①")
(begin
(assume "pos" "ord")
(elim)
  (auto)
(strip 4)
(simp "posOneNonSuc")
(use "Efq-Atom")
; Proof finished.
)
(save "FORD1")
(display-theorems "FORD1")





(display"

We extract an embedding of pos -> ord:

")

(sg "ex ord.FORD pos ord")

(begin
(assume "pos")
(cut(pf"all pos.ex ord FORD pos ord -> ex ord FORD(pos +1)ord"))
(cut(pf"ex ord FORD 1 ord"))
(use-with "posuposInd" (make-cterm (pv "pos") (pf "ex ord FORD pos ord")) (pt "pos"))
(ex-intro(pt"①"))
(intro 0)
(assume "pos1" "IH")
(by-assume-with "IH" "ord1" "IH1")
(ex-intro(pt"OP ø ord1"))
(intro 1)
(use "IH1")
; Proof finished.
)
(save "FO")
(display-theorems "FO")

(animate-posuposind)
;(add-theorem "FO_Soundness"
;	     (np(proof-to-soundness-proof 
;		 (theorem-name-to-proof "FO"))))
(deanimate-posuposind)
;(display-theorems "FO_Soundness")







(begin
(animate-posuposind)
(deanimate "FO")
(animate "FO")
; (show-output)
(display"

Test of cFO:

")
(display "cFO  1   ")
     (pnt"cFO  1   ")
(display "cFO  8   ")
     (pnt"cFO  8   ")
(display "cFO 13   ")
     (pnt"cFO 13   ")
(display "cFO 42   ")
     (pnt"cFO 42   ")
(newline)
; (hide-output)
(deanimate-posuposind)
(deanimate "FO")
)





(animate-posuposind)
(deanimate "posMAX")
(animate "posMAX")
(deanimate "FO")
(animate "FO")


(sg "cFO 1 = ①")
(use "Truth-Axiom")
; Proof finished.
(save "FOone")
(deanimate "posMAX")
(display-theorems "FOone")






(deanimate "Upostopossurjective")
(animate "Upostopossurjective")
(display"
cFO (pos+1)=OP ø (cFO pos)

PROOF:
")
(sg "cFO (pos+1)=OP ø (cFO pos)")

(begin
  (assume "pos")
  (ng #t)
  (simp "UpostoposPreimg")
  (simp "UpostoposPreimg")
  (use "Truth-Axiom")
)
;  Proof finished.

(save "FOplusOne")
(deanimate-posuposind)
(deanimate "FO")
(deanimate "Upostopossurjective")
(display-theorems "FOplusOne")






; (show-output)

(set! COMMENT-FLAG #t)

(display "

End of pao_term.scm
")

;EOF
