; $Id: fib.scm,v 1.11 2006/12/12 16:11:38 schimans Exp $

; Extraction of the Fibonacci algorithm from a classical proof
; based on [BBS02]

; We need some arithmetic first.

(libload "nat.scm")
(add-var-name "l" (py "nat"))
(add-var-name "f" (py "nat=>nat=>nat"))
(add-var-name "H" (py "(nat=>nat=>nat)=>nat"))

; The graph of the Fibonacci function:

(add-predconst-name "G" (make-arity (make-alg "nat") (make-alg "nat")))

; all n excl k G n k

(set-goal (pf "all n.G 0 0 -> G 1 1 -> 
                     (all n,k,l.G n k -> G (n+1) l -> G (n+2) (k+l)) -> 
                     excl k G n k"))
(assume "n" "Init-Zero" "Init-One" "Step")

(cut (pf "all n excl k,l.G n k ! G (n+1) l"))
(search)
(ind)
(search)
(assume "n1" 4 5)
(search 1)

(define nproof (np (current-proof)))
; (dp nproof)

(mload "../modules/atr.scm")

(define structured-eterm
  (atr-min-excl-proof-to-structured-extracted-term nproof))

(term-to-string structured-eterm)

; [n]([n325,(nat=>nat)_337]
;     (Rec nat=>(nat=>nat=>nat)=>nat)
;     ([f334]f334 0 1)
;     ([n327,H335,f336]H335
;      ([k328,l329]f336 l329(k328+l329)))
;     n325([k330,l331](nat=>nat)_337 k330))n
; ([k]([n323]n323)(([k]k)k))"

---------------------------------------------------------------------- 



(term-to-string (nt structured-eterm))

; [n0](Rec nat=>(nat=>nat=>nat)=>nat)
;     ([f1]f1 0 1)
;     ([n1,H2,f3]
;      H2([n4,n5]f3 n5(n4+n5)))
;     n0([n1,n2]n1)

(term-to-expr (nt structured-eterm))

; (lambda (n0)
;   ((((|(Rec nat=>(nat=>nat=>nat)=>nat)|
;        (lambda (f1) ((f1 "0") "1")))
;      (lambda (n1)
;        (lambda (|H2|)
;          (lambda (f3)
;            (|H2| (lambda (n4) (lambda (n5) ((f3 n5) (n4 "+" n5)))))))))
;     n0)
;    (lambda (n1) (lambda (n2) n1))))

(define nseterm (nt structured-eterm))

(term-to-string (nt (make-term-in-app-form nseterm (pt "0")))) ;"0"
(term-to-string (nt (make-term-in-app-form nseterm (pt "1")))) ;"1"
(term-to-string (nt (make-term-in-app-form nseterm (pt "2")))) ;"1"
(term-to-string (nt (make-term-in-app-form nseterm (pt "3")))) ;"2"
(term-to-string (nt (make-term-in-app-form nseterm (pt "4")))) ;"3"
(term-to-string (nt (make-term-in-app-form nseterm (pt "8")))) ;"21"
(term-to-string (nt (make-term-in-app-form nseterm (pt "10")))) ;"55"
(term-to-string (nt (make-term-in-app-form nseterm (pt "12")))) ;"144"

(define (fibo n)
  (fibo1 n (lambda (k l) k)))

(define (fibo1 n1 f)
  (if (= n1 0)
      (f 1 1)
      (fibo1 (- n1 1) (lambda (k l) (f l (+ k l)))))) 

; (define test (fibo 80000))


;Local Variables:
;mode: scheme
;End:
