/*******************************************************************************
 * Copyright (C) 2004-2007 Intel Corp. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *   - Redistributions of source code must retain the above copyright notice,
 *     this list of conditions and the following disclaimer.
 * 
 *   - Redistributions in binary form must reproduce the above copyright notice,
 *     this list of conditions and the following disclaimer in the documentation
 *     and/or other materials provided with the distribution.
 * 
 *   - Neither the name of Intel Corp. nor the names of its
 *     contributors may be used to endorse or promote products derived from this
 *     software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL Intel Corp. OR THE CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *******************************************************************************/

#ifndef __AT2_CHECK_CONFIG__
#define __AT2_CHECK_CONFIG__

#include <string>
#include <fstream>

//*******************************************************************************
//
// Class:	    CATCheckConfig
//
// Description:	    This class holds configuration data for the MEStatus application.
//                  There are two configuration files - a "Machine Config" file and
//                  a "User Config" file. Machine Config is general for the machine,
//                  and User Config is user-specific.
//                  If a configuration file is not found, or the file is found but 
//                  missing some parameters, defaults will be used.
//                  
//********************************************************************************
class CATCheckConfig
{
public:
	//ctor
	CATCheckConfig();
	
	//dtor
	virtual ~CATCheckConfig();

	//init(): Load the configuration from configuration files.
	//Returns true on success, false if either of the files could not be opened (in which
	//case the defaults will be used).
	bool Init();
	//SaveUserConfig(): Save the user configuration to the user config file.
	//Returns true on success, false otherwise.
	bool SaveUserConfig();

	//Properties
	unsigned long CheckAMTStatusTimeout() const;
	bool MinimizeAtStart() const;
	bool PopupForCurrentUser() const;
	bool AMTLastEnabled() const;
	std::string GetOemUrl() const;
	std::string GetDefaultOemUrl() const;
	unsigned long AMTStatusInitMaxRetries() const;

	//Modifiers
	bool SetPopupForCurrentUser(bool bPopup);
	bool SetAMTLastEnabled(bool bEnabled);

private:
	void LoadDefaults();
	void LoadMachineConfig(std::ifstream &input);
	void LoadUserConfig(std::ifstream &input);

	//Configuration file names
	std::string m_MachineConfigFileName;
	std::string m_UserConfigFileName;

	//Constants for configuration parameters names
	static const std::string		CHECK_AMT_STATUS_TIMEOUT;
	static const std::string		OEM_URL;
	static const std::string		AMT_STATUS_INIT_MAX_RETRIES;
	static const std::string		MINIMIZE_AT_START;

	//User-specific params:
	static const std::string		POPUP_FOR_CURRENT_USER; 
	static const std::string		AMT_LAST_ENABLED;

	//Default values for configuration parameters
	static const unsigned long	DEFAULT_CHECK_AMT_STATUS_TIMEOUT;
	static const std::string	DEFAULT_OEM_URL;
	static const unsigned long	DEFAULT_AMT_STATUS_INIT_MAX_RETRIES;
	static const bool			DEFAULT_MINIMIZE_AT_START;

	//User-specific params:
	static const bool			DEFAULT_POPUP_FOR_CURRENT_USER;
	static const bool			DEFAULT_AMT_LAST_ENABLED;

	//Constants for configuration file names
	static const std::string MACHINE_CFG_FILENAME;
	static const std::string USER_CFG_FILENAME;

	// Configuration state members
	unsigned long m_nCheckAMTStatusTimeout;
	std::string m_OemUrl;
	unsigned long m_nAMTStatusInitMaxRetries;
	bool m_bMinimizeAtStart;

	//User-specific params:
	bool m_bPopupForCurrentUser;
	bool m_bAMTLastEnabled;	
};




#endif //__AT2_CHECK_CONFIG__
