/*******************************************************************************
 * Copyright (C) 2004-2007 Intel Corp. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *   - Redistributions of source code must retain the above copyright notice,
 *     this list of conditions and the following disclaimer.
 * 
 *   - Redistributions in binary form must reproduce the above copyright notice,
 *     this list of conditions and the following disclaimer in the documentation
 *     and/or other materials provided with the distribution.
 * 
 *   - Neither the name of Intel Corp. nor the names of its
 *     contributors may be used to endorse or promote products derived from this
 *     software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL Intel Corp. OR THE CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *******************************************************************************/

#ifndef _AMT_STATUS_STATE_MACHINE_H
#define _AMT_STATUS_STATE_MACHINE_H

#include "atchkConfig.h"
#include "IPCAMTStatus.h"
#include "IMEGuiCommands.h"

class IMEGuiNotifications;


//*******************************************************************************
//
// Class:	    AMTStatusStateMachine
//
// Description:	    This class handles all the logic of the MEStatus application,
//                  and it communicates with the outside world through two interfaces:
//                  IMEGuiCommands, which it inherits from, and IMEGuiCommands, which
//                  it points to. The idea is for the user of this class to treat it 
//                  as an IMEGuiCommands object. The user would pass it a pointer to an
//                  IMEGuiNotifications object which would receive notifications that 
//                  are caused by activating commands from IMEGuiCommands.
//
//********************************************************************************
class AMTStatusStateMachine : public IMEGuiCommands
{
public:
  
  AMTStatusStateMachine();
  virtual ~AMTStatusStateMachine();
  //from IMEGuiCommands:
  bool Init(IMEGuiNotifications *pMENotifications);
  void SetEnablement(IPCAMTStatus::Enablement enablement);
  virtual void SetPopupForCurrentUser(bool bPopupForCurrentUser);
  virtual bool GetPopupForCurrentUser() const;
  virtual std::string GetOEMUrl() const;
  virtual std::string GetDefaultOEMUrl() const;
  virtual unsigned long GetCheckAMTStatusTimeout() const;

 protected:
  enum State {STATE_INITIAL_UNKNOWN, STATE_ENABLED, STATE_DISABLED, STATE_UNKNOWN};
  //Return internal state corresponding to AMT enablement state.
  State GetStateByEnablement(IPCAMTStatus::Enablement enablement);
  State SetEnablementOnInitialUnknownState(IPCAMTStatus::Enablement enablement);
  State SetEnablementOnEnabledState(IPCAMTStatus::Enablement enablement);
  State SetEnablementOnDisabledState(IPCAMTStatus::Enablement enablement);
  State SetEnablementOnUnknownState(IPCAMTStatus::Enablement enablement);

 private:
  State m_State;
  CATCheckConfig m_Config;
  unsigned long m_nSetEnablementCount;
  IMEGuiNotifications *m_pMEGuiNotifications;
};

#endif //_AMT_STATUS_STATE_MACHINE_H
