#---------------------------------------------------------------------------#
# Copyright (C) 1996-1999, 2001-2003 The University of Melbourne.
# This file may only be copied under the terms of the GNU General
# Public License - see the file COPYING in the Mercury distribution.
#---------------------------------------------------------------------------#
#
# bindist/bindist.Makefile.  Generated from bindist.Makefile.in by configure.
#

SHELL=		/bin/sh

INSTALL_BINDIR	= $(INSTALL_PREFIX)/bin
INSTALL_LIBDIR	= $(INSTALL_PREFIX)/lib/mercury
INSTALL_INFODIR = $(INSTALL_PREFIX)/info
INSTALL_MAN_DIR = $(INSTALL_PREFIX)/man
INSTALL_ELISP_DIR = $(INSTALL_PREFIX)/lib/mercury/elisp

# These scripts are generated by configure from the corresponding `.in' file
INSTALL_SCRIPTS		= scripts/c2init scripts/mmc \
			scripts/mercury_update_interface scripts/mgnuc \
			scripts/ml scripts/mmake scripts/mprof \
			scripts/mdb scripts/mkfifo_using_mknod \
			scripts/mercury_config scripts/Mercury.config

CGI_PROG_NAME		= mdprof_cgi

INSTALL_CGI_PROG	= cgi/$(CGI_PROG_NAME)

INSTALL_EMACS_SCRIPTS	= scripts/gud.el

INSTALL_MMAKE_EXTRAS	= scripts/Mmake.rules scripts/Mmake.vars

INSTALL_MDB_EXTRAS	= scripts/mdbrc

LIB_PARTS	= bin conf doc html inc ints lib mdb/mdb_doc modules reconf

EXT_FOR_EXE		= 

# The directory names in the installation refer to the FULLARCH
# on the machine on which the distribution was created, not the
# machine on which it is being installed.
FULLARCH		= i686-pc-linux-gnu

UTIL_PROGS		= util/mkinit util/mdemangle
UTIL_PROGFILENAMES	= $(UTIL_PROGS:%=%$(EXT_FOR_EXE))

# Any miscellaneous scripts and utilities not processed by configure
UTILS			= $(UTIL_PROGFILENAMES) util/mtags \
			  util/mprof_merge_runs util/vpath_find \
			  util/mercury_cleanup_install

#-----------------------------------------------------------------------------#

all:
	# since this is a binary distribution, we don't need to
	# make anything
	@echo "-- The binary distribution does not need building."
	@echo "-- Use \`make install' to install"

# The code of the install rule is duplicated from the toplevel Mmakefile,
# with minor changes.

.PHONY: install
install: install_lib install_info install_man \
		install_scripts install_emacs_scripts \
		install_mmake install_mdb install_util
	@echo
	@echo "-- Don't forget to add $(INSTALL_BINDIR) to your PATH,"
	@echo "-- $(INSTALL_MAN_DIR) to your MANPATH,"
	@echo "-- and $(INSTALL_INFODIR) to your INFOPATH,"
	@echo "-- and to add the following lines to the \`.emacs' file"
	@echo "-- in your home directory:"
	@echo "	(setq load-path (cons (expand-file-name "
	@echo "		\"$(INSTALL_ELISP_DIR)\") load-path))"
	@echo "	(autoload 'mdb \"gud\" \"Invoke the Mercury debugger\" t)"

.PHONY: install_lib
install_lib:
	@echo "-- Installing lib in $(INSTALL_LIBDIR)..."
	test -d $(INSTALL_LIBDIR) || mkdir -p $(INSTALL_LIBDIR)
	gzip --decompress --stdout lib.tar.gz | ( \
		cd $(INSTALL_LIBDIR) && tar -xf - $(LIB_PARTS) )
	@echo "-- Done."

.PHONY: install_info
install_info:
	@echo "-- Installing info documentation in $(INSTALL_INFODIR)..."
	test -d $(INSTALL_INFODIR) || mkdir -p $(INSTALL_INFODIR)
	gzip --decompress --stdout info.tar.gz | ( \
		cd $(INSTALL_INFODIR)/.. && tar -xf - )
	@echo "-- Done."

.PHONY: install_man
install_man:
	@echo "-- Installing man pages in $(INSTALL_MAN_DIR)..."
	test -d $(INSTALL_MAN_DIR) || mkdir -p $(INSTALL_MAN_DIR)
	# (XXX don't use redirection or pipes, because on gnu-win32
	# stdout defaults to text mode, which breaks tar and gzip)
	gzip --decompress --stdout man.tar.gz | ( \
		cd $(INSTALL_MAN_DIR)/.. && tar -xf - )
	@echo "-- Done."

.PHONY: install_scripts
install_scripts:
	@echo "-- Installing scripts in $(INSTALL_BINDIR)"
	test -d $(INSTALL_BINDIR) || mkdir -p $(INSTALL_BINDIR)
	cp $(INSTALL_SCRIPTS) $(INSTALL_BINDIR)
	for file in $(INSTALL_SCRIPTS); do \
		base=`basename $$file`; \
		chmod u+w $(INSTALL_BINDIR)/$$base ;\
	done
	@echo "-- Done."

install_emacs_scripts:
	@echo "-- Installing Emacs lisp scripts in $(INSTALL_ELISP_DIR)"
	test -d $(INSTALL_ELISP_DIR) || mkdir -p $(INSTALL_ELISP_DIR)
	cp $(INSTALL_EMACS_SCRIPTS) $(INSTALL_ELISP_DIR)

.PHONY: install_mmake
install_mmake: 
	test -d $(INSTALL_LIBDIR)/mmake || mkdir -p $(INSTALL_LIBDIR)/mmake
	cp $(INSTALL_MMAKE_EXTRAS) $(INSTALL_LIBDIR)/mmake

.PHONY: install_mdb
install_mdb: 
	test -d $(INSTALL_LIBDIR)/mdb || mkdir -p $(INSTALL_LIBDIR)/mdb
	cp $(INSTALL_MDB_EXTRAS) $(INSTALL_LIBDIR)/mdb

.PHONY: install_util
install_util: 
	test -d $(INSTALL_BINDIR) || mkdir -p $(INSTALL_BINDIR)
	cp $(UTILS) $(INSTALL_BINDIR)

#
# The following need to be run after configuration.
# INSTALL will set MMAKE_VARS to the location of the Mmake.vars
# file generated by configure.
#
ifneq ($(origin MMAKE_VARS),undefined)

# For INSTALL_PREFIX, INSTALL_CGI_DIR, GACUTIL,
# FULLARCH, ENABLE_DEEP_PROFILER.
# Most of this Makefile does not require the above variables.
# The parts that do are invoked by `make post_install', which
# is run after the installation has been reconfigured by the
# mercury_config script run by the INSTALL script.
include $(MMAKE_VARS)

.PHONY: post_install
post_install: install_cgi_progs install_gac

# The code of the install_cgi_progs target is duplicated from the code
# of the install_cgi_progs target in deep_profiler/Mmakefile. However,
# they refer to the script by different paths.

.PHONY: install_cgi_progs
install_cgi_progs:
	# $(INSTALL_CGI_DIR) is likely to be writeable only by root or
	# the www system administrator, which is why we don't consider a
	# failure of this action to be an error. If the command fails,
	# the install action in ../Mmakefile will remind the user to do
	# the copy later.
	#
	# The mv before the cp is there in case the executable is being
	# executed when we do the install. The mv is of course expected to
	# fail during a first-time installation.
	-if test $(ENABLE_DEEP_PROFILER) = yes ; then \
		mv $(INSTALL_CGI_DIR)/$(CGI_PROG_NAME) \
			$(INSTALL_CGI_DIR)/$(CGI_PROG_NAME).was ; \
		cp $(INSTALL_CGI_PROG) $(INSTALL_CGI_DIR) ; \
	fi
	@if test $(ENABLE_DEEP_PROFILER) != yes || \
		cmp -s $(INSTALL_CGI_PROG) \
			$(INSTALL_CGI_DIR)/$(CGI_PROG_NAME); \
	then true ; else \
		echo "-- Don't forget to copy $(INSTALL_CGI_PROG) to $(INSTALL_CGI_DIR),"; \
	fi

ifneq ("$(strip $(GACUTIL))","")
.PHONY: install_gac
install_gac: 
	if test -d $(INSTALL_LIBDIR)/lib/ilc/ ; then 		\
		cd $(INSTALL_LIBDIR)/lib/ilc/$(FULLARCH) &&	\
		$(GACUTIL) -i mercury.dll ; 			\
	fi
else
.PHONY: install_gac
install_gac: 
endif

endif	# $(origin MMAKE_VARS) != undefined

#-----------------------------------------------------------------------------#
