/*
 * medussa - a distributed cracking system
 * Copyright (C) 1999 Kostas Evangelinos <kos@bastard.net>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

/*
 * $Id: portscan.c,v 1.1.1.1 2002/01/22 01:27:09 kos Exp $
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/resource.h>
#include <unistd.h>

#include "common.h"
#include "portscan.h"

portscan_t *
portscan_init(char *params) {
  portscan_t *u;
  struct rlimit rm;  
  
  u = xcalloc(1, sizeof(portscan_t));
  if(getrlimit(RLIMIT_NOFILE, &rl)) {
    xfree(u);
    return (portscan_t *)NULL;
  }

  if(rl.rlim_cur != rl.rlim_max) {
    rl_rlim_cur = rl.rlim_max;
    setrlimit(RLIMIT_NOFILE, &rl);
  }
  getrlimit(RLIMIT_NOFILE, &rl);
  u->sock_limit = MIN(rl.rlimit_cur, PORTSCAN_CLAMP);
  u->results = array_init(sizeof(portscan_result_t));
  u->pool = array_init(sizeof(portscan_target_t));
  memset((void *)&u->sa, '\0', sizeof(struct sockaddr_in));

  return u;
}

int
portscan_destroy(portscan_t *u) {
  array_destroy(u->results);
  array_destroy(u->pool);
  xfree(u);
  return 0;
}

int
portscan_test(portscan_t *u, kchar *hash, int len) {
  return 0;
}

int
portscan_crypt(portscan_t *u) {
  int i;
  unsigned short *port;
  portscan_result_t result;

  if(u->sa.sin_port == INADDR_ANY)
    return 1;
  
  for(i=0; (port=array_get(u->pool, i)); i++) {
    
  }  
  return 0;
}

int
portscan_add(portscan_t *u, kchar *key, int len) {
  unsigned short port;
  unsigned char buf[4];

  if(len != 2)
    return 1;
  memset(buf, '\0', 4);
  memcpy(buf, key, 2);
  port = atoi(buf);
  array_add(u->pool, &port);
  return 0;
}

int
portscan_siz(portscan_t *u) {
  return u->sock_limit;
}

int
portscan_sethash(portscan_t *u, kchar *hash, int len) {
  struct hostent *he;
  unsigned char hostname[PORTSCAN_LINELEN];
  
  if(len > PORTSCAN_LINELEN)
    return 1;
  memset(hostname, '\0', PORTSCAN_LINELEN);
  memcpy(hostname, hash, len);

  if(!(he = gethostbyname(hostname)))
    return 2;
  u->sa.sin_addr.s_addr = ((struct in_addr *)(he->h_addr))->s_addr;
  u->sa.sin_family = AF_INET;
  u->sa.sin_port = 0;

  return 0;
}

int
portscan_setsalt(portscan_t *u, kchar *salt, int len) {
  return 0;
}

int
portscan_getkey(portscan_t *u, kchar *buf, int maxlen, int *len, int *relindex) {
  return 1;
}

method_impl_t portscan_impl = {
  "portscan",
  (meth_init)portscan_init,
  (meth_test)portscan_test,
  (meth_crypt)portscan_crypt,
  (meth_add)portscan_add,
  (meth_siz)portscan_siz,
  (meth_sethash)portscan_sethash,
  (meth_sethash)portscan_setsalt,
  (meth_getkey)portscan_getkey,
  (meth_destroy)portscan_destroy
};
