/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.plugin;

import com.fluendo.jst.Message;
import com.fluendo.plugin.AudioSink;
import com.fluendo.utils.Debug;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;

public class AudioSinkJ2
extends AudioSink {
    public static final int SEGSIZE = 8192;
    private SourceDataLine line = null;
    private int channels;
    private long samplesWritten;
    static /* synthetic */ Class class$0;

    protected AudioSink.RingBuffer createRingBuffer() {
        return new AudioSink.RingBuffer();
    }

    protected boolean open(AudioSink.RingBuffer ringBuffer) {
        this.channels = ringBuffer.channels;
        AudioFormat audioFormat = new AudioFormat(ringBuffer.rate, 16, ringBuffer.channels, true, true);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.sound.sampled.SourceDataLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DataLine.Info info = new DataLine.Info(clazz, audioFormat);
        try {
            Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
            int n = 0;
            while (n < infoArray.length) {
                Debug.log(3, "mixer description: " + infoArray[n].getDescription() + ", vendor: " + infoArray[n].getVendor());
                String string = infoArray[n].getDescription();
                String string2 = infoArray[n].getVendor();
                if ((string.indexOf("ALSA") >= 0 || string2.indexOf("ALSA") >= 0) && string.indexOf("IEC958") < 0) {
                    try {
                        Line.Info[] infoArray2 = AudioSystem.getMixer(infoArray[n]).getSourceLineInfo(info);
                        int n2 = 0;
                        while (n2 < infoArray2.length) {
                            Debug.log(3, "Mixer supports line: " + infoArray2[n2].toString());
                            AudioFormat[] audioFormatArray = ((DataLine.Info)infoArray2[n2]).getFormats();
                            int n3 = 0;
                            while (n3 < audioFormatArray.length) {
                                Debug.log(3, "Format: " + audioFormatArray[n3].toString());
                                ++n3;
                            }
                            ++n2;
                        }
                        Debug.log(3, "Attempting to get a line from ALSA mixer");
                        this.line = (SourceDataLine)AudioSystem.getMixer(infoArray[n]).getLine(info);
                        this.line.open(audioFormat);
                        break;
                    }
                    catch (Exception exception) {
                        if (this.line != null) {
                            this.line.close();
                            this.line = null;
                        }
                        Debug.log(3, "mixer: " + infoArray[n].getDescription() + " failed: " + exception);
                    }
                }
                ++n;
            }
            if (this.line == null) {
                this.line = (SourceDataLine)AudioSystem.getLine(info);
                this.line.open(audioFormat);
            }
        }
        catch (LineUnavailableException lineUnavailableException) {
            lineUnavailableException.printStackTrace();
            this.postMessage(Message.newError(this, "Could not open audio device."));
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.postMessage(Message.newError(this, "Unknown problem opening audio device"));
            return false;
        }
        Debug.log(3, "line info: available: " + this.line.available());
        Debug.log(3, "line info: buffer: " + this.line.getBufferSize());
        Debug.log(3, "line info: framePosition: " + this.line.getFramePosition());
        ringBuffer.segSize = 8192;
        ringBuffer.segTotal = this.line.getBufferSize() / ringBuffer.segSize;
        while (ringBuffer.segTotal < 4) {
            ringBuffer.segSize >>= 1;
            ringBuffer.segTotal = this.line.getBufferSize() / ringBuffer.segSize;
        }
        ringBuffer.emptySeg = new byte[ringBuffer.segSize];
        this.samplesWritten = 0L;
        this.line.start();
        return true;
    }

    protected boolean close(AudioSink.RingBuffer ringBuffer) {
        this.line.stop();
        this.line.close();
        return true;
    }

    protected int write(byte[] byArray, int n, int n2) {
        int n3 = this.line.write(byArray, n, n2);
        this.samplesWritten += (long)(n3 / (2 * this.channels));
        return n3;
    }

    protected long delay() {
        int n = this.line.getFramePosition();
        long l = this.samplesWritten - (long)n;
        return l;
    }

    protected void reset() {
        Debug.log(4, "reset audio: " + this.line);
        this.line.flush();
        this.samplesWritten = this.line.getFramePosition();
        Debug.log(4, "samples written: " + this.samplesWritten);
    }

    public String getFactoryName() {
        return "audiosinkj2";
    }
}

