/*
 *    Copyright (C) 2008
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mediathek.gui.menue;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import mediathek.Funktionen;
import mediathek.daten.Daten;
import mediathek.Konstanten;
import mediathek.gui.PanelVorlage;
import mediathek.gui.dialoge.DialogHilfe;

public class PanelEinstellungen extends PanelVorlage {

    private BeobCheckboxSender[] beobCheck;

    public PanelEinstellungen(Daten d) {
        super(d);
        initComponents();
        daten = d;
        beobCheck = new BeobCheckboxSender[daten.filmeLaden.mediathekListe.size()];
        for (int i = 0; i < daten.filmeLaden.mediathekListe.size(); ++i) {
            beobCheck[i] = new BeobCheckboxSender(i);
        }
        init();
        jSpinnerDownload.addChangeListener(new BeobSpinnerDownload());
        jCheckBoxFehler.addActionListener(new BeobCheckboxFehler());
        jCheckBoxHinweise.addActionListener(new BeobHinweise());
        jCheckBoxMax.addActionListener(new BeobCheckboxMax());
        jCheckBoxSimmulieren.addActionListener(new BeobachterSimmulieren());
        String[] theme = new String[Konstanten.THEME.length];
        for (int i = 0; i < Konstanten.THEME.length; ++i) {
            theme[i] = Konstanten.THEME[i][0];
        }
        jComboBoxLook.setModel(new DefaultComboBoxModel(theme));
        if (daten.system[Konstanten.SYSTEM_LOOK_NR].equals("")) {
            daten.system[Konstanten.SYSTEM_LOOK_NR] = "1";
        }
        jComboBoxLook.setSelectedIndex(Integer.parseInt(daten.system[Konstanten.SYSTEM_LOOK_NR]));
        jComboBoxLook.addActionListener(new BeobLook());
        jButtonHilfe.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                new DialogHilfe(null, false, "\n"
                        + "Dieser Text wird als User-Agent\n"
                        + "an den Webserver übertragen. Das enstpricht\n"
                        + "der Kennung die auch die Browser senden.").setVisible(true);
            }
        });

        jButtonStandard.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                jTextFieldUserAgent.setText(Funktionen.getStandardUserAgent());
                daten.setGeaendertOhnePanel();
            }
        });
        jTextFieldUserAgent.getDocument().addDocumentListener(new BeobUserAgent());
        jCheckBoxRtmp.addActionListener(new BeobRtmp());
//        jRadioButtonDsl1000.addActionListener(new LeitungBeobachter());
//        jRadioButtonDsl2000.addActionListener(new LeitungBeobachter());
//        jRadioButtonHD.addActionListener(new LeitungBeobachter());
    }

    @Override
    public void neuLaden() {
        init();
    }

    @Override
    public void neuLadenSofort() {
        jCheckBoxFehler.setSelected(Boolean.parseBoolean(daten.system[Konstanten.SYSTEM_FEHLER_ANZEIGEN_NR]));
        jCheckBoxHinweise.setSelected(Boolean.parseBoolean(daten.system[Konstanten.SYSTEM_HINWEIS_ANZEIGEN_NR]));
    }

    private void init() {
        jCheckBoxFehler.setSelected(Boolean.parseBoolean(daten.system[Konstanten.SYSTEM_FEHLER_ANZEIGEN_NR]));
        jCheckBoxHinweise.setSelected(Boolean.parseBoolean(daten.system[Konstanten.SYSTEM_HINWEIS_ANZEIGEN_NR]));
        jCheckBoxMax.setSelected(Boolean.parseBoolean(daten.system[Konstanten.SYSTEM_START_MAX_NR]));
        jTextFieldUserAgent.setText(daten.system[Konstanten.SYSTEM_USER_AGENT_NR]);
        if (daten.system[Konstanten.SYSTEM_MAX_DOWNLOAD_NR].equals("")) {
            jSpinnerDownload.setValue(1);
            daten.system[Konstanten.SYSTEM_MAX_DOWNLOAD_NR] = "1";
        } else {
            jSpinnerDownload.setValue(Integer.parseInt(daten.system[Konstanten.SYSTEM_MAX_DOWNLOAD_NR]));
        }
//        if (daten.system[Konstanten.SYSTEM_LEITUNG_NR].equals(Konstanten.LEITUNG_HD)) {
//            jRadioButtonHD.setSelected(true);
//        } else if (daten.system[Konstanten.SYSTEM_LEITUNG_NR].equals(Konstanten.LEITUNG_DSL1000)) {
//            jRadioButtonDsl1000.setSelected(true);
//        } else {
//            jRadioButtonDsl2000.setSelected(true);
//            //falls leer
//            daten.system[Konstanten.SYSTEM_LEITUNG_NR] = Konstanten.LEITUNG_DSL2000;
//        }
        jCheckBoxRtmp.setSelected(Boolean.parseBoolean(daten.system[Konstanten.SYSTEM_LEITUNG_RTMP_NR]));
    }

//    private String leitung() {
//        String leitung;
//        if (jRadioButtonHD.isSelected()) {
//            leitung = Konstanten.LEITUNG_HD;
//        } else if (jRadioButtonDsl1000.isSelected()) {
//            leitung = Konstanten.LEITUNG_DSL1000;
//        } else {
//            leitung = Konstanten.LEITUNG_DSL2000;
//        }
//        return leitung;
//    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroup1 = new javax.swing.ButtonGroup();
        jPanel6 = new javax.swing.JPanel();
        jCheckBoxFehler = new javax.swing.JCheckBox();
        jCheckBoxSimmulieren = new javax.swing.JCheckBox();
        jCheckBoxMax = new javax.swing.JCheckBox();
        jLabel1 = new javax.swing.JLabel();
        jComboBoxLook = new javax.swing.JComboBox();
        jLabel5 = new javax.swing.JLabel();
        jTextFieldUserAgent = new javax.swing.JTextField();
        jButtonStandard = new javax.swing.JButton();
        jButtonHilfe = new javax.swing.JButton();
        jSeparator2 = new javax.swing.JSeparator();
        jCheckBoxHinweise = new javax.swing.JCheckBox();
        jSeparator3 = new javax.swing.JSeparator();
        jLabel3 = new javax.swing.JLabel();
        jSpinnerDownload = new javax.swing.JSpinner();
        jPanel3 = new javax.swing.JPanel();
        jCheckBoxRtmp = new javax.swing.JCheckBox();

        jPanel6.setBorder(javax.swing.BorderFactory.createTitledBorder(""));

        jCheckBoxFehler.setText("Fehlermeldungen anzeigen");

        jCheckBoxSimmulieren.setText("Zum Testen: Das Starten externer Programme nur simulieren");

        jCheckBoxMax.setText("Programmfenster maximiert starten");

        jLabel1.setText("Look and Feel:");

        jComboBoxLook.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

        jLabel5.setText("User-Agent:");

        jButtonStandard.setText("Rücksetzen");

        jButtonHilfe.setText("Hilfe");

        jSeparator2.setOpaque(true);

        jCheckBoxHinweise.setText("Hinweise anzeigen");

        jSeparator3.setOpaque(true);

        jLabel3.setText("max. parallele Downloads beim Laden der Abos ( empf: 2 ):");

        javax.swing.GroupLayout jPanel6Layout = new javax.swing.GroupLayout(jPanel6);
        jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(
            jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel6Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jSeparator3, javax.swing.GroupLayout.DEFAULT_SIZE, 782, Short.MAX_VALUE)
                    .addComponent(jSeparator2, javax.swing.GroupLayout.DEFAULT_SIZE, 782, Short.MAX_VALUE)
                    .addComponent(jCheckBoxMax)
                    .addComponent(jCheckBoxSimmulieren)
                    .addComponent(jCheckBoxHinweise)
                    .addComponent(jCheckBoxFehler)
                    .addGroup(jPanel6Layout.createSequentialGroup()
                        .addGroup(jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel1)
                            .addComponent(jLabel5))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(jPanel6Layout.createSequentialGroup()
                                .addComponent(jTextFieldUserAgent, javax.swing.GroupLayout.DEFAULT_SIZE, 422, Short.MAX_VALUE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jButtonStandard)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jButtonHilfe))
                            .addComponent(jComboBoxLook, 0, 666, Short.MAX_VALUE)))
                    .addGroup(jPanel6Layout.createSequentialGroup()
                        .addComponent(jLabel3)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jSpinnerDownload, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap())
        );

        jPanel6Layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {jButtonHilfe, jButtonStandard});

        jPanel6Layout.setVerticalGroup(
            jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel6Layout.createSequentialGroup()
                .addGap(14, 14, 14)
                .addComponent(jCheckBoxFehler)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jCheckBoxHinweise)
                .addGap(18, 18, 18)
                .addComponent(jCheckBoxSimmulieren)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jCheckBoxMax)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jSeparator2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addGroup(jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(jComboBoxLook, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel5)
                    .addComponent(jTextFieldUserAgent, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jButtonHilfe)
                    .addComponent(jButtonStandard))
                .addGap(18, 18, 18)
                .addComponent(jSeparator3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addGroup(jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel3)
                    .addComponent(jSpinnerDownload, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jPanel6Layout.linkSize(javax.swing.SwingConstants.VERTICAL, new java.awt.Component[] {jButtonHilfe, jTextFieldUserAgent});

        jPanel3.setBorder(javax.swing.BorderFactory.createTitledBorder("Allgemeine Einstellungen der Filme"));

        jCheckBoxRtmp.setText("Flash-Filme ( RTMP-Protokoll ): Url für flvstreamer vorbereiten");

        javax.swing.GroupLayout jPanel3Layout = new javax.swing.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jCheckBoxRtmp)
                .addContainerGap(339, Short.MAX_VALUE))
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jCheckBoxRtmp)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jPanel3, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanel6, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel6, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(jPanel3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(196, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JButton jButtonHilfe;
    private javax.swing.JButton jButtonStandard;
    private javax.swing.JCheckBox jCheckBoxFehler;
    private javax.swing.JCheckBox jCheckBoxHinweise;
    private javax.swing.JCheckBox jCheckBoxMax;
    private javax.swing.JCheckBox jCheckBoxRtmp;
    private javax.swing.JCheckBox jCheckBoxSimmulieren;
    private javax.swing.JComboBox jComboBoxLook;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel6;
    private javax.swing.JSeparator jSeparator2;
    private javax.swing.JSeparator jSeparator3;
    private javax.swing.JSpinner jSpinnerDownload;
    private javax.swing.JTextField jTextFieldUserAgent;
    // End of variables declaration//GEN-END:variables

    private class BeobSpinnerDownload implements ChangeListener {

        @Override
        public void stateChanged(ChangeEvent arg0) {
            daten.system[Konstanten.SYSTEM_MAX_DOWNLOAD_NR] =
                    String.valueOf(((Number) jSpinnerDownload.getModel().getValue()).intValue());
            daten.setGeaendertOhnePanel();
        }
    }

    private class BeobCheckboxFehler implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            daten.system[Konstanten.SYSTEM_FEHLER_ANZEIGEN_NR] = Boolean.toString(jCheckBoxFehler.isSelected());
            daten.setGeaendert();
        }
    }

    private class BeobHinweise implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            daten.system[Konstanten.SYSTEM_HINWEIS_ANZEIGEN_NR] = Boolean.toString(jCheckBoxHinweise.isSelected());
            daten.setGeaendert();
        }
    }

    private class BeobCheckboxMax implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            daten.system[Konstanten.SYSTEM_START_MAX_NR] = Boolean.toString(jCheckBoxMax.isSelected());
            daten.setGeaendert();
        }
    }

    private class BeobCheckboxSender implements ActionListener {

        private int nr;

        public BeobCheckboxSender(int nnr) {
            nr = nnr;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            daten.filmeLaden.mediathekListe.get(nr).setSenderAn(((JCheckBox) e.getSource()).isSelected());
            daten.setGeaendert();
        }
    }

    private class BeobachterSimmulieren implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            daten.simmulieren = jCheckBoxSimmulieren.isSelected();
        }
    }

    private class BeobUserAgent implements DocumentListener {

        @Override
        public void insertUpdate(DocumentEvent e) {
            tus();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            tus();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            tus();
        }

        private void tus() {
            daten.system[Konstanten.SYSTEM_USER_AGENT_NR] = jTextFieldUserAgent.getText();
            daten.setGeaendert();
        }
    }

    private class BeobLook implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Funktionen.setLook(daten, daten.guiMediathek, Integer.parseInt(String.valueOf(jComboBoxLook.getSelectedIndex())))) {
                daten.system[Konstanten.SYSTEM_LOOK_NR] = String.valueOf(jComboBoxLook.getSelectedIndex());
                daten.setGeaendert();
            } else {
                daten.system[Konstanten.SYSTEM_LOOK_NR] = "1";
                jComboBoxLook.setSelectedIndex(1);
                Funktionen.setLook(daten, daten.guiMediathek, 1);
            }

        }
    }

    private class BeobRtmp implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            daten.system[Konstanten.SYSTEM_LEITUNG_RTMP_NR] = Boolean.toString(jCheckBoxRtmp.isSelected());
            daten.filmeLaden.listeFilme.rtmpAendern();
            daten.guiMediathek.guiFilme.neuLaden();
            daten.setGeaendert();
        }
    }

//    private class LeitungBeobachter implements ActionListener {
//
//        @Override
//        public void actionPerformed(ActionEvent e) {
//            daten.system[Konstanten.SYSTEM_LEITUNG_NR] = leitung();
//            daten.filmeLaden.leitungAendern();
//            daten.guiMediathek.guiFilme.neuLaden();
//            daten.setGeaendert();
//        }
//    }
}
