/*
 *    Copyright (C) 2008
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mediathek.filme;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import mediathek.Funktionen;
import mediathek.Konstanten;
import mediathek.daten.Daten;
import org.apache.commons.lang.StringEscapeUtils;

/**
 * 
 * @author emil
 */
public class ListeFilmeSchattenliste extends LinkedList<DatenFilm> {

    private Daten daten;

    /**
     * 
     * @param ddaten
     */
    public ListeFilmeSchattenliste(Daten ddaten) {
        daten = ddaten;
    }

    //===================================
    // public
    //===================================
    @Override
    public boolean add(DatenFilm film) {
//        String str = String.valueOf(nr++);
//        while (str.length() < MAX_STELLEN) {
//            str = FUELL_ZEICHEN + str;
//        }
        film.arr[Konstanten.FILM_THEMA_NR] = StringEscapeUtils.unescapeHtml(film.arr[Konstanten.FILM_THEMA_NR].trim());
        film.arr[Konstanten.FILM_TITEL_NR] = StringEscapeUtils.unescapeHtml(film.arr[Konstanten.FILM_TITEL_NR].trim());
//        film.arr[Konstanten.FILM_NR_NR] = str;
        film.arr[Konstanten.FILM_DATEI_NR] = Funktionen.getDateiName(daten, film.arr[Konstanten.FILM_URL_NR]);
        if (daten.listeBlacklist.checkBlackOk(film)) {
            daten.filmeLaden.listeFilme.add(film);
        }
        return super.add(film);
    }

    public boolean addSender(DatenFilm film) {
        // Filme die beim Sender gesucht wurden (und nur die) hier eintragen
        // nur für die MediathekReader
        // ist eine URL,Sender,Thema,Titel schon vorhanden, wird sie ersetzt
        return addInListe(film);
    }

    public boolean addSenderRtmp(DatenFilm film) {
        // Filme die beim Sender gesucht wurden (und nur die) hier eintragen
        // nur für die MediathekReader
        // ist eine URL,Sender,Thema,Titel schon vorhanden, wird sie ersetzt
        if (Boolean.parseBoolean(daten.system[Konstanten.SYSTEM_LEITUNG_RTMP_NR])) {
            if (film.arr[Konstanten.FILM_URL_NR].startsWith("rtmp")) {
                film.arr[Konstanten.FILM_URL_NR] = "-r " + film.arr[Konstanten.FILM_URL_NR];
            }
        }
        return addInListe(film);
    }

    public synchronized boolean addOld(DatenFilm film, int bisNr) {
        // alte Filme die noch nicht in der Liste sind, eintragen
        // und die werden so hinten angehängt
        DatenFilm f = null;
        int i = 0;
        boolean gibts = false;
        // erst mal schauen obs das schon gibt
        Iterator<DatenFilm> it = this.iterator();
        while (it.hasNext()) {
            ++i;
            if (i > bisNr) {
                // nur bis zur ursprünglichen länge der Liste prüfen
                // alle anderen sind ja die alte Liste
                break;
            }
            f = it.next();
            if (f.arr[Konstanten.FILM_SENDER_NR].equalsIgnoreCase(film.arr[Konstanten.FILM_SENDER_NR])
                    && f.arr[Konstanten.FILM_THEMA_NR].equalsIgnoreCase(film.arr[Konstanten.FILM_THEMA_NR])
                    && f.arr[Konstanten.FILM_URL_NR].equals(film.arr[Konstanten.FILM_URL_NR])) {
                gibts = true;
                break;
            }
        }
        if (!gibts) {
            // nur wenn er noch nicht in der Liste ist, wird er eingetragen
            return add(film);
        } else {
            return false;
        }
    }

    private synchronized boolean addInListe(DatenFilm film) {
        // Filme die beim Sender gesucht wurden (und nur die) hier eintragen
        // nur für die MediathekReader
        // ist eine URL,Sender,Thema,Titel schon vorhanden, wird sie ersetzt
        DatenFilm f = null;
        film.arr[Konstanten.FILM_THEMA_NR] = StringEscapeUtils.unescapeHtml(film.arr[Konstanten.FILM_THEMA_NR].trim());
        film.arr[Konstanten.FILM_TITEL_NR] = StringEscapeUtils.unescapeHtml(film.arr[Konstanten.FILM_TITEL_NR].trim());
        // erst mal schauen obs das schon gibt
        Iterator<DatenFilm> it = this.iterator();
        while (it.hasNext()) {
            f = it.next();
            if (f.arr[Konstanten.FILM_SENDER_NR].equalsIgnoreCase(film.arr[Konstanten.FILM_SENDER_NR])
                    && f.arr[Konstanten.FILM_THEMA_NR].equalsIgnoreCase(film.arr[Konstanten.FILM_THEMA_NR])
                    && f.arr[Konstanten.FILM_URL_NR].equals(film.arr[Konstanten.FILM_URL_NR])) {
                it.remove();
                break;
            }
        }
        return add(film);
    }

    public void sort() {
        Collections.<DatenFilm>sort(this);
    }

    public synchronized void delOhneSender(String sender) {
        DatenFilm film = null;
        ListIterator<DatenFilm> it = this.listIterator(0);
        while (it.hasNext()) {
            film = it.next();
            if (!film.arr[Konstanten.FILM_SENDER_NR].equalsIgnoreCase(sender)) {
                it.remove();
            }
        }
    }

    public synchronized void delSender(String sender) {
        DatenFilm film = null;
        ListIterator<DatenFilm> it = this.listIterator(0);
        while (it.hasNext()) {
            film = it.next();
            if (film.arr[Konstanten.FILM_SENDER_NR].equalsIgnoreCase(sender)) {
                it.remove();
            }
        }
    }

    public synchronized int countSender(String sender) {
        int ret = 0;
        ListIterator<DatenFilm> it = this.listIterator(0);
        while (it.hasNext()) {
            if (it.next().arr[Konstanten.FILM_SENDER_NR].equalsIgnoreCase(sender)) {
                ++ret;
            }
        }
        return ret;
    }
}
