/*
 *    Copyright (C) 2008
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mediathek.filme;

import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import javax.swing.event.EventListenerList;
import mediathek.Funktionen;
import mediathek.Konstanten;
import mediathek.daten.Daten;
import mediathek.filme.sender.Mediathek3Sat;
import mediathek.filme.sender.MediathekArd;
import mediathek.filme.sender.MediathekArdPodcast;
import mediathek.filme.sender.MediathekArte7;
import mediathek.filme.sender.MediathekMdr;
import mediathek.filme.sender.MediathekNdr;
import mediathek.filme.sender.MediathekNdrFlash;
import mediathek.filme.sender.MediathekOrf;
import mediathek.filme.sender.MediathekReader;
import mediathek.filme.sender.MediathekSf;
import mediathek.filme.sender.MediathekSfPod;
import mediathek.filme.sender.MediathekSwr;
import mediathek.filme.sender.MediathekWdr;
import mediathek.filme.sender.MediathekZdf;
import mediathek.update.UpdateSuchen;
import mediathek.io.GetUrl;

/**
 * 
 * @author emil
 */
public class FilmeLaden {

    private int seitenZaehlerGesamt = 0; //Gesamtzahl während der gesamten Programmlaufzeit
    private int seitenZaehler = 0; //Gesamtzahl für einen Lauf
    public LinkedList<MediathekReader> mediathekListe = new LinkedList<MediathekReader>();
    private Daten daten;
    public ListeFilme listeFilme;
    public ListeFilmeSchattenliste listeFilmeOld; // wird alles vor dem Update hierhin kopiert
    public ListeFilmeSchattenliste listeFilmeSchattenliste;
    public String[] filmlisteMetaDaten;
    public Date aktuellsterServer = null;
    EventListenerList listeners = new EventListenerList();
    private boolean ioxml = false;

    /**
     * 
     * @param ddaten
     */
    public FilmeLaden(Daten ddaten) {
        daten = ddaten;
        listeFilme = new ListeFilme(daten);
        listeFilmeSchattenliste = new ListeFilmeSchattenliste(daten);
        //FilmlisteMetaDaten
        filmlisteMetaDaten = new String[Konstanten.FILMLISTE_MAX_ELEM];
        for (int i = 0; i < filmlisteMetaDaten.length; ++i) {
            filmlisteMetaDaten[i] = "";
        }
        init();
    }
    //#######################
    // Schattenliste
    //#######################

    public synchronized void checkBlacklist() {
        Iterator<DatenFilm> it = listeFilmeSchattenliste.iterator();
        listeFilme.clear();
        while (it.hasNext()) {
            DatenFilm film = it.next();
            if (daten.listeBlacklist.checkBlackOk(film)) {
                listeFilme.add(film);
            }
        }
    }

    // ##########################################################################################################
    // laden
    // ###########################################################################################################
    // #######################################
    // Filme von Server importieren
    // #######################################
    public synchronized void filmeImportServer() {
        new Thread(new filmeImportServerThread()).start();
    }

    private class filmeImportServerThread implements Runnable {

        @Override
        public synchronized void run() {
            filmeImportServer_();
        }
    }

    private void filmeImportServer_() {
        //wenn auto-update-url dann erst mal die Updateserver aktualiseren laden
        // im auto-modus wird das vorher schon gemacht
        new UpdateSuchen(daten).suchen(false);
        if (Funktionen.getUpdateFilme(daten) == Konstanten.UPDATE_FILME_AUS) {
            urlLaden(daten.system[Konstanten.SYSTEM_IMPORT_URL_AUTO_NR]);
        } else {
            for (int i = 0; i < 10; ++i) {
                //10 mal mit einem anderen Server probieren
                if (urlLaden(daten.system[Konstanten.SYSTEM_IMPORT_URL_AUTO_NR])) {
                    // hat geklappt, nix wie weiter
                    break;
                }
                daten.system[Konstanten.SYSTEM_IMPORT_URL_AUTO_NR] = daten.listeFilmUpdate.getRand(i); //nächste Adresse in der Liste wählen
                daten.setGeaendertSofort();
            }
        }
        if (listeFilme.isEmpty()) {
            daten.fehler.fehlerMeldung("Filme laden", "Es konnten keine Filme geladen werden!");
        }
    }

    private boolean urlLaden(String pfad) {
        daten.timerLaden.reset(); //timer zurücksetzen
        boolean ret = false;
        try {
            if (!ioxml) {
                ioxml = true;
                daten.ioXml.addAdListener(new BeobLaden(true));
            }
            if (pfad.equals("")) {
                JOptionPane.showMessageDialog(null, "Keine Datei/Url angegeben", "Pfad", JOptionPane.INFORMATION_MESSAGE);
            } else {
                alleFilmeLoeschen();
                ret = daten.ioXml.importDatenFilme(pfad, false);
            }
        } catch (Exception ex) {
        }
        return ret;
    }

    // #######################################
    // Filme aus Datei laden
    // #######################################
    public void filmeImportDatei(String pfad, boolean istDatei) {
        new Thread(new filmeImportDateiThread(pfad, istDatei)).start();
    }

    private class filmeImportDateiThread implements Runnable {

        String pfad;
        boolean istDatei;

        public filmeImportDateiThread(String ppfad, boolean iistDatei) {
            pfad = ppfad;
            istDatei = iistDatei;
        }

        @Override
        public synchronized void run() {
            filmeImportDatei_(pfad, istDatei);
        }
    }

    private void filmeImportDatei_(String pfad, boolean istDatei) {
        try {
            if (pfad.equals("")) {
                JOptionPane.showMessageDialog(null, "Keine Datei/Url angegeben", "Pfad", JOptionPane.INFORMATION_MESSAGE);
            } else {
                if (!ioxml) {
                    ioxml = true;
                    daten.ioXml.addAdListener(new BeobLaden(true));
                }
                alleFilmeLoeschen();
                daten.ioXml.importDatenFilme(pfad, istDatei);
            }
        } catch (Exception ex) {
        }
    }

    // #######################################
    // Filme beim Sender laden
    // #######################################
    public void filmeBeimSenderLaden() {
        new Thread(new filmebeimSenderLadenThread()).start();
    }

    private class filmebeimSenderLadenThread implements Runnable {

        @Override
        public synchronized void run() {
            filmeBeimSenderLaden_();
        }
    }

    private void filmeBeimSenderLaden_() {
        if (daten.noGui || this.wenigstensEinSenderAn()) {
            daten.setGeaendert();
            listeFilme.clear();
            if (daten.allesLaden) {
                // nur dann die Liste löschen (Spezialfall SWR!)
                listeFilmeSchattenliste.delOhneSender(Konstanten.SENDER_SWR); //muss erhalten bleiben, der braucht mehrere Durchläufe
            } else {
                listeFilmeOld = listeFilmeSchattenliste;
                listeFilmeSchattenliste = new ListeFilmeSchattenliste(daten);
            }
            GetUrl.stop = false;
            //Seitenzähler Sender zurücksetzen
            seitenZaehlerLoeschen();
            Iterator<MediathekReader> it = mediathekListe.iterator();
            while (it.hasNext()) {
                new Thread(it.next()).start();
            }
        } else if (!daten.noGui) {
            JOptionPane.showMessageDialog(null, "Kein Sender zum Laden ausgewählt!");
        }
    }

    public void senderLaden(String sender) {
        MediathekReader reader = getMediathekReader(sender);
        if (reader != null) {
            daten.setGeaendert();
            listeFilme.clear();
            if (daten.allesLaden) {
                // nur dann die Liste löschen (Spezialfall SWR!)
                if (!sender.equalsIgnoreCase(Konstanten.SENDER_SWR)) {
                    listeFilmeSchattenliste.delSender(sender);
                }
            }
            GetUrl.stop = false;
            seitenZaehlerLoeschen(sender);
            reader.updateOn = true;
            new Thread(reader).start();
        }
    }
    // ##########################################################################################################
    // laden Ende
    // ###########################################################################################################

    private void datumSchreiben(boolean loeschen) {
        if (!loeschen) {
            filmlisteMetaDaten[Konstanten.FILMLISTE_DATUM_NR] = Funktionen.getJetzt_ddMMyyyy_HHmm();
            filmlisteMetaDaten[Konstanten.FILMLISTE_NUR_ZEIT_NR] = Funktionen.getJetzt_HH_MM_SS();
            filmlisteMetaDaten[Konstanten.FILMLISTE_NUR_DATUM_NR] = Funktionen.getHeute_dd_MM_yyyy();
        } else {
            filmlisteMetaDaten[Konstanten.FILMLISTE_DATUM_NR] = "";
            filmlisteMetaDaten[Konstanten.FILMLISTE_NUR_ZEIT_NR] = "";
            filmlisteMetaDaten[Konstanten.FILMLISTE_NUR_DATUM_NR] = "";
        }
        filmlisteMetaDaten[Konstanten.FILMLISTE_ANZAHL_NR] = String.valueOf(this.listeFilmeSchattenliste.size());
    }

    public void alleFilmeLoeschen() {
        listeFilme.clear();
        listeFilmeSchattenliste.clear();
    }

//    public void leitungAendern() {
//        this.listeFilme.leitungAendern();
//    }
    // Seitenzähler
    public int getSeitenZaehler(String sender) {
        int ret = 0;
        MediathekReader r = getMediathekReader(sender);
        if (r != null) {
            if (r.sender.equalsIgnoreCase(sender)) {
                ret = r.getSeitenZaehler();
            }
        }
        return ret;
    }

    public int getSeitenZaehlerGesamt() {
        return this.seitenZaehlerGesamt;
    }

    public int getSeitenZaehlerLauf() {
        return this.seitenZaehler;
    }

    public synchronized void incSeitenZaehler(String sender) {
        ++seitenZaehler;
        ++seitenZaehlerGesamt;
        //Seitenzähler des Senders aktualisieren und die Gesamtzähler
        MediathekReader r = getMediathekReader(sender);
        if (r != null) {
            r.incSeitenZaehler();
        }
    }

    public void seitenZaehlerLoeschen() {
        seitenZaehler = 0;
        Iterator<MediathekReader> it = mediathekListe.iterator();
        while (it.hasNext()) {
            it.next().seitenZaehlerLoeschen();
        }
    }

    public void seitenZaehlerLoeschen(String sender) {
        seitenZaehler = 0;
        MediathekReader r = getMediathekReader(sender);
        if (r != null) {
            r.seitenZaehlerLoeschen();
        }
    }

    public void laufzeitenSchreiben() {
        Iterator<MediathekReader> it = mediathekListe.iterator();
        int m = 0;
        String l = "";
        while (it.hasNext()) {
            MediathekReader r = it.next();
            if (daten.noGui || r.istSenderAn()) {
                daten.fehler.systemMeldung("##################################");
                daten.fehler.systemMeldung(r.sender);
                if (!(l = r.getLaufzeitMinuten()).equals("")) {
                    daten.fehler.systemMeldung("    Laufzeit: " + l + " Minuten");
                }
                if ((m = r.getSeitenZaehler()) != 0) {
                    daten.fehler.systemMeldung("    Seiten:   " + m);
                }
                daten.fehler.systemMeldung("    Filme:    " + listeFilmeSchattenliste.countSender(r.sender));
            }
        }
    }

    //Infos zu Sendern
    public boolean wenigstensEinSenderAn() {
        //liefert true wenn wenigstens ein Sender eingeschaltet ist
        boolean ret = false;
        Iterator<MediathekReader> it = mediathekListe.iterator();
        while (it.hasNext()) {
            if (it.next().istSenderAn()) {
                ret = true;
                break;
            }
        }
        return ret;
    }

    public String[] getSenderNamen() {
        String[] ret = new String[daten.filmeLaden.mediathekListe.size()];
        Iterator<MediathekReader> it = daten.filmeLaden.mediathekListe.iterator();
        int i = 0;
        while (it.hasNext()) {
            ret[i] = it.next().sender;
            ++i;
        }
        return ret;
    }

    public String[] getListeSender() {
        String[] ret = new String[daten.filmeLaden.mediathekListe.size()];
        Iterator<MediathekReader> it = daten.filmeLaden.mediathekListe.iterator();
        int i = 0;
        while (it.hasNext()) {
            ret[i] = Konstanten.SENDER_PREFX + it.next().sender;
            ++i;
        }
        return ret;
    }

    public String[] getSenderOn() {
        String[] ret = new String[daten.filmeLaden.mediathekListe.size()];
        Iterator<MediathekReader> it = daten.filmeLaden.mediathekListe.iterator();
        int i = 0;
        while (it.hasNext()) {
            ret[i] = Boolean.toString(it.next().istSenderAn());
            ++i;
        }
        return ret;
    }

    public void setSenderOn(String[] str) {
        String[] sender = getListeSender();
        Iterator<MediathekReader> it = daten.filmeLaden.mediathekListe.iterator();
        MediathekReader reader;
        while (it.hasNext()) {
            for (int i = 0; i < str.length; ++i) {
                reader = it.next();
                if ((Konstanten.SENDER_PREFX + reader.sender).equalsIgnoreCase(sender[i])) {
                    if (str[i].equals("")) {
                        reader.setSenderAn(true);
                    } else {
                        reader.setSenderAn(Boolean.parseBoolean(str[i]));
                    }
                }
            }
        }
    }

    public boolean senderAn(String sender) {
        MediathekReader r = getMediathekReader(sender);
        if (r != null) {
            if (r.istSenderAn()) {
                return true;
            }
        }
        return false;
    }

    public void addAdListener(FilmListener listener) {
        listeners.add(FilmListener.class, listener);
    }

    public void setStop() {
        Iterator<MediathekReader> it = daten.filmeLaden.mediathekListe.iterator();
        while (it.hasNext()) {
            it.next().stoppen();
        }
        GetUrl.stop = true;
        daten.ioXml.stop = true;
    }

    //===================================
    // private
    //===================================
    private void init() {
        //Reader laden Spaltenweises Laden
        mediathekListe.add(new MediathekArd(daten));
        mediathekListe.add(new MediathekArdPodcast(daten));
        mediathekListe.add(new MediathekZdf(daten));
        mediathekListe.add(new MediathekArte7(daten, true /*de*/));
        mediathekListe.add(new MediathekArte7(daten, false));
        mediathekListe.add(new Mediathek3Sat(daten));
        mediathekListe.add(new MediathekSwr(daten));
        // Spalte 2
//        mediathekListe.add(new MediathekNdrFlash(daten));
        mediathekListe.add(new MediathekMdr(daten));
        mediathekListe.add(new MediathekWdr(daten));
        mediathekListe.add(new MediathekSf(daten));
        mediathekListe.add(new MediathekSfPod(daten));
        mediathekListe.add(new MediathekOrf(daten));

        //--Reader ende
        BeobLaden beobLaden = new BeobLaden();
        Iterator<MediathekReader> it = mediathekListe.iterator();
        while (it.hasNext()) {
            MediathekReader r = it.next();
            r.addAdListener(beobLaden);
        }
    }

    private void notifyStart(String sender, int max) {
        for (FilmListener l : listeners.getListeners(FilmListener.class)) {
            l.start(sender, max);
        }
    }

    private void notifyProgress(String sender, String text) {
        for (FilmListener l : listeners.getListeners(FilmListener.class)) {
            l.progress(sender, text);
        }

    }

    private void notifyFertig(String sender, boolean stop) {
        for (FilmListener l : listeners.getListeners(FilmListener.class)) {
            l.fertig(sender, stop);
        }

    }

    private void notifyAddMax(String sender, int max) {
        for (FilmListener l : listeners.getListeners(FilmListener.class)) {
            l.addMax(sender, max);
        }

    }

    private void notifyThreads(String sender, int threads) {
        for (FilmListener l : listeners.getListeners(FilmListener.class)) {
            l.threads(sender, threads);
        }

    }

    private MediathekReader getMediathekReader(String sender) {
        MediathekReader ret = null;
        if (!sender.equals("")) {
            Iterator<MediathekReader> it = mediathekListe.iterator();
            while (it.hasNext()) {
                ret = it.next();
                if (ret.sender.equalsIgnoreCase(sender)) {
                    break;
                }
            }
        }
        return ret;
    }

    private void addOld() {
        if (listeFilmeOld != null) {
            int nr = listeFilmeSchattenliste.size();
            Iterator<DatenFilm> it = listeFilmeOld.iterator();
            while (it.hasNext()) {
                listeFilmeSchattenliste.addOld(it.next(), nr);
            }
            listeFilmeOld.clear();
        }
    }

    private class BeobLaden implements FilmListener {

        boolean listeImporieren = false;
        int count = 0;

        public BeobLaden() {
        }

        public BeobLaden(boolean iimporiteren) {
            listeImporieren = iimporiteren;
        }

        @Override
        public synchronized void start(String sender, int max) {
            //wird beim Start des Senders aufgerufen, 1x
            ++count;
            if (count <= 1 /*erster Aufruf*/) {
                notifyStart(sender, max);
            } else {
                notifyAddMax(sender, max);
            }
        }

        @Override
        public synchronized void progress(String sender, String text) {
            notifyProgress(sender, text);
        }

        @Override
        public synchronized void fertig(String sender, boolean stop /*abgebrochen*/) {
            // wird einmal aufgerufen, wenn der Sender fertig ist
            --count;
            if (count == 0) {
                addOld();
                listeFilmeSchattenliste.sort();
                //nach dem Laden die Liste der Filme speichern
                if (!listeImporieren) {
                    checkBlacklist();
                    //nur dann Datum schreiben
                    datumSchreiben(stop /*löschen*/);
                }
                listeFilme.sort();
                if (!listeFilme.isEmpty()) {
                    laufzeitenSchreiben();
                    daten.ioXml.filmeSchreiben();
                }
                notifyFertig(sender, stop);
            } else {
                //nur ein Sender fertig
                notifyProgress(sender, "fertig");
            }
        }

        @Override
        public synchronized void addMax(String sender, int max) {
            notifyAddMax(sender, max);
        }

        @Override
        public synchronized void threads(String sender, int threads) {
            notifyThreads(sender, threads);
        }
    }
}
