/*
 *    Copyright (C) 2008
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mediathek.io;

import java.io.BufferedInputStream;
import java.io.File;
import mediathek.daten.DatenPod;
import mediathek.daten.DatenAbo;
import mediathek.daten.Daten;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.event.EventListenerList;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import mediathek.Funktionen;
import mediathek.Konstanten;
import mediathek.daten.DatenBlacklist;
import mediathek.filme.DatenFilm;
import mediathek.daten.DatenFilmUpdate;
import mediathek.daten.DatenPgruppe;
import mediathek.daten.DatenPodster;
import mediathek.daten.DatenProg;
import mediathek.filme.FilmListener;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;

public class IoXml {

    private XMLOutputFactory outFactory;
    private XMLStreamWriter writer;
    private OutputStreamWriter out = null;
    ZipOutputStream zipOutputStream = null;
    BZip2CompressorOutputStream bZip2CompressorOutputStream = null;
    private Daten daten;
    EventListenerList listeners = new EventListenerList();
    public boolean stop = false;

    public IoXml(Daten d) {
        daten = d;
//        Properties sysprops = System.getProperties();
    }

    public void datenLesen() {
        stop = false;
        xmlDatenLesen();
        xmlDatenLesenFilme();
        xmlDatenLesenPodster();
    }

    public void datenLesenFilme() {
        stop = false;
        xmlDatenLesenFilme();
    }

    public void addAdListener(FilmListener listener) {
        listeners.add(FilmListener.class, listener);
    }

    /**
     *
     * @param datei
     * @param zip
     * @param istDatei
     * @return
     */
    public boolean importDatenFilme(String datei, boolean istDatei) {
        stop = false;
        this.notifyStart(1);
        this.notifyProgress(datei);
        boolean ret = true;
        XMLInputFactory inFactory = XMLInputFactory.newInstance();
        inFactory.setProperty(XMLInputFactory.IS_COALESCING, Boolean.FALSE);
        XMLStreamReader parser = null;
        InputStreamReader inReader = null;
        InputStream inputStream = null;
        BZip2CompressorInputStream bZip2CompressorInputStream = null;
        String user_agent = daten.system[Konstanten.SYSTEM_USER_AGENT_NR];
        int timeout = 30000;
        URLConnection conn = null;
        try {
            if (istDatei) {
                if (datei.endsWith(Konstanten.FORMAT_BZ2)) {
                    bZip2CompressorInputStream = new BZip2CompressorInputStream(new FileInputStream(datei));
                    inReader = new InputStreamReader(bZip2CompressorInputStream, Konstanten.KODIERUNG_UTF);
                } else if (datei.endsWith(Konstanten.FORMAT_ZIP)) {
                    ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(datei));
                    zipInputStream.getNextEntry();
                    inReader = new InputStreamReader(zipInputStream, Konstanten.KODIERUNG_UTF);
                } else {
                    inReader = new InputStreamReader(new FileInputStream(datei), Konstanten.KODIERUNG_UTF);
                }
            } else {
                conn = new URL(datei).openConnection();
                conn.setRequestProperty("User-Agent", user_agent);
                conn.setReadTimeout(timeout);
                conn.setConnectTimeout(timeout);
                if (datei.endsWith(Konstanten.FORMAT_BZ2)) {
//                    inputStream = conn.getInputStream();
//                    BufferedInputStream buffIn = new BufferedInputStream(inputStream);
//                    bZip2CompressorInputStream = new BZip2CompressorInputStream(buffIn);
                    bZip2CompressorInputStream = new BZip2CompressorInputStream(conn.getInputStream());
                    inReader = new InputStreamReader(bZip2CompressorInputStream, Konstanten.KODIERUNG_UTF);
                } else if (datei.endsWith(Konstanten.FORMAT_ZIP)) {
                    ZipInputStream zipInputStream = new ZipInputStream(conn.getInputStream());
                    zipInputStream.getNextEntry();
                    inReader = new InputStreamReader(zipInputStream, Konstanten.KODIERUNG_UTF);
                } else {
                    inReader = new InputStreamReader(conn.getInputStream(), Konstanten.KODIERUNG_UTF);
                }
            }
            parser = inFactory.createXMLStreamReader(inReader);
            ret = datenLesenFilme(parser,
                    Boolean.parseBoolean(daten.system[Konstanten.SYSTEM_ALTE_FILME_NR]), datei);
        } catch (Exception ex) {
            ret = false;
            daten.fehler.fehlerMeldung(ex, "Filme importieren von: " + datei);
        } finally {
            try {
                if (inReader != null) {
                    inReader.close();
                }
            } catch (Exception ex) {
                daten.fehler.fehlerMeldung(ex, "Stream.close");
            }
            this.notifyFertig();
        }
        return ret;
    }

    private boolean xmlDatenLesen() {
        boolean ret = true;
        try {
            String datei = "";
            datei = daten.getBasisVerzeichnis(false) + Konstanten.XML_DATEI;
            int event;
            XMLInputFactory inFactory = XMLInputFactory.newInstance();
            inFactory.setProperty(XMLInputFactory.IS_COALESCING, Boolean.FALSE);
            XMLStreamReader parser = null;
            InputStreamReader in = null;
            DatenPgruppe datenPgruppe = null;
            in = new InputStreamReader(new FileInputStream(datei), Konstanten.KODIERUNG_UTF);
            parser = inFactory.createXMLStreamReader(in);
            while (parser.hasNext()) {
                event = parser.next();
                if (event == XMLStreamConstants.START_ELEMENT) {
                    String t = parser.getLocalName();
                    if (parser.getLocalName().equals(Konstanten.SYSTEM)) {
                        //System
                        get(parser, event, Konstanten.SYSTEM, Konstanten.SYSTEM_COLUMN_NAMES, daten.system);
                    } else if (parser.getLocalName().equals(Konstanten.SENDERLISTE)) {
                        //Senderliste
                        String str[] = daten.filmeLaden.getListeSender(); //um das Array in der Länge zu erhalten
                        get(parser, event, Konstanten.SENDERLISTE, daten.filmeLaden.getListeSender(), str);
                        daten.filmeLaden.setSenderOn(str);
                    } else if (parser.getLocalName().equals(Konstanten.PROGRAMMGRUPPE_ABO)) {
                        //Programmgruppen
                        datenPgruppe = new DatenPgruppe();
                        if (get(parser, event, Konstanten.PROGRAMMGRUPPE_ABO, Konstanten.PROGRAMMGRUPPE_COLUMN_NAMES, datenPgruppe.arr)) {
                            daten.listePgruppeAbo.add(datenPgruppe);
                        }
                    } else if (parser.getLocalName().equals(Konstanten.PROGRAMMGRUPPE_BUTTON)) {
                        datenPgruppe = new DatenPgruppe();
                        if (get(parser, event, Konstanten.PROGRAMMGRUPPE_BUTTON, Konstanten.PROGRAMMGRUPPE_COLUMN_NAMES, datenPgruppe.arr)) {
                            daten.listePgruppeButton.add(datenPgruppe);
                        }
                    } else if (parser.getLocalName().equals(Konstanten.PROGRAMM)) {
                        DatenProg datenProg = new DatenProg();
                        if (get(parser, event, Konstanten.PROGRAMM, Konstanten.PROGRAMM_COLUMN_NAMES, datenProg.arr)) {
                            if (datenPgruppe == null) {
                                //beim update von 1.x auf 2.0.0
                            } else {
                                datenPgruppe.addProg(datenProg);
                            }
                        }
                        //ende Programgruppen
                    } else if (parser.getLocalName().equals(Konstanten.ABO)) {
                        //Abo
                        DatenAbo datenAbo = new DatenAbo();
                        if (get(parser, event, Konstanten.ABO, Konstanten.ABO_COLUMN_NAMES, datenAbo.arr)) {
                            if (!Boolean.parseBoolean(datenAbo.arr[Konstanten.ABO_EINMAL_ERLEDIGT_NR])) {
                                // keine fertigen Einmalabos laden
                                daten.listeAbo.addAbo(datenAbo);
                            }
                        }
                    } else if (parser.getLocalName().equals(Konstanten.BLACKLIST)) {
                        //Blacklist
                        DatenBlacklist blacklist = new DatenBlacklist();
                        if (get(parser, event, Konstanten.BLACKLIST, Konstanten.BLACKLIST_COLUMN_NAMES, blacklist.arr)) {
                            daten.listeBlacklist.add(blacklist);
                        }
                    } else if (parser.getLocalName().equals(Konstanten.POD)) {
                        //Pod
                        DatenPod datenPod = new DatenPod();
                        if (get(parser, event, Konstanten.POD, Konstanten.POD_COLUMN_NAMES, datenPod.arr)) {
                            daten.listePod.addPod(datenPod);
                        }
                    } else if (parser.getLocalName().equals(Konstanten.FILM_UPDATE)) {
                        //Filmliste update
                        DatenFilmUpdate datenFilmUpdate = new DatenFilmUpdate();
                        if (get(parser, event, Konstanten.FILM_UPDATE, Konstanten.FILM_UPDATE_COLUMN_NAMES, datenFilmUpdate.arr)) {
                            daten.listeFilmUpdate.addAlle(datenFilmUpdate);
                        }
                    }
                }
            }
        } catch (Exception ex) {
            daten.fehler.fehlerMeldung(ex, "IoXml.datenLesen");
            ret = false;
        } finally {
            if (!daten.noGui) {
                if (daten.system[Konstanten.SYSTEM_ZIELPFAD_POD_NR].equals("")) {
                    Funktionen.addStandardPodcast(daten);
                }
                //fürs update
                if (daten.listePgruppeAbo.size() == 0) {
                    Funktionen.addStandardprogrammeAbo(daten);
                }
                if (daten.listePgruppeButton.size() == 0) {
                    Funktionen.addStandardprogrammeButton(daten);
                }
                ret = false;
                //updateListe aufbauen
                daten.listeFilmUpdate.check20(Boolean.parseBoolean(daten.system[Konstanten.SYSTEM_UPDATE_20_NR]));
            }
        }
        return ret;

    }

    private boolean xmlDatenLesenFilme() {
        boolean ret = true;
        try {
            String datei = "";
            datei = daten.getBasisVerzeichnis(false) + Konstanten.XML_DATEI_FILME;
            int event;
            XMLInputFactory inFactory = XMLInputFactory.newInstance();
            inFactory.setProperty(XMLInputFactory.IS_COALESCING, Boolean.FALSE);
            XMLStreamReader parser = null;
            InputStreamReader in = null;
            in = new InputStreamReader(new FileInputStream(datei), Konstanten.KODIERUNG_UTF);
            parser = inFactory.createXMLStreamReader(in);
            ret = datenLesenFilme(parser);
        } catch (Exception ex) {
            ret = false;
        }
        return ret;
    }

    private boolean xmlDatenLesenPodster() {
        boolean ret = true;
        try {
            String datei = "";
            datei = daten.getBasisVerzeichnis(false) + Konstanten.XML_DATEI_PODCASTER;
            int event;
            XMLInputFactory inFactory = XMLInputFactory.newInstance();
            inFactory.setProperty(XMLInputFactory.IS_COALESCING, Boolean.FALSE);
            XMLStreamReader parser = null;
            InputStreamReader in = null;
            in = new InputStreamReader(new FileInputStream(datei), Konstanten.KODIERUNG_UTF);
            parser = inFactory.createXMLStreamReader(in);
            ret = datenLesenPodster(parser);
        } catch (Exception ex) {
//            daten.fehler.fehlermeldung(ex, "IoXml.datenLesen");
            ret = false;
        }
        return ret;
    }

    private boolean datenLesenFilme(XMLStreamReader parser) {
        // alle Filme laden
        return datenLesenFilme(parser, true, "");
    }

    private boolean datenLesenFilme(XMLStreamReader parser, boolean auchAlte, String text) {
        boolean ret = true;
        text = Funktionen.textLaenge(text);
        try {
            int event;
            while (!stop && parser.hasNext()) {
                event = parser.next();
//                String t = new String();
//                t = parser.getLocalName();
                //Filmeliste
                if (event == XMLStreamConstants.START_ELEMENT) {
                    if (parser.getLocalName().equals(Konstanten.FILMLISTE)) {
                        get(parser, event, Konstanten.FILMLISTE, Konstanten.FILMLISTE_COLUMN_NAMES, daten.filmeLaden.filmlisteMetaDaten);
                        int anz = 1;
                        try {
                            anz = Integer.parseInt(daten.filmeLaden.filmlisteMetaDaten[Konstanten.FILMLISTE_ANZAHL_NR]);
                        } catch (Exception ex) {
                        } finally {
                            this.addMax(anz);
                        }
                    }
                }
                //Filme
                if (event == XMLStreamConstants.START_ELEMENT) {
                    if (parser.getLocalName().equals(Konstanten.FILME)) {
                        DatenFilm datenFilm = new DatenFilm(daten);
                        if (get(parser, event, Konstanten.FILME, Konstanten.FILME_COLUMN_NAMES, datenFilm.arr)) {
                            this.notifyProgress(text);
                            daten.filmeLaden.listeFilmeSchattenliste.add(datenFilm);
                        }
                    }
                }
            }
        } catch (Exception ex) {
            ret = false;
        }
        return ret;
    }

    private boolean datenLesenPodster(XMLStreamReader parser) {
        boolean ret = true;
        try {
            int event;
            while (parser.hasNext()) {
                event = parser.next();
                //Podstcasts
                if (event == XMLStreamConstants.START_ELEMENT) {
                    if (parser.getLocalName().equals(Konstanten.PODSTER)) {
                        DatenPodster datenPodster = new DatenPodster();
                        if (get(parser, event, Konstanten.PODSTER, Konstanten.PODSTER_COLUMN_NAMES, datenPodster.arr)) {
                            daten.listePodster.add(datenPodster);
                        }
                    }
                }
            }
        } catch (Exception ex) {
//            daten.fehler.fehlermeldung(ex, "IoXml.datenLesen");
            ret = false;
        }
        return ret;
    }

    private boolean get(XMLStreamReader parser, int event, String xmlElem, String[] xmlNames, String[] strRet) {
        boolean ret = true;
        int maxElem = strRet.length;
        for (int i = 0; i < maxElem; ++i) {
            strRet[i] = "";
        }
        try {
            while (parser.hasNext()) {
                event = parser.next();
                if (event == XMLStreamConstants.END_ELEMENT) {
                    if (parser.getLocalName().equals(xmlElem)) {
                        break;
                    }
                }
                if (event == XMLStreamConstants.START_ELEMENT) {
                    for (int i = 0; i < maxElem; ++i) {
                        if (parser.getLocalName().equals(xmlNames[i])) {
                            strRet[i] = parser.getElementText();
                            break;
                        }
                    }
                }
            }
        } catch (Exception ex) {
            ret = false;
            daten.fehler.fehlerMeldung(ex, "IoXml.get");
        }
        return ret;
    }

    public synchronized void datenSchreiben() {
        stop = false;
        xmlDatenSchreiben();
        xmlFilmeSchreiben();
        xmlPodcastlisteSchreiben();
        daten.history.speichern();
    }

    public synchronized void filmeSchreiben() {
        stop = false;
        xmlFilmeSchreiben();
    }

    public synchronized void exportFilme(String datei) {
        stop = false;
        try {
            daten.fehler.systemMeldung("Filme exportieren nach: " + datei);
            xmlSchreibenStart(datei);
            xmlSchreibenFilmliste();
            xmlSchreibenFilm();
            xmlSchreibenEnde(datei);
        } catch (Exception ex) {
            daten.fehler.fehlerMeldung(ex, "Filme exportieren nach: " + datei);
        }
    }

    private void xmlDatenSchreiben() {
        try {
            daten.fehler.systemMeldung("Daten schreiben!");
            xmlSchreibenStart(daten.getBasisVerzeichnis(true) + Konstanten.XML_DATEI);
            xmlSchreibenSystem();
            xmlSchreibenProg();
            xmlSchreibenAbo();
            xmlSchreibenBlackList();
            xmlSchreibenPod();
            xmlSchreibenFilmUpdate();
            xmlSchreibenEnde();
        } catch (Exception ex) {
        }
    }

    private void xmlFilmeSchreiben() {
        try {
            daten.fehler.systemMeldung("Filme schreiben!");
            xmlSchreibenStart(daten.getBasisVerzeichnis(true) + Konstanten.XML_DATEI_FILME);
            xmlSchreibenFilmliste();
            xmlSchreibenFilm();
            xmlSchreibenEnde();
        } catch (Exception ex) {
            daten.fehler.fehlerMeldung(ex, "IoXml.xmlFilmeSchreiben");
        }
    }

    private void xmlPodcastlisteSchreiben() {
        try {
            daten.fehler.systemMeldung("Podcastliste schreiben!");
            xmlSchreibenStart(daten.getBasisVerzeichnis(true) + Konstanten.XML_DATEI_PODCASTER);
            xmlSchreibenPodcastliste();
            xmlSchreibenEnde();
        } catch (Exception ex) {
        }
    }

    private void xmlSchreibenStart(String datei) throws Exception {
        File file = new File(datei);
        System.out.println("Datei schreiben: " + file.getAbsolutePath());
        outFactory = XMLOutputFactory.newInstance();
        if (datei.endsWith(Konstanten.FORMAT_BZ2)) {
            bZip2CompressorOutputStream = new BZip2CompressorOutputStream(new FileOutputStream(file), 2);
            out = new OutputStreamWriter(bZip2CompressorOutputStream, Konstanten.KODIERUNG_UTF);
        } else if (datei.endsWith(Konstanten.FORMAT_ZIP)) {
            zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
            ZipEntry entry = new ZipEntry(Konstanten.XML_DATEI_FILME);
            zipOutputStream.putNextEntry(entry);
            out = new OutputStreamWriter(zipOutputStream, Konstanten.KODIERUNG_UTF);
        } else {
            out = new OutputStreamWriter(new FileOutputStream(file), Konstanten.KODIERUNG_UTF);
        }
        writer = outFactory.createXMLStreamWriter(out);
        writer.writeStartDocument("UTF-8", "1.0");
        writer.writeCharacters("\n");//neue Zeile
        writer.writeStartElement(Konstanten.XML_START);
        writer.writeCharacters("\n");//neue Zeile
    }

    private void xmlSchreibenSystem() {
        //System schreibem
        xmlSchreibenDaten(Konstanten.SYSTEM, Konstanten.SYSTEM_COLUMN_NAMES, daten.system);
        //Senderliste
        xmlSchreibenDaten(Konstanten.SENDERLISTE, daten.filmeLaden.getListeSender(), daten.filmeLaden.getSenderOn());
    }

    private void xmlSchreibenFilmliste() {
        //Filmliste schreiben
        xmlSchreibenDaten(Konstanten.FILMLISTE, Konstanten.FILMLISTE_COLUMN_NAMES, daten.filmeLaden.filmlisteMetaDaten);
    }

    private void xmlSchreibenPodcastliste() {
        //Podcastliste schreiben
        ListIterator<DatenPodster> iterator;
        //Filme schreibem
        DatenPodster datenPodster;
        iterator = daten.listePodster.listIterator();
        while (iterator.hasNext()) {
            datenPodster = iterator.next();
            xmlSchreibenDaten(Konstanten.PODSTER, Konstanten.PODSTER_COLUMN_NAMES, datenPodster.arr);
        }
    }

    private void xmlSchreibenFilm() {
        ListIterator<DatenFilm> iterator;
        //Filme schreiben
        DatenFilm datenFilm;
        iterator = daten.filmeLaden.listeFilmeSchattenliste.listIterator();
        while (iterator.hasNext()) {
            datenFilm = iterator.next();
            xmlSchreibenDaten(Konstanten.FILME, Konstanten.FILME_COLUMN_NAMES, datenFilm.getClean().arr);
        }
    }

    private void xmlSchreibenProg() {
        ListIterator<DatenPgruppe> iterator;
        //Proggruppen schreiben
        DatenPgruppe datenPgruppe;
        iterator = daten.listePgruppeAbo.listIterator();
        ListIterator<DatenProg> it;
        while (iterator.hasNext()) {
            datenPgruppe = iterator.next();
            xmlSchreibenDaten(Konstanten.PROGRAMMGRUPPE_ABO, Konstanten.PROGRAMMGRUPPE_COLUMN_NAMES, datenPgruppe.arr);
            it = datenPgruppe.getListeProg().listIterator();
            while (it.hasNext()) {
                xmlSchreibenDaten(Konstanten.PROGRAMM, Konstanten.PROGRAMM_COLUMN_NAMES, it.next().arr);
            }
        }
        iterator = daten.listePgruppeButton.listIterator();
        while (iterator.hasNext()) {
            datenPgruppe = iterator.next();
            xmlSchreibenDaten(Konstanten.PROGRAMMGRUPPE_BUTTON, Konstanten.PROGRAMMGRUPPE_COLUMN_NAMES, datenPgruppe.arr);
            it = datenPgruppe.getListeProg().listIterator();
            while (it.hasNext()) {
                xmlSchreibenDaten(Konstanten.PROGRAMM, Konstanten.PROGRAMM_COLUMN_NAMES, it.next().arr);
            }
        }
    }

    private void xmlSchreibenAbo() {
        ListIterator<DatenAbo> iterator;
        //Abo schreibem
        DatenAbo datenAbo;
        iterator = daten.listeAbo.listIterator();
        while (iterator.hasNext()) {
            datenAbo = iterator.next();
            xmlSchreibenDaten(Konstanten.ABO, Konstanten.ABO_COLUMN_NAMES, datenAbo.arr);
        }
    }

    private void xmlSchreibenBlackList() {
        Iterator<DatenBlacklist> it = daten.listeBlacklist.iterator();
        //Blacklist schreibem
        DatenBlacklist blacklist;
        while (it.hasNext()) {
            blacklist = it.next();
            xmlSchreibenDaten(Konstanten.BLACKLIST, Konstanten.BLACKLIST_COLUMN_NAMES, blacklist.arr);
        }
    }

    private void xmlSchreibenPod() {
        ListIterator<DatenPod> iterator;
        //Pod schreibem
        DatenPod datenPod;
        iterator = daten.listePod.listIterator();
        while (iterator.hasNext()) {
            datenPod = iterator.next();
            xmlSchreibenDaten(Konstanten.POD, Konstanten.POD_COLUMN_NAMES, datenPod.arr);
        }
    }

    private void xmlSchreibenFilmUpdate() {
        ListIterator<DatenFilmUpdate> iterator;
        //FilmUpdate schreibem
        DatenFilmUpdate datenFilmUpdate;
        iterator = daten.listeFilmUpdate.alle.listIterator();
        while (iterator.hasNext()) {
            datenFilmUpdate = iterator.next();
            xmlSchreibenDaten(Konstanten.FILM_UPDATE, Konstanten.FILM_UPDATE_COLUMN_NAMES, datenFilmUpdate.arr);
        }
    }

    private void xmlSchreibenDaten(String xmlName, String[] xmlSpalten, String[] datenArray) {
        int xmlMax = datenArray.length;
        try {
            writer.writeStartElement(xmlName);
            for (int i = 0; i < xmlMax; ++i) {
                if (!datenArray[i].equals("")) {
                    writer.writeStartElement(xmlSpalten[i]);
                    writer.writeCharacters(datenArray[i]);
                    writer.writeEndElement();
//                } else {
//                    writer.writeEmptyElement(xmlSpalten[i]);
                }
            }
            writer.writeEndElement();
            writer.writeCharacters("\n");//neue Zeile
        } catch (Exception ex) {
            daten.fehler.fehlerMeldung(ex, "IoXml.xmlSchreibenDaten");
        }
    }

    private void xmlSchreibenEnde() throws Exception {
        xmlSchreibenEnde("");
    }

    private void xmlSchreibenEnde(String datei) throws Exception {
        writer.writeEndElement();
        writer.writeEndDocument();
        writer.flush();
        if (datei.endsWith(Konstanten.FORMAT_BZ2)) {
            writer.close();
            bZip2CompressorOutputStream.close();
        } else if (datei.endsWith(Konstanten.FORMAT_ZIP)) {
            zipOutputStream.closeEntry();
            writer.close();
            zipOutputStream.close();
        } else {
            writer.close();
        }
        daten.fehler.systemMeldung("geschrieben!");
    }

    private void notifyStart(int max) {
        for (FilmListener l : listeners.getListeners(FilmListener.class)) {
            l.start("", max);
        }
    }

    private void addMax(int max) {
        for (FilmListener l : listeners.getListeners(FilmListener.class)) {
            l.addMax("", max);
        }
    }

    private void notifyProgress(String text) {
        for (FilmListener l : listeners.getListeners(FilmListener.class)) {
            l.progress("", text);
        }
    }

    private void notifyFertig() {
        daten.fehler.systemMeldung("Liste Filme gelesen: " + Funktionen.getJetzt_HH_MM_SS());
        for (FilmListener l : listeners.getListeners(FilmListener.class)) {
            l.fertig("", false);
        }
    }
}
