/*
 *    Copyright (C) 2008
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mediathek.gui.menue;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import mediathek.Funktionen;
import mediathek.Konstanten;
import mediathek.daten.Daten;
import mediathek.daten.DatenFilmUpdate;
import mediathek.gui.PanelVorlage;
import mediathek.update.UpdateSuchen;

public class PanelImportFilme extends PanelVorlage {

    public boolean ok = false;
    public String ziel;

    public PanelImportFilme(Daten d) {
        super(d);
        initComponents();
        init();
        jButtonUpdate.addActionListener(new BeobSuchen());
        jRadioButtonUpdateAus.addActionListener(new BeobOption());
        jRadioButtonUrl.addActionListener(new BeobOption());
        jRadioButtonStart.addActionListener(new BeobOption());
        jRadioButtonAuto.addActionListener(new BeobOption());
        jCheckBox20.addActionListener(new BeobCheckBox20());
        jTable1.getSelectionModel().addListSelectionListener(new BeobachterTableSelect1());
    }

    @Override
    public void neuLaden() {
        init();
    }

    private void init() {
        jRadioButtonStart.setSelected(Funktionen.getUpdateFilme(daten) == Konstanten.UPDATE_FILME_START);
        jRadioButtonAuto.setSelected(Funktionen.getUpdateFilme(daten) == Konstanten.UPDATE_FILME_AUTO);
        jRadioButtonUrl.setSelected(Funktionen.getUpdateFilme(daten) == Konstanten.UPDATE_FILME_URL);
        jRadioButtonUpdateAus.setSelected(Funktionen.getUpdateFilme(daten) == Konstanten.UPDATE_FILME_AUS);
        jTextFieldUrl.setText(daten.system[Konstanten.SYSTEM_IMPORT_URL_AUTO_NR]);
        jCheckBox20.setSelected(Boolean.parseBoolean(daten.system[Konstanten.SYSTEM_UPDATE_20_NR]));
        tabelleLaden();
    }

    private void updateSuchen() {
        new UpdateSuchen(daten).suchen(false); //neue Url wird eingetragen
        stopBeob = true;
        jTextFieldUrl.setText(daten.system[Konstanten.SYSTEM_IMPORT_URL_AUTO_NR]);
        tabelleLaden();
        daten.setGeaendertSofort();
        stopBeob = false;
    }

    private void tabelleLaden() {
        DefaultTableModel model = new DefaultTableModel(daten.listeFilmUpdate.getTableObjectData(), Konstanten.FILM_UPDATE_COLUMN_NAMES_ANZEIGE) {

            @Override
            public boolean isCellEditable(int i, int j) {
                return false;
            }
        };
        jTable1.setModel(model);
        for (int i = 0; i < jTable1.getColumnCount(); ++i) {
            if (i == Konstanten.FILM_UPDATE_URL_NR) {
                jTable1.getColumnModel().getColumn(i).setMinWidth(10);
                jTable1.getColumnModel().getColumn(i).setMaxWidth(3000);
                jTable1.getColumnModel().getColumn(i).setPreferredWidth(350);
            } else if (i == Konstanten.FILM_UPDATE_PRIO_NR || i == Konstanten.FILM_UPDATE_ANZAHL_NR) {
                jTable1.getColumnModel().getColumn(i).setMinWidth(0);
                jTable1.getColumnModel().getColumn(i).setMaxWidth(0);
                jTable1.getColumnModel().getColumn(i).setPreferredWidth(0);
            } else {
                jTable1.getColumnModel().getColumn(i).setMinWidth(10);
                jTable1.getColumnModel().getColumn(i).setMaxWidth(3000);
                jTable1.getColumnModel().getColumn(i).setPreferredWidth(100);
            }
        }
    }

    private void table1Select() {
        stopBeob = true;
        DatenFilmUpdate aktUpdate = null;
        int selectedTableRow = jTable1.getSelectedRow();
        if (selectedTableRow >= 0) {
            aktUpdate = daten.listeFilmUpdate.getNrUpdate(jTable1.getModel().getValueAt(jTable1.convertRowIndexToModel(selectedTableRow),
                    Konstanten.FILM_UPDATE_URL_NR).toString());
        }
        if (aktUpdate != null) {
            jTextFieldUrl.setText(aktUpdate.arr[Konstanten.FILM_UPDATE_URL_NR]);
            daten.setGeaendertSofort();
            daten.system[Konstanten.SYSTEM_IMPORT_URL_AUTO_NR] = aktUpdate.arr[Konstanten.FILM_UPDATE_URL_NR];
        }
        stopBeob = false;
    }

    private void tabelleSelSetzten() {
        stopBeob = true;
        boolean gefunden = false;
        for (int i = 0; i < Konstanten.FILME_MAX_ELEM; ++i) {
            if (jTable1.getModel().getValueAt(jTable1.convertRowIndexToModel(i), Konstanten.FILM_UPDATE_URL_NR).equals(
                    daten.system[Konstanten.SYSTEM_IMPORT_URL_AUTO_NR])) {
                gefunden = true;
                jTable1.setRowSelectionInterval(i, i);
                jTable1.scrollRectToVisible(jTable1.getCellRect(i, 0, false));
                break;
            }
        }
        if (!gefunden) {
            jTable1.getSelectionModel().clearSelection();
        }
        stopBeob = false;
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroup1 = new javax.swing.ButtonGroup();
        jPanel1 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTable1 = new javax.swing.JTable();
        jPanel6 = new javax.swing.JPanel();
        jPanel2 = new javax.swing.JPanel();
        jRadioButtonUpdateAus = new javax.swing.JRadioButton();
        jRadioButtonUrl = new javax.swing.JRadioButton();
        jPanel3 = new javax.swing.JPanel();
        jRadioButtonStart = new javax.swing.JRadioButton();
        jRadioButtonAuto = new javax.swing.JRadioButton();
        jPanel4 = new javax.swing.JPanel();
        jButtonUpdate = new javax.swing.JButton();
        jLabel1 = new javax.swing.JLabel();
        jTextFieldUrl = new javax.swing.JTextField();
        jCheckBox20 = new javax.swing.JCheckBox();

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(51, 51, 255), 2), "Filme importieren"));

        jTable1.setAutoCreateRowSorter(true);
        jTable1.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null}
            },
            new String [] {
                "Title 1", "Title 2", "Title 3", "Title 4"
            }
        ));
        jScrollPane1.setViewportView(jTable1);

        jPanel6.setBorder(new javax.swing.border.SoftBevelBorder(javax.swing.border.BevelBorder.LOWERED));

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 153)), "Filme manuell importieren"));

        buttonGroup1.add(jRadioButtonUpdateAus);
        jRadioButtonUpdateAus.setText("Alles manuell");

        buttonGroup1.add(jRadioButtonUrl);
        jRadioButtonUrl.setText("URL automatisch wählen");

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jRadioButtonUpdateAus)
                .addGap(18, 18, 18)
                .addComponent(jRadioButtonUrl)
                .addContainerGap(462, Short.MAX_VALUE))
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jRadioButtonUpdateAus)
                    .addComponent(jRadioButtonUrl))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jPanel3.setBorder(javax.swing.BorderFactory.createTitledBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 153)), "Filme automatisch importieren"));

        buttonGroup1.add(jRadioButtonStart);
        jRadioButtonStart.setText("Filme beim Start laden und URL automatisch wählen");

        buttonGroup1.add(jRadioButtonAuto);
        jRadioButtonAuto.setText("Filme beim Start und alle 75 Minuten laden, URL automatisch wählen");

        javax.swing.GroupLayout jPanel3Layout = new javax.swing.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jRadioButtonStart)
                    .addComponent(jRadioButtonAuto))
                .addContainerGap(288, Short.MAX_VALUE))
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addComponent(jRadioButtonStart)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jRadioButtonAuto)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout jPanel6Layout = new javax.swing.GroupLayout(jPanel6);
        jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(
            jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel6Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jPanel3, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanel2, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );
        jPanel6Layout.setVerticalGroup(
            jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel6Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jPanel3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jPanel4.setBorder(new javax.swing.border.SoftBevelBorder(javax.swing.border.BevelBorder.LOWERED));

        jButtonUpdate.setText("URL's aktualisieren");

        jLabel1.setText("URL:");

        jTextFieldUrl.setEditable(false);

        jCheckBox20.setText("nur \"Nach 20 Uhr\"");

        javax.swing.GroupLayout jPanel4Layout = new javax.swing.GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel4Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel4Layout.createSequentialGroup()
                        .addComponent(jLabel1)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jTextFieldUrl, javax.swing.GroupLayout.DEFAULT_SIZE, 773, Short.MAX_VALUE)
                        .addContainerGap())
                    .addGroup(jPanel4Layout.createSequentialGroup()
                        .addComponent(jButtonUpdate)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 491, Short.MAX_VALUE)
                        .addComponent(jCheckBox20)
                        .addGap(18, 18, 18))))
        );
        jPanel4Layout.setVerticalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel4Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jTextFieldUrl, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel1))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addComponent(jButtonUpdate)
                    .addComponent(jCheckBox20))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jPanel4Layout.linkSize(javax.swing.SwingConstants.VERTICAL, new java.awt.Component[] {jButtonUpdate, jLabel1, jTextFieldUrl});

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 847, Short.MAX_VALUE)
                    .addComponent(jPanel6, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanel4, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 197, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jPanel4, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jPanel6, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, 545, Short.MAX_VALUE)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JButton jButtonUpdate;
    private javax.swing.JCheckBox jCheckBox20;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel6;
    private javax.swing.JRadioButton jRadioButtonAuto;
    private javax.swing.JRadioButton jRadioButtonStart;
    private javax.swing.JRadioButton jRadioButtonUpdateAus;
    private javax.swing.JRadioButton jRadioButtonUrl;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTable jTable1;
    private javax.swing.JTextField jTextFieldUrl;
    // End of variables declaration//GEN-END:variables

    private class BeobSuchen implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            updateSuchen();
        }
    }

    private class BeobOption implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!stopBeob) {
                if (jRadioButtonUpdateAus.isSelected()) {
                    daten.system[Konstanten.SYSTEM_UPDATE_FILME_NR] = String.valueOf(Konstanten.UPDATE_FILME_AUS);
                } else if (jRadioButtonUrl.isSelected()) {
                    daten.system[Konstanten.SYSTEM_UPDATE_FILME_NR] = String.valueOf(Konstanten.UPDATE_FILME_URL);
                } else if (jRadioButtonStart.isSelected()) {
                    daten.system[Konstanten.SYSTEM_UPDATE_FILME_NR] = String.valueOf(Konstanten.UPDATE_FILME_START);
                } else {
                    daten.system[Konstanten.SYSTEM_UPDATE_FILME_NR] = String.valueOf(Konstanten.UPDATE_FILME_AUTO);
                    daten.timerLaden.reset();
                }
                daten.setGeaendert();
            }
        }
    }

    private class BeobCheckBox20 implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!stopBeob) {
                daten.system[Konstanten.SYSTEM_UPDATE_20_NR] = Boolean.toString(jCheckBox20.isSelected());
                daten.listeFilmUpdate.check20(Boolean.parseBoolean(daten.system[Konstanten.SYSTEM_UPDATE_20_NR]));
                tabelleLaden();
                daten.system[Konstanten.SYSTEM_IMPORT_URL_AUTO_NR] = daten.listeFilmUpdate.getRand(0); //eine Zufällige Adresse wählen
                tabelleSelSetzten();
                daten.setGeaendertSofort();
            }
        }
    }

    private class BeobachterTableSelect1 implements ListSelectionListener {

        public int selectedModelRow = -1;

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (!stopBeob) {
                if (!event.getValueIsAdjusting()) {
                    table1Select();
                }
            }
        }
    }
}
