/*
 *    Copyright (C) 2008
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mediathek.filme.sender;

import mediathek.Funktionen;
import mediathek.Konstanten;
import mediathek.daten.Daten;
import mediathek.filme.DatenFilm;

public class Mediathek3Sat extends MediathekReader implements Runnable {

    private StringBuffer seite = new StringBuffer();

    public Mediathek3Sat(Daten ddaten) {
        super(ddaten);
        sender = Konstanten.SENDER_3SAT;
        text = "3sat  (ca. 3 MB, 450 Filme)";
    }

    /**
     *
     * @param daten
     * @param film
     * @return
     */
//    public static String leitungAendern(Daten daten, DatenFilm film) {
//        return leitungAendern__(daten, film.arr[Konstanten.FILM_URL_ORG_NR]);
//    }
//
//    private static String leitungAendern__(Daten daten, String urlOrg) {
//        String url;
//        if (daten.system[Konstanten.SYSTEM_LEITUNG_NR].equals(Konstanten.LEITUNG_DSL1000)) {
//            url = urlOrg;
//        } else {
//            url = urlOrg.replace("/300/", "/veryhigh/");
//        }
//        return url;
//    }
    private class ThemaLaden implements Runnable {

        @Override
        public synchronized void run() {
            notifyStart(1);
            addThread();
            try {
                laden();
            } catch (Exception ex) {
            }
            threadUndFertig();
        }
    }

    @Override
    void addToList() {
        new Thread(new ThemaLaden()).start();
    }

    void laden() {
        //Liste von http://www.3sat.de/mediathek/rss/mediathek.xml holen
        final String MUSTER_URL = "type=\"video/x-ms-asf\" url=\"";
        final String MUSTER_TITEL = "<title>";
        final String MUSTER_DATUM = "<pubDate>";
        final String MUSTER_LINK = "<link>";
        final String ADRESSE = "http://www.3sat.de/mediathek/rss/mediathek.xml";
        this.notifyProgress(ADRESSE);
        seite = getUrlIo.getUri_Utf(sender, ADRESSE, seite, "");
        int pos = 0;
        int pos1 = 0;
        int pos2 = 0;
        String url = "";
        String thema = "";
        String link = "";
        String datum = "";
        String zeit = "";
        String titel = "";
        String tmp = "";
        if ((pos = seite.indexOf(MUSTER_TITEL, pos)) == -1) {
            return;
        }//für den HTML-Titel
        pos += MUSTER_TITEL.length();
        if ((pos = seite.indexOf(MUSTER_TITEL, pos)) == -1) {
            return;
        }//für den HTML-Titel
        pos += MUSTER_TITEL.length();
        while ((pos = seite.indexOf(MUSTER_TITEL, pos)) != -1) {
            pos += MUSTER_TITEL.length();
            url = "";
            thema = "";
            link = "";
            datum = "";
            zeit = "";
            titel = "";
            tmp = "";
            try {
                pos1 = pos;
                if ((pos2 = seite.indexOf("<", pos1)) != -1) {
                    titel = seite.substring(pos1, pos2);
                    thema = sender;
                    if (titel.contains(":") && (titel.indexOf(":") + 1) < titel.length()) {
                        //enthält : und ist nicht das letztes zeichen
                        thema = titel.substring(0, titel.indexOf(":"));
                        titel = titel.substring(titel.indexOf(":") + 1);
                    }
                    titel = titel.trim();
                    if (!titel.equals("")) {
                        while (titel.charAt(0) == '\u00A0') {
                            titel = titel.substring(1);
                            if (titel.equals("")) {
                                break;
                            }
                        }
                    }
                }
                if ((pos1 = seite.indexOf(MUSTER_DATUM, pos)) != -1) {
                    pos1 += MUSTER_DATUM.length();
                    if ((pos2 = seite.indexOf("<", pos1)) != -1) {
                        //<pubDate>Mon, 03 Jan 2011 17:06:16 +0100</pubDate>
                        tmp = seite.substring(pos1, pos2);
                        if (tmp.equals("")) {
                            daten.fehler.fehlerMeldung("Fehler!", "Mediathek3Sat.addToList: keine Datum");
                        } else {
                            datum = Funktionen.convertDatum(daten, tmp);
                            zeit = Funktionen.convertTime(daten, tmp);
                        }
                    }
                }
                if ((pos1 = seite.indexOf(MUSTER_LINK, pos)) != -1) {
                    pos1 += MUSTER_LINK.length();
                    if ((pos2 = seite.indexOf("<", pos1)) != -1) {
                        //<link>http://www.3sat.de/mediathek/?obj=20937</link>
                        link = seite.substring(pos1, pos2);
                    }
                }
                if ((pos1 = seite.indexOf(MUSTER_URL, pos)) != -1) {
                    pos1 += MUSTER_URL.length();
                    if ((pos2 = seite.indexOf("\"", pos1)) != -1) {
                        url = seite.substring(pos1, pos2);
                    }
                }
                if (url.equals("")) {
                    daten.fehler.fehlerMeldung("Fehler!", "Mediathek3Sat.addToList: keine URL");
                } else {
                    url = url.replace("/300/", "/veryhigh/");
                    //    public DatenFilm(Daten ddaten, String ssender, String tthema, String urlThema, String ttitel, String uurl, String datum) {
                    daten.filmeLaden.listeFilmeSchattenliste.addSenderRtmp(new DatenFilm(daten, sender, thema, link, titel, url, datum, zeit));
                }
            } catch (Exception ex) {
                daten.fehler.fehlerMeldung(ex, "Mediathek3Sat.addToList");
            }
        } //while, die ganz große Schleife
    }
}
