C*  This file is part of MED.
C*
C*  COPYRIGHT (C) 1999 - 2011  EDF R&D, CEA/DEN
C*  MED is free software: you can redistribute it and/or modify
C*  it under the terms of the GNU Lesser General Public License as published by
C*  the Free Software Foundation, either version 3 of the License, or
C*  (at your option) any later version.
C*
C*  MED is distributed in the hope that it will be useful,
C*  but WITHOUT ANY WARRANTY; without even the implied warranty of
C*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C*  GNU Lesser General Public License for more details.
C*
C*  You should have received a copy of the GNU Lesser General Public License
C*  along with MED.  If not, see <http://www.gnu.org/licenses/>.
C*

C******************************************************************************
C * How to create an structured mesh
C * Use case 4 : write a 2D structured mesh (5x3 cartesian grid)
C * - Computation step : NO
C *
C *****************************************************************************
      program UsesCase_MEDmesh_4
C     
      implicit none
      include 'med.hf'
C
C     
      integer cret
      integer fid
      integer sdim, mdim, stype, mtype, atype
      character*200 mdesc
      character*64  fname
      character*64 mname
      character*16 nomcoo(2)
      character*16 unicoo(2)
      character*16 dtunit
      parameter (fname = "UsesCase_MEDmesh_4.med")  
      parameter (mdesc = "A 2D structured mesh")
      parameter (mname = "2D unstructured mesh")  
      parameter (sdim = 2, mdim = 2)
      parameter (stype=MED_SORT_DTIT, mtype=MED_STRUCTURED_MESH)
      parameter (atype=MED_CARTESIAN_GRID)
      data  dtunit /""/
      data  nomcoo /"x               ","y               "/
      data  unicoo /"cm              ","cm              "/
C 
C
C     file creation
      call mfiope(fid,fname,MED_ACC_CREAT,cret)
      print *,cret
      print *,fid
      if (cret .ne. 0 ) then
         print *,'ERROR : file creation'
         call efexit(-1)
      endif  
C
C
C     mesh creation
      call mmhcre(fid, mname, sdim, mdim, mtype,mdesc,
     &            dtunit, stype, atype, nomcoo, unicoo, cret)
      print *,cret
      if (cret .ne. 0 ) then
         print *,'ERROR : mesh creation'
         call efexit(-1)
      endif  
C
C
C     specify grid type
      call mmhgtw(fid,mname,MED_CARTESIAN_GRID,cret)
      print *,cret
      if (cret .ne. 0 ) then
         print *,'ERROR : write grid type'
         call efexit(-1)
      endif  
C
C
C     close file
      call mficlo(fid,cret)
      print *,cret
      if (cret .ne. 0 ) then
         print *,'ERROR :  close file'
         call efexit(-1)
      endif        
C
C
C
      end

