/*  This file is part of MED.
 *
 *  COPYRIGHT (C) 1999 - 2011  EDF R&D, CEA/DEN
 *  MED is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  MED is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with MED.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <med.h>
#include <med_config.h>
#include <med_outils.h>
#include <hdf5.h>


med_idt _MEDfileOpen(const char * const filename,const med_access_mode accessmode)
{

  med_idt _fid =-1;
  int     _hdf_mode=-1;
  switch(accessmode)
    {
    case MED_ACC_RDWR :
    case MED_ACC_RDEXT    :
      _hdf_mode = MED_ACC_RDWR;
      break;

    case MED_ACC_RDONLY :
      _hdf_mode = H5F_ACC_RDONLY;
      break;

    default :
      MED_ERR_(_fid,MED_ERR_RANGE,MED_ERR_ACCESS,filename);
      goto ERROR;
    }


  if ((_fid = H5Fopen(filename,_hdf_mode,H5P_DEFAULT)) < 0) {
    MED_ERR_(_fid,MED_ERR_OPEN,MED_ERR_FILE,"");
    ISCRUTE_int(accessmode);
/*     H5Eprint1(stderr); */
    goto ERROR;
  }

  _MEDsetModeAcces(_fid,accessmode);

 ERROR:

  return _fid;
}
