/*************************************************************************
* COPYRIGHT (C) 1999 - 2007  EDF R&D, CEA/DEN
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/
#include <string.h>

#define MESGERR

#ifdef __cplusplus
extern "C" {
#endif

#include "med_config.h"
#include "med_outils.h"

#ifdef __cplusplus
}
#endif

#include <hdf5.h>
#include "med21.h"
#include "med_hdfi21.h"
#include "MAJ_21_22.h"

void MAJ_21_22_profils(med_idt fid,med_int nprofil)
{
  med_err ret;
  med_int i;
  char nom[MED_TAILLE_NOM+1];
  char chemin[MED_TAILLE_DESC+1];
  med_idt gid;
  med_int att;

  for (i=0;i<nprofil;i++)
    {    
      /* on recupere le nom du profil */
      ret = _MEDobjetIdentifier(fid,MED_PROFILS,i,nom);
      EXIT_IF(ret < 0,"Identification d'un profil",NULL);
      fprintf(stdout,"  >>> Normalisation du profil [%s] \n",nom);

      /* on accede au profil */
      strcpy(chemin,MED_PROFILS);
      strcat(chemin,nom);
      gid = _MEDdatagroupOuvrir(fid,chemin); 
      EXIT_IF(gid < 0,"Accs au profil",nom);

      /* On change l'attribut MED_NOM_N => MED_NOM_NBR */
      ret = _MEDattrEntierLire(gid,"N",&att);
      EXIT_IF(ret < 0,"Lecture de l'attribut MED_NOM_N",NULL);
      ret = H5Adelete(gid,"N");
      EXIT_IF(ret < 0,"Destruction de l'attribut MED_NOM_N",NULL);
      ret = _MEDattrEntierEcrire(gid,(char *)(MED_NOM_NBR),&att);
      EXIT_IF(ret < 0,"Ecriture de l'attribut MED_NOM_NBR dans le profil ",nom);

      /* on ferme le profil */
      ret = _MEDdatagroupFermer(gid);
      EXIT_IF(ret < 0,"Fermeture de l'acces au profil",nom);

      fprintf(stdout,"  >>> Normalisation du profil [%s] effectue \n",nom);
    }
}


