/*************************************************************************
* COPYRIGHT (C) 1999 - 2007  EDF R&D, CEA/DEN
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/


/******************************************************************************
 * - Nom du fichier : test6.c
 *
 * - Description : ecriture d'elements dans un maillage MED
 *
 *****************************************************************************/

#include <med.h>
#define MESGERR
#include <med_utils.h>

#ifdef DEF_LECT_ECR
#define MODE_ACCES MED_LECTURE_ECRITURE
#elif DEF_LECT_AJOUT
#define MODE_ACCES MED_LECTURE_AJOUT
#else
#define MODE_ACCES MED_CREATION
#endif

int main (int argc, char **argv)


{
  med_idt fid;
  med_int nse2 = 5;
  med_int se2[10] = {1,2,1,3,2,4,3,4,2,3};
  /*                                12345678901234561234567890123456123456789012345612345678901234561234567890123456*/
  char nomse2[MED_TAILLE_PNOM*5+1]="se1             se2             se3             se4             se5             ";
  med_int numse2[5] = {1,2,3,4,5};
  med_int nufase2[5] = {-1,-1,0,-2,-3}; 
  med_int ntr3 = 2;
  med_int tr3[6] = {1,2,-5,-5,3,-4};
  /*                                  12345678901234561234567890123456*/
  char nomtr3[MED_TAILLE_PNOM*2+1] = "tr1             tr2             ";
  med_int numtr3[2] = {4,5};
  med_int nufatr3[2] = {0,-1};
  char maa[MED_TAILLE_NOM+1] = "maa1";
  med_int mdim = 2;

  /* ouverture du fichier */
  if ( (fid = MEDouvrir("test6.med",MODE_ACCES)) < 0) {
    MESSAGE("Impossible de creer le fichier test6.med : ");
    return -1;
  }
  
  /* creation du maillage */
  if ( MEDmaaCr(fid,maa,mdim,MED_NON_STRUCTURE,
		   "un maillage pour test6") < 0 ) {
    MESSAGE("Impossible de creer le maillage : ");
    return -1;
  }
  
  /* ecriture des connectivites des segments */
  if ( MEDconnEcr(fid,maa,mdim,se2,MED_FULL_INTERLACE,nse2,MED_ARETE,MED_SEG2,
		  MED_DESC) < 0 ) {
    MESSAGE("Impossible d'ecrire la connectivit des segments: ");
    return -1;
  }


  /* ecriture (optionnelle) des noms des segments */
  if ( MEDnomEcr(fid,maa,nomse2,nse2,MED_ARETE,MED_SEG2) < 0 ) {
    MESSAGE("Impossible d'ecrire les noms des segments : ");
    return -1;
  }
  
  /* ecriture (optionnelle) des numeros des segments */
  if ( MEDnumEcr(fid,maa,numse2,nse2,MED_ARETE,MED_SEG2) < 0 ) {
    MESSAGE("Impossible d'ecrire les numros des segments : ");
    return -1;
  }
  
    /* ecriture des numeros des familles des segments */
  if ( MEDfamEcr(fid,maa,nufase2,nse2,MED_ARETE,MED_SEG2) < 0 ) {
    MESSAGE("Impossible d'ecrire les numros de famille des segments : ");
    return -1;
  }

  /* ecriture des connectivites des triangles */
  if ( MEDconnEcr(fid,maa,mdim,tr3,MED_FULL_INTERLACE,ntr3,MED_MAILLE,MED_TRIA3,
		     MED_DESC) < 0 ) {
    MESSAGE("Impossible d'ecrire la connectivit des triangles : ");
    return -1;
  }

  /* ecriture (optionnelle) des noms des triangles */
  if ( MEDnomEcr(fid, maa, nomtr3, ntr3, MED_MAILLE, MED_TRIA3) < 0 ) {
    MESSAGE("Impossible d'ecrire les noms des triangles : ");
    return -1;
  }
  
  /* ecriture (optionnelle) des numeros des triangles */
  if ( MEDnumEcr(fid,maa,numtr3,ntr3,MED_MAILLE,MED_TRIA3) < 0 ) {
    MESSAGE("Impossible d'ecrire les numros des triangles : ");
    return -1;
  }

  /* ecriture des numeros des familles des triangles */
  if ( MEDfamEcr(fid,maa,nufatr3,ntr3,MED_MAILLE,MED_TRIA3) < 0 ) {
    MESSAGE("Impossible d'ecrire les numros de famille des triangles : ");
    return -1;
  }

  /* fermeture du fichier */
  if ( MEDfermer(fid) < 0 ) {
    MESSAGE("Impossible de fermerle fichier : ");
    return -1;
  }

  return 0;
 
}



