/*************************************************************************
* COPYRIGHT (C) 1999 - 2007  EDF R&D, CEA/DEN
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/

#include <med.h>
#include <med_config.h>
#include <med_outils.h>

#include <string.h>
#include <stdlib.h>

med_err
MEDprofilEcr(med_idt fid,med_int *pflval,med_int n,char *profilname)
{
  med_idt gid, chid;
  med_size dimd[1];
  med_err ret=-1;
  char chemin[MED_TAILLE_PROFILS+1];
  med_mode_acces MED_MODE_ACCES;

  /*
   * On inhibe le gestionnaire d'erreur HDF 5
   */
  _MEDmodeErreurVerrouiller();

  if ( (MED_MODE_ACCES = _MEDmodeAcces(fid) ) == MED_UNDEF_MODE_ACCES ) {
    MESSAGE("Impossible de dterminer le mode d'acces au fichier ");
    goto ERROR;
  }

  /* 
   * Si le groupe "PROFILS" n'existe pas, on le cree
   */
  strncpy(chemin,MED_PROFILS,MED_TAILLE_PROFILS-1);
  chemin[MED_TAILLE_PROFILS-1] = '\0';
  if ((gid = _MEDdatagroupOuvrir(fid,chemin)) < 0)
    if ((gid = _MEDdatagroupCreer(fid,chemin)) < 0) {
      MESSAGE("Impossible de creer le groupe MED_PROFILS : ");
      SSCRUTE(chemin); goto ERROR;
    }

  /* 
   * Si le groupe "profilname" n'existe pas, on le cree
   * Sinon => erreur
   */
  NOFINALBLANK(profilname,ERROR);
  if ((chid = _MEDdatagroupOuvrir(gid,profilname)) >= 0) {
    if ( MED_MODE_ACCES != MED_LECTURE_ECRITURE ) {
      MESSAGE("Le profil existe dj : ");
      SSCRUTE(profilname); goto ERROR;
    }
  } else
    if ((chid = _MEDdatagroupCreer(gid,profilname)) < 0)
      goto ERROR;

  /*
   * On stocke "n" sous forme d'attribut
   */
  if ((ret = _MEDattrEntierEcrire(chid,MED_NOM_NBR,&n)) < 0) {
    MESSAGE("Erreur  l'criture de l'attribut MED_NOM_NBR : ");
    ISCRUTE(n); goto ERROR;
  };

  /*
   * On stocke le profil dans un dataset
   */
  dimd[0] = n;
#if defined(HAVE_F77INT64)
  ret =  _MEDdatasetNumEcrire(chid,MED_NOM_PFL,MED_INT64,MED_NO_INTERLACE,MED_DIM1,MED_ALL,MED_NOPF,MED_NO_PFLMOD,0,0,MED_NOPG,dimd,
			      (unsigned char*) pflval);
#else
  ret =  _MEDdatasetNumEcrire(chid,MED_NOM_PFL,MED_INT32,MED_NO_INTERLACE,MED_DIM1,MED_ALL,MED_NOPF,MED_NO_PFLMOD,0,0,MED_NOPG,dimd,
			      (unsigned char*) pflval);
#endif
  if (ret < 0 ) {
    MESSAGE("Impossible d'ecrire le dataset pflval de taille  : ");
    ISCRUTE(n); goto ERROR;
  }

  ret = 0;
 ERROR:
  /*
   * On ferme tout
   */
  if (chid>0)     if (_MEDdatagroupFermer(chid) < 0) {
    MESSAGE("Impossible de fermer le datagroup : ");
    ISCRUTE_id(chid); ret = -1;
  }

  if (gid>0)     if (_MEDdatagroupFermer(gid) < 0) {
    MESSAGE("Impossible de fermer le datagroup : ");
    ISCRUTE_id(gid); ret = -1;
  }

  return ret;
}




