/*************************************************************************
* COPYRIGHT (C) 1999 - 2007  EDF R&D, CEA/DEN
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/

#include <med.h>
#include <med_config.h>
#include <med_outils.h> 
#include <string.h>
 
#ifdef PPRO_NT
#define F_OK 0
#else
#include <unistd.h>
#endif

med_idt
MEDmonter(med_idt fid, const char *acces,med_type_donnee type)
{
  med_err ret;
  med_idt root,id, did;
  char chemin[MED_TAILLE_NOM+1];
  char acces_montage[2*MED_TAILLE_NOM+1];
  med_mode_acces MED_MODE_ACCES;

  /*
   * On inhibe le gestionnaire d'erreur HDF
   */
  _MEDmodeErreurVerrouiller();

  /*
   * On regarde si le fichier de nom "acces" existe
   * Si ce n'est pas le cas => erreur
   */
  if (access(acces,F_OK))
    return -1;

  if ( (MED_MODE_ACCES = _MEDmodeAcces(fid) ) == MED_UNDEF_MODE_ACCES ) {
    MESSAGE("Impossible de dterminer le mode d'acces au fichier ");
    return -1;
  }

  /*
   * On ouvre le fichier "acces" selon le mode d'acces MED_MODE_ACCES
   */
  if ((id = _MEDfichierOuvrir((char *)acces,MED_MODE_ACCES)) < 0)
    return -1;

  /* 
   * Si le point de montage n'existe pas dans le fichier local, on le cree
   */
  root = _MEDdatagroupOuvrir(fid,MED_MNT);
  if (root < 0)
    if ((root = _MEDdatagroupCreer(fid,MED_MNT)) < 0)
      return -1;
  if ((ret = _MEDdatagroupFermer(root)) < 0)
    return -1;

  /*
   * Montage du fichier (id) sur le point de montage local (fid)
   */
  strncpy(acces_montage,MED_MNT,strlen(MED_MNT)-1);
  acces_montage[strlen(MED_MNT)-1] = '\0';
  if ((ret = _MEDfichierMonter(fid,acces_montage,id)) < 0)
    return -1;

  /*
   * On cree un lien vers le point de montage
   * selon qu'on l'on veuille acceder aux champs
   * ou aux maillages du fichier "acces" que l'on vient
   * de monter sur le fichier local "fid"
   */
  switch(type) {

  case MED_MAILLAGE :
    strcpy(chemin,MED_MAA);
    break;

  case MED_CHAMP :
    strcpy(chemin,MED_CHA);
    break;

  default :
    return -1;
  }
  
  /* 
   * Creation du lien HDF vers le(s) champ(s) ou le(s) maillage(s) 
   * dans le fichier local :
   * - Si ce type de donnee existe deja en local => erreur
   * - Sinon on le cree le lien vers le point de montage
   */
  strcat(acces_montage,chemin);
  acces_montage[strlen(acces_montage)-1] = '\0';
  chemin[strlen(chemin)-1] = '\0';
  if ((ret = _MEDdatagroupLienCreer(fid,acces_montage,chemin)) < 0)
    return -1;

  /*
   * On renvoie l'ID du fichier "acces" que l'on vient de monter
   */
  return id;
}
