/*************************************************************************
* COPYRIGHT (C) 1999 - 2007  EDF R&D, CEA/DEN
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/

#include <med.h>
#include <med_config.h>
#include <med_outils.h>

#include <string.h>
#include <stdlib.h>

med_err
MEDdimEspaceCr(med_idt fid, char *maillage, med_int dim)
{
  med_idt maaid=0;
  med_err ret=-1;
  char chemin[MED_TAILLE_MAA+MED_TAILLE_NOM+1];
  med_int maadim;
  med_mode_acces MED_MODE_ACCES;

  /*
   * On inhibe le gestionnaire d'erreur
   */
  _MEDmodeErreurVerrouiller();

  if ( (MED_MODE_ACCES = _MEDmodeAcces(fid) ) == MED_UNDEF_MODE_ACCES ) {
    MESSAGE("Impossible de dterminer le mode d'acces au fichier.");
    goto ERROR;
  }

  if ( MED_MODE_ACCES == MED_LECTURE ) {
    MESSAGE("Impossible de crer un maillage en mode MED_LECTURE.");
    goto ERROR;
  };

  /*
   * On regarde si le groupe existe => erreur si non
   */
  strcpy(chemin,MED_MAA);
  strcat(chemin,maillage);  
  if ((maaid = _MEDdatagroupOuvrir(fid,chemin)) < 0) {
    MESSAGE("Erreur  l'ouverture du maillage : ");
    SSCRUTE(chemin);
    goto ERROR;
  }

  /*
   * On va lire l'attribut dimension du maillage et on controle 
   * la coherence
   */
  if ((ret = _MEDattrEntierLire(maaid,MED_NOM_DIM,&maadim)) < 0) {
    MESSAGE("Erreur  la lecture de la dimension du maillage : ");
    ISCRUTE(maadim);
    goto ERROR;
  }

  if (maadim > dim) {
    MESSAGE("La dimension de l'espace : ");
    ISCRUTE(dim);
    MESSAGE("doit tre suprieur  la dimension du maillage : ");
    ISCRUTE(maadim);
    goto ERROR;
  }

  /*
   * On ecrit la dimension de l'espace
   */
  if ((ret = _MEDattrEntierEcrire(maaid,MED_NOM_ESP,&dim)) < 0)  {
    MESSAGE("Erreur  l'criture de la dimension de l'espace : ");
    ISCRUTE(dim);
    goto ERROR;
  }

  /*
   * Fermetures des objets HDF 
   */
  ret = 0;
 ERROR:
  if (maaid>0)     if (_MEDdatagroupFermer(maaid) < 0) {
    MESSAGE("Impossible de fermer le datagroup : ");
    ISCRUTE_id(maaid);ret = -1; 
  }
  
  return ret;

}
