#include "preferences_dialog.h"
#include "application.h"
#include "xine_engine.h"

void PreferencesDialog::show()
{
	int response = 0;
	Application& application = Application::get_current();
	MainWindow& main_window = application.get_main_window();
	Glade& glade = application.get_glade();
	Configuration& configuration = application.get_configuration();
		
	String			recording_directory				= configuration.get_string_value("recording_directory");
	gint			record_extra_before				= configuration.get_int_value("record_extra_before");
	gint			record_extra_after				= configuration.get_int_value("record_extra_after");
	String			recording_type					= configuration.get_string_value("recording_type");
	gint			epg_span_hours					= configuration.get_int_value("epg_span_hours");
	gint			broadcast_port					= configuration.get_int_value("broadcast_port");
	String			epg_encoding					= configuration.get_string_value("epg_encoding");
	String			video_driver					= configuration.get_string_value("xine.video_driver");
	String			deinterlace_type				= configuration.get_string_value("xine.deinterlace_type");
	gboolean		start_minimised_in_tray			= configuration.get_boolean_value("start_minimised_in_tray");
	gboolean		always_on_top					= configuration.get_boolean_value("always_on_top");
	gboolean		fullscreen_workaround			= configuration.get_boolean_value("fullscreen_workaround");
	gboolean		pid_selection_workaround		= configuration.get_boolean_value("pid_selection_workaround");
	gboolean		sort_channels_alphabetically	= configuration.get_boolean_value("sort_channels_alphabetically");
	
	GtkWidget* dialog_preferences							= glade.get_widget("dialog_preferences");
	GtkWidget* filechooserbutton_recording_directory		= glade.get_widget("filechooserbutton_recording_directory");
	GtkWidget* spin_button_record_extra_before				= glade.get_widget("spin_button_record_extra_before");
	GtkWidget* spin_button_record_extra_after				= glade.get_widget("spin_button_record_extra_after");
	GtkWidget* combo_box_recording_type						= glade.get_widget("combo_box_recording_type");
	GtkWidget* spin_button_epg_span_hours					= glade.get_widget("spin_button_epg_span_hours");
	GtkWidget* spin_button_broadcast_port					= glade.get_widget("spin_button_broadcast_port");
	GtkWidget* combo_box_epg_encoding						= glade.get_widget("combo_box_epg_encoding");
	GtkWidget* combo_box_video_driver						= glade.get_widget("combo_box_video_driver");
	GtkWidget* combo_box_deinterlace_type					= glade.get_widget("combo_box_deinterlace_type");
	GtkWidget* check_button_start_minimised_in_tray			= glade.get_widget("check_button_start_minimised_in_tray");
	GtkWidget* check_button_always_on_top					= glade.get_widget("check_button_always_on_top");
	GtkWidget* check_button_fullscreen_workaround			= glade.get_widget("check_button_fullscreen_workaround");
	GtkWidget* check_button_pid_selection_workaround		= glade.get_widget("check_button_pid_selection_workaround");
	GtkWidget* check_button_sort_channels_alphabetically	= glade.get_widget("check_button_sort_channels_alphabetically");
	
	gtk_file_chooser_set_current_folder(GTK_FILE_CHOOSER(filechooserbutton_recording_directory), recording_directory.c_str());
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(spin_button_record_extra_before), record_extra_before);
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(spin_button_record_extra_after), record_extra_after);
	gtk_combo_box_set_active(GTK_COMBO_BOX(combo_box_recording_type), (recording_type == "ts") ? 0 : 1);	
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(spin_button_epg_span_hours), epg_span_hours);
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(spin_button_broadcast_port), broadcast_port);
	gtk_combo_box_set_active(GTK_COMBO_BOX(combo_box_epg_encoding), (epg_encoding == "auto") ? 0 : 1);
	gtk_combo_box_set_active(GTK_COMBO_BOX(combo_box_video_driver), (video_driver == "auto") ? 0 : 1);
	gtk_combo_box_set_active(GTK_COMBO_BOX(combo_box_deinterlace_type),
		(deinterlace_type == "default") ? 0 : ((deinterlace_type == "tvtime") ? 1 : 2));
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_button_start_minimised_in_tray), start_minimised_in_tray);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_button_always_on_top), always_on_top);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_button_fullscreen_workaround), fullscreen_workaround);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_button_pid_selection_workaround), pid_selection_workaround);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_button_sort_channels_alphabetically), sort_channels_alphabetically);

	gboolean was_fullscreen = main_window.get_is_fullscreen();

	if (fullscreen_workaround && was_fullscreen)
	{
		main_window.maximise();
		main_window.show_fullscreen(false);
	}
	
	response = gtk_dialog_run(GTK_DIALOG(dialog_preferences));
	gtk_widget_hide(GTK_WIDGET(dialog_preferences));
	
	if (fullscreen_workaround && was_fullscreen)
	{
		main_window.show_fullscreen(true);
	}
	
	if (response == 1)
	{
		recording_directory				= gtk_file_chooser_get_current_folder(GTK_FILE_CHOOSER(filechooserbutton_recording_directory));
		record_extra_before				= (gint)gtk_spin_button_get_value(GTK_SPIN_BUTTON(spin_button_record_extra_before));
		record_extra_after				= (gint)gtk_spin_button_get_value(GTK_SPIN_BUTTON(spin_button_record_extra_after));
		gint recording_type_index		= gtk_combo_box_get_active(GTK_COMBO_BOX(combo_box_recording_type));
		epg_span_hours					= (gint)gtk_spin_button_get_value(GTK_SPIN_BUTTON(spin_button_epg_span_hours));
		broadcast_port					= (gint)gtk_spin_button_get_value(GTK_SPIN_BUTTON(spin_button_broadcast_port));
		gint epg_encoding_index			= gtk_combo_box_get_active(GTK_COMBO_BOX(combo_box_epg_encoding));
		gint video_driver_index			= gtk_combo_box_get_active(GTK_COMBO_BOX(combo_box_video_driver));
		gint deinterlace_type_index		= gtk_combo_box_get_active(GTK_COMBO_BOX(combo_box_deinterlace_type));
		start_minimised_in_tray			= gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_button_start_minimised_in_tray));
		always_on_top					= gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_button_always_on_top));
		fullscreen_workaround			= gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_button_fullscreen_workaround));
		pid_selection_workaround		= gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_button_pid_selection_workaround));
		sort_channels_alphabetically	= gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_button_sort_channels_alphabetically));

		configuration.set_string_value("recording_directory", recording_directory);
		configuration.set_int_value("record_extra_before", record_extra_before);
		configuration.set_int_value("record_extra_after", record_extra_after);
		configuration.set_string_value("recording_type", recording_type_index == 0 ? "ts" : "ps");
		configuration.set_int_value("epg_span_hours", epg_span_hours);
		configuration.set_int_value("broadcast_port", broadcast_port);
		configuration.set_string_value("epg_encoding", epg_encoding_index == 0 ? "auto" : "iso6937");
		configuration.set_string_value("xine.video_driver", video_driver_index == 0 ? "auto" : "xshm");
		configuration.set_string_value("xine.deinterlace_type",
			deinterlace_type_index == 0 ? "default" : (deinterlace_type_index == 1 ? "tvtime" : "none"));
		configuration.set_boolean_value("start_minimised_in_tray", start_minimised_in_tray);
		configuration.set_boolean_value("always_on_top", always_on_top);
		configuration.set_boolean_value("fullscreen_workaround", fullscreen_workaround);
		configuration.set_boolean_value("pid_selection_workaround", pid_selection_workaround);
		configuration.set_boolean_value("sort_channels_alphabetically", sort_channels_alphabetically);
	}
}
