/*
 * Copyright (C) 2008 Michael Lamothe
 *
 * This file is part of Me TV
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */

#ifndef __SCHEDULED_RECORDING_DIALOG_H__
#define __SCHEDULED_RECORDING_DIALOG_H__

#include "scheduled_recording.h"
#include <libgnomeui/libgnomeui.h>

class ScheduledRecordingDialog
{
private:
	GtkWidget*		dialog_scheduled_recording;
	GtkEntry*		entry_description;
	GtkComboBox*	combo_box_channel;
	GtkComboBox*	combo_box_record_type;
	GtkComboBox*	combo_box_start_day;
	GnomeDateEdit*	date_edit_start_date;
	GtkSpinButton*	spinbutton_start_time_hour;
	GtkSpinButton*	spinbutton_start_time_minute;
	GtkSpinButton*	spinbutton_duration;
	
public:
	ScheduledRecordingDialog();
	void show();
	void show(ScheduledRecording& scheduled_recording);
};

#endif
