/*
 * Copyright (C) 2008 Michael Lamothe
 *
 * This file is part of Me TV
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */
 
#ifndef __CHANNEL_H__
#define __CHANNEL_H__

#include <linux/dvb/frontend.h>
#include "string.hh"
#include "transponder.h"
#include <vector>

#define SWITCHFREQ		11700000
#define LOF_HI			10600000
#define LOF_LO			9750000
#define HIGH_BAND(f)	((f)>=SWITCHFREQ) ? true : false

class Transponder;

class Channel
{
private:
	Transponder& transponder;
public:
	Channel(Transponder& transponder);
		
	String							name;
	unsigned int					service_id;
	unsigned int					default_video_pid;
	unsigned int					default_audio_pid;
	unsigned int					default_subtitle_pid;
	std::vector<int>				audio_pids;
	std::vector<int>				subtitle_pids;
	
	Transponder& get_transponder() { return transponder; }
	
	gboolean operator ==(const Channel& channel) const;
	gboolean operator !=(const Channel& channel) const;
};

#endif
