#!/bin/sh

# --------------------------------------------------------
# Copyright (C) Martin Ošmera <martin.osmera@gmail.com>
# Licence: GPL
# Version: 1.3.0
# Homepage: http://mcu8051ide.sf.net
# --------------------------------------------------------
#
# Installation script for MCU 8051 IDE
# Usage:
#	./install [--help | --uninstall]
#	./install --no-check
# --------------------------------------------------------


echo "+--------------------------------------------------+"
echo "| IMPORTANT NOTICE:                                |"
echo "|                                                  |"
echo "| This installation method is deprecated and will  |"
echo "| be removed in future versions !                  |"
echo "| Use 'cmake . && make && make install' instead.   |"
echo "+--------------------------------------------------+"

if [ $UID -ne 0 ]; then
	echo "You must have root privileges in order to perform installation"
	exit 1
fi

check_for_library() {
	echo -n "Checking for ${1} ..."
	if ./test-lib.sh ${1} ${2} >> /dev/null; then
		echo "Ok"
	else
		echo "FAILED"
		echo
		echo "Please install the missing library or:"
		echo "\$ ./install.sh --no-check"
		echo "\$ mcu8051ide --check-libraries"
		echo "and see exactly what is missing"
		exit 1
	fi
}

if [ "${1}" = "--help" ] || [ "${1}" = "-h" ]; then
	echo "Installation script for MCU 8051 IDE"
	echo "	Installation:"
	echo "		./install.sh"
	echo "	Installation without checking for libraries:"
	echo "		./install.sh --no-check"
	echo "	Uninstallation:"
	echo "		./install.sh --uninstall"
	echo ""
	exit
fi

if [ "${1}" = "--uninstall" ]; then
	echo "Uninstalling MCU 8051 IDE"
	rm -rfv /usr/share/mcu8051ide || exit 1
	rm -fv /usr/bin/mcu8051ide || exit 1
	rm -fv /usr/share/man/man1/mcu8051ide.1.gz
	echo "Uninstallation successful"
	exit
fi

echo "Installing MCU 8051 IDE"
echo

if [ "${1}" != "--no-check" ]; then
	check_for_library BWidget	1.8.0
	check_for_library Itcl		3.4
	check_for_library Tcl		8.2
	check_for_library md5		2.0
	check_for_library Tk		8.5
	check_for_library img::png	1.3
	check_for_library tdom		0.8
	check_for_library Tclx		8.4
fi

echo "Creating launcher"
./make-launcher --path-to-lib=/usr/share/mcu8051ide/lib || exit 1

echo "Creating destination directory: /usr/share/mcu8051ide"
mkdir -p /usr/share/mcu8051ide || exit 1

echo "Copying files"
cp -prv ./{demo,doc,lib,icons,data,translations} /usr/share/mcu8051ide || exit 1

echo "Copying manual page"
cp -pv ./doc/man/mcu8051ide.1.gz /usr/share/man/man1/mcu8051ide.1.gz

echo "Copying .desktop spec and application icon"
mkdir -p /usr/share/applications
mkdir -p /usr/share/pixmaps
cp -pv ./mcu8051ide.png /usr/share/pixmaps/mcu8051ide.png
cp -pv ./mcu8051ide.desktop /usr/share/applications/mcu8051ide.desktop

echo "Copying launcher"
cp -prv mcu8051ide /usr/bin || exit 1

echo
echo "Installation successful"
