""" An example plugin. """


# Enthought library imports.
from enthought.envisage.api import Plugin

# Acme imports.
from enthought.envisage.examples.misc.bar import Bar
from enthought.envisage.examples.misc.baz import Baz
from enthought.envisage.examples.misc.foo import Foo


class AcmePlugin(Plugin):
    """ An example plugin. """

    # fixme: At some point service interfaces should be real interfaces of some
    # kind.  It could be traits, CORBA IDL, whatever!
    INAMING_SERVICE = 'enthought.envisage.core.INamingService'
    ITYPE_MANAGER   = 'enthought.envisage.core.ITypeManager'
    
    ###########################################################################
    # 'Plugin' interface.
    ###########################################################################

    def start(self, application):
        """ Starts the plugin. """

        print 'Starting example plugin'

        # Get a reference to the naming service.
        naming_service = self.get_service(self.INAMING_SERVICE)
        print 'Naming service', naming_service
        
        # Get a reference to the type manager service.
        type_manager = self.get_service(self.ITYPE_MANAGER)
        print 'Type manager', type_manager

        # Create a Foo.
        f = Foo(name='fred')
        f.foo()

        # Adapt the Foo to be a Foo.
        print 'Adapt to Foo!'
        g = type_manager.object_as(f, Foo)
        g.foo()
        
        # Adapt the Foo to be a Bar.
        print 'Adapt to Bar!'
        b = type_manager.object_as(f, Bar)
        b.bar()

        # Adapt the Foo to be a Baz.
        b = type_manager.object_as(f, Baz)
        print 'baz', b

        # Try a method on the 'FooCategory' interface.
        f.blargle()
        
        return

    def stop(self, application):
        """ Stops the plugin. """

        print 'Stopping example plugin'

        return

#### EOF ######################################################################
